/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.system;

import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.nds.NDSAttributeDefinition;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSObjectAttribute;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.application.console.snapin.DefaultObjectEntryCollection;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryCollection;
import com.novell.application.console.snapin.Shell;
import com.novell.application.console.snapin.SnapinVetoException;
import com.novell.netmessenger.admin.common.BaseDlg;
import com.novell.netmessenger.admin.swingext.JCheckBoxExt;
import com.novell.netmessenger.admin.system.NNMSystemResource;
import com.novell.utility.nmsgbox.NMsgBox;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class NNMSystemCreateDlg
extends BaseDlg {
    private JTextField m_tfCN;
    private JCheckBoxExt m_cbProperties;
    private NDSNamespace m_ndsNamespace;
    private ObjectEntry m_parentObjectEntry;

    public NNMSystemCreateDlg(Shell shell, ObjectEntry objectEntry) {
        super((Frame)shell.getShellFrame(), NNMSystemResource.get("SystemCreateTitle"), true, "systemcreate");
        this.m_ndsNamespace = (NDSNamespace)this.m_shell.getNamespaceSnapin(NDSNamespace.name);
        this.m_parentObjectEntry = objectEntry;
    }

    public void layoutControls() {
        JLabel jLabel = new JLabel(NNMSystemResource.get("SystemCreateOU"));
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.m_tfCN = new JTextField(30);
        this.m_tfCN.addActionListener(this);
        this.m_cbProperties = new JCheckBoxExt(NNMSystemResource.get("CreateAdditionalProperties"));
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.m_tfCN, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this.m_cbProperties, gridBagConstraints);
        this.getContentPane().add((Component)jPanel, "North");
        super.layoutControls();
        this.setModal(true);
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_tfCN) {
            this.okButtonAction();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    protected void okButtonAction() {
        String string = this.m_tfCN.getText().trim();
        if (!string.equalsIgnoreCase("") && string != null) {
            try {
                ValueComponent[] valueComponentArray = new ValueComponent[]{NDSSyntax.SYN_CLASS_NAME.createValueComponent((Object)"nnmSystem")};
                NDSObjectAttribute nDSObjectAttribute = new NDSObjectAttribute((AttributeDefinition)((NDSAttributeDefinition)this.m_ndsNamespace.getAttributeDefinition(this.m_parentObjectEntry, "Object Class")), valueComponentArray);
                valueComponentArray[0] = NDSSyntax.SYN_CI_STRING.createValueComponent((Object)string);
                NDSObjectAttribute nDSObjectAttribute2 = new NDSObjectAttribute((AttributeDefinition)((NDSAttributeDefinition)this.m_ndsNamespace.getAttributeDefinition(this.m_parentObjectEntry, "OU")), valueComponentArray);
                valueComponentArray[0] = NDSSyntax.SYN_CI_STRING.createValueComponent((Object)"1.0");
                NDSObjectAttribute nDSObjectAttribute3 = new NDSObjectAttribute((AttributeDefinition)((NDSAttributeDefinition)this.m_ndsNamespace.getAttributeDefinition(this.m_parentObjectEntry, "nnmVersion")), valueComponentArray);
                if (this.m_ndsNamespace.doesExist(this.m_parentObjectEntry, string)) {
                    NMsgBox nMsgBox = new NMsgBox((Component)this, NNMSystemResource.get("SystemCreateDuplicateTitle"), NNMSystemResource.get("SystemCreateDuplicate"), 3);
                    nMsgBox.launch();
                    this.m_tfCN.requestFocus();
                    this.m_tfCN.selectAll();
                    return;
                }
                Vector<NDSObjectAttribute> vector = new Vector<NDSObjectAttribute>();
                vector.addElement(nDSObjectAttribute);
                vector.addElement(nDSObjectAttribute2);
                vector.addElement(nDSObjectAttribute3);
                ObjectEntry objectEntry = this.m_ndsNamespace.createObjectEntry(this.m_parentObjectEntry, string, "nnmSystem");
                NSObject nSObject = this.m_ndsNamespace.createNSObject(objectEntry, vector);
                this.m_ndsNamespace.create(nSObject);
                if (this.m_cbProperties.isSelected()) {
                    this.m_shell.showDetails((ObjectEntryCollection)new DefaultObjectEntryCollection(objectEntry), false);
                }
                this.dispose();
            }
            catch (NamespaceException namespaceException) {
                NMsgBox nMsgBox = new NMsgBox((Component)this, NNMSystemResource.get("SystemCreateInvalidNameTitle"), NNMSystemResource.get("SystemCreateInvalidName"), 3);
                nMsgBox.launch();
                this.m_tfCN.requestFocus();
                this.m_tfCN.selectAll();
                return;
            }
            catch (SnapinVetoException snapinVetoException) {
                return;
            }
            catch (Exception exception) {
                return;
            }
            this.m_shell.refreshCurrentTreeSelection();
            return;
        }
        NMsgBox nMsgBox = new NMsgBox((Component)this, NNMSystemResource.get("SystemCreateNoNameTitle"), NNMSystemResource.get("SystemCreateNoName"), 3);
        nMsgBox.launch();
        this.m_tfCN.requestFocus();
    }

    protected void cancelButtonAction() {
        this.dispose();
    }
}

