/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.system;

import com.novell.admin.ns.NSObject;
import com.novell.netmessenger.admin.common.NDSNegotiator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class NNMSystemNSObject {
    public static final int I_DEFAULT_ARCHIVE_TYPE = 0;
    public static final int I_DEFAULT_ARCHIVE_DELAY = 2;
    public static final int I_DEFAULT_ARCHIVE_EXPIRE = 90;
    public static final int I_DEFAULT_ARCHIVE_SESSION_TIMEOUT = 5;
    public static final int I_DEFAULT_ARCHIVE_INTERVAL = 4;
    public static final int I_DEFAULT_GRACE_LOGINS = 5;
    public static final int I_SYSTEM_HOST_LIST = 0;
    public static final int I_SYSTEM_SESSION_BROKER_PRIMARY = 1;
    public static final int I_SYSTEM_SCOPE_PROFILE = 2;
    public static final int I_SYSTEM_POLICY_DN = 3;
    public static final int I_SYSTEM_LDAP_PROFILE = 4;
    public static final int I_SYSTEM_SECURE_REQUIRED = 5;
    public static final int I_SYSTEM_ARCHIVE_TYPE = 6;
    public static final int I_SYSTEM_ARCHIVE_MASTER = 7;
    public static final int I_SYSTEM_ARCHIVE_LIST = 8;
    public static final int I_SYSTEM_ARCHIVE_PASS_PHRASE = 9;
    public static final int I_SYSTEM_ARCHIVE_ACL = 10;
    public static final int I_SYSTEM_ARCHIVE_EXT_ACL = 11;
    public static final int I_SYSTEM_ARCHIVE_DELAY = 12;
    public static final int I_SYSTEM_ARCHIVE_INTERVAL = 13;
    public static final int I_SYSTEM_ARCHIVE_EXPIRE = 14;
    public static final int I_SYSTEM_ARCHIVE_SESSION_TIMEOUT = 15;
    public static final int I_SYSTEM_SOFTWARE_DESCRIPTION = 16;
    public static final int I_SYSTEM_CLIENT_VERSION = 17;
    public static final int I_SYSTEM_CLIENT_DATE = 18;
    public static final int I_SYSTEM_CLIENT_GRACE_LOGINS = 19;
    public static final int I_SYSTEM_CLIENT_DOWNLOAD = 20;
    public static final int I_SYSTEM_CLIENT_DOWNLOAD_URLS = 21;
    public static final int I_SYSTEM_VERSION = 22;
    public static final int I_SYSTEM_CONFERENCING_SETTINGS = 23;
    private static final long I_MASK_HOST_LIST = 1L;
    private static final long I_MASK_SESSION_BROKER_PRIMARY = 2L;
    private static final long I_MASK_SCOPE_PROFILE = 4L;
    private static final long I_MASK_POLICY_DN = 8L;
    private static final long I_MASK_LDAP_PROFILE = 16L;
    private static final long I_MASK_SECURE_REQUIRED = 32L;
    private static final long I_MASK_ARCHIVE_TYPE = 64L;
    private static final long I_MASK_ARCHIVE_MASTER = 128L;
    private static final long I_MASK_ARCHIVE_LIST = 256L;
    private static final long I_MASK_ARCHIVE_PASS_PHRASE = 512L;
    private static final long I_MASK_ARCHIVE_ACL = 1024L;
    private static final long I_MASK_ARCHIVE_EXT_ACL = 2048L;
    private static final long I_MASK_ARCHIVE_DELAY = 4096L;
    private static final long I_MASK_ARCHIVE_INTERVAL = 8192L;
    private static final long I_MASK_ARCHIVE_EXPIRE = 16384L;
    private static final long I_MASK_ARCHIVE_SESSION_TIMEOUT = 32768L;
    private static final long I_MASK_SOFTWARE_DESCRIPTION = 65536L;
    private static final long I_MASK_CLIENT_VERSION = 131072L;
    private static final long I_MASK_CLIENT_DATE = 262144L;
    private static final long I_MASK_CLIENT_GRACE_LOGINS = 524288L;
    private static final long I_MASK_CLIENT_DOWNLOAD = 0x100000L;
    private static final long I_MASK_CLIENT_DOWNLOAD_URLS = 0x200000L;
    private static final long I_MASK_CONFERENCING_SETTINGS = 0x800000L;
    public static final String[] SA_SYSTEM_ATTRIBUTES = new String[]{"nnmHostList", "nnmPrimaryBroker", "nnmScopeProfileDN", "nnmPolicyDN", "nnmLDAPProfileDN", "nnmSecureRequired", "nnmArchiveType", "nnmArchiveMaster", "nnmArchiveList", "nnmArchivePassphrase", "nnmArchiveACL", "nnmArchiveExtACL", "nnmArchiveDelay", "nnmArchiveInterval", "nnmArchiveExpire", "nnmArchiveSessionTimeout", "nnmSoftwareDescription", "nnmClientVersion", "nnmClientDate", "nnmClientGraceLogins", "nnmClientDownload", "nnmClientDownloadList", "nnmVersion", "nnmConferencingSettings"};
    private long I_DIRTY_BITS;
    private int m_iArchiveType;
    private int m_iArchiveDelay;
    private int m_iArchiveInterval;
    private int m_iArchiveExpire;
    private int m_iArchiveSessionTimeout;
    private int m_iClientGraceLogins;
    private boolean m_bSecureRequired;
    private boolean m_bClientDownloadBrowser;
    private boolean m_bClientAutoUpdate;
    private String m_sSessionBrokerPrimary;
    private String m_sScopeProfile;
    private String m_sPolicyDN;
    private String m_sLDAPProfile;
    private String m_sArchiveMaster;
    private String m_sArchivePassphrase;
    private String m_sSoftwareDescription;
    private String m_sClientVersion;
    private String m_sClientDate;
    private Vector m_vHostList;
    private Vector m_vArchiveList;
    private Vector m_vArchiveACL;
    private Vector m_vArchiveExtACL;
    private Vector m_vClientDownloadURLs;
    private Hashtable m_htConferencingSettings;

    public void setSessionBrokerPrimary(String string) {
        this.m_sSessionBrokerPrimary = string;
        this.I_DIRTY_BITS |= 2L;
    }

    public String getSessionBrokerPrimary() {
        return this.m_sSessionBrokerPrimary;
    }

    public void setScopeProfile(String string) {
        this.m_sScopeProfile = string;
        this.I_DIRTY_BITS |= 4L;
    }

    public String getScopeProfile() {
        return this.m_sScopeProfile;
    }

    public void setPolicyDN(String string) {
        this.m_sPolicyDN = string;
        this.I_DIRTY_BITS |= 8L;
    }

    public String getPolicyDN() {
        return this.m_sPolicyDN;
    }

    public void setLDAPProfile(String string) {
        this.m_sLDAPProfile = string;
        this.I_DIRTY_BITS |= 0x10L;
    }

    public String getLDAPProfile() {
        return this.m_sLDAPProfile;
    }

    public void setArchiveType(int n) {
        this.m_iArchiveType = n;
        this.I_DIRTY_BITS |= 0x40L;
    }

    public int getArchiveType() {
        return this.m_iArchiveType;
    }

    public void setArchiveMaster(String string) {
        this.m_sArchiveMaster = string;
        this.I_DIRTY_BITS |= 0x80L;
    }

    public String getArchiveMaster() {
        return this.m_sArchiveMaster;
    }

    public void setArchivePassphrase(String string) {
        this.m_sArchivePassphrase = string;
        this.I_DIRTY_BITS |= 0x200L;
    }

    public String getArchivePassphrase() {
        return this.m_sArchivePassphrase;
    }

    public void setSoftwareDescription(String string) {
        this.m_sSoftwareDescription = string;
        this.I_DIRTY_BITS |= 0x10000L;
    }

    public String getSoftwareDescription() {
        return this.m_sSoftwareDescription;
    }

    public void setClientVersion(String string) {
        this.m_sClientVersion = string;
        this.I_DIRTY_BITS |= 0x20000L;
    }

    public String getClientVersion() {
        return this.m_sClientVersion;
    }

    public void setClientDate(String string) {
        this.m_sClientDate = string;
        this.I_DIRTY_BITS |= 0x40000L;
    }

    public String getClientDate() {
        return this.m_sClientDate;
    }

    public void setArchiveDelay(int n) {
        this.m_iArchiveDelay = n;
        this.I_DIRTY_BITS |= 0x1000L;
    }

    public int getArchiveDelay() {
        return this.m_iArchiveDelay;
    }

    public void setArchiveInterval(int n) {
        this.m_iArchiveInterval = n;
        this.I_DIRTY_BITS |= 0x2000L;
    }

    public int getArchiveInterval() {
        return this.m_iArchiveInterval;
    }

    public void setArchiveExpire(int n) {
        this.m_iArchiveExpire = n;
        this.I_DIRTY_BITS |= 0x4000L;
    }

    public int getArchiveExpire() {
        return this.m_iArchiveExpire;
    }

    public void setArchiveSessionTimeout(int n) {
        this.m_iArchiveSessionTimeout = n;
        this.I_DIRTY_BITS |= 0x8000L;
    }

    public int getArchiveSessionTimeout() {
        return this.m_iArchiveSessionTimeout;
    }

    public void setClientGraceLogins(int n) {
        this.m_iClientGraceLogins = n;
        this.I_DIRTY_BITS |= 0x80000L;
    }

    public int getClientGraceLogins() {
        return this.m_iClientGraceLogins;
    }

    public void setSecureRequired(boolean bl) {
        this.m_bSecureRequired = bl;
        this.I_DIRTY_BITS |= 0x20L;
    }

    public boolean getSecureRequired() {
        return this.m_bSecureRequired;
    }

    public void setClientDownload(boolean bl) {
        this.m_bClientDownloadBrowser = bl;
        this.I_DIRTY_BITS |= 0x100000L;
    }

    public boolean getClientDownload() {
        return this.m_bClientDownloadBrowser;
    }

    public void setClientAutoUpdate(boolean bl) {
        this.m_bClientAutoUpdate = bl;
        this.I_DIRTY_BITS |= 0x100000L;
    }

    public boolean getClientAutoUpdate() {
        return this.m_bClientAutoUpdate;
    }

    public void setHostList(Vector vector) {
        this.m_vHostList = vector;
        this.I_DIRTY_BITS |= 1L;
    }

    public Vector getHostList() {
        return this.m_vHostList;
    }

    public void setArchiveList(Vector vector) {
        this.m_vArchiveList = vector;
        this.I_DIRTY_BITS |= 0x100L;
    }

    public Vector getArchiveList() {
        return this.m_vArchiveList;
    }

    public void setArchiveACL(Vector vector) {
        this.m_vArchiveACL = vector;
        this.I_DIRTY_BITS |= 0x400L;
    }

    public Vector getArchiveACL() {
        return this.m_vArchiveACL;
    }

    public void setArchiveExtACL(Vector vector) {
        this.m_vArchiveExtACL = vector;
        this.I_DIRTY_BITS |= 0x800L;
    }

    public Vector getArchiveExtACL() {
        return this.m_vArchiveExtACL;
    }

    public void setClientDownloadURLs(Vector vector) {
        this.m_vClientDownloadURLs = vector;
        this.I_DIRTY_BITS |= 0x200000L;
    }

    public Vector getClientDownloadURLs() {
        return this.m_vClientDownloadURLs;
    }

    public String getConferencingSetting(String string) {
        return (String)this.m_htConferencingSettings.get(string);
    }

    public void setConferencingSetting(String string, String string2) {
        this.m_htConferencingSettings.put(string, string2);
        this.I_DIRTY_BITS |= 0x800000L;
    }

    public Vector getConferencingSettings() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.m_htConferencingSettings.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.m_htConferencingSettings.get(string);
            vector.add(string + ";" + string2);
        }
        return vector;
    }

    public void setConferencingSettings(Vector vector) {
        this.m_htConferencingSettings = new Hashtable();
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            int n = string.indexOf(";");
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1, string.length());
            this.m_htConferencingSettings.put(string2, string3);
        }
        this.I_DIRTY_BITS |= 0x800000L;
    }

    protected boolean load(NSObject nSObject) {
        int n;
        boolean bl;
        boolean bl2;
        NDSNegotiator nDSNegotiator = new NDSNegotiator();
        this.setScopeProfile(nDSNegotiator.getAttribute(nSObject, SA_SYSTEM_ATTRIBUTES[2]));
        this.setPolicyDN(nDSNegotiator.getAttribute(nSObject, SA_SYSTEM_ATTRIBUTES[3]));
        this.setLDAPProfile(nDSNegotiator.getAttribute(nSObject, SA_SYSTEM_ATTRIBUTES[4]));
        this.setArchiveMaster(nDSNegotiator.getAttribute(nSObject, SA_SYSTEM_ATTRIBUTES[7]));
        this.setArchivePassphrase(nDSNegotiator.getAttribute(nSObject, SA_SYSTEM_ATTRIBUTES[9]));
        this.setSoftwareDescription(nDSNegotiator.getAttribute(nSObject, SA_SYSTEM_ATTRIBUTES[16]));
        this.setClientVersion(nDSNegotiator.getAttribute(nSObject, SA_SYSTEM_ATTRIBUTES[17]));
        this.setClientDate(nDSNegotiator.getAttribute(nSObject, SA_SYSTEM_ATTRIBUTES[18]));
        String string = nDSNegotiator.getAttribute(nSObject, SA_SYSTEM_ATTRIBUTES[5]);
        boolean bl3 = string != null && string.equals("1");
        this.setSecureRequired(bl3);
        string = nDSNegotiator.getAttribute(nSObject, SA_SYSTEM_ATTRIBUTES[20]);
        if (string == null) {
            bl2 = false;
            bl = false;
        } else if (string.equals("0")) {
            bl2 = false;
            bl = false;
        } else if (string.equals("1")) {
            bl2 = true;
            bl = false;
        } else if (string.equals("2")) {
            bl2 = false;
            bl = true;
        } else {
            bl2 = true;
            bl = true;
        }
        this.setClientDownload(bl2);
        this.setClientAutoUpdate(bl);
        try {
            n = Integer.parseInt(nDSNegotiator.getAttribute(nSObject, SA_SYSTEM_ATTRIBUTES[6]));
        }
        catch (Exception exception) {
            n = 0;
        }
        this.setArchiveType(n);
        try {
            n = Integer.parseInt(nDSNegotiator.getAttribute(nSObject, SA_SYSTEM_ATTRIBUTES[12]));
        }
        catch (Exception exception) {
            n = 2;
        }
        this.setArchiveDelay(n);
        try {
            n = Integer.parseInt(nDSNegotiator.getAttribute(nSObject, SA_SYSTEM_ATTRIBUTES[13]));
        }
        catch (Exception exception) {
            n = 4;
        }
        this.setArchiveInterval(n);
        try {
            n = Integer.parseInt(nDSNegotiator.getAttribute(nSObject, SA_SYSTEM_ATTRIBUTES[14]));
        }
        catch (Exception exception) {
            n = 90;
        }
        this.setArchiveExpire(n);
        try {
            n = Integer.parseInt(nDSNegotiator.getAttribute(nSObject, SA_SYSTEM_ATTRIBUTES[15]));
        }
        catch (Exception exception) {
            n = 5;
        }
        this.setArchiveSessionTimeout(n);
        try {
            n = Integer.parseInt(nDSNegotiator.getAttribute(nSObject, SA_SYSTEM_ATTRIBUTES[19]));
        }
        catch (Exception exception) {
            n = 0;
        }
        this.setClientGraceLogins(n);
        this.setHostList(nDSNegotiator.getMultiValuedAttribute(nSObject, SA_SYSTEM_ATTRIBUTES[0]));
        this.setArchiveList(nDSNegotiator.getMultiValuedAttribute(nSObject, SA_SYSTEM_ATTRIBUTES[8]));
        this.setArchiveACL(nDSNegotiator.getMultiValuedAttribute(nSObject, SA_SYSTEM_ATTRIBUTES[10]));
        this.setArchiveExtACL(nDSNegotiator.getMultiValuedAttribute(nSObject, SA_SYSTEM_ATTRIBUTES[11]));
        this.setClientDownloadURLs(nDSNegotiator.getMultiValuedAttribute(nSObject, SA_SYSTEM_ATTRIBUTES[21]));
        this.setConferencingSettings(nDSNegotiator.getMultiValuedAttribute(nSObject, SA_SYSTEM_ATTRIBUTES[23]));
        this.I_DIRTY_BITS = 0L;
        return true;
    }

    protected boolean save(NSObject nSObject) {
        String string;
        boolean bl = false;
        NDSNegotiator nDSNegotiator = new NDSNegotiator();
        if ((this.I_DIRTY_BITS & 2L) != 0L) {
            // empty if block
        }
        if ((this.I_DIRTY_BITS & 4L) != 0L) {
            nDSNegotiator.setAttribute(nSObject, SA_SYSTEM_ATTRIBUTES[2], this.getScopeProfile());
        }
        if ((this.I_DIRTY_BITS & 8L) != 0L) {
            nDSNegotiator.setAttribute(nSObject, SA_SYSTEM_ATTRIBUTES[3], this.getPolicyDN());
        }
        if ((this.I_DIRTY_BITS & 0x10L) != 0L) {
            nDSNegotiator.setAttribute(nSObject, SA_SYSTEM_ATTRIBUTES[4], this.getLDAPProfile());
        }
        if ((this.I_DIRTY_BITS & 0x80L) != 0L) {
            nDSNegotiator.setAttribute(nSObject, SA_SYSTEM_ATTRIBUTES[7], this.getArchiveMaster());
        }
        if ((this.I_DIRTY_BITS & 0x200L) != 0L) {
            nDSNegotiator.setAttribute(nSObject, SA_SYSTEM_ATTRIBUTES[9], this.getArchivePassphrase());
        }
        if ((this.I_DIRTY_BITS & 0x10000L) != 0L) {
            nDSNegotiator.setAttribute(nSObject, SA_SYSTEM_ATTRIBUTES[16], this.getSoftwareDescription());
        }
        if ((this.I_DIRTY_BITS & 0x40000L) != 0L) {
            nDSNegotiator.setAttribute(nSObject, SA_SYSTEM_ATTRIBUTES[18], this.getClientDate());
        }
        if ((this.I_DIRTY_BITS & 0x20000L) != 0L) {
            nDSNegotiator.setAttribute(nSObject, SA_SYSTEM_ATTRIBUTES[17], this.getClientVersion());
        }
        if ((this.I_DIRTY_BITS & 0x20L) != 0L) {
            String string2 = this.getSecureRequired() ? "1" : "0";
            nDSNegotiator.setAttribute(nSObject, SA_SYSTEM_ATTRIBUTES[5], string2);
        }
        if ((this.I_DIRTY_BITS & 0x100000L) != 0L) {
            boolean bl2 = this.getClientDownload();
            boolean bl3 = this.getClientAutoUpdate();
            String string3 = !bl2 && !bl3 ? "0" : (bl2 && !bl3 ? "1" : (!bl2 && bl3 ? "2" : "3"));
            nDSNegotiator.setAttribute(nSObject, SA_SYSTEM_ATTRIBUTES[20], string3);
        }
        if ((this.I_DIRTY_BITS & 0x40L) != 0L) {
            string = String.valueOf(this.getArchiveType());
            nDSNegotiator.setAttribute(nSObject, SA_SYSTEM_ATTRIBUTES[6], string);
        }
        if ((this.I_DIRTY_BITS & 0x80000L) != 0L) {
            string = String.valueOf(this.getClientGraceLogins());
            nDSNegotiator.setAttribute(nSObject, SA_SYSTEM_ATTRIBUTES[19], string);
        }
        if ((this.I_DIRTY_BITS & 0x1000L) != 0L) {
            string = String.valueOf(this.getArchiveDelay());
            nDSNegotiator.setAttribute(nSObject, SA_SYSTEM_ATTRIBUTES[12], string);
        }
        if ((this.I_DIRTY_BITS & 0x2000L) != 0L) {
            string = String.valueOf(this.getArchiveInterval());
            nDSNegotiator.setAttribute(nSObject, SA_SYSTEM_ATTRIBUTES[13], string);
        }
        if ((this.I_DIRTY_BITS & 0x4000L) != 0L) {
            string = String.valueOf(this.getArchiveExpire());
            nDSNegotiator.setAttribute(nSObject, SA_SYSTEM_ATTRIBUTES[14], string);
        }
        if ((this.I_DIRTY_BITS & 0x8000L) != 0L) {
            string = String.valueOf(this.getArchiveSessionTimeout());
            nDSNegotiator.setAttribute(nSObject, SA_SYSTEM_ATTRIBUTES[15], string);
        }
        if ((this.I_DIRTY_BITS & 1L) != 0L) {
            nDSNegotiator.setMultiValuedAttribute(nSObject, SA_SYSTEM_ATTRIBUTES[0], this.getHostList());
        }
        if ((this.I_DIRTY_BITS & 0x100L) != 0L) {
            nDSNegotiator.setMultiValuedAttribute(nSObject, SA_SYSTEM_ATTRIBUTES[8], this.getArchiveList());
        }
        if ((this.I_DIRTY_BITS & 0x400L) != 0L) {
            nDSNegotiator.setMultiValuedAttribute(nSObject, SA_SYSTEM_ATTRIBUTES[10], this.getArchiveACL());
        }
        if ((this.I_DIRTY_BITS & 0x800L) != 0L) {
            nDSNegotiator.setMultiValuedAttribute(nSObject, SA_SYSTEM_ATTRIBUTES[11], this.getArchiveExtACL());
        }
        if ((this.I_DIRTY_BITS & 0x200000L) != 0L) {
            nDSNegotiator.setMultiValuedAttribute(nSObject, SA_SYSTEM_ATTRIBUTES[21], this.getClientDownloadURLs());
        }
        if ((this.I_DIRTY_BITS & 0x800000L) != 0L) {
            nDSNegotiator.setMultiValuedAttribute(nSObject, SA_SYSTEM_ATTRIBUTES[23], this.getConferencingSettings());
        }
        if (!(bl = nDSNegotiator.update(nSObject))) {
            System.out.println("=================\n" + this.toString());
        } else {
            this.I_DIRTY_BITS = 0L;
        }
        this.load(nSObject);
        return bl;
    }
}

