/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.system;

import com.novell.admin.common.snapins.AdminPageSnapin;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.application.console.snapin.InitSnapinInfo;
import com.novell.application.console.snapin.NamespaceSnapin;
import com.novell.application.console.snapin.PageSnapin;
import com.novell.netmessenger.admin.agent.NNMArchiveNSObject;
import com.novell.netmessenger.admin.common.DefaultOEList;
import com.novell.netmessenger.admin.common.NDSNegotiator;
import com.novell.netmessenger.admin.common.NIncrementBox;
import com.novell.netmessenger.admin.common.OESTextField;
import com.novell.netmessenger.admin.common.StaticUtilities;
import com.novell.netmessenger.admin.swingext.JComboBoxExt;
import com.novell.netmessenger.admin.swingext.JLabelExt;
import com.novell.netmessenger.admin.swingext.JTextFieldExt;
import com.novell.netmessenger.admin.system.NNMSystemPage;
import com.novell.netmessenger.admin.system.NNMSystemResource;
import com.novell.utility.nmsgbox.NMsgBox;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class NNMSystemPanelArchive
extends NNMSystemPage {
    private JComboBoxExt m_cmbArchiveType;
    private OESTextField m_tfArchiveMaster;
    private JTextFieldExt m_tfArchivePassphrase;
    private NIncrementBox m_incArchiveDelay;
    private NIncrementBox m_incArchiveInterval;
    private NIncrementBox m_incArchiveExpire;
    private NIncrementBox m_incArchiveSessionTimeout;
    private DefaultOEList m_listArchiveList;
    private JLabelExt m_labelArchiveMaster;
    private static final String[] SA_ARCHIVE_TYPE_OPTIONS = new String[]{NNMSystemResource.get("SystemArchiveTypeCentral"), NNMSystemResource.get("SystemArchiveTypeDistributed")};

    public NNMSystemPanelArchive(InitSnapinInfo initSnapinInfo, AdminPageSnapin adminPageSnapin, NSObject nSObject) {
        super(initSnapinInfo, adminPageSnapin, nSObject);
    }

    protected void init() {
        NamespaceSnapin namespaceSnapin = this.nsObj.getObjectEntry().getNamespace();
        this.m_cmbArchiveType = new JComboBoxExt(SA_ARCHIVE_TYPE_OPTIONS);
        this.m_cmbArchiveType.setLightWeightPopupEnabled(false);
        this.m_tfArchiveMaster = new OESTextField(this.propertyBook.getComponent(), this.nsObj.getObjectEntry());
        this.m_tfArchiveMaster.setFilter(StaticUtilities.SA_OBJECT_TYPE_ARCHIVE_AGENT);
        this.m_tfArchivePassphrase = new JTextFieldExt();
        this.m_incArchiveDelay = new NIncrementBox(0, Integer.MAX_VALUE, 0);
        this.m_incArchiveInterval = new NIncrementBox(0, Integer.MAX_VALUE, 0);
        this.m_incArchiveExpire = new NIncrementBox(0, Integer.MAX_VALUE, 0);
        this.m_incArchiveSessionTimeout = new NIncrementBox(0, Integer.MAX_VALUE, 0);
        this.m_listArchiveList = new DefaultOEList(this.propertyBook.getComponent(), this.nsObj.getObjectEntry());
        this.m_listArchiveList.setFilter(StaticUtilities.SA_OBJECT_TYPE_ARCHIVE_AGENT);
    }

    public void layoutControls() {
        super.layoutControls();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 18;
        JLabelExt jLabelExt = new JLabelExt(NNMSystemResource.get("SystemArchiveType"), this.m_cmbArchiveType);
        JLabelExt jLabelExt2 = new JLabelExt(NNMSystemResource.get("SystemArchivePassphrase"), this.m_tfArchivePassphrase);
        JLabelExt jLabelExt3 = new JLabelExt(NNMSystemResource.get("SystemArchiveDelay"), this.m_incArchiveDelay);
        JLabelExt jLabelExt4 = new JLabelExt(NNMSystemResource.get("SystemArchiveInterval"), this.m_incArchiveInterval);
        JLabelExt jLabelExt5 = new JLabelExt(NNMSystemResource.get("SystemArchiveExpire"), this.m_incArchiveExpire);
        JLabelExt jLabelExt6 = new JLabelExt(NNMSystemResource.get("SystemArchiveSessionTimeout"), this.m_incArchiveSessionTimeout);
        JLabelExt jLabelExt7 = new JLabelExt(NNMSystemResource.get("SystemArchiveList"), this.m_listArchiveList);
        this.m_labelArchiveMaster = new JLabelExt(NNMSystemResource.get("SystemArchiveMaster"), this.m_tfArchiveMaster);
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(NNMSystemResource.get("SystemArchiveMaintenance")));
        this.setGBC(gridBagConstraints, 1, 2, 1, 1, 0, 0.0, 0.0);
        this.add(this.m_labelArchiveMaster, gridBagConstraints);
        this.setGBC(gridBagConstraints, 2, 2, 2, 1, 2, 0.0, 0.0);
        this.add(this.m_tfArchiveMaster, gridBagConstraints);
        this.setGBC(gridBagConstraints, 1, 3, 1, 1, 0, 0.0, 0.0);
        this.add(jLabelExt2, gridBagConstraints);
        this.setGBC(gridBagConstraints, 2, 3, 2, 1, 2, 0.0, 0.0);
        this.add(this.m_tfArchivePassphrase, gridBagConstraints);
        this.setGBC(gridBagConstraints, 1, 7, 1, 1, 0, 0.0, 0.0);
        this.add(jLabelExt6, gridBagConstraints);
        this.setGBC(gridBagConstraints, 2, 7, 2, 1, 2, 0.0, 0.0);
        this.add(this.m_incArchiveSessionTimeout, gridBagConstraints);
        this.setGBC(gridBagConstraints, 1, 4, 1, 1, 0, 0.0, 0.0);
        jPanel.add((Component)jLabelExt3, gridBagConstraints);
        this.setGBC(gridBagConstraints, 2, 4, 2, 1, 0, 1.0, 0.0);
        jPanel.add((Component)this.m_incArchiveDelay, gridBagConstraints);
        this.setGBC(gridBagConstraints, 1, 5, 1, 1, 0, 0.0, 0.0);
        jPanel.add((Component)jLabelExt4, gridBagConstraints);
        this.setGBC(gridBagConstraints, 2, 5, 2, 1, 0, 1.0, 0.0);
        jPanel.add((Component)this.m_incArchiveInterval, gridBagConstraints);
        this.setGBC(gridBagConstraints, 1, 6, 1, 1, 0, 0.0, 0.0);
        jPanel.add((Component)jLabelExt5, gridBagConstraints);
        this.setGBC(gridBagConstraints, 2, 6, 2, 1, 0, 1.0, 0.0);
        jPanel.add((Component)this.m_incArchiveExpire, gridBagConstraints);
        this.setGBC(gridBagConstraints, 1, 8, 0, 1, 2, 1.0, 1.0);
        this.add(jPanel, gridBagConstraints);
    }

    public void readData() {
        String string;
        this.m_tfArchiveMaster.setText(this.m_systemNSObject.getArchiveMaster());
        this.m_cmbArchiveType.setSelectedIndex(this.m_systemNSObject.getArchiveType());
        this.initArchiveUI();
        try {
            string = StaticUtilities.decodeDecrypt(this.m_systemNSObject.getArchivePassphrase());
        }
        catch (Exception exception) {
            string = null;
        }
        this.m_tfArchivePassphrase.setText(string);
        this.m_incArchiveDelay.setValue(this.m_systemNSObject.getArchiveDelay());
        this.m_incArchiveInterval.setValue(this.m_systemNSObject.getArchiveInterval());
        this.m_incArchiveExpire.setValue(this.m_systemNSObject.getArchiveExpire());
        this.m_incArchiveSessionTimeout.setValue(this.m_systemNSObject.getArchiveSessionTimeout());
        Vector vector = this.m_systemNSObject.getArchiveList();
        if (vector != null) {
            int n = vector.size();
            DefaultListModel defaultListModel = (DefaultListModel)this.m_listArchiveList.getModel();
            for (int i = 0; i < n; ++i) {
                defaultListModel.addElement(vector.elementAt(i));
            }
        }
        this.m_cmbArchiveType.addItemListener(this);
        this.m_listArchiveList.addListDataListener(this);
        this.m_incArchiveDelay.addDocumentListener(this);
        this.m_incArchiveInterval.addDocumentListener(this);
        this.m_incArchiveExpire.addDocumentListener(this);
        this.m_incArchiveSessionTimeout.addDocumentListener(this);
        this.m_tfArchiveMaster.addDocumentListener(this);
        this.m_tfArchivePassphrase.addDocumentListener(this);
    }

    public boolean killActive() {
        String string = this.m_tfArchiveMaster.getText().trim();
        if (string.length() != 0) {
            NMsgBox nMsgBox;
            String string2 = this.m_tfArchivePassphrase.getText().trim();
            if (string2.length() == 0) {
                NDSNegotiator nDSNegotiator = new NDSNegotiator();
                try {
                    nMsgBox = nDSNegotiator.getNSObject((NDSNamespace)this.nsObj.getObjectEntry().getNamespace(), string);
                    string2 = nDSNegotiator.getAttribute((NSObject)nMsgBox, NNMArchiveNSObject.SA_ARCHIVE_ATTRIBUTES[1]);
                }
                catch (Exception exception) {
                    string2 = null;
                }
            }
            if (string2 == null || string2.length() < 7) {
                nMsgBox = new NMsgBox((Component)((Object)this), NNMSystemResource.get("SystemArchivePassphraseLengthTitle"), NNMSystemResource.get("SystemArchivePassphraseLength"), 3);
                nMsgBox.launch();
                this.fixFocus();
                this.m_tfArchivePassphrase.requestFocus();
                return false;
            }
        }
        return super.killActive();
    }

    public boolean saveData() {
        Object object;
        if (this.m_tfArchiveMaster.isModified()) {
            this.m_systemNSObject.setArchiveMaster(this.m_tfArchiveMaster.getText());
        }
        if (this.m_cmbArchiveType.isModified()) {
            this.m_systemNSObject.setArchiveType(this.m_cmbArchiveType.getSelectedIndex());
        }
        if (this.m_tfArchivePassphrase.isModified()) {
            try {
                object = StaticUtilities.encryptEncode(this.m_tfArchivePassphrase.getText().trim());
            }
            catch (Exception exception) {
                object = null;
            }
            this.m_systemNSObject.setArchivePassphrase((String)object);
        }
        if (this.m_incArchiveDelay.isModified()) {
            this.m_systemNSObject.setArchiveDelay(this.m_incArchiveDelay.getValue());
        }
        if (this.m_incArchiveInterval.isModified()) {
            this.m_systemNSObject.setArchiveInterval(this.m_incArchiveInterval.getValue());
        }
        if (this.m_incArchiveExpire.isModified()) {
            this.m_systemNSObject.setArchiveExpire(this.m_incArchiveExpire.getValue());
        }
        if (this.m_incArchiveSessionTimeout.isModified()) {
            this.m_systemNSObject.setArchiveSessionTimeout(this.m_incArchiveSessionTimeout.getValue());
        }
        if (this.m_listArchiveList.isModified()) {
            object = null;
            DefaultListModel defaultListModel = (DefaultListModel)this.m_listArchiveList.getModel();
            Enumeration enumeration = defaultListModel.elements();
            if (enumeration != null) {
                object = new Vector();
                while (enumeration.hasMoreElements()) {
                    ((Vector)object).addElement(enumeration.nextElement());
                }
            }
            this.m_systemNSObject.setArchiveList((Vector)object);
        }
        return true;
    }

    protected void initArchiveUI() {
        if (this.m_cmbArchiveType.getSelectedIndex() == 0) {
            this.m_labelArchiveMaster.setEnabled(true);
            this.m_tfArchiveMaster.setEnabled(true);
        } else {
            this.m_labelArchiveMaster.setEnabled(false);
            this.m_tfArchiveMaster.setEnabled(false);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.m_cmbArchiveType) {
            this.initArchiveUI();
        }
        this.propertyBook.setModified(true, (PageSnapin)this.pageSnapin);
    }
}

