/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.system;

import com.novell.admin.common.snapins.AdminPageSnapin;
import com.novell.admin.ns.NSObject;
import com.novell.application.console.snapin.InitSnapinInfo;
import com.novell.application.console.snapin.PageSnapin;
import com.novell.application.console.widgets.NDateTimeDlg;
import com.novell.netmessenger.admin.common.Debug;
import com.novell.netmessenger.admin.common.NIncrementBox;
import com.novell.netmessenger.admin.common.OEList;
import com.novell.netmessenger.admin.common.StaticUtilities;
import com.novell.netmessenger.admin.policy.PolicyContactRenameDlg;
import com.novell.netmessenger.admin.swingext.JButtonExt;
import com.novell.netmessenger.admin.swingext.JCheckBoxExt;
import com.novell.netmessenger.admin.swingext.JLabelExt;
import com.novell.netmessenger.admin.swingext.JTextAreaExt;
import com.novell.netmessenger.admin.swingext.JTextFieldExt;
import com.novell.netmessenger.admin.system.NNMSystemPage;
import com.novell.netmessenger.admin.system.NNMSystemResource;
import com.novell.utility.localization.Loc;
import com.novell.utility.nmsgbox.NMsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;

public class NNMSystemPanelClient
extends NNMSystemPage
implements ActionListener {
    private JTextAreaExt m_taPageDescription;
    private JTextFieldExt m_tfClientVersion;
    private JTextFieldExt m_tfClientDate;
    private NIncrementBox m_incClientGraceLogins;
    private JTextAreaExt m_taSoftwareDescription;
    private JButtonExt m_btnClientDate;
    private JButtonExt m_btnClientDateDelete;
    private JCheckBoxExt m_cbClientDownload;
    private JCheckBoxExt m_cbClientAutoUpdate;
    private URLDownloadList m_listURL;
    private Calendar m_calClientDate;

    public NNMSystemPanelClient(InitSnapinInfo initSnapinInfo, AdminPageSnapin adminPageSnapin, NSObject nSObject) {
        super(initSnapinInfo, adminPageSnapin, nSObject);
    }

    protected void init() {
        this.m_taPageDescription = new JTextAreaExt();
        this.m_taPageDescription.setText(NNMSystemResource.get("SystemClientPageDescription"));
        this.m_taPageDescription.setLineWrap(true);
        this.m_taPageDescription.setWrapStyleWord(true);
        this.m_tfClientVersion = new JTextFieldExt(25);
        this.m_tfClientDate = new JTextFieldExt(25);
        this.m_tfClientDate.setEditable(false);
        this.m_incClientGraceLogins = new NIncrementBox(0, Integer.MAX_VALUE, 0);
        this.m_taSoftwareDescription = new JTextAreaExt(3, 0);
        this.m_taSoftwareDescription.setLineWrap(true);
        this.m_taSoftwareDescription.setWrapStyleWord(true);
        this.m_listURL = new URLDownloadList(this.propertyBook.getComponent(), true);
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/com/novell/netmessenger/admin/common/images/date.gif"));
        ImageIcon imageIcon2 = new ImageIcon(this.getClass().getResource("/com/novell/netmessenger/admin/common/images/delete.gif"));
        Dimension dimension = new Dimension(imageIcon.getIconWidth() + 10, imageIcon.getIconHeight() + 6);
        this.m_btnClientDate = new JButtonExt(imageIcon, null);
        this.m_btnClientDate.setPreferredSize(dimension);
        this.m_btnClientDate.addActionListener(this);
        this.m_btnClientDateDelete = new JButtonExt(imageIcon2, null);
        this.m_btnClientDateDelete.setPreferredSize(dimension);
        this.m_btnClientDateDelete.addActionListener(this);
        this.m_cbClientDownload = new JCheckBoxExt(NNMSystemResource.get("SystemClientDownloadBrowser"));
        this.m_cbClientAutoUpdate = new JCheckBoxExt(NNMSystemResource.get("SystemClientAutoUpdate"));
        this.m_cbClientAutoUpdate.addActionListener(this);
    }

    public void layoutControls() {
        super.layoutControls();
        JLabelExt jLabelExt = new JLabelExt(NNMSystemResource.get("SystemClientVersion"), this.m_tfClientVersion);
        JLabelExt jLabelExt2 = new JLabelExt(NNMSystemResource.get("SystemClientDate"), this.m_btnClientDate);
        JLabelExt jLabelExt3 = new JLabelExt(NNMSystemResource.get("SystemClientGraceLogins"), this.m_incClientGraceLogins);
        JLabelExt jLabelExt4 = new JLabelExt(NNMSystemResource.get("SystemClientSoftwareDescription"), this.m_taSoftwareDescription);
        JLabelExt jLabelExt5 = new JLabelExt(NNMSystemResource.get("SystemClientDownloadURLs"), this.m_listURL);
        JLabelExt jLabelExt6 = new JLabelExt(NNMSystemResource.get("SystemClientURLHelp"));
        this.m_taPageDescription.setFont(jLabelExt2.getFont());
        this.m_taPageDescription.setWrapStyleWord(true);
        this.m_taPageDescription.setEditable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.setLayout(new GridBagLayout());
        this.setGBC(gridBagConstraints, 2, 1, 3, 1, 0, 0.0, 0.0);
        this.add(jLabelExt6, gridBagConstraints);
        this.setGBC(gridBagConstraints, 1, 2, 1, 1, 0, 0.0, 0.0);
        this.add(jLabelExt5, gridBagConstraints);
        this.m_listURL.setPreferredSize(new Dimension(250, 100));
        this.setGBC(gridBagConstraints, 2, 2, 3, 1, 1, 1.0, 0.7);
        this.add(this.m_listURL, gridBagConstraints);
        this.setGBC(gridBagConstraints, 1, 5, 0, 1, 0, 0.0, 0.0);
        this.add(this.m_cbClientDownload, gridBagConstraints);
        this.setGBC(gridBagConstraints, 1, 6, 0, 1, 0, 0.0, 0.0);
        this.add(this.m_cbClientAutoUpdate, gridBagConstraints);
        this.setGBC(gridBagConstraints, 1, 7, 1, 1, 0, 0.0, 0.0);
        this.add(jLabelExt, gridBagConstraints);
        this.setGBC(gridBagConstraints, 2, 7, 1, 1, 2, 0.0, 0.0);
        this.add(this.m_tfClientVersion, gridBagConstraints);
        this.setGBC(gridBagConstraints, 1, 8, 1, 1, 0, 0.0, 0.0);
        this.add(jLabelExt2, gridBagConstraints);
        this.setGBC(gridBagConstraints, 2, 8, 1, 1, 2, 0.0, 0.0);
        this.add(this.m_tfClientDate, gridBagConstraints);
        this.setGBC(gridBagConstraints, 3, 8, 1, 1, 3, 0.0, 0.0);
        this.add(this.m_btnClientDate, gridBagConstraints);
        this.setGBC(gridBagConstraints, 4, 8, 1, 1, 3, 0.0, 0.0);
        this.add(this.m_btnClientDateDelete, gridBagConstraints);
        this.setGBC(gridBagConstraints, 1, 9, 1, 1, 0, 0.0, 0.0);
        this.add(jLabelExt3, gridBagConstraints);
        this.setGBC(gridBagConstraints, 2, 9, 1, 1, 0, 0.0, 0.0);
        this.add(this.m_incClientGraceLogins, gridBagConstraints);
        this.setGBC(gridBagConstraints, 1, 10, 1, 1, 0, 0.0, 0.0);
        this.add(jLabelExt4, gridBagConstraints);
        JScrollPane jScrollPane = new JScrollPane(this.m_taSoftwareDescription, 20, 31);
        jScrollPane.setPreferredSize(new Dimension(250, 50));
        this.setGBC(gridBagConstraints, 2, 10, 3, 1, 1, 1.0, 0.3);
        this.add(jScrollPane, gridBagConstraints);
        this.setGBC(gridBagConstraints, 1, 11, 0, 1, 2, 0.0, 0.0);
        this.add(this.m_taPageDescription, gridBagConstraints);
    }

    private void enableControls() {
        boolean bl = this.m_cbClientAutoUpdate.isSelected();
        this.m_tfClientVersion.setEnabled(bl);
        this.m_tfClientDate.setEnabled(bl);
        this.m_btnClientDate.setEnabled(bl);
        this.m_btnClientDateDelete.setEnabled(bl);
        this.m_incClientGraceLogins.setEnabled(bl);
        this.m_taSoftwareDescription.setEnabled(bl);
    }

    public void readData() {
        this.m_tfClientVersion.setText(this.m_systemNSObject.getClientVersion());
        try {
            this.m_calClientDate = StaticUtilities.getCalendar(this.m_systemNSObject.getClientDate());
            if (this.m_calClientDate != null) {
                this.m_tfClientDate.setText(StaticUtilities.toLocaleFriendlyFormat(this.m_calClientDate));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_incClientGraceLogins.setValue(this.m_systemNSObject.getClientGraceLogins());
        this.m_cbClientDownload.setSelected(this.m_systemNSObject.getClientDownload());
        this.m_cbClientAutoUpdate.setSelected(this.m_systemNSObject.getClientAutoUpdate());
        this.m_taSoftwareDescription.setText(this.m_systemNSObject.getSoftwareDescription());
        this.m_listURL.setListData(this.m_systemNSObject.getClientDownloadURLs());
        this.m_tfClientVersion.addDocumentListener(this);
        this.m_tfClientDate.addDocumentListener(this);
        this.m_incClientGraceLogins.addDocumentListener(this);
        this.m_taSoftwareDescription.addDocumentListener(this);
        this.m_cbClientDownload.addItemListener(this);
        this.m_cbClientAutoUpdate.addItemListener(this);
        this.m_listURL.addListDataListener(this);
        this.enableControls();
    }

    public boolean saveData() {
        if (this.m_tfClientVersion.isModified()) {
            this.m_systemNSObject.setClientVersion(this.m_tfClientVersion.getText());
        }
        if (this.m_tfClientDate.isModified()) {
            this.m_systemNSObject.setClientDate(StaticUtilities.toSimpleDateFormat(this.m_calClientDate));
        }
        if (this.m_incClientGraceLogins.isModified()) {
            this.m_systemNSObject.setClientGraceLogins(this.m_incClientGraceLogins.getValue());
        }
        if (this.m_cbClientDownload.isModified()) {
            this.m_systemNSObject.setClientDownload(this.m_cbClientDownload.isSelected());
        }
        if (this.m_cbClientAutoUpdate.isModified()) {
            this.m_systemNSObject.setClientAutoUpdate(this.m_cbClientAutoUpdate.isSelected());
        }
        if (this.m_taSoftwareDescription.isModified()) {
            this.m_systemNSObject.setSoftwareDescription(this.m_taSoftwareDescription.getText());
        }
        if (this.m_listURL.isModified()) {
            this.m_systemNSObject.setClientDownloadURLs(this.m_listURL.getListData());
        }
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_btnClientDate) {
            Calendar calendar = this.m_calClientDate != null ? this.m_calClientDate : Calendar.getInstance();
            NDateTimeDlg nDateTimeDlg = new NDateTimeDlg((Component)((Object)this), calendar);
            if (nDateTimeDlg.launch() == 1) {
                this.m_calClientDate = nDateTimeDlg.getCalendar();
                String string = StaticUtilities.toLocaleFriendlyFormat(this.m_calClientDate);
                this.m_tfClientDate.setText(string);
                this.propertyBook.setModified(true, (PageSnapin)this.pageSnapin);
            }
            this.fixFocus();
        } else if (object == this.m_btnClientDateDelete) {
            this.m_calClientDate = null;
            this.m_tfClientDate.setText(null);
        } else if (object == this.m_cbClientAutoUpdate) {
            this.enableControls();
        }
    }

    class URLDownloadList
    extends OEList {
        public URLDownloadList(Component component, boolean bl) {
            super(component, bl);
            this.layoutControls();
        }

        protected void addButtonAction() {
            Debug.trace("URLDownloadList.addButtonAction");
            this.doEdit(-1);
        }

        protected void editButtonAction() {
            Debug.trace("URLDownloadList.editButtonAction");
            this.doEdit(this.m_list.getSelectedIndex());
        }

        private void doEdit(int n) {
            String string = null;
            if (n != -1) {
                string = (String)this.m_listModel.elementAt(n);
            }
            Debug.trace("URLDownloadList.doEdit: displayName= " + string);
            PolicyContactRenameDlg policyContactRenameDlg = new PolicyContactRenameDlg(NNMSystemPanelClient.this.propertyBook.getComponent(), Loc.removeHotChar((String)NNMSystemResource.getString("SystemClientDownloadURL")), NNMSystemResource.getStringWithColon("SystemClientDownloadURL"), "systemclienturledit", string);
            policyContactRenameDlg.usePlainDocumentExt(false);
            policyContactRenameDlg.setName(string);
            policyContactRenameDlg.show();
            NNMSystemPanelClient.this.fixFocus();
            String string2 = policyContactRenameDlg.getName();
            Debug.trace("URLDownloadList.doEdit: sName= " + string2);
            if (string2 != null) {
                if (this.m_listModel.contains(string2)) {
                    NMsgBox nMsgBox = new NMsgBox((Component)this, NNMSystemResource.getString("SystemClientDownloadDuplicateTitle"), NNMSystemResource.getString("SystemClientDownloadDuplicateMsg"), 3);
                    nMsgBox.launch();
                    this.m_btnEdit.doClick();
                    return;
                }
                if (n == -1) {
                    this.m_listModel.addElement(string2);
                } else {
                    this.m_listModel.setElementAt(string2, n);
                }
                NNMSystemPanelClient.this.propertyBook.setModified(true, (PageSnapin)NNMSystemPanelClient.this.pageSnapin);
                this.setModified(true);
            }
        }
    }
}

