/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.system;

import com.novell.admin.common.snapins.AdminPageSnapin;
import com.novell.admin.ns.NSObject;
import com.novell.application.console.snapin.InitSnapinInfo;
import com.novell.netmessenger.admin.swingext.JCheckBoxExt;
import com.novell.netmessenger.admin.swingext.JLabelExt;
import com.novell.netmessenger.admin.swingext.JTextAreaExt;
import com.novell.netmessenger.admin.swingext.JTextFieldExt;
import com.novell.netmessenger.admin.system.NNMSystemPage;
import com.novell.netmessenger.admin.system.NNMSystemResource;
import com.novell.utility.nmsgbox.NActivityBox;
import com.novell.utility.nmsgbox.NMsgBox;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import javax.net.ssl.HttpsURLConnection;

public class NNMSystemPanelConferencing
extends NNMSystemPage {
    private static final int CONNECTION_TIMEOUT = 10000;
    private static final int SLEEP_TIME = 100;
    private JTextFieldExt m_tfConferencingURL;
    private JCheckBoxExt m_cbConferencingSSO;

    public NNMSystemPanelConferencing(InitSnapinInfo initSnapinInfo, AdminPageSnapin adminPageSnapin, NSObject nSObject) {
        super(initSnapinInfo, adminPageSnapin, nSObject);
    }

    protected void init() {
        this.m_tfConferencingURL = new JTextFieldExt();
    }

    public void layoutControls() {
        this.init();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabelExt jLabelExt = new JLabelExt(NNMSystemResource.get("SystemConferencingServerURL"), this.m_tfConferencingURL);
        JTextAreaExt jTextAreaExt = new JTextAreaExt();
        jTextAreaExt.setText(NNMSystemResource.get("SystemConferencingMessengerCredentialsExplanation"));
        jTextAreaExt.setLineWrap(true);
        jTextAreaExt.setFont(jLabelExt.getFont());
        jTextAreaExt.setWrapStyleWord(true);
        jTextAreaExt.setEditable(false);
        this.m_cbConferencingSSO = new JCheckBoxExt(NNMSystemResource.get("SystemConferencingAllowMessengerCredentials"));
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.setLayout(new GridBagLayout());
        this.setGBC(gridBagConstraints, 1, 1, 1, 1, 0, 0.0, 0.0);
        this.add(jLabelExt, gridBagConstraints);
        this.setGBC(gridBagConstraints, 2, 1, 2, 1, 2, 0.0, 0.0);
        this.add(this.m_tfConferencingURL, gridBagConstraints);
        this.setGBC(gridBagConstraints, 1, 2, 0, 1, 2, 0.0, 0.0);
        this.add(this.m_cbConferencingSSO, gridBagConstraints);
        this.setGBC(gridBagConstraints, 1, 3, 0, 1, 2, 1.0, 1.0);
        this.add(jTextAreaExt, gridBagConstraints);
    }

    public void readData() {
        this.m_tfConferencingURL.setText(this.m_systemNSObject.getConferencingSetting("url"));
        String string = this.m_systemNSObject.getConferencingSetting("allowMessengerCredentials");
        boolean bl = string != null && string.equals("true");
        this.m_cbConferencingSSO.setSelected(bl);
        this.m_tfConferencingURL.addDocumentListener(this);
        this.m_cbConferencingSSO.addItemListener(this);
    }

    public boolean saveData() {
        if (this.m_tfConferencingURL.isModified()) {
            boolean bl;
            String string = this.m_tfConferencingURL.getText().trim();
            if (string.length() > 0) {
                if (string.startsWith("http://")) {
                    string = string.replaceFirst("http://", "https://");
                } else if (!string.startsWith("https://")) {
                    string = "https://" + string;
                }
            }
            if (bl = this.checkURL(string)) {
                this.m_systemNSObject.setConferencingSetting("url", string);
                this.m_tfConferencingURL.setText(string);
            } else {
                this.m_tfConferencingURL.setText(this.m_systemNSObject.getConferencingSetting("url"));
            }
        }
        if (this.m_cbConferencingSSO.isModified()) {
            this.m_systemNSObject.setConferencingSetting("allowMessengerCredentials", this.m_cbConferencingSSO.isSelected() ? "true" : "false");
        }
        return true;
    }

    private boolean checkURL(String string) {
        boolean bl = true;
        NActivityBox nActivityBox = new NActivityBox((Component)((Object)this), NNMSystemResource.get("SystemConferencingConnectionChecking"));
        nActivityBox.showImmediately();
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (string.length() > 0) {
            HttpConnectionThread httpConnectionThread = new HttpConnectionThread();
            httpConnectionThread.setURL(string);
            httpConnectionThread.start();
            for (int i = 0; httpConnectionThread.isAlive() && i < 10000; i += 100) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Thread.yield();
            }
            if (!httpConnectionThread.connectSucceeded()) {
                if (httpConnectionThread.urlMalformed()) {
                    NMsgBox nMsgBox = new NMsgBox(this.propertyBook.getComponent(), NNMSystemResource.get("SystemConferencingConnectionFailed"), NNMSystemResource.get("SystemConferencingInvalidURL"), 3);
                    nMsgBox.launch();
                    bl = false;
                } else if (httpConnectionThread.hostResolutionFailed()) {
                    NMsgBox nMsgBox = new NMsgBox(this.propertyBook.getComponent(), NNMSystemResource.get("SystemConferencingConnectionFailed"), NNMSystemResource.get("SystemConferencingUnknownHost"), 2);
                    int n = nMsgBox.launch();
                    bl = n == 8;
                } else {
                    NMsgBox nMsgBox = new NMsgBox(this.propertyBook.getComponent(), NNMSystemResource.get("SystemConferencingConnectionFailed"), NNMSystemResource.get("SystemConferencingCouldNotConnect"), 2);
                    int n = nMsgBox.launch();
                    boolean bl2 = bl = n == 8;
                }
            }
            if (httpConnectionThread.isAlive()) {
                httpConnectionThread.interrupt();
            }
        }
        nActivityBox.dispose();
        this.setCursor(Cursor.getPredefinedCursor(0));
        return bl;
    }

    class HttpConnectionThread
    extends Thread {
        private boolean m_bApplyChanges = false;
        private boolean m_bConnectSucceeded = false;
        private boolean m_bResolutionFailed = false;
        private boolean m_bInvalidURL = false;
        private String m_sURL = null;

        HttpConnectionThread() {
        }

        public boolean getApplyChanges() {
            return this.m_bApplyChanges;
        }

        public boolean connectSucceeded() {
            return this.m_bConnectSucceeded;
        }

        public boolean hostResolutionFailed() {
            return this.m_bResolutionFailed;
        }

        public boolean urlMalformed() {
            return this.m_bInvalidURL;
        }

        public void setURL(String string) {
            this.m_sURL = string;
        }

        public void run() {
            if (this.m_sURL == null) {
                return;
            }
            try {
                URL uRL = new URL(this.m_sURL);
                HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
                if (httpsURLConnection.getResponseCode() == 200) {
                    this.m_bConnectSucceeded = true;
                }
            }
            catch (UnknownHostException unknownHostException) {
                this.m_bResolutionFailed = true;
                unknownHostException.printStackTrace();
            }
            catch (MalformedURLException malformedURLException) {
                if (malformedURLException.getMessage().equals("unknown protocol: https")) {
                    this.m_bConnectSucceeded = true;
                } else {
                    this.m_bInvalidURL = true;
                }
                malformedURLException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

