/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.system;

import com.novell.admin.common.snapins.AdminPageSnapin;
import com.novell.admin.ns.NSObject;
import com.novell.application.console.snapin.InitSnapinInfo;
import com.novell.netmessenger.admin.common.DefaultOEList;
import com.novell.netmessenger.admin.common.OESTextField;
import com.novell.netmessenger.admin.common.StaticUtilities;
import com.novell.netmessenger.admin.swingext.JLabelExt;
import com.novell.netmessenger.admin.system.NNMSystemPage;
import com.novell.netmessenger.admin.system.NNMSystemResource;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultListModel;

public class NNMSystemPanelGeneral
extends NNMSystemPage {
    private OESTextField m_tfPolicyDN;
    private OESTextField m_tfSessionBrokerPrimary;
    private OESTextField m_tfLDAPProfile;
    private OESTextField m_tfScopeProfile;
    private DefaultOEList m_listHostList;

    public NNMSystemPanelGeneral(InitSnapinInfo initSnapinInfo, AdminPageSnapin adminPageSnapin, NSObject nSObject) {
        super(initSnapinInfo, adminPageSnapin, nSObject);
    }

    protected void init() {
        this.m_tfPolicyDN = new OESTextField(this.propertyBook.getComponent(), this.nsObj.getObjectEntry());
        this.m_tfPolicyDN.setFilter(StaticUtilities.SA_OBJECT_TYPE_POLICY);
        this.m_tfSessionBrokerPrimary = new OESTextField(this.propertyBook.getComponent(), this.nsObj.getObjectEntry());
        this.m_tfSessionBrokerPrimary.setFilter(StaticUtilities.SA_OBJECT_TYPE_SESSION_AGENT);
        this.m_tfLDAPProfile = new OESTextField(this.propertyBook.getComponent(), this.nsObj.getObjectEntry());
        this.m_tfLDAPProfile.setFilter(StaticUtilities.SA_OBJECT_TYPE_LDAP_PROFILE);
        this.m_tfScopeProfile = new OESTextField(this.propertyBook.getComponent(), this.nsObj.getObjectEntry());
        this.m_tfScopeProfile.setFilter(StaticUtilities.SA_OBJECT_TYPE_SCOPE_PROFILE);
        this.m_listHostList = new DefaultOEList(this.propertyBook.getComponent(), this.nsObj.getObjectEntry());
        this.m_listHostList.setFilter(StaticUtilities.SA_OBJECT_TYPE_HOST);
    }

    public void layoutControls() {
        this.init();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabelExt jLabelExt = new JLabelExt(NNMSystemResource.get("SystemGeneralPolicyDN"), this.m_tfPolicyDN);
        JLabelExt jLabelExt2 = new JLabelExt(NNMSystemResource.get("SystemGeneralSessionBrokerPrimary"), this.m_tfSessionBrokerPrimary);
        JLabelExt jLabelExt3 = new JLabelExt(NNMSystemResource.get("SystemGeneralLDAPProfile"), this.m_tfLDAPProfile);
        JLabelExt jLabelExt4 = new JLabelExt(NNMSystemResource.get("SystemGeneralScopeProfile"), this.m_tfScopeProfile);
        JLabelExt jLabelExt5 = new JLabelExt(NNMSystemResource.get("SystemGeneralHostList"), this.m_listHostList);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.setLayout(new GridBagLayout());
        this.setGBC(gridBagConstraints, 1, 1, 1, 1, 0, 0.0, 0.0);
        this.add(jLabelExt, gridBagConstraints);
        this.setGBC(gridBagConstraints, 2, 1, 2, 1, 2, 0.0, 0.0);
        this.add(this.m_tfPolicyDN, gridBagConstraints);
        this.setGBC(gridBagConstraints, 1, 2, 1, 1, 0, 0.0, 0.0);
        this.add(jLabelExt2, gridBagConstraints);
        this.setGBC(gridBagConstraints, 2, 2, 2, 1, 2, 0.0, 0.0);
        this.add(this.m_tfSessionBrokerPrimary, gridBagConstraints);
        this.setGBC(gridBagConstraints, 1, 3, 1, 1, 0, 0.0, 0.0);
        this.add(jLabelExt3, gridBagConstraints);
        this.setGBC(gridBagConstraints, 2, 3, 2, 1, 2, 0.0, 0.0);
        this.add(this.m_tfLDAPProfile, gridBagConstraints);
        this.setGBC(gridBagConstraints, 1, 4, 1, 1, 0, 0.0, 0.0);
        this.add(jLabelExt4, gridBagConstraints);
        this.setGBC(gridBagConstraints, 2, 4, 2, 1, 2, 0.0, 0.0);
        this.add(this.m_tfScopeProfile, gridBagConstraints);
        this.setGBC(gridBagConstraints, 1, 5, 1, 1, 0, 0.0, 0.0);
        this.add(jLabelExt5, gridBagConstraints);
        this.setGBC(gridBagConstraints, 2, 5, 1, 1, 1, 1.0, 1.0);
        this.add(this.m_listHostList, gridBagConstraints);
        jLabelExt2.setVisible(false);
        this.m_tfSessionBrokerPrimary.setVisible(false);
    }

    public void readData() {
        this.m_tfPolicyDN.setText(this.m_systemNSObject.getPolicyDN());
        this.m_tfSessionBrokerPrimary.setText(this.m_systemNSObject.getSessionBrokerPrimary());
        this.m_tfLDAPProfile.setText(this.m_systemNSObject.getLDAPProfile());
        this.m_tfScopeProfile.setText(this.m_systemNSObject.getScopeProfile());
        Vector vector = this.m_systemNSObject.getHostList();
        if (vector != null) {
            int n = vector.size();
            DefaultListModel defaultListModel = (DefaultListModel)this.m_listHostList.getModel();
            defaultListModel.removeAllElements();
            for (int i = 0; i < n; ++i) {
                defaultListModel.addElement(vector.elementAt(i));
            }
        }
        this.m_listHostList.addListDataListener(this);
        this.m_tfPolicyDN.addDocumentListener(this);
        this.m_tfSessionBrokerPrimary.addDocumentListener(this);
        this.m_tfLDAPProfile.addDocumentListener(this);
        this.m_tfScopeProfile.addDocumentListener(this);
    }

    public boolean saveData() {
        if (this.m_tfPolicyDN.isModified()) {
            this.m_systemNSObject.setPolicyDN(this.m_tfPolicyDN.getText());
        }
        if (this.m_tfSessionBrokerPrimary.isModified()) {
            this.m_systemNSObject.setSessionBrokerPrimary(this.m_tfSessionBrokerPrimary.getText());
        }
        if (this.m_tfLDAPProfile.isModified()) {
            this.m_systemNSObject.setLDAPProfile(this.m_tfLDAPProfile.getText());
        }
        if (this.m_tfScopeProfile.isModified()) {
            this.m_systemNSObject.setScopeProfile(this.m_tfScopeProfile.getText());
        }
        if (this.m_listHostList.isModified()) {
            Vector vector = null;
            DefaultListModel defaultListModel = (DefaultListModel)this.m_listHostList.getModel();
            Enumeration enumeration = defaultListModel.elements();
            if (enumeration != null) {
                vector = new Vector();
                while (enumeration.hasMoreElements()) {
                    vector.addElement(enumeration.nextElement());
                }
            }
            this.m_systemNSObject.setHostList(vector);
        }
        return true;
    }
}

