/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.user;

import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.netmessenger.admin.common.NDSNegotiator;
import com.novell.netmessenger.admin.policy.PolicyNSObject;
import com.novell.netmessenger.admin.system.NNMSystemNSObject;
import java.util.Vector;

public class UserNSObject {
    private static final int I_ATTR_TYPE_UNKNOWN = 0;
    private static final int I_ATTR_TYPE_INT = 1;
    private static final int I_ATTR_TYPE_STRING = 2;
    private static final int I_ATTR_TYPE_VECTOR = 3;
    private static final int I_ATTR_TYPE_BOOLEAN = 4;
    private static final int I_DEFAULT_FILE_TRANSFER = 0;
    private static final int I_DEFAULT_FILE_MAX_SEND_SIZE = 1024;
    private static final int I_DEFAULT_FILE_MAX_RECEIVE_SIZE = 1024;
    private static final int I_DEFAULT_MAX_CONTACTS = 100;
    private static final int I_DEFAULT_MAX_FOLDERS = 50;
    public static final int I_MAX_CONTACTS_LIMIT = 1000;
    public static final int I_MAX_FOLDERS_LIMIT = 100;
    public static final int I_USER_LEVEL_LOCK = 0;
    public static final int I_POLICY_LEVEL_LOCK = 1;
    public static final int I_SYSTEM_LEVEL_LOCK = 2;
    public static final int I_USER_SERVICES = 0;
    private static final int I_USER_LOCKED_ATTR_LIST = 1;
    public static final int I_USER_SCOPE_PROFILE = 2;
    public static final int I_USER_BLOCKING = 3;
    public static final int I_USER_BLOCKING_ALLOW_LIST = 5;
    private static final int I_USER_BLOCKING_ALLOW_EXT_LIST = 6;
    public static final int I_USER_BLOCKING_DENY_LIST = 7;
    private static final int I_USER_BLOCKING_DENY_EXT_LIST = 8;
    public static final int I_USER_CONTACT_LIST = 9;
    public static final int I_USER_INFORMATION_DISPLAY_LIST = 10;
    public static final int I_USER_FILE_TRANSFER = 11;
    public static final int I_USER_FILE_MAX_SEND_SIZE = 12;
    public static final int I_USER_FILE_MAX_RECEIVE_SIZE = 13;
    public static final int I_USER_ARCHIVE = 14;
    public static final int I_USER_PASSWORD_CHANGE = 15;
    public static final int I_USER_PASSWORD_REMEMBER = 16;
    public static final int I_USER_QUERY = 17;
    public static final int I_USER_POLICY_DN = 18;
    public static final int I_USER_CUSTOM_STATUS_LIST = 19;
    public static final int I_USER_DEFAULT_HOST = 20;
    private static final int I_USER_LAST_LOGIN = 21;
    public static final int I_USER_MAX_CONTACTS = 22;
    public static final int I_USER_MAX_FOLDERS = 23;
    public static final int I_USER_BROADCAST = 24;
    public static final int I_USER_BROADCASTSYSTEM = 25;
    public static final int I_USER_CHAT = 26;
    public static final int I_USER_CHATCREATE = 27;
    public static final int I_USER_PERSONALHISTORY = 28;
    public static final int I_USER_PRINTSAVE = 29;
    public static final int I_USER_CONFERENCING = 30;
    private static final long I_MASK_SERVICES = 1L;
    private static final long I_MASK_LOCKED_ATTR_LIST = 2L;
    private static final long I_MASK_SCOPE_PROFILE = 4L;
    private static final long I_MASK_BLOCKING = 8L;
    private static final long I_MASK_BLOCKING_PROMPT = 16L;
    private static final long I_MASK_BLOCKING_ALLOW_LIST = 32L;
    private static final long I_MASK_BLOCKING_ALLOW_EXT_LIST = 64L;
    private static final long I_MASK_BLOCKING_DENY_LIST = 128L;
    private static final long I_MASK_BLOCKING_DENY_EXT_LIST = 256L;
    private static final long I_MASK_CONTACT_LIST = 512L;
    private static final long I_MASK_INFORMATION_DISPLAY_LIST = 1024L;
    private static final long I_MASK_FILE_TRANSFER = 2048L;
    private static final long I_MASK_FILE_MAX_SEND_SIZE = 4096L;
    private static final long I_MASK_FILE_MAX_RECEIVE_SIZE = 8192L;
    private static final long I_MASK_ARCHIVE = 16384L;
    private static final long I_MASK_PASSWORD_CHANGE = 32768L;
    private static final long I_MASK_PASSWORD_REMEMBER = 65536L;
    private static final long I_MASK_QUERY = 131072L;
    private static final long I_MASK_POLICY_DN = 262144L;
    private static final long I_MASK_CUSTOM_STATUS_LIST = 524288L;
    private static final long I_MASK_DEFAULT_HOST = 0x100000L;
    private static final long I_MASK_LAST_LOGIN = 0x200000L;
    private static final long I_MASK_MAX_CONTACTS = 0x400000L;
    private static final long I_MASK_MAX_FOLDERS = 0x800000L;
    private static final long I_MASK_BROADCAST = 0x1000000L;
    private static final long I_MASK_BROADCASTSYSTEM = 0x2000000L;
    private static final long I_MASK_CHAT = 0x4000000L;
    private static final long I_MASK_CHATCREATE = 0x8000000L;
    private static final long I_MASK_PERSONALHISTORY = 0x10000000L;
    private static final long I_MASK_PRINTSAVE = 0x20000000L;
    private static final long I_MASK_CONFERENCING = 0x40000000L;
    private long I_DIRTY_BITS = 0L;
    private long I_ATTR_LOCKED = 0L;
    private long I_ATTR_LOCKED_AT_POLICY = 0L;
    private long I_ATTR_LOCKED_AT_SYSTEM = 0L;
    public static final String[] SA_USER_ATTRIBUTES = new String[]{"nnmServices", "nnmLockedAttrList", "nnmScopeProfileDN", "nnmBlocking", "nnmBlockingPrompt", "nnmBlockingAllowList", "nnmBlockingAllowExtList", "nnmBlockingDenyList", "nnmBlockingDenyExtList", "nnmContactList", "nnmInformationDisplayList", "nnmFileTransfer", "nnmFileMaxSendSize", "nnmFileMaxReceiveSize", "nnmArchive", "nnmPasswordChange", "nnmPasswordRemember", "nnmQuery", "nnmPolicyDN", "nnmCustomStatusList", "nnmDefaultHost", "nnmLastLogin", "nnmMaxContacts", "nnmMaxFolders", "nnmBroadcast", "nnmSystemBroadcast", "nnmChatService", "nnmChatCreate", "nnmPersonalHistory", "nnmPrintSave", "nnmEnableConferencing"};
    private static final long[] IA_MASK_ATTRIBUTES = new long[]{1L, 2L, 4L, 8L, 16L, 32L, 64L, 128L, 256L, 512L, 1024L, 2048L, 4096L, 8192L, 16384L, 32768L, 65536L, 131072L, 262144L, 524288L, 0x100000L, 0x200000L, 0x400000L, 0x800000L, 0x1000000L, 0x2000000L, 0x4000000L, 0x8000000L, 0x10000000L, 0x20000000L, 0x40000000L};
    private boolean m_bRestoreDefaultSettings;
    private NSObject m_nsObj;
    private NSObject m_nsObjPolicy;
    private NSObject m_nsObjSystemPolicy;
    private NDSNegotiator m_neg;
    private int m_iFileTransfer;
    private int m_iFileMaxSendSize;
    private int m_iFileMaxReceiveSize;
    private int m_iMaxContacts;
    private int m_iMaxFolders;
    private boolean m_bServices;
    private boolean m_bArchive;
    private boolean m_bPersonalHistory;
    private boolean m_bPrintSave;
    private boolean m_bPasswordChange;
    private boolean m_bPasswordRemember;
    private boolean m_bQuery;
    private boolean m_bBroadcast;
    private boolean m_bBroadcastSystem;
    private boolean m_bChat;
    private boolean m_bChatCreate;
    private boolean m_bConferencingEnabled;
    private boolean m_bBlocking;
    private boolean m_bPromptForSystemDN;
    private boolean m_bBlockingAllowListLocked = false;
    private boolean m_bBlockingDenyListLocked = false;
    private boolean m_bBlockingMerged;
    private boolean m_bBlockingAllowListMerged;
    private boolean m_bBlockingDenyListMerged;
    private String m_sScopeProfile;
    private String m_sPolicyDN;
    private String m_sDefaultHost;
    private String m_sLastLogin;
    private String m_sSystemDN;
    private Vector m_vLockedAttrList;
    private Vector m_vContactList;
    private Vector m_vInformationDisplayList;
    private Vector m_vBlockingAllowList;
    private Vector m_vBlockingAllowExtList;
    private Vector m_vBlockingDenyList;
    private Vector m_vBlockingDenyExtList;
    private Vector m_vCustomStatusList;
    private long m_lMergeSystemBits = 0L;
    private long m_lMergePolicyBits = 0L;
    private long m_lMergeUserBits = 0L;

    public void setFileTransfer(int n) {
        this.m_iFileTransfer = n;
        this.I_DIRTY_BITS |= 0x800L;
    }

    public int getFileTransfer() {
        return this.m_iFileTransfer;
    }

    public void setFileMaxSendSize(int n) {
        this.m_iFileMaxSendSize = n;
        this.I_DIRTY_BITS |= 0x1000L;
    }

    public int getFileMaxSendSize() {
        return this.m_iFileMaxSendSize;
    }

    public void setFileMaxReceiveSize(int n) {
        this.m_iFileMaxReceiveSize = n;
        this.I_DIRTY_BITS |= 0x2000L;
    }

    public int getFileMaxReceiveSize() {
        return this.m_iFileMaxReceiveSize;
    }

    public void setMaxContacts(int n) {
        this.m_iMaxContacts = n;
        this.I_DIRTY_BITS |= 0x400000L;
    }

    public int getMaxContacts() {
        return this.m_iMaxContacts;
    }

    public void setMaxFolders(int n) {
        this.m_iMaxFolders = n;
        this.I_DIRTY_BITS |= 0x800000L;
    }

    public int getMaxFolders() {
        return this.m_iMaxFolders;
    }

    public void setServices(boolean bl) {
        this.m_bServices = bl;
        this.I_DIRTY_BITS |= 1L;
    }

    public boolean getServices() {
        return this.m_bServices;
    }

    public void setArchive(boolean bl) {
        this.m_bArchive = bl;
        this.I_DIRTY_BITS |= 0x4000L;
    }

    public boolean getArchive() {
        return this.m_bArchive;
    }

    public void setPersonalHistory(boolean bl) {
        this.m_bPersonalHistory = bl;
        this.I_DIRTY_BITS |= 0x10000000L;
    }

    public boolean getPersonalHistory() {
        return this.m_bPersonalHistory;
    }

    public void setPrintSave(boolean bl) {
        this.m_bPrintSave = bl;
        this.I_DIRTY_BITS |= 0x20000000L;
    }

    public boolean getPrintSave() {
        return this.m_bPrintSave;
    }

    public void setPasswordChange(boolean bl) {
        this.m_bPasswordChange = bl;
        this.I_DIRTY_BITS |= 0x8000L;
    }

    public boolean getPasswordChange() {
        return this.m_bPasswordChange;
    }

    public void setPasswordRemember(boolean bl) {
        this.m_bPasswordRemember = bl;
        this.I_DIRTY_BITS |= 0x10000L;
    }

    public boolean getPasswordRemember() {
        return this.m_bPasswordRemember;
    }

    public void setQuery(boolean bl) {
        this.m_bQuery = bl;
        this.I_DIRTY_BITS |= 0x20000L;
    }

    public boolean getQuery() {
        return this.m_bQuery;
    }

    public void setBroadcast(boolean bl) {
        this.m_bBroadcast = bl;
        this.I_DIRTY_BITS |= 0x1000000L;
    }

    public boolean getBroadcast() {
        return this.m_bBroadcast;
    }

    public void setBroadcastSystem(boolean bl) {
        this.m_bBroadcastSystem = bl;
        this.I_DIRTY_BITS |= 0x2000000L;
    }

    public boolean getBroadcastSystem() {
        return this.m_bBroadcastSystem;
    }

    public void setChat(boolean bl) {
        this.m_bChat = bl;
        this.I_DIRTY_BITS |= 0x4000000L;
    }

    public boolean getChat() {
        return this.m_bChat;
    }

    public void setChatCreate(boolean bl) {
        this.m_bChatCreate = bl;
        this.I_DIRTY_BITS |= 0x8000000L;
    }

    public boolean getChatCreate() {
        return this.m_bChatCreate;
    }

    public void setConferencingEnabled(boolean bl) {
        this.m_bConferencingEnabled = bl;
        this.I_DIRTY_BITS |= 0x40000000L;
    }

    public boolean getConferencingEnabled() {
        return this.m_bConferencingEnabled;
    }

    public void setBlocking(boolean bl) {
        this.m_bBlocking = bl;
        this.I_DIRTY_BITS |= 8L;
    }

    public boolean getBlocking() {
        return this.m_bBlocking;
    }

    public void setScopeProfile(String string) {
        this.m_sScopeProfile = string;
        this.I_DIRTY_BITS |= 4L;
    }

    public String getScopeProfile() {
        return this.m_sScopeProfile;
    }

    public void setPolicyDN(String string) {
        this.m_sPolicyDN = string;
        this.m_bPromptForSystemDN = this.m_sPolicyDN == null;
        this.I_DIRTY_BITS |= 0x40000L;
    }

    public String getPolicyDN() {
        return this.m_sPolicyDN;
    }

    public void setDefaultHost(String string) {
        this.m_sDefaultHost = string;
        this.I_DIRTY_BITS |= 0x100000L;
    }

    public String getDefaultHost() {
        return this.m_sDefaultHost;
    }

    private void setLastLogin(String string) {
        this.m_sLastLogin = string;
    }

    public String getLastLogin() {
        return this.m_sLastLogin;
    }

    private void setLockedAttrList(Vector vector) {
        this.m_vLockedAttrList = vector;
        this.I_DIRTY_BITS |= 2L;
    }

    private Vector getLockedAttrList() {
        return this.m_vLockedAttrList;
    }

    public void setContactList(Vector vector) {
        this.m_vContactList = vector;
        this.I_DIRTY_BITS |= 0x200L;
    }

    public Vector getContactList() {
        return this.m_vContactList;
    }

    public void setInformationDisplayList(Vector vector) {
        this.m_vInformationDisplayList = vector;
        this.I_DIRTY_BITS |= 0x400L;
    }

    public Vector getInformationDisplayList() {
        return this.m_vInformationDisplayList;
    }

    public void setBlockingAllowList(Vector vector) {
        this.m_vBlockingAllowList = vector;
        this.I_DIRTY_BITS |= 0x20L;
    }

    public Vector getBlockingAllowList() {
        return this.m_vBlockingAllowList;
    }

    public boolean isBlockingAllowListLocked() {
        return this.m_bBlockingAllowListLocked;
    }

    private void setBlockingAllowExtList(Vector vector) {
        this.m_vBlockingAllowExtList = vector;
        this.I_DIRTY_BITS |= 0x40L;
    }

    private Vector getBlockingAllowExtList() {
        return this.m_vBlockingAllowExtList;
    }

    public void setBlockingDenyList(Vector vector) {
        this.m_vBlockingDenyList = vector;
        this.I_DIRTY_BITS |= 0x80L;
    }

    public Vector getBlockingDenyList() {
        return this.m_vBlockingDenyList;
    }

    public boolean isBlockingDenyListLocked() {
        return this.m_bBlockingDenyListLocked;
    }

    private void setBlockingDenyExtList(Vector vector) {
        this.m_vBlockingDenyExtList = vector;
        this.I_DIRTY_BITS |= 0x100L;
    }

    private Vector getBlockingDenyExtList() {
        return this.m_vBlockingDenyExtList;
    }

    public void setCustomStatusList(Vector vector) {
        this.m_vCustomStatusList = vector;
        this.I_DIRTY_BITS |= 0x80000L;
    }

    public Vector getCustomStatusList() {
        return this.m_vCustomStatusList;
    }

    public void setPromptForSystemDN(boolean bl) {
        this.m_bPromptForSystemDN = bl;
    }

    public boolean promptForSystemDN() {
        return this.m_sPolicyDN == null && this.m_bPromptForSystemDN;
    }

    private void readLocks() {
        if (this.m_vLockedAttrList != null) {
            int n = this.m_vLockedAttrList.size();
            for (int i = 0; i < n; ++i) {
                String string = (String)this.m_vLockedAttrList.elementAt(i);
                for (int j = 0; j < SA_USER_ATTRIBUTES.length; ++j) {
                    if (!string.equals(SA_USER_ATTRIBUTES[j])) continue;
                    this.I_ATTR_LOCKED |= IA_MASK_ATTRIBUTES[j];
                }
            }
        }
    }

    public boolean isAttributeMerged(int n, int n2) {
        boolean bl;
        switch (n) {
            case 0: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                long l = n2 == 2 ? this.m_lMergeSystemBits : (n2 == 1 ? this.m_lMergePolicyBits : this.m_lMergeUserBits);
                bl = (l & IA_MASK_ATTRIBUTES[n]) != 0L;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public boolean isAttributeLocked(int n) {
        return this.isAttributeLocked(n, 0);
    }

    public boolean isAttributeLocked(int n, int n2) {
        boolean bl;
        switch (n) {
            case 0: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                long l = n2 == 2 ? this.I_ATTR_LOCKED_AT_SYSTEM : (n2 == 1 ? this.I_ATTR_LOCKED_AT_POLICY : this.I_ATTR_LOCKED);
                bl = (l & IA_MASK_ATTRIBUTES[n]) != 0L;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public void lockAttribute(int n, boolean bl) {
        if (bl && this.m_vLockedAttrList == null) {
            this.m_vLockedAttrList = new Vector();
        }
        switch (n) {
            case 0: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                if (bl) {
                    this.m_vLockedAttrList.addElement(SA_USER_ATTRIBUTES[n]);
                } else {
                    int n2 = this.m_vLockedAttrList.size();
                    for (int i = 0; i < n2; ++i) {
                        String string = (String)this.m_vLockedAttrList.elementAt(i);
                        if (!string.equals(SA_USER_ATTRIBUTES[n])) continue;
                        this.m_vLockedAttrList.removeElementAt(i);
                        break;
                    }
                }
                this.I_DIRTY_BITS |= 2L;
                break;
            }
        }
    }

    private void readPolicyLocks(NDSNamespace nDSNamespace) {
        if (this.m_sPolicyDN != null) {
            try {
                NSObject nSObject = this.m_neg.getNSObject(nDSNamespace, this.m_sPolicyDN);
                Vector vector = this.m_neg.getMultiValuedAttribute(nSObject, "nnmLockedAttrList");
                if (vector != null) {
                    int n = vector.size();
                    for (int i = 0; i < n; ++i) {
                        String string = (String)vector.elementAt(i);
                        for (int j = 0; j < SA_USER_ATTRIBUTES.length; ++j) {
                            if (!string.equals(SA_USER_ATTRIBUTES[j])) continue;
                            this.I_ATTR_LOCKED_AT_POLICY |= IA_MASK_ATTRIBUTES[j];
                            int n2 = UserNSObject.getAttributeType(j);
                            if (n2 == 3) {
                                Vector vector2 = this.m_neg.getMultiValuedAttribute(nSObject, SA_USER_ATTRIBUTES[j]);
                                this.mergeAttributeForced(j, vector2);
                                continue;
                            }
                            String string2 = this.m_neg.getAttribute(nSObject, SA_USER_ATTRIBUTES[j]);
                            this.mergeAttributeForced(j, string2, n2);
                        }
                    }
                }
            }
            catch (Exception exception) {
                System.out.println("Failed to read policy locks for : " + this.m_sPolicyDN);
                System.out.println(exception.getLocalizedMessage());
            }
        }
    }

    private void readSystemLocks(NDSNamespace nDSNamespace) {
        if (this.m_sPolicyDN != null) {
            try {
                NSObject nSObject;
                String string;
                NSObject nSObject2 = this.m_neg.getNSObject(nDSNamespace, this.m_sPolicyDN);
                this.m_sSystemDN = this.m_neg.getAttribute(nSObject2, "nnmSystemDN");
                if (this.m_sSystemDN != null && (string = this.m_neg.getAttribute(nSObject = this.m_neg.getNSObject(nDSNamespace, this.m_sSystemDN), "nnmPolicyDN")) != null) {
                    ObjectEntry objectEntry;
                    ObjectEntry objectEntry2 = this.m_nsObj.getObjectEntry();
                    if (objectEntry2.equals((Object)(objectEntry = nDSNamespace.getObjectEntry(string)))) {
                        return;
                    }
                    NSObject nSObject3 = this.m_neg.getNSObject(nDSNamespace, string);
                    Vector vector = this.m_neg.getMultiValuedAttribute(nSObject3, "nnmLockedAttrList");
                    if (vector != null) {
                        int n = vector.size();
                        for (int i = 0; i < n; ++i) {
                            String string2 = (String)vector.elementAt(i);
                            for (int j = 0; j < SA_USER_ATTRIBUTES.length; ++j) {
                                if (!string2.equals(SA_USER_ATTRIBUTES[j])) continue;
                                this.I_ATTR_LOCKED_AT_SYSTEM |= IA_MASK_ATTRIBUTES[j];
                                int n2 = UserNSObject.getAttributeType(j);
                                if (n2 == 3) {
                                    Vector vector2 = this.m_neg.getMultiValuedAttribute(nSObject3, SA_USER_ATTRIBUTES[j]);
                                    this.mergeAttributeForced(j, vector2);
                                    continue;
                                }
                                String string3 = this.m_neg.getAttribute(nSObject3, SA_USER_ATTRIBUTES[j]);
                                this.mergeAttributeForced(j, string3, n2);
                            }
                        }
                    }
                }
            }
            catch (Exception exception) {
                System.out.println("Failed to read system policy locks");
                System.out.println(exception.getLocalizedMessage());
            }
        }
    }

    public void restoreDefaultSettings(int n) {
        boolean bl = true;
        switch (n) {
            case 0: 
            case 2: 
            case 3: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                this.m_neg.setAttribute(this.m_nsObj, SA_USER_ATTRIBUTES[n], null);
                this.mergeAttributeForced(n, this.mergeAttribute(n));
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 19: {
                this.m_neg.setMultiValuedAttribute(this.m_nsObj, SA_USER_ATTRIBUTES[n], null);
                this.mergeAttributeForced(n, this.mergeMultiValuedAttribute(n));
                break;
            }
            default: {
                bl = false;
            }
        }
        if (bl) {
            this.m_bRestoreDefaultSettings = true;
        }
    }

    private String mergeAttribute(int n) {
        String string = this.m_neg.getAttribute(this.m_nsObj, SA_USER_ATTRIBUTES[n]);
        if (string == null) {
            NDSNamespace nDSNamespace = (NDSNamespace)this.m_nsObj.getObjectEntry().getNamespace();
            if (this.m_nsObjPolicy == null) {
                if (this.m_sPolicyDN != null) {
                    try {
                        this.m_nsObjPolicy = this.m_neg.getNSObject(nDSNamespace, this.m_sPolicyDN);
                    }
                    catch (Exception exception) {
                        System.out.println("Error getting user's policy");
                        System.out.println(exception.getLocalizedMessage());
                        return null;
                    }
                } else {
                    return null;
                }
            }
            if ((string = this.m_neg.getAttribute(this.m_nsObjPolicy, SA_USER_ATTRIBUTES[n])) == null) {
                if (this.m_nsObjSystemPolicy == null) {
                    String string2 = this.m_neg.getAttribute(this.m_nsObjPolicy, PolicyNSObject.SA_POLICY_ATTRIBUTES[20]);
                    if (string2 != null) {
                        try {
                            NSObject nSObject = this.m_neg.getNSObject(nDSNamespace, string2);
                            String string3 = this.m_neg.getAttribute(nSObject, NNMSystemNSObject.SA_SYSTEM_ATTRIBUTES[3]);
                            if (string3 == null) {
                                return null;
                            }
                            this.m_nsObjSystemPolicy = this.m_neg.getNSObject(nDSNamespace, string3);
                        }
                        catch (Exception exception) {
                            System.out.println("Error getting system policy");
                            System.out.println(exception.getLocalizedMessage());
                            return null;
                        }
                    } else {
                        return null;
                    }
                }
                string = this.m_neg.getAttribute(this.m_nsObjSystemPolicy, SA_USER_ATTRIBUTES[n]);
                this.m_lMergeSystemBits |= IA_MASK_ATTRIBUTES[n];
            } else {
                this.m_lMergePolicyBits |= IA_MASK_ATTRIBUTES[n];
            }
        } else {
            this.m_lMergeUserBits |= IA_MASK_ATTRIBUTES[n];
        }
        return string;
    }

    private Vector mergeMultiValuedAttribute(int n) {
        Vector vector = this.m_neg.getMultiValuedAttribute(this.m_nsObj, SA_USER_ATTRIBUTES[n]);
        if (vector == null) {
            NDSNamespace nDSNamespace = (NDSNamespace)this.m_nsObj.getObjectEntry().getNamespace();
            if (this.m_nsObjPolicy == null) {
                if (this.m_sPolicyDN != null) {
                    try {
                        this.m_nsObjPolicy = this.m_neg.getNSObject(nDSNamespace, this.m_sPolicyDN);
                    }
                    catch (Exception exception) {
                        System.out.println("Error getting policy for merge");
                        System.out.println(exception.getLocalizedMessage());
                        return null;
                    }
                } else {
                    return null;
                }
            }
            if ((vector = this.m_neg.getMultiValuedAttribute(this.m_nsObjPolicy, SA_USER_ATTRIBUTES[n])) == null) {
                if (this.m_nsObjSystemPolicy == null) {
                    String string = this.m_neg.getAttribute(this.m_nsObjPolicy, PolicyNSObject.SA_POLICY_ATTRIBUTES[20]);
                    if (string != null) {
                        try {
                            NSObject nSObject = this.m_neg.getNSObject(nDSNamespace, string);
                            String string2 = this.m_neg.getAttribute(nSObject, NNMSystemNSObject.SA_SYSTEM_ATTRIBUTES[3]);
                            if (string2 == null) {
                                return null;
                            }
                            this.m_nsObjSystemPolicy = this.m_neg.getNSObject(nDSNamespace, string2);
                        }
                        catch (Exception exception) {
                            System.out.println("Error getting system policy for merge");
                            System.out.println(exception.getLocalizedMessage());
                            return null;
                        }
                    } else {
                        return null;
                    }
                }
                vector = this.m_neg.getMultiValuedAttribute(this.m_nsObjSystemPolicy, SA_USER_ATTRIBUTES[n]);
                this.m_lMergeSystemBits |= IA_MASK_ATTRIBUTES[n];
            } else {
                this.m_lMergePolicyBits |= IA_MASK_ATTRIBUTES[n];
            }
        } else {
            this.m_lMergeUserBits |= IA_MASK_ATTRIBUTES[n];
        }
        return vector;
    }

    private static int getAttributeType(int n) {
        int n2;
        switch (n) {
            case 11: 
            case 12: 
            case 13: 
            case 22: 
            case 23: {
                n2 = 1;
                break;
            }
            case 0: 
            case 3: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                n2 = 4;
                break;
            }
            case 2: 
            case 20: {
                n2 = 2;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 19: {
                n2 = 3;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }

    private void mergeAttributeForced(int n, String string) {
        this.mergeAttributeForced(n, string, UserNSObject.getAttributeType(n));
    }

    private void mergeAttributeForced(int n, String string, int n2) {
        if (n2 == 1) {
            int n3;
            try {
                n3 = Integer.parseInt(string);
            }
            catch (Exception exception) {
                n3 = 0;
            }
            switch (n) {
                case 11: {
                    this.setFileTransfer(n3);
                    break;
                }
                case 12: {
                    this.setFileMaxSendSize(n3);
                    break;
                }
                case 13: {
                    this.setFileMaxReceiveSize(n3);
                    break;
                }
                case 22: {
                    this.setMaxContacts(n3);
                    break;
                }
                case 23: {
                    this.setMaxFolders(n3);
                    break;
                }
            }
        } else if (n2 == 4) {
            boolean bl = string != null && string.equals("1");
            switch (n) {
                case 0: {
                    this.setServices(bl);
                    break;
                }
                case 3: {
                    this.setBlocking(bl);
                    break;
                }
                case 14: {
                    this.setArchive(bl);
                    break;
                }
                case 28: {
                    this.setPersonalHistory(bl);
                    break;
                }
                case 29: {
                    this.setPrintSave(bl);
                    break;
                }
                case 15: {
                    this.setPasswordChange(bl);
                    break;
                }
                case 16: {
                    this.setPasswordRemember(bl);
                    break;
                }
                case 17: {
                    this.setQuery(bl);
                    break;
                }
                case 24: {
                    this.setBroadcast(bl);
                    break;
                }
                case 25: {
                    this.setBroadcastSystem(bl);
                    break;
                }
                case 26: {
                    this.setChat(bl);
                    break;
                }
                case 27: {
                    this.setChatCreate(bl);
                    break;
                }
                case 30: {
                    this.setConferencingEnabled(bl);
                    break;
                }
            }
        } else {
            switch (n) {
                case 2: {
                    this.setScopeProfile(string);
                    break;
                }
                case 20: {
                    this.setDefaultHost(string);
                    break;
                }
            }
        }
    }

    private void mergeAttributeForced(int n, Vector vector) {
        switch (n) {
            case 5: {
                this.setBlockingAllowList(vector);
                break;
            }
            case 6: {
                this.setBlockingAllowExtList(vector);
                break;
            }
            case 7: {
                this.setBlockingDenyList(vector);
                break;
            }
            case 8: {
                this.setBlockingDenyExtList(vector);
                break;
            }
            case 9: {
                this.setContactList(vector);
                break;
            }
            case 10: {
                this.setInformationDisplayList(vector);
                break;
            }
            case 19: {
                this.setCustomStatusList(vector);
                break;
            }
        }
    }

    public boolean load(NSObject nSObject) {
        return this.load(nSObject, null);
    }

    public boolean load(NSObject nSObject, String string) {
        int n;
        this.m_neg = new NDSNegotiator();
        this.m_nsObj = nSObject;
        this.m_bRestoreDefaultSettings = false;
        if (string != null) {
            this.setPolicyDN(string);
        } else {
            this.setPolicyDN(this.m_neg.getAttribute(this.m_nsObj, SA_USER_ATTRIBUTES[18]));
        }
        this.setScopeProfile(this.mergeAttribute(2));
        this.setDefaultHost(this.mergeAttribute(20));
        this.setLastLogin(this.m_neg.getAttribute(this.m_nsObj, SA_USER_ATTRIBUTES[21]));
        String string2 = this.mergeAttribute(0);
        boolean bl = string2 == null || string2.equals("1");
        this.setServices(bl);
        this.m_bBlockingMerged = false;
        string2 = this.m_neg.getAttribute(nSObject, SA_USER_ATTRIBUTES[3]);
        if (string2 == null) {
            string2 = this.mergeAttribute(3);
            this.m_bBlockingMerged = true;
        }
        bl = string2 != null && string2.equals("1");
        this.setBlocking(bl);
        string2 = this.mergeAttribute(14);
        bl = string2 != null && string2.equals("1");
        this.setArchive(bl);
        string2 = this.mergeAttribute(28);
        bl = string2 != null && string2.equals("1");
        this.setPersonalHistory(bl);
        string2 = this.mergeAttribute(29);
        bl = string2 != null && string2.equals("1");
        this.setPrintSave(bl);
        string2 = this.mergeAttribute(15);
        bl = string2 != null && string2.equals("1");
        this.setPasswordChange(bl);
        string2 = this.mergeAttribute(16);
        bl = string2 != null && string2.equals("1");
        this.setPasswordRemember(bl);
        string2 = this.mergeAttribute(17);
        bl = string2 != null && string2.equals("1");
        this.setQuery(bl);
        string2 = this.mergeAttribute(24);
        bl = string2 != null && string2.equals("1");
        this.setBroadcast(bl);
        string2 = this.mergeAttribute(25);
        bl = string2 != null && string2.equals("1");
        this.setBroadcastSystem(bl);
        string2 = this.mergeAttribute(26);
        bl = string2 != null && string2.equals("1");
        this.setChat(bl);
        string2 = this.mergeAttribute(27);
        bl = string2 != null && string2.equals("1");
        this.setChatCreate(bl);
        string2 = this.mergeAttribute(30);
        bl = string2 != null && string2.equals("1");
        this.setConferencingEnabled(bl);
        try {
            n = Integer.parseInt(this.mergeAttribute(11));
        }
        catch (Exception exception) {
            n = 0;
        }
        this.setFileTransfer(n);
        try {
            n = Integer.parseInt(this.mergeAttribute(12));
        }
        catch (Exception exception) {
            n = 1024;
        }
        this.setFileMaxSendSize(n);
        try {
            n = Integer.parseInt(this.mergeAttribute(13));
        }
        catch (Exception exception) {
            n = 1024;
        }
        this.setFileMaxReceiveSize(n);
        try {
            n = Integer.parseInt(this.mergeAttribute(22));
        }
        catch (Exception exception) {
            n = 100;
        }
        this.setMaxContacts(n);
        try {
            n = Integer.parseInt(this.mergeAttribute(23));
        }
        catch (Exception exception) {
            n = 50;
        }
        this.setMaxFolders(n);
        this.setContactList(this.mergeMultiValuedAttribute(9));
        this.setInformationDisplayList(this.mergeMultiValuedAttribute(10));
        this.setLockedAttrList(this.m_neg.getMultiValuedAttribute(this.m_nsObj, SA_USER_ATTRIBUTES[1]));
        this.m_bBlockingAllowListMerged = false;
        Vector vector = this.m_neg.getMultiValuedAttribute(nSObject, SA_USER_ATTRIBUTES[5]);
        if (vector == null) {
            vector = this.mergeMultiValuedAttribute(5);
            this.m_bBlockingAllowListMerged = true;
        }
        this.setBlockingAllowList(vector);
        this.setBlockingAllowExtList(this.mergeMultiValuedAttribute(6));
        this.m_bBlockingDenyListMerged = false;
        vector = this.m_neg.getMultiValuedAttribute(nSObject, SA_USER_ATTRIBUTES[7]);
        if (vector == null) {
            vector = this.mergeMultiValuedAttribute(7);
            this.m_bBlockingDenyListMerged = true;
        }
        this.setBlockingDenyList(vector);
        this.setBlockingDenyExtList(this.mergeMultiValuedAttribute(8));
        this.setCustomStatusList(this.mergeMultiValuedAttribute(19));
        if (!(this.m_bBlockingMerged && this.m_bBlockingAllowListMerged && this.m_bBlockingDenyListMerged)) {
            if (this.m_bBlockingMerged) {
                this.setBlocking(false);
            }
            if (this.m_bBlockingAllowListMerged) {
                this.setBlockingAllowList(null);
            }
            if (this.m_bBlockingDenyListMerged) {
                this.setBlockingDenyList(null);
            }
        }
        this.readLocks();
        this.readPolicyLocks((NDSNamespace)this.m_nsObj.getObjectEntry().getNamespace());
        this.readSystemLocks((NDSNamespace)this.m_nsObj.getObjectEntry().getNamespace());
        this.I_DIRTY_BITS = 0L;
        return true;
    }

    public boolean save(NSObject nSObject) {
        boolean bl = false;
        if (!this.m_bRestoreDefaultSettings) {
            String string;
            if ((this.I_DIRTY_BITS & 4L) != 0L) {
                this.m_neg.setAttribute(nSObject, SA_USER_ATTRIBUTES[2], this.getScopeProfile());
            }
            if ((this.I_DIRTY_BITS & 0x40000L) != 0L) {
                this.m_neg.setAttribute(nSObject, SA_USER_ATTRIBUTES[18], this.getPolicyDN());
            }
            if ((this.I_DIRTY_BITS & 0x100000L) != 0L) {
                this.m_neg.setAttribute(nSObject, SA_USER_ATTRIBUTES[20], this.getDefaultHost());
            }
            if ((this.I_DIRTY_BITS & 1L) != 0L) {
                string = this.getServices() ? "1" : "0";
                this.m_neg.setAttribute(nSObject, SA_USER_ATTRIBUTES[0], string);
            }
            if ((this.I_DIRTY_BITS & 0x4000L) != 0L) {
                string = this.getArchive() ? "1" : "0";
                this.m_neg.setAttribute(nSObject, SA_USER_ATTRIBUTES[14], string);
            }
            if ((this.I_DIRTY_BITS & 0x10000000L) != 0L) {
                string = this.getPersonalHistory() ? "1" : "0";
                this.m_neg.setAttribute(nSObject, SA_USER_ATTRIBUTES[28], string);
            }
            if ((this.I_DIRTY_BITS & 0x20000000L) != 0L) {
                string = this.getPrintSave() ? "1" : "0";
                this.m_neg.setAttribute(nSObject, SA_USER_ATTRIBUTES[29], string);
            }
            if ((this.I_DIRTY_BITS & 8L) != 0L) {
                string = this.getBlocking() ? "1" : "0";
                this.m_neg.setAttribute(nSObject, SA_USER_ATTRIBUTES[3], string);
            }
            if ((this.I_DIRTY_BITS & 0x8000L) != 0L) {
                string = this.getPasswordChange() ? "1" : "0";
                this.m_neg.setAttribute(nSObject, SA_USER_ATTRIBUTES[15], string);
            }
            if ((this.I_DIRTY_BITS & 0x10000L) != 0L) {
                string = this.getPasswordRemember() ? "1" : "0";
                this.m_neg.setAttribute(nSObject, SA_USER_ATTRIBUTES[16], string);
            }
            if ((this.I_DIRTY_BITS & 0x20000L) != 0L) {
                string = this.getQuery() ? "1" : "0";
                this.m_neg.setAttribute(nSObject, SA_USER_ATTRIBUTES[17], string);
            }
            if ((this.I_DIRTY_BITS & 0x1000000L) != 0L) {
                string = this.getBroadcast() ? "1" : "0";
                this.m_neg.setAttribute(nSObject, SA_USER_ATTRIBUTES[24], string);
            }
            if ((this.I_DIRTY_BITS & 0x2000000L) != 0L) {
                string = this.getBroadcastSystem() ? "1" : "0";
                this.m_neg.setAttribute(nSObject, SA_USER_ATTRIBUTES[25], string);
            }
            if ((this.I_DIRTY_BITS & 0x4000000L) != 0L) {
                string = this.getChat() ? "1" : "0";
                this.m_neg.setAttribute(nSObject, SA_USER_ATTRIBUTES[26], string);
            }
            if ((this.I_DIRTY_BITS & 0x8000000L) != 0L) {
                string = this.getChatCreate() ? "1" : "0";
                this.m_neg.setAttribute(nSObject, SA_USER_ATTRIBUTES[27], string);
            }
            if ((this.I_DIRTY_BITS & 0x40000000L) != 0L) {
                string = this.getConferencingEnabled() ? "1" : "0";
                this.m_neg.setAttribute(nSObject, SA_USER_ATTRIBUTES[30], string);
            }
            if ((this.I_DIRTY_BITS & 0x800L) != 0L) {
                string = String.valueOf(this.getFileTransfer());
                this.m_neg.setAttribute(nSObject, SA_USER_ATTRIBUTES[11], string);
            }
            if ((this.I_DIRTY_BITS & 0x1000L) != 0L) {
                string = String.valueOf(this.getFileMaxSendSize());
                this.m_neg.setAttribute(nSObject, SA_USER_ATTRIBUTES[12], string);
            }
            if ((this.I_DIRTY_BITS & 0x2000L) != 0L) {
                string = String.valueOf(this.getFileMaxReceiveSize());
                this.m_neg.setAttribute(nSObject, SA_USER_ATTRIBUTES[13], string);
            }
            if ((this.I_DIRTY_BITS & 0x400000L) != 0L) {
                string = String.valueOf(this.getMaxContacts());
                this.m_neg.setAttribute(nSObject, SA_USER_ATTRIBUTES[22], string);
            }
            if ((this.I_DIRTY_BITS & 0x800000L) != 0L) {
                string = String.valueOf(this.getMaxFolders());
                this.m_neg.setAttribute(nSObject, SA_USER_ATTRIBUTES[23], string);
            }
            if ((this.I_DIRTY_BITS & 0x200L) != 0L) {
                this.m_neg.setMultiValuedAttribute(nSObject, SA_USER_ATTRIBUTES[9], this.getContactList());
            }
            if ((this.I_DIRTY_BITS & 0x400L) != 0L) {
                this.m_neg.setMultiValuedAttribute(nSObject, SA_USER_ATTRIBUTES[10], this.getInformationDisplayList());
            }
            if ((this.I_DIRTY_BITS & 2L) != 0L) {
                this.m_neg.setMultiValuedAttribute(nSObject, SA_USER_ATTRIBUTES[1], this.getLockedAttrList());
            }
            if ((this.I_DIRTY_BITS & 0x20L) != 0L) {
                this.m_neg.setMultiValuedAttribute(nSObject, SA_USER_ATTRIBUTES[5], this.getBlockingAllowList());
            }
            if ((this.I_DIRTY_BITS & 0x40L) != 0L) {
                this.m_neg.setMultiValuedAttribute(nSObject, SA_USER_ATTRIBUTES[6], this.getBlockingAllowExtList());
            }
            if ((this.I_DIRTY_BITS & 0x80L) != 0L) {
                this.m_neg.setMultiValuedAttribute(nSObject, SA_USER_ATTRIBUTES[7], this.getBlockingDenyList());
            }
            if ((this.I_DIRTY_BITS & 0x100L) != 0L) {
                this.m_neg.setMultiValuedAttribute(nSObject, SA_USER_ATTRIBUTES[8], this.getBlockingDenyExtList());
            }
            if ((this.I_DIRTY_BITS & 0x80000L) != 0L) {
                this.m_neg.setMultiValuedAttribute(nSObject, SA_USER_ATTRIBUTES[19], this.getCustomStatusList());
            }
        }
        this.I_DIRTY_BITS = 0L;
        bl = this.m_neg.update(nSObject);
        if (!bl) {
            System.out.println("================= Save failed");
        }
        this.load(nSObject);
        this.m_bRestoreDefaultSettings = false;
        return bl;
    }

    protected boolean isConferencingURLSet() {
        Object object;
        NSObject nSObject = null;
        try {
            object = (NDSNamespace)this.m_nsObj.getObjectEntry().getNamespace();
            nSObject = this.m_neg.getNSObject((NDSNamespace)object, this.m_sSystemDN);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (nSObject != null) {
            object = this.m_neg.getMultiValuedAttribute(nSObject, NNMSystemNSObject.SA_SYSTEM_ATTRIBUTES[23]);
            if (object == null) {
                return false;
            }
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                String string = (String)((Vector)object).elementAt(i);
                int n = string.indexOf(";");
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1, string.length());
                if (!string2.equals("url") || string3.length() <= 0) continue;
                return true;
            }
        }
        return false;
    }
}

