/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.user;

import com.novell.admin.common.snapins.AdminPageSnapin;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.application.console.snapin.DefaultObjectEntryCollection;
import com.novell.application.console.snapin.InitSnapinInfo;
import com.novell.application.console.snapin.NamespaceSnapin;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryCollection;
import com.novell.application.console.snapin.ObjectType;
import com.novell.application.console.snapin.PageSnapin;
import com.novell.application.console.util.objectentryselector.ObjectEntrySelector;
import com.novell.netmessenger.admin.common.Debug;
import com.novell.netmessenger.admin.common.NDSNegotiator;
import com.novell.netmessenger.admin.common.NIncrementBox;
import com.novell.netmessenger.admin.common.StaticUtilities;
import com.novell.netmessenger.admin.policy.ContactListItem;
import com.novell.netmessenger.admin.policy.PolicyContactRenameDlg;
import com.novell.netmessenger.admin.policy.PolicyResource;
import com.novell.netmessenger.admin.swingext.JButtonExt;
import com.novell.netmessenger.admin.swingext.JLabelExt;
import com.novell.netmessenger.admin.swingext.JTreeExt;
import com.novell.netmessenger.admin.user.UserAdminPage;
import com.novell.netmessenger.admin.user.UserResource;
import com.novell.utility.nmsgbox.NMsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class UserPanelContactList
extends UserAdminPage
implements ActionListener,
KeyListener {
    private JTreeExt m_tree;
    private DefaultTreeModel m_treeModel;
    private JButton m_btnAddUser;
    private JButton m_btnAddFolder;
    private JButton m_btnEdit;
    private JButton m_btnRemove;
    private JButton m_btnLock;
    protected JButton m_btnResetDefaultSettings;
    private NIncrementBox m_incMaxContacts;
    private JLabelExt m_labelLockMaxContacts;
    private NIncrementBox m_incMaxFolders;
    private JLabelExt m_labelLockMaxFolders;
    private Hashtable m_htContactList;
    private int m_iLastRecordedID;
    private int m_iLeafCountUser;
    private int m_iLeafCountFolder;
    private NamespaceSnapin m_ns;

    public UserPanelContactList(InitSnapinInfo initSnapinInfo, AdminPageSnapin adminPageSnapin, NSObject nSObject) {
        super(initSnapinInfo, adminPageSnapin, nSObject);
        this.m_ns = nSObject.getObjectEntry().getNamespace();
    }

    protected void init() {
        ContactListItem contactListItem;
        this.m_iLastRecordedID = 0;
        this.m_htContactList = new Hashtable();
        try {
            contactListItem = new ContactListItem(0, 0, 0, 1, 0, null, "Net Messenger", null);
        }
        catch (Exception exception) {
            contactListItem = null;
        }
        this.m_treeModel = new DefaultTreeModel(new DefaultMutableTreeNode(contactListItem));
        this.m_tree = new JTreeExt(this.m_treeModel);
        this.m_tree.setRootVisible(false);
        this.m_tree.setCellRenderer(new DefaultTreeCellRendererExt());
        DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)this.m_tree.getCellRenderer();
        this.m_incMaxContacts = new NIncrementBox(0, 1000, 0);
        this.m_labelLockMaxContacts = new JLabelExt();
        this.m_incMaxFolders = new NIncrementBox(0, 100, 0);
        this.m_labelLockMaxFolders = new JLabelExt();
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/com/novell/netmessenger/admin/common/images/folderClosed.gif"));
        defaultTreeCellRenderer.setClosedIcon(imageIcon);
        ImageIcon imageIcon2 = new ImageIcon(this.getClass().getResource("/com/novell/netmessenger/admin/common/images/folderOpened.gif"));
        defaultTreeCellRenderer.setOpenIcon(imageIcon2);
        Dimension dimension = new Dimension(this.m_iconLockPolicyLevel.getIconWidth() + 15, this.m_iconLockPolicyLevel.getIconHeight() + 10);
        this.m_btnAddUser = new JButtonExt(PolicyResource.get("PolicyContactAddUser"));
        this.m_btnAddFolder = new JButtonExt(PolicyResource.get("PolicyContactAddFolder"));
        this.m_btnEdit = new JButtonExt(PolicyResource.get("PolicyContactEditContact"));
        this.m_btnRemove = new JButtonExt(PolicyResource.get("PolicyContactRemoveContact"));
        this.m_btnResetDefaultSettings = new JButtonExt(PolicyResource.get("RestoreDefaultSettingsButton"));
        this.m_btnLock = new JButtonExt(this.m_iconLockOpen, PolicyResource.get("PolicyContactLock"));
        this.m_btnLock.setPreferredSize(dimension);
    }

    public void layoutControls() {
        this.init();
        JLabelExt jLabelExt = new JLabelExt(PolicyResource.get("PolicyContactList"), this.m_tree);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.setLayout(new GridBagLayout());
        this.setGBC(gridBagConstraints, 1, 1, 3, 1, 2, 1.0, 0.0);
        this.add(this.getMaxPanel(), gridBagConstraints);
        this.setGBC(gridBagConstraints, 1, 2, 1, 1, 0, 0.0, 0.0);
        this.add(jLabelExt, gridBagConstraints);
        this.setGBC(gridBagConstraints, 2, 2, 1, 1, 0, 0.0, 0.0);
        this.add(this.m_btnLock, gridBagConstraints);
        JScrollPane jScrollPane = new JScrollPane(this.m_tree);
        jScrollPane.setPreferredSize(new Dimension(400, 200));
        this.setGBC(gridBagConstraints, 1, 3, 3, 5, 1, 1.0, 1.0);
        this.add(jScrollPane, gridBagConstraints);
        this.setGBC(gridBagConstraints, 4, 3, 1, 1, 2, 0.0, 0.0);
        this.add(this.m_btnAddUser, gridBagConstraints);
        this.setGBC(gridBagConstraints, 4, 4, 1, 1, 2, 0.0, 0.0);
        this.add(this.m_btnAddFolder, gridBagConstraints);
        this.setGBC(gridBagConstraints, 4, 5, 1, 1, 2, 0.0, 0.0);
        this.add(this.m_btnEdit, gridBagConstraints);
        this.setGBC(gridBagConstraints, 4, 6, 1, 1, 2, 0.0, 0.0);
        this.add(this.m_btnRemove, gridBagConstraints);
        this.setGBC(gridBagConstraints, 1, 15, 5, 1, 0, 0.0, 0.0);
        this.add(this.m_btnResetDefaultSettings, gridBagConstraints);
    }

    protected JPanel getMaxPanel() {
        JLabelExt jLabelExt = new JLabelExt(PolicyResource.get("PolicyContactListMaxContacts"), this.m_incMaxContacts);
        JLabelExt jLabelExt2 = new JLabelExt(PolicyResource.get("PolicyContactListMaxFolders"), this.m_incMaxFolders);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.setGBC(gridBagConstraints, 1, 0, 1, 1, 0, 0.1, 0.0);
        jPanel.add((Component)jLabelExt, gridBagConstraints);
        this.setGBC(gridBagConstraints, 2, 0, 1, 1, 0, 0.0, 0.0);
        jPanel.add((Component)this.m_incMaxContacts, gridBagConstraints);
        this.setGBC(gridBagConstraints, 3, 0, 1, 1, 3, 0.9, 0.0);
        jPanel.add((Component)this.m_labelLockMaxContacts, gridBagConstraints);
        this.setGBC(gridBagConstraints, 1, 1, 2, 1, 0, 0.1, 0.0);
        jPanel.add((Component)jLabelExt2, gridBagConstraints);
        this.setGBC(gridBagConstraints, 2, 1, 1, 1, 0, 0.0, 0.0);
        jPanel.add((Component)this.m_incMaxFolders, gridBagConstraints);
        this.setGBC(gridBagConstraints, 3, 1, 1, 1, 3, 0.9, 0.0);
        jPanel.add((Component)this.m_labelLockMaxFolders, gridBagConstraints);
        return jPanel;
    }

    public void readData() {
        Vector vector = this.m_userNSObject.getContactList();
        if (vector != null) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            ContactListItem contactListItem;
            int n;
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.m_treeModel.getRoot();
            this.m_htContactList.clear();
            int n2 = vector.size();
            for (n = 0; n < n2; ++n) {
                String string = (String)vector.elementAt(n);
                try {
                    contactListItem = new ContactListItem(string);
                }
                catch (Exception exception) {
                    continue;
                }
                defaultMutableTreeNode = new DefaultMutableTreeNode(contactListItem);
                this.m_htContactList.put(defaultMutableTreeNode, new Integer(contactListItem.getID()));
            }
            Enumeration enumeration = this.m_htContactList.keys();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                    contactListItem = (ContactListItem)defaultMutableTreeNode.getUserObject();
                    if (contactListItem.getID() > this.m_iLastRecordedID) {
                        this.m_iLastRecordedID = contactListItem.getID();
                    }
                    this.addContactToTree(defaultMutableTreeNode);
                }
                defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.m_treeModel.getRoot();
                this.m_tree.expandPath(new TreePath(defaultMutableTreeNode2.getPath()));
                n = this.m_tree.getRowCount();
                for (int i = 0; i < n; ++i) {
                    this.m_tree.expandRow(i);
                }
            }
        }
        this.m_incMaxContacts.setValue(this.m_userNSObject.getMaxContacts());
        this.m_incMaxFolders.setValue(this.m_userNSObject.getMaxFolders());
        this.m_iLeafCountUser = this.getTotalChildCount((DefaultMutableTreeNode)this.m_treeModel.getRoot(), 2);
        this.m_iLeafCountFolder = this.getTotalChildCount((DefaultMutableTreeNode)this.m_treeModel.getRoot(), 1);
        this.m_incMaxContacts.setMinValue(this.m_iLeafCountUser);
        this.m_incMaxFolders.setMinValue(this.m_iLeafCountFolder);
        this.initMergeIcons();
        this.initLocks();
        this.m_incMaxContacts.addDocumentListener(this);
        this.m_incMaxFolders.addDocumentListener(this);
        this.m_btnAddUser.addActionListener(this);
        this.m_btnAddFolder.addActionListener(this);
        this.m_btnEdit.addActionListener(this);
        this.m_btnRemove.addActionListener(this);
        this.m_btnLock.addActionListener(this);
        this.m_btnResetDefaultSettings.addActionListener(this);
        this.m_tree.addKeyListener(this);
        this.m_tree.addTreeModelListener(this);
    }

    protected int getTotalChildCount(DefaultMutableTreeNode defaultMutableTreeNode, int n) {
        int n2 = 0;
        if (defaultMutableTreeNode.getChildCount() > 0) {
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                ContactListItem contactListItem = (ContactListItem)defaultMutableTreeNode2.getUserObject();
                if (contactListItem.getContactType() != n) continue;
                ++n2;
            }
        }
        return n2;
    }

    protected void initMergeIcons() {
        if (this.m_userNSObject.isAttributeMerged(9, 2)) {
            this.m_btnLock.setIcon(this.m_iconLockSystemLevelOpen);
            this.m_btnLock.setToolTipText(UserResource.get("UserGlobalPolicyLevelUnlock"));
        } else if (this.m_userNSObject.isAttributeMerged(9, 1)) {
            this.m_btnLock.setIcon(this.m_iconLockPolicyLevelOpen);
            this.m_btnLock.setToolTipText(UserResource.get("UserPolicyLevelUnlock"));
        } else {
            this.m_btnLock.setIcon(this.m_iconLockOpen);
            this.m_btnLock.setToolTipText(UserResource.get("UserNotLocked"));
        }
        if (this.m_userNSObject.isAttributeMerged(22, 2)) {
            this.m_labelLockMaxContacts.setIcon(this.m_iconLockSystemLevelOpen, UserResource.get("UserGlobalPolicyLevelUnlock"));
        } else if (this.m_userNSObject.isAttributeMerged(22, 1)) {
            this.m_labelLockMaxContacts.setIcon(this.m_iconLockPolicyLevelOpen, UserResource.get("UserPolicyLevelUnlock"));
        } else {
            this.m_labelLockMaxContacts.setIcon(this.m_iconLockOpen, UserResource.get("UserNotLocked"));
        }
        if (this.m_userNSObject.isAttributeMerged(23, 2)) {
            this.m_labelLockMaxFolders.setIcon(this.m_iconLockSystemLevelOpen, UserResource.get("UserGlobalPolicyLevelUnlock"));
        } else if (this.m_userNSObject.isAttributeMerged(23, 1)) {
            this.m_labelLockMaxFolders.setIcon(this.m_iconLockPolicyLevelOpen, UserResource.get("UserPolicyLevelUnlock"));
        } else {
            this.m_labelLockMaxFolders.setIcon(this.m_iconLockOpen, UserResource.get("UserNotLocked"));
        }
    }

    protected void initLocks() {
        if (this.m_userNSObject.isAttributeLocked(9, 2)) {
            this.setUIEnabled(false);
            this.m_btnLock.setIcon(this.m_iconLockSystemLevel);
            this.m_btnLock.setToolTipText(UserResource.get("UserGlobalPolicyLevelLock"));
        } else if (this.m_userNSObject.isAttributeLocked(9, 1)) {
            this.setUIEnabled(false);
            this.m_btnLock.setIcon(this.m_iconLockPolicyLevel);
            this.m_btnLock.setToolTipText(UserResource.get("UserPolicyLevelLock"));
        } else if (this.m_userNSObject.isAttributeLocked(9)) {
            this.m_btnLock.setIcon(this.m_iconLockClosed);
            this.m_btnLock.setToolTipText(UserResource.get("UserLocked"));
        }
        if (this.m_userNSObject.isAttributeLocked(22, 2)) {
            this.m_incMaxContacts.setEnabled(false);
            this.m_labelLockMaxContacts.setIcon(this.m_iconLockSystemLevel, UserResource.get("UserGlobalPolicyLevelLock"));
        } else if (this.m_userNSObject.isAttributeLocked(22, 1)) {
            this.m_incMaxContacts.setEnabled(false);
            this.m_labelLockMaxContacts.setIcon(this.m_iconLockPolicyLevel, UserResource.get("UserPolicyLevelLock"));
        }
        if (this.m_userNSObject.isAttributeLocked(23, 2)) {
            this.m_incMaxFolders.setEnabled(false);
            this.m_labelLockMaxFolders.setIcon(this.m_iconLockSystemLevel, UserResource.get("UserGlobalPolicyLevelLock"));
        } else if (this.m_userNSObject.isAttributeLocked(23, 1)) {
            this.m_incMaxFolders.setEnabled(false);
            this.m_labelLockMaxFolders.setIcon(this.m_iconLockPolicyLevel, UserResource.get("UserPolicyLevelLock"));
        }
    }

    protected void setUIEnabled(boolean bl) {
        this.m_tree.setEnabled(bl);
        this.m_btnAddUser.setEnabled(bl);
        this.m_btnAddFolder.setEnabled(bl);
        this.m_btnEdit.setEnabled(bl);
        this.m_btnRemove.setEnabled(bl);
        this.m_btnLock.setEnabled(bl);
        this.m_btnResetDefaultSettings.setEnabled(bl);
    }

    protected void addContactToTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode != null) {
            int n;
            Enumeration<TreeNode> enumeration;
            Object object;
            Object object2;
            Object object3 = null;
            ContactListItem contactListItem = (ContactListItem)defaultMutableTreeNode.getUserObject();
            if (contactListItem.getParentID() == 0) {
                object3 = (DefaultMutableTreeNode)this.m_treeModel.getRoot();
            } else if (contactListItem.getParentID() > 0) {
                object3 = this.getParentNode(null, contactListItem);
            }
            if (object3 == null) {
                object2 = this.m_htContactList.keys();
                while (object2.hasMoreElements()) {
                    object = (DefaultMutableTreeNode)object2.nextElement();
                    ContactListItem contactListItem2 = (ContactListItem)((DefaultMutableTreeNode)object).getUserObject();
                    if (contactListItem2.getID() != contactListItem.getParentID()) continue;
                    object3 = object;
                    break;
                }
                if (object3 == null) {
                    object3 = (DefaultMutableTreeNode)this.m_treeModel.getRoot();
                }
            }
            if ((enumeration = ((DefaultMutableTreeNode)object3).children()) != null) {
                n = 0;
                while (enumeration.hasMoreElements()) {
                    object2 = (DefaultMutableTreeNode)enumeration.nextElement();
                    object = (ContactListItem)((DefaultMutableTreeNode)object2).getUserObject();
                    if (contactListItem.getSequence() >= ((ContactListItem)object).getSequence()) {
                        ++n;
                        continue;
                    }
                    break;
                }
            } else {
                n = ((DefaultMutableTreeNode)object3).getChildCount();
            }
            this.m_treeModel.insertNodeInto(defaultMutableTreeNode, (MutableTreeNode)object3, n);
        }
    }

    protected DefaultMutableTreeNode getParentNode(DefaultMutableTreeNode defaultMutableTreeNode, ContactListItem contactListItem) {
        Enumeration<TreeNode> enumeration;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        if (defaultMutableTreeNode == null) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_treeModel.getRoot();
        }
        if ((enumeration = defaultMutableTreeNode.children()).hasMoreElements()) {
            defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            ContactListItem contactListItem2 = (ContactListItem)defaultMutableTreeNode2.getUserObject();
            if (contactListItem2.getID() == contactListItem.getParentID()) {
                return defaultMutableTreeNode2;
            }
            return this.getParentNode(defaultMutableTreeNode2, contactListItem);
        }
        return defaultMutableTreeNode2;
    }

    public boolean saveData() {
        if (this.m_incMaxContacts.isModified()) {
            this.m_userNSObject.setMaxContacts(this.m_incMaxContacts.getValue());
        }
        if (this.m_incMaxFolders.isModified()) {
            this.m_userNSObject.setMaxFolders(this.m_incMaxFolders.getValue());
        }
        if (this.m_tree.isModified()) {
            Vector vector = new Vector();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_treeModel.getRoot();
            if (defaultMutableTreeNode != null) {
                this.createContactList(vector, defaultMutableTreeNode);
                this.m_userNSObject.setContactList(vector);
            }
        }
        return true;
    }

    protected void createContactList(Vector vector, DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode != null && defaultMutableTreeNode.getChildCount() > 0) {
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                this.createContactList(vector, defaultMutableTreeNode2);
                ContactListItem contactListItem = (ContactListItem)defaultMutableTreeNode2.getUserObject();
                vector.addElement(contactListItem.toStringExt());
            }
        }
    }

    protected void restoreDefaultSettings() {
        this.m_userNSObject.restoreDefaultSettings(9);
        this.m_userNSObject.restoreDefaultSettings(22);
        this.m_userNSObject.restoreDefaultSettings(23);
        ((DefaultMutableTreeNode)this.m_treeModel.getRoot()).removeAllChildren();
        this.m_treeModel.reload();
        this.readData();
    }

    private void doRemove() {
        TreePath[] treePathArray = this.m_tree.getSelectionPaths();
        if (treePathArray != null) {
            for (int i = 0; i < treePathArray.length; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
                if (defaultMutableTreeNode == null) continue;
                ContactListItem contactListItem = (ContactListItem)defaultMutableTreeNode.getUserObject();
                if (contactListItem.getContactType() == 2) {
                    this.m_incMaxContacts.setMinValue(--this.m_iLeafCountUser);
                } else if (contactListItem.getContactType() == 1) {
                    this.m_incMaxContacts.setMinValue(--this.m_iLeafCountFolder);
                }
                this.m_treeModel.removeNodeFromParent(defaultMutableTreeNode);
                this.propertyBook.setModified(true, (PageSnapin)this.pageSnapin);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        DefaultMutableTreeNode defaultMutableTreeNode2;
        Object object5 = actionEvent.getSource();
        if (object5 == this.m_btnAddUser) {
            if (this.m_iLeafCountUser >= this.m_incMaxContacts.getValue()) {
                NMsgBox nMsgBox = new NMsgBox((Component)((Object)this), PolicyResource.get("PolicyContactListMaxContactsErrorTitle"), PolicyResource.get("PolicyContactListMaxContactsError") + this.m_incMaxContacts.getValue(), 3);
                nMsgBox.launch();
                return;
            }
            defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.m_tree.getLastSelectedPathComponent();
            object3 = defaultMutableTreeNode2 != null ? (((ContactListItem)(object4 = (ContactListItem)defaultMutableTreeNode2.getUserObject())).getContactType() == 1 ? defaultMutableTreeNode2 : (DefaultMutableTreeNode)this.m_treeModel.getRoot()) : (DefaultMutableTreeNode)this.m_treeModel.getRoot();
            object2 = (ContactListItem)((DefaultMutableTreeNode)object3).getUserObject();
            object4 = this.getContactVec(((ContactListItem)object2).getID());
            if (object4 != null) {
                for (int i = 0; i < ((Vector)object4).size(); ++i) {
                    object = (ContactListItem)((Vector)object4).elementAt(i);
                    if (this.isNodePresent(null, ((ContactListItem)object).toString())) continue;
                    ((ContactListItem)object).setSequence(((DefaultMutableTreeNode)object3).getChildCount());
                    defaultMutableTreeNode = new DefaultMutableTreeNode(object);
                    defaultMutableTreeNode.setAllowsChildren(false);
                    this.m_treeModel.insertNodeInto(defaultMutableTreeNode, (MutableTreeNode)object3, ((DefaultMutableTreeNode)object3).getChildCount());
                }
                this.m_tree.expandPath(new TreePath(((DefaultMutableTreeNode)object3).getPath()));
                this.m_incMaxContacts.setMinValue(++this.m_iLeafCountUser);
                this.propertyBook.setModified(true, (PageSnapin)this.pageSnapin);
            }
        }
        if (object5 == this.m_btnAddFolder) {
            if (this.m_iLeafCountFolder >= this.m_incMaxFolders.getValue()) {
                object3 = new NMsgBox((Component)((Object)this), PolicyResource.get("PolicyContactListMaxFoldersErrorTitle"), PolicyResource.get("PolicyContactListMaxFoldersError") + this.m_incMaxFolders.getValue(), 3);
                object3.launch();
                return;
            }
            int n = 2;
            defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_treeModel.getRoot();
            try {
                object2 = "New Folder";
                while (this.isNodePresent(null, (String)object2)) {
                    object2 = "New Folder " + n++;
                }
                int n2 = defaultMutableTreeNode.getChildCount();
                object4 = new ContactListItem(++this.m_iLastRecordedID, 0, n2, 1, 0, null, (String)object2, null);
            }
            catch (Exception exception) {
                return;
            }
            object = new DefaultMutableTreeNode(object4);
            this.m_treeModel.insertNodeInto((MutableTreeNode)object, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
            this.m_tree.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
            this.m_incMaxFolders.setMinValue(++this.m_iLeafCountFolder);
            this.propertyBook.setModified(true, (PageSnapin)this.pageSnapin);
        } else if (object5 == this.m_btnEdit) {
            defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.m_tree.getLastSelectedPathComponent();
            if (defaultMutableTreeNode2 != null) {
                object3 = (ContactListItem)defaultMutableTreeNode2.getUserObject();
                if (((ContactListItem)object3).getContactType() == 2) {
                    try {
                        object2 = this.m_ns.getObjectEntry(StaticUtilities.LDAPToDNFormat(((ContactListItem)object3).getFDN()));
                        this.shell.showDetails((ObjectEntryCollection)new DefaultObjectEntryCollection((ObjectEntry)object2), false);
                    }
                    catch (Exception exception) {
                        return;
                    }
                } else {
                    object2 = new PolicyContactRenameDlg(this.propertyBook.getComponent(), PolicyResource.get("PolicyContactRenameTitle"), PolicyResource.get("PolicyContactRename"), "usercontactfolderedit", ((ContactListItem)object3).getDisplayName());
                    ((PolicyContactRenameDlg)object2).show();
                    this.fixFocus();
                    if (((PolicyContactRenameDlg)object2).getName() != null) {
                        ((ContactListItem)object3).setDisplayName(((PolicyContactRenameDlg)object2).getName());
                        this.m_treeModel.reload();
                        this.propertyBook.setModified(true, (PageSnapin)this.pageSnapin);
                    }
                }
            }
        } else if (object5 == this.m_btnRemove) {
            this.doRemove();
        } else if (object5 == this.m_btnLock) {
            object3 = this.m_btnLock.getIcon();
            int n = 9;
            if (object3 == this.m_iconLockClosed) {
                this.m_userNSObject.lockAttribute(n, false);
                if (this.m_userNSObject.isAttributeMerged(n, 2)) {
                    this.m_btnLock.setIcon(this.m_iconLockSystemLevelOpen);
                    this.m_btnLock.setToolTipText(UserResource.get("UserGlobalPolicyLevelUnlock"));
                } else if (this.m_userNSObject.isAttributeMerged(n, 1)) {
                    this.m_btnLock.setIcon(this.m_iconLockPolicyLevelOpen);
                    this.m_btnLock.setToolTipText(UserResource.get("UserPolicyLevelUnlock"));
                } else {
                    this.m_btnLock.setIcon(this.m_iconLockOpen);
                    this.m_btnLock.setToolTipText(UserResource.get("UserNotLocked"));
                }
            } else {
                this.m_userNSObject.lockAttribute(n, true);
                this.m_btnLock.setIcon(this.m_iconLockClosed);
                this.m_btnLock.setToolTipText(UserResource.get("UserLocked"));
            }
            this.propertyBook.setModified(true, (PageSnapin)this.pageSnapin);
        } else if (object5 == this.m_btnResetDefaultSettings) {
            object3 = new NMsgBox(this.propertyBook.getComponent(), PolicyResource.get("PolicyDefaultSettingsConfirmTitle"), PolicyResource.get("PolicyDefaultSettingsConfirm2"), 2);
            int n = object3.launch();
            this.fixFocus();
            if (n == 8) {
                this.restoreDefaultSettings();
                this.propertyBook.setModified(true, (PageSnapin)this.pageSnapin);
            }
        }
    }

    protected boolean isNodePresent(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        boolean bl = false;
        if (defaultMutableTreeNode == null) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_treeModel.getRoot();
        }
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            ContactListItem contactListItem = (ContactListItem)defaultMutableTreeNode2.getUserObject();
            if (string.equalsIgnoreCase(contactListItem.toString())) {
                bl = true;
                break;
            }
            bl = this.isNodePresent(defaultMutableTreeNode2, string);
        }
        return bl;
    }

    private boolean addUserToVec(NSObject nSObject, Vector vector, NDSNegotiator nDSNegotiator, int n) {
        Object object;
        NDSNamespace nDSNamespace = (NDSNamespace)this.m_ns;
        ObjectEntry objectEntry = nSObject.getObjectEntry();
        if (nDSNamespace.getUnrootedName(objectEntry).equals(nDSNamespace.getUnrootedName(this.nsObj.getObjectEntry()))) {
            return true;
        }
        String string = StaticUtilities.DNToLDAPFormat(((NDSNamespace)this.m_ns).getFullyTypedName(objectEntry));
        String string2 = nDSNegotiator.getAttribute(nSObject, "Full Name");
        if (string2 == null || string2.length() == 0) {
            object = nDSNegotiator.getMultiValuedAttribute(nSObject, "CN");
            string2 = (String)((Vector)object).elementAt(0);
        }
        object = nDSNegotiator.getAttribute(nSObject, "Internet Email Address");
        try {
            ContactListItem contactListItem = new ContactListItem(++this.m_iLastRecordedID, n, -1, 2, 0, string, string2, (String)object);
            vector.addElement(contactListItem);
        }
        catch (Exception exception) {
            Debug.trace("addUserToVec: Error creating ContactListItem for " + objectEntry);
            Debug.trace("addUserToVec: ex= " + exception);
            return true;
        }
        return false;
    }

    private Vector getContactVec(int n) {
        Vector vector = null;
        Debug.trace("getContactVec: iParentIndex= " + n);
        ObjectType[] objectTypeArray = new ObjectType[]{new ObjectType("User", this.m_ns, false), new ObjectType("Group", this.m_ns, false)};
        ObjectEntrySelector objectEntrySelector = new ObjectEntrySelector((Frame)this.shell.getShellFrame(), this.nsObj.getObjectEntry().getRoot());
        objectEntrySelector.setFilter("", objectTypeArray);
        objectEntrySelector.setSelectionMode(2);
        objectEntrySelector.setFederationMode(1);
        objectEntrySelector.show();
        this.fixFocus();
        ObjectEntry[] objectEntryArray = objectEntrySelector.getSelectedObjectEntries();
        if (objectEntryArray != null) {
            vector = new Vector(50, 50);
            NDSNegotiator nDSNegotiator = new NDSNegotiator();
            for (int i = 0; i < objectEntryArray.length; ++i) {
                NSObject nSObject;
                ObjectEntry objectEntry = objectEntryArray[i];
                String string = objectEntry.getFullName();
                try {
                    nSObject = nDSNegotiator.getNSObject((NDSNamespace)this.m_ns, string);
                }
                catch (Exception exception) {
                    Debug.trace("getContactVec: exception on " + string);
                    Debug.trace("getContactVec: ex= " + exception);
                    continue;
                }
                String string2 = objectEntry.getObjectType().getName();
                if (string2.equalsIgnoreCase("User")) {
                    if (!this.addUserToVec(nSObject, vector, nDSNegotiator, n)) continue;
                    continue;
                }
                if (string2.equalsIgnoreCase("Group")) {
                    Debug.trace("getContactVec: Adding members of a group");
                    Vector vector2 = nDSNegotiator.getMultiValuedAttribute(nSObject, "Member");
                    for (int j = 0; j < vector2.size(); ++j) {
                        NSObject nSObject2;
                        string = (String)vector2.elementAt(j);
                        Debug.trace("   " + j + ": " + string);
                        try {
                            nSObject2 = nDSNegotiator.getNSObject((NDSNamespace)this.m_ns, string);
                        }
                        catch (Exception exception) {
                            Debug.trace("getContactVec: exception on group member " + string);
                            Debug.trace("getContactVec: ex= " + exception);
                            continue;
                        }
                        if (!this.addUserToVec(nSObject2, vector, nDSNegotiator, n)) continue;
                    }
                    continue;
                }
                Debug.traceDlg("getContactVec: Deal with this case of " + string2);
            }
        }
        return vector;
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 127) {
            this.doRemove();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private class DefaultTreeCellRendererExt
    extends DefaultTreeCellRenderer {
        private ImageIcon iconAddUser = new ImageIcon(this.getClass().getResource("/com/novell/netmessenger/admin/common/images/user.gif"));
        private ImageIcon iconAddFolderExpanded = new ImageIcon(this.getClass().getResource("/com/novell/netmessenger/admin/common/images/folderOpened.gif"));
        private ImageIcon iconAddFolderCollapsed = new ImageIcon(this.getClass().getResource("/com/novell/netmessenger/admin/common/images/folderClosed.gif"));

        private DefaultTreeCellRendererExt() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            if (defaultMutableTreeNode.getUserObject() instanceof ContactListItem) {
                ContactListItem contactListItem = (ContactListItem)defaultMutableTreeNode.getUserObject();
                if (contactListItem.getContactType() == 2) {
                    this.setIcon(this.iconAddUser);
                } else if (contactListItem.getContactType() == 1) {
                    if (bl2) {
                        this.setIcon(this.iconAddFolderExpanded);
                    } else {
                        this.setIcon(this.iconAddFolderCollapsed);
                    }
                }
            }
            return this;
        }
    }
}

