/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.user;

import com.novell.admin.common.snapins.AdminPageSnapin;
import com.novell.admin.ns.NSObject;
import com.novell.application.console.snapin.InitSnapinInfo;
import com.novell.application.console.snapin.PageSnapin;
import com.novell.netmessenger.admin.common.Debug;
import com.novell.netmessenger.admin.policy.PolicyInformationList;
import com.novell.netmessenger.admin.policy.PolicyResource;
import com.novell.netmessenger.admin.swingext.JButtonExt;
import com.novell.netmessenger.admin.swingext.JLabelExt;
import com.novell.netmessenger.admin.user.UserAdminPage;
import com.novell.netmessenger.admin.user.UserResource;
import com.novell.utility.nmsgbox.NMsgBox;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.Icon;

public class UserPanelInformationList
extends UserAdminPage
implements ActionListener {
    private PolicyInformationList m_listSelectedAttributes;
    private JLabelExt m_lblLock;
    protected JButtonExt m_btnResetDefaultSettings;

    public UserPanelInformationList(InitSnapinInfo initSnapinInfo, AdminPageSnapin adminPageSnapin, NSObject nSObject) {
        super(initSnapinInfo, adminPageSnapin, nSObject);
    }

    protected void init() {
        this.m_listSelectedAttributes = new PolicyInformationList(this.propertyBook.getComponent(), this.nsObj.getObjectEntry());
        this.m_btnResetDefaultSettings = new JButtonExt(PolicyResource.get("RestoreDefaultSettingsButton"));
        this.m_btnResetDefaultSettings.addActionListener(this);
        this.m_lblLock = new JLabelExt((Icon)this.m_iconLockOpen, null);
    }

    public void layoutControls() {
        this.init();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        JLabelExt jLabelExt = new JLabelExt(PolicyResource.get("PolicyInformationListSelectedAttributes"), this.m_listSelectedAttributes);
        this.setLayout(new GridBagLayout());
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.add(jLabelExt, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.add(this.m_lblLock, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        this.add(this.m_listSelectedAttributes, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        this.add(this.m_btnResetDefaultSettings, gridBagConstraints);
    }

    public void readData() {
        Vector vector = this.m_userNSObject.getInformationDisplayList();
        if (vector != null) {
            DefaultListModel defaultListModel = (DefaultListModel)this.m_listSelectedAttributes.getModel();
            for (int i = 0; i < vector.size(); ++i) {
                defaultListModel.addElement((String)vector.elementAt(i));
            }
        }
        this.initMergeIcons();
        this.initLocks();
        this.m_listSelectedAttributes.addListDataListener(this);
    }

    protected void initMergeIcons() {
        if (this.m_userNSObject.isAttributeMerged(10, 2)) {
            this.m_lblLock.setIcon(this.m_iconLockSystemLevelOpen);
            this.m_lblLock.setToolTipText(UserResource.get("UserGlobalPolicyLevelUnlock"));
        } else if (this.m_userNSObject.isAttributeMerged(10, 1)) {
            this.m_lblLock.setIcon(this.m_iconLockPolicyLevelOpen);
            this.m_lblLock.setToolTipText(UserResource.get("UserPolicyLevelUnlock"));
        } else {
            this.m_lblLock.setIcon(this.m_iconLockOpen);
            this.m_lblLock.setToolTipText(UserResource.get("UserNotLocked"));
        }
    }

    protected void initLocks() {
        if (this.m_userNSObject.isAttributeLocked(10, 2)) {
            this.setUIEnabled(false);
            this.m_lblLock.setIcon(this.m_iconLockSystemLevel);
            this.m_lblLock.setToolTipText(UserResource.get("UserGlobalPolicyLevelLock"));
        } else if (this.m_userNSObject.isAttributeLocked(10, 1)) {
            this.setUIEnabled(false);
            this.m_lblLock.setIcon(this.m_iconLockPolicyLevel);
            this.m_lblLock.setToolTipText(UserResource.get("UserPolicyLevelLock"));
        } else if (this.m_userNSObject.isAttributeLocked(10)) {
            this.m_lblLock.setIcon(this.m_iconLockClosed);
            this.m_lblLock.setToolTipText(UserResource.get("UserLocked"));
        }
    }

    protected void setUIEnabled(boolean bl) {
        this.m_listSelectedAttributes.setEnabled(bl);
        this.m_lblLock.setEnabled(bl);
        this.m_btnResetDefaultSettings.setEnabled(bl);
    }

    public boolean saveData() {
        if (this.m_listSelectedAttributes.isModified()) {
            this.m_userNSObject.setInformationDisplayList(this.m_listSelectedAttributes.getInformationList());
        }
        return true;
    }

    protected void restoreDefaultSettings() {
        this.m_userNSObject.restoreDefaultSettings(10);
        DefaultListModel defaultListModel = (DefaultListModel)this.m_listSelectedAttributes.getModel();
        defaultListModel.clear();
        this.readData();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_btnResetDefaultSettings) {
            NMsgBox nMsgBox = new NMsgBox(this.propertyBook.getComponent(), PolicyResource.get("PolicyDefaultSettingsConfirmTitle"), PolicyResource.get("PolicyDefaultSettingsConfirm2"), 2);
            int n = nMsgBox.launch();
            this.fixFocus();
            if (n == 8) {
                this.restoreDefaultSettings();
                this.propertyBook.setModified(true, (PageSnapin)this.pageSnapin);
            }
        } else {
            Debug.traceDlg("PolicyPanelInformationList.actionPerformed: deal with eventSource= " + object);
        }
    }
}

