/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.user;

import com.novell.admin.common.snapins.AdminPageSnapin;
import com.novell.admin.ns.NSObject;
import com.novell.application.console.snapin.InitSnapinInfo;
import com.novell.application.console.snapin.PageSnapin;
import com.novell.netmessenger.admin.policy.PolicyCustomStatusList;
import com.novell.netmessenger.admin.policy.PolicyResource;
import com.novell.netmessenger.admin.policy.PolicyStatusItem;
import com.novell.netmessenger.admin.swingext.JButtonExt;
import com.novell.netmessenger.admin.swingext.JLabelExt;
import com.novell.netmessenger.admin.user.UserAdminPage;
import com.novell.netmessenger.admin.user.UserResource;
import com.novell.utility.nmsgbox.NMsgBox;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.Icon;

public class UserPanelStatus
extends UserAdminPage
implements ActionListener {
    private PolicyCustomStatusList m_listCustomStatus;
    private JButtonExt m_btnLock;
    protected JButtonExt m_btnResetDefaultSettings;

    public UserPanelStatus(InitSnapinInfo initSnapinInfo, AdminPageSnapin adminPageSnapin, NSObject nSObject) {
        super(initSnapinInfo, adminPageSnapin, nSObject);
    }

    protected void init() {
        this.m_listCustomStatus = new PolicyCustomStatusList(this.propertyBook.getComponent());
        this.m_btnResetDefaultSettings = new JButtonExt(PolicyResource.get("RestoreDefaultSettingsButton"));
        this.m_btnResetDefaultSettings.addActionListener(this);
        this.m_btnLock = new JButtonExt(this.m_iconLockOpen, null);
        this.m_btnLock.addActionListener(this);
    }

    public void layoutControls() {
        this.init();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 18;
        this.setLayout(new GridBagLayout());
        JLabelExt jLabelExt = new JLabelExt(PolicyResource.get("PolicyStatusCustomStatus"), this.m_listCustomStatus);
        Dimension dimension = new Dimension(this.m_iconLockSystemLevel.getIconWidth() + 15, this.m_iconLockSystemLevel.getIconHeight() + 10);
        this.m_btnLock.setPreferredSize(dimension);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        this.add(jLabelExt, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        this.add(this.m_btnLock, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.add(this.m_listCustomStatus, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        this.add(this.m_btnResetDefaultSettings, gridBagConstraints);
    }

    public void readData() {
        Vector vector = this.m_userNSObject.getCustomStatusList();
        if (vector != null) {
            DefaultListModel defaultListModel = (DefaultListModel)this.m_listCustomStatus.getModel();
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                PolicyStatusItem policyStatusItem;
                try {
                    policyStatusItem = new PolicyStatusItem((String)vector.elementAt(i));
                }
                catch (Exception exception) {
                    continue;
                }
                defaultListModel.addElement(policyStatusItem);
            }
        }
        this.initMergeIcons();
        this.initLocks();
        this.m_listCustomStatus.addListDataListener(this);
    }

    protected void initMergeIcons() {
        if (this.m_userNSObject.isAttributeMerged(19, 2)) {
            this.m_btnLock.setIcon(this.m_iconLockSystemLevelOpen);
            this.m_btnLock.setToolTipText(UserResource.get("UserGlobalPolicyLevelUnlock"));
        } else if (this.m_userNSObject.isAttributeMerged(19, 1)) {
            this.m_btnLock.setIcon(this.m_iconLockPolicyLevelOpen);
            this.m_btnLock.setToolTipText(UserResource.get("UserPolicyLevelUnlock"));
        } else {
            this.m_btnLock.setIcon(this.m_iconLockOpen);
            this.m_btnLock.setToolTipText(UserResource.get("UserNotLocked"));
        }
    }

    protected void initLocks() {
        if (this.m_userNSObject.isAttributeLocked(19, 2)) {
            this.setEnabled(false);
            this.m_btnLock.setIcon(this.m_iconLockSystemLevel);
            this.m_btnLock.setToolTipText(UserResource.get("UserGlobalPolicyLevelLock"));
        } else if (this.m_userNSObject.isAttributeLocked(19, 1)) {
            this.setEnabled(false);
            this.m_btnLock.setIcon(this.m_iconLockPolicyLevel);
            this.m_btnLock.setToolTipText(UserResource.get("UserPolicyLevelLock"));
        } else if (this.m_userNSObject.isAttributeLocked(19)) {
            this.m_btnLock.setIcon(this.m_iconLockClosed);
            this.m_btnLock.setToolTipText(UserResource.get("UserLocked"));
        }
    }

    public boolean saveData() {
        if (this.m_listCustomStatus.isModified()) {
            Vector<String> vector = null;
            DefaultListModel defaultListModel = (DefaultListModel)this.m_listCustomStatus.getModel();
            Enumeration enumeration = defaultListModel.elements();
            if (enumeration != null) {
                vector = new Vector<String>();
                while (enumeration.hasMoreElements()) {
                    PolicyStatusItem policyStatusItem = (PolicyStatusItem)enumeration.nextElement();
                    vector.addElement(policyStatusItem.toStringExt());
                }
            }
            this.m_userNSObject.setCustomStatusList(vector);
        }
        return true;
    }

    public void setEnabled(boolean bl) {
        this.m_btnLock.setEnabled(bl);
        this.m_listCustomStatus.setEnabled(bl);
        this.m_btnResetDefaultSettings.setEnabled(bl);
    }

    protected void restoreDefaultSettings() {
        this.m_userNSObject.restoreDefaultSettings(19);
        DefaultListModel defaultListModel = (DefaultListModel)this.m_listCustomStatus.getModel();
        defaultListModel.clear();
        this.readData();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_btnLock) {
            Icon icon = this.m_btnLock.getIcon();
            int n = 19;
            if (icon == this.m_iconLockClosed) {
                this.m_userNSObject.lockAttribute(n, false);
                if (this.m_userNSObject.isAttributeMerged(n, 2)) {
                    this.m_btnLock.setIcon(this.m_iconLockSystemLevelOpen);
                    this.m_btnLock.setToolTipText(UserResource.get("UserGlobalPolicyLevelUnlock"));
                } else if (this.m_userNSObject.isAttributeMerged(n, 1)) {
                    this.m_btnLock.setIcon(this.m_iconLockPolicyLevelOpen);
                    this.m_btnLock.setToolTipText(UserResource.get("UserPolicyLevelUnlock"));
                } else {
                    this.m_btnLock.setIcon(this.m_iconLockOpen);
                    this.m_btnLock.setToolTipText(UserResource.get("UserNotLocked"));
                }
            } else {
                this.m_userNSObject.lockAttribute(n, true);
                this.m_btnLock.setIcon(this.m_iconLockClosed);
                this.m_btnLock.setToolTipText(UserResource.get("UserLocked"));
            }
            this.propertyBook.setModified(true, (PageSnapin)this.pageSnapin);
        } else if (actionEvent.getSource() == this.m_btnResetDefaultSettings) {
            NMsgBox nMsgBox = new NMsgBox(this.propertyBook.getComponent(), PolicyResource.get("PolicyDefaultSettingsConfirmTitle"), PolicyResource.get("PolicyDefaultSettingsConfirm2"), 2);
            int n = nMsgBox.launch();
            this.fixFocus();
            if (n == 8) {
                this.restoreDefaultSettings();
                this.propertyBook.setModified(true, (PageSnapin)this.pageSnapin);
            }
        }
    }
}

