/*
 * Decompiled with CFR 0.152.
 */
package com.novell.netmessenger.admin.user;

import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.application.console.snapin.InitSnapinInfo;
import com.novell.application.console.snapin.MenuSnapin;
import com.novell.application.console.snapin.NamespaceSnapin;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryCollection;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import com.novell.application.console.snapin.ObjectType;
import com.novell.application.console.snapin.PopupMenuSnapin;
import com.novell.application.console.snapin.Shell;
import com.novell.application.console.snapin.context.MenuSnapinContext;
import com.novell.application.console.snapin.context.PopupMenuSnapinContext;
import com.novell.application.console.snapin.context.SnapinContext;
import com.novell.application.console.util.objectentryselector.ObjectEntrySelector;
import com.novell.netmessenger.admin.common.NDSNegotiator;
import com.novell.netmessenger.admin.policy.PolicyNSObject;
import com.novell.netmessenger.admin.user.UserResource;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class UserSnapinPolicy
implements MenuSnapin,
PopupMenuSnapin,
ActionListener {
    private Shell m_objShell;
    private NDSNamespace m_ns;
    private String m_sMenuLocation;
    private JMenuItem m_menuPolicy;
    private JMenu[] m_aNMMenu;

    public JMenuItem[] getMenuItems() {
        this.m_menuPolicy = new JMenuItem(UserResource.get("UserMenuAddPolicy"));
        this.m_menuPolicy.addActionListener(this);
        this.m_aNMMenu = new JMenu[1];
        this.m_aNMMenu[0] = new JMenu(UserResource.get("UserMenuNetMessenger"));
        this.m_aNMMenu[0].add(this.m_menuPolicy);
        this.m_aNMMenu[0].addActionListener(this);
        return this.m_aNMMenu;
    }

    public String getMenuLocation() {
        return this.m_sMenuLocation;
    }

    public String getSnapinName() {
        return "UserSetPolicy";
    }

    public String getSnapinDescription() {
        return "Set Messenger user policy";
    }

    public boolean initSnapin(InitSnapinInfo initSnapinInfo) {
        this.m_objShell = initSnapinInfo.getShell();
        SnapinContext snapinContext = initSnapinInfo.getSnapinContext();
        if (snapinContext instanceof MenuSnapinContext) {
            this.m_sMenuLocation = "Tools";
            ObjectEntryCollection objectEntryCollection = ((MenuSnapinContext)snapinContext).getObjectCollection();
            this.m_ns = (NDSNamespace)objectEntryCollection.getFirstElement().getNamespace();
        } else if (snapinContext instanceof PopupMenuSnapinContext) {
            this.m_sMenuLocation = "";
            this.m_ns = (NDSNamespace)((PopupMenuSnapinContext)snapinContext).getParentObjectEntry().getNamespace();
        }
        return true;
    }

    public void shutdownSnapin() {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        NSObject nSObject;
        Object object = actionEvent.getSource();
        if (object == null) {
            return;
        }
        if (!object.equals(this.m_menuPolicy)) {
            return;
        }
        ObjectType[] objectTypeArray = new ObjectType[]{new ObjectType("nnmPolicy", (NamespaceSnapin)this.m_ns, false)};
        String string = this.getObjectSelection(this.m_ns, objectTypeArray);
        if (string == null) {
            return;
        }
        NDSNegotiator nDSNegotiator = new NDSNegotiator();
        ObjectEntryEnumeration objectEntryEnumeration = this.m_objShell.getCurrentSelections().elements();
        try {
            nSObject = nDSNegotiator.getNSObject(this.m_ns, string);
        }
        catch (Exception exception) {
            nSObject = null;
        }
        Vector<String> vector = nDSNegotiator.getMultiValuedAttribute(nSObject, PolicyNSObject.SA_POLICY_ATTRIBUTES[21]);
        if (vector == null) {
            vector = new Vector<String>(20, 20);
        }
        while (objectEntryEnumeration.hasMoreElements()) {
            ObjectEntry objectEntry = (ObjectEntry)objectEntryEnumeration.nextElement();
            try {
                NSObject nSObject2 = nDSNegotiator.getNSObject(this.m_ns, objectEntry.getFullName());
                String string2 = nDSNegotiator.getAttribute(nSObject2, "nnmPolicyDN");
                if (string.equals(string2)) continue;
                if (string2 != null) {
                    try {
                        NSObject nSObject3 = nDSNegotiator.getNSObject(this.m_ns, string2);
                        Vector vector2 = nDSNegotiator.getMultiValuedAttribute(nSObject3, PolicyNSObject.SA_POLICY_ATTRIBUTES[21]);
                        if (vector2 != null) {
                            vector2.removeElement(this.m_ns.getUnrootedName(objectEntry));
                            nDSNegotiator.setMultiValuedAttribute(nSObject3, PolicyNSObject.SA_POLICY_ATTRIBUTES[21], vector2);
                            nDSNegotiator.update(nSObject3);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                nDSNegotiator.setAttribute(nSObject2, "nnmPolicyDN", string);
                nDSNegotiator.update(nSObject2);
                if (vector.contains(this.m_ns.getUnrootedName(objectEntry))) continue;
                vector.addElement(this.m_ns.getUnrootedName(objectEntry));
            }
            catch (Exception exception) {}
        }
        if (vector.size() > 0 && nSObject != null) {
            nDSNegotiator.setMultiValuedAttribute(nSObject, PolicyNSObject.SA_POLICY_ATTRIBUTES[21], vector);
            nDSNegotiator.update(nSObject);
        }
    }

    private String getObjectSelection(NDSNamespace nDSNamespace, ObjectType[] objectTypeArray) {
        ObjectEntry objectEntry;
        ObjectEntrySelector objectEntrySelector = new ObjectEntrySelector((Frame)this.m_objShell.getShellFrame());
        objectEntrySelector.setFilter("", objectTypeArray);
        objectEntrySelector.setSelectionMode(0);
        objectEntrySelector.setFederationMode(1);
        objectEntrySelector.show();
        ObjectEntry[] objectEntryArray = objectEntrySelector.getSelectedObjectEntries();
        if (objectEntryArray != null && (objectEntry = objectEntryArray[0]) != null) {
            return nDSNamespace.getUnrootedName(objectEntry);
        }
        return null;
    }
}

