-- Novell Messenger ASN1 Schema Definition
-- VeRsIoN=NovellMessenger 2.1
-- CoPyRiGhT=(c) Copyright 2003-2010, Novell, Inc. All rights reserved

-- Object ID Syntax
------------------------------------------------------------------------------
------------------------------------------------------------------------------
-- ASN1 Object ID's Defined as Follows:
--     joint-iso-ccitt(2) country(16) us(840) organization(1)
--     Novell(113719) applications(1) Messenger(323) MessengerAttributeType(4)
--														MessengerAttributeSyntax(5)
--                                            			MessengerObjectClass(6)
------------------------------------------------------------------------------

NovellMessengerSchemaExtensions { 2 16 840 1 113719 1 323 } DEFINITIONS ::=
BEGIN

------------------------------------------------------------------------------
-- 
-- Novell Messenger schema extensions
-- 
------------------------------------------------------------------------------

------------------------------------------------------------------------------
-- New Attributes
------------------------------------------------------------------------------

------------------------------------------------------------------------------
-- Name      : nnmArchive
-- Desc      : Specifies whether session archiving is enabled or disabled.
-- Values    : [0 | 1]  (1 = TRUE, else FALSE)
-- Used by   : nnmPolicy, User, nnmChat
------------------------------------------------------------------------------
"nnmArchive" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 1 }
}

------------------------------------------------------------------------------
-- Name      : nnmArchiveACL
-- Desc      : Specifies a list of users who have access to search and view 
--             the system archive.
-- Used by   : nnmSystem
------------------------------------------------------------------------------
"nnmArchiveACL" ATTRIBUTE ::=
{
	SyntaxID	SYN_DIST_NAME,
	Flags		{ DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 2 }
}

------------------------------------------------------------------------------
-- Name      : nnmArchiveDelay
-- Desc      : Specifies a number of hours after midnight to start 
--             maintenance (on the session archive).
-- Values    : value > 0  (Default = 0 hours - Start maintenace at midnight)
-- Used by   : nnmSystem, nnmArchiveAgent
------------------------------------------------------------------------------
"nnmArchiveDelay" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 3 }
}

------------------------------------------------------------------------------
-- Name      : nnmArchiveExpire
-- Desc      : Specifies the expiration policy for sessions stored in the 
--             archive. Those sessions older than ## days will be removed from
--             the store.
-- Values    : value >= 0  (Default = 0 days - Do NOT expire)
-- Used by   : nnmSystem, nnmArchiveAgent 
------------------------------------------------------------------------------
"nnmArchiveExpire" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 4 }
}

------------------------------------------------------------------------------
-- Name      : nnmArchiveInterval
-- Desc      : Specifies a number of hours between maintenance cycles 
--             (on the session archive).
-- Values    : value > 0  (Default = 4 hours)
-- Used by   : nnmSystem, nnmArchiveAgent
------------------------------------------------------------------------------
"nnmArchiveInterval" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 5 }
}

------------------------------------------------------------------------------
-- Name      : nnmArchiveList
-- Desc      : Specifies a list of Archive Agents that will be used to store 
--             sessions and search archives. This list is specified by the 
--             administrator.
-- Note      : Only Archive Agents with a local data store may be in this list.
-- Used by   : nnmSystem
------------------------------------------------------------------------------
"nnmArchiveList" ATTRIBUTE ::=
{
	SyntaxID	SYN_DIST_NAME,
	Flags		{ DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 6 }
}

------------------------------------------------------------------------------
-- Name      : nnmArchiveMaster
-- Desc      : Pointer to the Archive Agent that will be used to store 
--             sessions and search the archive.
-- Note      : This is only used when the archive type ("nnmArchiveType") is
--             set to "Central".
-- Used by   : nnmSystem
------------------------------------------------------------------------------
"nnmArchiveMaster" ATTRIBUTE ::=
{
	SyntaxID	SYN_DIST_NAME,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 7 }
}

------------------------------------------------------------------------------
-- Name      : nnmArchivePassphrase
-- Desc      : Specifies the passphrase to use when encrypting/decrypting the
--             store.
-- Note      : If this attribute has a value (non-whitespace) then encryption 
--             (for the archive store) is enabled. Otherwise, encryption is 
--             disabled.
-- Used by   : nnmSystem, nnmArchiveAgent
------------------------------------------------------------------------------
"nnmArchivePassphrase" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 8 }
}

------------------------------------------------------------------------------
-- Name      : nnmArchiveSessionTimeout
-- Desc      : Specifies how long (in minutes) a session must be inactive
--             before it times out and is archived (assuming the policy 
--             requires archiving).
-- Values    : value >= 0  (Default = 5 minutes)
-- Used by   : nnmSystem, nnmArchiveAgent 
------------------------------------------------------------------------------
"nnmArchiveSessionTimeout" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 9 }
}

------------------------------------------------------------------------------
-- Name      : nnmArchiveType
-- Desc      : Specifies whether archiving is "Central" (one data store) or 
--             "Distributed".
-- Values    : [0 | 1]  (1 = Distributed, else Central)
-- Used by   : nnmSystem
------------------------------------------------------------------------------
"nnmArchiveType" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 10 }
}

------------------------------------------------------------------------------
-- Name      : nnmBlocking
-- Desc      : Specifies whether the blocking default for everyone else is
--			   allow or deny.
-- Values    : [ 0 | 1 ] 
--			   0 = Allow (Default)
--             1 = Deny
-- Note      : *CLIENT SETTING
-- Used by   : nnmPolicy, User
------------------------------------------------------------------------------
"nnmBlocking" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 11 }
}

------------------------------------------------------------------------------
-- Name      : nnmBlockingAdminAllowList
-- Desc      : Specifies an additional list of admininstrator specified users 
--			   that are granted access to a user's presence. 
-- Note      : This attribute is a list of DISTINGUISHED NAMES.
-- Used by   : nnmPolicy, User
------------------------------------------------------------------------------
"nnmBlockingAdminAllowList" ATTRIBUTE ::=
{
	SyntaxID	SYN_DIST_NAME,
	Flags		{ DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 12 }
}

------------------------------------------------------------------------------
-- Name      : nnmBlockingAdminDenyList
-- Desc      : Specifies an additional list of admininstrator specified users 
--			   that are denied access to a user's presence. 
-- Note      : This attribute is a list of DISTINGUISHED NAMES.
-- Used by   : nnmPolicy, User
------------------------------------------------------------------------------
"nnmBlockingAdminDenyList" ATTRIBUTE ::=
{
	SyntaxID	SYN_DIST_NAME,
	Flags		{ DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 13 }
}

------------------------------------------------------------------------------
-- Name      : nnmBlockingAllowList
-- Desc      : Specifies a list of users granted access to a user's presence.
-- Note      : This attribute is a list of DISTINGUISHED NAMES.
--             *CLIENT SETTING
-- Used by   : nnmPolicy, User
------------------------------------------------------------------------------
"nnmBlockingAllowList" ATTRIBUTE ::=
{
	SyntaxID	SYN_DIST_NAME,
	Flags		{ DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 14 }
}

------------------------------------------------------------------------------
-- Name      : nnmBlockingDenyList
-- Desc      : Specifies a list of users denied access to a user's presence.
-- Note      : This attribute is a list of DISTINGUISHED NAMES.
--             *CLIENT SETTING
-- Used by   : nnmPolicy, User
------------------------------------------------------------------------------
"nnmBlockingDenyList" ATTRIBUTE ::=
{
	SyntaxID	SYN_DIST_NAME,
	Flags		{ DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 15 }
}

------------------------------------------------------------------------------
-- Name      : nnmCertPath
-- Desc      : Specifies a UNC Path or relative path to the directory where
--             the certificate files are located.
-- Used by   : nnmServer, nnmAgent
------------------------------------------------------------------------------
"nnmCertPath" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 16 }
}

------------------------------------------------------------------------------
-- Name      : nnmClientDate
-- Desc      : Specifies the minimum required client date (24-Hour).
-- Format	 : dd/mm/yyyy 14:10
-- Used by   : nnmSystem
------------------------------------------------------------------------------
"nnmClientDate" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 17 }
}

------------------------------------------------------------------------------
-- Name      : nnmClientDownload
-- Desc      : Specifies whether  users can download the client from the agent
-- Values    : [0 | 1]  (1 = TRUE, else FALSE)
-- Used by   : nnmSystem, nnmMessagingAgent
------------------------------------------------------------------------------
"nnmClientDownload" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 18 }
}

------------------------------------------------------------------------------
-- Name      : nnmClientGraceLogins
-- Desc      : Specifies the maximum number of times older clients are allowed
--			   to login without updating to the new client.
-- Used by   : nnmSystem
------------------------------------------------------------------------------
"nnmClientGraceLogins" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 19 }
}

------------------------------------------------------------------------------
-- Name      : nnmClientSettings
-- Desc      : List of client settings. The format includes a "tag" and 
--             "value".
-- Format    : TAG:VALUE
--             TAG  = Alphanumeric string representing the setting tag
--             VALUE= Alphanumeric string representing the setting value
-- Example   : PathToStore:\\xyz\a\b
--             StoreIndexInterval:5
-- Used by   : User
------------------------------------------------------------------------------
"nnmClientSettings" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 20 }
}

------------------------------------------------------------------------------
-- Name      : nnmClientVersion
-- Desc      : Specifies the minimum required client version 
-- Example	 : 1.0
-- Used by   : nnmSystem
------------------------------------------------------------------------------
"nnmClientVersion" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 21 }
}

------------------------------------------------------------------------------
-- Name      : nnmContactList
-- Desc      : List of contacts (includes folders and contact items)
-- Format	 : Object Id;Parent Id;Sequence#;Type;Status;userDN;displayName;reserved
--			   Object Id	= Unique object id
--			   Parent Id	= Identifier representing parent (folder)
--			   Sequence #	= 0 based ordering for a given parent id
--			   Type			= Object type
--								Values: [ 0 | 1 | 2 ] (0 = Unknown, 1= Folder, 2 = Contact)
--			   Status		= Object status flags (currently, only apply to folder)
--								Values: [ 0 | 1 ] (0 = Expanded, 1 = Collapsed)
--			   User DN		= Typed DN of contact
--			   Display Name	= Object display name
-- Note      : *CLIENT SETTING
-- Used by   : nnmPolicy, User
------------------------------------------------------------------------------
"nnmContactList" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 22 }
}

------------------------------------------------------------------------------
-- Name      : nnmCustomStatusList
-- Desc      : List of custom status messages.
-- Format    : #;Title;Auto-Response
--             #				= Status type (3 = Busy, 4 = Away)
--             Title			= Status text
--             Auto-Response	= Auto-response message
-- Used by   : nnmPolicy, User
------------------------------------------------------------------------------
"nnmCustomStatusList" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 23 }
}

------------------------------------------------------------------------------
-- Name		 : nnmDefaultHost
-- Desc		 : Pointer to a host ("nnmHost") object 
-- Used by	 : nnmPolicy, User
------------------------------------------------------------------------------
"nnmDefaultHost" ATTRIBUTE ::=
{
	SyntaxID	SYN_DIST_NAME,
	Flags		{  DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 24 }
}

------------------------------------------------------------------------------
-- Name      : nnmDescription
-- Desc      : Description for server or agent
-- Used by   : nnmServer, nnmAgent, nnmChat
------------------------------------------------------------------------------
"nnmDescription" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 25 }
}

------------------------------------------------------------------------------
-- Name      : nnmDiskCheckDelay
-- Desc      : Specifies the time interval (in hours) to wait before notifying
--             the administrator about an already reported disk space problem.
-- Values    : value > 0  (Default = 1 hour)
-- Used by   : nnmServer, nnmAgent
------------------------------------------------------------------------------
"nnmDiskCheckDelay" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 26 }
}

------------------------------------------------------------------------------
-- Name      : nnmDiskCheckInterval
-- Desc      : Specifies the time interval (in minutes) to check the 
--             available disk space.
-- Values    : value >= 0  (Default = 10 minutes, 0 = Do NOT check disk space)
-- Used by   : nnmServer, nnmAgent
------------------------------------------------------------------------------
"nnmDiskCheckInterval" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 27 }
}

------------------------------------------------------------------------------
-- Name      : nnmFileMaxReceiveSize
-- Desc      : Specifies the maximum size (kb) of a file that may be received 
--			   from another user.
-- Values    : value >= 0 (if 0, then file receiving is NOT allowed)
-- Used by   : nnmPolicy, User
------------------------------------------------------------------------------
"nnmFileMaxReceiveSize" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 28 }
}

------------------------------------------------------------------------------
-- Name      : nnmFileMaxSendSize
-- Desc      : Specifies the maximum size (kb) of a file that may be sent to 
--			   another user.
-- Values    : value >= 0 (if 0, then file sending is NOT allowed)
-- Used by   : nnmPolicy, User
------------------------------------------------------------------------------
"nnmFileMaxSendSize" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 29 }
}

------------------------------------------------------------------------------
-- Name      : nnmFileTransfer
-- Desc      : Specifies whether file transfer is disabled, enabled with the
--			   server only, or enabled for peer-to-peer (including server).
-- Values    : [ 0 | 1 | 2 ] 
--			   0 = Disabled
--             1 = Enabled w/ server only
--             2 = Enabled w/ Peer-to-Peer support
-- Used by   : nnmPolicy, User
------------------------------------------------------------------------------
"nnmFileTransfer" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 30 }
}

------------------------------------------------------------------------------
-- Name      : nnmFileTransferPath
-- Desc      : Specifies a UNC Path or relative path to the directory where
--             uploaded files are stored.
-- Used by   : nnmMessagingAgent
------------------------------------------------------------------------------
"nnmFileTransferPath" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 31 }
}

------------------------------------------------------------------------------
-- Name      : nnmHostList
-- Desc      : List of nnmHost objects that apply to this system.
-- Used by   : nnmSystem
------------------------------------------------------------------------------
"nnmHostList" ATTRIBUTE ::=
{
	SyntaxID	SYN_DIST_NAME,
	Flags		{ DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 32 }
}

------------------------------------------------------------------------------
-- Name		: nnmHostName
-- Desc		: A host name.
-- Example  : xyz.com
-- Used by  : nnmHost
------------------------------------------------------------------------------
"nnmHostName" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 33 }
}

------------------------------------------------------------------------------
-- Name      : nnmInformationDisplayList
-- Desc      : Specifies a list of directory attributes that may be displayed \
--			   for a particular user.
-- Used by   : nnmPolicy, User
------------------------------------------------------------------------------
"nnmInformationDisplayList" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 34 }
}

------------------------------------------------------------------------------
-- Name      : nnmIPAddress
-- Desc      : IP/DNS address for this server
-- Used by   : nnmServer, nnmAgent
------------------------------------------------------------------------------
"nnmIPAddress" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 35 }
}

------------------------------------------------------------------------------
-- Name      : nnmIPAddressBind
-- Desc      : Specifies whether an agent should bind to the address specified 
--             in the "nnmIPAddress" attribute. Otherwise, the agent should 
--             listen on all available addresses.
-- Values    : [0 | 1]  (1 = TRUE, else FALSE)
-- Note      : If this value "FALSE" the agent should listen on all available 
--             addresses.
-- Used by   : nnmServer, nnmAgent
------------------------------------------------------------------------------
"nnmIPAddressBind" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 36 }
}

------------------------------------------------------------------------------
-- Name		: nnmLastLogin
-- Desc		: Specifies the last date/time the user logged into the Novell
--			  Messenger system.
-- Format	: The value will be a number representing the number of seconds 
--			  since January 1, 1970.
-- Used by	: User
------------------------------------------------------------------------------
"nnmLastLogin" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 37 }
}

------------------------------------------------------------------------------
-- Name      : nnmLDAPAdditionalDNs
-- Desc      : List of available DNs that may be used for searching
-- Format    : #:DN
--             #  = Numeric value used to specify sequence
--             DN = A "Typed" DN. This value may also include an asterisk(*)
--                  which will specify that the scope is the "whole subtree".
-- Example   : 1:ou=sales,ou=americas,o=Novell
--             2:*,ou=emea,o=Novell
-- Used by   : nnmLDAPProfile
------------------------------------------------------------------------------
"nnmLDAPAdditionalDNs" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 38 }
}

------------------------------------------------------------------------------
-- Name      : nnmLDAPBaseDN
-- Desc      : BaseDN of the LDAP directory to start searching for objects.
--             If this attribute is not available, then searching will begin
--             at the root of the LDAP server (as defined by the server).
-- Format    : The format of this attribute is LDAP "typed" representation of
--             the DN (e.g., ou=sales, ou=americas, o=Novell).
-- Example   : ou=sales,ou=americas,o=novell
-- Used by   : nnmLDAPProfile
------------------------------------------------------------------------------
"nnmLDAPBaseDN" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 39 }
}

------------------------------------------------------------------------------
-- Name      : nnmLDAPBaseScope
-- Desc      : Scope level which limits searching to the base DN, single level
--             or whole subtree.
-- Values    : [0 | 1 | 2]
--             0 = Only search base DN (Default if no value)
--             1 = Search base DN and one level below
--             2 = Search whole subtree
-- Used by   : nnmLDAPProfile
------------------------------------------------------------------------------
"nnmLDAPBaseScope" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 40 }
}

------------------------------------------------------------------------------
-- Name      : nnmLDAPConnection
-- Desc      : LDAP Server Connection information
-- Format    : Address,Port,SSL,RootCert,Weight
--             Address = LDAP Server IP/DNS Address
--             Port    = LDAP Server Port
--             SSL     = Specifies whether encrypted communication via SSL
--                       is enabled or disabled. 
--                       Values: [0 | 1]   (Non-secure / Secure)
--                       Default: 0
--             RootCert= Specifies a UNC Path/Filename, relative path/filename, 
--                       or filename to the root certificate (to be used for 
--                       communicating with the LDAP server).
--             Weight  = Numeric value used to specify servers for pooling and
--                       failover. The lower the number the higher its priority.
--                       Default: 0
-- Example   : ldap.xyz.com,389,0,,5
--             100.1.1.10,636,1,myrootcert.der,5
-- Used by   : nnmLDAPProfile
------------------------------------------------------------------------------
"nnmLDAPConnection" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 41 }
}

------------------------------------------------------------------------------
-- Name      : nnmLDAPDefaultConnections
-- Desc      : Number of connections that will be created for each (LDAP) 
--             server upon LDAP initialization.
-- Values    : value > 0  (Default = 10)
-- Used by   : nnmLDAPProfile
------------------------------------------------------------------------------
"nnmLDAPDefaultConnections" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 42 }
}

------------------------------------------------------------------------------
-- Name      : nnmLDAPIdleTimeout
-- Desc      : Specifies the maximum time (in seconds) a connection will be 
--             idle before being closed.
-- Values    : value > 0  (Default = 300 seconds)
-- Used by   : nnmLDAPProfile
------------------------------------------------------------------------------
"nnmLDAPIdleTimeout" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 43 }
}

------------------------------------------------------------------------------
-- Name      : nnmLDAPMaxConnections
-- Desc      : Specifies the maximum number of connections that can be used 
--             for each server.
-- Values    : value > 0  (Default = 30)
-- Used by   : nnmLDAPProfile
------------------------------------------------------------------------------
"nnmLDAPMaxConnections" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 44 }
}

------------------------------------------------------------------------------
-- Name      : nnmLDAPProfileDN
-- Desc      : Pointer to an LDAP Profile object ("nnmLDAPProfile") which 
--             contains LDAP connection information.
-- Used by   : nnmSystem, nnmServer, nnmAgent
------------------------------------------------------------------------------
"nnmLDAPProfileDN" ATTRIBUTE ::=
{
	SyntaxID	SYN_DIST_NAME,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 45 }
}

------------------------------------------------------------------------------
-- Name      : nnmLDAPProxy
-- Desc      : User credentials to use for authentication to the LDAP 
--             server.
-- Used by   : nnmLDAPProfile
------------------------------------------------------------------------------
"nnmLDAPProxy" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 46 }
}

------------------------------------------------------------------------------
-- Name      : nnmLDAPQueryMaxResults
-- Desc      : Specifies the maximum number of results that should be 
--             returned.
-- Values    : value > 0  (Default = 100)
-- Used by   : nnmLDAPProfile
------------------------------------------------------------------------------
"nnmLDAPQueryMaxResults" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 47 }
}

------------------------------------------------------------------------------
-- Name      : nnmLDAPQueryTimeout
-- Desc      : Specifies the maximum time (in seconds) to wait for a query 
--             to return.
-- Values    : value > 0  (Default = 30 seconds)
-- Used by   : nnmLDAPProfile
------------------------------------------------------------------------------
"nnmLDAPQueryTimeout" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 48 }
}

------------------------------------------------------------------------------
-- Name      : nnmLDAPReferral
-- Desc      : Specifies whether LDAP referrals should be followed (if 
--             returned from the LDAP Server)
-- Values    : [0 | 1]  (1 = True, else FALSE)
-- Used by   : nnmLDAPProfile
------------------------------------------------------------------------------
"nnmLDAPReferral" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 49 }
}

------------------------------------------------------------------------------
-- Name      : nnmLockedAttrList
-- Desc      : List of attributes that have been "locked".
-- Used by   : nnmPolicy, User
------------------------------------------------------------------------------
"nnmLockedAttrList" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 50 }
}

------------------------------------------------------------------------------
-- Name      : nnmLogLevel
-- Desc      : Specifies the logging level (None, Normal, Verbose, Diagnostic)
-- Values    : [0 | 1 | 2 | 3]
--             0 = None
--             1 = Normal
--             2 = Verbose
--             3 = Diagnostic
-- Used by   : nnmAgent
------------------------------------------------------------------------------
"nnmLogLevel" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 51 }
}

------------------------------------------------------------------------------
-- Name      : nnmLogMaxAge
-- Desc      : Specifies the maximum number of days for the log files to 
--			   remain on disk before being automatically deleted. 
--			   (Default = 14 Days)
-- Used by   : nnmAgent
------------------------------------------------------------------------------
"nnmLogMaxAge" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 52 }
}

------------------------------------------------------------------------------
-- Name      : nnmLogMaxSize
-- Desc      : Specifies the maximum amount of disk space for all log files.
--			   (Default = 1MB)
-- Used by   : nnmAgent
------------------------------------------------------------------------------
"nnmLogMaxSize" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 53 }
}

------------------------------------------------------------------------------
-- Name      : nnmLogPath
-- Desc      : Specifies a UNC Path or relative path to the directory where
--             the log files will be stored.
-- Used by   : nnmAgent
------------------------------------------------------------------------------
"nnmLogPath" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 54 }
}

------------------------------------------------------------------------------
-- Name      : nnmLogToDisk
-- Desc      : Specifies whether logging to disk is enabled or disabled.
-- Values    : [0 | 1]  (1 = Enabled, else Disabled)
-- Used by   : nnmAgent
------------------------------------------------------------------------------
"nnmLogToDisk" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 55 }
}

------------------------------------------------------------------------------
-- Name      : nnmMaxContacts
-- Desc      : Specifies the maximum number of contacts.
-- Values    : value > 0
-- Used by   : nnmPolicy, User
------------------------------------------------------------------------------
"nnmMaxContacts" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 56 }
}

------------------------------------------------------------------------------
-- Name      : nnmModuleBin
-- Desc      : Specifies a UNC Path/Filename, relative path/filename, or 
--             filename to the executable code for the module. If the path
--			   is not available, the code must be in the same directory as 
--			   the application.
-- Used by   : nnmModule
------------------------------------------------------------------------------
"nnmModuleBin" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 57 }
}

------------------------------------------------------------------------------
-- Name      : nnmModuleDescription
-- Desc      : General description for the module (e.g., copyright information)
-- Used by   : nnmModule
------------------------------------------------------------------------------
"nnmModuleDescription" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 58 }
}

------------------------------------------------------------------------------
-- Name      : nnmModuleName
-- Desc      : Descriptive name of the module
-- Used by   : nnmModule
------------------------------------------------------------------------------
"nnmModuleName" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 59 }
}

------------------------------------------------------------------------------
-- Name      : nnmModuleSettings
-- Desc      : List of module settings. The format includes a "tag" and 
--             "value".
-- Format    : TAG:VALUE
--             TAG  = Alphanumeric string representing the setting tag
--             VALUE= Alphanumeric string representing the setting value
-- Example   : PathToStore:\\xyz\a\b
--             StoreIndexInterval:5
-- Used by   : nnmModule
------------------------------------------------------------------------------
"nnmModuleSettings" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 60 }
}

------------------------------------------------------------------------------
-- Name      : nnmPolicyDN
-- Desc      : Pointer to a policy ("nnmPolicy") object
-- Used by   : nnmPoliciesContainer, nnmSystem, User
------------------------------------------------------------------------------
"nnmPolicyDN" ATTRIBUTE ::=
{
	SyntaxID	SYN_DIST_NAME,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 61 }
}

------------------------------------------------------------------------------
-- Name      : nnmPort
-- Desc      : Specifies the TCP/IP port for the agent to listen on.
-- Format    : TAG:VALUE
--             TAG  = Alphanumeric string representing the setting tag
--             VALUE= Alphanumeric string representing the setting value
-- Example   : C/S:7000
--             MTP:7001
-- Used by   : nnmAgent
------------------------------------------------------------------------------
"nnmPort" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 62 }
}

------------------------------------------------------------------------------
-- Name      : nnmQuery
-- Desc      : Specifies whether user searching is enabled / disabled.
-- Values    : [0 | 1]  (1 = TRUE, else FALSE)
-- Note      : *CLIENT SETTING
-- Used by   : nnmPolicy, User, nnmChat
------------------------------------------------------------------------------
"nnmQuery" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 64 }
}

------------------------------------------------------------------------------
-- Name      : nnmQueuePath
-- Desc      : Specifies a UNC Path or relative path to the directory where
--			   sessions are queued.
-- Used by   : nnmMessagingAgent, nnmArchiveAgent
------------------------------------------------------------------------------
"nnmQueuePath" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 65 }
}

------------------------------------------------------------------------------
-- Name		 : nnmReferenceList
-- Desc		 : List of "user" objects that are associated with this policy.
-- Used by	 : nnmPolicy
------------------------------------------------------------------------------
"nnmReferenceList" ATTRIBUTE ::=
{
	SyntaxID	SYN_DIST_NAME,
	Flags		{ DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 66 }
}

------------------------------------------------------------------------------
-- Name      : nnmScopeContextList
-- Desc      : Specifies a list of contexts. The format includes a sequence
--             number to allow processing of contexts in a priority order.
-- Format    : #:DN
--             #  = Numeric value used to specify sequence
--             DN = A "Typed" DN. This value may also include an asterisk(*)
--                  which will specify that the scope is the "whole subtree".
-- Example   : 1:ou=sales,ou=americas,o=Novell
--             2:*,ou=emea,o=Novell
-- Used by   : nnmScopeProfile
------------------------------------------------------------------------------
"nnmScopeContextList" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 67 }
}

------------------------------------------------------------------------------
-- Name      : nnmScopeProfileDN
-- Desc      : Pointer to a Scope Profile ("nnmScopeProfile") object which 
--             contains scope information.
-- Used by   : nnmSystem, nnmProfile, User
------------------------------------------------------------------------------
"nnmScopeProfileDN" ATTRIBUTE ::=
{
	SyntaxID	SYN_DIST_NAME,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 68 }
}

------------------------------------------------------------------------------
-- Name      : nnmServerDN
-- Desc		 : Pointer to a Novell Messenger server ("nnmServer") object.
-- Used by   : NCP Server 
------------------------------------------------------------------------------
"nnmServerDN" ATTRIBUTE ::=
{
	SyntaxID	SYN_DIST_NAME,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 69 }
}

------------------------------------------------------------------------------
-- Name      : nnmServices
-- Desc      : Specifies whether this server's (or agent's) services are 
--             enabled or disabled.
-- Values    : [0 | 1]  (1 = Enabled, else Disabled)
-- Used by   : nnmServer, nnmAgent
------------------------------------------------------------------------------
"nnmServices" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 70 }
}

------------------------------------------------------------------------------
-- Name      : nnmSNMP
-- Desc      : Specifies whether SNMP is enabled or disabled.
-- Values    : [0 | 1]  (1 = Enabled, else Disabled)
-- Used by   : nnmServer, nnmAgent
------------------------------------------------------------------------------
"nnmSNMP" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 71 }
}

------------------------------------------------------------------------------
-- Name		: nnmSNMPCommunity
-- Desc		: Specifies the SNMP community string for this server.
-- Used by	: nnmServer
------------------------------------------------------------------------------
"nnmSNMPCommunity" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 72 }
}

------------------------------------------------------------------------------
-- Name      : nnmSoftwareDescription
-- Desc      : Specifies an administrator message that will be displayed to
--			   the user when they are prompted to update their client (via
--			   auto-update).
-- Used by   : nnmSystem
------------------------------------------------------------------------------
"nnmSoftwareDescription" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 73 }
}

------------------------------------------------------------------------------
-- Name      : nnmSoftwarePath
-- Desc      : Specifies a UNC Path or relative path to the directory where
--             the client software is located
-- Used by   : nnmServer
------------------------------------------------------------------------------
"nnmSoftwarePath" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 74 }
}

------------------------------------------------------------------------------
-- Name      : nnmSSL
-- Desc      : Specifies whether TCP/IP communications should be encrypted 
--             via SSL.
-- Values    : [0 | 1]  (1 = TRUE, else FALSE)
-- Used by   : nnmServer, nnmAgent
------------------------------------------------------------------------------
"nnmSSL" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 75 }
}

------------------------------------------------------------------------------
-- Name      : nnmSSLCertFile
-- Desc      : Specifies a UNC Path/Filename, relative path/filename, or 
--             filename to the certificate file.
-- Used by   : nnmServer, nnmAgent
------------------------------------------------------------------------------
"nnmSSLCertFile" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 76 }
}

------------------------------------------------------------------------------
-- Name      : nnmSSLKeyCredentials
-- Desc      : SSL Key Credentials
-- Used by   : nnmServer, nnmAgent
------------------------------------------------------------------------------
"nnmSSLKeyCredentials" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 77 }
}

------------------------------------------------------------------------------
-- Name      : nnmSSLKeyFile
-- Desc      : Specifies a UNC Path/Filename, relative path/filename, or 
--             filename to the key file.
-- Used by   : nnmServer, nnmAgent
------------------------------------------------------------------------------
"nnmSSLKeyFile" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 78 }
}

------------------------------------------------------------------------------
-- Name      : nnmSystemDN
-- Desc      : Pointer to a Novell Messenger system ("nnmSystem") object
-- Used by   : nnmPolicy 
------------------------------------------------------------------------------
"nnmSystemDN" ATTRIBUTE ::=
{
	SyntaxID	SYN_DIST_NAME,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 79 }
}

------------------------------------------------------------------------------
-- Name      : nnmVersion
-- Desc      : Version identifier
-- Used by   : nnmSystem, nnmAgent
------------------------------------------------------------------------------
"nnmVersion" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 80 }
}

------------------------------------------------------------------------------
-- Name      : nnmWebConsoleCredentials
-- Desc      : User credentials to use when authenticating users into the
--			   web console.
-- Used by   : nnmAgent
------------------------------------------------------------------------------
"nnmWebConsoleCredentials" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 82 }
}

------------------------------------------------------------------------------
-- Name      : nnmWebConsolePort
-- Desc      : Specifies the TCP/IP port the agent will listen on for 
--			   WebConsole requests. If the value is 0, then the WebConsole
--			   is not available (disabled).
-- Values    : value >= 0
-- Used by   : nnmAgent
------------------------------------------------------------------------------
"nnmWebConsolePort" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 83 }
}

------------------------------------------------------------------------------
-- Name      : nnmWebConsoleSSL
-- Desc      : Specifies whether TCP/IP communications for the WebConsole
--			   should be encrypted via SSL.
-- Values    : [0 | 1]  (1 = TRUE, else FALSE)
-- Used by   : nnmAgent
------------------------------------------------------------------------------
"nnmWebConsoleSSL" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 84 }
}

------------------------------------------------------------------------------
-- Name      : nnmWorkPath
-- Desc      : Specifies a UNC Path or relative path for temporary files
-- Used by   : nnmServer, nnmAgent
------------------------------------------------------------------------------
"nnmWorkPath" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 85 }
}

------------------------------------------------------------------------------
-- Name      : nnmMaxFolders
-- Desc      : Specifies the maximum number of folders.
-- Values    : value > 0
-- Used by   : nnmPolicy, User
------------------------------------------------------------------------------
"nnmMaxFolders" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 86 }
}

------------------------------------------------------------------------------
-- Name      : nnmPasswordChange
-- Desc      : Specifies whether the user can change their password
-- Values    : [0 | 1]  (1 = TRUE, else FALSE)
-- Note      : *CLIENT SETTING
-- Used by   : nnmPolicy, User
------------------------------------------------------------------------------
"nnmPasswordChange" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 87 }
}

------------------------------------------------------------------------------
-- Name      : nnmClientDownloadList
-- Desc      : Specifies a list of URLs that may be used to download software.
-- Format    : #:URL
--             #  = Numeric value used to specify sequence
--             URL = A valid URL that may be used to download software
-- Example   : 1:http://128.1.1.10:7000
--             2:https://128.1.1.11:7000
-- Used by   : nnmSystem
------------------------------------------------------------------------------
"nnmClientDownloadList" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 88 }
}

------------------------------------------------------------------------------
-- Name      : nnmThreads
-- Desc      : Specifies the number of threads to use for processing requests
-- Values    : value >= 0
-- Used by   : nnmAgent
------------------------------------------------------------------------------
"nnmThreads" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 89 }
}

------------------------------------------------------------------------------
-- Name      : nnmMaxUsers
-- Desc      : Specifies the maximum number of users allowed on this agent
-- Values    : value >= 0
-- Used by   : nnmAgent, nnmChat
------------------------------------------------------------------------------
"nnmMaxUsers" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 90 }
}

------------------------------------------------------------------------------
-- Name      : nnmAgentSettings
-- Desc      : List of client settings. The format includes a "tag" and 
--             "value".
-- Format    : TAG:VALUE
--             TAG  = Alphanumeric string representing the setting tag
--             VALUE= Alphanumeric string representing the setting value
-- Example   : PathToStore:\\xyz\a\b
--             StoreIndexInterval:5
-- Used by   : nnmAgent
------------------------------------------------------------------------------
"nnmAgentSettings" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 91 }
}

------------------------------------------------------------------------------
-- Name      : nnmPasswordRemember
-- Desc      : Specifies whether a user can use the Remember Password option. 
-- Values    : [0 | 1]  (1 = TRUE, else FALSE)
-- Note      : *CLIENT SETTING
-- Used by   : nnmProfile, User
------------------------------------------------------------------------------
"nnmPasswordRemember" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 92 }
}

------------------------------------------------------------------------------
-- Name      : nnmBroadcast
-- Desc      : Specifies whether a user can broadcast. 
-- Values    : [0 | 1]  (1 = TRUE, else FALSE)
-- Note      : *CLIENT SETTING
-- Used by   : nnmProfile, User
------------------------------------------------------------------------------
"nnmBroadcast" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 93 }
}

------------------------------------------------------------------------------
-- Name      : nnmSystemBroadcast
-- Desc      : Specifies whether a user can perform a system broadcast. 
-- Values    : [0 | 1]  (1 = TRUE, else FALSE)
-- Note      : *CLIENT SETTING
-- Used by   : nnmProfile, User
------------------------------------------------------------------------------
"nnmSystemBroadcast" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 94 }
}

------------------------------------------------------------------------------
-- Name      : nnmDisplayName
-- Desc      : Name of chat object shown in Chat lists.
-- Used by   : nnmChat
------------------------------------------------------------------------------
"nnmDisplayName" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 95 }
}

------------------------------------------------------------------------------
-- Name      : nnmChatPassword
-- Desc      : The password required to enter chat room.
-- Used by   : nnmChat
------------------------------------------------------------------------------
"nnmChatPassword" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 96 }
}

------------------------------------------------------------------------------
-- Name      : nnmDisclaimer
-- Desc      : Text displayed when someone enters the chat room.
-- Used by   : nnmChat
------------------------------------------------------------------------------
"nnmDisclaimer" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 97 }
}

------------------------------------------------------------------------------
-- Name      : nnmChatOwnerDN
-- Desc      : The DN of the user who has ownership rights on the chat room.
-- Used by   : nnmChat
------------------------------------------------------------------------------
"nnmChatOwnerDN" ATTRIBUTE ::=
{
	SyntaxID	SYN_DIST_NAME,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 98 }
}

------------------------------------------------------------------------------
-- Name      : nnmChatACL
-- Desc      : Array of values denoting chat access rights.
-- Format	 : DN;Flags
--			   DN		= Typed DN of user
--			   Flags	= Number representing access flags for the user
-- Used by   : nnmChat
------------------------------------------------------------------------------
"nnmChatACL" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 99 }
}

------------------------------------------------------------------------------
-- Name      : nnmChatCreate
-- Desc      : Rights to create chat rooms.
-- Value	 : [0 | 1]  (1 = TRUE, else FALSE)
-- Used by   : nnmPolicy, User
------------------------------------------------------------------------------
"nnmChatCreate" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 100 }
}

------------------------------------------------------------------------------
-- Name      : nnmPersonalHistory
-- Desc      : Rights to save conversations in personal history files.
-- Value	 : [0 | 1]  (1 = TRUE, else FALSE)
-- Used by   : nnmPolicy, User
------------------------------------------------------------------------------
"nnmPersonalHistory" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 101 }
}

------------------------------------------------------------------------------
-- Name      : nnmPrintSave
-- Desc      : Rights to print and save files.
-- Value	 : [0 | 1]  (1 = TRUE, else FALSE)
-- Used by   : nnmPolicy, User
------------------------------------------------------------------------------
"nnmPrintSave" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 102 }
}

------------------------------------------------------------------------------
-- Name      : nnmCreatorDN
-- Desc      : The DN of the object creator.
-- Used by   : nnmChat
------------------------------------------------------------------------------
"nnmCreatorDN" ATTRIBUTE ::=
{
	SyntaxID	SYN_DIST_NAME,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 103 }
}

------------------------------------------------------------------------------
-- Name      : nnmCreatorName
-- Desc      : The name of the object creator.
-- Used by   : nnmChat
------------------------------------------------------------------------------
"nnmCreatorName" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 104 }
}

------------------------------------------------------------------------------
-- Name		: nnmCreationTime
-- Desc		: Specifies the date/time that the object was created.
-- Format	: The value will be a number representing the number of seconds 
--			  since January 1, 1970.
-- Used by	: nnmChat
------------------------------------------------------------------------------
"nnmCreationTime" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 105 }
}

------------------------------------------------------------------------------
-- Name      : nnmChatService
-- Desc      : Rights to use chat service.
-- Value	 : [0 | 1]  (1 = TRUE, else FALSE)
-- Used by   : nnmPolicy, User
------------------------------------------------------------------------------
"nnmChatService" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 106 }
}

------------------------------------------------------------------------------
-- Name      : nnmEnableConferencing
-- Desc      : Rights to use conferencing integrations.
-- Value	 : [0 | 1]  (1 = TRUE, else FALSE)
-- Used by   : nnmPolicy, User
------------------------------------------------------------------------------
"nnmEnableConferencing" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 107 }
}

------------------------------------------------------------------------------
-- Name      : nnmConferencingSettings
-- Desc      : Conferencing integration settings 
--             (semicolon delimited name/value pairs)
-- Format    : name;value
-- Used by   : nnmSystem
------------------------------------------------------------------------------
"nnmConferencingSettings" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags		{ DS_SYNC_IMMEDIATE },
	ASN1ObjID	{ 2 16 840 1 113719 1 323 4 108 }
}

------------------------------------------------------------------------------
-- New Classes
------------------------------------------------------------------------------

------------------------------------------------------------------------------
-- Name      : nnmSystem
-- Desc      : The Novell Messenger "system" class consists of those
--			   attributes that apply to the entire system. This class is also
--			   a container where all of the objects that comprise the Novell
--			   Messenger system are stored.
------------------------------------------------------------------------------
"nnmSystem" OBJECT-CLASS ::=
{
	SubClassOf 	{ "TOP" },
	ContainedBy	{ "Country", "Locality", "Organization", "Organizational Unit", "domain" },
	Flags		{ DS_EFFECTIVE_CLASS, DS_CONTAINER_CLASS },
	NamedBy		{
					"OU"
				},
	MustContain	{
					"OU",
					"nnmVersion"
				},
	MayContain	{
					"nnmHostList",
					"nnmScopeProfileDN",
					"nnmPolicyDN",
					"nnmLDAPProfileDN",
					"nnmArchiveType",
					"nnmArchiveMaster",
					"nnmArchiveList",
					"nnmArchivePassphrase",
					"nnmArchiveACL",
					"nnmArchiveDelay",
					"nnmArchiveInterval",
					"nnmArchiveExpire",
					"nnmArchiveSessionTimeout",
					"nnmSoftwareDescription",
					"nnmClientVersion",
					"nnmClientDate",
					"nnmClientGraceLogins",
					"nnmClientDownload",
					"nnmClientDownloadList",
					"nnmConferencingSettings"
				},
	ASN1ObjID	{ 2 16 840 1 113719 1 323 6 1 }
}


------------------------------------------------------------------------------
-- Name      : nnmLDAPProfileContainer
-- Desc      : The nnmLDAPProfileContainer class is a container created to 
--			   hold nnmLDAPProfile objects.
------------------------------------------------------------------------------
"nnmLDAPProfileContainer" OBJECT-CLASS ::=
{
	SubClassOf 	{ "TOP" },
	ContainedBy	{ "Country", "Locality", "Organization", "Organizational Unit", "domain", "nnmSystem" },
	Flags		{ DS_EFFECTIVE_CLASS, DS_CONTAINER_CLASS },
	NamedBy		{
					"OU"
				},
	MustContain	{
					"OU"
				},
	ASN1ObjID	{ 2 16 840 1 113719 1 323 6 2 }
}


------------------------------------------------------------------------------
-- Name      : nnmLDAPProfile
-- Desc      : The nnmLDAPProfile class consists of those attributes which
--			   specify how and where a client should connect to one or more 
--			   LDAP servers.
------------------------------------------------------------------------------
"nnmLDAPProfile" OBJECT-CLASS ::=
{
	SubClassOf 	{ "TOP" },
	ContainedBy	{ "Country", "Locality", "Organization", "Organizational Unit", "domain", "nnmLDAPProfileContainer" },
	Flags		{ DS_EFFECTIVE_CLASS },
	NamedBy		{
					"CN"
				},
	MustContain	{
					"CN"
				},
	MayContain	{
					"nnmLDAPBaseDN",
					"nnmLDAPBaseScope",
					"nnmLDAPAdditionalDNs",
					"nnmLDAPReferral",
					"nnmLDAPProxy",
					"nnmLDAPQueryMaxResults",
					"nnmLDAPQueryTimeout",
					"nnmLDAPIdleTimeout",
					"nnmLDAPMaxConnections",
					"nnmLDAPDefaultConnections",
					"nnmLDAPConnection"
				},
	ASN1ObjID	{ 2 16 840 1 113719 1 323 6 3 }
}


------------------------------------------------------------------------------
-- Name      : nnmScopeProfileContainer
-- Desc      : The nnmScopeProfileContainer class is a container created to 
--			   hold nnmScopeProfile objects.
------------------------------------------------------------------------------
"nnmScopeProfileContainer" OBJECT-CLASS ::=
{
	SubClassOf 	{ "TOP" },
	ContainedBy	{ "Country", "Locality", "Organization", "Organizational Unit", "domain", "nnmSystem" },
	Flags		{ DS_EFFECTIVE_CLASS, DS_CONTAINER_CLASS },
	NamedBy		{
					"OU"
				},
	MustContain	{
					"OU"
				},
	ASN1ObjID	{ 2 16 840 1 113719 1 323 6 4 }
}


------------------------------------------------------------------------------
-- Name      : nnmScopeProfile
-- Desc      : The nnmScopeProfile class consists of those attributes which 
--			   limit directory operations to specific contexts within a tree.
------------------------------------------------------------------------------
"nnmScopeProfile" OBJECT-CLASS ::=
{
	SubClassOf 	{ "TOP" },
	ContainedBy	{ "Country", "Locality", "Organization", "Organizational Unit", "domain", "nnmScopeProfileContainer" },
	Flags		{ DS_EFFECTIVE_CLASS },
	NamedBy		{
					"CN"
				},
	MustContain	{
					"CN"
				},
	MayContain	{
					"nnmScopeContextList"
				},
	ASN1ObjID	{ 2 16 840 1 113719 1 323 6 5 }
}

------------------------------------------------------------------------------
-- Name		 : nnmHostContainer
-- Desc      : The nnmHostContainer class is a container created to hold
--			   nnmHost (Novell Messenger Host) objects.
------------------------------------------------------------------------------
"nnmHostContainer" OBJECT-CLASS ::=
{
	SubClassOf 	{ "TOP" },
	ContainedBy	{ "Country", "Locality", "Organization", "Organizational Unit", "domain", "nnmSystem" },
	Flags		{ DS_EFFECTIVE_CLASS, DS_CONTAINER_CLASS },
	NamedBy		{
					"OU"
				},
	MustContain {
					"OU"
				},
	ASN1ObjID	{ 2 16 840 1 113719 1 323 6 6 }
}

------------------------------------------------------------------------------
-- Name		 : nnmHost
-- Desc      : The nnmHost class consists of those attributes which define the
--			   scope for a specific Novell Messenger host name.
------------------------------------------------------------------------------
"nnmHost" OBJECT-CLASS ::=
{
	SubClassOf 	{ "TOP" },
	ContainedBy	{ "Country", "Locality", "Organization", "Organizational Unit", "domain", "nnmHostContainer" },
	Flags		{ DS_EFFECTIVE_CLASS },
	NamedBy		{
					"CN"
				},
	MustContain	{
					"CN"
				},
	MayContain  {
					"nnmHostName",
					"nnmScopeProfileDN"
				},
	ASN1ObjID	{ 2 16 840 1 113719 1 323 6 7 }
}

------------------------------------------------------------------------------
-- Name      : nnmPoliciesContainer
-- Desc      : The nnmPoliciesContainer class is a container created to hold
--			   nnmPolicy (Novell Messenger Policy) objects.
------------------------------------------------------------------------------
"nnmPoliciesContainer" OBJECT-CLASS ::=
{
	SubClassOf 	{ "TOP" },
	ContainedBy	{ "Country", "Locality", "Organization", "Organizational Unit", "domain", "nnmSystem" },
	Flags		{ DS_EFFECTIVE_CLASS, DS_CONTAINER_CLASS },
	NamedBy		{
					"OU"
				},
	MustContain	{
					"OU"
				},
	ASN1ObjID	{ 2 16 840 1 113719 1 323 6 8 }
}

------------------------------------------------------------------------------
-- Name      : nnmPolicy
-- Desc      : The nnmPolicy class consists of those attributes which allow
--			   management of Novell Messenger features for users.
------------------------------------------------------------------------------
"nnmPolicy" OBJECT-CLASS ::=
{
	SubClassOf 	{ "TOP" },
	ContainedBy	{ "Country", "Locality", "Organization", "Organizational Unit", "domain", "nnmPoliciesContainer" },
	Flags		{ DS_EFFECTIVE_CLASS },
	NamedBy		{
					"CN"
				},
	MustContain	{
					"CN"
				},
	MayContain	{
					"nnmServices",
					"nnmLockedAttrList",
					"nnmScopeProfileDN",
					"nnmBlocking",
					"nnmBlockingAllowList",
					"nnmBlockingDenyList",
					"nnmBlockingAdminAllowList",
					"nnmBlockingAdminDenyList",
					"nnmContactList",
					"nnmInformationDisplayList",
					"nnmFileTransfer",
					"nnmFileMaxSendSize",
					"nnmFileMaxReceiveSize",
					"nnmArchive",
					"nnmQuery",
					"nnmCustomStatusList",
					"nnmDefaultHost",
					"nnmSystemDN",
					"nnmReferenceList",
					"nnmMaxContacts",
					"nnmMaxFolders",
					"nnmPasswordChange",
					"nnmPasswordRemember",
					"nnmBroadcast",
					"nnmSystemBroadcast",
					"nnmChatCreate",
					"nnmPersonalHistory",
					"nnmPrintSave",
					"nnmChatService",
					"nnmEnableConferencing"
				},
	ASN1ObjID	{ 2 16 840 1 113719 1 323 6 9 }
}


------------------------------------------------------------------------------
-- Name      : nnmServer
-- Desc      : The nnmServer class consists of those attributes which
--			   specify how agents on a single machine will run.
------------------------------------------------------------------------------
"nnmServer" OBJECT-CLASS ::=
{
	SubClassOf 	{ "TOP" },
	ContainedBy	{ "Country", "Locality", "Organization", "Organizational Unit", "domain", "nnmSystem" },
	Flags		{ DS_EFFECTIVE_CLASS, DS_CONTAINER_CLASS },
	NamedBy		{
					"OU"
				},
	MustContain	{
					"OU"
				},
	MayContain	{
					"nnmDescription",
					"nnmIPAddress",
					"nnmIPAddressBind",
					"nnmSSL",
					"nnmSSLCertFile",
					"nnmSSLKeyFile",
					"nnmSSLKeyCredentials",
					"nnmCertPath",
					"nnmServices",
					"nnmSNMP",
					"nnmDiskCheckInterval",
					"nnmDiskCheckDelay",
					"nnmLDAPProfileDN",
					"nnmWorkPath",
					"nnmSoftwarePath",
					"nnmSNMPCommunity"
				},
	ASN1ObjID	{ 2 16 840 1 113719 1 323 6 10 }
}


------------------------------------------------------------------------------
-- Name      : nnmAgent
-- Desc      : The nnmAgent class is the "base" class from which all Novell
--			   Messenger agents will be based. This class consists of those
--			   attributes which will determine how the agent will run.
-- Note		 : The nnmAgent class is not an "effective" class since it is
--			   meant to be a base class for all other Novell Messenger agents.
------------------------------------------------------------------------------
"nnmAgent" OBJECT-CLASS ::=
{
	SubClassOf 	{ "TOP" },
	ContainedBy	{ "nnmServer" },
	NamedBy		{
					"CN"
				},
	MustContain	{
					"CN",
					"nnmVersion"
				},
	MayContain	{
					"nnmDescription",
					"nnmIPAddress",
					"nnmIPAddressBind",
					"nnmSSL",
					"nnmSSLCertFile",
					"nnmSSLKeyFile",
					"nnmSSLKeyCredentials",
					"nnmCertPath",
					"nnmServices",
					"nnmSNMP",
					"nnmDiskCheckInterval",
					"nnmDiskCheckDelay",
					"nnmLDAPProfileDN",
					"nnmWorkPath",
					"nnmPort",
					"nnmLogToDisk",
					"nnmLogLevel",
					"nnmLogMaxAge",
					"nnmLogMaxSize",
					"nnmLogPath",
					"nnmWebConsolePort",
					"nnmWebConsoleSSL",
					"nnmWebConsoleCredentials",
					"nnmAgentSettings",
					"nnmThreads",
					"nnmMaxUsers"
				},
	ASN1ObjID	{ 2 16 840 1 113719 1 323 6 11 }
}


------------------------------------------------------------------------------
-- Name      : nnmMessagingAgent
-- Desc      : The nnmMessagingAgent class consists of those attributes which
--			   specify how the Novell Messenger Messaging agent will run.
------------------------------------------------------------------------------
"nnmMessagingAgent" OBJECT-CLASS ::=
{
	SubClassOf 	{ "nnmAgent" },
	Flags		{ DS_EFFECTIVE_CLASS },
	MayContain	{
					"nnmFileTransferPath",
					"nnmQueuePath",
					"nnmClientDownload"
				},
	ASN1ObjID	{ 2 16 840 1 113719 1 323 6 12 }
}


------------------------------------------------------------------------------
-- Name      : nnmArchiveAgent
-- Desc      : The nnmArchiveAgent class consists of those attributes which
--			   specify how the Novell Messenger Archive agent will run.
------------------------------------------------------------------------------
"nnmArchiveAgent" OBJECT-CLASS ::=
{
	SubClassOf 	{ "nnmAgent" },
	Flags		{ DS_EFFECTIVE_CLASS, DS_CONTAINER_CLASS },
	MayContain	{
					"nnmArchivePassphrase",
					"nnmArchiveDelay",
					"nnmArchiveInterval",
					"nnmArchiveExpire",
					"nnmQueuePath"
				},
	ASN1ObjID	{ 2 16 840 1 113719 1 323 6 14 }
}


------------------------------------------------------------------------------
-- Name      : nnmModule
-- Desc      : The nnmModule class consists of those attributes which
--			   specify information about finding and loading a module 
--			   (pluggable, executable code).
------------------------------------------------------------------------------
"nnmModule" OBJECT-CLASS ::=
{
	SubClassOf 	{ "TOP" },
	ContainedBy	{ "Country", "Locality", "Organization", "Organizational Unit", "domain", "nnmArchiveAgent" },
	Flags		{ DS_EFFECTIVE_CLASS },
	NamedBy		{
					"CN"
				},
	MustContain	{
					"CN",
					"nnmModuleName",
					"nnmModuleBin"
				},
	MayContain	{
					"nnmModuleDescription",
					"nnmModuleSettings"
				},
	ASN1ObjID	{ 2 16 840 1 113719 1 323 6 15 }
}


------------------------------------------------------------------------------
-- Name      : nnmChatContainer
-- Desc      : The nnmChatContainer class is a container created to hold
--			   nnmChat (chat room) objects.
------------------------------------------------------------------------------
"nnmChatContainer" OBJECT-CLASS ::=
{
	SubClassOf 	{ "TOP" },
	ContainedBy	{ "Country", "Locality", "Organization", "Organizational Unit", "domain", "nnmSystem" },
	Flags		{ DS_EFFECTIVE_CLASS, DS_CONTAINER_CLASS },
	NamedBy		{
					"OU"
				},
	MustContain	{
					"OU"
				},
	ASN1ObjID	{ 2 16 840 1 113719 1 323 6 16 }
}

------------------------------------------------------------------------------
-- Name      : nnmChat
-- Desc      : The nnmChat class consists of those attributes which describe a
--			   single chat room in a Novell Messenger system.
------------------------------------------------------------------------------
"nnmChat" OBJECT-CLASS ::=
{
	SubClassOf 	{ "TOP" },
	ContainedBy	{ "Country", "Locality", "Organization", "Organizational Unit", "domain", "nnmChatContainer" },
	Flags		{ DS_EFFECTIVE_CLASS },
	NamedBy		{
					"CN"
				},
	MustContain	{
					"CN",
					"nnmDisplayName"
				},
	MayContain	{
					"nnmDescription",
					"nnmChatPassword",
					"nnmDisclaimer",
					"nnmChatOwnerDN",
					"nnmQuery",
					"nnmChatACL",
					"nnmArchive",
					"nnmMaxUsers",
					"nnmCreatorDN",
					"nnmCreatorName",
					"nnmCreationTime"
				},
	ASN1ObjID	{ 2 16 840 1 113719 1 323 6 17 }
}

------------------------------------------------------------------------------
-- Class Modifications
------------------------------------------------------------------------------

------------------------------------------------------------------------------
-- Name		: User
-- Desc		: The "User" class is modified to contain most of the same 
--			  attributes as stored on a policy ("nnmPolicy") object. Some of
--			  the other attributes are specific to the user 
--			  (e.g., nnmLastLogin).
------------------------------------------------------------------------------
"User" OBJECT-CLASS ::=
{
	Operation 	MODIFY,
	MayContain	{
					"nnmClientSettings",
					"nnmPolicyDN",
					"nnmServices",
					"nnmLockedAttrList",
					"nnmScopeProfileDN",
					"nnmBlocking",
					"nnmBlockingAllowList",
					"nnmBlockingDenyList",
					"nnmBlockingAdminAllowList",
					"nnmBlockingAdminDenyList",
					"nnmContactList",
					"nnmInformationDisplayList",
					"nnmFileTransfer",
					"nnmFileMaxSendSize",
					"nnmFileMaxReceiveSize",
					"nnmArchive",
					"nnmQuery",
					"nnmCustomStatusList",
					"nnmDefaultHost",
					"nnmMaxContacts",
					"nnmLastLogin",
					"nnmMaxFolders",
					"nnmPasswordChange",
					"nnmPasswordRemember",
					"nnmBroadcast",
					"nnmSystemBroadcast",
					"nnmChatCreate",
					"nnmPersonalHistory",
					"nnmPrintSave",
					"nnmChatService",
					"nnmEnableConferencing"
				}
}


------------------------------------------------------------------------------
-- Name		: NCP Server
-- Desc		: The "NCP Server" class is modified to contain a server 
--			  ("nnmServerDN") attribute. This attribute exists as a 
--			  bootstrapping mechanism for the Novell Messenger agents.
------------------------------------------------------------------------------
"NCP Server" OBJECT-CLASS ::=
{
	Operation 	MODIFY,
	MayContain	{
					"nnmServerDN"
				}
}


END
