;======================================================================
;                   Novell Messenger 2.0-Nachrichtenagent
;                         Beispiel-Startup-Datei
;----------------------------------------------------------------------
;  Ersetzen Sie die Werte in eckigen Klammern durch Ihre eigenen Werte.
;
;  Alle optionalen Schalter wurden durch Voranstellen eines 
;  Strichpunkts deaktiviert. Entfernen Sie den Strichpunkt, um einen 
;  Schalter zu aktivieren.
;
;  Speichern Sie die Datei im ASCII-Format.  
;----------------------------------------------------------------------
;  Diese Beispieldatei ist in zwei Abschnitte unterteilt:
;  1) Einstellungen, die nur als Startup-Schalter verfgbar sind
;    - Allgemeine Schalter
;    - Schalter fr NLM (NetWare Loadable Module)
;  2) Einstellungen, die in ConsoleOne gendert werden sollten, aber 
;      auch als Startup-Schalter verfgbar sind
;    - Schalter fr die Ereignisprotokollierung
;    - Schalter fr die Leistung
;    - Client/Server-Schalter
;======================================================================

;======================================================================
;                        ABSCHNITT 1:
;       EINSTELLUNGEN, DIE NUR ALS STARTUP-SCHALTER VERFGBAR SIND
;======================================================================

;----------------------------------------------------------------------
; DN des Nachrichtenagenten
; Beispiel: CN=MessagingAgent,OU=NMServer1,OU=MessengerService,O=Novell
;----------------------------------------------------------------------
;/home-[DN-Format]

;----------------------------------------------------------------------
; Sprache
;----------------------------------------------------------------------
;/language-[ EN | DE | ES | FR | PT ]

;----------------------------------------------------------------------
; Benutzername und Passwort, mit denen der Agent die Einstellungen aus 
; dem Verzeichnis lesen kann.
;----------------------------------------------------------------------
;/user-[Benutzer-ID]
;/password-[Passwort]


;====================== VERZEICHNISKONFIGURATION =======================

;----------------------------------------------------------------------
; IP-Adresse der Verzeichnisreproduktion
; Gibt die Adresse der Verzeichnisreproduktion an.
;----------------------------------------------------------------------
;/dirreplicaipaddr-[Adresse]

;----------------------------------------------------------------------
; Direktzugriff fr Benutzersitzung erzwingen
; Legt als Verzeichnismodus fr den Benutzerzugriff "Direktzugriff" 
; fest. Dadurch werden die LDAP-Profile ignoriert.
;----------------------------------------------------------------------
;/diruserforcedirect

;----------------------------------------------------------------------
; Verzeichnisbenutzerbeglaubigung ber Bindung
; Gibt an, ob die Benutzerbeglaubigung ber eine Bindung oder einen 
; Vergleich erfolgt. Der Standardwert ist "Vergleich".
;----------------------------------------------------------------------
;/diruserauthbind

;----------------------------------------------------------------------
; Zeitberschreitung fr Zurcksetzung eines Servers im Verzeichnispool
; Gibt die Zeitspanne an, nach der ein Problemserver wieder in den Pool 
; zurckgesetzt wird.
;----------------------------------------------------------------------
;/dirpoolresettime-[Minuten]

;----------------------------------------------------------------------
; ID-Alias des Verzeichnisbenutzers
; Gibt das Attribut an, das anstelle des CN fr Benutzerbeglaubigungen, 
; Suchvorgnge usw. verwendet werden soll.
;----------------------------------------------------------------------
;/diruseralias-[Attributname]


;============ NACHRICHTENTRANSPORTPROTOKOLL SWITCHES ==================

;----------------------------------------------------------------------
; Deaktiviert das Nachrichtentransportprotokoll fr diesen Agenten.
;----------------------------------------------------------------------
;/nomtp

;----------------------------------------------------------------------
; MTP-Verbindungszeitberschreitung
; Gibt in Sekunden an, wie lange eine Verbindung besteht, bevor sie 
; durch Zeitberschreitung beendet wird.
;----------------------------------------------------------------------
;/mtpconnecttimeout-[Sekunden]

;----------------------------------------------------------------------
; MTP-Datenzeitberschreitung
; Gibt in Sekunden an, wie lange eine Anforderung auf Daten wartet, 
; bevor sie durch Zeitberschreitung beendet wird.
;----------------------------------------------------------------------
;/mtpdatatimeout-[Sekunden]

;----------------------------------------------------------------------
; MTP-Sendeziel-Anschlussnummer
; Gibt die Nummer des Anschlusses an, an den sich das MTP fr die MTP-
; Dateibertragung anbindet.
;----------------------------------------------------------------------
;/mtpport-[Anschlussnummer]

;----------------------------------------------------------------------
; MTP-Sendeziel-IP-Adresse
; Gibt die IP-Adresse an, an die sich der Agent fr die MTP-
; Dateibertragung anbindet.
;----------------------------------------------------------------------
;/mtpipaddr-[Adresse]


;======================= SCHALTER FR NLM ========================

;----------------------------------------------------------------------
; Simple Network Management Protocol (SNMP)
; Der Nachrichtenagent ist standardmig fr SNMP aktiviert.
;----------------------------------------------------------------------
;/nosnmp

;----------------------------------------------------------------------
; Informiert den Nachrichtenagenten, dass er in einem Cluster 
; ausgefhrt wird.
;----------------------------------------------------------------------
;/cluster

;======================================================================
;                             ABSCHNITT 2:
;                    IN CONSOLEONE VERFGBARE EINSTELLUNGEN
;======================================================================

;====================== VERZEICHNISKONFIGURATION =======================

;----------------------------------------------------------------------
; Max. Verzeichnisabfrageergebnisse
; Gibt die maximale Anzahl der Ergebnisse an, die fr eine Abfrage an 
; das Verzeichnis zurckgegeben werden.
;----------------------------------------------------------------------
;/dirquerymaxresults-[Zahl]

;----------------------------------------------------------------------
; Verzeichnisleerlauf-Zeitberschreitung
; Gibt die Zeitspanne an, nach der eine inaktive Verzeichnisverbindung 
; getrennt wird.
;----------------------------------------------------------------------
;/diridletimeout-[Sekunden]

;----------------------------------------------------------------------
; Max. Verzeichnisverbindungen
; Gibt die maximale Anzahl von Verzeichnisverbindungen an.
;----------------------------------------------------------------------
;/dirmaxconnections-[Zahl]

;----------------------------------------------------------------------
; Standardanzahl fr Verzeichnisverbindungen
; Gibt die Standardanzahl fr Verzeichnisverbindungen an.
;----------------------------------------------------------------------
;/dirdefaultconnections-[Zahl]

;----------------------------------------------------------------------
; Abfrage-Zeitberschreitung des Verzeichnisses
; Gibt die Dauer in Sekunden an, bevor ein Suchvorgang wegen 
; Zeitberschreitung beendet wird.  
; Der Standardwert betrgt 30.
;----------------------------------------------------------------------
;/dirquerytimeout-[Zahl]

;============= SCHALTER FR DIE EREIGNISPROTOKOLLIERUNG ===============

;----------------------------------------------------------------------
; Protokollierumfang
; Whlt die einfache Fehlerprotokollierung (Normal) oder grundlegende 
; (Verbose) bzw. vollstndige Details (Diagnostic) aus.
;----------------------------------------------------------------------
;/loglevel-[ Normal | Verbose | Diagnostic ]

;----------------------------------------------------------------------
; Datentrgerprotokollierung
; Deaktiviert das Schreiben der Protokolldatei auf den Datentrger.
;----------------------------------------------------------------------
;/logdiskoff

;----------------------------------------------------------------------
; Protokollverzeichnis
;----------------------------------------------------------------------
;/log-\\[Server]\[Volume]\[Verzeichnis]

;----------------------------------------------------------------------
; Protokollalter
; Bestimmt, wie lange (in Tagen) eine Protokolldatei auf dem 
; Datentrger verbleibt, bevor sie automatisch gelscht wird.
;----------------------------------------------------------------------
;/logdays-[Tage]

;----------------------------------------------------------------------
; Protokollspeicher
; Bestimmt den maximalen Speicherplatz (in Megabyte), der fr alle 
; Protokolldateien zusammen verwendet wird.
;----------------------------------------------------------------------
;/logmax-[MB]

;====================== SSL-ZERTIFIKATSCHALTER ========================

;----------------------------------------------------------------------
; SSL fr die Client/Serverkommunikation verwenden
;----------------------------------------------------------------------
;/ssl-[enable | disable]

;----------------------------------------------------------------------
; SSL-Zertifikat
; Gltiges Serverzertifikat im PEM- oder PFX-Format, das von einer
; Zertifizierungsstelle (CA) abgerufen wurde.
;----------------------------------------------------------------------
;/certpath-\\[Server]\[Volume]\[Verzeichnis]
;/certfile-\\[Server]\[Volume]\[Verzeichnis]\[Zertifikat]
;/keyfile-\\[Server]\[Volume]\[Verzeichnis]\[private key]
;/keypassword-[Schlsselpasswort]

;====================== CLIENT/SERVER-SCHALTER ========================

;----------------------------------------------------------------------
; TCP-Anschlussnummer
; Gibt die Nummer des Anschlusses an, den der Nachrichtenagent auf 
; Client/Server-Anforderungen berwacht.
; Der Standardanschluss ist 8300.
; Wenn mehrere Nachrichtenagent-Instanzen zur Verarbeitung von Client/
; Server-Anforderungen auf einem Rechner vorhanden sind, mssen Sie fr 
; jede Instanz einen anderen Anschluss angeben.
;----------------------------------------------------------------------
;/port-[Zahl]

;----------------------------------------------------------------------
; TCP/IP-Adresse
; Gibt die IP-Adresse an, die der Nachrichtenagent auf Client/Server-
; Anforderungen berwacht. 
; Dieser Schalter weist den Nachrichtenagenten an, eine bestimmte 
; Adresse zu berwachen.
;----------------------------------------------------------------------
;/ip-[Adresse]

;----------------------------------------------------------------------
; Max. Verbindungen
; Die Anzahl der Client/Server-Verbindungen, die der Server zulsst.
; Der Standardwert betrgt 5120 (5K).
;----------------------------------------------------------------------
;/maxconns-[Zahl]

;----------------------------------------------------------------------
; Anzahl der TCP-Verarbeitungs-Threads
; Legt fest, wie viele Threads der Nachrichtenagent fr die 
; Verarbeitung von Client/Server-Anforderungen einsetzt. Der 
; Standardwert betrgt 15.
;----------------------------------------------------------------------
;/threads-[Zahl]


;============= NACHRICHTENTRANSPORTPROTOKOLL-SCHALTER =================

;----------------------------------------------------------------------
; Warteschlangenverzeichnis
;----------------------------------------------------------------------
;/queue-\\[Server]\[Volume]\[Verzeichnis]


;=========== SCHALTER FR DIE HTTP-NACHRICHTENVERARBEITUNG ============

;----------------------------------------------------------------------
; Ermglicht die Verwendung von HTTP fr WebConsole und gibt die Nummer 
; des Anschlusses an, der auf WebConsole-Anforderungen berwacht wird.
;----------------------------------------------------------------------
;/httpport-[Anschlussnummer]

;----------------------------------------------------------------------
; Benutzername fr die Beglaubigung des Benutzers, der die HTTP-
; Informationen anfordert.
;----------------------------------------------------------------------
;/httpuser-[Benutzer-ID]

;----------------------------------------------------------------------
; Benutzerpasswort fr die Beglaubigung des Benutzers, der die HTTP-
; Informationen anfordert.
;----------------------------------------------------------------------
;/httppassword-[Passwort]

;----------------------------------------------------------------------
; SSL fr HTTPS aktivieren
;----------------------------------------------------------------------
;/httpssl-[enable | disable]


;================ SCHALTER FR DIE LDAP-BEGLAUBIGUNG ==================

;----------------------------------------------------------------------
; LDAP-Benutzer-ID 
; Diese LDAP-Benutzer-ID wird vom Nachrichtenagenten zur Herstellung 
; einer Verbindung mit dem LDAP-Server verwendet, um die Konfiguration 
; des Servers lesen zu knnen. Verwenden Sie das Format "cn=userid,
; ou=group,ou=division,o=organization".
;----------------------------------------------------------------------
;/ldapuser-[DN-Format]  

;-----------------------------------------------------------------------
; LDAP-Passwort
; Das Passwort fr den LDAP-Benutzer.												
;-----------------------------------------------------------------------
;/ldappwd-[Passwort]        

;-----------------------------------------------------------------------
; LDAP-Server-IP-Adresse
; Die IP-Adresse des LDAP-Servers im Format mit Punkten oder im DNS-
; Format. Wenn mehrere LDAP-Beglaubigungsserveradressen angegeben sind, 
; werden diese vom LDAP-Server als FAILOVER eingesetzt. [address] 
; sollte im Format "123.3.4.1 123.4.5.2 123.3.4.5" angegeben werden, 
; wobei die einzelnen Adressen durch eine Leerstelle getrennt werden.
;-----------------------------------------------------------------------
;/ldapipaddr-[Adresse]  

;-----------------------------------------------------------------------
; LDAP-Anschlussnummer
; Die Nummer des Anschlusses, den der LDAP-Server fr die Beglaubigung 
; berwacht. Der Standardwert ist 389. Dieser Schalter gibt den LDAP-
; Anschluss fr den Failover-Modus an.
;----------------------------------------------------------------------
;/ldapport-[Zahl]      

;------------------------------------------------------------------------
; Teilt dem Nachrichtenagenten mit, ob diese LDAP-Beglaubigung SSL fr 
; den Failover-Modus verwendet.
;----------------------------------------------------------------------
;/ldapssl               

;----------------------------------------------------------------------
; Gibt den SSL-Schlssel-Dateinamen, z. B. gwkey.der, an. Dieser 
; Schalter wird fr den Failover-Modus verwendet.
;----------------------------------------------------------------------
;/ldapsslkey-[Name]    

;========================== ENDE DER DATEI =============================
