;======================================================================
;                   Novell Messenger 2.0 Messaging Agent
;                         Sample Startup File
;----------------------------------------------------------------------
;  Replace the values in the square brackets with your own values.
;
;  All optional switches are disabled by placing a semicolon in front
;  of the switch.  To enable a switch, remove the semicolon.
;
;  Be sure to save in ASCII format.  
;----------------------------------------------------------------------
;  This sample file is divided into two sections:
;  1) Settings only available as startup switches
;    - General
;    - NetWare Loadable Module (NLM) Specific
;  2) Settings that are recommended to be modified from ConsoleOne
;     but are also available as startup switches.
;    - Event Logging
;    - Performance
;    - Client/Server
;======================================================================

;======================================================================
;                             SECTION 1:
;             SETTINGS AVAILABLE ONLY AS STARTUP SWITCHES
;======================================================================

;----------------------------------------------------------------------
; DN of the Messaging Agent
; Example: CN=MessagingAgent,OU=NMServer1,OU=MessengerService,O=Novell
;----------------------------------------------------------------------
;/home-[DN Format]

;----------------------------------------------------------------------
; Language
;----------------------------------------------------------------------
;/language-[ EN | DE | ES | FR | PT ]

;----------------------------------------------------------------------
; User and password to enable the agent to read settings from the 
; directory.
;----------------------------------------------------------------------
;/user-[user ID]
;/password-[password]

;----------------------------------------------------------------------
; IPV6/IPV4
; IPV6 support is available by default
;----------------------------------------------------------------------
;/ipv4only

;====================== DIRECTORY CONFIGURATION =======================

;----------------------------------------------------------------------
; Directory Replica IP Address
; Specifies the address of the directory replica.
;----------------------------------------------------------------------
;/dirreplicaipaddr-[address]

;----------------------------------------------------------------------
; Force User Session to Use Direct Access
; Specifies that the directory mode for user access is direct access.
; This causes the LDAP profiles to be ignored.
;----------------------------------------------------------------------
;/diruserforcedirect

;----------------------------------------------------------------------
; Directory User Authentication via Bind
; Specifies whether user authentication is performed via a bind or a
; comparison. The default is comparison.
;----------------------------------------------------------------------
;/diruserauthbind

;----------------------------------------------------------------------
; Directory Pool Reset Time
; Specifies the amount of time before putting a problem server back 
; into the pool.
;----------------------------------------------------------------------
;/dirpoolresettime-[minutes]

;----------------------------------------------------------------------
; Directory User ID Alias
; Specifies the attribute to use instead of CN for user 
; authentications, searches, etc.
;----------------------------------------------------------------------
;/diruseralias-[attribute name]


;================ MESSAGE TRANSFER PROTOCOL SWITCHES ==================

;----------------------------------------------------------------------
; Disables the Message Transfer Protocol for this agent
;----------------------------------------------------------------------
;/nomtp

;----------------------------------------------------------------------
; MTP Connect Timeout
; Specifies, in seconds, how long a connection lasts before it is 
; timed out.
;----------------------------------------------------------------------
;/mtpconnecttimeout-[seconds]

;----------------------------------------------------------------------
; MTP Data Timeout
; Specifies, in seconds, how long a request waits for data before it 
; is timed out.
;----------------------------------------------------------------------
;/mtpdatatimeout-[seconds]

;----------------------------------------------------------------------
; MTP Send Destination Port Number
; Specifies the port number that the MTP binds to for the MTP file
; transfer.
;----------------------------------------------------------------------
;/mtpport-[port number]

;----------------------------------------------------------------------
; MTP Send Destination IP Address
; Specifies the IP address that the agent binds to for the MTP file
; transfer.
;----------------------------------------------------------------------
;/mtpipaddr-[address]


;======================= NLM SPECIFIC SWITCHES ========================

;----------------------------------------------------------------------
; Simple Network Management Protocol (SNMP)
; The Messaging Agent is SNMP-enabled by default.
;----------------------------------------------------------------------
;/nosnmp

;----------------------------------------------------------------------
; Informs the Messaging Agent that it is running in a cluster.
;----------------------------------------------------------------------
;/cluster

;======================================================================
;                             SECTION 2:
;                    SETTINGS AVAILABLE IN ConsoleOne
;======================================================================

;====================== DIRECTORY CONFIGURATION =======================

;----------------------------------------------------------------------
; Directory Query Maximum Results
; Specifies the maximum number of results that are returned for any
; request to the directory.
;----------------------------------------------------------------------
;/dirquerymaxresults-[number]

;----------------------------------------------------------------------
; Directory Idle Timeout
; Specifies the amount of time before an inactive directory connection
; closes down.
;----------------------------------------------------------------------
;/diridletimeout-[seconds]

;----------------------------------------------------------------------
; Directory Maximum Connections
; Specifies the maximum number of directory connections
;----------------------------------------------------------------------
;/dirmaxconnections-[number]

;----------------------------------------------------------------------
; Directory Default Connections
; Specifies the default number of directory connections
;----------------------------------------------------------------------
;/dirdefaultconnections-[number]

;----------------------------------------------------------------------
; Directory Query Timeout
; Specifies the number of seconds before timing out a search.  The 
; default is 30.
;----------------------------------------------------------------------
;/dirquerytimeout-[number]

;=========================== LOG SWITCHES =============================

;----------------------------------------------------------------------
; Log Level
; Selects error logging only (Normal) or basic details (Verbose) or 
; full details (Diagnostic).
;----------------------------------------------------------------------
;/loglevel-[ Normal | Verbose | Diagnostic ]

;----------------------------------------------------------------------
; Disk Logging
; Disables writing the log file to disk.
;----------------------------------------------------------------------
;/logdiskoff

;----------------------------------------------------------------------
; Log Directory
;----------------------------------------------------------------------
;/log-\\[server]\[volume]\[directory]

;----------------------------------------------------------------------
; Maximum Log File Age
; Determines how long (number of days) a log file resides on the disk
; before being automatically deleted.
;----------------------------------------------------------------------
;/logdays-[days]

;----------------------------------------------------------------------
; Maximum Log Disk Space
; Determines the maximum disk space in megabytes used for all log 
; files.
;----------------------------------------------------------------------
;/logmax-[mb]

;===================== SSL CERTIFICATE SWITCHES =======================

;----------------------------------------------------------------------
; Enable SSL for the client/server communication
;----------------------------------------------------------------------
;/ssl-[enable | disable]

;----------------------------------------------------------------------
; SSL Certificate
; Valid server certificate in PEM or PFX format obtained from a
; Certificate Authority (CA).
;----------------------------------------------------------------------
;/certpath-\\[server]\[volume]\[directory]
;/certfile-\\[server]\[volume]\[directory]\[certificate]
;/keyfile-\\[server]\[volume]\[directory]\[private key]
;/keypassword-[key password]

;====================== CLIENT/SERVER SWITCHES ========================

;----------------------------------------------------------------------
; TCP Port Number
; Specifies the port number that the Messaging Agent listens on for 
; client/server requests.
; The default port is 8300.
; If you have multiple Messaging Agent instances servicing 
; client/server requests running on the same machine, you must specify 
; a different port for each instance.
;----------------------------------------------------------------------
;/port-[number]

;----------------------------------------------------------------------
; TCP IP Address
; Specifies the IP address that the Messaging Agent listens on for 
; client/server requests. 
; This switch tells the Messaging Agent to listen to a specific 
; address.
;----------------------------------------------------------------------
;/ip-[address]

;----------------------------------------------------------------------
; Maximum Connections
; The number of client/server connections the server allows.
; The default is 5120 (5K).
;----------------------------------------------------------------------
;/maxconns-[number]

;----------------------------------------------------------------------
; Number of TCP Processing Threads
; Sets how many threads the Messaging Agent spawns for handling
; client/server requests. The default is 15.
;----------------------------------------------------------------------
;/threads-[number]


;================ MESSAGE TRANSFER PROTOCOL SWITCHES ==================

;----------------------------------------------------------------------
; Queue Directory
;----------------------------------------------------------------------
;/queue-\\[server]\[volume]\[directory]


;================= HTTP MESSAGE PROCESSING SWITCHES ===================

;----------------------------------------------------------------------
; Enables the use of HTTP for WebConsole and specifies the port number 
; to listen on for WebConsole.
;----------------------------------------------------------------------
;/httpport-[port number]

;----------------------------------------------------------------------
; User Name for the Authenticating Requester of the HTTP Information
;----------------------------------------------------------------------
;/httpuser-[user ID]

;----------------------------------------------------------------------
; User Password for the Authenticating Requester of the HTTP 
; Information
;----------------------------------------------------------------------
;/httppassword-[password]

;----------------------------------------------------------------------
; Enable SSL for HTTPS
;----------------------------------------------------------------------
;/httpssl-[enable | disable]


;=================== LDAP AUTHENTICATION SWITCHES =====================

;----------------------------------------------------------------------
; LDAP User ID
; This LDAP user ID is used by the Messaging Agent to establish a
; connection with the LDAP server to read its configuration. The format 
; should be "cn=userid,ou=group,ou=division,o=organization".
;----------------------------------------------------------------------
;/ldapuser-[DN format]  

;-----------------------------------------------------------------------
; LDAP Password
; The password for the LDAP user.												
;-----------------------------------------------------------------------
;/ldappwd-[password]        

;-----------------------------------------------------------------------
; LDAP Server IP Address
; The LDAP server's IP address in dotted format or DNS format.  If 
; multiple LDAP authentication server addresses are specified, they are 
; used by LDAP server in the FAILOVER manner. [address] should be 
; specified as "123.3.4.1 123.4.5.2 123.3.4.5"  with a space between 
; each address.
;-----------------------------------------------------------------------
;/ldapipaddr-[address]  

;-----------------------------------------------------------------------
; LDAP Port Number
; The port number that the LDAP server listens on for authentication
; default is 389. This switch is used to specify the LDAP port for 
; failover mode.
;------------------------------------------------------------------------ 
;/ldapport-[number]      

;------------------------------------------------------------------------
; Indicates to the Messaging Agent whether this LDAP authentication is 
; using SSL for failover mode.
;------------------------------------------------------------------------
;/ldapssl               

;------------------------------------------------------------------------
; Specifies the SSL Key file name such as gwkey.der  This switch is used 
; for failover mode.
;------------------------------------------------------------------------
;/ldapsslkey-[name]    

;========================== END OF FILE ===============================
