;======================================================================
;                   Agente de mensajera de Novell Messenger 2.0
;                         Archivo de inicio de muestra
;----------------------------------------------------------------------
;  Sustituya los valores que aparecen entre corchetes por sus propios 
;  valores.
;
;  Se han inhabilitado todos los conmutadores opcionales colocando un 
;  punto y coma delante del conmutador. Elimine el punto y coma para 
;  habilitar el conmutador.
;
;  Asegrese de guardar en formato ASCII.  
;----------------------------------------------------------------------
;  Este archivo de muestra est dividido en dos secciones:
;  1) Ajustes que slo estn disponibles como conmutadores de inicio
;    - Generales
;    - Especficos para el mdulo cargable de NetWare (NLM)
;  2) Ajustes que se recomienda modificar desde ConsoleOne pero que 
;      tambin estn disponibles como conmutadores de inicio.
;    - Registro de eventos
;    - Rendimiento
;    - Cliente/servidor
;======================================================================

;======================================================================
;                             SECCIN 1:
;             AJUSTES DISPONIBLES SLO COMO CONMUTADORES DE INICIO
;======================================================================

;----------------------------------------------------------------------
; DN del Agente de mensajera.
; Ejemplo: CN=MessagingAgent,OU=NMServer1,OU=MessengerService,O=Novell
;----------------------------------------------------------------------
;/home-[Formato de nombre completo]

;----------------------------------------------------------------------
; Idioma
;----------------------------------------------------------------------
;/language-[ EN | DE | ES | FR | PT ]

;----------------------------------------------------------------------
; Usuario y contrasea para habilitar el agente para que lea los ajustes 
; del Directorio.
;----------------------------------------------------------------------
;/user-[ID de usuario]
;/password-[contrasea]


;================== CONFIGURACIN DEL DIRECTORIO ======================

;----------------------------------------------------------------------
; Direccin IP de la rplica del Directorio
; Especifica la direccin de la rplica del Directorio.
;----------------------------------------------------------------------
;/dirreplicaipaddr-[direccin]

;----------------------------------------------------------------------
; Fuerza la sesin del usuario para que el acceso sea directo
; Especifica que el modo del Directorio para el acceso de los usuarios 
; sea directo.
; Esto provoca que se haga caso omiso de los perfiles LDAP.
;----------------------------------------------------------------------
;/diruserforcedirect

;----------------------------------------------------------------------
; Autenticacin del usuario del Directorio a travs de una asociacin
; Especifica si la autenticacin del usuario se realiza mediante una 
; asociacin o una comparacin. Por defecto, la autenticacin se realiza 
; mediante comparacin.
;----------------------------------------------------------------------
;/diruserauthbind

;----------------------------------------------------------------------
; Hora de reinicio del repositorio del Directorio
; Especifica la cantidad de tiempo que ha de transcurrir antes de 
; devolver el servidor de problemas al repositorio.
;----------------------------------------------------------------------
;/dirpoolresettime-[minutos]

;----------------------------------------------------------------------
; Alias del ID de usuario del Directorio
; Especifica el atributo que se debe usar en lugar del CN para las 
; autenticaciones de usuarios, las bsquedas, etc.
;----------------------------------------------------------------------
;/diruseralias-[nombre de atributo]


;========== PROTOCOLO DE TRANSFERENCIA DE MENSAJES SWITCHES ============

;----------------------------------------------------------------------
; Inhabilita el protocolo de transferencia de mensajes para este agente
;----------------------------------------------------------------------
;/nomtp

;----------------------------------------------------------------------
; Tiempo lmite de conexin de MTP
; Especifica (en segundos) cunto dura una conexin antes de que se 
; agote su tiempo.
;----------------------------------------------------------------------
;/mtpconnecttimeout-[segundos]

;----------------------------------------------------------------------
; Tiempo lmite de datos MTP
; Especifica (en segundos) cunto espera una peticin para obtener 
; datos antes de que se agote su tiempo.
;----------------------------------------------------------------------
;/mtpdatatimeout-[segundos]

;----------------------------------------------------------------------
; Nmero de puerto de destino para enviar MTP
; Especifica el nmero de puerto al que se conecta MTP para las 
; transferencias de archivos de MTP.
;----------------------------------------------------------------------
;/mtpport-[nmero de puerto]

;----------------------------------------------------------------------
; Direccin IP de destino para enviar MTP
; Especifica la direccin IP que a la que se conecta el agente para las 
; transferencias de archivos de MTP.
;----------------------------------------------------------------------
;/mtpipaddr-[direccin]


;================ CONMUTADORES ESPECFICOS PARA NLM ===================

;----------------------------------------------------------------------
; Simple Network Management Protocol (SNMP)
; Por defecto, el Agente de mensajera tiene habilitado el protocolo 
; SNMP.
;----------------------------------------------------------------------
;/nosnmp

;----------------------------------------------------------------------
; Informa al Agente de mensajera acerca de que la ejecucin se est 
; realizando en un clster
;----------------------------------------------------------------------
;/cluster

;======================================================================
;                             SECCIN 2:
;                    AJUSTES DISPONIBLES EN ConsoleOne
;======================================================================

;================= CONFIGURACIN DEL DIRECTORIO =======================

;----------------------------------------------------------------------
; Nmero mximo de resultados para una consulta al Directorio
; Especifica el nmero mximo de resultados que se devolvern para las 
; peticiones realizadas al Directorio.
;----------------------------------------------------------------------
;/dirquerymaxresults-[nmero]

;----------------------------------------------------------------------
; Tiempo de espera de inactividad del Directorio
; Especifica la cantidad de tiempo que ha de transcurrir antes de que 
; una conexin de Directorio inactiva se cierre.
;----------------------------------------------------------------------
;/diridletimeout-[segundos]

;----------------------------------------------------------------------
; Nmero mximo de conexiones con el Directorio
; Especifica el nmero mximo de conexiones con el Directorio.
;----------------------------------------------------------------------
;/dirmaxconnections-[nmero]

;----------------------------------------------------------------------
; Conexiones por defecto con el Directorio
; Especifica el nmero por defecto de las conexiones con el Directorio.
;----------------------------------------------------------------------
;/dirdefaultconnections-[nmero]

;----------------------------------------------------------------------
; Tiempo lmite de la consulta del Directorio
; Especifica el nmero de segundos que han de transcurrir antes de que 
; una bsqueda caduque.  
; El valor por defecto es 30.
;----------------------------------------------------------------------
;/dirquerytimeout-[nmero]

;===================== CONMUTADORES DE REGISTRO =======================

;----------------------------------------------------------------------
; Nivel de registro
; Puede seleccionar que nicamente se registren los errores (Normal), 
; que se incluyan detalles bsicos (Detallado) o que se incluyan todos 
; los detalles (Diagnstico).
;----------------------------------------------------------------------
;/loglevel-[ Normal | Verbose | Diagnostic ]

;----------------------------------------------------------------------
; Registro en disco
; Deshabilita la escritura en el archivo de registro en disco.
;----------------------------------------------------------------------
;/logdiskoff

;----------------------------------------------------------------------
; Directorio de registro
;----------------------------------------------------------------------
;/log-\\[servidor]\[volumen]\[directorio]

;----------------------------------------------------------------------
; Antigedad mxima
; Determina la cantidad mxima de tiempo (nmero de das) durante los 
; cuales reside un archivo de registro en el disco antes de que se 
; elimine automticamente.
;----------------------------------------------------------------------
;/logdays-[das]

;----------------------------------------------------------------------
; Espacio mximo de disco de registro
; Determina el espacio en disco mximo (en megabytes) usado para todos 
; los archivos de registro.
;----------------------------------------------------------------------
;/logmax-[MB]

;================ CONMUTADORES PARA CERTIFICADOS SSL ==================

;----------------------------------------------------------------------
; Habilita SSL para las comunicaciones cliente/servidor
;----------------------------------------------------------------------
;/ssl-[enable | disable]

;----------------------------------------------------------------------
; Certificado SSL
; Certificado de servidor vlido en formato PEM o PFX obtenido a travs 
; de una
; autoridad certificadora.
;----------------------------------------------------------------------
;/certpath-\\[servidor]\[volumen]\[directorio]
;/certfile-\\[servidor]\[volumen]\[directorio]\[certificado]
;/keyfile-\\[servidor]\[volumen]\[directorio]\[clave privada]
;/keypassword-[contrasea de clave]

;=============== CONMUTADORES PARA CLIENTE/SERVIDOR ===================

;----------------------------------------------------------------------
; Nmero de puerto TCP
; Especifica el nmero de puerto al que se conecta el Agente de 
; mensajera para recibir las peticiones cliente/servidor.
; El puerto por defecto es 8300.
; Si varios Agentes de mensajera que dan servicio a peticiones 
; cliente/servidor estn ejecutndose en el mismo equipo, deber 
; especificar un puerto diferente para cada uno de ellos.
;----------------------------------------------------------------------
;/port-[nmero]

;----------------------------------------------------------------------
; Direccin TCP/IP
; Especifica la direccin IP a la que se conecta el Agente de mensajera 
; para recibir las peticiones cliente/servidor. 
; Este conmutador insta al Agente de mensajera a recibir las conexiones 
; mediante una direccin especfica.
;----------------------------------------------------------------------
;/ip-[direccin]

;----------------------------------------------------------------------
; Nmero mximo de conexiones
; Nmero de conexiones cliente/servidor que permite el servidor.
; El valor por defecto es 5120 (5 k).
;----------------------------------------------------------------------
;/maxconns-[nmero]

;----------------------------------------------------------------------
; Nmero de hilos de procesamiento TCP
; Define cuntos hilos genera el Agente de mensajera para gestionar
; las peticiones cliente/servidor. El valor por defecto es 15.
;----------------------------------------------------------------------
;/threads-[nmero]


;===== CONMUTADORES DE PROTOCOLO DE TRANSFERENCIA DE MENSAJES =========

;----------------------------------------------------------------------
; Directorio de cola
;----------------------------------------------------------------------
;/queue-\\[servidor]\[volumen]\[directorio]


;=========== CONMUTADORES DE PROCESAMIENTO DE MENSAJES HTTP ===========

;----------------------------------------------------------------------
; Habilita el uso de HTTP para la consola Web y especifica el nmero de 
; puerto por el que debe recibir las conexiones la consola Web.
;----------------------------------------------------------------------
;/httpport-[nmero de puerto]

;----------------------------------------------------------------------
; Nombre de usuario para autenticar al solicitante de la informacin 
; HTTP
;----------------------------------------------------------------------
;/httpuser-[ID de usuario]

;----------------------------------------------------------------------
; Contrasea de usuario para autenticar al solicitante de la informacin 
; HTTP
;----------------------------------------------------------------------
;/httppassword-[contrasea]

;----------------------------------------------------------------------
; Habilita SSL para HTTPS
;----------------------------------------------------------------------
;/httpssl-[enable | disable]


;============== CONMUTADORES PARA LA AUTENTICACIN LDAP ===============

;----------------------------------------------------------------------
; ID de usuario LDAP
; Este ID de usuario LDAP lo utiliza el Agente de mensajera para 
; establecer una conexin con el servidor LDAP para leer su 
; configuracin. El formato debe ser "cn=userid,ou=group,ou=division,
; o=organization".
;----------------------------------------------------------------------
;/ldapuser-[Formato de nombre completo]  

;-----------------------------------------------------------------------
; Contrasea LDAP
; Contrasea para el usuario LDAP.												
;-----------------------------------------------------------------------
;/ldappwd-[contrasea]        

;-----------------------------------------------------------------------
; Direccin IP del servidor LDAP
; La direccin IP del servidor LDAP en formato con punto o en formato 
; DNS. Si se han especificado varias direcciones de servidor de 
; autenticacin LDAP, el servidor LDAP las utilizar para el modo de 
; RECUPERACIN DE FALLOS. [address] debe especificarse como 
; "123.3.4.1 123.4.5.2 123.3.4.5" (con un espacio entre cada direccin 
; y la siguiente).
;-----------------------------------------------------------------------
;/ldapipaddr-[direccin]  

;-----------------------------------------------------------------------
; Nmero del puerto LDAP
; El nmero del puerto que utiliza el servidor LDAP para la 
; autenticacin. El valor por defecto es 389. Este conmutador se utiliza 
; para especificar el puerto LDAP para el modo de recuperacin de fallos.
;------------------------------------------------------------------------ 
;/ldapport-[nmero]      

;------------------------------------------------------------------------
; Indica al Agente de mensajera si la autenticacin LDAP usa SSL para 
; el modo de recuperacin de fallos.
;------------------------------------------------------------------------
;/ldapssl               

;------------------------------------------------------------------------
; Especifica el nombre del archivo de clave SSL como, por ejemplo, 
; gwkey.der. Este conmutador se usa para el modo de recuperacin de 
; fallos.
;------------------------------------------------------------------------
;/ldapsslkey-[nombre]    

;========================== FIN DEL ARCHIVO ===========================
