;======================================================================
;                   Agent de messagerie Novell Messenger 2.0
;                         Exemple de fichier de dmarrage
;----------------------------------------------------------------------
;  Remplacez les valeurs entre crochets par les vtres.
;
;  Pour activer un paramtre facultatif, supprimez le point-virgule 
; qui le prcde par dfaut.
;
;  Lors de l'enregistrement, utilisez le format ASCII.
;----------------------------------------------------------------------
;  Ce fichier d'exemple comprend deux sections :
;  1) Paramtres disponibles uniquement pour le dmarrage
;    - Gnraux
;    - Spcifiques du module tlchargeable NetWare (NLM)
;  2) Paramtres modifiables depuis ConsoleOne et disponibles pour 
;     le dmarrage.
;    - Consignation d'vnement
;    - Performances
;    - Client/Serveur
;======================================================================

;======================================================================
;                             SECTION 1 :
;             PARAMTRES DISPONIBLES UNIQUEMENT POUR LE DMARRAGE
;======================================================================

;----------------------------------------------------------------------
; DN de l'agent de messagerie
; Exemple : CN=MessagingAgent,OU=NMServer1,OU=MessengerService,O=Novell
;----------------------------------------------------------------------
;/home-[Format DN]

;----------------------------------------------------------------------
; Langue
;----------------------------------------------------------------------
;/language-[ EN | DE | ES | FR | PT ]

;----------------------------------------------------------------------
; Nom d'utilisateur et mot de passe pour autoriser l'agent  lire les 
; paramtres du rpertoire
;----------------------------------------------------------------------
;/user-[ID utilisateur]
;/password-[mot de passe]


;================== CONFIGURATION DU RPERTOIRE =======================

;----------------------------------------------------------------------
; Adresse IP de rplique du rpertoire
; Spcifie l'adresse de rplique du rpertoire.
;----------------------------------------------------------------------
;/dirreplicaipaddr-[adresse]

;----------------------------------------------------------------------
; Forcer l'accs direct des utilisateurs
; Indique que l'accs des utilisateurs au mode rpertoire est direct.
; En consquence, les profils LDAP sont ignors.
;----------------------------------------------------------------------
;/diruserforcedirect

;----------------------------------------------------------------------
; Authentification de l'utilisateur du rpertoire via une liaison
; Dtermine si l'authentification de l'utilisateur s'effectue via une 
; liaison ou via une comparaison. L'option par dfaut est la 
; comparaison.
;----------------------------------------------------------------------
;/diruserauthbind

;----------------------------------------------------------------------
; Temps de rinitialisation de la rserve de rpertoire
; Spcifie le temps d'attente pour mettre un serveur problmatique en 
; rserve.
;----------------------------------------------------------------------
;/dirpoolresettime-[minutes]

;----------------------------------------------------------------------
; Alias ID utilisateur du rpertoire
; Spcifie l'attribut  utiliser au lieu de CN pour authentifier les 
; utilisateurs, effectuer des recherches, etc.
;----------------------------------------------------------------------
;/diruseralias-[nom d'attribut]


;==== PARAMTRES DE PROTOCOLE DE TRANSFERT DE MESSAGES SWITCHES =======

;----------------------------------------------------------------------
; Dsactiver le protocole de transfert de messages pour cet agent
;----------------------------------------------------------------------
;/nomtp

;----------------------------------------------------------------------
; Timeout de connexion du MTP
; Spcifie la dure (en secondes) d'une connexion.
;----------------------------------------------------------------------
;/mtpconnecttimeout-[secondes]

;----------------------------------------------------------------------
; Timeout des donnes du MTP
; Spcifie le temps d'attente (en secondes) d'une requte de donnes.
;----------------------------------------------------------------------
;/mtpdatatimeout-[secondes]

;----------------------------------------------------------------------
; Numro de port de la destination d'envoi du MTP
; Spcifie le numro de port li au MTP pour le transfert de 
; fichier MTP.
;----------------------------------------------------------------------
;/mtpport-[numro de port]

;----------------------------------------------------------------------
; Adresse IP de la destination d'envoi du MTP
; Spcifie l'adresse IP lie  l'agent pour le transfert de 
; fichier MTP.
;----------------------------------------------------------------------
;/mtpipaddr-[adresse]


;================== PARAMTRES SPCIFIQUES DE NLM =====================

;----------------------------------------------------------------------
; SNMP (Simple Network Management Protocol)
; Par dfaut, SNMP est activ pour l'agent de messagerie.
;----------------------------------------------------------------------
;/nosnmp

;----------------------------------------------------------------------
; Informer l'agent de messagerie qu'il s'excute dans une grappe
;----------------------------------------------------------------------
;/cluster

;======================================================================
;                             SECTION 2 :
;                    PARAMTRES DISPONIBLES DANS ConsoleOne
;======================================================================

;================== CONFIGURATION DU RPERTOIRE =======================

;----------------------------------------------------------------------
; Nombre maximum de rsultats de la requte au rpertoire
; Spcifie le nombre maximum de rsultats de toute requte au 
; rpertoire.
;----------------------------------------------------------------------
;/dirquerymaxresults-[nombre]

;----------------------------------------------------------------------
; Timeout d'une connexion inactive au rpertoire
; Spcifie le temps d'attente pour arrter une connexion inactive au 
; rpertoire.
;----------------------------------------------------------------------
;/diridletimeout-[secondes]

;----------------------------------------------------------------------
; Nombre maximum de connexions au rpertoire
; Spcifie le nombre maximum de connexions au rpertoire.
;----------------------------------------------------------------------
;/dirmaxconnections-[nombre]

;----------------------------------------------------------------------
; Nombre par dfaut de connexions au rpertoire
; Spcifie le nombre par dfaut de connexions au rpertoire.
;----------------------------------------------------------------------
;/dirdefaultconnections-[nombre]

;----------------------------------------------------------------------
; Timeout de la requte au rpertoire
; Spcifie le temps d'attente (en secondes) pour arrter une recherche.
; La valeur par dfaut est 30.
;----------------------------------------------------------------------
;/dirquerytimeout-[nombre]

;================ PARAMTRES DE CONSIGNATION ==========================

;----------------------------------------------------------------------
; Niveau de consignation
; Consignation des erreurs uniquement (Normal), des dtails de base 
; (Verbeux) ou des dtails complets (Diagnostic).
;----------------------------------------------------------------------
;/loglevel-[ Normal | Verbose | Diagnostic ]

;----------------------------------------------------------------------
; Consignation sur disque
; Dsactivation de l'criture du fichier journal sur le disque.
;----------------------------------------------------------------------
;/logdiskoff

;----------------------------------------------------------------------
; Rpertoire du journal
;----------------------------------------------------------------------
;/log-\\[serveur]\[volume]\[rpertoire]

;----------------------------------------------------------------------
; ge maximum du fichier journal
; Dure (en jours) pendant laquelle le fichier journal rside sur le 
; disque avant d'tre automatiquement supprim.
;----------------------------------------------------------------------
;/logdays-[jours]

;----------------------------------------------------------------------
; Espace disque maximum des fichiers journaux
; Quantit maximum d'espace disque (en Mo) affecte aux fichiers 
; journaux.
;----------------------------------------------------------------------
;/logmax-[Mo]

;================= PARAMTRES DE CERTIFICAT SSL =======================

;----------------------------------------------------------------------
; Activer SSL pour les communications client/serveur
;----------------------------------------------------------------------
;/ssl-[enable | disable]

;----------------------------------------------------------------------
; Certificat SSL
; Certificat de serveur valide au format PEM ou PFX, obtenu auprs
; d'une autorit de certification (CA).
;----------------------------------------------------------------------
;/certpath-\\[serveur]\[volume]\[rpertoire]
;/certfile-\\[serveur]\[volume]\[rpertoire]\[certificat]
;/keyfile-\\[serveur]\[volume]\[rpertoire]\[cl prive]
;/keypassword-[mot de passe cl]

;=================== PARAMTRES CLIENT/SERVEUR ========================

;----------------------------------------------------------------------
; Numro de port TCP
; Numro de port sur lequel l'agent de messagerie coute les requtes 
; client/serveur.
; Le numro de port par dfaut est 8300.
; Si plusieurs instances de l'agent de messagerie grent les requtes 
; client/serveur s'excutant sur la mme machine, vous devez spcifier 
; un port diffrent pour chaque instance.
;----------------------------------------------------------------------
;/port-[nombre]

;----------------------------------------------------------------------
; Adresse TCP/IP
; Adresse IP sur laquelle l'agent de messagerie coute les requtes 
; client/serveur.
; Ce paramtre demande  l'agent de messagerie d'couter les requtes 
; sur une adresse spcifique.
;----------------------------------------------------------------------
;/ip-[adresse]

;----------------------------------------------------------------------
; Nombre maximum de connexions
; Nombre de connexions client/serveur autoris par le serveur.
; La valeur par dfaut est 5120.
;----------------------------------------------------------------------
;/maxconns-[nombre]

;----------------------------------------------------------------------
; Nombre de threads de traitement TCP
; Nombre de threads  reproduire par l'agent de messagerie pour grer 
; des requtes client/serveur. La valeur par dfaut est 15.
;----------------------------------------------------------------------
;/threads-[nombre]


;======= PARAMTRES DE PROTOCOLES DE TRANSFERT DE MESSAGES ============

;----------------------------------------------------------------------
; Rpertoire de la file d'attente
;----------------------------------------------------------------------
;/queue-\\[serveur]\[volume]\[rpertoire]


;======== PARAMTRES DE TRAITEMENT DES MESSAGES HTTP ==================

;----------------------------------------------------------------------
; Activer l'utilisation de HTTP pour WebConsole et spcifier le numro 
; de port  couter pour WebConsole
;----------------------------------------------------------------------
;/httpport-[numro de port]

;----------------------------------------------------------------------
; Nom d'utilisateur pour authentifier l'auteur d'une requte 
; d'informations HTTP
;----------------------------------------------------------------------
;/httpuser-[ID utilisateur]

;----------------------------------------------------------------------
; Mot de passe utilisateur pour authentifier l'auteur d'une requte 
; d'informations
; HTTP
;----------------------------------------------------------------------
;/httppassword-[mot de passe]

;----------------------------------------------------------------------
; Activer SSL pour HTTPS
;----------------------------------------------------------------------
;/httpssl-[enable | disable]


;============= PARAMTRES D'AUTHENTIFICATION LDAP =====================

;----------------------------------------------------------------------
; ID utilisateur LDAP
; Ce paramtre est utilis par l'agent de messagerie pour tablir la 
; connexion avec le serveur LDAP et lire sa configuration. Le format 
; doit tre "cn=userid,ou=group,ou=division,o=organization".
;----------------------------------------------------------------------
;/ldapuser-[Format DN]

;-----------------------------------------------------------------------
; Mot de passe LDAP
; Mot de passe de l'utilisateur LDAP.												
;-----------------------------------------------------------------------
;/ldappwd-[mot de passe]

;-----------------------------------------------------------------------
; Adresse IP du serveur LDAP
; Adresse IP du serveur LDAP en notation  points ou au format DNS. 
; Si plusieurs adresses de serveurs d'authentification LDAP sont 
; spcifies, elles sont utilises par le serveur LDAP en reprise aprs
; chec. Le format de [address] doit tre 
; "123.3.4.1 123.4.5.2 123.3.4.5" avec un espace entre chaque adresse.
;-----------------------------------------------------------------------
;/ldapipaddr-[adresse]

;-----------------------------------------------------------------------
; Numro de port LDAP
; Par dfaut, le serveur d'authentification LDAP coute le port 389. 
; Ce paramtre spcifie le port LDAP pour la reprise aprs chec.
;------------------------------------------------------------------------
;/ldapport-[nombre]

;------------------------------------------------------------------------
; Indiquer  l'agent de messagerie si l'authentification LDAP utilise 
; SSL pour la reprise aprs chec.
;------------------------------------------------------------------------
;/ldapssl

;------------------------------------------------------------------------
; Spcifier le nom du fichier de cl SSL (par exemple, gwkey.der). 
; Ce paramtre est utilis pour la reprise aprs chec.
;------------------------------------------------------------------------
;/ldapsslkey-[nom]

;======================== FIN DU FICHIER ===============================
