;======================================================================
;                   Agente de Mensagens do Novell Messenger 2.0
;                         Exemplo de arquivo de inicializao
;----------------------------------------------------------------------
;  Substitua os valores entre colchetes pelos seus prprios valores.
;
;  Todos os switches adicionais so desabilitados com a colocao do 
;  ponto-e-vrgula na frente do switch.  Para habilitar um switch, 
;  remova o ponto-e-vrgula.
;
;  Grave os dados no formato ASCII.  
;----------------------------------------------------------------------
;  Este arquivo de exemplo tem duas sees:
;  1) Configuraes disponveis somente como switches de inicializao
;    - Geral
;    - Especficas do NLM (NetWare Loadable Module)
;  2) Configuraes que devem ser modificadas a partir do ConsoleOne 
;     mas que tambm esto disponveis como switches de inicializao.
;    - Registro de Eventos
;    - Desempenho
;    - Cliente/Servidor
;======================================================================

;======================================================================
;                             SEO 1:
;   CONFIGURAES DISPONVEIS SOMENTE COMO SWITCHES DE CONFIGURAO
;======================================================================

;----------------------------------------------------------------------
; DN do Agente de Mensagens
; Exemplo: CN=MessagingAgent,OU=NMServer1,OU=MessengerService,O=Novell
;----------------------------------------------------------------------
;/home-[Formato de DN]

;----------------------------------------------------------------------
; Idioma
;----------------------------------------------------------------------
;/language-[ EN | DE | ES | FR | PT ]

;----------------------------------------------------------------------
; Usurio e senha usados para que o agente possa ler configuraes 
; do diretrio.
;----------------------------------------------------------------------
;/user-[ID do usurio]
;/password-[senha]


;==================== CONFIGURAO DO DIRETRIO =======================

;----------------------------------------------------------------------
; Endereo IP de Rplica do Diretrio
; Especifica o endereo da rplica do diretrio.
;----------------------------------------------------------------------
;/dirreplicaipaddr-[endereo]

;----------------------------------------------------------------------
; Forar Sesso de Usurio a Usar Acesso Direto
; Especifica que o modo de diretrio do usurio  de acesso direto.
; Isso faz com que os perfis LDAP sejam ignorados.
;----------------------------------------------------------------------
;/diruserforcedirect

;----------------------------------------------------------------------
; Autenticao do Usurio de Diretrio atravs de Vinculao
; Especifica se a autenticao do usurio deve ser realizada atravs de
; vinculao ou comparao. O padro  a comparao.
;----------------------------------------------------------------------
;/diruserauthbind

;----------------------------------------------------------------------
; Tempo de Redefinio do Pool de Diretrios
; Especifica o perodo at a incluso de um servidor problemtico 
; de volta no pool.
;----------------------------------------------------------------------
;/dirpoolresettime-[minutos]

;----------------------------------------------------------------------
; lias do ID de Usurio de Diretrio
; Especifica o atributo a ser usado em vez do CN para autenticaes do 
; usurio, pesquisas etc.
;----------------------------------------------------------------------
;/diruseralias-[nome do atributo]


;======== PROTOCOLO DE TRANSFERNCIA DE MENSAGENS SWITCHES ============

;----------------------------------------------------------------------
; Desabilita o Message Transfer Protocol neste agente.
;----------------------------------------------------------------------
;/nomtp

;----------------------------------------------------------------------
; Tempo de Espera de Conexo MTP
; Especifica, em segundos, a durao da conexo at que seu tempo de 
; espera se esgote.
;----------------------------------------------------------------------
;/mtpconnecttimeout-[segundos]

;----------------------------------------------------------------------
; Tempo de Espera de Dados MTP
; Especifica, em segundos, o perodo em que uma solicitao aguarda 
; dados at que o tempo de espera se esgote.
;----------------------------------------------------------------------
;/mtpdatatimeout-[segundos]

;----------------------------------------------------------------------
; Nmero da Porta de Destino de Envio do MTP
; Especifica o nmero de porta a que o MTP se vincular para a 
; transferncia de arquivos do MTP.
;----------------------------------------------------------------------
;/mtpport-[nmero da porta]

;----------------------------------------------------------------------
; Endereo IP de Destino de Envio do MTP; Especifica o endereo IP ao 
; qual o agente se vincula para a transferncia de arquivos do MTP.
;----------------------------------------------------------------------
;/mtpipaddr-[endereo]


;================= SWITCHES ESPECFICOS DO NLM ========================

;----------------------------------------------------------------------
; SNMP (Simple Network Management Protocol)
; Por padro, o Agente de Mensagens est habilitado para SNMP.
;----------------------------------------------------------------------
;/nosnmp

;----------------------------------------------------------------------
; Informa o Agente de Mensagens de que est em execuo em um cluster.
;----------------------------------------------------------------------
;/cluster

;======================================================================
;                             SEO 2:
;                    CONFIGURAES DISPONVEIS NO ConsoleOne
;======================================================================

;==================== CONFIGURAO DO DIRETRIO =======================

;----------------------------------------------------------------------
; Mximo de Resultados da Consulta de Diretrio
; Especifica o nmero mximo de resultados retornados para 
; solicitaes ao diretrio.
;----------------------------------------------------------------------
;/dirquerymaxresults-[nmero]

;----------------------------------------------------------------------
; Tempo de Espera de Inatividade do Diretrio
; Especifica o perodo at o fechamento de uma conexo de 
; diretrio inativa.
;----------------------------------------------------------------------
;/diridletimeout-[segundos]

;----------------------------------------------------------------------
; Mximo de Conexes do Diretrio
; Especifica o nmero mximo de conexes do diretrio.
;----------------------------------------------------------------------
;/dirmaxconnections-[nmero]

;----------------------------------------------------------------------
; Conexes Padro do Diretrio
; Especifica o nmero padro de conexes do diretrio.
;----------------------------------------------------------------------
;/dirdefaultconnections-[nmero]

;----------------------------------------------------------------------
; Tempo de Espera de Consulta do Diretrio
; Especifica o nmero de segundos at o trmino do tempo de espera 
; de uma pesquisa.  
; O padro  30.
;----------------------------------------------------------------------
;/dirquerytimeout-[nmero]

;=================== SWITCHES DE REGISTRO =============================

;----------------------------------------------------------------------
; Nvel de Registro
; Seleciona somente o registro de erros (Normal), detalhes bsicos 
; (Verboso) ou detalhes completos (Diagnstico).
;----------------------------------------------------------------------
;/loglevel-[ Normal | Verbose | Diagnostic ]

;----------------------------------------------------------------------
; Registro em Disco
; Desabilita a gravao do arquivo de registro no disco.
;----------------------------------------------------------------------
;/logdiskoff

;----------------------------------------------------------------------
; Diretrio de Registro
;----------------------------------------------------------------------
;/log-\\[servidor]\[volume]\[diretrio]

;----------------------------------------------------------------------
; Durao Mx. Arq. de Registro
; Determina por quanto tempo (nmero de dias) um arquivo de registro 
; deve permanecer no disco antes de ser apagado automaticamente.
;----------------------------------------------------------------------
;/logdays-[dias]

;----------------------------------------------------------------------
; Espao Mx. Disco de Registro
; Determina o espao mximo no disco (em megabytes) usado para todos 
; os arquivos de registro.
;----------------------------------------------------------------------
;/logmax-[mb]

;================== SWITCHES DE CERTIFICADO SSL =======================

;----------------------------------------------------------------------
; Habilitar SSL para a comunicao cliente/servidor
;----------------------------------------------------------------------
;/ssl-[enable | disable]

;----------------------------------------------------------------------
; Certificado SSL
; Certificado de servidor vlido no formato PEM ou PFX obtido de uma
; Autoridade de Certificao (CA).
;----------------------------------------------------------------------
;/certpath-\\[servidor]\[volume]\[diretrio]
;/certfile-\\[servidor]\[volume]\[diretrio]\[certificado]
;/keyfile-\\[servidor]\[volume]\[diretrio]\[chave privada]
;/keypassword-[senha da chave]

;================ SWITCHES DE CLIENTE/SERVIDOR ========================

;----------------------------------------------------------------------
; Nmero da Porta TCP
; Especifica o nmero da porta em que o Agente de Mensagens receber 
; solicitaes cliente/servidor.
; A porta padro  8300.
; Se houver vrias instncias do Agente de Mensagens atendendo a 
; solicitaes de cliente/servidor no mesmo computador, voc dever 
; especificar uma porta distinta para cada instncia.
;----------------------------------------------------------------------
;/port-[nmero]

;----------------------------------------------------------------------
; Endereo TCP/IP
; Especifica o endereo IP atravs do qual o Agente de Mensagens 
; receber solicitaes de cliente/servidor. 
; Este switch instrui o Agente de Mensagens a escutar em um endereo 
; especfico.
;----------------------------------------------------------------------
;/ip-[endereo]

;----------------------------------------------------------------------
; N Mximo de Conexes
; O nmero de conexes de cliente/servidor permitidas pelo servidor.
; O padro  5120 (5K).
;----------------------------------------------------------------------
;/maxconns-[nmero]

;----------------------------------------------------------------------
; Nmero de Processos de TCP
; Define quantos processos so gerados pelo Agente de Mensagens para a 
; manipulao de solicitaes cliente/servidor. O padro  15.
;----------------------------------------------------------------------
;/threads-[nmero]


;===== SWITCHES DO PROTOCOLO DE TRANSFERNCIA DE MENSAGENS ============

;----------------------------------------------------------------------
; Diretrio da Fila
;----------------------------------------------------------------------
;/queue-\\[servidor]\[volume]\[diretrio]


;=========== SWITCHES DE PROCESSAMENTO DE MENSAGENS HTTP ==============

;----------------------------------------------------------------------
; Permite o uso de HTTP no WebConsole e especifica o nmero da porta 
; de escuta para o WebConsole.
;----------------------------------------------------------------------
;/httpport-[nmero da porta]

;----------------------------------------------------------------------
; Nome de Usurio para o Requester de Autenticao das Informaes HTTP
;----------------------------------------------------------------------
;/httpuser-[ID do usurio]

;----------------------------------------------------------------------
; Senha do Usurio para o Requester de Autenticao das Informaes
; HTTP
;----------------------------------------------------------------------
;/httppassword-[senha]

;----------------------------------------------------------------------
; Habilitar SSL para HTTPS
;----------------------------------------------------------------------
;/httpssl-[enable | disable]


;=================== SWITCHES DE AUTENTICAO LDAP =====================

;----------------------------------------------------------------------
; ID de usurio LDAP 
; Este ID de usurio LDAP  usado pelo Agente de Mensagens para 
; estabelecer conexo com o servidor LDAP a fim de ler sua 
; configurao. O formato deve ser 
; "cn=userid,ou=group,ou=division,o=organization".
;----------------------------------------------------------------------
;/ldapuser-[Formato de DN]  

;-----------------------------------------------------------------------
; Senha LDAP
; A senha do usurio LDAP.												
;-----------------------------------------------------------------------
;/ldappwd-[senha]        

;-----------------------------------------------------------------------
; Endereo IP do Servidor LDAP
; O endereo IP do servidor LDAP no formato DNS ou de ponto.  
; Se vrios endereos de servidor de autenticao LDAP forem 
; especificados, eles sero usados pelo servidor LDAP no modo de 
; FAILOVER. O [address] deve ser especificado como 
; "123.3.4.1 123.4.5.2 123.3.4.5"  com um espao entre cada endereo.
;-----------------------------------------------------------------------
;/ldapipaddr-[endereo]  

;-----------------------------------------------------------------------
; Nmero da Porta LDAP
; O nmero da porta de escuta do servidor LDAP para a autenticao 
; padro  389. Este switch  usado para especificar a porta LDAP para 
; o modo de failover.
;------------------------------------------------------------------------ 
;/ldapport-[nmero]      

;------------------------------------------------------------------------
; Indica ao Agente de Mensagens se a autenticao LDAP est usando 
; SSL para o modo de failover.
;------------------------------------------------------------------------
;/ldapssl               

;------------------------------------------------------------------------
; Especifica o nome do arquivo de chave SSL como gwkey.der  Este switch
;  usado no modo de failover.
;------------------------------------------------------------------------
;/ldapsslkey-[nome]    

;======================= FIM DO ARQUIVO ===============================
