/*++

Copyright (c) 1996  Digital Equipment Corporation

Module Name:

    vendor.h

Abstract:

    This header defines the Alpha/ARC private interface.

Author:

    Hy Pham       [DEC] 10-Oct-96

Revision History:

--*/

#ifndef _VENDOR_H_
#define _VENDOR_H_

#include <arc.h>

//
// 32-bit Super Page Base
//

#define KSEG0           0x80000000

//
// Allocation Function
//

void *
AllocatePool(
	ULONG NumberOfBytes
	);

//
// System Function
//

void
StallExecution(
	ULONG Microseconds
	);

//
// Print Function
//

ULONG
Print(
	char *Format,
	...
	);

//
// System Information Functions
//

typedef struct {
    ULONG   ProcessorId;
    ULONG   ProcessorRevision;
    ULONG   ProcessorPageSize;
    ULONG   NumberOfPhysicalAddressBits;
    ULONG   MaximumAddressSpaceNumber;
    ULONG   ProcessorCycleCounterPeriod;
    ULONG   SystemRevision;
    UCHAR   SystemSerialNumber[16];
    UCHAR   FirmwareVersion[16];
    UCHAR   FirmwareBuildTimeStamp[12];   // yymmdd.hhmm (Available as of 5.10)
} EXTENDED_SYSTEM_INFORMATION,*PEXTENDED_SYSTEM_INFORMATION; 


void 
ReturnExtendedSystemInformation (
	EXTENDED_SYSTEM_INFORMATION *SystemInfo
	);

ULONG
VideoDisplayInitialize (
	void *UnusedParameter
	);

//
// EISA Memory Space Functions
//

ULONG
EISAReadRegisterBufferUCHAR (
    ULONG BusNumber,
    ULONG Offset,
    void  *Buffer,
    ULONG Length
    );

ULONG
EISAWriteRegisterBufferUCHAR (
    ULONG BusNumber,
    ULONG Offset,
    void  *Buffer,
    ULONG Length
    );

//
// EISA I/O Space Functions
//

UCHAR
EISAReadPortUCHAR (
    ULONG BusNumber,
    ULONG Offset
    );

USHORT
EISAReadPortUSHORT (
    ULONG BusNumber,
    ULONG Offset
    );

ULONG
EISAReadPortULONG (
	ULONG BusNumber,
    ULONG Offset
    );

void
EISAWritePortUCHAR (
    ULONG BusNumber,
    ULONG Offset,
    UCHAR Datum
    );

void
EISAWritePortUSHORT (
    ULONG BusNumber,
    ULONG Offset,
    USHORT Datum
    );

void
EISAWritePortULONG (
    ULONG BusNumber,
    ULONG Offset,
    ULONG Datum
    );

//
//  Deallocation Function
//

void
FreePool (
    void *MemoryPointer
    );

//
// Call Back Intel Bios Function
//

typedef struct {
    ULONG Eax;
    ULONG Ebx;
    ULONG Ecx;
    ULONG Edx;
    ULONG Esi;
    ULONG Edi;
    ULONG Ebp;
} X86_BIOS_ARGUMENTS,*PX86_BIOS_ARGUMENTS;

BOOLEAN
CallBios (
    ULONG InterruptNumber,
    X86_BIOS_ARGUMENTS *BiosArguments
    );

//
// Bus Address Translation Functions
//

#if !defined(_NTDDK_) && !defined(_MINIPORT_)

typedef enum {
    InterfaceTypeUndefined = -1,
    Internal,
    Isa,
    Eisa,
    MicroChannel,
    TurboChannel,
    PCIBus,
    VMEBus,
    NuBus,
    PCMCIABus,
    CBus,
    MPIBus,
    MPSABus,
    ProcessorInternal,
    InternalPowerBus,
    PNPISABus,
    MaximumInterfaceType
}INTERFACE_TYPE,*PINTERFACE_TYPE;

#endif // !defined(_NTDDK_) && !defined(_MINIPORT_)

BOOLEAN
TranslateBusAddress (
    INTERFACE_TYPE  InterfaceType,
    ULONG BusNumber,
    LARGE_INTEGER BusAddress,
    ULONG *AddressSpace,
    LARGE_INTEGER *TranslatedAddress
    );

//
// Port Space Functions
//

UCHAR
ReadPortUCHAR (
    UCHAR *Port
    );

USHORT
ReadPortUSHORT (
    USHORT *Port
    );

ULONG
ReadPortULONG (
    ULONG *Port
    );

void
WritePortUCHAR (
    UCHAR *Port,
    UCHAR  Value
    );

void
WritePortUSHORT (
    USHORT *Port,
    USHORT  Value
    );

void
WritePortULONG (
    ULONG *Port,
    ULONG   Value
    );

//
// Register Functions
//

UCHAR
ReadRegisterUCHAR (
    UCHAR *Register
    );


USHORT
ReadRegisterUSHORT (
    USHORT *Register
    );

ULONG
ReadRegisterULONG (
    ULONG *Register
    );

void
WriteRegisterUCHAR (
    UCHAR *Register,
    UCHAR  Value
    );

void
WriteRegisterUSHORT (
    USHORT *Register,
    USHORT  Value
    );

void
WriteRegisterULONG (
    ULONG *Register,
    ULONG  Value
    );

//
// Bus Data Functions
//

#if !defined(_NTDDK_) && !defined(_MINIPORT_)

typedef enum {
    ConfigurationSpaceUndefined = -1,
    Cmos,
    EisaConfiguration,
    Pos,
    CbusConfiguration,
    PCIConfiguration,
    VMEConfiguration,
    NuBusConfiguration,
    PCMCIAConfiguration,
    MPIConfiguration,
    MPSAConfiguration,
    PNPISAConfiguration,
    MaximumBusDataType
} BUS_DATA_TYPE,*PBUS_DATA_TYPE;

#endif //!defined(_NTDDK_) && !defined(_MINIPORT_)

ULONG
GetBusDataByOffset(
    BUS_DATA_TYPE  BusDataType,
    ULONG BusNumber,
    ULONG SlotNumber,
    void *Buffer,
    ULONG Offset,
    ULONG Length
    );


ULONG
SetBusDataByOffset(
    BUS_DATA_TYPE  BusDataType,
    ULONG BusNumber,
    ULONG SlotNumber,
    void  *Buffer,
    ULONG Offset,
    ULONG Length
    );

// 
// Print Unicode Function
//

ULONG
WidePrint (
    WCHAR *Format,
    ...
    );

//
// Language ID Functions
//

typedef enum {
    LANGUAGE_ID_UNKNOWN,    
    LANGUAGE_ID_ENGLISH,
    LANGUAGE_ID_FRENCH,
    LANGUAGE_ID_GERMAN,
    LANGUAGE_ID_SPANISH,
    LANGUAGE_ID_JAPANESE,
    LANGUAGE_ID_ITALIAN,
    LANGUAGE_ID_ENGLISH_UK,
    LANGUAGE_ID_MAXIMUM
} LANGUAGE_ID_TYPE,*PLANGUAGE_ID_TYPE;


LONG
ReturnLanguageId ( 
    void 
    );

//
// Adapter Object Function
//

#if !defined(_NTDDK_) && !defined(_MINIPORT_)

typedef enum{
    Width8Bits,
    Width16Bits,
    Width32Bits,
    MaximumDmaWidth
}DMA_WIDTH,*PDMA_WIDTH;

typedef enum{
    Compatible,
    TypeA,
    TypeB,
    TypeC,
    MaximumDmaSpeed
}DMA_SPEED,*PDMA_SPEED;

#endif // !defined(_NTDDK_) && !defined(_MINIPORT_)

#ifndef _NTDDK_

typedef struct{
    ULONG Version;
    BOOLEAN Master;
    BOOLEAN ScatterGather;
    BOOLEAN DemandMode;
    BOOLEAN AutoInitialize;
    BOOLEAN Dma32BitAddresses;
    BOOLEAN IgnoreCount;
    BOOLEAN Reserved1;          // must be false
    BOOLEAN Reserved2;          // must be false
    ULONG BusNumber;
    ULONG DmaChannel;
    INTERFACE_TYPE  InterfaceType;
    DMA_WIDTH DmaWidth;
    DMA_SPEED DmaSpeed;
    ULONG MaximumLength;
    ULONG DmaPort;
} DEVICE_DESCRIPTION,*PDEVICE_DESCRIPTION;

#endif //_NTDDK_ 

typedef struct _ADAPTER_OBJECT{
    struct _ADAPTER_OBJECT *MasterAdapter;
} ADAPTER_OBJECT;



ADAPTER_OBJECT *
GetAdapter(
    DEVICE_DESCRIPTION *DeviceDescription,
    ULONG *NumberOfMapRegisters
    );

//
// Memory Map Functions
//

void *
AllocateCommonBuffer(
    ADAPTER_OBJECT *AdapterObject,
    ULONG Length,
    LARGE_INTEGER *LogicalAddress,
    BOOLEAN CacheEnabled
    );

void
FreeCommonBuffer(
    ADAPTER_OBJECT *AdapterObject,
    ULONG Length,
    LARGE_INTEGER LogicalAddress,
    void *VirtualAddress,
    BOOLEAN CacheEnabled
    );

//
// Information Functions
//

typedef struct{
    ULONG  Version;
    UCHAR **SearchPath;
    UCHAR *Reserved1;
    UCHAR *Reserved2;
    UCHAR *Reserved3;
    UCHAR *Reserved4;

} ARC_INFORMATION,*PARC_INFORMATION;

ULONG
ReturnArcInformation(
	ARC_INFORMATION *ArcInfo
	);


ULONG
IssueSrbDirect(
	UCHAR ScsiAdapterID,
	UCHAR PathID,
	UCHAR TargetID,
	UCHAR LunID,
	void  *Srb,
	void  *BufferAddress,
	ULONG BufferLength,
	BOOLEAN WriteToDevice
	);

//
// Define special character values. 
//

#define ASCII_NUL 0x00
#define ASCII_BEL 0x07
#define ASCII_BS  0x08
#define ASCII_HT  0x09
#define ASCII_LF  0x0A
#define ASCII_VT  0x0B
#define ASCII_FF  0x0C
#define ASCII_CR  0x0D
#define ASCII_CSI 0x9B
#define ASCII_ESC 0x1B
#define ASCII_SYSRQ 0x80

//
// Define screen colors.
//

typedef enum _ARC_SCREEN_COLOR {
    ArcColorBlack,
    ArcColorRed,
    ArcColorGreen,
    ArcColorYellow,
    ArcColorBlue,
    ArcColorMagenta,
    ArcColorCyan,
    ArcColorWhite,
    MaximumArcColor
    } ARC_SCREEN_COLOR;

//
// Print macros.
//

#define VenClearScreen() \
    Print("%c2J", ASCII_CSI)

#define VenMoveCursorToColumn(Spaces) \
    Print("\r\x9B"#Spaces"C")

#define VenSetScreenColor(FgColor, BgColor) \
    Print("%c3%dm", ASCII_CSI, (UCHAR)FgColor); \
    Print("%c4%dm", ASCII_CSI, (UCHAR)BgColor)

#define VenSetScreenAttributes( HighIntensity, Underscored, ReverseVideo ) \
    Print("%c0m", ASCII_CSI); \
    if (HighIntensity) { \
        Print("%c1m", ASCII_CSI); \
    } \
    if (Underscored) { \
        Print("%c4m", ASCII_CSI); \
    } \
    if (ReverseVideo) { \
        Print("%c7m", ASCII_CSI); \
    }

#define VenSetPosition( Row, Column ) \
    Print("%c%d;", ASCII_CSI, Row); \
    Print("%dH", Column)



#endif
