
/*************************************************************/
/**                                                         **/
/**                 Microsoft RPC Examples                  **/
/**                 OSF DCE Interop Application             **/
/**             Copyright(c) Microsoft Corp. 1993           **/
/**                                                         **/
/*************************************************************/

#include <stdio.h>
#include "msg.h"    /* header file generated by M/IDL compiler */

#if defined(__RPC_WIN32__) || defined(__RPC_DOS__)
#include "dceport.h"
#endif

/*
 * Print out client messages
 */

void ClientMessage(unsigned char *message)
{
    printf("%s\n", message);
    return;
}

/*
 * The client can stop the server by calling this operation.
 */
void ShutdownServer()
{
    unsigned32 status;
    rpc_mgmt_stop_server_listening(0, &status);
    if (status)
        {
        printf("rpc_mgmt_stop_server_listening returns 0x%x\n", status);
        }
    return;
}

