//
// File name: 3dengine.CPP
//
// Description: The main file for a tiny 3D game
//

// ------------------------------------------------------------
// | Global include files:                                    |
// ------------------------------------------------------------


#include <Math.H>
#include <Conio.H>
#include <Time.H>
#include <Stdio.H>
#include <Windows.h>
#include <Iostream.H>
// ------------------------------------------------------------
// | Local include files:                                     |
// ------------------------------------------------------------

#include "TextType.HPP"
#include "3Dclass.HPP"
#include "LineType.HPP"
#include "PalShade.HPP"
#include "FastWin.HPP"
#include "scrsize.HPP"

#include "resource.H"

// ------------------------------------------------------------
// | Global variables/constants:                              |
// ------------------------------------------------------------

LRESULT CALLBACK WndProc ( HWND hWnd, unsigned int iMessage,
                          unsigned int wParam, LONG lParam );

HANDLE ThisInstance;
long RightButton = FALSE, LeftButton = FALSE, MiddleButton = FALSE, 
     Keys, Dir, Mag, sXPos, sYPos, MOldX, MOldY, MOld1X, MOld1Y;
long KeyPressed = FALSE, AktKey; 
BOOL Running = TRUE;

const long SCREEN_WIDTH = sbredde;
const long SCREEN_HEIGHT = shoejde;

// ------------------------------------------------------------
// | Local structs/classes:                                   |
// ------------------------------------------------------------

struct View 
{
	int XRot, YRot, ZRot;
	float XPos, YPos, ZPos;
	View () 
	{ 
		XRot = YRot = ZRot = 0;
		XPos = YPos = ZPos = 0.0F; 
	}
	void Clear () 
	{ 
		XRot = YRot = ZRot = 0;
		XPos = YPos = ZPos = 0.0F; 
	}
};


// ------------------------------------------------------------
// | Function section:                                        |
// ------------------------------------------------------------

int InitZBuffer ()
  {
  // Allocate memory for Z-buffer:
  if ( ( ZBuffer = new long [ zbufsize ] ) == 0 )
     return 0;
  return 1;
  }

int DestZBuffer ()
  {
  // Deallocate Z-buffer's memory:
  delete [] ZBuffer;
  if ( ZBuffer )
     return 0;
  return 1;
  }

void ClearBuffer ()
   {
   // Clear the Z-buffer:
   long *ZPtr = ZBuffer;
   for ( unsigned int Index = 0; Index < zrun; Index++ )
       {
       *ZPtr++ = 0;
       *ZPtr++ = 0;

       *ZPtr++ = 0;
       *ZPtr++ = 0;

       *ZPtr++ = 0;
       *ZPtr++ = 0;

       *ZPtr++ = 0;
       *ZPtr++ = 0;

       *ZPtr++ = 0;
       *ZPtr++ = 0;
       }
   }

  void HandleKey( PanelObject *World, long key)
  {
	  switch(key) {
	  case ('\t'):
		  {
			  World->SelNext();
			  break;
		  }
	  case ('t'):
	  case ('T'):
		  {
			  World->NexText();
			  break;
		  }
	  case ('r'):
	  case ('R'):
		  {
			  World->RotText ();
			  break;
		  }
	  case ('M'):
		  {
	//		  World->MoveText (MOldX, MOldY,);
	//		  break;
		  }
	  default: break;
	  }
  }

  

// ------------------------------------------------------------
// | Program entry:                                           |
// ------------------------------------------------------------

int WINAPI WinMain ( HANDLE hInstance, HANDLE hPrevInstance,
		    LPSTR lpszCmdParam, int nCmdShow )
{
	hPrevInstance; 
	lpszCmdParam;
	ThisInstance = hInstance;
	HWND hWnd;
	MSG Message;
	WNDCLASS WndClass;
	Matrix3D M, Copy; 
	View V;
	unsigned char *VidBuf;
	unsigned int MaxWait, BackC, FrameNum = 0, OldXRot = 0,
       Looking = FALSE, FrameCount = 0, NoSound = 0;
	ZTrans = 0;
	FastWin MyWin;


	// Allocate memory for a panel object:
	PanelObject *World = new PanelObject;

	// Allocate memory for Z-buffer:
	InitZBuffer ();

	// Read the panel data:
	World->LoadDXF ( "Test.DXF" );

	//  World->WriteBIN ( "Test1.BIN" );
	World->ReadBIN ( "Test.BIN" );

	// Read -- if possible -- the texture data:
	if ( World->ReadText ( "Text.BT" ) == FALSE )
    {
		if ( TextDat.LoadINI ( "Text.INI" ) == FALSE )
        {
			delete World;
			return 0;
        }
		// Initialize default texture coords:
		World->InitDefText ();
    }
	// Read -- if possible -- the shade table:
	if ( TextShade.LoadTable ( "Shade.TAB" ) == FALSE )
     {
     // Generate a palette that fades to Black:
     TextShade.GenTable ( 0.0F, 0.0F, 0.0F,
                          TextDat.TMap [ 0 ].Palette );
     TextShade.SaveTable ( "Shade.TAB" );
     }

  MyWin.Init ( sbredde, shoejde, TextDat.TMap [ 0 ].Palette );
  VidBuf = ( unsigned char * ) MyWin;

  // Raise the viewer and move forward:
  M.Initialize ();
  M.Translate ( 0, -700, 600 );
  ClearBuffer ();
  World->Display ( M, VidBuf );
  MaxWait = ( long ) pow ( 2, 31 - ZSTEP_PREC  );

  // Calculate the background color:
  BackC = GetColor ( 15, 15, 125, TextDat.TMap [ 0 ].Palette );

  WndClass.cbClsExtra = 0;
  WndClass.cbWndExtra = 0;
  WndClass.hbrBackground = GetStockObject ( GRAY_BRUSH );
  WndClass.hCursor =  LoadCursor ( NULL, IDC_ARROW );
  WndClass.hIcon = LoadIcon ( hInstance, NULL );
  WndClass.hInstance = hInstance;
  WndClass.lpfnWndProc = WndProc;
  WndClass.lpszClassName = "NEWTEC";
  WndClass.lpszMenuName = ( const char * ) IDR_MENU1;
  WndClass.style = CS_HREDRAW | CS_VREDRAW | CS_OWNDC;

  if ( !RegisterClass ( &WndClass ) )
     return 0;           

  hWnd = CreateWindow ( "NEWTEC",             // class name
						"3D-Engine",  // Caption
                        WS_CAPTION | WS_MINIMIZEBOX | WS_SYSMENU,// Style
                        CW_USEDEFAULT,           // x position
                        CW_USEDEFAULT,           // y position
                        sbredde,                 // cx - size
                        shoejde + 40,            // cy - size
                        NULL,                    // Parent window
                        NULL,                    // Menu
                        hInstance,               // Program Instance
                        NULL );                  // Parameters

  ShowWindow ( hWnd, nCmdShow );

  MyWin.Colors ();

  while ( Running )
  {
	  // Process frame:
		if(KeyPressed == TRUE)
		{
			HandleKey(World, AktKey);
			KeyPressed = FALSE;
		}
		if ( LeftButton == TRUE)
        {
			if ( Dir < 0 )
            {
				V.YRot = fabs ( Dir ) / 10.0F;
            }
			else 
			{
                V.YRot = -fabs ( Dir ) / 10.0F;
            }
			if ( Mag < 0 )
            {
				V.ZPos -= fabs ( Mag ) / 1.0F;
            }
			else 
			{
                V.ZPos += fabs ( Mag ) / 1.0F;
            }
        }
		if ( MiddleButton == TRUE )
		{
			MOldX = sXPos;
			MOldY = sYPos;
			World->MoveText(MOldX, MOldY,(MOld1X - MOldX) >> 2, (MOld1Y - MOldY) >> 2);
			MOld1X = sXPos;
			MOld1Y = sYPos;
			
		}

        if ( RightButton == TRUE)
        {
			World->SelectText(sXPos, sYPos);
			
		}
        if ( V.XRot != 0 )
		{
			
			M.Rotate ( OldXRot, 0, 0 );
			M.Rotate ( -V.XRot, 0, 0 );
			OldXRot = V.XRot;
		}
       

		// Simulate gravity:
		V.YPos = -100.0F;

		// Perform collision detection:
		World->Collide ( V.XPos, V.YPos, V.ZPos, 100.0F, V.XRot, V.YRot, V.ZRot );

		// Update the world:
		M.Rotate ( -V.XRot, -V.YRot, V.ZRot );
		M.Translate ( -V.XPos, -V.YPos, -V.ZPos );
		
		
  

		V.Clear ();
		

		//
		memset ( VidBuf, BackC, zbufsize );
		// Clear the Z-buffer (if necessary):
		ZTrans += ( 1 << ZSTEP_PREC );
		if ( ( FrameCount % MaxWait ) == 0 )
		{
			ZTrans = 0;
			ClearBuffer ();
		}

		World->Display ( M, VidBuf );

		MyWin.Show ();

		if ( PeekMessage ( &Message, hWnd, 0, 0, PM_NOREMOVE ) == TRUE )
		{
			Running = GetMessage ( &Message, hWnd, 0, 0 );
			TranslateMessage ( &Message );
			DispatchMessage ( &Message );
		}

		++FrameCount;
		
  }

  // Destroy the Z buffer:
  DestZBuffer ();

  // Save the texture data:
  World->WriteText ( "Text.BT" );

  // Deallocate memory for panel object:
  delete World;

  return Message.wParam;
}


  
  
  LRESULT CALLBACK WndProc ( HWND hWnd, unsigned int iMessage,
                          unsigned int wParam, LONG lParam )
  {
	  float XPos, YPos;
	  switch ( iMessage )
	  {
	  case ( WM_COMMAND ):
		  {
			  switch ( LOWORD ( wParam ) )
			  {
			  case ( ID_FILE_EXIT ):
				  {
					  Running = FALSE;
					  break;
				  }
			  }
			  break;
		  }

	  case ( WM_CHAR ):
		  {
			  KeyPressed = TRUE;
			  AktKey = (TCHAR)wParam;
			  break;
		  }

	  case ( WM_LBUTTONUP ):
		  {
			  ReleaseCapture ();
			  LeftButton = FALSE;
			  break;
		  }
		  
		  
		  
	  case ( WM_LBUTTONDOWN ):
		  {
			  SetCapture ( hWnd );
			  LeftButton = TRUE; 
			  Keys = wParam; 
			  Keys;       // key flags                      
			  RightButton = FALSE;
			  MiddleButton = FALSE;
			  XPos = float ( ( short int ) ( LOWORD ( lParam ) ) );
			  YPos = float ( ( short int ) ( HIWORD ( lParam ) ) );
			  Dir  = ( SCREEN_WIDTH / 2 )  - XPos;
			  Mag  = ( SCREEN_HEIGHT / 2 ) - YPos;
			  break;
		  }
	  case ( WM_RBUTTONUP ):
		  {
			  ReleaseCapture ();
			  RightButton = FALSE;
			  break;
		  }
	  case ( WM_MBUTTONUP ):
		  {
			  ReleaseCapture ();
			  MiddleButton = FALSE;
			  break;
		  }
	  case ( WM_RBUTTONDOWN ):
		  {
			  SetCapture ( hWnd );
			  RightButton = TRUE;
			  Keys = wParam; 
			  Keys;
			  LeftButton = FALSE;
			  MiddleButton = FALSE;
			  XPos = float ( ( short int ) ( LOWORD ( lParam ) ) );
			  YPos = float ( ( short int ) ( HIWORD ( lParam ) ) );
			  Dir  = ( SCREEN_WIDTH / 2 )  - XPos;
			  Mag  = ( SCREEN_HEIGHT / 2 ) - YPos;
			  sXPos = LOWORD ( lParam );
			  sYPos = HIWORD ( lParam );
			  break;
		  }
	  case ( WM_MBUTTONDOWN ):
		  {
			  SetCapture ( hWnd );
			  MiddleButton = TRUE;
			  Keys = wParam; 
			  Keys;
			  LeftButton = FALSE;
			  RightButton = FALSE;
			  XPos = float ( ( short int ) ( LOWORD ( lParam ) ) );
			  YPos = float ( ( short int ) ( HIWORD ( lParam ) ) );
			  Dir  = ( SCREEN_WIDTH / 2 )  - XPos;
			  Mag  = ( SCREEN_HEIGHT / 2 ) - YPos;
			  sXPos = LOWORD ( lParam );
			  sYPos = HIWORD ( lParam );
			  break;
		  }
	  case ( WM_MOUSEMOVE ):
		  {
			  if ( MiddleButton == TRUE)
			  {
                  Keys = wParam; 
				  Keys;       // key flags                      
				  sXPos = LOWORD ( lParam );
				  sYPos = HIWORD ( lParam );
				   
              }
			  if ( LeftButton == TRUE)
			  {
                  Keys = wParam; 
				  Keys;       // key flags                      
                  XPos = float ( ( short int ) ( LOWORD ( lParam ) ) );
                  YPos = float ( ( short int ) ( HIWORD ( lParam ) ) );
                  Dir  = ( SCREEN_WIDTH / 2 )  - XPos;
                  Mag  = ( SCREEN_HEIGHT / 2 ) - YPos;
			  }
			  if ( RightButton == TRUE )
			  {
                  Keys = wParam; 
				  Keys;
                  XPos = float ( ( short int ) ( LOWORD ( lParam ) ) );
                  YPos = float ( ( short int ) ( HIWORD ( lParam ) ) );
                  Dir  = ( SCREEN_WIDTH / 2 )  - XPos;
                  Mag  = ( SCREEN_HEIGHT / 2 ) - YPos;
                  break;
			  }
			  break;
		  }
	  case ( WM_DESTROY ):
		  {
			  Running = FALSE;
			  break;
		  }
	  default:
		  return DefWindowProc ( hWnd, iMessage, wParam,
			  lParam );
          }
		  return 0;
   }

