#define STRICT               // Striktere Typprfungen einschalten
#define WIN32_LEAN_AND_MEAN  // Nur wichtige Headerfiles compilieren
#include <windows.h>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <commctrl.h>
#include "KartenGrafik.h"
#include "Karte.h"
#include "Resource.h"
#include "Spielfeld.h"
#include "Zug.h"

CHAR szClassName[] = "Freecell";       // Name der Fensterklasse
CHAR szWndTitle[]  = "Freecell Deluxe"; // Titel des Fensters
CHAR szStatusMessage[128];
HWND hwndStatusbar,hwndToolbar;
HINSTANCE hinst;
HBRUSH hBkBrush;

KartenGrafik KG;
SpielFeld S;
ZugListe ZL,EL;
int StapelNr,StapelPos,Aufgedeckt=FALSE,NeuerLevel;


// Der Levelauswahl-Dialog
BOOL APIENTRY LevelAuswahl(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
    int Nr,bSuccess;

    switch (message)
    {
        case WM_INITDIALOG:
          // Registration-ID-Feld vorbelegen
          NeuerLevel = 0;
          SetDlgItemInt(hDlg,IDC_LEVELNR,S.LevelNr,FALSE);

          return(TRUE);
        case WM_COMMAND:
          // LOWORD added for portability
          if (LOWORD(wParam) == IDOK) 
          { 
            // evtl. gendertes Registration-ID-Feld auslesen
            Nr = GetDlgItemInt(hDlg,IDC_LEVELNR,&bSuccess,FALSE);
            if (bSuccess) NeuerLevel = Nr;
            EndDialog(hDlg,0); 
            return(TRUE); 
          }
          if (LOWORD(wParam) == IDCANCEL) 
          {
            EndDialog(hDlg,0); 
            return(TRUE); 
          }
          break;
    }
    return(FALSE);
}

// Behandelt alle WM_CHAR-Nachrichten
LRESULT HandleCharMsg(HWND hwnd,WPARAM wP,LPARAM lP);
LRESULT HandleCharMsg(HWND hwnd,WPARAM wP,LPARAM lP)
{
  return 0;
}


// Behandelt die Mousemove-Nachrichten
LRESULT HandleMouseMoveMsg(HWND hwnd,WPARAM wP,LPARAM lP);
LRESULT HandleMouseMoveMsg(HWND hwnd,WPARAM wP,LPARAM lP)
{
  int mx=LOWORD(lP),my=HIWORD(lP);
  int x,fs=16,ff=16,tz=16,Gueltig=FALSE;

  if (S.Selektiert)
  {
    if (my > 144) S.SelZiel= (mx-8)/78;
    else
    {
      if ((my >= 25) && (my <= 115))
      {
        if ((mx >= 8) && (mx <= 295)) S.SelZiel = 8+(mx-8)/72;
        if ((mx >= 344) && (mx <= 631)) S.SelZiel = 12+(mx-344)/72;
      }
    }
    
    for (x = 0; x < 8; x++) if (S.Stapel[x].IstLeer()) { fs = x; break; }
    for (x = 8; x < 12; x++) if (S.Stapel[x].IstLeer()) { ff = x; break; }
    if ((S.SelZiel < 12) && S.Stapel[S.SelZiel].IstLeer()) tz = (S.SelZiel < 8) ? fs : ff; 
    else tz = S.SelZiel;
    for (x = 0; x < ZL.ZugAnz; x++)
    {
      if ( (S.SelQuelle == ZL.Liste[x].GetQ())  &&
           (tz == ZL.Liste[x].GetZ())  &&
           (S.Stapel[S.SelQuelle].AktPos-S.SelPos == ZL.Liste[x].GetAnz())) { Gueltig = TRUE; break; }
    }

    if (Gueltig || (S.SelQuelle == S.SelZiel)) SetCursor(LoadCursor(NULL,IDC_ARROW));
    else SetCursor(LoadCursor(NULL,IDC_NO));
  }
  else SetCursor(LoadCursor(NULL,IDC_ARROW));
  return 0;
}

// Behandelt die Paint-Nachrichten
LRESULT HandlePaintMsg(HWND hwnd,WPARAM wP,LPARAM lP);
LRESULT HandlePaintMsg(HWND hwnd,WPARAM wP,LPARAM lP)
{
  PAINTSTRUCT ps;
  HDC hdc;

  hdc=BeginPaint(hwnd,&ps); // Handle eines Device Context holen
  S.Male(hdc,KG);
  S.MaleSelektion(hdc,KG,1);
  EndPaint(hwnd,&ps);           // Ausgabe beenden

  return 0;
}

// Behandelt die LButtonDown-Nachrichten
LRESULT HandleLButtonDownMsg(HWND hwnd,WPARAM wP,LPARAM lP);
LRESULT HandleLButtonDownMsg(HWND hwnd,WPARAM wP,LPARAM lP)
{
  HDC hdc;

  int x,ZwingZug;
  int mx=LOWORD(lP),my=HIWORD(lP);
  Zug Z;

  hdc=GetDC(hwnd);     // Handle eines Device Context holen

  // Zugliste erzeugen und zwingende Zge machen
  do
  { // solange zwingende Zge mglich sind, diese ausfhren
    S.ZugErzeugung(ZL);
    ZL.Sortieren();
    ZwingZug = (ZL.ZugAnz > 0) && (ZL.Liste[0].GetWert() == 1000);
    if (ZwingZug)
    {
      S.MaleZug(hdc,ZL.Liste[0],KG);
      S.MacheZug(ZL.Liste[0]);
      S.SpielListe.Anfuegen(ZL.Liste[0]);
      Sleep(50);
    }
  } while (ZwingZug);

  if (!S.Selektiert)
  { // es ist noch kein Quellstapel ausgewhlt
    if (my > 144)
    {
      S.SelQuelle= (mx-8)/78; S.SelPos = (my-145)/18;
      if (S.SelPos > S.Stapel[S.SelQuelle].AktPos-1) 
        S.SelPos = S.Stapel[S.SelQuelle].AktPos-1;
      if (S.SelPos < S.Stapel[S.SelQuelle].SortPos) 
        S.SelPos = S.Stapel[S.SelQuelle].SortPos;
      if (S.SelPos >= 0)
      {
        S.Selektiert = TRUE;
        S.MaleSelektion(hdc,KG,1);
      }
    }
    else
    {
      if ((mx >= 8) && (mx <= 295) && (my >= 25) && (my <= 115))
      {
        S.SelPos = 0;
        S.SelQuelle= 8+(mx-8)/72;
        if (S.Stapel[S.SelQuelle].AktPos > 0)
        {
          S.Selektiert = TRUE;
          S.MaleSelektion(hdc,KG,1);
          SetCursor(LoadCursor(NULL,IDC_NO));
        }
      }
    }
    S.SelZiel = 16;
  }
  else
  { // es ist bereits ein Quellstapel ausgewhlt
    if (my > 144) S.SelZiel= (mx-8)/78;
    else
    {
      if ((my >= 25) && (my <= 115))
      {
        if ((mx >= 8) && (mx <= 295)) S.SelZiel = 8+(mx-8)/72;
        if ((mx >= 344) && (mx <= 631)) S.SelZiel = 12+(mx-344)/72;
      }
    }
    if (S.SelQuelle == S.SelZiel)
    {
      S.MaleSelektion(hdc,KG,0);
      S.Selektiert = FALSE; 
      S.SelZiel= 16;
      SetCursor(LoadCursor(NULL,IDC_ARROW)); // Default-Cursor setzen
    }
  }

  if (S.Selektiert && (S.SelZiel != 16))
  { // mgliche Zugsequenz, also Zug auf Gltigkeit prfen
    int fs=16,ff=16,tz=16,gueltig=FALSE;
    for (x = 0; x < 8; x++) if (S.Stapel[x].IstLeer()) { fs = x; break; }
    for (x = 8; x < 12; x++) if (S.Stapel[x].IstLeer()) { ff = x; break; }
    if ((S.SelZiel < 12) && S.Stapel[S.SelZiel].IstLeer()) tz = (S.SelZiel < 8) ? fs : ff; 
    else tz = S.SelZiel;
    for (x = 0; x < ZL.ZugAnz; x++)
    {
      if ( (S.SelQuelle == ZL.Liste[x].GetQ())  &&
           (tz == ZL.Liste[x].GetZ())  &&
           (S.Stapel[S.SelQuelle].AktPos-S.SelPos == ZL.Liste[x].GetAnz())) { gueltig = TRUE; break; }
    }

    if (gueltig)
    {
      // Markierung rckgngig machen
      S.MaleSelektion(hdc,KG,0);

      Z.SetQ(S.SelQuelle); Z.SetZ(S.SelZiel); 
      Z.SetAnz(S.Stapel[S.SelQuelle].AktPos-S.SelPos);

      if (Z.GetAnz() == 1)
      {
        S.MaleZug(hdc,Z,KG);
        S.MacheZug(Z);
      }
      else
      {
        S.EinzelZuege(Z,EL);
        for (x = 0; x < EL.ZugAnz; x++)
        {
          S.MaleZug(hdc,EL.Liste[x],KG);
          S.MacheZug(EL.Liste[x]);
          Sleep(50);
        }
      }
      S.SpielListe.Anfuegen(Z);
      S.Selektiert = FALSE; S.SelQuelle = S.SelZiel = 16;
    }
    else MessageBeep(MB_ICONASTERISK);

  }

  ReleaseDC(hwnd,hdc); // Ausgabe beenden
  return 0;
}

// Behandelt die LButtonUp-Nachrichten
LRESULT HandleLButtonUpMsg(HWND hwnd,WPARAM wP,LPARAM lP);
LRESULT HandleLButtonUpMsg(HWND hwnd,WPARAM wP,LPARAM lP)
{
  HDC hdc;
  int ZwingZug,Gewonnen;
  CHAR szText[64];

  hdc = GetDC(hwnd);
  do
  { // solange zwingende Zge mglich sind, diese ausfhren
    S.ZugErzeugung(ZL);
    ZL.Sortieren();
    ZwingZug = (ZL.ZugAnz > 0) && (ZL.Liste[0].GetWert() == 1000);
    if (ZwingZug)
    {
      S.MaleZug(hdc,ZL.Liste[0],KG);
      S.MacheZug(ZL.Liste[0]);
      S.SpielListe.Anfuegen(ZL.Liste[0]);
      Sleep(50);
    }
  } while (ZwingZug);

  if (ZL.ZugAnz == 0)
  { // keine Zuege mehr mglich
    Gewonnen = (S.OrdFeld[0].Wert == Koenig) && (S.OrdFeld[1].Wert == Koenig) &&
               (S.OrdFeld[2].Wert == Koenig) && (S.OrdFeld[3].Wert == Koenig);
    if (Gewonnen) MessageBox(hwnd,"  Congratulations!\nYou solved the level.","End of game",MB_OK);
    else MessageBox(hwnd,"  There are no more moves possible.\nYou lost the game.","End of game",MB_OK);
  }

  sprintf(szText,"%i possible moves",ZL.ZugAnz);
  SendMessage(hwndStatusbar,SB_SETTEXT,3,(LPARAM) (LPSTR) szText);
  if (S.MaxKarten[0])
    sprintf(szText,"%i/%i moveable cards",S.MaxKarten[1],S.MaxKarten[0]);
  else
    sprintf(szText,"%i moveable cards",S.MaxKarten[1]);
  SendMessage(hwndStatusbar,SB_SETTEXT,2,(LPARAM) (LPSTR) szText);
  sprintf(szText,"%i. move",S.SpielListe.ZugAnz);
  SendMessage(hwndStatusbar,SB_SETTEXT,1,(LPARAM) (LPSTR) szText);

  ReleaseDC(hwnd,hdc);
  return 0;
}

// Behandelt die RButtonDown-Nachrichten
LRESULT HandleRButtonDownMsg(HWND hwnd,WPARAM wP,LPARAM lP);
LRESULT HandleRButtonDownMsg(HWND hwnd,WPARAM wP,LPARAM lP)
{
  HDC hdc;
  int mx=LOWORD(lP),my=HIWORD(lP);

  hdc = GetDC(hwnd);
  Aufgedeckt = FALSE;
  if (my > 144) 
  {
    StapelNr = (mx-8)/78;
    StapelPos = (my-145)/18;
    if ((!S.Stapel[StapelNr].IstLeer()) && (StapelPos < S.Stapel[StapelNr].AktPos))
    {
      SetCapture(hwnd);   // Fang die Maus !!!
      Aufgedeckt = TRUE;
      KG.MaleKarte(hdc,S.Stapel[StapelNr].K[StapelPos],StapelNr*78+8,145+StapelPos*18,0,0);
    }
  }
  ReleaseDC(hwnd,hdc);
  return 0;
}

// Behandelt die RButtonUp-Nachrichten
LRESULT HandleRButtonUpMsg(HWND hwnd,WPARAM wP,LPARAM lP);
LRESULT HandleRButtonUpMsg(HWND hwnd,WPARAM wP,LPARAM lP)
{
  HDC hdc;
  int j,k,bs;

  if (Aufgedeckt)
  {
    hdc = GetDC(hwnd);
    k = S.Stapel[StapelNr].AktPos;
    for (j = StapelPos; j < k; j++)
    {
      bs = S.Selektiert && (StapelNr == S.SelQuelle) && (j >= S.SelPos);
      KG.MaleKarte (hdc,S.Stapel[StapelNr].K[j],StapelNr*78+8,145+j*18,j != k-1,bs);
    }
    ReleaseDC(hwnd,hdc);
    ReleaseCapture();    // und lass die Maus wieder frei
  }
  Aufgedeckt = FALSE;
  return 0;
}

// Behandelt die LButtonDblClk-Nachrichten
LRESULT HandleLButtonDblClkMsg(HWND hwnd,WPARAM wP,LPARAM lP);
LRESULT HandleLButtonDblClkMsg(HWND hwnd,WPARAM wP,LPARAM lP)
{
  HDC hdc;
  int mx=LOWORD(lP),my=HIWORD(lP);
  int i,QS,ZS=0;
  Zug Z;

  hdc = GetDC(hwnd);
  if (my > 144) 
  {
    QS = (mx-8)/78;
    if (!S.Stapel[QS].IstLeer()) 
    {
      for (i = 8; i < 12; i++) if (S.Stapel[i].IstLeer()) { ZS = i; break; }
      if (ZS != 0)
      {
        if (S.Selektiert)
        {
          S.MaleSelektion(hdc,KG,0);
          S.Selektiert = FALSE;
        }
        Z.SetQ(QS); Z.SetZ(ZS); Z.SetAnz(1);
        S.MaleZug(hdc,Z,KG);
        S.MacheZug(Z);
        S.SpielListe.Anfuegen(Z);
      }
    }
  }
  ReleaseDC(hwnd,hdc);
  return 0;
}

// Behandelt die RButtonDblClk-Nachrichten
LRESULT HandleRButtonDblClkMsg(HWND hwnd,WPARAM wP,LPARAM lP);
LRESULT HandleRButtonDblClkMsg(HWND hwnd,WPARAM wP,LPARAM lP)
{
  return 0;
}

// Behandelt die Notify-Nachrichten
LRESULT HandleNotifyMsg(HWND hwnd,WPARAM wP,LPARAM lP);
LRESULT HandleNotifyMsg(HWND hwnd,WPARAM wP,LPARAM lP)
{
  switch (((LPNMHDR) lP)->code) 
  { 
    case TTN_NEEDTEXT: 
    { 
      LPTOOLTIPTEXT lpttt; 

      lpttt = (LPTOOLTIPTEXT) lP; 
      lpttt->hinst = hinst; 

      // Specify the resource identifier of the descriptive 
      // text for the given button. 
      switch (lpttt->hdr.idFrom) 
      { 
        case ID_SPIEL_NEU: 
          lpttt->lpszText = MAKEINTRESOURCE(IDS_SPIEL_NEU); 
          break; 
        case ID_SPIEL_NEUSTART: 
          lpttt->lpszText = MAKEINTRESOURCE(IDS_SPIEL_NEUSTART); 
          break; 
        case ID_SPIEL_ZUGRUECK: 
          lpttt->lpszText = MAKEINTRESOURCE(IDS_SPIEL_ZUGRUECK); 
          break; 
        case ID_SPIEL_EXIT: 
          lpttt->lpszText = MAKEINTRESOURCE(IDS_SPIEL_EXIT); 
          break; 
      } 
      break; 
    } 
  }
  return 0;
}
// Behandelt die MenuSelect-Nachrichten
LRESULT HandleMenuSelectMsg(HWND hwnd,WPARAM wP,LPARAM lP);
LRESULT HandleMenuSelectMsg(HWND hwnd,WPARAM wP,LPARAM lP)
{
  char szText[64];
  switch ((UINT) LOWORD(wP))
  {
    case ID_SPIEL_NEU:
      LoadString(hinst,ID_SPIEL_NEU,szText,64); break;
    case ID_SPIEL_NEUSTART:
      LoadString(hinst,ID_SPIEL_NEUSTART,szText,64); break;
    case ID_SPIEL_AUSWAHL:
      LoadString(hinst,ID_SPIEL_AUSWAHL,szText,64); break;
    case ID_SPIEL_ZUGRUECK:
      LoadString(hinst,ID_SPIEL_ZUGRUECK,szText,64);  break;
    case ID_SPIEL_EXIT:
      LoadString(hinst,ID_SPIEL_EXIT,szText,64); break;
    default:
      strcpy(szText,"");
  }
  SendMessage(hwndStatusbar,SB_SETTEXT,0,(LPARAM) (LPSTR) szText);
  return 0;
}

// Der WM_COMMAND-Handler
LRESULT CommandHandler(HWND hwnd,WPARAM wP,LPARAM lP);
LRESULT CommandHandler(HWND hwnd,WPARAM wP,LPARAM lP)
{
  int StartLevel,Zuege;
  CHAR szText[64];
  static int NewMask=0x5A5A5A5A;
  switch (wP)
  {
    case ID_SPIEL_NEU:
      NewMask = NewMask*14215469+1;
      srand(time(NULL)^NewMask);
      StartLevel = ((rand() << 15) + rand()) % 999999 + 1;
      S.Neu(StartLevel);
      sprintf(szText,"Freecell Deluxe - Level %lu",S.LevelNr);
      SetWindowText(hwnd,szText);
      sprintf(szText,"");
      SendMessage(hwndStatusbar,SB_SETTEXT,2,(LPARAM) (LPSTR) szText);
      SendMessage(hwndStatusbar,SB_SETTEXT,3,(LPARAM) (LPSTR) szText);
      InvalidateRect(hwnd,NULL,TRUE);
      PostMessage(NULL,WM_PAINT,0,0);
      return 0;
    case ID_SPIEL_NEUSTART:
      S.Neu(S.LevelNr);
      sprintf(szText,"Freecell Deluxe - Level %lu",S.LevelNr);
      SetWindowText(hwnd,szText);
      sprintf(szText,"");
      SendMessage(hwndStatusbar,SB_SETTEXT,2,(LPARAM) (LPSTR) szText);
      SendMessage(hwndStatusbar,SB_SETTEXT,3,(LPARAM) (LPSTR) szText);
      InvalidateRect(hwnd,NULL,TRUE);
      PostMessage(NULL,WM_PAINT,0,0);
      return 0;
    case ID_SPIEL_AUSWAHL:
      DialogBox(hinst,"IDD_LEVEL",hwnd,(DLGPROC)LevelAuswahl);
      if (NeuerLevel) 
      {
        S.Neu(NeuerLevel);
        sprintf(szText,"Freecell Deluxe - Level %lu",S.LevelNr);
        SetWindowText(hwnd,szText);
        sprintf(szText,"");
        SendMessage(hwndStatusbar,SB_SETTEXT,2,(LPARAM) (LPSTR) szText);
        SendMessage(hwndStatusbar,SB_SETTEXT,3,(LPARAM) (LPSTR) szText);
        InvalidateRect(hwnd,NULL,TRUE);
        PostMessage(NULL,WM_PAINT,0,0);
      }
      return 0;
    case ID_SPIEL_ZUGRUECK:
      Zuege = S.SpielListe.ZugAnz;
      if (Zuege > 0)
      {
        while ((--Zuege >= 0) && (S.SpielListe.Liste[Zuege].GetWert() == 1000))
        {
          S.RueckZug(S.SpielListe.Liste[Zuege]);
          S.SpielListe.ZugAnz--;
        }
        if (Zuege >= 0)
        {
          S.EinzelZuege(S.SpielListe.Liste[Zuege],EL);
          for (int i = EL.ZugAnz-1; i >= 0; i--)
          {
            S.RueckZug(EL.Liste[i]);
          }
          S.SpielListe.ZugAnz--;
        }
        InvalidateRect(hwnd,NULL,TRUE);
        PostMessage(NULL,WM_PAINT,0,0);
      }
      sprintf(szText,"%i. move",S.SpielListe.ZugAnz);
      SendMessage(hwndStatusbar,SB_SETTEXT,1,(LPARAM) (LPSTR) szText);
      return 0;
    case ID_SPIEL_EXIT: 
      DestroyWindow(hwnd);
      return 0;
    case ID_HILFE_INHALT:
      WinHelp(hwnd, "FREEPLAY.HLP", HELP_CONTENTS, 0L); 
      return 0;
    default:
      return 0;
  }
}

// Die (simple) Window-Prozedur
LRESULT CALLBACK SimpleWndProc(HWND hwnd,UINT msg,WPARAM wP,LPARAM lP);
LRESULT CALLBACK SimpleWndProc(HWND hwnd,UINT msg,WPARAM wP,LPARAM lP)
{
  CHAR wtext[64];
  int StartLevel;
  switch (msg) {
  // WM_CREATE erhlt ein Window direkt nach seiner Erzeugung,
  // z.B. um weitere Initialisierungen vorzunehmen.
    case WM_COMMAND:
      return CommandHandler(hwnd,wP,lP);

    case WM_CREATE:
      KG.Init(hwnd);     // Kartengrafik initialisieren
      srand(time(NULL));
      StartLevel = ((rand() << 15) + rand()) % 999999 + 1;
      S.Neu(StartLevel);          // Neues Spiel erzeugen
      sprintf(wtext,"Freecell Deluxe - Level %lu",S.LevelNr);
      SetWindowText(hwnd,wtext);
      S.ZugErzeugung(ZL);
      ZL.Sortieren();
      return 0;          // Alles OK (-1 bedeutet Abbruch der Erzeugung)

    case WM_SIZE:
      SendMessage(hwndToolbar,WM_SIZE,wP,lP);
      SendMessage(hwndStatusbar,WM_SIZE,wP,lP);
      return 0;

    case WM_CHAR:        // Zeichen getippt
      return HandleCharMsg(hwnd,wP,lP);

    case WM_MOUSEMOVE:   // Maus bewegt
      return HandleMouseMoveMsg(hwnd,wP,lP);

    case WM_PAINT:       // Fensterinhalt darstellen
      return HandlePaintMsg(hwnd,wP,lP);

    case WM_LBUTTONDOWN: // linke bzw. ...
      return HandleLButtonDownMsg(hwnd,wP,lP);

    case WM_RBUTTONDOWN: // rechte Maustaste gedrckt
      return HandleRButtonDownMsg(hwnd,wP,lP);

    case WM_LBUTTONUP: // linke bzw. ...
      return HandleLButtonUpMsg(hwnd,wP,lP);

    case WM_RBUTTONUP: // rechte Maustaste losgelassen
      return HandleRButtonUpMsg(hwnd,wP,lP);

    case WM_LBUTTONDBLCLK: // linke bzw. ...
      return HandleLButtonDblClkMsg(hwnd,wP,lP);

    case WM_RBUTTONDBLCLK: // rechte Maustaste doppelgeklickt
      return HandleRButtonDblClkMsg(hwnd,wP,lP);

    case WM_GETMINMAXINFO:
      ((LPMINMAXINFO)lP)->ptMaxSize.x = 
      ((LPMINMAXINFO)lP)->ptMaxTrackSize.x = 640;
      return 0;

    case WM_NOTIFY: // Nachrichten vom Toolbar bzw. Statusbar
      return HandleNotifyMsg(hwnd,wP,lP);

    case WM_MENUSELECT:
      return HandleMenuSelectMsg(hwnd,wP,lP);

    case WM_DESTROY: // Hauptfenster schlieen, zerstrt automatisch das Child-Window.
      PostQuitMessage(0); // WM_QUIT in die Nachrichtenschlange legen
      return 0;

  }
  // Andere Nachrichten landen bei der Standard-Behandlung
  return DefWindowProc(hwnd,msg,wP,lP);
}

INT WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,
  LPSTR lpCmdLine,INT nCmdShow)
{
  WNDCLASS wc;
  HWND hwnd;
  MSG msg;

  // grnen Brush erzeugen
  hBkBrush = CreateSolidBrush(RGB(0,96,0));
  
  // Instance-Handle in globaler Variable sichern
  hinst=hInstance; 

  // WNDCLASS-Struktur fllen
  wc.style=CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS;   
  wc.lpfnWndProc=SimpleWndProc;     
  wc.cbClsExtra=0; wc.cbWndExtra=0; 
  wc.hInstance=hInstance;           
  wc.hIcon=LoadIcon(hInstance,"IDI_WINDOW"); 
  wc.hCursor=NULL;     
  wc.hbrBackground= hBkBrush;       
  wc.lpszMenuName="MAINMENU";       
  wc.lpszClassName=szClassName;     
                                    
  RegisterClass(&wc);               // Klasse bei Windows registrieren

  hwnd=CreateWindow(szClassName, // Fenster der Klasse erzeugen
                    szWndTitle,  // Fenster-Titel (Window-Text)
                    WS_OVERLAPPEDWINDOW|WS_CLIPCHILDREN,
                    200,100,     // x,y-Position auf dem Schirm
                    640,640,     // Breite und Hhe (in Pixel)
                    NULL,        // Parentfenster (keines)
                    NULL,        // Menu-Handle 
                    hInstance,   // Instanz-Handle
                    NULL);       // Zustzliche Daten

  ShowWindow(hwnd,nCmdShow);     // Fenster wird unsichtbar erzeugt,
                                 // daher sichtbar machen
  
  // Statusbar erzeugen und anzeigen
  InitCommonControls();
  hwndStatusbar = CreateStatusWindow(WS_CHILD|WS_VISIBLE,(LPCTSTR) szStatusMessage,hwnd,IDC_STATUS);
  int aWidths[4];
  aWidths[0] = 240; aWidths[1] = 320; aWidths[2] = 480; aWidths[3] = -1;
  WPARAM wParam = (WPARAM) 4; 
  LPARAM lParam = (LPARAM) (LPINT) aWidths;
  SendMessage(hwndStatusbar,SB_SETPARTS,wParam,lParam);

  // Toolbar erzeugen und anzeigen
  TBBUTTON  tbb[7];
  
  tbb[0].iBitmap = 0; 
  tbb[0].idCommand = 0; 
  tbb[0].fsState = TBSTATE_ENABLED; 
  tbb[0].fsStyle = TBSTYLE_SEP; 
  tbb[0].dwData = 0; 
  tbb[0].iString = NULL;
  
  tbb[1].iBitmap = 0; 
  tbb[1].idCommand = ID_SPIEL_EXIT; 
  tbb[1].fsState = TBSTATE_ENABLED; 
  tbb[1].fsStyle = TBSTYLE_BUTTON; 
  tbb[1].dwData = 0; 
  tbb[1].iString = NULL; 

  tbb[2].iBitmap = 0; 
  tbb[2].idCommand = 0; 
  tbb[2].fsState = TBSTATE_ENABLED; 
  tbb[2].fsStyle = TBSTYLE_SEP; 
  tbb[2].dwData = 0; 
  tbb[2].iString = NULL;

  tbb[3].iBitmap = 2; 
  tbb[3].idCommand = ID_SPIEL_NEUSTART; 
  tbb[3].fsState = TBSTATE_ENABLED; 
  tbb[3].fsStyle = TBSTYLE_BUTTON; 
  tbb[3].dwData = 0; 
  tbb[3].iString = NULL; 

  tbb[4].iBitmap = 3; 
  tbb[4].idCommand = ID_SPIEL_ZUGRUECK; 
  tbb[4].fsState = TBSTATE_ENABLED; 
  tbb[4].fsStyle = TBSTYLE_BUTTON; 
  tbb[4].dwData = 0; 
  tbb[4].iString = NULL; 


  tbb[5].iBitmap = 0; 
  tbb[5].idCommand = 0; 
  tbb[5].fsState = TBSTATE_ENABLED; 
  tbb[5].fsStyle = TBSTYLE_SEP; 
  tbb[5].dwData = 0; 
  tbb[5].iString = NULL;

  tbb[6].iBitmap = 1; 
  tbb[6].idCommand = ID_SPIEL_NEU; 
  tbb[6].fsState = TBSTATE_ENABLED; 
  tbb[6].fsStyle = TBSTYLE_BUTTON; 
  tbb[6].dwData = 0; 
  tbb[6].iString = NULL; 

  hwndToolbar = CreateToolbarEx(
    hwnd, 
    WS_CHILD|WS_VISIBLE|TBSTYLE_TOOLTIPS, 
    IDC_TOOLBAR,  
    4,  
    hinst,  
    IDR_TOOLBAR,  
    tbb,  
    7,  
    16,   
    15,   
    16,   
    15,   
    sizeof(TBBUTTON)  
  );

  SetCursor(LoadCursor(NULL,IDC_ARROW)); // Default-Cursor setzen

  while (GetMessage(&msg,NULL,0,0)) {
    TranslateMessage(&msg);
    DispatchMessage(&msg);
  }

  return 0;
}
