#include <stdio.h>
#include <stdlib.h>
#include "Spielfeld.h"

#define yOff 30

SpielFeld::SpielFeld()
{ int ff,fs,i,k,x;
  for (i = 0; i < 12; i++) Stapel[i].StapelNr(i);
  for (i = 0; i < 4; i++) OrdFeld[i].Farbe = (Farben) i;
  for (ff = 0; ff < 5; ff++)
    for (fs = 0; fs < 8; fs++)
    {
      k = 0;
      for (i = 1; i <= fs; i++)
      {
        x = (i-ff-1) >> 1; if (x < 0) x = 0;
        k += (i-x)*(ff+x+1);
      }
      KMax[ff][fs] = k+ff+1;
    }
  Selektiert = FALSE;
}

void SpielFeld::Neu(int Nr)
{
  int temp, i, j, k, Perm[52];
  KartenStapel* AS;

  LevelNr = Nr;
  srand(Nr);
  for (i = 0; i < 12; i++) { Stapel[i].AktPos = 0; Stapel[i].SortPos = -1; }
  for (i = 0; i < 4; i++) 
  {
    OrdFeld[i].Farbe = (Farben) i;
    OrdFeld[i].Wert = Joker;
  }

  for (i = 0; i < 52; i++) Perm [i] = i;
  for (k = 7; k >= 0; k--)
    for (i = 51; i >= 0; i--)
    { // 8 Runden sollten es 'einigermaen zufllig' machen
      j = rand() % (i+1); temp = Perm [i]; Perm[i] = Perm[i-j]; Perm[i-j] = temp;
    }
  for (i = 0; i < 52; i++)
  {
    AS = &Stapel[i&7];
    AS->K[AS->AktPos].Wert = (Werte)((Perm [i] >> 2)+1);
    AS->K[AS->AktPos++].Farbe = (Farben)(Perm[i] & 3);
  }
  for (i = 0; i < 8; i++) Stapel[i].CalcSortPos();
  Selektiert = FALSE;
  SpielListe.Loeschen();
}

int SpielFeld::Laden(char* fn)
{
  FILE* Datei;
  char Name [8], Zeile [32];
  Karte k;
  unsigned int i, j, l;
  for (i = 0; i < 12; i++) { Stapel[i].AktPos = 0; Stapel[i].SortPos = -1; }
  if ((Datei = fopen(fn, "rt")) == NULL)
  {
    fprintf(stderr, "Cannot open %s\n",Name);
    return (1);
  }
  l = 0;
  for (i = 0; i < 7; i++)
  {
    fgets (Zeile,31,Datei);
    for (j = 0; (j < 24) && (l <= 51); j+=3)
    {
      l++;
      if (Zeile [j] <= '9') k.Wert = (Werte) (Zeile [j]-48);
      else
        switch (Zeile [j])
        {
          case 'A' : k.Wert = As; break;
          case 'Z' : k.Wert = Zehn; break;
          case 'B' : k.Wert = Bube; break;
          case 'D' : k.Wert = Dame; break;
          case 'K' : k.Wert = Koenig; break;
        }
      k.Farbe = (Farben) (Zeile[j+1]-48);
      Stapel[j/3].K[Stapel[j/3].AktPos++] = k;
    }
  }
  fclose (Datei);
  for (i = 0; i < 8; i++) Stapel[i].CalcSortPos();
  return (0);
}

void SpielFeld::LoesungLaden(char* fn,ZugListe& ZL)
{
  Zug Z;
  FILE* f;
  int j;
  char Zeile[80];

  f = fopen(fn,"rt");
  while(!feof(f))
  {
    j = 0;
    fgets(Zeile,80,f);
    while (Zeile[j] > 65)
    {
      switch (Zeile[j])
      {
        case 'S' : Z.SetQ(Zeile[j+1]-48); break;
        case 'M' : Z.SetQ(Zeile[j+1]-40); break;
        default  : exit(1);
      }
      switch (Zeile[j+2])
      {
        case 'S' : Z.SetZ(Zeile[j+3]-48); break;
        case 'M' : Z.SetZ(Zeile[j+3]-40); break;
        case 'D' : Z.SetZ(Zeile[j+3]-36); break;
        default  : exit(1);
      }
      Z.SetAnz(1);
      ZL.Anfuegen(Z);
      j += 5;
    }
  }
  fclose(f);
}

void SpielFeld::Speichern(char* fn)
{ int i;
  FILE* f;
  Karte K;
  f = fopen(fn,"wt");
  for (i = 0; i < 52; i++)
  {
    K = Stapel[i & 7].K[i >> 3];
    switch (K.Wert)
    {
      case  1 : fputc('A',f); break;
      case 10 : fputc('Z',f); break;
      case 11 : fputc('B',f); break;
      case 12 : fputc('D',f); break;
      case 13 : fputc('K',f); break;
      default : fputc(K.Wert+48,f); break;
    }
    switch (K.Farbe)
    {
      case Karo  : fputc('0',f); break;
      case Herz  : fputc('1',f); break;
      case Pik   : fputc('2',f); break;
      case Kreuz : fputc('3',f); break;
    }
    if ((i & 7) == 7) fprintf(f,"\n"); else fputc(' ',f);
  }
  fprintf(f,"\n");
  fclose(f);
}

void SpielFeld::Male(HDC hdc,KartenGrafik& Grafik)
{
  unsigned int i,j,k;
  for (i = 0; i < 8; i++)
    if (!Stapel[i].IstLeer())
    {
      k = Stapel[i].AktPos;
      for (j = 0; j < k; j++)
        Grafik.MaleKarte (hdc,Stapel[i].K[j],i*78+8,145+j*18,j != k-1,0);
    }
  for (i = 8; i < 12; i++)
    if (!Stapel[i].IstLeer())
      Grafik.MaleKarte (hdc,Stapel[i].K[0],(i-8)*72+4,yOff,0,0);
    else 
      Grafik.MaleFreifeld(hdc,(i-8)*72+4,yOff);
  for (i = 0; i < 4; i++)
    if (OrdFeld[i].Wert != 0) 
      Grafik.MaleKarte (hdc,OrdFeld[i],344+i*72,yOff,0,0);
    else 
      Grafik.MaleFreifeld(hdc,344+i*72,yOff);
}

void SpielFeld::MaleSelektion(HDC hdc,KartenGrafik& Grafik,int Invers)
{
  int i,j,p;
  if (Selektiert)
  {
    i = SelQuelle;
    if (SelQuelle < 8)
    {
      p = Stapel[SelQuelle].AktPos;
      for (j = SelPos; j < p; j++)
        Grafik.MaleKarte (hdc,Stapel[i].K[j],i*78+8,145+j*18,j != p-1,Invers);
    }
    else
      Grafik.MaleKarte (hdc,Stapel[i].K[0],(i-8)*72+4,yOff,0,Invers);
  }
}

void SpielFeld::MaleZug(HDC hdc,Zug& Z,KartenGrafik& Grafik)
{ 
  int x0,y0,x1,y1,j,k,l;
  HPEN hOldPen;
  HBRUSH hOldBrush;

  k = Stapel[Z.GetQ()].AktPos;
  if (Z.GetQ() > 7)
  {
    x0 = (Z.GetQ()-8)*72+4; y0 = yOff;
    Grafik.MaleFreifeld(hdc,x0,y0);
  }
  else
  {
    x0 = Z.GetQ()*78+8; x1 = x0+72;
    y1 = 224+k*18;
    if (k == Z.GetAnz()) y0 = 145; else y0 = y1-Z.GetAnz()*18-2;
    hOldPen = (HPEN) SelectObject(hdc,GetStockObject(NULL_PEN));
    hOldBrush = (HBRUSH) SelectObject(hdc,hBkBrush);
    Rectangle(hdc,x0,y0,x1,y1);
    SelectObject(hdc,hOldPen); SelectObject(hdc,hOldBrush);
    if (k > Z.GetAnz())
      Grafik.MaleKarte(hdc,Stapel[Z.GetQ()].K[k-Z.GetAnz()-1],x0,y0-95,0,0);
  }
  if (Z.GetZ() > 11)
  {
    x0 = (Z.GetZ()-12)*72+344; y0 = yOff;
    Grafik.MaleKarte(hdc,Stapel[Z.GetQ()].K[k-Z.GetAnz()],x0,y0,0,0);
  }
  else
  {
    if (Z.GetZ() > 7)
    {
      x0 = (Z.GetZ()-8)*72+4; y0 = yOff;
      Grafik.MaleKarte(hdc,Stapel[Z.GetQ()].K[k-Z.GetAnz()],x0,y0,0,0);
    }
    else
    {
      l = Stapel[Z.GetZ()].AktPos;
      x0 = Z.GetZ()*78+8; y0 = 145+l*18;
      for (j = 0; j < Z.GetAnz(); j++)
        Grafik.MaleKarte(hdc,Stapel[Z.GetQ()].K[k-Z.GetAnz()+j],x0,y0+j*18,j != Z.GetAnz()-1,0);
    }
  }
}

void SpielFeld::ZugErzeugung(ZugListe& ZL)
{ int FreiFelder = 0,FreiStapel = 0,FFNr = 16,FSNr = 16,i,j,MaxK,OrdK,mp;
  Zug z;
  Karte k;
  ZL.Loeschen();
  // Anzahl freier Felder und erstes freies Feld bestimmen
  // Zuege von belegten Freifeldern auf Ordnungsfeld in Zugliste eintragen
  j = 1;
  for (i = 8; i < 12 ; i++)
  {
    if (Stapel[i].IstLeer())
    {
      if (j) { FFNr = i; j = 0; }
      FreiFelder++;
    }
    else
    {
      k = Stapel[i].K[0];
      if (OrdFeld[k.Farbe].Wert+1 == k.Wert)
      {
        z.SetQ(i); z.SetZ(12+k.Farbe); z.SetAnz(1); z.SetWert(50);
        if ( (k.Wert-OrdFeld[k.Farbe ^ 1].Wert <= 3) &&
             (k.Wert-OrdFeld[k.Farbe ^ 2].Wert <= 2) &&
             (k.Wert-OrdFeld[k.Farbe ^ 3].Wert <= 2) ) z.SetWert(1000);
        ZL.Anfuegen(z);
      }
    }
  }
  // Anzahl freier Stapel und ersten freien Stapel bestimmen
  // Zuege von belegten Stapeln auf Freifeld in Zugliste eintragen
  j = 1;
  for (i = 0; i < 8 ; i++)
  {
    if  (Stapel[i].IstLeer())
    { // leerer Stapel
      if (j) { FSNr = i; j = 0; }
      FreiStapel++;
    }
    else
    { // nichtleerer Stapel !
      if (FreiFelder > 0)
      { // Zuege auf Freifelder speichern
        z.SetQ(i); z.SetZ(FFNr); z.SetAnz(1); z.SetWert(-Stapel[i].AktPos);
        ZL.Anfuegen(z);
      }
      // Zuege auf Ordnungsfelder speichern
      k = Stapel[i].K[Stapel[i].AktPos-1];
      if (OrdFeld[k.Farbe].Wert+1 == k.Wert)
      {
        z.SetQ(i); z.SetZ(12+k.Farbe); z.SetAnz(1); z.SetWert(50);
        if ( (k.Wert-OrdFeld[k.Farbe ^ 1].Wert <= 3) &&
             (k.Wert-OrdFeld[k.Farbe ^ 2].Wert <= 2) &&
             (k.Wert-OrdFeld[k.Farbe ^ 3].Wert <= 2) ) z.SetWert(1000);
        ZL.Anfuegen(z);
      }
    }
  }
  // Zuege von belegten Stapeln oder belegten Freifeldern auf
  // einen leeren Stapel
  if (FreiStapel > 0)
  {  // wenn ueberhaupt leere Stapel da
    for (i = 8; i < 12; i++)
    { // Zuege von belegten Freifeldern auf leeren Stapel
      if (!Stapel[i].IstLeer())
      {
        z.SetQ(i); z.SetZ(FSNr); z.SetAnz(1); z.SetWert(0);
        ZL.Anfuegen(z);
      }
    }
    // alle Zuege von geordneten Teilstapeln eines belegten Stapels
    // auf leeren Stapel in Zugliste
    MaxK = KMax[FreiFelder][FreiStapel-1];
    for (i = 0; i < 8; i++)
    { // alle nichtleeren Stapel abgrasen
      if (!Stapel[i].IstLeer())
      {
        OrdK = Stapel[i].AktPos-Stapel[i].SortPos;
        if (Stapel[i].SortPos == 0) OrdK--;
        for (j = 1; j <= __min(MaxK,OrdK); j++)
        {
          z.SetQ(i); z.SetZ(FSNr); z.SetAnz(j);z.SetWert(j+j-OrdK);
          ZL.Anfuegen(z);
        }
      }
    }
  }
  // Zuege von belegten Freifeldern auf nichtleere Stapel
  for (i = 8; i < 12; i++)
  {
    if (!Stapel[i].IstLeer())
    {
      for (j = 0; j < 8; j++)
        if (!Stapel[i].IstLeer())
          if (match(Stapel[i].K[0],Stapel[j].K[Stapel[j].AktPos-1]))
          {
            z.SetQ(i); z.SetZ(j); z.SetAnz(1); z.SetWert(25);
            ZL.Anfuegen(z);
          }
    }
  }
  // Zuege von nichtleeren Stapeln auf nichtleere Stapel
  MaxKarten[1] = MaxK = KMax[FreiFelder][FreiStapel];
  for (i = 0; i < 8; i++)
    if (!Stapel[i].IstLeer())
    {
      k = Stapel[i].K[Stapel[i].AktPos-1];
      for (j = 0; j < 8; j++)
        if (!Stapel[j].IstLeer() && (i != j))
        {
          mp = Stapel[j].K[Stapel[j].SortPos].Wert-k.Wert+1;
          OrdK = Stapel[j].AktPos-Stapel[j].SortPos;
          if ((mp >= 0) && (mp < OrdK) && (OrdK-mp <= MaxK))
          {
            if (match(Stapel[j].K[Stapel[j].SortPos+mp],k))
            {
              int n = OrdK-mp;
              z.SetQ(j); z.SetZ(i); z.SetAnz(n);
              z.SetWert(n+abs(Stapel[i].AktPos+n+n-Stapel[j].AktPos));
              ZL.Anfuegen(z);
            }
          }
        }
    }
  if (ZL.ZugAnz)
  {
    MaxKarten[0] = FreiStapel ? KMax[FreiFelder][FreiStapel-1] : 0;
    MaxKarten[1] = KMax[FreiFelder][FreiStapel];
  } 
  else MaxKarten[0] = MaxKarten[1] = 0;
}

void SpielFeld::EinzelZuege(Zug& Z,ZugListe& ZL)
{ 
  int i,j,k=Z.GetAnz(),qs=Z.GetQ(),zs=Z.GetZ(),ff=0,fs=0,sa,se,x,F[12];
  Zug EZ,TZ;

  ZL.Loeschen();
  EZ.SetAnz(1);
  for (i = 8; i < 12; i++) if (Stapel[i].IstLeer()) { F[ff] = i; ff++;}
  for (i = 0; i < 8; i++)
    if (Stapel[i].IstLeer() && (i != zs)) { F[ff+fs] = i; fs++;}
  for ( ;fs > 0;fs--)
  {
    x = (fs-ff-1) >> 1; if (x < 0) x = 0;
    sa = ff+x; se = ff+fs-1;
    for (i = sa; i <= se; i++)
    {
      for (j = 0; j < sa; j++)
      {
        k--; if (k == 0) break;
        EZ.SetQ(qs); EZ.SetZ(F[j]); ZL.Anfuegen(EZ);
      }
      if (k == 0) break;
      k--; if (k == 0) break;
      EZ.SetQ(qs); EZ.SetZ(F[i]); ZL.Anfuegen(EZ);
      for (j = sa-1; j >= 0; j--)
      {
        EZ.SetQ(F[j]); EZ.SetZ(F[i]); ZL.Anfuegen(EZ);
      }
    }
    if (k == 0) break;
    for (i = sa; i < se; i++)
    {
      for (j = 0; j < sa; j++)
      {
        EZ.SetQ(F[i]); EZ.SetZ(F[j]); ZL.Anfuegen(EZ);
      }
      EZ.SetQ(F[i]); EZ.SetZ(F[se]); ZL.Anfuegen(EZ);
      for (j = sa-1; j >= 0; j--)
      {
        EZ.SetQ(F[j]); EZ.SetZ(F[se]); ZL.Anfuegen(EZ);
      }
    }
  }
  if (k != 0)
  {
    for (j = 0; j < ff; j++)
    {
      k--; if (k == 0) break;
      EZ.SetQ(qs); EZ.SetZ(F[j]); ZL.Anfuegen(EZ);
    }
  }
  EZ.SetQ(qs); EZ.SetZ(zs); ZL.Anfuegen(EZ);
  i = ZL.ZugAnz-2;
  while (i >= 0)
  {
    TZ = ZL.Liste[i];
    if (TZ.GetQ() != qs)
    {
      EZ.SetQ(TZ.GetZ()); EZ.SetZ(TZ.GetQ()); ZL.Anfuegen(EZ);
    }
    else
    {
      EZ.SetQ(TZ.GetZ()); EZ.SetZ(zs); ZL.Anfuegen(EZ);
    }
    i--;
  }
}

void SpielFeld::MacheZug(Zug& zz)
{ int q,z,n;
  q = zz.GetQ(); z = zz.GetZ(); n = zz.GetAnz();
  if (z < 12) Stapel[q].Hinlegen(Stapel[z],n);
  else
  {
    OrdFeld[z-12].Wert = (Werte) (((int)OrdFeld[z-12].Wert) + 1);
    Stapel[q].AktPos--;
    if (Stapel[q].AktPos == Stapel[q].SortPos) Stapel[q].CalcSortPos();
  }
}

void SpielFeld::RueckZug(Zug& zz)
{ int q,z,n;
  q = zz.GetQ(); z = zz.GetZ(); n = zz.GetAnz();
  if (z < 12) Stapel[z].Ruecklegen(Stapel[q],n);
  else
  {
    Stapel[q].K[Stapel[q].AktPos++] = OrdFeld[z-12];
    OrdFeld[z-12].Wert = (Werte) (((int)OrdFeld[z-12].Wert) - 1);;
    Stapel[q].CalcSortPos();
  }
}
