#ifndef RTR_RTR_H
#define RTR_RTR_H
/*
Copyright Digital Equipment Corporation 1993, 1996. All rights reserved.

Restricted Rights: Use, duplication, or disclosure by the U.S. Government
is subject to restrictions as set forth in subparagraph (c) (1) (ii) of
DFARS 252.227-7013, or in FAR 52.227-19, or in FAR 52.227-14 Alt. III, as
applicable.

This software is proprietary to and embodies the confidential technology
of Digital Equipment Corporation. Possession, use, or copying of this
software and media is authorized only pursuant to a valid written license
from Digital or an authorized sublicensor.
*/

#ifdef __VMS
#pragma member_alignment save
#if defined( __VAX)
#pragma nomember_alignment
#elif defined( __ALPHA)
#pragma member_alignment
#endif
#endif

/* Global types --------------------------------------------------------------*/
#if defined(MSDOS) && ! defined(_WIN32)
#define	RTRAPI	_far __export __pascal

typedef signed   long	rtr_sgn_32_t;   /* 32-bit signed integer   */
typedef unsigned long	rtr_uns_32_t;	/* 32-bit unsigned integer */
typedef signed int	rtr_sgn_16_t;	/* 16-bit signed integer   */
typedef unsigned int	rtr_uns_16_t;	/* 16-bit unsigned integer */
#else
#define _far
#define	RTRAPI

typedef signed   int	rtr_sgn_32_t;   /* 32-bit signed integer   */
typedef unsigned int	rtr_uns_32_t;	/* 32-bit unsigned integer */
typedef signed short	rtr_sgn_16_t;	/* 16-bit signed integer   */
typedef unsigned short	rtr_uns_16_t;	/* 16-bit unsigned integer */

#endif
typedef signed char	rtr_sgn_8_t;	/* 8-bit signed integer    */
typedef unsigned char 	rtr_uns_8_t;	/* 8-bit unsigned integer  */

typedef enum                            /* Boolean type            */
{
    RTR_FALSE = 0,
    RTR_TRUE
} rtr_bool_t;

/* RTR standard types --------------------------------------------------------*/
typedef rtr_sgn_32_t  rtr_status_t;          /* standard RTR status type      */
typedef rtr_uns_32_t  rtr_flags_t;           /* standard RTR flag type        */
typedef void _far *   rtr_pointer_t;         /* standard RTR pointer type     */
typedef char _far *   rtr_string_t;          /* standard RTR string type      */


/* RTR API types -------------------------------------------------------------*/
typedef rtr_string_t  rtr_access_t;          /* Access name type              */
typedef rtr_string_t  rtr_chanam_t;          /* Channel name type             */
typedef rtr_uns_32_t  rtr_channel_t;         /* Channel type                  */
typedef rtr_uns_8_t   rtr_evtnum_t;          /* Event number type             */
typedef rtr_string_t  rtr_facnam_t;          /* Facility name type            */
typedef rtr_string_t  rtr_infoclass_t;       /* Request/Set info class type   */
typedef rtr_string_t  rtr_itemcode_t;        /* Item code type (selector)     */
typedef rtr_uns_32_t  rtr_keylen_t;          /* Key length type               */
typedef rtr_pointer_t rtr_msgbuf_t;          /* Message buffer type           */
typedef rtr_string_t  rtr_msgfmt_t;          /* Message format type           */
typedef rtr_uns_32_t  rtr_msglen_t;          /* Message buffer length type    */
typedef rtr_uns_32_t  rtr_numseg_t;          /* Number of segments type       */
typedef rtr_string_t  rtr_rcpnam_t;          /* Recipients name type          */
typedef rtr_string_t  rtr_rcpspc_t;          /* Recipients spec type          */
typedef rtr_uns_32_t  rtr_reason_t;          /* Reason for rejection type     */
typedef rtr_string_t  rtr_selval_t;          /* Selector value type           */
typedef rtr_string_t  rtr_setval_t;          /* Set value type                */
typedef rtr_uns_32_t  rtr_timout_t;          /* Time out type                 */
typedef rtr_pointer_t rtr_usrhdl_t;          /* User handle type              */


/* RTR API flags types -------------------------------------------------------*/
typedef rtr_flags_t rtr_acc_flag_t;          /* Flags for rtr_accept_tx       */
typedef rtr_flags_t rtr_bro_flag_t;          /* Flags for rtr_broadcast_event */
typedef rtr_flags_t rtr_clo_flag_t;          /* Flags for rtr_close_channel   */
typedef rtr_flags_t rtr_ope_flag_t;          /* Flags for rtr_open_channel()  */
typedef rtr_flags_t rtr_rcv_flag_t;          /* Flags for rtr_receive_message */
typedef rtr_flags_t rtr_rej_flag_t;          /* Flags for rtr_reject_tx       */
typedef rtr_flags_t rtr_rep_flag_t;          /* Flags for rtr_reply_to_client */
typedef rtr_flags_t rtr_req_flag_t;          /* Flags for rtr_request_info    */
typedef rtr_flags_t rtr_sen_flag_t;          /* Flags for rtr_send_to_server  */
typedef rtr_flags_t rtr_set_flag_t;          /* Flags for rtr_set_info        */
typedef rtr_flags_t rtr_sta_flag_t;          /* Flags for rtr_start_tx        */
typedef rtr_flags_t rtr_tid_flag_t;          /* Flags for rtr_get_tid         */

/*-------------------------------------------------------- RTR key definition */

typedef enum                                 /* RTR Key Segment Type Type     */
{
    rtr_keyseg_signed,
    rtr_keyseg_unsigned,
    rtr_keyseg_string
} rtr_keyseg_type_t;

typedef struct                               /* RTR Key Segment Type          */
{
    rtr_keyseg_type_t ks_type;               /* data type of key segment      */
    rtr_keylen_t      ks_length;             /* key segment length (bytes)    */
    rtr_keylen_t      ks_offset;             /* key segment offset (bytes)    */
    rtr_pointer_t     ks_lo_bound;           /* ptr to key segment low bound  */
    rtr_pointer_t     ks_hi_bound;           /* ptr to key segment high bound */
} rtr_keyseg_t;

#define RTR_TIDSIZ_UNS_32 7
typedef struct                               /* RTR transaction id            */
{                           		     /* Unique number assigned by RTR */
    rtr_uns_32_t tid32[RTR_TIDSIZ_UNS_32];   /* to each transaction           */
} rtr_tid_t;

/*
rtr_status_data_t defines the type of the message buffer (*pmsg) returned by
rtr_receive_message when:
	 msgsb.msgtype == rtr_mt_opened,
	 msgsb.msgtype == rtr_mt_closed,
	 msgsb.msgtype == rtr_mt_accepted,
or	 msgsb.msgtype == rtr_mt_rejected
*/
typedef struct
{
    rtr_status_t    status;
    rtr_reason_t    reason;
} rtr_status_data_t;


/*--------------------------------------------------------- RTR message types */
/*
rtr_msg_type_t defines the message types that can be returned (in
pmsgsb->msgtype) by a call to rtr_receive_message().
*/
typedef enum				     /* RTR message type type         */
{
    rtr_mt_msg1,		/* first message of a transaction             */
    rtr_mt_msgn,		/* nth message (i.e. not the first) of a tx   */
    rtr_mt_msg1_uncertain,	/* first message - might have been received   */
    rtr_mt_reply,		/* message sent by a server to a client       */
    rtr_mt_prepare,		/* expects server to accept or reject         */
    rtr_mt_rtr_event,		/* received message is an RTR event           */
    rtr_mt_user_event,		/* received message is a user event           */
    rtr_mt_accepted,		/* tx has been accepted by all participants   */
    rtr_mt_rejected,		/* specified tx was rejected by a participant */
    rtr_mt_opened,		/* channel opened                             */
    rtr_mt_closed,		/* channel closed by RTR                      */
    rtr_mt_request_info,	/* message from rtr_request_info              */
    rtr_mt_set_info,		/* message from rtr_set_info                  */
    rtr_mt_rettosend,		/* message has been returned to sender        */
    rtr_mt_tid,			/* reserved to Digital			      */
    rtr_mt_credit,		/* reserved to Digital			      */
    rtr_mt_dtx_completed	/* reserved to Digital			      */
} rtr_msg_type_t ;


/*
rtr_msgsb_t defines the type of the message status block (*pmsgsb) associated
with each message returned returned by rtr_receive_message().
*/
typedef struct                               /* RTR message status block      */
{
#if defined(MSDOS) && ! defined(_WIN32)
    rtr_sgn_32_t	msgtype;
#else
    rtr_msg_type_t	msgtype;
#endif
    rtr_usrhdl_t	usrhdl;
    rtr_msglen_t	msglen;
    rtr_tid_t		tid;
    rtr_evtnum_t	evtnum;
#if defined(MSDOS) && ! defined(_WIN32)
    char pad[3];		/* for alignment */
#endif
} rtr_msgsb_t;

/* RTR Limits ----------------------------------------------------------------*/

#define RTR_MAX_ACCESS_LEN   31         /* maximum length for access string   */
#define RTR_MAX_FACNAM_LEN   31         /* maximum length for facility name   */
#define RTR_MAX_MSGLEN       64000      /* maximum size of an RTR message     */
#define RTR_MAX_NUMSEG       20         /* maximum number of segments in key  */
#define RTR_MAX_RCPNAM_LEN   31         /* maximum name for bx recipient name */
#define RTR_MAX_RCPSPC_LEN   31         /* maximum name for bx recipient spec */
#define RTR_MAX_MSGFMT_LEN   8192	/* maximum name for msgfmt            */
#define RTR_MAX_SELVAL_LEN   8192       /* maximum length for selector value  */


/* RTR parameter disabler defines --------------------------------------------*/

#define RTR_NO_FLAGS                          0
#define RTR_NO_WAKEUP           (void _far *)(0)
#define RTR_NO_PEVTNUM  (rtr_evtnum_t _far *)(0)
#define RTR_NO_ACCESS         (rtr_access_t )(0)
#define RTR_NO_NUMSEG         (rtr_uns_32_t )(0)
#define RTR_NO_PKEYSEG  (rtr_keyseg_t _far *)(0)
#define RTR_NO_RCPNAM         (rtr_rcpnam_t )(0)
#define RTR_NO_RCPSPC         (rtr_rcpspc_t )(0)
#define RTR_NO_PTID        (rtr_tid_t _far *)(0)
#define RTR_NO_USRHDL         (rtr_usrhdl_t )(0)
#define RTR_NO_PMSG          (rtr_pointer_t )(0)
#define RTR_NO_MSGFMT         (rtr_msgfmt_t )(0)
#define RTR_NO_REASON         (rtr_reason_t )(0)
#define RTR_NO_TIMOUTMS    (rtr_uns_32_t )(0xFFFFFFFF)
#define RTR_NO_JOINCHAN   (rtr_channel_t )(0xFFFFFFFF)
#define RTR_NO_SELITM	   ""
#define RTR_NO_SELVAL	   ""


/* superseded, but retained for compatibility ------------------------------- */
#define RTR_MAX_CHANAM_LEN   RTR_MAX_RCPNAM_LEN  /* superseded                */
#define RTR_NO_CHANAM        RTR_NO_RCPNAM

/* ------------ use this instead of your own ones ... ----------------------- */
#define RTR_MIN(a,b)    (((a) < (b)) ? (a) : (b))
#define RTR_MAX(a,b)    (((a) > (b)) ? (a) : (b))

/* ------------------------------------------------ Defines for rtr_accept_tx */
/* rtr_accept_tx flags */
#define RTR_F_ACC_FORGET       (1<<0)  /* Don't get more msgs for this tx     */


/* ------------------------------------------ Defines for rtr_broadcast_event */
/* NO rtr_broadcast_event flags */


/* -------------------------------------------- Defines for rtr_close_channel */
/* NO rtr_close_channel flags */


/* -------------------------------------------------- Defines for rtr_get_tid */
/* NO rtr_get_tid flags */


/* --------------------------------------------- Defines for rtr_open_channel */
/* rtr_open_channel flags */
#define RTR_F_OPE_CLIENT           (1<<0) /* channel to be used as a CLIENT.  */
#define RTR_F_OPE_SERVER           (1<<1) /* channel to be used as a SERVER.  */
#define RTR_F_OPE_EXPLICIT_ACCEPT  (1<<2) /* "receive" does not imply ACCEPT  */
#define RTR_F_OPE_FE_CALL_OUT      (1<<3) /* Server Flag: Frontend call-out   */
#define RTR_F_OPE_TR_CALL_OUT      (1<<4) /* Server Flag: Router call-out     */
#define RTR_F_OPE_BE_CALL_OUT      (1<<5) /* Server Flag: Backend call-out    */
#define RTR_F_OPE_SHADOW           (1<<6) /* Server Flag: shadow server       */
#define RTR_F_OPE_NOSTANDBY        (1<<7) /* Server Flag: disallow standby    */
#define RTR_F_OPE_NOCONCURRENT     (1<<8) /* Server Flag: disallow concurrent */
#define RTR_F_OPE_EXPLICIT_PREPARE (1<<9) /* Server Flag: explicit prepares   */

#define RTR_F_OPE_DECDTM_MANAGED   (1<<10) /* Server Flag: use DECdtm txn mgmt*/
#define RTR_F_OPE_XA_MANAGED       (1<<11) /* Server Flag: use XA txn mgmt    */

/* ------------------------------------------ Defines for rtr_receive_message */
/* NO rtr_receive_message flags */
#define RTR_ANYCHAN (rtr_channel_t _far *)(-1L)
#define RTR_CHAN_ENDLIST (rtr_channel_t)(0)

/* ------------------------------------------------ Defines for rtr_reject_tx */
/* rtr_reject_tx flags */
#define RTR_F_REJ_RETRY        (1<<0)  /* Server cannot do now, maybe later   */


/* ------------------------------------------ Defines for rtr_reply_to_client */
/* rtr_reply_to_client flags */
#define RTR_F_REP_ACCEPT           (1<<0) /* Tx is accepted by this server.   */
#define RTR_F_REP_FORGET           (1<<1) /* Don't get more msgs for this tx  */


/* --------------------------------------------- Defines for rtr_request_info */
/* NO rtr_request_info flags */


/* ------------------------------------------- Defines for rtr_send_to_server */
/* rtr_send_to_server flags */
#define RTR_F_SEN_ACCEPT       (1<<0)  /* conversation complete, accepted     */
#define RTR_F_SEN_EXPENDABLE   (1<<1)  /* no problem if this send fails       */
#define RTR_F_SEN_READONLY     (1<<2)  /* send will not cause any RM update   */
#define RTR_F_SEN_RETURN_TO_SENDER (1<<3) /* return msg to sender if rejected */
#define RTR_F_SEN_FORGET       (1<<4)  /* don't get more msgs for this tx     */


/* ------------------------------------------------- Defines for rtr_set_info */
/* NO rtr_set_info flags */


/* --------------------------------------------------Defines for rtr_start_tx */
/* NO rtr_start_tx flags */


/* ------------------------------------------------- Defines for Event Number */
#define RTR_EVTNUM_ENDLIST	255 /* indicates end of list */
#define RTR_EVTNUM_UP_TO	254 /* indicates range of event numbers */
#define RTR_EVTNUM_RTRDEF	253 /* indicates defining RTR event numbers */
#define RTR_EVTNUM_USERDEF	252 /* indicates defining user event numbers */

/* User events -------------------------------------------------------------- */
#define RTR_EVTNUM_USERBASE	  0 /* lowest user event #        */
#define RTR_EVTNUM_USERMAX	250 /* highest user event #       */

/* RTR events --------------------------------------------------------------- */

#define RTR_EVTNUM_FACREADY      96    /* facility ready                      */
#define RTR_EVTNUM_FACDEAD       97    /* facility not ready                  */
#define RTR_EVTNUM_FERTRGAIN     98    /* frontend gained link to router      */
#define RTR_EVTNUM_FERTRLOSS     99    /* frontend lost link to router        */
#define RTR_EVTNUM_RTRBEGAIN     100   /* router gained link to backend       */
#define RTR_EVTNUM_RTRBELOSS     101   /* router lost link to backend         */
#define RTR_EVTNUM_KEYRANGEGAIN  102   /* new key range available             */
#define RTR_EVTNUM_KEYRANGELOSS  103   /* a key range not available           */
#define RTR_EVTNUM_BERTRGAIN     104   /* backend gained link to router       */
#define RTR_EVTNUM_BERTRLOSS     105   /* backend lost link to router         */
#define RTR_EVTNUM_RTRFEGAIN     106   /* router gained link to frontend      */
#define RTR_EVTNUM_RTRFELOSS     107   /* router lost link to frontend        */
#define RTR_EVTNUM_SRPRIMARY     108   /* server is in primary mode           */
#define RTR_EVTNUM_SRSTANDBY     109   /* server is in standby mode           */
#define RTR_EVTNUM_SRSECONDARY   110   /* server is in secondary mode         */
#define RTR_EVTNUM_SRSHADOWLOST  111   /* server lost shadow                  */
#define RTR_EVTNUM_SRSHADOWGAIN  112   /* server gained shadow                */
#define RTR_EVTNUM_SRRECOVERCMPL 113   /* server recovered                    */

#define RTR_EVTNUM_RTRBASE        96	/* base RTR event #		*/
#define RTR_EVTNUM_RTRMAX	 113	/* highest rtr event #		*/

/* ----------------------------------------------------------- RTR item codes */
#define RTR_ITEMCODE_END              (0) /* Item code list terminator.       */


/* -------------------------------------------------- RTR function prototypes */

#if defined(__cplusplus)
extern "C" {
#endif

/* Accept the transaction currently active on a channel ----------------------*/
extern rtr_status_t RTRAPI rtr_accept_tx (
    rtr_channel_t	channel,
    rtr_acc_flag_t	flags,
    rtr_reason_t	reason
    ) ;


/* Broadcast a user event ----------------------------------------------------*/
extern rtr_status_t RTRAPI rtr_broadcast_event (
    rtr_channel_t	channel,
    rtr_bro_flag_t	flags,
    const void *	pmsg,		     /* rtr_msgbuf_t */
    rtr_msglen_t	msglen,
    rtr_evtnum_t	evtnum,
    const char *	rcpspc,		     /* rtr_rcpspc_t */
    const char *	msgfmt		     /* rtr_msgfmt_t */
    ) ;


/* Close a previously opened channel -----------------------------------------*/
extern rtr_status_t RTRAPI rtr_close_channel (
    rtr_channel_t	channel,
    rtr_clo_flag_t	flags
    ) ;


/* Return the unique transaction for the current transaction -----------------*/
extern rtr_status_t RTRAPI rtr_get_tid (
    rtr_channel_t	channel,
    rtr_tid_flag_t	flags,
    rtr_tid_t	_far	*ptid		     /* write */
    ) ;


/* Open a channel to allow for communication with other applications ---------*/

extern rtr_status_t RTRAPI rtr_open_channel (
    rtr_channel_t _far	*pchannel,	     /* write */
    rtr_ope_flag_t	flags,		
    const char *	facnam,		     /* rtr_facnam_t */
    const char *	rcpnam,		     /* rtr_rcpnam_t */
    const rtr_evtnum_t  _far *pevtnum,
    const char *	access,		     /* rtr_access_t */
    rtr_numseg_t	numseg,
    const rtr_keyseg_t  _far *pkeyseg
    ) ;


/* Receive a message from RTR or the application -----------------------------*/
extern rtr_status_t RTRAPI rtr_receive_message (
    rtr_channel_t  _far	*pchannel,	     /* write */
    rtr_rcv_flag_t	flags,
    const rtr_channel_t  _far *prcvchan,
    rtr_msgbuf_t	pmsg,		     /* write */
    rtr_msglen_t	maxlen,
    rtr_timout_t	timoutms,
    rtr_msgsb_t	   _far	*pmsgsb		     /* write */
    ) ;

/* Reject the transaction currently active on a channel ----------------------*/
extern rtr_status_t RTRAPI rtr_reject_tx (
    rtr_channel_t	channel,
    rtr_rej_flag_t	flags,
    rtr_reason_t	reason
    ) ;

/* Send a (server's) reply to a client's transactional message ---------------*/
extern rtr_status_t RTRAPI rtr_reply_to_client (
    rtr_channel_t	channel,
    rtr_rep_flag_t	flags,
    const void *	pmsg,		     /* rtr_msgbuf_t */
    rtr_msglen_t	msglen,
    const char *	msgfmt		     /* rtr_msgfmt_t */
    );

/* Request information about the RTR environment -----------------------------*/
extern rtr_status_t RTRAPI rtr_request_info (
    rtr_channel_t  _far	*pchannel,	     /* write */
    rtr_req_flag_t	flags,
    const char *	infcla,		     /* rtr_infoclass_t */
    const char *	selitm,		     /* rtr_itemcode_t  */
    const char *	selval,		     /* rtr_selval_t    */
    const char *	getitms		     /* rtr_itemcode_t */
    ) ;


/* Send a transactional message to a server ----------------------------------*/
extern rtr_status_t RTRAPI rtr_send_to_server (
    rtr_channel_t	channel,
    rtr_sen_flag_t	flags,
    const void *	pmsg,		     /* rtr_msgbuf_t */
    rtr_msglen_t	msglen,
    const char *	msgfmt		     /* rtr_msgfmt_t */
    ) ;

/* Set information in the RTR environment ------------------------------------*/
extern rtr_status_t RTRAPI rtr_set_info (
    const rtr_channel_t _far *pchannel,
    rtr_set_flag_t	flags,
    const char *	infcla,		     /*  rtr_infoclass_t */
    const char *	selitm,		     /*  rtr_itemcode_t  */
    const char *	selval,		     /*  rtr_selval_t    */
    const char *	setitm,		     /*  rtr_itemcode_t  */
    const char *	setval		     /*  rtr_setval_t    */
    ) ;

/* Associate a user defined value (handle) with a transaction ----------------*/
extern rtr_status_t RTRAPI rtr_set_user_handle (
    rtr_channel_t	channel,
    rtr_usrhdl_t	usrhdl
    ) ;


/* Set a routine as the RTR wakeup routine -----------------------------------*/
extern rtr_status_t RTRAPI rtr_set_wakeup (
    void		(_far *wu_rou)(void)
    ) ;

#define RTR_XIDSIZ_UNS_32 4
typedef struct                               /* RTR distributed transaction id*/
{                           		     /* Unique number used by distr.  */
    rtr_uns_32_t xid32[RTR_XIDSIZ_UNS_32];   /* transaction managers to       */
} rtr_xid_t;				     /* identify each transaction     */

/* Get the extended TID for the transaction currently active on a channel ----*/
extern rtr_status_t RTRAPI rtr_get_xid (
    rtr_channel_t	channel,
    rtr_xid_t		*xid
    ) ;

/* Explicitly start a transaction on the specified channel -------------------*/
#if !defined( MSDOS) || defined( RTR_STRICT_V3API)
extern rtr_status_t RTRAPI rtr_start_tx (
    rtr_channel_t	channel,
    rtr_sta_flag_t	flags,
    rtr_timout_t	timoutms,
    rtr_channel_t	joinchan
    );
#else	/* #ifndef	MSDOS						    */
#if defined( RTR_STRICT_V2API)
typedef struct RTR__TXSB RTR__TXSB;
extern rtr_uns_32_t RTRAPI rtr_start_tx(
    rtr_uns_16_t	ch,
    rtr_uns_32_t	flags,
    RTR__TXSB _far     *txsb,
    rtr_sgn_8_t _far   *ptimeout
    );
#else
extern rtr_status_t RTRAPI rtr_start_tx ();
#endif
#endif

#if !defined( MSDOS) || defined( RTR_STRICT_V3API)
extern char _far * RTRAPI rtr_error_text(
    rtr_status_t	status
    );
#else	/* #ifndef	MSDOS						    */
#if defined( RTR_STRICT_V2API)
extern rtr_uns_32_t RTRAPI rtr_error_text(
    rtr_uns_32_t	status,
    rtr_uns_8_t _far   *buffer,
    rtr_uns_16_t _far  *buflen
    );
#else
extern char _far * RTRAPI rtr_error_text();
#endif
#endif

#if defined(__cplusplus)
}
#endif
/*
Define symbols for RTR subsystem messages created by the
MSG_UTIL program on Tue Dec 16 19:09:04 1997
 */
#define RTR_STS_VERMISMAT -65382
#define RTR_STS_ACPNOTVIA -130918
#define RTR_STS_BRODISCAC -196454
#define RTR_STS_BRODISBLO -261990
#define RTR_STS_BRODISLIN -327526
#define RTR_STS_ERROPEFIL -393062
#define RTR_STS_ERRACCFIL -458598
#define RTR_STS_COMNOTFOU -524134
#define RTR_STS_COMNUMMUS -589670
#define RTR_STS_DUPNODNAM -655206
#define RTR_STS_FACNAMBLA -720742
#define RTR_STS_FACNAMLON -786278
#define RTR_STS_FACNAMSTA -851814
#define RTR_STS_FACNAMILL -917350
#define RTR_STS_WILNOTALL -982886
#define RTR_STS_NOROUTERS -1048422
#define RTR_STS_NOBACKEND -1113958
#define RTR_STS_NOFRONTEN -1179494
#define RTR_STS_OWNNODMIS -1245030
#define RTR_STS_FACALREXI -1310566
#define RTR_STS_ERRACCTAB -1376102
#define RTR_STS_ERRINIACS -1441638
#define RTR_STS_RTRNOTSTA -1507174
#define RTR_STS_RTRALRSTA -1572710
#define RTR_STS_RTRWASSTO -1638246
#define RTR_STS_NOSUCHFAC -1703782
#define RTR_STS_NOFACILIT -1769318
#define RTR_STS_ERRCREMBX -1834854
#define RTR_STS_ERRACCMBX -1900390
#define RTR_STS_ERRDELMBX -1965926
#define RTR_STS_INVFILNAM -2031462
#define RTR_STS_SUBTOOLON -2096998
#define RTR_STS_TOOMANSUB -2162534
#define RTR_STS_TRANOTACT -2228070
#define RTR_STS_TRAALRSUS -2293606
#define RTR_STS_TRANOTSUS -2359142
#define RTR_STS_TOOMANLOG -2424678
#define RTR_STS_LOGNOTACT -2490214
#define RTR_STS_NOSUCHPRC -2555750
#define RTR_STS_NORTRPROC -2621286
#define RTR_STS_PROCIDILL -2686822
#define RTR_STS_ERRSTAACP -2752358
#define RTR_STS_NOSUCHCOU -2817894
#define RTR_STS_NOSUCHITM -2883430
#define RTR_STS_ITMALREXI -2948966
#define RTR_STS_NOTHTODIS -3014502
#define RTR_STS_ERRACCNOD -3080038
#define RTR_STS_TOOMUCDAT -3145574
#define RTR_STS_MONNOTACT -3211110
#define RTR_STS_TOOSMALL -3276646
#define RTR_STS_TOOBIG -3342182
#define RTR_STS_ONLYDISP -3407718
#define RTR_STS_AMBIGDISP -3473254
#define RTR_STS_NOSUCHDIS -3538790
#define RTR_STS_NOSUCHNOD -3604326
#define RTR_STS_ONLONENOD -3669862
#define RTR_STS_ACCTOOBIG -3735398
#define RTR_STS_MSGDATILL -3800934
#define RTR_STS_EVTNAMILL -3866470
#define RTR_STS_CHCQUOEXD -3932006
#define RTR_STS_NOSUCHCHN -3997542
#define RTR_STS_CHNALRDEC -4063078
#define RTR_STS_EXPTOOCOM -4128614
#define RTR_STS_NUMCONILL -4194150
#define RTR_STS_NOTSAMTYP -4259686
#define RTR_STS_UNEXPEND -4325222
#define RTR_STS_EXPSYNILL -4390758
#define RTR_STS_SUPCHAEND -4456294
#define RTR_STS_NODECNET -4521830
#define RTR_STS_NODNOTKNO -4587366
#define RTR_STS_ERRGETNOD -4652902
#define RTR_STS_NDBTABFUL -4718438
#define RTR_STS_FDBTABFUL -4783974
#define RTR_STS_FACTABFUL -4849510
#define RTR_STS_CMDRESDEV -4915046
#define RTR_STS_UICNOTGRP -4980582
#define RTR_STS_BADRTRINS -5046118
#define RTR_STS_INSUFPRIV -5111654
#define RTR_STS_NFW -5177190
#define RTR_STS_ILLREMDEV -5242726
#define RTR_STS_ILLDEVTYP -5308262
#define RTR_STS_INATIMOUT -5373798
#define RTR_STS_CONTIMOUT -5439334
#define RTR_STS_MODECHANGE -5504870
#define RTR_STS_CMDTOOLON -5570406
#define RTR_STS_CANTSTOP -5635942
#define RTR_STS_BADNVRMT -5701478
#define RTR_STS_RCHNOTSTA -5767014
#define RTR_STS_RCHALRSTA -5832550
#define RTR_STS_RCHWASSTO -5898086
#define RTR_STS_ERRSTARCH -5963622
#define RTR_STS_DSKNOTSET -6029158
#define RTR_STS_MAXTOOSMA -6094694
#define RTR_STS_NOSUCHPRT -6160230
#define RTR_STS_TOOMANYOBJ -6225766
#define RTR_STS_NOLICENSE -6291302
#define RTR_STS_BUGCHECK -6356838
#define RTR_STS_MESFLOCON -6422374
#define RTR_STS_JOUFILMIS -6487910
#define RTR_STS_DUPJOUFIL -6553446
#define RTR_STS_SPUJOUFIL -6618982
#define RTR_STS_ERRJOUNAM -6684518
#define RTR_STS_JOUNOTINI -6750054
#define RTR_STS_JOUFORCHA -6815590
#define RTR_STS_JOUHDRERR -6881126
#define RTR_STS_JOUSEQERR -6946662
#define RTR_STS_JOUOVERFL -7012198
#define RTR_STS_JOUFILFUL -7077734
#define RTR_STS_JOUNOTFOU -7143270
#define RTR_STS_JOUALREXI -7208806
#define RTR_STS_JOUINUSE -7274342
#define RTR_STS_INVJOUCHN -7339878
#define RTR_STS_CHNNOTOPE -7405414
#define RTR_STS_NOFLUSH -7470950
#define RTR_STS_ERROPEJOU -7536486
#define RTR_STS_TOOMANREC -7602022
#define RTR_STS_DFSDISK -7667558
#define RTR_STS_INVACCESS -7733094
#define RTR_STS_INVFACNAM -7798630
#define RTR_STS_INVBUFLEN -7864166
#define RTR_STS_CACHEXHAU -7929702
#define RTR_STS_NOACP -7995238
#define RTR_STS_ABORT -8060774
#define RTR_STS_SYNCHCOMM -8126310
#define RTR_STS_NETSHUT -8191846
#define RTR_STS_INTERFERENCE -8257382
#define RTR_STS_INCOMPAT -8322918
#define RTR_STS_OBJUNKNOWN -8388454
#define RTR_STS_NOTRECOGNISED -8453990
#define RTR_STS_NOTCONFIGURED -8519526
#define RTR_STS_ALRDCNCTD -8585062
#define RTR_STS_ALRINPRGS -8650598
#define RTR_STS_PROTOCOL -8716134
#define RTR_STS_NOCURRTR -8781670
#define RTR_STS_CURRTRLOSS -8847206
#define RTR_STS_FACNOTDEC -8912742
#define RTR_STS_RSPFAC -8978278
#define RTR_STS_RSPNODE -9043814
#define RTR_STS_CNCTREJFR -9109350
#define RTR_STS_CNCTREJBY -9174886
#define RTR_STS_NODENOTCNFG -9240422
#define RTR_STS_ROLESMISMATCH -9305958
#define RTR_STS_TRNOQUO -9371494
#define RTR_STS_BENOQUO -9437030
#define RTR_STS_NOFECREDIT -9502566
#define RTR_STS_NODISOLAT -9568102
#define RTR_STS_LINKSHUT -9633638
#define RTR_STS_LNQOVERFLOW -9699174
#define RTR_STS_QCROVERFLOW -9764710
#define RTR_STS_QIROVERFLOW -9830246
#define RTR_STS_RAEOVERFLOW -9895782
#define RTR_STS_RDEOVERFLOW -9961318
#define RTR_STS_QAROVERFLOW -10026854
#define RTR_STS_UNKNOFAC -10092390
#define RTR_STS_NODSTFND -10157926
#define RTR_STS_NOACCESS -10223462
#define RTR_STS_NRSEGSDIF -10288998
#define RTR_STS_DATTYPDIF -10354534
#define RTR_STS_KEYOFFDIF -10420070
#define RTR_STS_KEYLENDIF -10485606
#define RTR_STS_KEYRANOVE -10551142
#define RTR_STS_UPPLESLOW -10616678
#define RTR_STS_INVTXBUFLEN -10682214
#define RTR_STS_NODNOTFRO -10747750
#define RTR_STS_NODNOTBAC -10813286
#define RTR_STS_ALRSHADOW -10878822
#define RTR_STS_EXINOTCON -10944358
#define RTR_STS_CONNOTSET -11009894
#define RTR_STS_ALLSRVSTA -11075430
#define RTR_STS_NOTSAMNOD -11140966
#define RTR_STS_TWONODALR -11206502
#define RTR_STS_NORDATPAR -11272038
#define RTR_STS_NORLOWBND -11337574
#define RTR_STS_NORUPPBND -11403110
#define RTR_STS_INVPCKLEN -11468646
#define RTR_STS_INVPCKCHAR -11534182
#define RTR_STS_NEGZEROPCK -11599718
#define RTR_STS_NOCALLOUT -11665254
#define RTR_STS_REQCALLUN -11730790
#define RTR_STS_ZEROELEM -11796326
#define RTR_STS_ALLSRVSHA -11861862
#define RTR_STS_TOOMANSHA -11927398
#define RTR_STS_KEYOUTREC -11992934
#define RTR_STS_RNODNOTCNF -12058470
#define RTR_STS_KRRVYINPRG -12124006
#define RTR_STS_KRTAKEOVR -12189542
#define RTR_STS_KRCATCHUP -12255078
#define RTR_STS_NOSRVAVL -12320614
#define RTR_STS_ILLKRIDVAL -12386150
#define RTR_STS_NOMOREPRT -12451686
#define RTR_STS_REQABOTX -12517222
#define RTR_STS_SRVABOTX -12582758
#define RTR_STS_SRVDIED -12648294
#define RTR_STS_BELINLOS -12713830
#define RTR_STS_FELINLOS -12779366
#define RTR_STS_RTLINLOS -12844902
#define RTR_STS_NOCURROU -12910438
#define RTR_STS_REQDIED -12975974
#define RTR_STS_REQDIEDVOT -13041510
#define RTR_STS_SRVDIEDVOT -13107046
#define RTR_STS_SRVDIEDCOM -13172582
#define RTR_STS_ABODEAREQ -13238118
#define RTR_STS_COMDEAREQ -13303654
#define RTR_STS_ABODEASRV -13369190
#define RTR_STS_COMDEASRV -13434726
#define RTR_STS_ENQDEAREQ -13500262
#define RTR_STS_TIMOUT -13565798
#define RTR_STS_SRVDIEDREC -13631334
#define RTR_STS_SRVABOREC -13696870
#define RTR_STS_COMSTAUNO -13762406
#define RTR_STS_DLKTXRES -13827942
#define RTR_STS_CLIABSENT -13893478
#define RTR_STS_CLINEGATED -13959014
#define RTR_STS_NOKEYW -14024550
#define RTR_STS_CONFLICT -14090086
#define RTR_STS_VALREQ -14155622
#define RTR_STS_NOPAREN -14221158
#define RTR_STS_ABKEYW -14286694
#define RTR_STS_ABVERB -14352230
#define RTR_STS_IVKEYW -14417766
#define RTR_STS_IVVERB -14483302
#define RTR_STS_IVQUAL -14548838
#define RTR_STS_PARMDEL -14614374
#define RTR_STS_NOLIST -14679910
#define RTR_STS_MAXPARM -14745446
#define RTR_STS_CDUEOF -14810982
#define RTR_STS_PARREQ -14876518
#define RTR_STS_INVCHANNEL -14942054
#define RTR_STS_INVFLAGS -15007590
#define RTR_STS_INVEVTNUM -15073126
#define RTR_STS_INVEVTRAN -15138662
#define RTR_STS_INVRCPNAM -15204198
#define RTR_STS_INVNUMSEG -15269734
#define RTR_STS_INVPKEYSEG -15335270
#define RTR_STS_INVKSTYPE -15400806
#define RTR_STS_INVKSLENGTH -15466342
#define RTR_STS_INVMSGLEN -15531878
#define RTR_STS_INVWAKEUP -15597414
#define RTR_STS_INVMSGFMT -15662950
#define RTR_STS_INVREASON -15728486
#define RTR_STS_INVJOINCHAN -15794022
#define RTR_STS_FUNCNOTSUP -15859558
#define RTR_STS_TOOMANCHA -15925094
#define RTR_STS_TXNOTACT -15990630
#define RTR_STS_TRUNCATED -16056166
#define RTR_STS_INVCHANAM -16121702
#define RTR_STS_NOTNEG -16187238
#define RTR_STS_INSVIRMEM -16252774
#define RTR_STS_TOOMANDIS -16318310
#define RTR_STS_INVDEVNAM -16383846
#define RTR_STS_INVOP4CLI -16449382
#define RTR_STS_INVOP4SRV -16514918
#define RTR_STS_INVFL4CLI -16580454
#define RTR_STS_INVFL4SRV -16645990
#define RTR_STS_CHANOTOPE -16711526
#define RTR_STS_REQABOREP -16777062
#define RTR_STS_TXTIMOUT -16842598
#define RTR_STS_INVSELITM -16908134
#define RTR_STS_INVSELVAL -16973670
#define RTR_STS_INVSELLEN -17039206
#define RTR_STS_INVGETITMS -17104742
#define RTR_STS_CTXNACC -17170278
#define RTR_STS_CLSNFND -17235814
#define RTR_STS_PFLVNFND -17301350
#define RTR_STS_RBRKMISS -17366886
#define RTR_STS_ITMLSTTOOBIG -17432422
#define RTR_STS_NOCLASS -17497958
#define RTR_STS_CLASSREQ -17563494
#define RTR_STS_TOOMANYSELITM -17629030
#define RTR_STS_NOTHLIST -17694566
#define RTR_STS_FLDNFND -17760102
#define RTR_STS_EMPTYREQ -17825638
#define RTR_STS_SELVALNOTFND -17891174
#define RTR_STS_RQINODATA -17956710
#define RTR_STS_MONCMPERR -18022246
#define RTR_STS_MSGTOOBIG -18087782
#define RTR_STS_INVMESSAGE -18153318
#define RTR_STS_INVMSGSIZE -18218854
#define RTR_STS_CHAALROPE -18284390
#define RTR_STS_HLBNCPTBL -18349926
#define RTR_STS_UNRROUNAM -18415462
#define RTR_STS_AMBROUNAM -18480998
#define RTR_STS_TXALRACC -18546534
#define RTR_STS_TXACTIVE -18612070
#define RTR_STS_NODEFDEV -18677606
#define RTR_STS_BADOUTFIL -18743142
#define RTR_STS_KNLEXECFAIL -18808678
#define RTR_STS_VALTOOBIG -18874214
#define RTR_STS_ERRACCDIR -18939750
#define RTR_STS_NOVALU -19005286
#define RTR_STS_NONPRINTBLE -19070822
#define RTR_STS_BADDSKWRI -19136358
#define RTR_STS_TOOMANCHN -19201894
#define RTR_STS_NOOUTSTND -19267430
#define RTR_STS_TIOSYS_FAILURE -19332966
#define RTR_STS_TIO_BADROWCOL -19398502
#define RTR_STS_ROUTERUNAVAILTMO -19464038
#define RTR_STS_BEREPLAYQDELETED -19529574
#define RTR_STS_MSGFMTTOOSHORT -19595110
#define RTR_STS_INCONSTMSGFMT -19660646
#define RTR_STS_BADKSDORDERING -19726182
#define RTR_STS_UNRECOGMSGFMT -19791718
#define RTR_STS_INVKEYFMT -19857254
#define RTR_STS_IOSNOTSUPP -19922790
#define RTR_STS_REPLYDIFF -19988326
#define RTR_STS_DTXFAIL -20053862
#define RTR_STS_DTXOPENFAIL -20119398
#define RTR_STS_DTXSTARTFAIL -20184934
#define RTR_STS_DTXPREPAREFAIL -20250470
#define RTR_STS_DTXCOMMITFAIL -20316006
#define RTR_STS_DTXROLLBACKFAIL -20381542
#define RTR_STS_ABORTINPROG -20447078
#define RTR_STS_COMMITINPROG -20512614
#define RTR_STS_DCLNOTTERM -20578150
#define RTR_STS_SHUTDOWN -20643686
#define RTR_STS_LRCERROR -20709222
#define RTR_STS_PRTEND -20774758
#define RTR_STS_NOCHANOPEN -20840294
#define RTR_STS_NOMORETXI -20905830
#define RTR_STS_NOTSAMOBJ -20971366
#define RTR_STS_INVCONTXT -21036902
#define RTR_STS_OVERFLOW -21102438
#define RTR_STS_PRTWAITJNL -21167974
#define RTR_STS_ACCERR -21233510
#define RTR_STS_DISKSSM -21299046
#define RTR_STS_DISKNOTMOU -21364582
#define RTR_STS_DISKMOUFOR -21430118
#define RTR_STS_DISKSWL -21495654
#define RTR_STS_DISKALL -21561190
#define RTR_STS_DISKMNTVER -21626726
#define RTR_STS_TEMPLATE_NOT_FE -21692262
#define RTR_STS_DTXRECOV -21757798
#define RTR_STS_DTXRECOVDONE -21823334
#define RTR_STS_DTXINQUIREFAIL -21888870
#define RTR_STS_DTXSETFAIL -21954406
#define RTR_STS_ACPINSRES -22019942
#define RTR_STS_DTXERROR -22085478
#define RTR_STS_DTXCLOSEFAIL -22151014
#define RTR_STS_INVARGPTR -22216550
#define RTR_STS_LOADLIBFAIL -22282086
#define RTR_STS_DTXTOOMANYRMS -22347622
#define RTR_STS_DTXRMEXISTS -22413158
#define RTR_STS_DTXNOSUCHRM -22478694
#define RTR_STS_JOUNOTAVA -22544230
#define RTR_STS_CNTCRJOU -22609766
#define RTR_STS_LOCKFAIL -22675302
#define RTR_STS_CHNOTACTIVE -22740838
#define RTR_STS_INVDSDEF -22806374
#define RTR_STS_CLOSEPEND -22871910
#define RTR_STS_RTRSTART 65594
#define RTR_STS_RTRSTOP 131130
#define RTR_STS_FACADDED 196666
#define RTR_STS_FACDELETE 262202
#define RTR_STS_TRACESTOP 327738
#define RTR_STS_TRACESTAR 393274
#define RTR_STS_TRASUSPEN 458810
#define RTR_STS_TRARESUME 524346
#define RTR_STS_LOGFILSET 589882
#define RTR_STS_COMARESEN 655418
#define RTR_STS_LOGFILSUP 720954
#define RTR_STS_ACPSTOP 786490
#define RTR_STS_DISITMCLR 852026
#define RTR_STS_REASONSTS 917562
#define RTR_STS_JOURNALINI 983098
#define RTR_STS_STACOMSRV 1048698
#define RTR_STS_WAITING 1114234
#define RTR_STS_RESCTRLA 1179770
#define RTR_STS_DEQDATA 1245306
#define RTR_STS_ACPDIED 1310842
#define RTR_STS_SRVDISCON 1376378
#define RTR_STS_SRVNOTRUN 1441914
#define RTR_STS_ENABMOD 1507450
#define RTR_STS_DISABMOD 1572986
#define RTR_STS_FORCEDEXI 1638522
#define RTR_STS_LIVEAPPL 1704058
#define RTR_STS_RTRRCHSTART 1769530
#define RTR_STS_RTRRCHSTOP 1835066
#define RTR_STS_CMDIGNORE 1900666
#define RTR_STS_JOURNALMOD 1966138
#define RTR_STS_NOCHANGES 2031674
#define RTR_STS_FACCREATED 2097210
#define RTR_STS_FACEXTENDED 2162746
#define RTR_STS_FACTRIMMED 2228282
#define RTR_STS_RTRLOGENT 2293818
#define RTR_STS_LOGFILENT 2359418
#define RTR_STS_COMJOUSEA 2424954
#define RTR_STS_JOUSEACOM 2490490
#define RTR_STS_COMMIT 2555962
#define RTR_STS_PATHLOST 2621562
#define RTR_STS_CNCTLOST 2687098
#define RTR_STS_FACSTART 2752634
#define RTR_STS_FACSTARTFE 2818170
#define RTR_STS_FACSTARTBE 2883706
#define RTR_STS_FACSTARTTR 2949242
#define RTR_STS_FACLOSTFE 3014778
#define RTR_STS_FACLOSTBE 3080314
#define RTR_STS_FACLOSTTR 3145850
#define RTR_STS_FACSTOP 3211386
#define RTR_STS_FACSTOPPED 3276922
#define RTR_STS_TRINQUO 3342458
#define RTR_STS_BEINQUO 3407994
#define RTR_STS_CURRTR 3473466
#define RTR_STS_CNCTACCFR 3539002
#define RTR_STS_CNCTCFRM 3604538
#define RTR_STS_FACEXTNFE 3670138
#define RTR_STS_FACEXTNTR 3735674
#define RTR_STS_FACEXTNBE 3801210
#define RTR_STS_FACTRMFE 3866746
#define RTR_STS_FACTRMTR 3932282
#define RTR_STS_FACTRMBE 3997818
#define RTR_STS_SRVDCLSBY 4063290
#define RTR_STS_FACROLEDEL 4128890
#define RTR_STS_TRAALRSTA 4194426
#define RTR_STS_STARTTX 4259898
#define RTR_STS_VOTETX 4325434
#define RTR_STS_RQEQUALS 4391034
#define RTR_STS_TXIDEQUALS 4456570
#define RTR_STS_TIMEEQUALS 4522106
#define RTR_STS_STATXREC 4587578
#define RTR_STS_CDUOK 4653114
#define RTR_STS_CLIPRESENT 4718650
#define RTR_STS_CLIDEFAULTED 4784186
#define RTR_STS_OK 4849722
#define RTR_STS_GRPMODCHG 4915322
#define RTR_STS_OPTSUPSED 4980858
#define RTR_STS_CMDNOTWRK 5046394
#define RTR_STS_LFILREOPE 5111930
#define RTR_STS_NOAPPSRV 5177466
#define RTR_STS_NOHLPENV 5243002
#define RTR_STS_HLPNOTFND 5308538
#define RTR_STS_NOTSTACOMSRV 5374074
#define RTR_STS_SYSSRVCOM 5439610
#define RTR_STS_SYSSRVNOW 5505146
#define RTR_STS_WFPROCESS 5570682
#define RTR_STS_TRMCENTRYNFND 5636218
#define RTR_STS_LNKDSC 5701754
#define RTR_STS_ABORTPEND 5767290
#define RTR_STS_DTXASYNC 5832826
#define RTR_STS_EVENTAST 5898362
#define RTR_STS_PRTBEGIN 5963898
#define RTR_STS_LOWBNDHEX 6029434
#define RTR_STS_HIGBNDHEX 6094970
#define RTR_STS_PRTSCANJNL 6160506
#define RTR_STS_DTXBUSY 6226042
#define RTR_STS_RTRNOTRUN 6291578
#define RTR_STS_DTXNOSUCHXID 6357114
#define RTR_STS_CONNALIAS 6422650
#define RTR_STS_CLUENABLED 6488186
/*
Copyright Digital Equipment Corporation 1994. All rights reserved.

Restricted Rights: Use, duplication, or disclosure by the U.S. Government
is subject to restrictions as set forth in subparagraph (c) (1) (ii) of
DFARS 252.227-7013, or in FAR 52.227-19, or in FAR 52.227-14 Alt. III, as
applicable.

This software is proprietary to and embodies the confidential technology
of Digital Equipment Corporation. Possession, use, or copying of this
software and media is authorized only pursuant to a valid written license
from Digital or an authorized sublicensor.
*/


/*
Kasturi BIswas - Apr 29, 1996
Commented out rtr$_noquorum -- bogus value of message
Re-defiend in rtrmsgtm.h
*/


#ifdef _AIX
#define RTR_UNS_BITFIELD_TYPE unsigned int
#define RTR_SGN_BITFIELD_TYPE unsigned int
#else
#define RTR_UNS_BITFIELD_TYPE unsigned int
#define RTR_SGN_BITFIELD_TYPE int
#endif /* _AIX */


#ifdef VMS
#pragma member_alignment save
#pragma nomember_alignment
/*                                                                          */
/* FILE RT$RTRDEF.MSG CONTAINS RTR MESSAGES EXPORTED                        */
/* (AND USED) BY THE RTR SYSTEM SERVICE CODE -                              */
/* INTO THE FINAL RTRMSG FILE. THE FILE IS A PART                           */
/* OF THE ENTIRE RTR MSG SYSTEM, INCLUDING MSG'S                            */
/* EXPORTED BY OTHER RTR SUB-SYSTEMS.                                       */
/* THE .END (ETC) DIRECTIVE IS CONTAINED IN ANOTHER FILE.                   */
#define RTR$_FACILITY 11
/*                                                                          */
/* %SYSTEM_SERVICE, OBSOLETE                                                */
/*                                                                          */
#define RTR$_NOSERVCHAN 753674
/*                                                                          */
/* %SYSTEM_SERVICE, OBSOLETE                                                */
/*                                                                          */
#define RTR$_NOREQCHAN 753682
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/* THE CHANNEL SUPPLIED FOR TRANSACTION OPERATIONS                          */
/* HAS NOT BEEN DECLARED. USE THE SYSTEM SERVICE                            */
/* $DCL_TX_PRC TO DECLARE CHANNEL BEFORE ATTEMPTING                         */
/* TRANSACTION OPERATIONS. ALTERNATIVELY, CHECK TO                          */
/* SEE IF CHANNEL HAS BEEN SHUTDOWN BY USING THE                            */
/* SHUTDOWN OPTION FOR $DCL_TX_PRC.                                         */
/*                                                                          */
#define RTR$_CHNOTALLOC 753690
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* THE OPERATION REQUESTED REQUIRES THAT A TRANSACTION                      */
/* IS PRESENTLY ACTIVE ON SPECIFIED CHANNEL. A TRANSACTION                  */
/* BECOMES ACTIVE ON A CHANNEL WHEN (IN THE CASE OF A                       */
/* REQUESTER) A $START_TX IS ISSUED ON THE CHANNEL,                         */
/* TERMINATING SUCCESSFULLY.                                                */
/* FOR A SERVER CHANNEL THE TRANSITION TO ACTIVE HAPPENS                    */
/* WHEN A $DEQ_TX TERMINATES WITH AN RTR$_STARTTX                           */
/* STATUS. A TRANSACTION STOPS BEING ACTIVE WHEN IT IS                      */
/* EITHER ABORTED, COMMITTED (IN THE CASE OF A REQUESTER)                   */
/* OR THE $VOTE_TX (IN THE CASE OF A SERVER) SYSTEM                         */
/* SERVICE TERMINATES.                                                      */
/*                                                                          */
#define RTR$_CHNOTACTIVE 753698
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* OPERATION SPECIFIED NOT VALID ON CHANNEL WITH ACTIVE                     */
/* TRANSACTION RUNNING.A TRANSACTION                                        */
/* BECOMES ACTIVE ON A CHANNEL WHEN (IN THE CASE OF A                       */
/* REQUESTER) A $START_TX IS ISSUED ON THE CHANNEL,                         */
/* TERMINATING SUCCESSFULLY.                                                */
/* FOR A SERVER CHANNEL THE TRANSITION TO ACTIVE HAPPENS                    */
/* WHEN A $DEQ_TX TERMINATES WITH AN RTR$_STARTTX                           */
/* STATUS. A TRANSACTION STOPS BEING ACTIVE WHEN IT IS                      */
/* EITHER ABORTED, COMMITTED (IN THE CASE OF A REQUESTER)                   */
/* OR THE $VOTE_TX (IN THE CASE OF A SERVER) SYSTEM                         */
/* SERVICE TERMINATES.                                                      */
/*                                                                          */
#define RTR$_CHACTIVE 753706
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* A $DCL_TX_PRC SYSTEM SERVICE MUST BE CALLED PRIOR                        */
/* TO AND TERMINATE SUCCESSFULLY BEFORE ANY OTHER                           */
/* RTR OPERATION CAN BE EXECUTED.                                           */
/*                                                                          */
#define RTR$_RTRNOTDECL 753714
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* OPERATION SPECIFIED ONLY VALID IN THE CONTEXT OF AN ACTIVE               */
/* TRANSACTION. A TRANSACTION BECOMES ACTIVE ON A CHANNEL                   */
/* WHEN (IN THE CASE OF A REQUESTER) A $START_TX IS ISSUED                  */
/* ON THE CHANNEL, TERMINATING SUCCESSFULLY.                                */
/* FOR A SERVER CHANNEL THE TRANSITION TO ACTIVE HAPPENS                    */
/* WHEN A $DEQ_TX TERMINATES WITH AN RTR$_STARTTX                           */
/* STATUS. A TRANSACTION STOPS BEING ACTIVE WHEN IT IS                      */
/* EITHER ABORTED, COMMITTED (IN THE CASE OF A REQUESTER)                   */
/* OR THE $VOTE_TX (IN THE CASE OF A SERVER) SYSTEM                         */
/* SERVICE TERMINATES.                                                      */
#define RTR$_TXNOTACTIVE 753722
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* A $ABORT_TX SYSTEM SERVICE IS STILL IN PROGRESS                          */
/* FOR THE CHANNEL SPECIFIED. FURTHER OPERATIONS ON CHANNEL                 */
/* MUST AWAIT TERMINATION OF $ABORT_TX SYSTEM                               */
/* SERVICE.                                                                 */
/*                                                                          */
#define RTR$_ABORTINPROG 753730
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* A $COMMIT_TX SYSTEM SERVICE IS STILL IN PROGRESS                         */
/* FOR THE CHANNEL SPECIFIED. FURTHER OPERATIONS ON CHANNEL                 */
/* MUST AWAIT TERMINATION OF $COMMIT_TX SYSTEM                              */
/* SERVICE.                                                                 */
/*                                                                          */
#define RTR$_COMMITINPROG 753738
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* A $VOTE_TX SYSTEM SERVICE IS STILL IN PROGRESS                           */
/* FOR THE CHANNEL SPECIFIED. FURTHER OPERATIONS ON CHANNEL                 */
/* MUST AWAIT TERMINATION OF $VOTE_TX SYSTEM                                */
/* SERVICE.                                                                 */
/*                                                                          */
#define RTR$_2PCINPROG 753746
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* A $VOTE_TX SYSTEM SERVICE CANNOT BE ISSUED                               */
/* FOR THE CHANNEL SPECIFIED. THE $VOTE_TX SYSTEM SERVICE                   */
/* CAN ONLY BE ISSUED FOR A TRANSACTION WHICH HAS ENTERED                   */
/* PHASE 1 OF THE TWO PHASE COMMIT. THIS TRANSITION TAKES PLACE             */
/* WHEN A $DEQ_TX IS TERMINATED WITH AN RTR$_VOTETX STATUS.                 */
#define RTR$_2PCNOTINPROG 753754
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* A $VOTE_TX SYSTEM SERVICE CANNOT BE ISSUED                               */
/* FOR THE CHANNEL SPECIFIED. THE $VOTE_TX SYSTEM SERVICE                   */
/* CAN ONLY BE ISSUED FOR A TRANSACTION WHICH IS IN                         */
/* PHASE 1 OF THE TWO PHASE COMMIT (2PC). THIS PHASE STARTS                 */
/* WHEN A $DEQ_TX IS TERMINATED WITH AN RTR$_VOTETX STATUS.                 */
/* PHASE 1 OF THE 2PC ENDS WHEN A $VOTE_TX IS ISSUED. THIS                  */
/* STARTS THE PHASE 2 OF THE 2PC - THE SO-CALLED UNCERTAINTY                */
/* PERIOD. UNTIL THE $VOTE_TX TERMINATES NO OTHER SYSTEM                    */
/* SERVICE CAN BE ISSUED FOR THIS TRANSACTION.                              */
#define RTR$_2PCUNCERTAIN 753762
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* AT THE TIME OF THE OPERATION ATTEMPTED A MESSAGE WAS                     */
/* FOUND OUTSTANDING INTENDED FOR DELIVERY TO THE                           */
/* APPLICATION PROGRAM. THIS MESSAGE MUST BE READ BY THE                    */
/* APPLICATION BY ISSUING A $DEQ_TX SYSTEM SERVICE.                         */
/*                                                                          */
#define RTR$_MSGPEND 753770
/*                                                                          */
/* %SYSTEM_SERVICE, TXSB_STATUS                                             */
/*                                                                          */
/* BUFFER SUPPLIED BY THE USER WAS TOO SMALL TO HOLD                        */
/* MESSAGE RECEIVED. THE MESSAGE WAS TRUNCATED TO FIT                       */
/* INTO BUFFER. CHECK IF APPLICATION OBSERVES PROTOCOL                      */
/* AGREED TO BETWEEN REQUESTER/SERVER.                                      */
/*                                                                          */
#define RTR$_TRUNCATE 753778
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* AN INVALID NUMBER OF PARAMETERS HAVE BEEN SPECIFIED                      */
/* IN CALL TO SYSTEM SERVICE.                                               */
/*                                                                          */
#define RTR$_INVPARNO 753786
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* AN INVALID CHANNEL NUMBER HAS BEEN SUPPLIED. CHECK                       */
/* RTR APPLICATION WRITERS MANUAL FOR VALID RANGE OF                        */
/* CHANNEL NUMBERS SUPPORTED BY PRESENT RTR RELEASE.                        */
/*                                                                          */
#define RTR$_INVALCH 753794
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* ACCESS PARAMETER PROVIDED IS ILLEGAL. CHECK FOR EITHER                   */
/* NULL ACCESS POINTER, OR NULL LENGTH SPECIFIED IN                         */
/* DESCRIPTOR POINTING TO ACCESS PROPER.                                    */
/*                                                                          */
#define RTR$_INVACCESS 753802
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* FACNAM PARAMETER PROVIDED IS ILLEGAL. CHECK FOR EITHER                   */
/* NULL FACNAM POINTER, OR NULL LENGTH SPECIFIED IN                         */
/* DESCRIPTOR POINTING TO FACNAM PROPER.                                    */
/*                                                                          */
#define RTR$_INVFACNAM 753810
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* INVALID DATPAR ARGUMENT SUPPLIED. CHECK FOR NULL DATPAR                  */
/* POINTER.                                                                 */
/*                                                                          */
#define RTR$_INVDATPAR 753818
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* NULL BUFADR OR BUFLEN ARGUMENT SUPPLIED.                                 */
/*                                                                          */
#define RTR$_INVBUF 753826
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* BUFLEN PARAMETER TO LARGE. CHECK RTR APPLICATION WRITER'S                */
/* MANUAL FOR LARGEST BUFFERLENGTH SUPPORTED BY CURRENT VERSION             */
/* OF RTR.                                                                  */
#define RTR$_INVBUFLEN 753834
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* INVALID EVTMSK ARGUMENT SUPPLIED. SUPPLIED LENGTH                        */
/* EXCEEDS MAXIMUM LENGTH SUPPORTED BY PRESENT VERSION                      */
/* OF RTR.                                                                  */
/*                                                                          */
#define RTR$_INVEVTMSK 753842
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* ADDRESS OF EVTAST SPECIFIED CANNOT BE USED AS ENTRY ADDRESS              */
/* OF ROUTINE.                                                              */
#define RTR$_INVEVTAST 753850
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* AN UNDEFINED FLAG WAS SET, OR AN ILLEGAL FLAG                            */
/* COMBINATION WAS SPECIFIED IN THE FLAGS ARGUMENT. CHECK                   */
/* RTR APPLICATIONS WRITERS MANUAL FOR VALID FLAG BITS AND                  */
/* LEGAL FLAG COMBINATIONS FOR SERVICE IN QUESTION.                         */
/*                                                                          */
#define RTR$_BADFLAG 753858
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* THE PRESENT RELEASE OF THE RTR DOES NOT SUPPORT THE FLAG                 */
/* SPECIFIED.                                                               */
/*                                                                          */
#define RTR$_FLGNOTSUP 753866
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* FOR PRESENT VERSION OF RTR THERE ARE RESTRICTIONS TO                     */
/* WHICH TYPES OF ACCESS CAN BE USED. AT PRESENT ONLY                       */
/* TYPE SUPPORTED IS PASSWORD.                                              */
/*                                                                          */
#define RTR$_ACCNOTSUP 753874
/*                                                                          */
/* %SYSTEM_SERVICE, TXSB_STATUS                                             */
/*                                                                          */
/* THE ONGOING TRANSACTION HAS BEEN ABORTED DUE TO                          */
/* EXHAUSTION OF RTR MEMORY CACHE. THIS ERROR CODE                          */
/* INDICATES A CONGESTION STATE OF RTR DUE TO                               */
/* OPERATIONAL OVERLOAD. CHECK IF FAULTY APPLICATIONS                       */
/* ATTEMPT ISSUING ABNORMALLY LARGE TRANSACTIONS                            */
/* OR ISSUES TRANSACTIONS AT AN ABNORMALLY HIGH RATE.                       */
/*                                                                          */
#define RTR$_CHCQUOEXD 753882
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* THE NUMBER OF CHANNELS DECLARED EXCEEDS MAX. NUMBER                      */
/* OF CHANNELS (PER APPLICATION PROGRAM) SUPPORTED BY                       */
/* PRESENT RTR RELEASE.                                                     */
/*                                                                          */
#define RTR$_CCBEXHAUST 753890
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* THE OPERATION ATTEMPTED IS NOT VALID ON A CHANNEL OF                     */
/* THIS TYPE. CHECK YOUR CHANNEL TYPE FOR REQUESTER OR                      */
/* SERVER, COMPARE THIS TO OPERATION ATTEMPTED.                             */
/*                                                                          */
#define RTR$_OPERNOTVALID 753898
/*                                                                          */
/* %SYSTEM_SERVICE, TXSB_STATUS                                             */
/*                                                                          */
/* UPON TERMINATION OF A COMMIT_TX A NON-TERMINATED                         */
/* DEQ_TX SYSTEM SERVICE WAS FOUND. BOTH OUTSTANDING                        */
/* SYSTEM SERVICES WILL BE TERMINATED WITH                                  */
/* RTR$_NONTRMDEQCOM STATUS CODE. CHECK IF APPLICATION                      */
/* PROGRAM OBSERVES PROTOCOL AGREED BETWEEN SERVER AND                      */
/* REQUESTER PROGRAMS.                                                      */
/*                                                                          */
#define RTR$_NONTRMDEQCOM 753906
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
#define RTR$_NONTRMTXSDWN 753914
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* UPON SHUTDOWN AN OUTSTANDING - I.E. NOT YET DELIVERED - EVENT            */
/* WAS ENCOUNTERED. WAIT FOR EVENT TO BE DELIVERED AND REPEAT               */
/* SHUTDOWN OPERATION.                                                      */
#define RTR$_OUTSTEVTSDWN 753922
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* RTR MEMORY CACHE EXHAUSTION.                                             */
/*                                                                          */
#define RTR$_CACHEXHAU 753930
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* THE PROCESS AST LIMIT HAS BEEN EXCEEDED.                                 */
#define RTR$_EXASTLIM 753938
/*                                                                          */
/* %SYSTEM_SERVICE, R0, TXSB_STATUS                                         */
/*                                                                          */
/* UPON RETURN FROM A USER SPECIFIED EVTAST THE STACK WAS                   */
/* FOUND TO BE CORRUPTED. CHECK EVTAST'S STACK USE.                         */
#define RTR$_INVALSTCK 753946
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* THE RTRACP PROCESS HAS DIED. NO FURTHER RTR SYSTEM                       */
/* SERVICE ACTIVITY WILL BE ALLOWED. RESTART RTRACP                         */
/* AND APPLICATION PROGRAM.                                                 */
/*                                                                          */
#define RTR$_NOACP 753954
/*                                                                          */
/* %SYSTEM_SERVICE, TXSB_STATUS                                             */
/*                                                                          */
/* TRANSACTION ABORTED, CHECK TXSB FIELD RTR$L_TXSB_RSNSTS                  */
/* FOR ADDITIONAL STATUS CODE.                                              */
#define RTR$_ABORT 753960
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* THE CHANNEL SPECIFIED FOR THE OPERATION HAS GOT                          */
/* NON-TERMINATED DCL_TX_PRC OUTSTANDING ON IT.                             */
/* DCL_TX_PRC MUST TERMINATE PRIOR TO ANY OTHER                             */
/* RTR OPERATIONS ON SPECIFIED CHANNEL.                                     */
/*                                                                          */
#define RTR$_DCLNOTTERM 753968
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* RTR SYSTEM SERVICE NOT SUPPORTED BY PRESENT VERSION                      */
/* OF RTR.                                                                  */
/*                                                                          */
#define RTR$_SERVNOTSUP 753976
/*                                                                          */
/* %SYSTEM_SERVICE, TXSB_STATUS, TXSB_RSNSTS                                */
/*                                                                          */
/* SYSTEM SERVICE OUTSTANDING AT CHANNEL SHUTDOWN WAS TERMINATED.           */
/* OUTSTANDING TRANSACTIONS (IF ANY) ABORTED.                               */
/* SHUTDOWN MAY HAVE INDUCED BY THE APPLICATION CALLING $DCL_TX_PRC         */
/* WITH SHUTDOWN FLAG SET. ALTERNATIVELY, THE CHANNEL MAY HAVE BEEN         */
/* SHUT DOWN AS A RESULT OF AN OUTSIDE ACTION - SUCH AS A FACILITY          */
/* DELETION.                                                                */
/* IF RTR$_SHUTDOWN IS RETURNED IN THE TSXB STATUS FIELD THE TXSB           */
/* RSNSTS FIELD WILL CONTAIN A STATUS INDICATING CH SHUTDOWN REASON.        */
/* ALSO RETURNED IN TXSB FIELD RTR$L_TXSB_RSNSTS TO INDICATE                */
/* THAT AN OUTSTANDING TRANSACTION WAS ABORTED DURING CHANNEL               */
/* SHUTDOWN.                                                                */
#define RTR$_SHUTDOWN 753984
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* AN ABORT_TX SYSTEM SERVICE HAS BEEN TERMINATED                           */
/* SYNCHRONOUSLY. THIS HAPPENS WHEN NO OTHER PARTS OF                       */
/* THE RTR SYSTEM HAD TO BECOME INVOLVED IN THE ABORT                       */
/* PROCESSING. THIS HAPPENS IF THE TRANSACTION HAS BEEN                     */
/* STARTED WITH A START_TX (NO TIMEOUT SPECIFIED) AND                       */
/* THE ABORT_TX WAS ISSUED BEFORE ANY OTHER                                 */
/* TRANSACTION OPERATIONS ON THAT PARTICULAR CHANNEL.                       */
/*                                                                          */
#define RTR$_SYNCHABORT 753995
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* A COMMIT_TX SYSTEM SERVICE HAS BEEN TERMINATED                           */
/* SYNCHRONOUSLY. THIS HAPPENS WHEN NO OTHER PARTS OF                       */
/* THE RTR SYSTEM HAD TO BECOME INVOLVED IN THE COMMIT                      */
/* PROCESSING. THIS HAPPENS IF THE TRANSACTION HAS BEEN                     */
/* STARTED WITH A START_TX (NO TIMEOUT SPECIFIED) AND                       */
/* THE COMMIT_TX WAS ISSUED BEFORE ANY OTHER                                */
/* TRANSACTION OPERATIONS ON THAT PARTICULAR CHANNEL.                       */
/*                                                                          */
#define RTR$_SYNCHCOMM 754003
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* THE ONGOING TRANSACTION WAS ABORTED DUE TO A PENDING                     */
/* ABORT OPERATION. CHECK TXSB STATUS/RSNSTS FIELDS FOR                     */
/* MORE INFORMATION ON CAUSE OF ABORT.                                      */
/*                                                                          */
#define RTR$_ABORTPEND 754011
/*                                                                          */
/* %SYSTEM_SERVICE, UNDOCUMENTED                                            */
/*                                                                          */
/* UPON TERMINATION OF A $COMMIT_TX, A NON-TERMINATED SERVICE WAS FOUND. THE */
/* TRANSACTION WILL BE COMITTED AND THE SYSTEM SERVICE WILL BE TERMINATED. CHECK */
/* IF APPLICATION PROGRAM OBSERVES PROTOCOL AGREED BETWEEN SERVER AND REQUESTER */
/* PROGRAMS.                                                                */
/*                                                                          */
#define RTR$_NONTRMSRVCOM 754019
/*                                                                          */
/* %SYSTEM_SERVICE, TXSB_STATUS                                             */
/*                                                                          */
/* UPON TERMINATION OF A COMMIT_TX AN UNDELIVERED MESSAGE WAS FOUND. THE    */
/* TRANACTION WILL BE COMITTED BUT THE MESSAGE IS DISCARDED.  CHECK IF      */
/* APPLICATION PROGRAM OBSERVES PROTOCOL AGREED BETWEEN SERVER AND REQUESTER */
/* PROGRAMS, SINCE THIS ERROR INDICATES THAT THE REQUESTER DID NOT ISSUE ENOUGH  */
/* $DEQ_TX CALLS BEFORE COMMITTING THE TRANSACTION.                         */
/*                                                                          */
#define RTR$_NONDEQMSGCOM 754027
/*                                                                          */
/* %SYSTEM_SERVICE, TXSB_STATUS                                             */
/*                                                                          */
/* TERMINATION STATUS OF A VOTE_TX SYSTEM SERVICE                           */
/* INDICATING THAT THE TRANSACTION IS TO BE COMMITTED.                      */
/* THE APPLICATION IS NOW RESPONSIBLE FOR COMMITTING                        */
/* CHANGES INCURRED TO THE DATABASE.                                        */
/*                                                                          */
#define RTR$_COMMIT 754033
/*                                                                          */
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* INVALID NO OF ARGUMENTS SUPPLIED TO SYSTEM SERVICE,                      */
/* SETTING THE RTR$M_EVENT FLAG REQUIRES THAT ALL                           */
/* ARGUMENTS BE SUPPLIED !                                                  */
/*                                                                          */
#define RTR$_INVALARGNO 754042
/*                                                                          */
/* A SYSTEM SERVICE IS WAITING FOR A RESOURCE. UNTIL THIS WAIT TERMINATES   */
/* NO OTHER SYSTEM SERVICE CALL IS ALLOWED ON THE PARTICULAR CHANNEL. THIS  */
/* TO ENSURE CORRECT SEQUENCE OF MESSAGES AND CALLS TO RTR.                 */
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/*                                                                          */
#define RTR$_SRVINWAIT 754050
/*                                                                          */
/*	A SYSTEM SERVICE CALL HAS NOT FOUND THE RESOURCES AVAILABLE         */
/*	FOR EXECUTION. THE USER HAS SPECIFIED NO WAIT IN THIS SITUATION.    */
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
#define RTR$_NORSRCAVAI 754056
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* INVALID EVTNAM ARGUMENT SPECIFIED. CHECK EVTNAM PARAMETER FOR MAX LENGTH, */
/* READABILITY.                                                             */
/*                                                                          */
#define RTR$_INVEVTNAM 754066
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* THE RTR SYSTEM SERVICE CALL HAS BEEN ACCEPTED FOR PROCESSING.            */
/* HOWEVER DUE TO LACK OF RESOURCES THE SERVICE CALL WILL NOT               */
/* BE TERMINATED IMMEDIATELY. RATHER THE TERMINATION WILL BE                */
/* DELAYED UNTIL SUCH TIME WHEN RESOURCES ARE AVAILABLE. IF AN              */
/* RTR SYSTEM SERVICE CALL (OTHER THAN $DEQ_TX AND $ABORT_TX)               */
/* IS ISSUED ON THE SAME CHANNEL BEFORE TERMINATION OF PREVIOUS             */
/* CALL THE SECOND CALL WILL BE PUT INTO A WAIT-STATE.                      */
/*                                                                          */
#define RTR$_DELAYTERM 754075
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/*	INCORRECT OR UNKNOWN SELTYP ARGUMENT SUPPLIED TO GET_TXI OR         */
/*	SET_TXI SYSTEM SERVICE CALL.                                        */
/*                                                                          */
#define RTR$_SELTYPERR 754082
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/*	INCORRECT ITMLST ARGUMENT SUPPLIED TO GET_TXI OR                    */
/*	SET_TXI SYSTEM SERVICE CALL.                                        */
/*                                                                          */
#define RTR$_ITMLSTERR 754090
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/*	INCORRECT ITMCOD ARGUMENT SUPPLIED TO GET_TXI OR                    */
/*	SET_TXI SYSTEM SERVICE CALL.                                        */
/*                                                                          */
#define RTR$_ITMCODERR 754098
/* %SYSTEM_SERVICE, TXSB_RSNSTS                                             */
/*                                                                          */
/*	CHANNEL SHUTDOWN WAS CAUSED BY APPLICATION CALLING $DCL_TX_PRC      */
/*	WITH THE SHUTDOWN FLAG SET. RETURNED IN RSNSTS FIELD OF TXSB.       */
#define RTR$_SHUTCALL 754104
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/*THE CHANNEL CHOSEN FOR SYSTEM SERVICE EXECUTION HAD A SHUTDOWN PENDING,   */
/*THIS SHUTDOWN HAS NOW BEEN EXECUTED AND THE CHANNEL IS NO LONGER AVAILABLE */
/*FOR RTR OPERATIONS. TO DECLARE NEW RTR CHANNEL USE SYSTEM SERVICE $DCL_TX_PRC */
/*                                                                          */
#define RTR$_SHUTPEND 754115
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/*	DDTM NOT SUPPORTED ON PRE 6.1 VERSIONS OF OPENVMS                   */
/*	                                                                    */
/*                                                                          */
#define RTR$_DDTMVERERR 754122
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/*	USE NONDEFTID FLAG ONLY WITH DDTM SPECIFIED                         */
/*	                                                                    */
/*                                                                          */
#define RTR$_ERRNODDTM 754130
/*                                                                          */
/* %SYSTEM_SERVICE, TXSB_RSNSTS                                             */
/*                                                                          */
/*	THIS STATUS IS USED INTERNALLY BY RTR TO RECOVER A DDTM TXN         */
/*	IN THE PREPARED STATE, WHERE THE ORIGINAL SERVER PROCESS HAS DIED   */
/*                                                                          */
#define RTR$_DDTMEXISTS 754138
/*                                                                          */
/* %SYSTEM_SERVICE, TXSB_RSNSTS                                             */
/*                                                                          */
/*	THIS STATUS IS USED BY RTR AS A REASON TO ABORT A TRANSACTION       */
/*	WHEN THE ATTEMPT TO START A DDTM TRANSACTION FAILS.                 */
/*                                                                          */
#define RTR$_DDTMJOINFAIL 754146
/*                                                                          */
/* COPYRIGHT (C) 1988 BY                                                    */
/* DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.                   */
/* ALL RIGHTS RESERVED.                                                     */
/*                                                                          */
/* THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED    */
/* ONLY  IN  ACCORDANCE  OF  THE  TERMS  OF  SUCH  LICENSE  AND WITH THE    */
/* INCLUSION OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY  OTHER    */
/* COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY    */
/* OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY    */
/* TRANSFERRED.                                                             */
/*                                                                          */
/* THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE    */
/* AND  SHOULD  NOT  BE  CONSTRUED  AS A COMMITMENT BY DIGITAL EQUIPMENT    */
/* CORPORATION.                                                             */
/*                                                                          */
/* DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS    */
/* SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.                  */
/*                                                                          */
/*                                                                          */
/* FACILITY : RTR SUBSYSTEM TM                                              */
/*                                                                          */
/* ABSTRACT : MESSAGE DEFINITIONS FOR RTR SUBSYSTEM TM                      */
/*                                                                          */
/* AUTHOR   : TONY CROSBY                                                   */
/*                                                                          */
/* CREATED  : 8-DEC-1988                                                    */
/*                                                                          */
/*                                                                          */
/* FILE RT$RTRTMDEF.MSG CONTAINS RTR MESSAGES EXPORTED                      */
/* (AND USED) BY THE RTR SUBSYSTEM TM                                       */
/* INTO THE FINAL RTRMSG FILE. THE FILE IS A PART                           */
/* OF THE ENTIRE RTR MSG SYSTEM, INCLUDING MSG'S                            */
/* EXPORTED BY OTHER RTR SUB-SYSTEMS.                                       */
/*                                                                          */
/* %SYSTEM_SERVICE, TXSB_STATUS                                             */
/*                                                                          */
/* RETURNED BY $DEQ_TX TO A SERVER WHEN THE FIRST MESSAGE OF                */
/* A NEW TRANSACTION IS DEQED.                                              */
/*                                                                          */
#define RTR$_STARTTX 755265
/*                                                                          */
/* %SYSTEM_SERVICE, TXSB_STATUS                                             */
/*                                                                          */
/* RETURNED BY $DEQ_TX TO A SERVER AFTER THE REQUESTER ISSUES $COMMIT_TX,   */
/* AND THE LAST MESSAGE OF THE TRANSACTION HAS BEEN DEQED.                  */
/*                                                                          */
#define RTR$_VOTETX 755273
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* DISPLAYS THE PROCESS NAME OF THE REQUESTER [A] AND ITS DECNET NODE ADDRESS */
/* [B] IN MESSAGES RELATING TO TRANSACTIONS.                                */
/*                                                                          */
#define RTR$_RQEQUALS 755283
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* DISPLAYS THE TRANSACTION ID [A] IN MESSAGES                              */
/* RELATING TO TRANSACTIONS.                                                */
/*                                                                          */
#define RTR$_TXIDEQUALS 755291
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* DISPLAYS THE TRANSACTION START TIME [A] IN MESSAGES                      */
/* RELATING TO TRANSACTIONS.                                                */
/*                                                                          */
#define RTR$_TIMEEQUALS 755299
/*                                                                          */
/* %SYSTEM_SERVICE, TXSB_STATUS                                             */
/*                                                                          */
/* STATUS CODE RETURNED ON SERVER $DEQ_TX OR $VOTE_TX IN THE CASE WHERE     */
/* THE TRANSACTION CURRENTLY BEING PROCESSED HAS BEEN ABORTED BY THE        */
/* REQUESTER.                                                               */
/*                                                                          */
#define RTR$_REQABOTX 755306
/*                                                                          */
/* %SYSTEM_SERVICE, TXSB_STATUS                                             */
/*                                                                          */
/* STATUS CODE RETURNED ON SERVER $DEQ_TX OR $VOTE_TX, OR ON REQUESTER      */
/* $ENQ_TX OR $COMMIT_TX IN THE CASE WHERE THE TRANSACTION CURRENTLY BEING  */
/* PROCESSED HAS BEEN ABORTED BY A SERVER FOR THE TX.                       */
/*                                                                          */
#define RTR$_SRVABOTX 755314
/*                                                                          */
/* %SYSTEM_SERVICE, OBSOLETE                                                */
/*                                                                          */
/* THIS CODE IS NEVER RETURNED UNDER ANY CIRCUMSTANCES                      */
/*                                                                          */
#define RTR$_NOSUISRV 755322
/*                                                                          */
/* %SYSTEM_SERVICE, TXSB_STATUS                                             */
/*                                                                          */
/* STATUS CODE RETURNED ON SERVER $DEQ_TX OR $VOTE_TX, OR ON REQUESTER      */
/* $ENQ_TX OR $COMMIT_TX IN THE CASE WHERE THE TRANSACTION CURRENTLY BEING  */
/* PROCESSED HAS BEEN ABORTED BECAUSE A SERVER IMAGE EXITED.                */
/*                                                                          */
#define RTR$_SRVDIED 755330
/*                                                                          */
/* %SYSTEM_SERVICE, TXSB_STATUS                                             */
/*                                                                          */
/*                                                                          */
#define RTR$_BELINLOS 755338
/*                                                                          */
/* %SYSTEM_SERVICE, TXSB_STATUS                                             */
/*                                                                          */
/*                                                                          */
#define RTR$_FELINLOS 755346
/*                                                                          */
/* %SYSTEM_SERVICE, TXSB_STATUS                                             */
/*                                                                          */
/*                                                                          */
#define RTR$_RTLINLOS 755354
/*                                                                          */
/* %SYSTEM_SERVICE, TXSB_STATUS                                             */
/*                                                                          */
/* STATUS CODE RETURNED ON REQUESTER $ENQ_TX OR $COMMIT_TX IN THE CASE      */
/* WHERE THE TRANSACTION CURRENTLY BEING PROCESSED HAS BEEN ABORTED         */
/* BECAUSE NO ROUTER IS AVAILABLE.                                          */
/* RETURNED IN TXSB STATUS FIELD.                                           */
/*                                                                          */
#define RTR$_NOCURROU 755362
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* INDICATES THAT A REQUESTER EXITED BEFORE COMPLETING A TRANSACTION.       */
/*                                                                          */
#define RTR$_REQDIED 755370
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* INDICATES THAT A REQUESTER DIED AFTER COMMITTING, BUT BEFORE COMPLETION OF A */
/* TRANSACTION.                                                             */
/*                                                                          */
#define RTR$_REQDIEDVOT 755378
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* INDICATES THAT A SERVER EXITED BEFORE COMPLETING A TRANSACTION.          */
/*                                                                          */
#define RTR$_SRVDIEDVOT 755386
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* INDICATES THAT A SERVER EXITED AFTER BEING TOLD TO COMMIT A TRANSACTION. */
/*                                                                          */
#define RTR$_SRVDIEDCOM 755394
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* INDICATES THAT A TRANSACTION HAS BEEN ABORTED THAT WAS STARTED BY A      */
/* REQUESTER THAT HAS SINCE EXITED.                                         */
/*                                                                          */
#define RTR$_ABODEAREQ 755402
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* INDICATES THAT A TRANSACTION HAS BEEN COMMITTED THAT WAS STARTED         */
/* BY A REQUESTER THAT HAS SINCE EXITED.                                    */
/*                                                                          */
#define RTR$_COMDEAREQ 755410
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* INDICATES THAT A TRANSACTION HAS BEEN ABORTED THAT WAS SENT TO A SERVER  */
/* THAT HAS SINCE EXITED.                                                   */
/*                                                                          */
#define RTR$_ABODEASRV 755418
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/*                                                                          */
/* INDICATES THAT A TRANSACTION HAS BEEN COMMITTED THAT WAS SENT TO A SERVER */
/* THAT HAS SINCE EXITED.                                                   */
/*                                                                          */
#define RTR$_COMDEASRV 755426
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/*                                                                          */
/* INDICATES THAT A A REPLY $ENQ_TX MESSAGE WAS RECEIVED FOR A REQUESTER    */
/* THAS HAS SINCE EXITED.                                                   */
/*                                                                          */
#define RTR$_ENQDEAREQ 755434
/*                                                                          */
/* %SYSTEM_SERVICE, TXSB_STATUS                                             */
/*                                                                          */
/* STATUS CODE RETURNED ON SERVER $DEQ_TX OR                                */
/* $VOTE_TX, OR ON REQUESTER $ENQ_TX OR $COMMIT_TX IN THE CASE WHERE THE    */
/* TRANSACTION CURRENTLY BEING PROCESSED HAS BEEN ABORTED BECAUSE THE USER- */
/* SPECIFIED TRANSACTION TIMEOUT HAS BEEN EXCEEDED.                         */
/*                                                                          */
#define RTR$_TIMOUT 755442
/*                                                                          */
/* %SYSTEM_SERVICE, TXSB_STATUS                                             */
/*                                                                          */
/* RETURNED BY $DEQ_TX TO A SERVER TO INDICATE THE FIRST MESSAGE            */
/* OF A TRANSACTION REPLAYED DURING RECOVERY. THE SERVER SHOULD             */
/* ENSURE THAT THIS TRANSACTION HAS NOT ALREADY BEEN PROCESSED.             */
/*                                                                          */
#define RTR$_STATXREC 755449
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* INDICATES THAT A SERVER EXITED WHILST PERFORMING RECOVERY OF TRANSACTIONS LOST */
/* ON AN EARLIER FAILURE.                                                   */
/*                                                                          */
#define RTR$_SRVDIEDREC 755458
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* INDICATES THAT A SERVER ABORTED A TRANSACTION BEING RECOVERED AFTER AN EARLIER */
/* FAILURE.                                                                 */
/*                                                                          */
#define RTR$_SRVABOREC 755466
/*                                                                          */
/* %SYSTEM_SERVICE, TXSB_STATUS                                             */
/*                                                                          */
/* STATUS CODE RETURNED ON REQUESTER $COMMIT_TX IN THE CASE WHERE THE       */
/* FATE OF THE TRANSACTION CURRENTLY BEING COMMITTED IS UNOBTAINABLE        */
/* BECAUSE OF AN UNRECOVERABLE HARDWARE ERROR.                              */
/*                                                                          */
/* RETURNED IN TXSB STATUS FIELD.                                           */
/*                                                                          */
#define RTR$_COMSTAUNO 755474
/*                                                                          */
/* %SYSTEM_SERVICE, TXSB_STATUS                                             */
/*                                                                          */
/* STATUS CODE RETURNED ON SERVER $DEQ_TX OR $VOTE_TX IN THE CASE WHERE     */
/* THE TRANSACTION CURRENTLY BEING PROCESSED HAS BEEN ABORTED BECAUSE       */
/* OF A DEADLOCK WITH OTHER TRANSACTIONS USING THE SAME SERVERS. RTR        */
/* WILL REPLAY THE TRANSACTION AFTER THE DEADLOCK HAS BEEN CLEARED.         */
/*                                                                          */
/* RETURNED IN TXSB STATUS FIELD.                                           */
/*                                                                          */
#define RTR$_DLKTXRES 755482
/*                                                                          */
/* %SYSTEM_SERVICE, TXSB_STATUS                                             */
/*                                                                          */
/* STATUS CODE RETURNED ON SERVER $VOTE_TX IN THE CASE WHERE                */
/* THE TRANSACTION CURRENTLY BEING PROCESSED HAS BEEN ABORTED BECAUSE       */
/* THE PARTICIPATING RM HAS ABORTED THE TRANSACTION WHEN ASKED TO PREPARE   */
/*                                                                          */
/* RETURNED IN TXSB RSNSTS FIELD.                                           */
/*                                                                          */
#define RTR$_RMABOTX 755490
/*                                                                          */
/* COPYRIGHT (C) 1988 BY                                                    */
/* DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.                   */
/* ALL RIGHTS RESERVED.                                                     */
/*                                                                          */
/* THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED    */
/* ONLY  IN  ACCORDANCE  OF  THE  TERMS  OF  SUCH  LICENSE  AND WITH THE    */
/* INCLUSION OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY  OTHER    */
/* COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY    */
/* OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY    */
/* TRANSFERRED.                                                             */
/*                                                                          */
/* THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE    */
/* AND  SHOULD  NOT  BE  CONSTRUED  AS A COMMITMENT BY DIGITAL EQUIPMENT    */
/* CORPORATION.                                                             */
/*                                                                          */
/* DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS    */
/* SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.                  */
/*                                                                          */
/*                                                                          */
/* FACILITY : RTR SUBSYSTEM CIF                                             */
/*                                                                          */
/* ABSTRACT : MESSAGE DEFINITIONS FOR RTR SUBSYSTEM CIF                     */
/*                                                                          */
/* AUTHOR   : ANDREW C. SCHOFIELD                                           */
/*                                                                          */
/* CREATED  : 31ST JUNE 1988                                                */
/*                                                                          */
/*                                                                          */
/* FILE RT$RTRCIFDEF.MSG CONTAINS RTR MESSAGES EXPORTED                     */
/* BY SUB-SYSTEM CIF. THESE MESSAGES ARE INCORPORATED                       */
/* INTO THE FINAL RTRMSG FILE. NOTE THIS FILE SHOULD                        */
/* NOT CONTAIN ANY OTHER DIRECTIVES BUT .BASE AND                           */
/* .SEVERITY. THE .FACILITY AND .END (ETC) DIRECTIVES                       */
/* ARE CONTAINED IN OTHER FILES.                                            */
/*                                                                          */
/* MODIFIED:	CHARLES SMITH 24-JUN-1991 14:38:01                          */
/*		- PUT NEW MESSAGE AT END OF FILE TO AVOID VERSION MISMATCHES */
/* MODIFIED:	CHARLES SMITH  5-JAN-1993 10:55:44                          */
/*		- ADD FACEXTENDED AND FACTRIMMED                            */
/* MODIFIED:	DIPNKAR DESHMUKH 25-JAN-1993 6:25                           */
/*		- ADD NOSUCHPRT                                             */
/* MODIFIED:	CHARLES SMITH 4-FEB-1993 17:06:14                           */
/*		- NEW MESSAGES FOR MODIFY JOURNAL                           */
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* INDICATES THAT RTR HAS BEEN SUCCESSFULLY STARTED AFTER ISSUING A         */
/* "START RTR" COMMAND.                                                     */
/*                                                                          */
#define RTR$_RTRSTART 756865
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* INDICATES THAT RTR HAS BEEN SUCCESSFULLY STOPPED AFTER ISSUING A         */
/* "STOP RTR" COMMAND.                                                      */
/*                                                                          */
#define RTR$_RTRSTOP 756873
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* DISPLAYS THE NAME [A] OF THE FACILITY THAT WAS SUCCESSFULLY ADDED AFTER  */
/* ISSUING AN "ADD FACILITY" COMMAND.                                       */
/*                                                                          */
#define RTR$_FACADDED 756881
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* DISPLAYS THE NAME OF THE FACILITY [A] THAT HAS BEEN                      */
/* SUCCESSFULLY DELETED AFTER ISSUING A "DELETE FACILITY" COMMAND.          */
/*                                                                          */
#define RTR$_FACDELETE 756889
/*                                                                          */
/* %UTILITY,UNSUPPORTED                                                     */
/*                                                                          */
/* TRACE SUCCESSFULLY STOPPED AFTER ISSUING A "SET TRACE" COMMAND.          */
/*                                                                          */
#define RTR$_TRACESTOP 756897
/*                                                                          */
/* %UTILITY,UNSUPPORTED                                                     */
/*                                                                          */
/* TRACE SUCCESSFULLY STOPPED AFTER ISSUING A "SET TRACE" COMMAND.          */
/*                                                                          */
#define RTR$_TRACESTAR 756905
/*                                                                          */
/* %UTILITY,UNSUPPORTED                                                     */
/*                                                                          */
/* TRACE SUCCESSFULLY SUSPENDED AFTER ISSUING A "SUSPEND TRACE" COMMAND.    */
/*                                                                          */
#define RTR$_TRASUSPEN 756913
/*                                                                          */
/* %UTILITY,UNSUPPORTED                                                     */
/*                                                                          */
/* TRACE SUCCESSFULLY RESUMED AFTER ISSUING A "RESUME TRACE" COMMAND.       */
/*                                                                          */
#define RTR$_TRARESUME 756921
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* DISPLAYS WHICH LOG FILES [A] WILL BE USED AFTER ISSUING A "SET LOG" COMMAND */
/* WITH THE "/FILE" AND/OR "/OPERATOR" QUALIFIER                            */
/*                                                                          */
#define RTR$_LOGFILSET 756929
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* DISPLAYS THE DEFAULT NODES [A] FOR COMMAND EXECUTION AFTER ISSUING A     */
/* "SET ENVIRONMENT" OR "SHOW ENVIRONMENT" COMMAND                          */
/*                                                                          */
#define RTR$_COMARESEN 756937
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* INDICATES THAT LOGGING WAS SUCCESSFULLY SUPPRESSED AFTER                 */
/* ISSUING A "SET LOG command"                                              */
/* WITHOUT A "/FILE" OR "/OPERATOR" QUALIFIER.                              */
/*                                                                          */
#define RTR$_LOGFILSUP 756945
/*                                                                          */
/* %INTERNAL                                                                */
/*                                                                          */
/*  ERROR CODE SUPPLIED TO $FORCEX WHEN STOPPING THE ACP.                   */
/*                                                                          */
#define RTR$_ACPSTOP 756953
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* INDICATES HOW MANY DISPLAY ITEMS [A] WERE SUCCESSFULLY CLEARED           */
/* AFTER ISSUING A CLEAR DISPLAY COMMAND.                                   */
/*                                                                          */
#define RTR$_DISITMCLR 756961
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* DISPLAYS THE CONTENTS [A] OF THE RSNSTS FIELD OF THE TXSB AFTER          */
/* CALLING AN RTR SYSTEM SERVICE VIA THE DCL INTERFACE                      */
/*                                                                          */
#define RTR$_REASONSTS 756969
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* CONFIRMS THAT THE RTR JOURNAL HAS BEEN SUCCESSFULLY INITIALIZED          */
/* ON DEVICE [A] AFTER ISSUING THE "CREATE JOURNAL" COMMAND.                */
/*                                                                          */
#define RTR$_JOURNALINI 756977
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* INDICATES THAT A COMMAND SERVER IS BEING STARTED ON THE SPECIFIED        */
/* NODE [A].                                                                */
/*                                                                          */
#define RTR$_STACOMSRV 756987
/*                                                                          */
/* %UTILITY,UNSUPPORTED                                                     */
/*                                                                          */
/* INDICATES THAT THE RTR UTILITY WILL WAIT UNTIL CONTROL-G KEY IS PRESSED. */
/* THIS MESSAGE APPEARS WHEN EITHER THE "WAIT" COMMAND OR "DEBUG ACP" COMMAND */
/* IS ISSUED.                                                               */
/*                                                                          */
#define RTR$_WAITING 756995
/*                                                                          */
/* %UTILITY,UNSUPPORTED                                                     */
/*                                                                          */
/* CONFIRMS THAT CONTROL-G WAS PRESSED. THE RTR UTILITY WILL NOW RESUME     */
/* EXECUTION.                                                               */
/*                                                                          */
#define RTR$_RESCTRLA 757003
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* DISPLAYS THE EVENT NUMBER [A], CHANNEL [B] AND DATA [C] IN THE RTR LOG WHEN */
/* AN EVENT OCCURS AND EVENTS WERE REQUESTED BY SUPPLYING                   */
/* THE "/EVENT" QUALIFIER ON THE "$DCL_TX_PRC" COMMAND.                     */
/*                                                                          */
#define RTR$_EVENTAST 757011
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* DISPLAYS THE DEQUEUED DATA [B] AND ITS LENGTH IN BYTES [A]               */
/* WHEN A "SYS$DEQ_TX" COMMAND COMPLETES.                                   */
/*                                                                          */
#define RTR$_DEQDATA 757019
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* DISPLAYS THE LOW BOUND OF THE SERVER KEY RANGE AS                        */
/* HEXADECIMAL NUMBER [A] AFTER ISSUING A                                   */
/* "SYS$DCL_TX_PRC" COMMAND.                                                */
/*                                                                          */
#define RTR$_LOWBNDHEX 757027
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* DISPLAYS THE HIGH BOUND OF THE SERVER KEY RANGE AS                       */
/* HEXADECIMAL NUMBER [A] AFTER ISSUING A                                   */
/* "SYS$DCL_TX_PRC" COMMAND.                                                */
/*                                                                          */
#define RTR$_HIGBNDHEX 757035
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* DISPLAYS THE NAME [A] OF THE OPERATION THAT COMPLETED ON                 */
/* A CHANNEL AFTER ISSUING A "SYS$SYNCH" COMMAND.                           */
/*                                                                          */
#define RTR$_SYSSRVCOM 757043
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* DISPLAYS THE NAME [A] OF THE OPERATION THAT WAS                          */
/* ISSUED WITH THE "/NOWAIT" QUALIFIER ON CHANNEL [B].                      */
/*                                                                          */
#define RTR$_SYSSRVNOW 757051
/*                                                                          */
/* %UTILITY,UNSUPPORTED                                                     */
/*                                                                          */
/* THE RTR ACP PROCESS IS NO LONGER RUNNING, BUT WAS NOT                    */
/* STOPPED WITH THE "STOP RTR" COMMAND. PLEASE SUBMIT A SPR.                */
/*                                                                          */
#define RTR$_ACPDIED 757059
/*                                                                          */
/* %UTILITY,UNSUPPORTED                                                     */
/*                                                                          */
/* DISPLAYS THE NAME [A] OF THE NODE TO WHICH THE LINK HAS BEEN DISCONNECTED */
/* AFTER ISSUING A "DISCONNECT SERVER" COMMAND.                             */
/*                                                                          */
#define RTR$_SRVDISCON 757067
/*                                                                          */
/* %UTILITY,UNSUPPORTED                                                     */
/*                                                                          */
/* DISPLAYS THE NAME [A] OF THE NODE TO WHICH THERE WAS NO LINK             */
/* AFTER ISSUING A "DISCONNECT SERVER" COMMAND.                             */
/*                                                                          */
#define RTR$_SRVNOTRUN 757075
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* DISPLAYS THE NAME [A] OF THE MODE THAT WAS ENABLED AFTER ISSUING         */
/* A "SET MODE" COMMAND.                                                    */
/*                                                                          */
#define RTR$_ENABMOD 757083
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* DISPLAYS THE NAME [A] OF THE MODE THAT WAS DISABLED AFTER ISSUING        */
/* A "SET MODE" COMMAND.                                                    */
/*                                                                          */
#define RTR$_DISABMOD 757091
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* DISPLAYS THE NAME [A] AND PID [B] OF THE PROCESSES THAT WERE FORCED TO EXIT */
/* DUE TO THE EXECUTION OF A "STOP RTR" COMMAND.                            */
/*                                                                          */
#define RTR$_FORCEDEXI 757099
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* DISPLAYS THE NAME [A] AND PID [B] OF THE PROCESSES THAT ARE STILL ATTACHED */
/* TO RTR.                                                                  */
/*                                                                          */
#define RTR$_LIVEAPPL 757107
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* DISPLAYS THE NAME [A] OF A FILE THAT THE RTR UTILITY WAS UNABLE TO       */
/* OPEN. IT IS FOLLOWED BY AN RMS ERROR MESSAGE WHICH GIVES MORE            */
/* DETAILS.                                                                 */
/*                                                                          */
#define RTR$_ERROPEFIL 757114
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* DISPLAYS THE NAME [A] OF A FILE THAT THE RTR UTILITY WAS UNABLE TO       */
/* ACCESS. IT IS FOLLOWED BY AN RMS ERROR MESSAGE WHICH GIVES MORE          */
/* DETAILS.                                                                 */
/*                                                                          */
#define RTR$_ERRACCFIL 757122
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* INDICATES THAT THE COMMAND [A] REQUESTED WITH "RECALL" WAS               */
/* NOT IN THE RECALL BUFFER.                                                */
/*                                                                          */
#define RTR$_COMNOTFOU 757130
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* INDICATES THAT THE COMMAND NUMBER REQUESTED WITH "RECALL" WAS            */
/* NOT IN THE ALLOWED RANGE (1 TO [A]).                                     */
/*                                                                          */
#define RTR$_COMNUMMUS 757138
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE NODE NAME LIST SPECIFIED WITH THE                                    */
/* "/FRONTEND", "/ROUTER" OR "/BACKEND" QUALIFIERS ON AN                    */
/* "ADD FACILITY" COMMAND CONTAINED THE NODE NAME [A] MORE                  */
/* THAN ONCE.                                                               */
/*                                                                          */
#define RTR$_DUPNODNAM 757146
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* AN EMPTY STRING WAS SPECIFIED WHERE A FACILITY NAME WAS EXPECTED.        */
/*                                                                          */
#define RTR$_FACNAMBLA 757154
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* FACILITY NAME [A] IS TOO LONG.                                           */
/*                                                                          */
#define RTR$_FACNAMLON 757162
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* FACILITY NAME [A] DOES NOT START WITH A CAPITAL LETTER ("A" TO "Z").     */
/*                                                                          */
#define RTR$_FACNAMSTA 757170
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* FACILITY NAME [A] CONTAINS THE ILLEGAL CHARACTER [B].                    */
/* LEGAL CHARACTERS ARE CAPITAL LETTERS ("A" TO "Z"), NUMBERS ("0" TO "9"), */
/* DOLLAR ("$") AND UNDERSCORE ("_").                                       */
/*                                                                          */
#define RTR$_FACNAMILL 757178
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* WILDCARDS ("%" AND "*") ARE NOT ALLOWED.                                 */
/*                                                                          */
#define RTR$_WILNOTALL 757186
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* NO ROUTERS WERE SPECIFIED ON AN "ADD FACILITY" COMMAND                   */
/* AND THE NODE WHERE THE COMMAND WAS EXECUTED WAS SPECIFIED                */
/* AS BEING A FRONTEND AND/OR BACKEND.                                      */
/*                                                                          */
#define RTR$_NOROUTERS 757194
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* NO BACKEND WERE SPECIFIED ON AN "ADD FACILITY" COMMAND                   */
/* AND THE NODE WHERE THE COMMAND WAS EXECUTED WAS SPECIFIED                */
/* AS BEING A ROUTER.                                                       */
/*                                                                          */
#define RTR$_NOBACKEND 757202
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* NO FRONTENDS WERE SPECIFIED ON AN "ADD FACILITY" COMMAND                 */
/* AND THE NODE WHERE THE COMMAND WAS EXECUTED WAS SPECIFIED                */
/* AS BEING A ROUTER.                                                       */
/*                                                                          */
#define RTR$_NOFRONTEN 757210
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE NODE WHERE AN "ADD FACILITY" COMMAND WAS EXECUTED                    */
/* WAS NOT SPECIFIED AS BEING A FRONTEND, ROUTER OR BACKEND.                */
/*                                                                          */
#define RTR$_OWNNODMIS 757218
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE FACILITY [A] SPECIFIED WITH THE "ADD FACILITY" COMMAND               */
/* ALREADY EXISTS.                                                          */
/*                                                                          */
#define RTR$_FACALREXI 757226
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* INDICATES THAT THE CONFIGURATION TABLES COULD NOT BE ACCESSED.           */
/* THE SUBSEQUENT MESSAGE GIVES MORE DETAILS.                               */
/*                                                                          */
#define RTR$_ERRACCTAB 757234
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* INDICATES THAT THE CONFIGURATION TABLES COULD NOT BE INITIALIZED.        */
/* THE SUBSEQUENT MESSAGE GIVES MORE DETAILS.                               */
/*                                                                          */
#define RTR$_ERRINIACS 757242
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* RTR HAD NOT BEEN STARTED WHEN THE COMMAND WHEN                           */
/* A COMMAND WAS ISSUED WHICH REQUIRES RTR TO BE RUNNING.                   */
/*                                                                          */
#define RTR$_RTRNOTSTA 757250
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* RTR WAS ALREADY RUNNING WHEN THE "START RTR" COMMAND                     */
/* WAS EXECUTED.                                                            */
/*                                                                          */
#define RTR$_RTRALRSTA 757258
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* RTR HAD BEEN STOPPED WHEN THE COMMAND WHEN                               */
/* A COMMAND WAS ISSUED WHICH REQUIRES RTR TO BE RUNNING.                   */
/*                                                                          */
#define RTR$_RTRWASSTO 757266
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE REQUESTED FACILITY [A] DOES NOT EXIST.                               */
/*                                                                          */
#define RTR$_NOSUCHFAC 757274
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* NO FACILITIES HAVE YET BEEN DEFINED WITH THE                             */
/* "ADD FACILITY" COMMAND.                                                  */
/*                                                                          */
#define RTR$_NOFACILIT 757282
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* AN ERROR OCCURRED WHILST CREATING A MAILBOX.                             */
/* THE SUBSEQUENT MESSAGE GIVES MORE DETAILS.                               */
/*                                                                          */
#define RTR$_ERRCREMBX 757290
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* AN ERROR OCCURRED WHILST ACCESSING A MAILBOX.                            */
/* THE SUBSEQUENT MESSAGE GIVES MORE DETAILS.                               */
/*                                                                          */
#define RTR$_ERRACCMBX 757298
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* AN ERROR OCCURRED WHILST DELETING A MAILBOX.                             */
/* THE SUBSEQUENT MESSAGE GIVES MORE DETAILS.                               */
/*                                                                          */
#define RTR$_ERRDELMBX 757306
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE SPECIFIED FILENAME [A] IS INVALID. THE SUBSEQUENT RMS MESSAGE        */
/* GIVES MORE DETAILS.                                                      */
/*                                                                          */
#define RTR$_INVFILNAM 757314
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* %UTILITY,UNSUPPORTED                                                     */
/*                                                                          */
/* THE SUBSYSTEM NAME [A] SPECIFIED WITH THE "/SUBSYSTEM" QUALIFIER         */
/* ON THE "SET TRACE" COMMAND IS TOO LONG.                                  */
/*                                                                          */
#define RTR$_SUBTOOLON 757322
/*                                                                          */
/* %UTILITY,UNSUPPORTED                                                     */
/*                                                                          */
/* TOO MANY SUBSYSTEM NAMES WERE SPECIFIED WITH THE "/SUBSYSTEM" QUALIFIER  */
/* ON THE "SET TRACE" COMMAND.                                              */
/*                                                                          */
#define RTR$_TOOMANSUB 757330
/*                                                                          */
/* %UTILITY,UNSUPPORTED                                                     */
/*                                                                          */
/* TRACE WAS NOT ENABLED WHEN A "SUSPEND TRACE" COMMAND                     */
/* WAS ISSUED.                                                              */
/*                                                                          */
#define RTR$_TRANOTACT 757338
/*                                                                          */
/* %UTILITY,UNSUPPORTED                                                     */
/*                                                                          */
/* TRACE WAS ALREADY SUSPENDED WHEN A "SUSPEND TRACE" COMMAND               */
/* WAS ISSUED.                                                              */
/*                                                                          */
#define RTR$_TRAALRSUS 757346
/*                                                                          */
/* %UTILITY,UNSUPPORTED                                                     */
/*                                                                          */
/* TRACE WAS NOT SUSPENDED WHEN A "RESUME TRACE" COMMAND                    */
/* WAS ISSUED.                                                              */
/*                                                                          */
#define RTR$_TRANOTSUS 757354
/*                                                                          */
/* %UTILITY,UNSUPPORTED                                                     */
/*                                                                          */
/* TOO MANY FILE NAMES WERE SPECIFIED WITH THE "/FILE" QUALIFIER            */
/* ON THE "SET LOG" COMMAND.                                                */
/*                                                                          */
#define RTR$_TOOMANLOG 757362
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* INDICATES THAT LOGGING WAS NOT ACTIVE WHEN A "SHOW LOG" COMMAND WAS ISSUED. */
/*                                                                          */
#define RTR$_LOGNOTACT 757370
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE PROCESS WITH ID = [A] DOES NOT EXIST OR IS NOT USING                 */
/* RTR.                                                                     */
/*                                                                          */
#define RTR$_NOSUCHPRC 757378
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* NO PROCESSES ARE CURRENTLY USING RTR.                                    */
/*                                                                          */
#define RTR$_NORTRPROC 757386
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE SPECIFIED PROCESS ID [A] HAS AN INVALID FORMAT.                      */
/* PROCESS ID'S ARE HEXADECIMAL NUMBERS WITH UP TO EIGHT DIGITS.            */
/*                                                                          */
#define RTR$_PROCIDILL 757394
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE RTR ACP PROCESS COULD NOT BE STARTED WHEN A "START RTR"              */
/* COMMAND WAS ISSUED. THE SUBSEQUENT MESSAGE GIVES MORE                    */
/* DETAILS.                                                                 */
/*                                                                          */
#define RTR$_ERRSTAACP 757402
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE REQUESTED COUNTER [A] DOES NOT EXIST.                                */
/*                                                                          */
#define RTR$_NOSUCHCOU 757410
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* INDICATES THAT INVALID COORDINATES WERE SPECIFIED                        */
/* ON A "CLEAR DISPLAY" OR "SHOW DISPLAY" COMMAND. NO ITEM                  */
/* IS DISPLAYED AT POINT [A], [B].                                          */
/*                                                                          */
#define RTR$_NOSUCHITM 757418
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* INDICATES THAT INVALID COORDINATES WERE SPECIFIED                        */
/* ON A "DISPLAY" COMMAND WITHIN A DISPLAY FILE. THERE ALREADY IS           */
/* AN ITEM AT POINT [A], [B].                                               */
/*                                                                          */
/*                                                                          */
#define RTR$_ITMALREXI 757426
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* INDICATES THAT NO ITEMS HAD BEEN DEFINED WITH THE DISPLAY                */
/* COMMAND WHEN A "MONITOR" OR "SCROLL" COMMAND WAS ISSUED.                 */
/*                                                                          */
#define RTR$_NOTHTODIS 757434
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* AN ERROR OCCURRED WHILST ACCESSING NODE [A].                             */
/* THE SUBSEQUENT ERROR MESSAGE GIVES MORE DETAILS.                         */
/*                                                                          */
#define RTR$_ERRACCNOD 757442
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* AN ATTEMPT WAS MADE TO MONITOR TOO MANY PROCESSES.                       */
/* PLEASE SUBMIT AN SPR.                                                    */
/*                                                                          */
#define RTR$_TOOMUCDAT 757450
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* A SCROLL OR PRINT COMMAND WAS ISSUED BEFORE ANY MONITOR PICTURE          */
/* HAD BEEN DISPLAYED.                                                      */
/*                                                                          */
#define RTR$_MONNOTACT 757458
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE VALUE OF QUALIFIER [A] MUST BE GREATER OR EQUAL TO [B].              */
/*                                                                          */
#define RTR$_TOOSMALL 757466
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE VALUE OF QUALIFIER [A] MUST BE LESS OR EQUAL TO [B].                 */
/*                                                                          */
#define RTR$_TOOBIG 757474
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE SPECIFIED DISPLAY FILE CONTAINED A COMMAND [A] OTHER THAN "DISPLAY". */
/* THIS IS SOMETIMES CAUSED BY FORGETTING THE CONTINUATION CHARACTER ("-")  */
/* ON THE END OF A LINE THAT IS TO BE CONTINUED.                            */
/* USE MONITOR/VERIFY TO FIND THE INCORRECT COMMAND.                        */
/*                                                                          */
#define RTR$_ONLYDISP 757482
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE FILE-NAME [A] COULD REFER TO MORE THAN ONE                           */
/* MONITOR FILE. PLEASE SUPPLY MORE CHARACTERS.                             */
/*                                                                          */
#define RTR$_AMBIGDISP 757490
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE REQUESTED MONITOR FILE [A] DOES NOT EXIST.                           */
/*                                                                          */
#define RTR$_NOSUCHDIS 757498
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE REQUESTED NODE [A] DOES NOT EXIST.                                   */
/*                                                                          */
#define RTR$_NOSUCHNOD 757506
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* IF A PROCESS ID IS SUPPLIED ON "MONITOR" COMMAND THEN                    */
/* ONLY ONE NODE MAY BE MONITORED.                                          */
/*                                                                          */
#define RTR$_ONLONENOD 757514
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE STRING SUPPLIED WITH THE "/ACCESS" QUALIFIER ON THE                  */
/* "SYS$DCL_TX_PRC" COMMAND WAS TOO LONG.                                   */
/*                                                                          */
#define RTR$_ACCTOOBIG 757522
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE STRING [A] COULD NOT BE CONVERTED TO DATA TYPE                       */
/* [B]. THE SUBSEQUENT MESSAGE GIVES THE REASON.                            */
/*                                                                          */
#define RTR$_MSGDATILL 757530
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE "/EVENT" QUALIFIER ON THE "SYS$DCL_TX_PRC" COMMAND                   */
/* SPECIFIED AN UNKNOWN EVENT NAME.                                         */
/*                                                                          */
#define RTR$_EVTNAMILL 757538
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* DISPLAYED WHEN A "SYS$DCL_TX_PRC" COMMAND IS ISSUED                      */
/* AND THE CHANNEL TABLE IS FULL.                                           */
/*                                                                          */
#define RTR$_TOOMANCHN 757546
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE REQUESTED CHANNEL [A] HAS NOT BEEN DECLARED.                         */
/*                                                                          */
#define RTR$_NOSUCHCHN 757554           /*                                  */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE CHANNEL SPECIFIED WITH THE "/CHANNEL" QUALIFIER ON                   */
/* A "SYS$DCL_TX_PRC" COMMAND HAS ALREADY BEEN DECLARED.                    */
/*                                                                          */
#define RTR$_CHNALRDEC 757562
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE EXPRESSION [A] IS TOO COMPLEX TO EVALUATE.                           */
/* PLEASE SUBMIT AN SPR.                                                    */
/*                                                                          */
#define RTR$_EXPTOOCOM 757570
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE NUMERIC CONSTANT [A] IS INVALID.                                     */
/*                                                                          */
#define RTR$_NUMCONILL 757578
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* COUNTER [A] IS NOT THE SAME TYPE AS THE OTHER COUNTERS IN THE EXPRESSION. */
/* ALL COUNTERS IN AN EXPRESSION MUST BE EITHER 'PROCESS COUNTERS',         */
/* 'FACILITY COUNTERS', 'LINK COUNTERS' OR 'NODE COUNTERS'.                 */
/*                                                                          */
#define RTR$_NOTSAMTYP 757586
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE EXPRESSION IS INVALID BECAUSE IT TERMINATED WHERE                    */
/* WHEN TOKEN [A] WAS EXPECTED.                                             */
/*                                                                          */
#define RTR$_UNEXPEND 757594
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE EXPRESSION IS INVALID BECAUSE TOKEN [A]                              */
/* WAS EXPECTED BUT [B] WAS FOUND.                                          */
/*                                                                          */
#define RTR$_EXPSYNILL 757602
/*                                                                          */
/* %UTILITY                                                                 */
/* THE EXPRESSION IS INVALID BECAUSE THE CHARACTERS [A]                     */
/* AT THE END OF THE EXPRESSION COULD NOT BE INTERPRETED.                   */
/*                                                                          */
#define RTR$_SUPCHAEND 757610
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* DECNET WAS SHUTDOWN ON LOCAL NODE WHEN THE RTR UTILITY WAS BEING USED    */
/*                                                                          */
#define RTR$_NODECNET 757618
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE NODE [A] IS UNKNOWN TO DECNET.                                       */
/*                                                                          */
#define RTR$_NODNOTKNO 757626
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/*                                                                          */
/* AN ERROR OCCURRED WHILST TRYING TO LOOK UP NODE [A]                      */
/* IN THE DECNET DATABASE. THE SUBSEQUENT MESSAGE GIVES MORE                */
/* DETAILS.                                                                 */
/*                                                                          */
#define RTR$_ERRGETNOD 757634
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THIS MESSAGE IS DISPLAYED WHEN AN "ADD FACILITY" COMMAND IS ISSUED.  IT  */
/* INDICATES THAT THE TOTAL NUMBER OF DIFFERENT NODES SPECIFIED WITH THIS AND */
/* ALL PREVIOUS "ADD FACILITY" COMMANDS WOULD EXCEED THE LIMIT SPECIFIED WITH */
/* THE "/LINKS" QUALIFIER WHEN RTR WAS STARTED.                             */
/*                                                                          */
#define RTR$_NDBTABFUL 757642
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/*                                                                          */
/* THIS MESSAGE IS DISPLAYED WHEN AN "ADD FACILITY" COMMAND IS ISSUED.  IT  */
/* INDICATES THAT THE MAXIMUM NUMBER OF FACILITIES HAS ALREADY BEEN REACHED. */
/* THIS MAXIMUM IS SPECIFIED WITH THE "/FACILITIES" QUALIFIER               */
/* WHEN RTR IS STARTED.                                                     */
/*                                                                          */
#define RTR$_FDBTABFUL 757650
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THIS MESSAGE IS DISPLAYED WHEN AN "ADD FACILITY" COMMAND IS ISSUED.  IT  */
/* INDICATES THAT THE MAXIMUM NUMBER OF FACILITY TO LINK RELATIONS          */
/* HAS BEEN REACHED.                                                        */
/* THIS MAXIMUM IS SPECIFIED WITH THE "/RELATIONS" QUALIFIER                */
/* WHEN RTR IS STARTED.                                                     */
/*                                                                          */
#define RTR$_FACTABFUL 757658
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* A "SYS$SYNCH" COMMAND WAS ISSUED BUT THERE WERE NO OUTSTANDING           */
/* OPERATIONS ON CHANNEL [A]                                                */
/*                                                                          */
#define RTR$_NOOUTSTND 757666
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* AN UNSUPPORTED COMMAND WAS ISSUED.                                       */
/*                                                                          */
#define RTR$_CMDRESDEV 757674
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* A "SET MODE/GROUP" COMMAND WAS ISSUED WHILE RUNNING UNDER                */
/* SYSTEM UIC (GROUP ONE). SYSTEM UIC'S CANNOT BE USED IN                   */
/* GROUP MODE.                                                              */
/*                                                                          */
#define RTR$_UICNOTGRP 757682
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* RTR IS NOT CORRECTLY INSTALLED.                                          */
/* REFER TO THE RTR INSTALLATION GUIDE FOR                                  */
/* DETAILS OF HOW TO INSTALL RTR.                                           */
/*                                                                          */
#define RTR$_BADRTRINS 757690
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* "OPER" PRIVILEGE OR THE "RTR$OPERATOR" IDENTIFIER IS REQUIRED TO         */
/* RUN THE RTR UTILITY.                                                     */
/*                                                                          */
#define RTR$_INSUFPRIV 757698
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* "SETPRV" PRIVILEGE IS REQUIRED TO EXECUTE A REMOTE COMMAND               */
/*                                                                          */
#define RTR$_NFW 757706
/*                                                                          */
/* %UTILITY,OBSOLETE                                                        */
/*                                                                          */
/* THE RTR JOURNAL CANNOT BE INITIALIZED IF RTR IS RUNNING.                 */
/* FIRST STOP RTR AND THEN RE-ISSUE THE "CREATE JOURNAL"                    */
/* COMMAND.                                                                 */
/*                                                                          */
#define RTR$_ININOTRUN 757714
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* RTR CAN ONLY PLACE IS NOT ABLE TO PLACE ITS JOURNAL FILES ON             */
/* REMOTE SYSTEMS. RE-ISSUE THE "CREATE JOURNAL" COMMAND                    */
/* WITHOUT THE NODE NAME AND COLONS ("::").                                 */
/*                                                                          */
#define RTR$_ILLREMDEV 757722
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* RTR CAN ONLY PLACE ITS JOURNAL FILES ON DIRECTORY STRUCTURED             */
/* DEVICES. RE-ISSUE THE "CREATE JOURNAL" COMMAND SPECIFYING                */
/* A DISK.                                                                  */
/*                                                                          */
#define RTR$_ILLDEVTYP 757730
/*                                                                          */
/* %INTERNAL                                                                */
/*                                                                          */
/*  EXIT STATUS FROM RTRCOMSERV WHEN INACTIVITY TIMEOUT EXPIRES             */
/*                                                                          */
#define RTR$_INATIMOUT 757738
/*                                                                          */
/* %INTERNAL                                                                */
/*                                                                          */
/*  EXIT STATUS FROM RTRCOMSERV WHEN CONNECT TIMEOUT EXPIRES                */
/*                                                                          */
#define RTR$_CONTIMOUT 757746
/*                                                                          */
/* %INTERNAL                                                                */
/*                                                                          */
/*  EXIT STATUS FROM RTRCOMSERV WHEN SYTEM/GROUP MODE CHANGED               */
/*                                                                          */
#define RTR$_MODECHANGE 757754
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/*  COMMAND WAS LONGER THAN 256 CHARACTERS.                                 */
/*                                                                          */
#define RTR$_CMDTOOLON 757762
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/*  INDICATES THAT RTR CANNOT BE STOPPED UNDER PRESENT CIRCUMSTANCES        */
/*                                                                          */
#define RTR$_CANTSTOP 757770
/*                                                                          */
/* %INTERNAL                                                                */
/*                                                                          */
/*  EXIT STATUS FROM RTRCOMSERV DURING AN ENVIRONMENT ERROR, PROBABLY       */
/*  CAUSED THROUGH ISSUING RTR COMMANDS VIA THE SYSMAN UTILITY.             */
/*                                                                          */
#define RTR$_BADNVRMT 757778
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE REMOTE CLIENT HANDLER HAD NOT BEEN STARTED WHEN                      */
/* A COMMAND WAS ISSUED WHICH REQUIRES IT TO BE RUNNING.                    */
/*                                                                          */
#define RTR$_RCHNOTSTA 757786
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE REMOTE CLIENT HANDLER WAS ALREADY RUNNING WHEN THE                   */
/* "START REMOTE_CLIENT_HANDLER" COMMAND WAS EXECUTED.                      */
/*                                                                          */
#define RTR$_RCHALRSTA 757794
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE REMOTE CLIENT HANDLER HAD BEEN STOPPED WHEN                          */
/* A COMMAND WAS ISSUED WHICH REQUIRES IT TO BE RUNNING.                    */
/*                                                                          */
#define RTR$_RCHWASSTO 757802
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE RTR REMOTE CLIENT HANDLER PROCESS COULD NOT BE STARTED WHEN          */
/* A "START REMOTE_CLIENT_HANDLER" COMMAND WAS ISSUED. THE SUBSEQUENT       */
/* MESSAGE GIVES MORE DETAILS.                                              */
/*                                                                          */
#define RTR$_ERRSTARCH 757810
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* INDICATES THAT REMOTE CLIENT HANDLER HAS BEEN SUCCESSFULLY STARTED       */
/* AFTER ISSUING A "START REMOTE_CLIENT_HANDLER" COMMAND.                   */
/*                                                                          */
#define RTR$_RTRRCHSTART 757817
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* INDICATES THAT THE REMOTE CLIENT HANDLER HAS BEEN SUCCESSFULLY STOPPED   */
/* AFTER ISSUING A "STOP REMOTE_CLIENT_HANDLER" COMMAND.                    */
/*                                                                          */
#define RTR$_RTRRCHSTOP 757825
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* INDICATES THAT THE COMMAND IS IGNORED ON THE EXECUTING NODE SINCE IT     */
/* HAS NO SIGNIFICANCE FOR THE ROLE DEFINED.                                */
/*                                                                          */
#define RTR$_CMDIGNORE 757835
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* CONFIRMS THAT THE RTR JOURNAL HAS SUCCESSFULLY MODIFIED THE SIZE         */
/* REQUIREMENTS ON DEVICE [A] AFTER ISSUING THE "MODIFY JOURNAL" COMMAND.   */
/*                                                                          */
#define RTR$_JOURNALMOD 757841
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* A DISK WAS SPECIFIED AS PART OF A MODIFY JOURNAL COMMAND WHICH WAS       */
/* NOT PART OF THE ORIGINAL DISK SET SPECIFIED IN THE CREATE JOURNAL        */
/* COMMAND.                                                                 */
/*                                                                          */
#define RTR$_DSKNOTSET 757850
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE NUMBER OF BLOCKS SPECIFIED WITH THE /MAX_BLOCKS QUALIFIER IN         */
/* THE CREATE JOURNAL OR MODIFY JOURNAL COMMAND WAS LOWER THAN THE NUMBER   */
/* OF BLOCKS SPECIFIED WITH THE /BLOCKS QUALIFIER.                          */
/*                                                                          */
#define RTR$_MAXTOOSMA 757858
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE MODIFICATIONS SPECIFIED RESULTED IN NO CHANGES BEING REQUIRED.       */
/*                                                                          */
#define RTR$_NOCHANGES 757865
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* DISPLAYS THE NAME [A] OF THE FACILITY THAT WAS SUCCESSFULLY CREATED AFTER  */
/* ISSUING A "CREATE FACILITY" COMMAND.                                     */
/*                                                                          */
#define RTR$_FACCREATED 757873
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* DISPLAYS THE NAME [A] OF THE FACILITY THAT WAS SUCCESSFULLY EXTENDED     */
/* (OR CREATED) AFTER ISSUING AN "EXTEND FACILITY" COMMAND.                 */
/*                                                                          */
#define RTR$_FACEXTENDED 757881
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* DISPLAYS THE NAME [A] OF THE FACILITY THAT WAS SUCCESSFULLY TRIMMED AFTER  */
/* ISSUING A "TRIM FACILITY" COMMAND.                                       */
/*                                                                          */
#define RTR$_FACTRIMMED 757889
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE REQUESTED PARTITION [A] DOES NOT EXIST.                              */
/*                                                                          */
#define RTR$_NOSUCHPRT 757898
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE RTR LOG COMMAND WAS USED TO MAKE AN ENTRY IN THE RTR LOG             */
/*                                                                          */
#define RTR$_RTRLOGENT 757905
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE EXECUTOR LIMIT ON THE NUMBER OF DECNET CONNECT OBJECTS HAS BEEN EXCEEDED. */
/* PLEASE USE NCP TO RAISE THE MAXIMUM NUMBER OF OBJECTS ON THIS NODE.      */
/*                                                                          */
#define RTR$_TOOMANYOBJ 757914
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* APPROPRIATE LICENSE IS NOT INSTALLED FOR THE REQUIRED OPERATION          */
/*                                                                          */
#define RTR$_NOLICENSE 757922
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* RCH RECEIVED A MESSAGE FROM A CLIENT WHICH IT DID NOT RECOGNIZE          */
/*                                                                          */
#define RTR$_RCHBADMSG 757932
/*                                                                          */
/* COPYRIGHT (C) 1988 BY                                                    */
/* DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.                   */
/* ALL RIGHTS RESERVED.                                                     */
/*                                                                          */
/* THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED    */
/* ONLY  IN  ACCORDANCE  OF  THE  TERMS  OF  SUCH  LICENSE  AND WITH THE    */
/* INCLUSION OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY  OTHER    */
/* COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY    */
/* OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY    */
/* TRANSFERRED.                                                             */
/*                                                                          */
/* THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE    */
/* AND  SHOULD  NOT  BE  CONSTRUED  AS A COMMITMENT BY DIGITAL EQUIPMENT    */
/* CORPORATION.                                                             */
/*                                                                          */
/* DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS    */
/* SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.                  */
/*                                                                          */
/* FACILITY : RTR SUBSYSTEM ERR                                             */
/*                                                                          */
/* ABSTRACT : MESSAGE DEFINITIONS FOR RTR SUBSYSTEM XXX INTERNAL MESSAGES   */
/*                                                                          */
/* AUTHOR   : ANDREW C. SCHOFIELD                                           */
/*                                                                          */
/* CREATED  : 31ST JUNE 1988                                                */
/*                                                                          */
/*                                                                          */
/* FILE RT$RTRERRDEF.MSG	CONTAINS RTR MESSAGES EXPORTED              */
/* BY SUB-SYSTEM ERR. THESE MESSAGES ARE INCORPORATED                       */
/* INTO THE FINAL RTRMSG FILE. NOTE THIS FILE SHOULD                        */
/* NOT CONTAIN ANY OTHER DIRECTIVES BUT .BASE AND                           */
/* .SEVERITY. THE .FACILITY AND .END (ETC) DIRECTIVES                       */
/* ARE CONTAINED IN OTHER FILES.                                            */
/*                                                                          */
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* DISPLAYS THE TIME/DATE [A], NODE NAME [B] AND USER NAME [C]              */
/* ASSOCIATED WITH THE SUBSEQUENT ERROR MESSAGE.                            */
/*                                                                          */
#define RTR$_LOGFILENT 758467
/*                                                                          */
/* %CRASH                                                                   */
/*                                                                          */
/* SIGNALED BY A PROCESS WHEN AN RTR INTERNAL ERROR OCCURS.                 */
/* PLEASE SUBMIT AN SPR.                                                    */
/*                                                                          */
#define RTR$_BUGCHECK 758476
/*                                                                          */
/* %CRASH                                                                   */
/*                                                                          */
/* SIGNALED BY A PROCESS WHEN AN RTR INTERNAL ERROR OCCURS.                 */
/* PLEASE SUBMIT AN SPR.                                                    */
/*                                                                          */
#define RTR$_BUGCHECKPC 758484
/* COPYRIGHT (C) 1988 BY                                                    */
/* DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.                   */
/* ALL RIGHTS RESERVED.                                                     */
/*                                                                          */
/* THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED    */
/* ONLY  IN  ACCORDANCE  OF  THE  TERMS  OF  SUCH  LICENSE  AND WITH THE    */
/* INCLUSION OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY  OTHER    */
/* COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY    */
/* OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY    */
/* TRANSFERRED.                                                             */
/*                                                                          */
/* THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE    */
/* AND  SHOULD  NOT  BE  CONSTRUED  AS A COMMITMENT BY DIGITAL EQUIPMENT    */
/* CORPORATION.                                                             */
/*                                                                          */
/* DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS    */
/* SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.                  */
/*                                                                          */
/* FACILITY : RTR SUBSYSTEM ACS                                             */
/*                                                                          */
/* ABSTRACT : MESSAGE DEFINITIONS FOR RTR SUBSYSTEM ACS                     */
/*                                                                          */
/* AUTHOR   : ANDREW SCHOFIELD                                              */
/*                                                                          */
/* CREATED  : THURSDAY, THE 1ST OF SEPTEMBER 1988                           */
/*                                                                          */
/*                                                                          */
/* FILE RT$RTRACSDEF.MSG	CONTAINS RTR MESSAGES EXPORTED              */
/* BY SUB-SYSTEM ACS. THESE MESSAGES ARE INCORPORATED                       */
/* INTO THE FINAL RTRMSG FILE. NOTE THIS FILE SHOULD                        */
/* NOT CONTAIN ANY OTHER DIRECTIVES BUT .BASE AND                           */
/* .SEVERITY. THE .FACILITY AND .END (ETC) DIRECTIVES                       */
/* ARE CONTAINED IN OTHER FILES.                                            */
/*                                                                          */
/*                                                                          */
/* %UTILITY,SYSTEM_SERVICE,R0                                               */
/*                                                                          */
/* INDICATES THAT UTILITIES AND/OR SHARABLE IMAGES BEING                    */
/* USED ARE INTENDED FOR A DIFFERENT VERSION OF RTR TO THAT                 */
/* WHICH IS CURRENTLY RUNNING ON THE SYSTEM.                                */
/*                                                                          */
/* THIS MESSAGE CAN HOWEVER BE IGNORED WHEN IT IS DISPLAYED AFTER           */
/* ISSUING THE FIRST "STOP RTR" COMMAND AFTER HAVING JUST INSTALLED A NEW   */
/* RTR RELEASE.                                                             */
/*                                                                          */
#define RTR$_VERMISMAT 759266
/*                                                                          */
/* %SYSTEM_SERVICE,R0                                                       */
/*                                                                          */
/* INDICATES THAT AN ATTEMPT WAS MADE TO START MORE RTR PROCESSES           */
/* THAN WERE SPECIFIED WITH THE "/PROCESS" QUALIFIER ON THE                 */
/* "START RTR" COMMAND.                                                     */
/*                                                                          */
#define RTR$_TOOMANPRO 759274
/*                                                                          */
/* %SYSTEM_SERVICE,R0                                                       */
/*                                                                          */
/* INDICATES THAT THE RTR ACP HAS UNEXPECTEDLY DIED.                        */
/* PLEASE SUBMIT AN SPR.                                                    */
/*                                                                          */
#define RTR$_ACPNOTVIA 759282
/* COPYRIGHT (C) 1988 BY                                                    */
/* DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.                   */
/* ALL RIGHTS RESERVED.                                                     */
/*                                                                          */
/* THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED    */
/* ONLY  IN  ACCORDANCE  OF  THE  TERMS  OF  SUCH  LICENSE  AND WITH THE    */
/* INCLUSION OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY  OTHER    */
/* COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY    */
/* OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY    */
/* TRANSFERRED.                                                             */
/*                                                                          */
/* THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE    */
/* AND  SHOULD  NOT  BE  CONSTRUED  AS A COMMITMENT BY DIGITAL EQUIPMENT    */
/* CORPORATION.                                                             */
/*                                                                          */
/* DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS    */
/* SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.                  */
/*                                                                          */
/* FACILITY : RTR SUBSYSTEM ASM                                             */
/*                                                                          */
/* ABSTRACT : MESSAGE DEFINITIONS FOR RTR SUBSYSTEM ASM                     */
/*                                                                          */
/* AUTHOR   : TONY CROSBY                                                   */
/*                                                                          */
/* CREATED  : 30-NOV-1989                                                   */
/*                                                                          */
/*                                                                          */
/* FILE RT$RTRASMDEF.MSG	CONTAINS RTR MESSAGES EXPORTED              */
/* BY SUB-SYSTEM ASM. THESE MESSAGES ARE INCORPORATED                       */
/* INTO THE FINAL RTRMSG FILE. NOTE THIS FILE SHOULD                        */
/* NOT CONTAIN ANY OTHER DIRECTIVES BUT .BASE AND                           */
/* .SEVERITY. THE .FACILITY AND .END (ETC) DIRECTIVES                       */
/* ARE CONTAINED IN OTHER FILES.                                            */
/*                                                                          */
/*                                                                          */
/* %SYSTEM_SERVICE, TXSB_STATUS                                             */
/*                                                                          */
/* ALL INFORMATION RETRIEVABLE ON A SERIES OF WILD-CARD $GET_TXI CALLS      */
/* HAS ALREADY BEEN RETURNED, NO MORE INFORMATION IS AVAILABLE.             */
/*                                                                          */
#define RTR$_NOMORETXI 768068
/*                                                                          */
/* %SYSTEM_SERVICE, TXSB_STATUS                                             */
/*                                                                          */
/* ALL ITEM LIST ENTRIES FOR A WILDCARD $GET_TXI/$SET_TXI CALL MUST BELONG  */
/* TO THE SAME ACP DATABASE "object". THIS ERROR CODE IS RETURNED           */
/* BY $GET_TXI AND $SET_TXI IF THIS CONDITION IS VIOLATED.                  */
/*                                                                          */
#define RTR$_NOTSAMOBJ 768076
/*                                                                          */
/* %SYSTEM_SERVICE, TXSB_STATUS                                             */
/*                                                                          */
/* TOO MUCH DATA HAS BEEN REQUESTED FOR RETURN BY A SINGLE CALL             */
/* TO $GET_TXI                                                              */
/*                                                                          */
#define RTR$_GETTOOBIG 768084
/*                                                                          */
/* %SYSTEM_SERVICE, TXSB_STATUS                                             */
/*                                                                          */
/* AN INVALID WILDCARD CONTEXT HAS BEEN SPECIFIED ON A CALL TO $GET_TXI.    */
/*                                                                          */
#define RTR$_INVCONTXT 768092
/* COPYRIGHT (C) 1988 BY                                                    */
/* DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.                   */
/* ALL RIGHTS RESERVED.                                                     */
/*                                                                          */
/* THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED    */
/* ONLY  IN  ACCORDANCE  OF  THE  TERMS  OF  SUCH  LICENSE  AND WITH THE    */
/* INCLUSION OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY  OTHER    */
/* COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY    */
/* OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY    */
/* TRANSFERRED.                                                             */
/*                                                                          */
/* THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE    */
/* AND  SHOULD  NOT  BE  CONSTRUED  AS A COMMITMENT BY DIGITAL EQUIPMENT    */
/* CORPORATION.                                                             */
/*                                                                          */
/* DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS    */
/* SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.                  */
/*                                                                          */
/* FACILITY : RTR SUBSYSTEM WAL                                             */
/*                                                                          */
/* ABSTRACT : MESSAGE DEFINITIONS FOR RTR SUBSYSTEM WAL                     */
/*                                                                          */
/* AUTHOR   : TONY CROSBY                                                   */
/*                                                                          */
/* CREATED  : 30-NOV-1989                                                   */
/*                                                                          */
/*                                                                          */
/* FILE RT$RTRWALDEF.MSG	CONTAINS RTR MESSAGES EXPORTED              */
/* BY SUB-SYSTEM WAL. THESE MESSAGES ARE INCORPORATED                       */
/* INTO THE FINAL RTRMSG FILE. NOTE THIS FILE SHOULD                        */
/* NOT CONTAIN ANY OTHER DIRECTIVES BUT .BASE AND                           */
/* .SEVERITY. THE .FACILITY AND .END (ETC) DIRECTIVES                       */
/* ARE CONTAINED IN OTHER FILES.                                            */
/*                                                                          */
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* ONE OR MORE BROADCAST MESSAGES HAD TO BE DISCARDED BECAUSE OF LOCAL      */
/* MEMORY CACHE CONGESTION. REDUCE THE RATE AT WHICH BROADCASTS ARE         */
/* SENT, OR INCREASE THE EFFICIENCY OF BROADCAST PROCESSING BY THE          */
/* RECIPIENT APPLICATIONS.                                                  */
/*                                                                          */
#define RTR$_BRODISCAC 767268
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* ONE OR MORE BROADCAST MESSAGES HAD TO BE DISCARDED BECAUSE OF AN INTERNODE */
/* COMMUNICATIONS BLOCKAGE. REDUCE BROADCAST RATE OR INCREASE COMMUNICATIONS */
/* LINK CAPACITY.                                                           */
/*                                                                          */
#define RTR$_BRODISBLO 767276
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* ONE OR MORE BROADCAST MESSAGES HAD TO BE DISCARDED BECAUSE NO NETWORK    */
/* LINK TO THE DESTINATION NODE WAS AVAILABLE                               */
/*                                                                          */
#define RTR$_BRODISLIN 767284
/*                                                                          */
/*                                                                          */
/* COPYRIGHT (C) 1988 BY                                                    */
/* DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.                   */
/* ALL RIGHTS RESERVED.                                                     */
/*                                                                          */
/* THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED    */
/* ONLY  IN  ACCORDANCE  OF  THE  TERMS  OF  SUCH  LICENSE  AND WITH THE    */
/* INCLUSION OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY  OTHER    */
/* COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY    */
/* OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY    */
/* TRANSFERRED.                                                             */
/*                                                                          */
/* THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE    */
/* AND  SHOULD  NOT  BE  CONSTRUED  AS A COMMITMENT BY DIGITAL EQUIPMENT    */
/* CORPORATION.                                                             */
/*                                                                          */
/* DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS    */
/* SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.                  */
/*                                                                          */
/*                                                                          */
/* FACILITY : RTR SUBSYSTEM RTL                                             */
/*                                                                          */
/* ABSTRACT : MESSAGE DEFINITIONS FOR RTR SUBSYSTEM RTL                     */
/*                                                                          */
/* AUTHOR   : ANDREW C. SCHOFIELD                                           */
/*                                                                          */
/* CREATED  : SUNDAY, THE 30TH OF OCTOBER 1988                              */
/*                                                                          */
/*                                                                          */
/* FILE RT$RTRRTLDEF.MSG	CONTAINS RTR MESSAGES EXPORTED              */
/* BY SUB-SYSTEM RTL. THESE MESSAGES ARE INCORPORATED                       */
/* INTO THE FINAL RTRMSG FILE. NOTE THIS FILE SHOULD                        */
/* NOT CONTAIN ANY OTHER DIRECTIVES BUT .BASE AND                           */
/* .SEVERITY. THE .FACILITY AND .END (ETC) DIRECTIVES                       */
/* ARE CONTAINED IN OTHER FILES.                                            */
/*                                                                          */
#define RTR$_REQALRDEC 760066
#define RTR$_FACNAMABS 760074
#define RTR$_FACNAMDES 760082
#define RTR$_SENBUFABS 760090
#define RTR$_SENBUFDES 760098
#define RTR$_KEYPARABS 760106
#define RTR$_TOOMANKEY 760114
#define RTR$_KEYPAROMI 760122
#define RTR$_KEYPARDES 760130
#define RTR$_STAVARDES 760138
#define RTR$_SECVARDES 760146
#define RTR$_REQNOTDEC 760154
#define RTR$_TRAALRSTA 760162
#define RTR$_TRANOTSTA 760170
#define RTR$_REPBUFDES 760178
#define RTR$_REASONDES 760186
#define RTR$_LOWALRSPC 760194
#define RTR$_EXPSRVDEC 760202
#define RTR$_SRVALRDEC 760210
#define RTR$_SRVNOTDEC 760218
#define RTR$_ERRACCLOW 760226
#define RTR$_LOWBNDABS 760234
#define RTR$_UPPALRSPC 760242
#define RTR$_UPPBNDABS 760250
#define RTR$_ERRACCUPP 760258
#define RTR$_BNDNOTSPC 760266
#define RTR$_RECBUFABS 760274
#define RTR$_RECBUFDES 760282
#define RTR$_EXPREPREJ 760290
#define RTR$_ACTIONABS 760298
#define RTR$_EXPRECEIV 760306
#define RTR$_INVKEYTYP 760314
#define RTR$_ERRRETRSN 760322
#define RTR$_ERRRETMSG 760330
#define RTR$_ERRRETACT 760338
#define RTR$_ERRACCRSN 760346
#define RTR$_ERRACCTIM 760354
/*	TITLE RT$RTRRSCDEF.MSG     RSC PUBLIC ERROR MESSAGE DEFINITIONS     */
/*       IDENT VERSION X-0.0                                                */
/*                                                                          */
/* COPYRIGHT (C) 1988 BY                                                    */
/* DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.                   */
/* ALL RIGHTS RESERVED.                                                     */
/*                                                                          */
/* THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED    */
/* ONLY  IN  ACCORDANCE  OF  THE  TERMS  OF  SUCH  LICENSE  AND WITH THE    */
/* INCLUSION OF THE ABOVE COPYRIGHT NOTICE. THIS SOFTWARE OR  ANY  OTHER    */
/* COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY    */
/* OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY    */
/* TRANSFERRED.                                                             */
/*                                                                          */
/* THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE    */
/* AND  SHOULD  NOT  BE  CONSTRUED  AS A COMMITMENT BY DIGITAL EQUIPMENT    */
/* CORPORATION.                                                             */
/*                                                                          */
/* DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS    */
/* SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.                  */
/*++                                                                        */
/* FACILITY:                                                                */
/*                                                                          */
/*   RTR REQUESTER SERVER CONFIGURATOR                                      */
/*                                                                          */
/* ABSTRACT:                                                                */
/*                                                                          */
/*   THIS FILE CONTAINS THE DEFINITION OF ALL RSC'S PUBLIC ERROR            */
/*   MESSAGES. THESE "public" ERROR MESSAGES ARE RETURNED TO THE            */
/*   USER.                                                                  */
/*                                                                          */
/* AUTHORS:                                                                 */
/*                                                                          */
/*   ANDREW SCHOFIELD                                                       */
/*                                                                          */
/* CREATION DATE: 1-DEC-1988                                                */
/*                                                                          */
/* MODIFICATION HISTORY:                                                    */
/*                                                                          */
/* 	CHARLES SMITH	  23-JUL-1991 21:18:20                              */
/*	ADDED RTR$_KEYOUTREC                                                */
/*                                                                          */
/* 	DIPANKAR DESHMUKH 22-JAN-1992                                       */
/*	ADDED RTR$_NOSRVAVL                                                 */
/*--                                                                        */
/*                                                                          */
/* %SYSTEM_SERVICE,R0                                                       */
/*                                                                          */
/* SERVER DECLARE SUCCESSFUL, BUT IN STANDBY MODE.                          */
/* SUBSEQUENT $DEQ_TX'S TO THIS CHANNEL WILL WAIT                           */
/* UNTIL THE PRIMARY NODE FAILS.                                            */
/*                                                                          */
#define RTR$_SRVDCLSBY 763265
/*                                                                          */
/* %SYSTEM_SERVICE,R0                                                       */
/*                                                                          */
/* FUNCTION IS NOT SUPPORTED BY THIS RELEASE OF RTR                         */
/*                                                                          */
#define RTR$_FUNCNOTSUP 763274
/*                                                                          */
/* %SYSTEM_SERVICE,R0                                                       */
/*                                                                          */
/* THE SPECIFIED FACILITY HAS NOT YET BEEN ADDED WITH                       */
/* THE "RTR ADD FACILITY" COMMAND.                                          */
/*                                                                          */
#define RTR$_UNKNOFAC 763282
/*                                                                          */
/* %SYSTEM_SERVICE,TXSB_RSNSTS                                              */
/*                                                                          */
/* NO SERVER HAD DECLARED ITSELF TO HANDLE THE KEY VALUE                    */
/* SPECIFIED IN A MESSAGE SENT WITH A $ENQ_TX CALL                          */
/*                                                                          */
#define RTR$_NODSTFND 763290            /*                                  */
/* %SYSTEM_SERVICE,TXSB_STATUS                                              */
/*                                                                          */
/* THE 'ACCESS' STRING SPECIFIED DOES NOT MATCH THAT OF                     */
/* EXISTING SERVER(S). CAN BE RETURNED WHEN DECLARING                       */
/* SERVERS OR REQUESTERS.                                                   */
/*                                                                          */
#define RTR$_NOACCESS 763298
/*                                                                          */
/* %SYSTEM_SERVICE,TXSB_STATUS                                              */
/*                                                                          */
/* THE NUMBER OF KEY SEGMENTS IN THE 'DATPAR' ARGUMENT DOES                 */
/* NOT MATCH THAT OF EXISTING SERVER(S). CAN BE RETURNED                    */
/* WHEN DECLARING SERVERS OR REQUESTERS.                                    */
/*                                                                          */
#define RTR$_NRSEGSDIF 763306
/*                                                                          */
/* %SYSTEM_SERVICE,TXSB_STATUS                                              */
/*                                                                          */
/* THE KEY DATA TYPE IN THE 'DATPAR' ARGUMENT DOES NOT MATCH                */
/* THAT OF EXISTING SERVER(S). CAN BE RETURNED WHEN                         */
/* DECLARING SERVERS OR REQUESTERS.                                         */
/*                                                                          */
#define RTR$_DATTYPDIF 763314           /*                                  */
/* %SYSTEM_SERVICE,TXSB_STATUS                                              */
/*                                                                          */
/* THE KEY OFFSET IN THE 'DATPAR' ARGUMENT DOES NOT MATCH                   */
/* THAT OF EXISTING SERVER(S). CAN BE RETURNED WHEN                         */
/* DECLARING SERVERS OR REQUESTERS.                                         */
/*                                                                          */
#define RTR$_KEYOFFDIF 763322           /*                                  */
/* %SYSTEM_SERVICE,TXSB_STATUS                                              */
/*                                                                          */
/* THE KEY LENGTH IN THE 'DATPAR' ARGUMENT DOES NOT MATCH                   */
/* THAT OF EXISTING SERVER(S). CAN BE RETURNED WHEN                         */
/* DECLARING SERVERS OR REQUESTERS.                                         */
/*                                                                          */
#define RTR$_KEYLENDIF 763330           /*                                  */
/* %SYSTEM_SERVICE,TXSB_STATUS                                              */
/*                                                                          */
/* THE KEY RANGE SPECIFIED IN THE 'DATPAR' ARGUMENT OVERLAPS                */
/* THAT OF EXISTING SERVER(S). RETURNED WHEN                                */
/* DECLARING SERVERS.                                                       */
/*                                                                          */
#define RTR$_KEYRANOVE 763338
/*                                                                          */
/* %SYSTEM_SERVICE,TXSB_STATUS                                              */
/*                                                                          */
/* THE HIGH BOUND IN THE 'DATPAR' ARGUMENT IS LESS THEN THE                 */
/* LOWER BOUND.RETURNED WHEN DECLARING SERVERS.                             */
/*                                                                          */
#define RTR$_UPPLESLOW 763346
/*                                                                          */
/* %SYSTEM_SERVICE,TXSB_STATUS                                              */
/*                                                                          */
/* THE LENGTH OF THE ROUTING KEY IS LONGER THAN                             */
/* THE LENGTH OF A MESSAGE SENT WITH A $ENQ_TX CALL                         */
/*                                                                          */
#define RTR$_INVTXBUFLEN 763354
/*                                                                          */
/* %SYSTEM_SERVICE,R0                                                       */
/*                                                                          */
/* AN ATTEMPT WAS MADE TO DECLARE A REQUESTER ON A NODE                     */
/* THAT WAS NOT DEFINED AS BEING A FRONTEND WHEN THE                        */
/* "ADD FACILITY" COMMAND WAS ISSUED.                                       */
/*                                                                          */
#define RTR$_NODNOTFRO 763362
/*                                                                          */
/* %SYSTEM_SERVICE,R0                                                       */
/*                                                                          */
/* AN ATTEMPT WAS MADE TO DECLARE A SERVER ON A NODE                        */
/* THAT WAS NOT DEFINED AS BEING A BACKEND WHEN THE                         */
/* "ADD FACILITY" COMMAND WAS ISSUED.                                       */
/*                                                                          */
#define RTR$_NODNOTBAC 763370
/*                                                                          */
/* %SYSTEM_SERVICE,TXSB_STATUS                                              */
/*                                                                          */
/* SHADOW SERVERS HAVE ALREADY BEEN DECLARED FOR THIS KEY RANGE ON          */
/* TWO OTHER NODES.                                                         */
/*                                                                          */
#define RTR$_ALRSHADOW 763378
/*                                                                          */
/* %SYSTEM_SERVICE,TXSB_STATUS                                              */
/*                                                                          */
/* A SERVER HAS ALREADY BEEN DECLARED FOR THIS KEY RANGE ON THIS NODE       */
/* WHICH DID NOT SET 'CONCURRENT' FLAG ON ITS DECLARE.                      */
/*                                                                          */
#define RTR$_EXINOTCON 763386
/*                                                                          */
/* %SYSTEM_SERVICE,TXSB_STATUS                                              */
/*                                                                          */
/* A SERVER HAS ALREADY BEEN DECLARED FOR THIS KEY RANGE ON THIS NODE       */
/* AND THIS DECLARE DID NOT SET THE 'CONCURRENT' FLAG.                      */
/*                                                                          */
#define RTR$_CONNOTSET 763394
/*                                                                          */
/* %SYSTEM_SERVICE,TXSB_STATUS                                              */
/*                                                                          */
/* EITHER:                                                                  */
/*                                                                          */
/* (A) AN ATTEMPT WAS MADE TO START A STANDBY SERVER WHEN EXISTING SERVERS  */
/* HAD ALREADY BEEN DECLARED FOR THIS KEY RANGE WHICH HAD NOT SET THE       */
/* "STANDBY" FLAG, OR:                                                      */
/*                                                                          */
/* (B) AN ATTEMPT WAS MADE TO DECLARE A SERVER WITHOUT SETTING THE          */
/* "STANDBY" FLAG BUT STANDBY SERVERS WERE ALREADY RUNNING FOR THIS KEY RANGE. */
/*                                                                          */
#define RTR$_ALLSRVSTA 763402
/*                                                                          */
/* %SYSTEM_SERVICE,TXSB_STATUS                                              */
/*                                                                          */
/* THIS KEY RANGE IS ALREADY BEING HANDLED BY SERVER(S) ON ANOTHER          */
/* NODE AND NEITHER THE "SHADOW" NOR "STANDBY" FLAGS WERE SET.              */
/*                                                                          */
#define RTR$_NOTSAMNOD 763410
/*                                                                          */
/* %SYSTEM_SERVICE,TXSB_STATUS                                              */
/*                                                                          */
/* AN ATTEMPT WAS MADE TO CREATE A STANDBY SET WITH MORE                    */
/* THAN TWO PARTICIPATING NODES OR TO CREATE A SHADOW SET WITH MORE         */
/* THAN TWO PARTICIPATING NODES.                                            */
/*                                                                          */
#define RTR$_TWONODALR 763418
/*                                                                          */
/* %SYSTEM_SERVICE,TXSB_STATUS                                              */
/*                                                                          */
/* ALL STANDBY SERVERS FOR A GIVEN KEY RANGE MUST BE ON NODES               */
/* WHICH BELONG TO THE SAME VAX-CLUSTER.                                    */
/*                                                                          */
#define RTR$_NOTSAMCLU 763426
/*                                                                          */
/* %SYSTEM_SERVICE,R0,OBSOLETE                                              */
/*                                                                          */
#define RTR$_INVDPARLEN 763434
/*                                                                          */
/* %SYSTEM_SERVICE,R0,OBSOLETE                                              */
/*                                                                          */
#define RTR$_INVKEYLEN 763442
/*                                                                          */
/* %SYSTEM_SERVICE,R0,OBSOLETE                                              */
/*                                                                          */
#define RTR$_INVKEYFLG 763450
/*                                                                          */
/* %SYSTEM_SERVICE,R0,OBSOLETE                                              */
/*                                                                          */
#define RTR$_INVBNDLEN 763458
/*                                                                          */
/* %SYSTEM_SERVICE,R0                                                       */
/*                                                                          */
/* THE STRUCTURE PASSED TO $DCL_TX_PRC VIA THE 'DATPAR' ARGUMENT            */
/* COULD NOT BE READ.                                                       */
/*                                                                          */
#define RTR$_NORDATPAR 763466
/*                                                                          */
/* %SYSTEM_SERVICE,R0                                                       */
/*                                                                          */
/* THE KEY RANGE LOW BOUND SPECIFIED IN THE RTR$A_DATPAR_LO_BND FIELD OF THE  */
/* DATPAR ARGUMENT COULD NOT BE READ.                                       */
/*                                                                          */
#define RTR$_NORLOWBND 763474           /*                                  */
/* %SYSTEM_SERVICE,R0                                                       */
/*                                                                          */
/* THE KEY RANGE HIGH BOUND SPECIFIED IN THE RTR$A_DATPAR_HI_BND FIELD OF THE  */
/* DATPAR ARGUMENT COULD NOT BE READ.                                       */
/*                                                                          */
#define RTR$_NORUPPBND 763482           /*                                  */
/* %SYSTEM_SERVICE                                                          */
/*                                                                          */
/* A PACKED DECIMAL STRING HAD AN INVALID LENGTH.                           */
/*                                                                          */
#define RTR$_INVPCKLEN 763490
/*                                                                          */
/* %SYSTEM_SERVICE                                                          */
/*                                                                          */
/* A PACKED DECIMAL STRING CONTAINED AN INVALID CHARACTER.                  */
/*                                                                          */
#define RTR$_INVPCKCHAR 763498
/*                                                                          */
/* %SYSTEM_SERVICE                                                          */
/*                                                                          */
/* A PACKED DECIMAL STRING CONTAINED MINUS ZERO.                            */
/*                                                                          */
#define RTR$_NEGZEROPCK 763506
/*                                                                          */
/* %SYSTEM_SERVICE,R0                                                       */
/*                                                                          */
/* A "CALL_OUT" FLAG WAS SET WHEN DECLARING A SERVER BUT THE                */
/* FACILITY WAS NOT CONFIGURED FOR CALL-OUT SERVERS.                        */
/* USE THE "/CALL_OUT" QUALIFIER ON THE "ADD FACILITY" COMMAND              */
/* IF CALL-OUT SERVERS ARE TO BE DECLARED.                                  */
/*                                                                          */
#define RTR$_NOCALLOUT 763514
/*                                                                          */
/* %SYSTEM_SERVICE,TXSB_RSNSTS                                              */
/*                                                                          */
/* THE "ADD FACILITY" COMMAND SPECIFIED THAT A NODE MUST                    */
/* HAVE "call-out" SERVERS BUT NONE WERE FOUND.                             */
/*                                                                          */
#define RTR$_REQCALLUN 763522
/*                                                                          */
/* %SYSTEM_SERVICE,R0                                                       */
/*                                                                          */
/* THE "DATPAR" ARGUMENT OF $DCL_TX_PRC POINTED TO A LONGWORD               */
/* CONTAINING ZERO.                                                         */
/*                                                                          */
#define RTR$_ZEROELEM 763530
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* THE PROCESS WITH ID = [A] USED AN OBSOLETE FORM OF                       */
/* THE 'DATPAR' ARGUMENT WHEN IT DECLARED A CHANNEL.                        */
/* THE CHANNEL DECLARATION MAY SUCCEED BUT THE OBSOLETE                     */
/* 'DATPAR' FORMAT MAY NOT BE SUPPORTED IN FUTURE VERSIONS                  */
/* OF RTR.                                                                  */
/*                                                                          */
#define RTR$_OLDDATPAR 763536
/*                                                                          */
/* %SYSTEM_SERVICE,TXSB_STATUS                                              */
/*                                                                          */
/* EITHER:                                                                  */
/*                                                                          */
/* (A) AN ATTEMPT WAS MADE TO START A SHADOW SERVER WHEN EXISTING SERVERS   */
/* HAD ALREADY BEEN DECLARED FOR THIS KEY RANGE WHICH HAD NOT SET THE       */
/* "SHADOW" FLAG, OR:                                                       */
/*                                                                          */
/* (B) AN ATTEMPT WAS MADE TO DECLARE A SERVER WITHOUT SETTING THE          */
/* "SHADOW" FLAG BUT SHADOW SERVERS WERE ALREADY RUNNING FOR THIS KEY RANGE. */
/*                                                                          */
#define RTR$_ALLSRVSHA 763546
/*                                                                          */
/* %SYSTEM_SERVICE,TXSB_STATUS                                              */
/*                                                                          */
/* AN ATTEMPT WAS MADE TO DECLARE A THIRD SHADOW SITE.                      */
/*                                                                          */
#define RTR$_TOOMANSHA 763554
/*                                                                          */
/* %SYSTEM_SERVICE,TXSB_STATUS                                              */
/*                                                                          */
/* A KEY SEGMENT WAS DEFINED TO START BEFORE THE BEGINNING OF THE           */
/* MESSAGE BUFFER THAT WAS INTENDED TO CONTAIN IT.                          */
/*                                                                          */
#define RTR$_KEYOUTREC 763562
/*                                                                          */
/* A SERVER MIGHT BE WAITING TO RECOVER TRANSACTION INFORMATION FROM        */
/* JOURNAL ACCESSIBLE THROUGH NODE [A], BUT CANNOT BE ACCESSED SINCE        */
/* IT WASN'T CONFIGURED AS A BE IN FACILITY [B]. CALLS FOR OPERATOR         */
/* INTERVENTION EITHER THROUGH RECONFIGURING THE FACILITY OR MANUALLY       */
/* OVERRIDING THE WAIT.                                                     */
/*                                                                          */
#define RTR$_RNODNOTCNF 763570
/*                                                                          */
/* THE DATA PARTITION SERVER IS REFUSING REAL TRANSACTIONS BECAUSE          */
/* TRANSACTION RECOVERY FROM THE JOURNAL IS CURRENTLY IN PROGRESS.          */
/*                                                                          */
#define RTR$_KRRVYINPRG 763578
/*                                                                          */
/* STANDBY FAILOVER RECOVERY IS IN PROGRESS                                 */
/*                                                                          */
#define RTR$_KRTAKEOVR 763586
/*                                                                          */
/* SECONDARY SERVER IS CATCHING UP WITH PRIMARY                             */
/*                                                                          */
#define RTR$_KRCATCHUP 763594
/*                                                                          */
/* REQUESTER DECLARE COULD NOT BE COMPLETED BECAUSE THERE IS EITHER NO      */
/* ROUTER AVAILABLE, OR NO SERVER HAS YET BEEN DECLARED                     */
/*                                                                          */
#define RTR$_NOSRVAVL 763602
/*                                                                          */
/* ATTEMPT TO FREE A KRID ALREADY FREED EARLIER, OR AN INVALID KRID         */
/*                                                                          */
#define RTR$_ILLKRIDVAL 763610
/*                                                                          */
/*                                                                          */
/* RTR WAS STARTED WITH NOT ENOUGH PARTITIONS, OR THE DEFAULT NUMBER OF     */
/* PARTITIONS ISN'T ENOUGH TO RUN THE APPLICATION. PLEASE RESTART RTR       */
/* WITH MORE PARTITIONS                                                     */
/*                                                                          */
#define RTR$_NOMOREPRT 763620
/*                                                                          */
/* THIS STATUS CAN BE RETURNED AS THE REASON STATUS WHEN A REQUESTER CHANNEL */
/* IS BEING SHUT DOWN BECAUSE THE FACILITY HAS BEEN DELETED OR ITS          */
/* CONFIGURATION HAS BEEN MODIFIED TO EXCLUDE THE APPROPRIATE ROLE FROM THE */
/* SET OF ROLES FOR THIS NODE                                               */
/*                                                                          */
#define RTR$_FACROLEDEL 763627
/* COPYRIGHT (C) 1988 BY                                                    */
/* DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.                   */
/* ALL RIGHTS RESERVED.                                                     */
/*                                                                          */
/* THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED    */
/* ONLY  IN  ACCORDANCE  OF  THE  TERMS  OF  SUCH  LICENSE  AND WITH THE    */
/* INCLUSION OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY  OTHER    */
/* COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY    */
/* OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY    */
/* TRANSFERRED.                                                             */
/*                                                                          */
/* THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE    */
/* AND  SHOULD  NOT  BE  CONSTRUED  AS A COMMITMENT BY DIGITAL EQUIPMENT    */
/* CORPORATION.                                                             */
/*                                                                          */
/* DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS    */
/* SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.                  */
/*                                                                          */
/* FACILITY : RTR SUBSYSTEM NCF                                             */
/*                                                                          */
/* ABSTRACT : MESSAGE DEFINITIONS FOR RTR SUBSYSTEM NCF                     */
/*                                                                          */
/* AUTHOR   : DIPANKAR DESHMUKH                                             */
/*                                                                          */
/* CREATED  : 5-DEC-1988                                                    */
/*                                                                          */
/*                                                                          */
/* FILE RT$RTRNCFDEF.MSG	CONTAINS RTR MESSAGES EXPORTED              */
/* BY SUB-SYSTEM NCF. THESE MESSAGES ARE INCORPORATED                       */
/* INTO THE FINAL RTRMSG FILE. NOTE THIS FILE SHOULD                        */
/* NOT CONTAIN ANY OTHER DIRECTIVES BUT .BASE AND                           */
/* .SEVERITY. THE .FACILITY AND .END (ETC) DIRECTIVES                       */
/* ARE CONTAINED IN OTHER FILES.                                            */
/*                                                                          */
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* THIS STATUS RESULTS WHEN SOMEONE STOPS DECNET ON A NODE RUNNING RTR      */
/* IF THE APPLICATION DOES NOT NEED DECNET, THEN RTR SHOULD                 */
/* BE STARTED UP BEFORE DECNET                                              */
/*                                                                          */
#define RTR$_NETSHUT 764868
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* INTERNAL ERROR. SEND SPR                                                 */
/*                                                                          */
#define RTR$_INTERFERENCE 764876
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* ATTEMPT TO START UP AN INCOMPATIBLE VERSION OF RTR ON THE SAME NETWORK   */
/* WITH SHARED FACILITIES.                                                  */
/*                                                                          */
#define RTR$_INCOMPAT 764884
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* THIS IS A GENERAL STATUS USED TO INDICATE AN INADEQUACY IN THE STATIC    */
/* RESERVATIONS FOR THE TABLES. SEND SPR, WITH RTRACP DUMP.                 */
/*                                                                          */
#define RTR$_OVERFLOW 764890
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* A CONNECTION FAILED BECAUSE RTR HAD NOT BEEN STARTED OR HAD DIED         */
/* ON THE REMOTE NODE [A].                                                  */
/*                                                                          */
#define RTR$_OBJUNKNOWN 764898
/*                                                                          */
/* %LOG                                                                     */
/* THIS COULD BE A REASON FOR REJECTING A CONNECT REQUEST FROM A REMOTE ACP */
/*                                                                          */
#define RTR$_NOTRECOGNISED 764906
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* THIS MEANS THAT NONE OF THE FACILITIES DEFINED ON THE LOCAL NODE [A] DEFINED */
/* A VALID ROLE FOR THE REMOTE NODE TO PERMIT A CONNECTION.                 */
/*                                                                          */
#define RTR$_NOTCONFIGURED 764914
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* THIS CAN BE A REASON FOR REJECTING A CONNECT REQUEST.                    */
/* SUBMIT AN SPR.                                                           */
/*                                                                          */
#define RTR$_ALRDCNCTD 764922
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* THIS CAN HAPPEN IF BOTH ACPS SIMULTANEOUSLY TRY TO CONNECT TO EACH OTHER */
/* SUBMIT AN SPR.                                                           */
/*                                                                          */
#define RTR$_ALRINPRGS 764930
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* INTERNAL ERROR IN MESSAGES BETWEEN RTRACPS.                              */
/* SUBMIT AN SPR.                                                           */
/*                                                                          */
#define RTR$_PROTOCOL 764938
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* NONE OF THE ROUTERS SPECIFIED FOR FACILITY [A] ARE CURRENTLY CONNECTABLE. */
/* THE SEARCH WILL CONTINUE AFTER A SHORT INTERVAL.                         */
/*                                                                          */
#define RTR$_NOCURRTR 764946
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* THE ROUTER HANDLING FACILITY [A] FOR THIS FRONTEND NODE HAS DIED, OR     */
/* [A] HAS BEEN DELETED ON THE ROUTER. NO USER INTERVENTION IS              */
/* EXPECTED, AN ATTEMPT IS BEING MADE TO RECONNECT TO AN ALTERNATE ROUTER,  */
/* IF ONE IS AVAILABLE.                                                     */
/*                                                                          */
#define RTR$_CURRTRLOSS 764954
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* A CONNECTION COULD FAIL BETWEEN A ROUTER AND A FRONTEND OR A BACKEND     */
/* IF THE FACILITY IS NOT YET DEFINED ON THE REMOTE NODE, TO NEGOTIATE      */
/* THE STATUS OF THE FACILITY.                                              */
/*                                                                          */
#define RTR$_FACNOTDEC 764962
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* A NEGOTIATION WITH REMOTE NODE [A] ABOUT FACILITY [B] HAS FAILED FOR     */
/* THE REASON REPORTED IN THE FOLLOWING LINE. THIS MAY BE A REASON          */
/* FOR SYSTEM MANAGER INTERVENTION.                                         */
/*                                                                          */
#define RTR$_RSPFAC 764968
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* A NEGOTIATION WITH REMOTE NODE [A] ABOUT FACILITY [B] HAS FAILED FOR     */
/* THE REASON REPORTED IN THE FOLLOWING LINE. THIS MAY BE A REASON          */
/* FOR SYSTEM MANAGER INTERVENTION.                                         */
/*                                                                          */
#define RTR$_RSPNODE 764976
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* RTRACP ON NODE [A] MADE A CONNECT REQUEST, WHICH HAD TO BE REJECTED      */
/*                                                                          */
#define RTR$_CNCTREJFR 764984
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* RTRACP ON NODE [A] REJECTED A CONNECT REQUEST FROM THIS NODE.            */
/*                                                                          */
#define RTR$_CNCTREJBY 764992
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* NO FACILITY DEFINED ON THE NODE DESCRIBES THE CONNECTION REQUESTING NODE */
/*                                                                          */
#define RTR$_NODENOTCNFG 765000
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* THE FACILITY EXISTS, BUT THE DEFINITION OF THE ROLE FOR THE REMOTE NODE  */
/* IS NOT THE SAME AS THE ONE IN THE LOCAL NODE. THE SYSTEM MANAGER HAS     */
/* PROBABLY INCORRECTLY DEFINED THE FACILITIES ON THE TWO NODES CONCERNED.  */
/*                                                                          */
#define RTR$_ROLESMISMATCH 765008
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* THE ROUTER ROLE HAS LOST QUORUM FOR FACILITY [A]                         */
/*                                                                          */
#define RTR$_TRNOQUO 765016						
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* THE BACKEND ROLE HAS LOST QUORUM FOR FACILITY [A]                        */
/*                                                                          */
#define RTR$_BENOQUO 765024
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* THE ROUTER HAS NO CREDIT LEFT TO ACCEPT ANY MORE FRONTENDS RIGHT NOW.    */
/* OTHER ROUTERS CAN BE TRIED.                                              */
/*                                                                          */
#define RTR$_NOFECREDIT 765032
/* %LOG                                                                     */
/*                                                                          */
/* NODE [A] CANNOT BE REACHED PRESENTLY. THIS GENERALLY IMPLIES TRYING      */
/* TO REESTABLISH A CONNECTION.                                             */
/*                                                                          */
/*                                                                          */
#define RTR$_PATHLOST 765043
/* %LOG                                                                     */
/*                                                                          */
/* DECNET CONNECTION WITH NODE [A] LOST                                     */
/*                                                                          */
#define RTR$_CNCTLOST 765051
/*                                                                          */
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* FACILITY [A] INITIALIZED ON NODE [B]                                     */
/*                                                                          */
#define RTR$_FACSTART 765059
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* THIS NODE IS NOW A CURRENT ROUTER FOR FRONTEND [B], FACILITY [A]         */
/*                                                                          */
#define RTR$_FACSTARTFE 765067
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* A CONNECTION HAS BEEN ESTABLISHED WITH BACKEND NODE [B] ON FACILITY [A]  */
/*                                                                          */
#define RTR$_FACSTARTBE 765075
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* A CONNECTION HAS BEEN ESTABLISHED WITH ROUTER NODE [B] ON FACILITY [A]   */
/*                                                                          */
#define RTR$_FACSTARTTR 765083
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* THIS NODE IS NO LONGER A CURRENT ROUTER ON FACILITY [A],                 */
/* FOR FRONTEND NODE [B]                                                    */
/*                                                                          */
#define RTR$_FACLOSTFE 765091
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* A CONNECTION HAS BEEN LOST WITH BACKEND NODE [B] ON FACILITY [A]         */
/*                                                                          */
#define RTR$_FACLOSTBE 765099
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* A CONNECTION HAS BEEN LOST WITH ROUTER NODE [B] ON FACILITY [A]          */
/*                                                                          */
#define RTR$_FACLOSTTR 765107
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
#define RTR$_FACSTOP 765115
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
#define RTR$_FACSTOPPED 765123
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* THE ROUTER ROLE IS NOW A MEMBER OF THE ROUTER QUORUM SET OF FACILITY [A]  */
/*                                                                          */
#define RTR$_TRINQUO 765131
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* THE BACKEND ROLE IS NOW A MEMBER OF THE BACKEND QUORUM SET OF FACILITY [A]  */
/*                                                                          */
#define RTR$_BEINQUO 765139
/*                                                                          */
/*% LOG                                                                     */
/*                                                                          */
/* A NEW CURRENT ROUTER [A] HAS BEEN FOUND FOR FACILITY [B]                 */
/*                                                                          */
#define RTR$_CURRTR 765145
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* A CONNECTION REQUEST FROM RTRACP RUNNING ON NODE [A] HAS BEEN ACCEPTED   */
/*                                                                          */
#define RTR$_CNCTACCFR 765153
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* A CONNECTION REQUEST HAS BEEN CONFIRMED BY RTRACP RUNNING ON NODE [A]    */
/*                                                                          */
#define RTR$_CNCTCFRM 765161
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* THE REMOTE NODE [A] HAS BEEN DIAGNOSED TO CAUSE NETWORK CONGESTION       */
/* RTR WILL ISOLATE THE NODE FROM THE REST OF THE NETWORK                   */
/*                                                                          */
#define RTR$_NODISOLAT 765168
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* A CONNECTION COULD FAIL BETWEEN A ROUTER AND A FRONTEND OR A BACKEND     */
/* IF THE LINK IS IN THE "closed" STATE. THIS COULD HAPPEN IF THE LINK      */
/* HAS BEEN SUSPECTED OF CAUSING CONGESTION TO THE REST OF THE NETWORK.     */
/* THIS STATE CAN ALSO BE RESET BY SYSTEM MANAGER INTERVENTION.             */
/*                                                                          */
#define RTR$_LINKSHUT 765178
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* THE CONFIGURATION OF FACILITY [A] HAS BEEN EXTENDED TO INCLUDE NODE [B]  */
/* AS A FRONTEND                                                            */
/*                                                                          */
#define RTR$_FACEXTNFE 765187
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* THE CONFIGURATION OF FACILITY [A] HAS BEEN EXTENDED TO INCLUDE NODE [B]  */
/* AS A ROUTER                                                              */
/*                                                                          */
#define RTR$_FACEXTNTR 765195
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* THE CONFIGURATION OF FACILITY [A] HAS BEEN EXTENDED TO INCLUDE NODE [B]  */
/* AS A FRONTEND                                                            */
#define RTR$_FACEXTNBE 765203
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* THE CONFIGURATION OF FACILITY [A] HAS BEEN MODIFIED TO EXCLUDE NODE [B]  */
/* AS A FRONTEND                                                            */
/*                                                                          */
#define RTR$_FACTRMFE 765211
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* THE CONFIGURATION OF FACILITY [A] HAS BEEN MODIFIED TO EXCLUDE NODE [B]  */
/* AS A ROUTER                                                              */
/*                                                                          */
#define RTR$_FACTRMTR 765219
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* THE CONFIGURATION OF FACILITY [A] HAS BEEN MODIFIED TO EXCLUDE NODE [B]  */
/* AS A BACKEND                                                             */
/*                                                                          */
#define RTR$_FACTRMBE 765227
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* A SEQUENCING ERROR OR CONTENT CORRUPTION ERROR HAS BEEN DETECTED ON      */
/* THE NETWORK LINK TO NODE [A]                                             */
/*                                                                          */
#define RTR$_NETERROR 765234
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* THE ROUTER NODE HAS REJECTED THIS FRONTEND'S ATTEMPT AT ESTABLISHING     */
/* A VIRTUAL CONNECTION, BECAUSE IT HAS NOT YET REACHED QUORUM              */
/*                                                                          */
/* #define RTR$_NOQUORUM 765242						    */
/* COPYRIGHT (C) 1988 BY                                                    */
/* DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.                   */
/* ALL RIGHTS RESERVED.                                                     */
/*                                                                          */
/* THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED    */
/* ONLY  IN  ACCORDANCE  OF  THE  TERMS  OF  SUCH  LICENSE  AND WITH THE    */
/* INCLUSION OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY  OTHER    */
/* COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY    */
/* OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY    */
/* TRANSFERRED.                                                             */
/*                                                                          */
/* THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE    */
/* AND  SHOULD  NOT  BE  CONSTRUED  AS A COMMITMENT BY DIGITAL EQUIPMENT    */
/* CORPORATION.                                                             */
/*                                                                          */
/* DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS    */
/* SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.                  */
/*                                                                          */
/* FACILITY : RTR SUBSYSTEM JNL                                             */
/*                                                                          */
/* ABSTRACT : MESSAGE DEFINITIONS FOR RTR SUBSYSTEM JNL                     */
/*                                                                          */
/* AUTHOR   : CHARLES SMITH, BASED UPON THE ORIGINAL BY TONY CROSBY         */
/*                                                                          */
/* CREATED  : 23-AUG-1991 17:45:01                                          */
/* MODIFIED:	CHARLES SMITH 8-NOV-1991 13:25:33                           */
/*		- LOSE FORMATTING (IT AFFECTS SMM.SDML OUTPUT...)           */
/*		- RESTORE ORIGINAL MESSAGE ORDERING (VERSION                */
/*		  COMPATIBILITY)                                            */
/* MODIFIED:	CHARLES SMITH 25-MAY-1993 18:44:50                          */
/*		- CHANGE TEXT ASSOCIATED WITH FULL JOURNALS.                */
/*		- DFS ERROR MESSAGE                                         */
/*                                                                          */
/* FILE RT$RTRJNLDEF.MSG	CONTAINS RTR MESSAGES EXPORTED              */
/* BY SUB-SYSTEM JNL. THESE MESSAGES ARE INCORPORATED                       */
/* INTO THE FINAL RTRMSG FILE. NOTE THIS FILE SHOULD                        */
/* NOT CONTAIN ANY OTHER DIRECTIVES BUT .BASE AND                           */
/* .SEVERITY. THE .FACILITY AND .END (ETC) DIRECTIVES                       */
/* ARE CONTAINED IN OTHER FILES.                                            */
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* ONE OF PREVIOUSLY INITIALIZED RTR JOURNAL FILES FOR A BACKEND            */
/* COULD NOT BE FOUND. THIS STATUS MAY BE RETURNED BY THE ADD FACILITY      */
/* AND SHOW JOURNAL COMMANDS.                                               */
/*                                                                          */
/* PROBABLE CAUSES ARE:                                                     */
/*                                                                          */
/* (1) ONE OF THE DISKS BEING USED FOR JOURNALLING IS UNAVAILABLE, OR       */
/*                                                                          */
/* (2) A USER HAS INADVERTENTLY DELETED AN RTR JOURNAL FILE.                */
/*                                                                          */
/* CORRECTIVE ACTION, EITHER:                                               */
/*                                                                          */
/* (A) BRING THE MISSING DISK BACK ON LINE, OR                              */
/*                                                                          */
/* (B) REISSUE THE RTR CREATE JOURNAL /SUPERSEDE COMMAND TO CREATE A NEW JOURNAL */
/*     (IN THIS CASE ANY RECOVERY INFORMATION IN THE OLD JOURNAL IS LOST).  */
/*                                                                          */
/*                                                                          */
#define RTR$_JOUFILMIS 766468
/* %UTILITY                                                                 */
/*                                                                          */
/* A DUPLICATE RTR JOURNAL FILE HAS BEEN FOUND. THIS STATUS MAY BE RETURNED */
/* BY THE ADD FACILITY AND SHOW JOURNAL COMMANDS.                           */
/*                                                                          */
/* PROBABLE CAUSE:                                                          */
/*                                                                          */
/* SYSTEM MANAGEMENT ERROR. A USER HAS INADVERTENTLY CREATED                */
/* TWO COPIES OF A JOURNAL FILE (PROBABLY WITH DCL BACKUP OR COPY).         */
/*                                                                          */
/* CORRECTIVE ACTION, EITHER:                                               */
/*                                                                          */
/* (A) DELETE THE SPURIOUS JOURNAL FILE, OR                                 */
/*                                                                          */
/* (B) REISSUE THE CREATE JOURNAL /SUPERSEDE COMMAND                        */
/*     (IN THIS CASE ANY RECOVERY INFORMATION IN THE OLD JOURNAL IS LOST).  */
/*                                                                          */
#define RTR$_DUPJOUFIL 766476
/* %UTILITY                                                                 */
/*                                                                          */
/* A SPURIOUS RTR JOURNAL FILE HAS BEEN FOUND WHICH DOES NOT CORRESPOND     */
/* TO THE OTHER JOURNAL FILES ON THE SYSTEM. THIS STATUS MAY BE RETURNED    */
/* BY THE ADD FACILITY AND SHOW JOURNAL COMMANDS.                           */
/*                                                                          */
/* PROBABLE CAUSE:                                                          */
/*                                                                          */
/* SYSTEM MANAGEMENT ERROR. A USER HAS INADVERTENTLY CREATED                */
/* A SPURIOUS JOURNAL FILE (PROBABLY WITH DCL BACKUP OR COPY)               */
/*                                                                          */
/* CORRECTIVE ACTION, EITHER:                                               */
/*                                                                          */
/* (A) DELETE THE SPURIOUS JOURNAL FILE, OR                                 */
/*                                                                          */
/* (B) REISSUE THE CREATE JOURNAL /SUPERSEDE COMMAND                        */
/*     (IN THIS CASE ANY RECOVERY INFORMATION IN THE OLD JOURNAL IS LOST).  */
/*                                                                          */
#define RTR$_SPUJOUFIL 766484
/* %UTILITY                                                                 */
/*                                                                          */
/* AN RTR JOURNAL FILE HAS BEEN FOUND WHICH HAS AN INCORRECT NAME FORMAT.   */
/* THIS IS PROBABLY AN RTR BUG, SUBMIT AN SPR. THIS STATUS MAY BE RETURNED  */
/* BY THE ADD FACILITY AND SHOW JOURNAL COMMANDS.                           */
/*                                                                          */
/* REISSUE THE RTR CREATE JOURNAL COMMAND BEFORE RESTARTING RTR.            */
/*                                                                          */
#define RTR$_ERRJOUNAM 766492
/* %UTILITY                                                                 */
/*                                                                          */
/* NO RTR JOURNAL FILES CAN BE FOUND.                                       */
/*                                                                          */
/* THIS STATUS MAY BE RETURNED BY THE ADD FACILITY AND SHOW JOURNAL COMMANDS. */
/*                                                                          */
/* EITHER:                                                                  */
/*                                                                          */
/* 1) YOU HAVE NOT ISSUED AN RTR CREATE JOURNAL COMMAND                     */
/*                                                                          */
/* 2) ALL JOURNAL DISKS ARE OFFLINE                                         */
/*                                                                          */
/* 3) THE JOURNAL FILES HAVE BEEN INADVERTANTLY DELETED.                    */
/*                                                                          */
/* CORRECTIVE ACTION, EITHER:                                               */
/*                                                                          */
/* A) BRING THE JOURNAL DISK ON LINE                                        */
/*                                                                          */
/* B) ISSUE AN RTR CREATE JOURNAL COMMAND.                                  */
/*                                                                          */
#define RTR$_JOUNOTINI 766500
/* %UTILITY                                                                 */
/*                                                                          */
/* THE JOURNAL FILE(S) FOUND HAVE AN OUT-OF-DATE FORMAT. THIS STATUS MAY BE */
/* RETURNED BY THE ADD FACILITY AND SHOW JOURNAL COMMANDS AFTER A NEW VERSION OF */
/* RTR HAS BEEN INSTALLED ON A SYSTEM.                                      */
/*                                                                          */
/* CORRECTIVE ACTION: ISSUE AN RTR CREATE JOURNAL /SUPERSEDE COMMAND.       */
/*                                                                          */
#define RTR$_JOUFORCHA 766508
/* %LOG                                                                     */
/*                                                                          */
/* AN INCONSISTENCY HAS BEEN FOUND IN A RECORD HEADER WITHIN THE RTR JOURNAL. */
/*                                                                          */
/* CORRECTIVE ACTION:                                                       */
/*                                                                          */
/* 1) REISSUE THE RTR CREATE JOURNAL /SUPERSEDE COMMAND.                    */
/*                                                                          */
/* 2) RESTART RTR.                                                          */
/*                                                                          */
/* 3) SUBMIT AN SPR.                                                        */
/*                                                                          */
#define RTR$_JOUHDRERR 766516
/* %LOG                                                                     */
/*                                                                          */
/* AN INCONSISTENCY HAS BEEN FOUND IN THE RECORD SEQUENCE WITHIN THE RTR JOURNAL. */
/*                                                                          */
/* CORRECTIVE ACTION:                                                       */
/*                                                                          */
/* 1) REISSUE THE RTR CREATE JOURNAL /SUPERSEDE COMMAND.                    */
/*                                                                          */
/* 2) RESTART RTR.                                                          */
/*                                                                          */
/* 3) SUBMIT AN SPR.                                                        */
/*                                                                          */
#define RTR$_JOUSEQERR 766524
/* %LOG                                                                     */
/*                                                                          */
/* THE JOURNAL FILE IS SO FULL THAT SOME TRANSACTION RECOVERY INFORMATION   */
/* HAS HAD TO BE DISCARDED. ONE OR MORE OF THE CURRENTLY ACTIVE TRANSACTIONS */
/* MAY BE INCORRECTLY RECOVERED IF A SYSTEM FAILURE OCCURS IN THE NEAR FUTURE. */
/*                                                                          */
#define RTR$_JOUOVERFL 766532
/* %LOG                                                                     */
/*                                                                          */
/* THE RTR JOURNAL FILE IS BECOMING FULL. EITHER REDUCE THE NUMBER AND SIZE OF */
/* CONCURRENTLY ACTIVE TRANSACTIONS, OR INCREASE THE SIZE OF THE JOURNAL FILE */
/* USING MODIFY JOURNAL /MAXIMUM_BLOCKS                                     */
/*                                                                          */
#define RTR$_JOUFILFUL 766536
/* %LOG                                                                     */
/*                                                                          */
/* JOURNAL SEARCH IS STARTING. THIS MESSAGE APPEARS WHEN RTR IS STARTED.    */
/*                                                                          */
#define RTR$_COMJOUSEA 766547
/* %LOG                                                                     */
/*                                                                          */
/* JOURNAL SEARCH HAS COMPLETED. THIS MESSAGE APPEARS WHEN RTR IS STARTED   */
/* THE NUMBER OF TRANSACTIONS NEEDING RECOVERY IS INDICATED BY [A].         */
/*                                                                          */
/*                                                                          */
#define RTR$_JOUSEACOM 766555
/* %UTILITY                                                                 */
/*                                                                          */
/* NO RTR JOURNAL FILES CAN BE FOUND.                                       */
/*                                                                          */
/* THIS STATUS MAY BE RETURNED BY THE ADD FACILITY,                         */
/* DELETE JOURNAL AND SHOW JOURNAL COMMANDS.                                */
/*                                                                          */
/* EITHER:                                                                  */
/*                                                                          */
/* 1) YOU HAVE NOT ISSUED AN RTR CREATE JOURNAL COMMAND                     */
/*                                                                          */
/* 2) ALL JOURNAL DISKS ARE OFFLINE                                         */
/*                                                                          */
/* 3) THE JOURNAL FILES HAVE ALREADY BEEN DELETED.                          */
/*                                                                          */
#define RTR$_JOUNOTFOU 766564
/* %UTILITY                                                                 */
/*                                                                          */
/* A PREVIOUSLY EXISTING JOURNAL WAS FOUND                                  */
/*                                                                          */
/* THIS STATUS MAY BE RETURNED BY THE                                       */
/* CREATE JOURNAL COMMANDS.                                                 */
/*                                                                          */
/* 1) YOU HAVE ISSUED AN RTR CREATE JOURNAL COMMAND WITHOUT                 */
/*    DELETING THE PREVIOUS JOURNAL.                                        */
/*                                                                          */
/* CORRECTIVE ACTION:                                                       */
/*                                                                          */
/* A) USE THE /SUPERSEDE QUALIFIER WITH CREATE JOURNAL                      */
/* OR                                                                       */
/* B) DELETE THE OLD JOURNAL WITH THE DELETE JOURNAL COMMAND                */
#define RTR$_JOUALREXI 766568
/* %UTILITY                                                                 */
/*                                                                          */
/* THE JOURNAL IS CURRENTLY IN USE BY ANOTHER USER.                         */
/*                                                                          */
/* THIS STATUS MAY BE RETURNED BY THE CREATE JOURNAL,                       */
/* AND DELETE JOURNAL COMMANDS.                                             */
/*                                                                          */
/* CORRECTIVE ACTION, EITHER:                                               */
/*                                                                          */
/* WAIT FOR THE OTHER USER TO COMPLETE, AND REISSSUE THE COMMAND            */
/*                                                                          */
#define RTR$_JOUINUSE 766576
/* %INTERNAL                                                                */
/*                                                                          */
/* A CHANNEL ARGUMENT IS NOT WELL FORMED                                    */
/*                                                                          */
#define RTR$_INVJOUCHN 766588
/* %INTERNAL                                                                */
/*                                                                          */
/* ATTEMPT TO DO CHANNEL BASED OPERATION WITHOUT OPENING                    */
/* A CHANNEL                                                                */
/*                                                                          */
#define RTR$_CHNNOTOPE 766596
/* %INTERNAL                                                                */
/*                                                                          */
/* AN ATTEMPT WAS MADE TO FLUSH 0 DISK WRITES                               */
/*                                                                          */
#define RTR$_NOFLUSH 766600
/* %UTILITY                                                                 */
/*                                                                          */
/* AN ERROR OCCURRED WHILE OPENING A JOURNAL FILE                           */
/*                                                                          */
#define RTR$_ERROPEJOU 766612
/* %UTILITY                                                                 */
/*                                                                          */
/* AN ATTEMPT WAS MADE TO WRITE MORE THAN 65534 RECORDS                     */
/* TO ONE ENTRY (TRANSACTION) IN THE JOURNAL.                               */
/*                                                                          */
#define RTR$_TOOMANREC 766620
/* %UTILITY                                                                 */
/*                                                                          */
/* AN ATTEMPT WAS MADE TO CREATE A JOURNAL ON A DISK                        */
/* SERVED BY DFS. RTR DOES NOT SUPPORT JOURNALS ON DFS                      */
/* SUPPORTED DISKS                                                          */
/*                                                                          */
#define RTR$_DFSDISK 766628
/* %UTILITY                                                                 */
/*                                                                          */
/* AN ATTEMPT WAS MADE TO CREATE A JOURNAL ON A DISK                        */
/* WHICH IS A MEMBER OF A SHADOW SET. RTR CANNOT LOCATE                     */
/* JOURNAL ON INDIVIDUAL SHADOW SET MEMBERS                                 */
/*                                                                          */
#define RTR$_DISKSSM 766636
/* %UTILITY                                                                 */
/*                                                                          */
/* AN ATTEMPT WAS MADE TO CREATE A JOURNAL ON A DISK                        */
/* WHICH IS NOT MOUNTED. PLEASE CHECK DISK FOR PROPER MOUNT STATUS          */
#define RTR$_DISKNOTMOU 766644
/* %UTILITY                                                                 */
/*                                                                          */
/* AN ATTEMPT WAS MADE TO CREATE A JOURNAL ON A DISK                        */
/* WHICH IS MOUNTED FOREIGN. PLEASE CHECK DISK FOR PROPER MOUNT STATUS      */
#define RTR$_DISKMOUFOR 766652
/* %UTILITY                                                                 */
/*                                                                          */
/* AN ATTEMPT WAS MADE TO CREATE A JOURNAL ON A DISK                        */
/* WHICH IS SOFTWARE WRITE LOCKED.                                          */
#define RTR$_DISKSWL 766660
/* %UTILITY                                                                 */
/*                                                                          */
/* AN ATTEMPT WAS MADE TO CREATE A JOURNAL ON A DISK                        */
/* WHICH IS ALLOOCATED TO A DIFFERENT PROCESS.                              */
#define RTR$_DISKALL 766668
/* %UTILITY                                                                 */
/*                                                                          */
/* AN ATTEMPT WAS MADE TO CREATE A JOURNAL ON A DISK                        */
/* WHICH IS IN MOUNT VERIFICATION. TRY LATER.                               */
#define RTR$_DISKMNTVER 766676
/* COPYRIGHT (C) 1988 BY                                                    */
/* DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.                   */
/* ALL RIGHTS RESERVED.                                                     */
/*                                                                          */
/* THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED    */
/* ONLY  IN  ACCORDANCE  OF  THE  TERMS  OF  SUCH  LICENSE  AND WITH THE    */
/* INCLUSION OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY  OTHER    */
/* COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY    */
/* OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY    */
/* TRANSFERRED.                                                             */
/*                                                                          */
/* THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE    */
/* AND  SHOULD  NOT  BE  CONSTRUED  AS A COMMITMENT BY DIGITAL EQUIPMENT    */
/* CORPORATION.                                                             */
/*                                                                          */
/* DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS    */
/* SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.                  */
/*                                                                          */
/* FACILITY : RTR SUBSYSTEM FCT                                             */
/*                                                                          */
/* ABSTRACT : MESSAGE DEFINITIONS FOR RTR SUBSYSTEM FCT                     */
/*                                                                          */
/* AUTHOR   : TONY CROSBY                                                   */
/*                                                                          */
/* CREATED  : 30-NOV-1989                                                   */
/*                                                                          */
/*                                                                          */
/* FILE RT$RTRFCTDEF.MSG	CONTAINS RTR MESSAGES EXPORTED              */
/* BY SUB-SYSTEM FCT. THESE MESSAGES ARE INCORPORATED                       */
/* INTO THE FINAL RTRMSG FILE. NOTE THIS FILE SHOULD                        */
/* NOT CONTAIN ANY OTHER DIRECTIVES BUT .BASE AND                           */
/* .SEVERITY. THE .FACILITY AND .END (ETC) DIRECTIVES                       */
/* ARE CONTAINED IN OTHER FILES.                                            */
/*                                                                          */
/*                                                                          */
/* %LOG,OBSOLETE                                                            */
/*                                                                          */
/* RTR INTERNODE COMMUNICATION HAS BECOME TEMPORARILY BLOCKED. ONE OR MORE  */
/* MESSAGES MAY HAVE BEEN LOST.                                             */
/*                                                                          */
#define RTR$_NETCOMBLO 765668
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* RTR INTERNODE COMMUNICATION HAS BECOME CONGESTED. NEW MESSAGES ARE WAITING */
/* FOR THE CONGESTION TO CLEAR.                                             */
/*                                                                          */
#define RTR$_MESFLOCON 765672
/*                                                                          */
/* COPYRIGHT (C) 1988 BY                                                    */
/* DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.                   */
/* ALL RIGHTS RESERVED.                                                     */
/*                                                                          */
/* THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED    */
/* ONLY  IN  ACCORDANCE  OF  THE  TERMS  OF  SUCH  LICENSE  AND WITH THE    */
/* INCLUSION OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY  OTHER    */
/* COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY    */
/* OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY    */
/* TRANSFERRED.                                                             */
/*                                                                          */
/* THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE    */
/* AND  SHOULD  NOT  BE  CONSTRUED  AS A COMMITMENT BY DIGITAL EQUIPMENT    */
/* CORPORATION.                                                             */
/*                                                                          */
/* DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS    */
/* SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.                  */
/*                                                                          */
/* FACILITY : RTR SUBSYSTEM QRM                                             */
/*                                                                          */
/* ABSTRACT : MESSAGE DEFINITIONS FOR RTR SUBSYSTEM QRM                     */
/*                                                                          */
/* AUTHOR   : DIPANKAR DESHMUKH                                             */
/*                                                                          */
/* CREATED  : 28-JUN-1992                                                   */
/*                                                                          */
/*                                                                          */
/* FILE RT$RTRQRMDEF.MSG	CONTAINS RTR MESSAGES EXPORTED              */
/* BY SUB-SYSTEM QRM. THESE MESSAGES ARE INCORPORATED                       */
/* INTO THE FINAL RTRMSG FILE. NOTE THIS FILE SHOULD                        */
/* NOT CONTAIN ANY OTHER DIRECTIVES BUT .BASE AND                           */
/* .SEVERITY. THE .FACILITY AND .END (ETC) DIRECTIVES                       */
/* ARE CONTAINED IN OTHER FILES.                                            */
/*                                                                          */
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* THIS STATUS IS USED TO INDICATE AN INADEQUACY IN THE STATIC              */
/* RESERVATIONS THE PER-LINK CONGESTION QUEUE HEADER BLOCKS.                */
/* SEND SPR.                                                                */
/*                                                                          */
#define RTR$_LNQOVERFLOW 760868
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* THIS STATUS IS USED TO INDICATE AN INADEQUACY IN THE STATIC              */
/* RESERVATIONS FOR THE INTERNAL QUERY CONTEXT DESCRIPTORS.                 */
/* SEND SPR.                                                                */
/*                                                                          */
#define RTR$_QCROVERFLOW 760876
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* THIS STATUS IS USED TO INDICATE AN INADEQUACY IN THE STATIC              */
/* RESERVATIONS FOR THE INTERNAL QUERY INITIATION DESCRIPTORS.              */
/* MAKE A NOTE OF ALL QRM COUNTERS USING SHOW RTR /COUNTER=QRM*             */
/* SEND SPR WITH THE CORRESPONDING RTRACP DUMP.                             */
/*                                                                          */
#define RTR$_QIROVERFLOW 760884
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* THIS STATUS IS USED TO INDICATE AN INADEQUACY IN THE STATIC              */
/* RESERVATIONS FOR THE INTERNAL RESPONSE ACCEPTOR ELEMENTS.                */
/* MAKE A NOTE OF ALL QRM COUNTERS USING SHOW RTR /COUNTER=QRM*             */
/* SEND SPR WITH THE CORRESPONDING RTRACP DUMP.                             */
/*                                                                          */
#define RTR$_RAEOVERFLOW 760892
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* THIS STATUS IS USED TO INDICATE AN INADEQUACY IN THE STATIC              */
/* RESERVATIONS FOR THE INTERNAL RESPONSE DISPATCH ELEMENTS.                */
/* MAKE A NOTE OF ALL QRM COUNTERS USING SHOW RTR /COUNTER=QRM*             */
/* SEND SPR WITH THE CORRESPONDING RTRACP DUMP.                             */
/*                                                                          */
#define RTR$_RDEOVERFLOW 760900
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* THIS STATUS IS USED TO INDICATE AN INADEQUACY IN THE STATIC              */
/* RESERVATIONS FOR THE INTERNAL QUERY ACCEPTOR RECORDS.                    */
/* MAKE A NOTE OF ALL QRM COUNTERS USING SHOW RTR /COUNTER=QRM*             */
/* SEND SPR WITH RTRACP DUMP.                                               */
/*                                                                          */
#define RTR$_QAROVERFLOW 760908
/*                                                                          */
/*	FILE RT$RTRENDDEF.MSG CONTAINS .END DIRECTIVE FOR                   */
/*	USE IN APPENDING RTR MESSAGE FILES TOGETHER FOR                     */
/*	THE FINAL RTR MESSAGE UTILITY.                                      */

/********************************************************************************************************************************/
/* Created: 16-OCT-1994 16:21:59 by OpenVMS SDL EV1-19     */
/* Source:   2-FEB-1994 15:37:04 RTR$BUILD_ROOT:[LIB.BLDRTRTMP]RT$RTRSERVICE.SDL */
/********************************************************************************************************************************/
/*** MODULE $RTRDEF IDENT V0.0 ***/
/*                                                                          */
/* The following definitions are used to create the "datpar"                */
/* argument on calls to "SYS$DCL_TX_PRC" when declaring server              */
/* and (optionally) requester channels.                                     */
/*                                                                          */
/* The "datpar" argument specifies the position, length and data type       */
/* of the routing key within the messages sent from requesters to           */
/* servers. This specification is optional for requesters but, if           */
/* supplied, must match the key specification of the servers in that        */
/* facility.                                                                */
/*                                                                          */
/* Servers have additionally to specify the lower and upper bounds of the   */
/* range of values that they wish to handle.                                */
/*                                                                          */
/* The "datpar" argument is similar to an item list and consists            */
/* of a zero terminated list of elements of type "RTR$_DATPAR_ELEM"         */
/* If the key has only one segment then only one "RTR$_DATPAR_ELEM"         */
/* (followed by a zero longword of zero) need be defined. If a "split"      */
/* key (i.e. more than one segment) is to be used than the datpar has       */
/* to contain the corresponding number of "RTR$_DATPAR_ELEM" elements       */
/* followed by a longword of zero.                                          */
/*                                                                          */
/* In high level languages this is best achieved by declaring an array      */
/* of elements of type "RTR$_DATPAR_ELEM" with one more element than        */
/* there are key segments. Initialize the first long word of of the         */
/* last element to zero and the remaining elements to  contain              */
/* the required key/boundary specification.                                 */
/*                                                                          */
/* The structure of an "RTR$_DATPAR_ELEM" element is described below.       */
/* Use of the symbolic offsets is however recommended.                      */
/*                                                                          */
/* .---------------------------------------------------------------.        */
/* |                     rtr$l_datpar_key_dtyp                     | 0      */
/* |---------------------------------------------------------------|        */
/* |                     rtr$l_datpar_key_len                      | 4      */
/* |---------------------------------------------------------------|        */
/* |                     rtr$l_datpar_key_off                      | 8      */
/* |---------------------------------------------------------------|        */
/* |                      rtr$a_datpar_lo_bnd                      | 12     */
/* |---------------------------------------------------------------|        */
/* |                      rtr$a_datpar_hi_bnd                      | 16     */
/* `---------------------------------------------------------------'        */
/*                                                                          */
/* rtr$l_datpar_key_dtyp                                                    */
/*                                                                          */
/*   Data type of key segment can take one of the following values,         */
/*   (constants defined in STARLET - $DSCDEF):-                             */
/*                                                                          */
/*      DSC$K_DTYPE_BU (=2)    Unsigned byte                                */
/*      DSC$K_DTYPE_WU (=3)    Unsigned word                                */
/*      DSC$K_DTYPE_LU (=4)    Unsigned long                                */
/*      DSC$K_DTYPE_B  (=6)    Signed byte                                  */
/*      DSC$K_DTYPE_W  (=7)    Signed word                                  */
/*      DSC$K_DTYPE_L  (=8)    Signed long                                  */
/*      DSC$K_DTYPE_Q  (=9)    Signed quad                                  */
/*      DSC$K_DTYPE_T (=14)    String                                       */
/*      DSC$K_DTYPE_P (=21)    Packed decimal                               */
/*                                                                          */
/*                                                                          */
/* rtr$l_datpar_key_len                                                     */
/*                                                                          */
/*   length of key segment in $enq_tx buffer. In bytes for all key types    */
/*   except DSC$K_DTYPE_P which uses nibbles (half bytes).                  */
/*                                                                          */
/* rtr$l_datpar_key_off-                                                    */
/*                                                                          */
/*   offset of key segment within $enq_tx buffer in bytes                   */
/*                                                                          */
/*                                                                          */
/* rtr$a_datpar_lo_bnd                                                      */
/*                                                                          */
/*   address of key range low bound (must be zero for requesters)           */
/*                                                                          */
/* rtr$a_datpar_hi_bnd                                                      */
/*                                                                          */
/*   address of key range high bound (must be zero for requesters)          */
/*                                                                          */
struct RTR$_DATPAR_ELEM {
    int RTR$L_DATPAR_KEY_DTYP;          /* Data type of key segment = DSC$K_DTYPE_xxx */
    int RTR$L_DATPAR_KEY_LEN;           /* Length of key segment in $ENQ_TX buffer */
    int RTR$L_DATPAR_KEY_OFF;           /* Offset of key segment wihin $ENQ_TX buffer */
    int *RTR$A_DATPAR_LO_BND;           /* Address of key range low bound   */
    int *RTR$A_DATPAR_HI_BND;           /* Address of key range high bound  */
    } ;
/*                                                                          */
/* RTR$R_KEY_SEGMENT IS NOW OBSOLETE, PLEASE USE "RTR$_DATPAR_ELEM"         */
/*                          ========                                        */
/*                                                                          */
struct RTR$_KEY_SEGMENT {
    unsigned char RTR$B_KEYSEG_DTYP;    /*Data type of key segment = DSC$K_DTYPE_xxx */
    unsigned RTR$V_SPARE : 24;
    unsigned short int RTR$W_KEYSEG_LENGTH; /* Length of segment            */
    unsigned short int RTR$W_KEYSEG_OFFSET; /* Offset of segment in TX record */
    } ;
/*                                                                          */
/* RTR$R_DATPAR IS NOW OBSOLETE, PLEASE USE "RTR$R_DATPAR_ELEM"             */
/*                     ========                                             */
/*                                                                          */
#define RTR$M_DATPAR_SPLIT_KEY 0x1
#define RTR$M_DATPAR_CDD_SPEC 0x2
struct RTR$_DATPAR {
    unsigned short int RTR$W_DATPAR_LENGTH;
    struct  {
        unsigned RTR$V_DATPAR_SPLIT_KEY : 1;
        unsigned RTR$V_DATPAR_CDD_SPEC : 1;
        unsigned RTR$V_DATPAR_SPARE1 : 14;
        } RTR$R_DATPAR_KEY_FLAGS;
    union  {
        struct  {
            union  {
                unsigned int RTR$Q_DATPAR_LBV [2];
                struct  {
                    unsigned short int RTR$W_DATPAR_LBD_LENGTH;
                    unsigned short int RTR$W_DATPAR_LBD_SPARE1;
                    int *RTR$A_DATPAR_LBD_POINTER;
                    } RTR$R_DATPAR_LBD;
               } RTR$R_DATPAR_LOW_BOUND;
            union  {
                unsigned int RTR$Q_DATPAR_HBV [2];
                struct  {
                    unsigned short int RTR$W_DATPAR_HBD_LENGTH;
                    unsigned short int RTR$W_DATPAR_HBD_SPARE2;
                    int *RTR$A_DATPAR_HBD_POINTER;
                    } RTR$R_DATPAR_HBD;
                } RTR$R_DATPAR_HIGH_BOUND;
            struct  {
                int RTR$Q_KEY [2];
                } RTR$R_DATPAR_KEY_SEGMENT_LIST;
            } RTR$R_DATPAR_DATA;
        struct  {
            unsigned short int RTR$W_DATPAR_SPEC_LENGTH;
            unsigned short int RTR$W_DATPAR_SPEC_SPARE3;
            char *RTR$A_DATPAR_SPEC_POINTER;
            } RTR$R_DATPAR_SPEC;
        } RTR$R_DATPAR_INFO;
    } ;
#define RTR$K_DATPAR_FIX 20             /* Fixed length part                */
#define RTR$K_DATPAR_FIL 12             /* File spec length                 */
struct RTR$_TXSB {
    int RTR$L_TXSB_STATUS;              /*RTR status, always passed back    */
    union  {
        int RTR$L_TXSB_DATLEN;          /*data length, passed back to DEQ if STATUS success */
        int RTR$L_TXSB_FACID;           /*facility id, passed back on DCL_TX_PRC */
        int RTR$L_TXSB_COMMITMSK;       /*on tx commit - contains or'ed commit rsnsts msk. */
        int RTR$L_TXSB_RSNSTS;          /*on transaction abort, abort status/reason */
        } RTR$R_DATLEN_FACID_OVERLAY;
    unsigned int RTR$Q_TXSB_TXID [2];   /*transaction id. always passed back to server */
/*for requesters only passed back on commit/abort                           */
/*or if tx aborts unsolicited.                                              */
    } ;
struct RTR$_TID {
    unsigned int RTR$Q_RTRTID [2];      /*transaction id. always passed back to server */
/*with $DEQ_TX if server has declared DDTM chan                             */
    unsigned int RTR$L_FRSTMSG;         /*sequence # of first txn msg to this server */
    unsigned int RTR$L_KRID;            /*keyrange-id for this server's partition */
    } ;
#define RTR$K_ACCESS_TYPE_PASSWORD 1
struct RTR$_ACCESS {
    unsigned short int RTR$W_ACCESS_LENGTH; /* byte length of access string */
    unsigned short int RTR$W_ACCESS_TYPE; /* must be set to RTR$K_ACCESS_TYPE_PASSWORD */
    union  {
        unsigned int RTR$L_ACCESS_ACCADR; /* Address of access string       */
        int *RTR$A_ACCESS_ACCADR;       /* Address of access string         */
        } RTR$R_ACCADR_OVERLAY;
    } ;
/*                                                                          */
/*  DCL_TX_PRC SYSTEM SERVICE FLAG DEFINITION                               */
/*                                                                          */
#define RTR$M_SHUTDOWN 0x1
#define RTR$M_REQUESTER 0x2
#define RTR$M_SERVER 0x4
#define RTR$M_RESERVED_1 0x8
#define RTR$M_RESERVED_2 0x10
#define RTR$M_CONCURRENT 0x20
#define RTR$M_SHADOW 0x40
#define RTR$M_STANDBY 0x80
#define RTR$M_FE_CALL_OUT 0x100
#define RTR$M_TR_CALL_OUT 0x200
#define RTR$M_BE_CALL_OUT 0x400
#define RTR$M_INHNOSRVWT 0x800
#define RTR$M_DDTM 0x1000
#define RTR$M_NONDEFTID 0x2000
struct RTR$_DCL_FLAGS {
    unsigned RTR$V_SHUTDOWN : 1;        /*channel shutdown, must be specified alone */
    unsigned RTR$V_REQUESTER : 1;       /*channel declared is requester channel */
    unsigned RTR$V_SERVER : 1;          /*channel declared is server channel */
    unsigned RTR$V_RESERVED_1 : 1;
    unsigned RTR$V_RESERVED_2 : 1;
    unsigned RTR$V_CONCURRENT : 1;      /*concurrent servers allowed        */
    unsigned RTR$V_SHADOW : 1;          /*server member of shadow server set */
    unsigned RTR$V_STANDBY : 1;         /*server may act as standby for another server */
    unsigned RTR$V_FE_CALL_OUT : 1;     /*process acts as call out appl. on FE node */
    unsigned RTR$V_TR_CALL_OUT : 1;     /*process acts as call out appl. on TR node */
    unsigned RTR$V_BE_CALL_OUT : 1;     /*process acts as call out appl. on BE node */
    unsigned RTR$V_INHNOSRVWT : 1;      /*req dcl will term immed if no srv avail in fac */
    unsigned RTR$V_DDTM : 1;            /*server accessing resource managed thru DECdtm */
    unsigned RTR$V_NONDEFTID : 1;       /*DDTM start branch with nondefault tid */
    unsigned RTR$V_RESERVED_DCL_FLAGS : 18; /*reserved to DIGITAL           */
    } ;
/*                                                                          */
/*  START_TX SYSTEM SERVICE FLAG DEFINITION                                 */
/*                                                                          */
struct RTR$_START_FLAGS {
    unsigned RTR$V_RESERVED_START_FLAGS : 32; /*reserved to DIGITAL         */
    } ;
/*                                                                          */
/*  ENQ_TX SYSTEM SERVICE FLAG DEFINITION                                   */
/*                                                                          */
#define RTR$M_BROADCAST 0x1
#define RTR$M_EVENT 0x1
#define RTR$M_STOANDFOR 0x100
#define RTR$M_ENQBUFCHK 0x200
#define RTR$M_NORSWAIT 0x400
#define RTR$M_NODSTFNDIGN 0x800
#define RTR$M_NODSTFNDEVT 0x1000
#define RTR$M_READONLY 0x2000
struct RTR$_ENQ_FLAGS {
    union  {
        unsigned RTR$V_BROADCAST : 1;   /*Generates broadcast event         */
        unsigned RTR$V_EVENT : 1;       /*Generates broadcast event         */
        } RTR$R_BROADCAST_SYNONYMS;
    unsigned RTR$V_STOANDFOR : 1;       /*Enq queued for later delivery to server */
    unsigned RTR$V_ENQBUFCHK : 1;       /*Unsupported, checks rd access to entire user suppl. buffer */
    unsigned RTR$V_NORSWAIT : 1;        /*No Resource Wait in flow control situations. */
    unsigned RTR$V_NODSTFNDIGN : 1;     /*Txn not aborted on NODSTFND of ENQ_TX */
    unsigned RTR$V_NODSTFNDEVT : 1;     /*Generate NODSTFNDEVT event on NODSTFND */
    unsigned RTR$V_READONLY : 1;        /*Operation is read-only. No recovery or shadowing needed */
    unsigned RTR$V_RESERVED_ENQ_FLAGS : 18; /*reserved to DIGITAL           */
    } ;
/*                                                                          */
/*  DEQ_TX SYSTEM SERVICE FLAG DEFINITION                                   */
/*                                                                          */
#define RTR$M_DEQBUFCHK 0x1
struct RTR$_DEQ_FLAGS {
    unsigned RTR$V_DEQBUFCHK : 1;       /*Unsupported, checks wrt access to entire user suppl. buffer */
    unsigned RTR$V_RESERVED_DEQ_FLAGS : 31; /*reserved to DIGITAL           */
    } ;
/*                                                                          */
/*  COMMIT_TX SYSTEM SERVICE FLAG DEFINITION                                */
/*                                                                          */
struct RTR$_COMMIT_FLAGS {
    unsigned RTR$V_RESERVED_COMMIT_FLAGS : 32; /*reserved to DIGITAL        */
    } ;
/*                                                                          */
/*  VOTE_TX SYSTEM SERVICE FLAG DEFINITION                                  */
/*                                                                          */
#define RTR$M_ABORT 0x1
#define RTR$M_COMMIT 0x2
#define RTR$M_FORGET 0x4
struct RTR$_VOTE_FLAGS {
    unsigned RTR$V_ABORT : 1;
    unsigned RTR$V_COMMIT : 1;
    unsigned RTR$V_FORGET : 1;
    unsigned RTR$V_RESERVED_VOTE_FLAGS : 29; /*Reserved to DIGITAL          */
    } ;
/*                                                                          */
/*  Definition of EVTMSK and EVTNO bit numbers                              */
/*  for event signalling. Also defines a number of                          */
/*  constants relating to EVTMSK and max EVTNO.                             */
/*                                                                          */
#define RTR$M_EVTMSK_BRDCST 0x1
#define RTR$M_EVTMSK_USRDEF1 0x2
#define RTR$M_EVTMSK_USRDEF2 0x4
#define RTR$M_EVTMSK_USRDEF3 0x8
#define RTR$M_EVTMSK_USRDEF4 0x10
#define RTR$M_EVTMSK_USRDEF5 0x20
#define RTR$M_EVTMSK_USRDEF6 0x40
#define RTR$M_EVTMSK_USRDEF7 0x80
#define RTR$M_EVTMSK_USRDEF8 0x100
#define RTR$M_EVTMSK_USRDEF9 0x200
#define RTR$M_EVTMSK_USRDEF10 0x400
#define RTR$M_EVTMSK_USRDEF11 0x800
#define RTR$M_EVTMSK_USRDEF12 0x1000
#define RTR$M_EVTMSK_USRDEF13 0x2000
#define RTR$M_EVTMSK_USRDEF14 0x4000
#define RTR$M_EVTMSK_USRDEF15 0x8000
#define RTR$M_EVTMSK_USRDEF16 0x10000
#define RTR$M_EVTMSK_USRDEF17 0x20000
#define RTR$M_EVTMSK_USRDEF18 0x40000
#define RTR$M_EVTMSK_USRDEF19 0x80000
#define RTR$M_EVTMSK_USRDEF20 0x100000
#define RTR$M_EVTMSK_USRDEF21 0x200000
#define RTR$M_EVTMSK_USRDEF22 0x400000
#define RTR$M_EVTMSK_USRDEF23 0x800000
#define RTR$M_EVTMSK_USRDEF24 0x1000000
#define RTR$M_EVTMSK_USRDEF25 0x2000000
#define RTR$M_EVTMSK_USRDEF26 0x4000000
#define RTR$M_EVTMSK_USRDEF27 0x8000000
#define RTR$M_EVTMSK_USRDEF28 0x10000000
#define RTR$M_EVTMSK_USRDEF29 0x20000000
#define RTR$M_EVTMSK_USRDEF30 0x40000000
#define RTR$M_EVTMSK_USRDEF31 0x80000000
struct RTR$_EVTMSK_FLAGS_TYPE1 {
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_BRDCST : 1;   /*brdcst bit.                       */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF1 : 1;  /*user defined event no 1           */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF2 : 1;  /*user defined event no 2           */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF3 : 1;  /*user defined event no 3           */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF4 : 1;  /*user defined event no 4           */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF5 : 1;  /*user defined event no 5           */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF6 : 1;  /*user defined event no 6           */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF7 : 1;  /*user defined event no 7           */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF8 : 1;  /*user defined event no 8           */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF9 : 1;  /*user defined event no 9           */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF10 : 1; /*user defined event no 10          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF11 : 1; /*user defined event no 11          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF12 : 1; /*user defined event no 12          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF13 : 1; /*user defined event no 13          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF14 : 1; /*user defined event no 14          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF15 : 1; /*user defined event no 15          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF16 : 1; /*user defined event no 16          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF17 : 1; /*user defined event no 17          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF18 : 1; /*user defined event no 18          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF19 : 1; /*user defined event no 19          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF20 : 1; /*user defined event no 20          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF21 : 1; /*user defined event no 21          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF22 : 1; /*user defined event no 22          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF23 : 1; /*user defined event no 23          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF24 : 1; /*user defined event no 24          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF25 : 1; /*user defined event no 25          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF26 : 1; /*user defined event no 26          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF27 : 1; /*user defined event no 27          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF28 : 1; /*user defined event no 28          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF29 : 1; /*user defined event no 29          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF30 : 1; /*user defined event no 30          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF31 : 1; /*user defined event no 31          */
    } ;
#define RTR$M_EVTMSK_USRDEF32 0x1
#define RTR$M_EVTMSK_USRDEF33 0x2
#define RTR$M_EVTMSK_USRDEF34 0x4
#define RTR$M_EVTMSK_USRDEF35 0x8
#define RTR$M_EVTMSK_USRDEF36 0x10
#define RTR$M_EVTMSK_USRDEF37 0x20
#define RTR$M_EVTMSK_USRDEF38 0x40
#define RTR$M_EVTMSK_USRDEF39 0x80
#define RTR$M_EVTMSK_USRDEF40 0x100
#define RTR$M_EVTMSK_USRDEF41 0x200
#define RTR$M_EVTMSK_USRDEF42 0x400
#define RTR$M_EVTMSK_USRDEF43 0x800
#define RTR$M_EVTMSK_USRDEF44 0x1000
#define RTR$M_EVTMSK_USRDEF45 0x2000
#define RTR$M_EVTMSK_USRDEF46 0x4000
#define RTR$M_EVTMSK_USRDEF47 0x8000
#define RTR$M_EVTMSK_USRDEF48 0x10000
#define RTR$M_EVTMSK_USRDEF49 0x20000
#define RTR$M_EVTMSK_USRDEF50 0x40000
#define RTR$M_EVTMSK_USRDEF51 0x80000
#define RTR$M_EVTMSK_USRDEF52 0x100000
#define RTR$M_EVTMSK_USRDEF53 0x200000
#define RTR$M_EVTMSK_USRDEF54 0x400000
#define RTR$M_EVTMSK_USRDEF55 0x800000
#define RTR$M_EVTMSK_USRDEF56 0x1000000
#define RTR$M_EVTMSK_USRDEF57 0x2000000
#define RTR$M_EVTMSK_USRDEF58 0x4000000
#define RTR$M_EVTMSK_USRDEF59 0x8000000
#define RTR$M_EVTMSK_USRDEF60 0x10000000
#define RTR$M_EVTMSK_USRDEF61 0x20000000
#define RTR$M_EVTMSK_USRDEF62 0x40000000
#define RTR$M_EVTMSK_USRDEF63 0x80000000
struct RTR$_EVTMSK_FLAGS_TYPE2 {
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF32 : 1; /*user defined event no 32          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF33 : 1; /*user defined event no 33          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF34 : 1; /*user defined event no 34          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF35 : 1; /*user defined event no 35          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF36 : 1; /*user defined event no 36          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF37 : 1; /*user defined event no 37          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF38 : 1; /*user defined event no 38          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF39 : 1; /*user defined event no 39          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF40 : 1; /*user defined event no 40          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF41 : 1; /*user defined event no 41          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF42 : 1; /*user defined event no 42          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF43 : 1; /*user defined event no 43          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF44 : 1; /*user defined event no 44          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF45 : 1; /*user defined event no 45          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF46 : 1; /*user defined event no 46          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF47 : 1; /*user defined event no 47          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF48 : 1; /*user defined event no 48          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF49 : 1; /*user defined event no 49          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF50 : 1; /*user defined event no 50          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF51 : 1; /*user defined event no 51          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF52 : 1; /*user defined event no 52          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF53 : 1; /*user defined event no 53          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF54 : 1; /*user defined event no 54          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF55 : 1; /*user defined event no 55          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF56 : 1; /*user defined event no 56          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF57 : 1; /*user defined event no 57          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF58 : 1; /*user defined event no 58          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF59 : 1; /*user defined event no 59          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF60 : 1; /*user defined event no 60          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF61 : 1; /*user defined event no 61          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF62 : 1; /*user defined event no 62          */
    RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_USRDEF63 : 1; /*user defined event no 63          */
    } ;
#define RTR$M_EVTMSK_FACREADY 0x1
#define RTR$M_EVTMSK_FACDEAD 0x2
#define RTR$M_EVTMSK_FERTRGAIN 0x4
#define RTR$M_EVTMSK_FERTRLOSS 0x8
#define RTR$M_EVTMSK_RTRBEGAIN 0x10
#define RTR$M_EVTMSK_RTRBELOSS 0x20
#define RTR$M_EVTMSK_KEYRANGEGAIN 0x40
#define RTR$M_EVTMSK_KEYRANGELOSS 0x80
#define RTR$M_EVTMSK_BERTRGAIN 0x100
#define RTR$M_EVTMSK_BERTRLOSS 0x200
#define RTR$M_EVTMSK_RTRFEGAIN 0x400
#define RTR$M_EVTMSK_RTRFELOSS 0x800
#define RTR$M_EVTMSK_SRPRIMARY 0x1000
#define RTR$M_EVTMSK_SRSTANDBY 0x2000
#define RTR$M_EVTMSK_SRSECONDARY 0x4000
#define RTR$M_EVTMSK_SRSHADOWLOST 0x8000
#define RTR$M_EVTMSK_SRSHADOWGAIN 0x10000
#define RTR$M_EVTMSK_SRRECOVERCMPL 0x20000
#define RTR$M_EVTMSK_NODSTFNDEVT 0x40000
struct RTR$_EVTMSK_TYPE2_MASK {
    int RTR$L_EVTMSK_TYPE1_FLAGS;
    int RTR$L_EVTMSK_TYPE2_FLAGS;
    struct  {
        RTR_UNS_BITFIELD_TYPE RTR$V_FIRST_RTR_DEFINED : 32;
        } RTR$R_FIRST_RTR_DEFINED_BITS;
    struct  {
        RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_FACREADY : 1; /* The facility has become operational */
        RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_FACDEAD : 1; /* The facility has broken down  */
        RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_FERTRGAIN : 1; /* FE link to current router established */
        RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_FERTRLOSS : 1; /* FE link to current router lost */
        RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_RTRBEGAIN : 1; /* Current router established link to a BE */
        RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_RTRBELOSS : 1; /* Current router lost link to a BE */
        RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_KEYRANGEGAIN : 1; /* Server(s) for new key range available */
        RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_KEYRANGELOSS : 1; /* No more servers left for a particular key range */
        RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_BERTRGAIN : 1; /* BE established link to a router */
        RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_BERTRLOSS : 1; /* BE lost link to a router    */
        RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_RTRFEGAIN : 1; /* Router established link to an FE */
        RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_RTRFELOSS : 1; /* Router lost link to an FE   */
        RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_SRPRIMARY : 1; /* Server is in primary mode   */
        RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_SRSTANDBY : 1; /* Server is in standby mode   */
        RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_SRSECONDARY : 1; /* Server is in secondary mode */
        RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_SRSHADOWLOST : 1; /* Server lost shadow partner  */
        RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_SRSHADOWGAIN : 1; /* Server gained shadow partner  */
        RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_SRRECOVERCMPL : 1; /* Server completed recovery */
        RTR_UNS_BITFIELD_TYPE RTR$V_EVTMSK_NODSTFNDEVT : 1; /* No server found to service request */
        RTR_UNS_BITFIELD_TYPE RTR$V_MORE_RTR_DEFINED : 13;
        } RTR$R_MORE_RTR_DEFINED_BITS;
    } ;
union RTR$_EVTMSK {
    struct  {                           /*evtmsk type 1,quad word, mask in 2'nd longword */
        unsigned int RTR$L_EVTMSK_MBZ;  /*NOTE: first long must be zero to indicate mask type 1 */
        int RTR$L_EVTMSK_MASK;          /*mask type 1 bits                  */
        } RTR$R_EVTMSK_TYPE1;
    struct  {                           /*evtmsk type 2, descriptor type    */
        unsigned short int RTR$W_EVTMSK_LEN; /*len of bitmask in bytes, max rtr$evt_k_maxmsklen  */
        unsigned short int RTR$W_RESERV;
        struct RTR$_EVTMSK_TYPE2_MASK *RTR$A_EVTMSK_EVTADR; /*bitmask  address - max 8*rtr$evt_k_maxmsklen bits */
        } RTR$R_EVTMSK_TYPE2;
    } ;
/*rtr$k_evtmsk_maxmsklen max len of EVTMSK type 2 in bytes.                 */
#define RTR$K_EVTMSK_MAXMSKLEN 16
/*rtr$k_max_evtnamlen : max byte length of evtnam parameter for $dcl_tx_prc and  */
/* $enq_tx.                                                                 */
#define RTR$K_MAX_EVTNAMLEN 32
#define RTR$V_EVTNO_BRDCST 0            /*brdcst bit.                       */
#define RTR$V_EVTNO_USRDEF0 0           /*brdcst bit.                       */
#define RTR$V_EVTNO_USRDEF1 1           /*user defined event no 1           */
#define RTR$V_EVTNO_USRDEF2 2           /*user defined event no 2           */
#define RTR$V_EVTNO_USRDEF3 3           /*user defined event no 3           */
#define RTR$V_EVTNO_USRDEF4 4           /*user defined event no 4           */
#define RTR$V_EVTNO_USRDEF5 5           /*user defined event no 5           */
#define RTR$V_EVTNO_USRDEF6 6           /*user defined event no 6           */
#define RTR$V_EVTNO_USRDEF7 7           /*user defined event no 7           */
#define RTR$V_EVTNO_USRDEF8 8           /*user defined event no 8           */
#define RTR$V_EVTNO_USRDEF9 9           /*user defined event no 9           */
#define RTR$V_EVTNO_USRDEF10 10         /*user defined event no 10          */
#define RTR$V_EVTNO_USRDEF11 11         /*user defined event no 11          */
#define RTR$V_EVTNO_USRDEF12 12         /*user defined event no 12          */
#define RTR$V_EVTNO_USRDEF13 13         /*user defined event no 13          */
#define RTR$V_EVTNO_USRDEF14 14         /*user defined event no 14          */
#define RTR$V_EVTNO_USRDEF15 15         /*user defined event no 15          */
#define RTR$V_EVTNO_USRDEF16 16         /*user defined event no 16          */
#define RTR$V_EVTNO_USRDEF17 17         /*user defined event no 17          */
#define RTR$V_EVTNO_USRDEF18 18         /*user defined event no 18          */
#define RTR$V_EVTNO_USRDEF19 19         /*user defined event no 19          */
#define RTR$V_EVTNO_USRDEF20 20         /*user defined event no 20          */
#define RTR$V_EVTNO_USRDEF21 21         /*user defined event no 21          */
#define RTR$V_EVTNO_USRDEF22 22         /*user defined event no 22          */
#define RTR$V_EVTNO_USRDEF23 23         /*user defined event no 23          */
#define RTR$V_EVTNO_USRDEF24 24         /*user defined event no 24          */
#define RTR$V_EVTNO_USRDEF25 25         /*user defined event no 25          */
#define RTR$V_EVTNO_USRDEF26 26         /*user defined event no 26          */
#define RTR$V_EVTNO_USRDEF27 27         /*user defined event no 27          */
#define RTR$V_EVTNO_USRDEF28 28         /*user defined event no 28          */
#define RTR$V_EVTNO_USRDEF29 29         /*user defined event no 29          */
#define RTR$V_EVTNO_USRDEF30 30         /*user defined event no 30          */
#define RTR$V_EVTNO_USRDEF31 31         /*user defined event no 31          */
#define RTR$V_EVTNO_USRDEF32 32         /*user defined event no 32          */
#define RTR$V_EVTNO_USRDEF33 33         /*user defined event no 33          */
#define RTR$V_EVTNO_USRDEF34 34         /*user defined event no 34          */
#define RTR$V_EVTNO_USRDEF35 35         /*user defined event no 35          */
#define RTR$V_EVTNO_USRDEF36 36         /*user defined event no 36          */
#define RTR$V_EVTNO_USRDEF37 37         /*user defined event no 37          */
#define RTR$V_EVTNO_USRDEF38 38         /*user defined event no 38          */
#define RTR$V_EVTNO_USRDEF39 39         /*user defined event no 39          */
#define RTR$V_EVTNO_USRDEF40 40         /*user defined event no 40          */
#define RTR$V_EVTNO_USRDEF41 41         /*user defined event no 41          */
#define RTR$V_EVTNO_USRDEF42 42         /*user defined event no 42          */
#define RTR$V_EVTNO_USRDEF43 43         /*user defined event no 43          */
#define RTR$V_EVTNO_USRDEF44 44         /*user defined event no 44          */
#define RTR$V_EVTNO_USRDEF45 45         /*user defined event no 45          */
#define RTR$V_EVTNO_USRDEF46 46         /*user defined event no 46          */
#define RTR$V_EVTNO_USRDEF47 47         /*user defined event no 47          */
#define RTR$V_EVTNO_USRDEF48 48         /*user defined event no 48          */
#define RTR$V_EVTNO_USRDEF49 49         /*user defined event no 49          */
#define RTR$V_EVTNO_USRDEF50 50         /*user defined event no 50          */
#define RTR$V_EVTNO_USRDEF51 51         /*user defined event no 51          */
#define RTR$V_EVTNO_USRDEF52 52         /*user defined event no 52          */
#define RTR$V_EVTNO_USRDEF53 53         /*user defined event no 53          */
#define RTR$V_EVTNO_USRDEF54 54         /*user defined event no 54          */
#define RTR$V_EVTNO_USRDEF55 55         /*user defined event no 55          */
#define RTR$V_EVTNO_USRDEF56 56         /*user defined event no 56          */
#define RTR$V_EVTNO_USRDEF57 57         /*user defined event no 57          */
#define RTR$V_EVTNO_USRDEF58 58         /*user defined event no 58          */
#define RTR$V_EVTNO_USRDEF59 59         /*user defined event no 59          */
#define RTR$V_EVTNO_USRDEF60 60         /*user defined event no 60          */
#define RTR$V_EVTNO_USRDEF61 61         /*user defined event no 61          */
#define RTR$V_EVTNO_USRDEF62 62         /*user defined event no 62          */
#define RTR$V_EVTNO_USRDEF63 63         /*user defined event no 63          */
#define RTR$K_EVTMSK_MAXUSREVTNO 63
/*rtr$k_evtmsk_maxusrevtno max event no possible to signal for user         */
#define RTR$V_EVTNO_FACREADY 96         /* The facility has become operational */
#define RTR$V_EVTNO_FACDEAD 97          /* The facility has broken down     */
#define RTR$V_EVTNO_FERTRGAIN 98        /* FE link to current router established */
#define RTR$V_EVTNO_FERTRLOSS 99        /* FE link to current router lost   */
#define RTR$V_EVTNO_RTRBEGAIN 100       /* Current router established link to a BE */
#define RTR$V_EVTNO_RTRBELOSS 101       /* Current router lost link to a BE */
#define RTR$V_EVTNO_KEYRANGEGAIN 102    /* Server(s) for new key range available */
#define RTR$V_EVTNO_KEYRANGELOSS 103    /* No more servers left for a particular key range */
#define RTR$V_EVTNO_BERTRGAIN 104       /* BE established link to a router  */
#define RTR$V_EVTNO_BERTRLOSS 105       /* BE lost link to a router         */
#define RTR$V_EVTNO_RTRFEGAIN 106       /* Router established link to an FE */
#define RTR$V_EVTNO_RTRFELOSS 107       /* Router lost link to an FE        */
#define RTR$V_EVTNO_SRPRIMARY 108       /* Server is in primary mode        */
#define RTR$V_EVTNO_SRSTANDBY 109       /* Server is in standby mode        */
#define RTR$V_EVTNO_SRSECONDARY 110     /* Server is in secondary mode      */
#define RTR$V_EVTNO_SRSHADOWLOST 111    /* Server lost shadow partner       */
#define RTR$V_EVTNO_SRSHADOWGAIN 112    /* Server gained shadow partner     */
#define RTR$V_EVTNO_SRRECOVERCMPL 113   /* Server completed recovery        */
#define RTR$V_EVTNO_NODSTFNDEVT 114     /* No server found to service request */
#define RTR$K_MAXBUFLEN 64000           /*max no of bytes sent by one ENQ_TX */
#define RTR$K_EVTAST_ARGNO 6            /*no of arg's in EVTAST arg-list    */
struct RTR$_EVT {
    int RTR$L_EVT_ARGNO;                /*no of arg in argument array.      */
    int RTR$L_EVT_STATUS;               /*event status field.               */
    int RTR$L_EVT_EVTNO;                /*the event no. causing delivery of evtast */
    short int RTR$W_EVT_CH;             /*the channel on which the event occured. */
    short int RTR$W_EVT_SPAREW;
    int RTR$L_EVT_FACID;                /*facility id for fac. where event occurred. */
    int RTR$L_EVT_BUFLEN;               /*long arg-list only, message buffer length . */
    int RTR$L_EVT_BUFADR;               /*long arg-list only, message buffer address. */
    } ;
/*                                                                          */
/*  Definition of EVT-MSG structure: zero-terminated array of               */
/*  descriptors, each representing an item in the evt-msg.                  */
/*                                                                          */
/*AGGREGATE EVTMSG STRUCTURE                                                */
/*    PREFIX RTR$ MARKER RTR$ TAG "";                                       */
/*END EVTMSG;                                                               */
/*                                                                          */
/* Definitions of CHMK codes for the system services.                       */
/*                                                                          */
#define RTR$K_CHMK_CODE_BASE -300       /*CHMK code base for RTR services   */
#define RTR$K_ENQ_TX_CHMK_CODE -300     /*= -300, FED4                      */
#define RTR$K_DEQ_TX_CHMK_CODE -299     /*= -299, FED5                      */
#define RTR$K_START_TX_CHMK_CODE -298   /*= -298, FED6                      */
#define RTR$K_COMMIT_TX_CHMK_CODE -297  /*= -297, FED7                      */
#define RTR$K_VOTE_TX_CHMK_CODE -296    /*= -296, FED8                      */
#define RTR$K_GET_TXI_CHMK_CODE -295    /*= -295, FED9                      */
#define RTR$K_SET_TXI_CHMK_CODE -294    /*= -294, FEDA                      */
#define RTR$K_ABORT_TX_CHMK_CODE -293   /*= -293, FEDB                      */
#define RTR$K_DCL_TX_PRC_CHMK_CODE -292 /*= -292, FEDC                      */
#define RTR$K_CHMK_CODE_COUNT -292      /*No. of CHMK codes handled by RTR  */
/*system service dispatcher.                                                */
/*                                                                          */
/* Definition of an entry in the ITMLST supplied to $GET_TXI and $SET_TXI   */
/*                                                                          */
/* The ITMLST argument is the address of a list of one or more of           */
/* these entries, each of which specifies an item code. The list is         */
/* terminated by the item code 0, or by the longword 0.                     */
/*                                                                          */
struct RTR$_ITEM_LIST_ENTRY {
    unsigned short int RTR$W_ILE_BUFSIZ; /*item buffer size in bytes        */
    unsigned short int RTR$W_ILE_ITMCOD; /*item code defining item to get or set */
    int RTR$L_ILE_BUFADR;               /*item buffer address               */
    int RTR$L_ILE_LENADR;               /*addr. of longword to return size of info got/set */
    } ;
/*                                                                          */
/* START_SERVICE_MACROS                                                     */
/*                                                                          */


#if defined(__cplusplus)
extern "C" {
#endif

int sys$dcl_tx_prc() ;
int sys$dcl_tx_prcw() ;
int sys$get_txi() ;
int sys$get_txiw() ;
int sys$set_txi() ;
int sys$set_txiw() ;
int sys$enq_tx() ;
int sys$enq_txw() ;
int sys$deq_tx() ;
int sys$deq_txw() ;
int sys$start_tx() ;
int sys$abort_tx() ;
int sys$abort_txw() ;
int sys$commit_tx();
int sys$commit_txw() ;
int sys$vote_tx() ;
int sys$vote_txw() ;

#if defined(__cplusplus)
}
#endif


/*
 * To maintain compatibility with old style of service names
 */
#define SYS$DCL_TX_PRC sys$dcl_tx_prc
#define SYS$DCL_TX_PRCW sys$dcl_tx_prcw
#define SYS$GET_TXI sys$get_txi
#define SYS$GET_TXIW sys$get_txiw
#define SYS$SET_TXI sys$set_txi
#define SYS$SET_TXIW sys$set_txiw
#define SYS$ENQ_TX sys$enq_tx
#define SYS$ENQ_TXW sys$enq_txw
#define SYS$DEQ_TX sys$deq_tx
#define SYS$DEQ_TXW sys$deq_txw
#define SYS$START_TX sys$start_tx
#define SYS$ABORT_TX sys$abort_tx
#define SYS$ABORT_TXW sys$abort_txw
#define SYS$COMMIT_TX sys$commit_tx
#define SYS$COMMIT_TXW sys$commit_txw
#define SYS$VOTE_TX sys$vote_tx
#define SYS$VOTE_TXW sys$vote_txw
/********************************************************************************************************************************/
/* Created: 16-OCT-1994 16:22:02 by OpenVMS SDL EV1-19     */
/* Source:  16-OCT-1994 16:21:24 RTR$BUILD_ROOT:[LIB.BLDRTRTMP]RTRITMDEF.SDL;1 */
/********************************************************************************************************************************/
/* created by ITEMS utility from file "SRC$:RTRITMDEF" at 16:21:24.11 on 16-OCT-1994 */
/*** MODULE RTRITMDEF IDENT V0.0 ***/
#define RTR$ITM_K_TEXTUAL 1
#define RTR$ITM_K_PRT_FACILITY 258
#define RTR$ITM_K_PRT_LOW_BOUND 260
#define RTR$ITM_K_PRT_HIGH_BOUND 262
#define RTR$ITM_K_PRT_PRI_MAIN_NODE 264
#define RTR$ITM_K_PRT_PRI_STBY_NODE 266
#define RTR$ITM_K_PRT_SHD_MAIN_NODE 268
#define RTR$ITM_K_PRT_SHD_STBY_NODE 270
#define RTR$ITM_K_PRT_STATE 272
#define RTR$ITM_K_KSG_FACILITY 514
#define RTR$ITM_K_KSG_DATA_TYPE 516
#define RTR$ITM_K_KSG_LENGTH 518
#define RTR$ITM_K_KSG_OFFSET 520
#define RTR$ITM_K_SRV_PID 770
#define RTR$ITM_K_SRV_CHANNEL 772
#define RTR$ITM_K_SRV_FACILITY 774
#define RTR$ITM_K_SRV_STATE 776
#define RTR$ITM_K_SRV_DCL_FLAGS 778
#define RTR$ITM_K_SRV_EVENT_MASK 780
#define RTR$ITM_K_SRV_EVENT_NAME 782
#define RTR$ITM_K_SRV_LOW_BOUND 784
#define RTR$ITM_K_SRV_HIGH_BOUND 786
#define RTR$ITM_K_SRV_PARTITION 788
#define RTR$ITM_K_REQ_PID 1026
#define RTR$ITM_K_REQ_CHANNEL 1028
#define RTR$ITM_K_REQ_FACILITY 1030
#define RTR$ITM_K_REQ_STATE 1032
#define RTR$ITM_K_REQ_DCL_FLAGS 1034
#define RTR$ITM_K_REQ_EVENT_MASK 1036
#define RTR$ITM_K_REQ_EVENT_NAME 1038
#define RTR$ITM_K_BTX_FACILITY 1282
#define RTR$ITM_K_BTX_FE_USER 1284
#define RTR$ITM_K_BTX_TX_ID 1286
#define RTR$ITM_K_BTX_TX_START_TIME 1288
#define RTR$ITM_K_BTX_STATE 1290
#define RTR$ITM_K_BTX_ROUTER 1292
#define RTR$ITM_K_BTX_NR_ACT_KRS 1294
#define RTR$ITM_K_BTX_NR_TX_ENQS 1296
#define RTR$ITM_K_BTX_CRP_IN_PRG 1298
#define RTR$ITM_K_BTX_NR_REC_KRS 1300
#define RTR$ITM_K_BTX_KR_ID 1302
#define RTR$ITM_K_BTX_KR_SR 1304
#define RTR$ITM_K_BTX_KR_SR_STATE 1306
#define RTR$ITM_K_BTX_KR_JNL_STATE 1308
#define RTR$ITM_K_BTX_KR_JNL_NODE 1310
#define RTR$ITM_K_BTX_KR_JNL_FLUSH 1312
#define RTR$ITM_K_BTX_KR_ENQ1 1314
#define RTR$ITM_K_BTX_KR_ENQ_LAST 1316
#define RTR$ITM_K_BTX_KR_ENQS_RCVD 1318
#define RTR$ITM_K_BTX_KR_ENQS_DLVD 1320
#define RTR$ITM_K_BTX_KR_REPLIES 1322
#define RTR$ITM_K_BTX_KR_RSNSTS 1324
#define RTR$ITM_K_BTX_KR_INVCTN 1326
#define RTR$ITM_K_BTX_KR_ALL_ENQS_RCVD 1328
#define RTR$ITM_K_BTX_KR_CMT_SQ_NR 1330
#define RTR$ITM_K_BTX_KR_STATE 1332
#define RTR$ITM_K_BTX_KR_LINK_LOST 1334
#define RTR$ITM_K_BTX_RVY_KR_JNL_STATE 1336
#define RTR$ITM_K_BTX_RVY_KR_ENQ1 1338
#define RTR$ITM_K_BTX_RVY_KR_ENQS 1340
#define RTR$ITM_K_BTX_RVY_KR_STATE 1342
#define RTR$ITM_K_BTX_RVY_KR_RSNSTS 1344
#define RTR$ITM_K_BTX_RVY_KR_ID 1346
#define RTR$ITM_K_BTX_RVY_KR_CMT_SEQ_NR 1348
#define RTR$ITM_K_BTX_FRONTEND 1350
#define RTR$ITM_K_FTX_FACILITY 1538
#define RTR$ITM_K_FTX_FE_USER 1540
#define RTR$ITM_K_FTX_TX_ID 1542
#define RTR$ITM_K_FTX_TX_START_TIME 1544
#define RTR$ITM_K_FTX_STATE 1546
#define RTR$ITM_K_FTX_CHANNEL 1548
#define RTR$ITM_K_FTX_TX_WITH_TIMEOUT 1550
#define RTR$ITM_K_FTX_RQ_TX_NR 1552
#define RTR$ITM_K_FTX_NR_REPLIES 1554
#define RTR$ITM_K_FTX_ENQS_FROM_RQ 1556
#define RTR$ITM_K_FTX_ENQS_TO_TR 1558
#define RTR$ITM_K_FTX_ROUTER 1560
#define RTR$ITM_K_FTX_UNCERTAIN 1562
#define RTR$ITM_K_FTX_REPLAYED 1564
#define RTR$ITM_K_FTX_RSNSTS 1566
#define RTR$ITM_K_RTX_FACILITY 1794
#define RTR$ITM_K_RTX_FE_USER 1796
#define RTR$ITM_K_RTX_TX_ID 1798
#define RTR$ITM_K_RTX_TX_START_TIME 1800
#define RTR$ITM_K_RTX_STATE 1802
#define RTR$ITM_K_RTX_NR_KRS 1804
#define RTR$ITM_K_RTX_FRONTEND 1806
#define RTR$ITM_K_RTX_RSNSTS 1808
#define RTR$ITM_K_RTX_UNCERTAIN 1810
#define RTR$ITM_K_RTX_NR_TX_ENQS 1812
#define RTR$ITM_K_RTX_FGT_WT_SECS 1814
#define RTR$ITM_K_RTX_CRP_IN_PRG 1816
#define RTR$ITM_K_RTX_REPLAY_RQD 1818
#define RTR$ITM_K_RTX_DFD_RPL_RQD 1820
#define RTR$ITM_K_RTX_KR_BE 1822
#define RTR$ITM_K_RTX_KR_JNL_STATE 1824
#define RTR$ITM_K_RTX_KR_ID 1826
#define RTR$ITM_K_RTX_KR_ENQ1 1828
#define RTR$ITM_K_RTX_KR_ENQS 1830
#define RTR$ITM_K_RTX_KR_STATE 1832
#define RTR$ITM_K_RTX_KR_CMT_SQ_NR 1834
#define RTR$ITM_K_RTX_FE_CONNECTED 1836
#define RTR$ITM_K_BKR_FACILITY 2050
#define RTR$ITM_K_BKR_CUR_CMT_SEQ_NR 2052
#define RTR$ITM_K_BKR_LAST_RVY_BE 2054
#define RTR$ITM_K_BKR_LAST_SR_MSG_SECS 2056
#define RTR$ITM_K_BKR_FREE_SR_WAIT_SECS 2058
#define RTR$ITM_K_BKR_CSN_CHANGED 2060
#define RTR$ITM_K_BKR_WAIT_FREE_SR 2062
#define RTR$ITM_K_BKR_FREE_SERVERS 2064
#define RTR$ITM_K_BKR_ACTIVE_SERVERS 2066
#define RTR$ITM_K_BKR_KR_ID 2068
#define RTR$ITM_K_BKR_LAST_RVY_TX_STATE 2070
#define RTR$ITM_K_BKR_RVY_GET_TX_STATE 2072
#define RTR$ITM_K_BKR_NR_TXS_PRESENT 2074
#define RTR$ITM_K_BKR_KR_STATE 2076
#define RTR$ITM_K_BKR_RVY_TXS_THIS_BE 2078
#define RTR$ITM_K_BKR_RVY_NEXT_CTXT 2080
#define RTR$ITM_K_BEQ_FACILITY 2306
#define RTR$ITM_K_BEQ_FLAGS 2308
#define RTR$ITM_K_BEQ_STATE 2310
#define RTR$ITM_K_BEQ_NGTNS_EXPECTED 2312
#define RTR$ITM_K_BEQ_DEL_EVALS_PENDING 2314
#define RTR$ITM_K_BEQ_DEL_PROPS_PENDING 2316
#define RTR$ITM_K_BBV_FACILITY 2562
#define RTR$ITM_K_BBV_BE_ADDR 2564
#define RTR$ITM_K_BBV_BE_STATUS 2566
#define RTR$ITM_K_BBV_BE_ATTRIBUTE 2568
#define RTR$ITM_K_BTV_FACILITY 2818
#define RTR$ITM_K_BTV_TR_ADDR 2820
#define RTR$ITM_K_BTV_BE_STATUS 2822
#define RTR$ITM_K_BTV_BE_ATTRIBUTE 2824
#define RTR$ITM_K_BNE_FACILITY 3074
#define RTR$ITM_K_BNE_NODE 3076
#define RTR$ITM_K_BDR_FACILITY 3330
#define RTR$ITM_K_BDR_NODE 3332
#define RTR$ITM_K_BDR_VOTES_REQUIRED 3334
#define RTR$ITM_K_BDP_FACILITY 3586
#define RTR$ITM_K_BDP_PROPOSED 3588
#define RTR$ITM_K_BDP_PROPOSEE 3590

#pragma member_alignment restore
#endif /* VMS */
#pragma pack(1)
/*
 * File name:           Full file name:
 *  RTRTYPES.H            RTR - Types.
 *
 * Creation date:
 *  28-FEB-1991
 *
 * Purpose summary:
 *  Defines the necessary types required to write an RTR application.
 *
 * Revision date:       Revised by:     Revision summary:
 *  xx-xxx-xxxx
 *
 */

#if defined(MSDOS) && !defined(_WIN32)

/*
 * Defines some standard types for compatibility with
 * those defined by the V2 remote-client on MSDOS
 */

typedef unsigned char  boolean;
typedef unsigned char  byte;
typedef unsigned short word;
typedef rtr_uns_32_t   longword;

#endif /* #ifdef MSDOS */

/*
 * Defines RTR related types.
 */

struct RTR__TXSB
        {
          rtr_uns_32_t RTR_L_TXSB_STATUS; /* RTR status, always passed back. */
          union
          {
            rtr_uns_32_t RTR_L_TXSB_DATLEN;
            /* Data length, passed back to DEQ if STATUS success. */
            rtr_uns_32_t RTR_L_TXSB_FACID;
            /* Facility id, passed back on DCL_TX_PRC.            */
            rtr_uns_32_t RTR_L_TXSB_COMMITMSK;
            /* On tx commit - contains or'ed commit rsnsts msk.   */
            rtr_uns_32_t RTR_L_TXSB_RSNSTS;
            /* On transaction abort, abort status/reason.         */
          } RTR_R_DATLEN_FACID_OVERLAY;
          rtr_uns_32_t RTR_Q_TXSB_TXID[2];
          /* Transaction id. always passed back to remote client handler.    */
          /* For requesters only passed back on commit/abort  */
          /* or if tx aborts unsolicited.                     */
        };

typedef struct RTR__TXSB    RTR__TXSB;


struct RTR__ACCESS
        {
          rtr_uns_16_t  RTR_W_ACCESS_LENGTH;
          /* Byte length of access string. */
          rtr_uns_16_t  RTR_W_ACCESS_TYPE;
          /* Must be set to RTR_K_ACCESS_TYPE_PASSWORD. */
          char _far *RTR_A_ACCESS_ACCADR;
          /* Address of access string. */
        };

typedef struct RTR__ACCESS	RTR__ACCESS;


/* The following definitions are used to create the "datpar"                  */
/* argument on calls to "RTR_DCL_TX_PRC" when declaring server                */
/* and (optionally) requester channels.                                       */
/*                                                                            */
/* The "datpar" argument specifies the position, length and data type         */
/* of the routing key within the messages sent from requesters to             */
/* servers. This specification is optional for requesters but, if             */
/* supplied, must match the key specification of the servers in that          */
/* facility.                                                                  */
/*                                                                            */
/* The "datpar" argument is similar to an item list and consists              */
/* of a zero terminated list of elements of type "RTR__DATPAR_ELEM"           */
/* If the key has only one segment then only one "RTR__DATPAR_ELEM"           */
/* (followed by a zero Longword of zero) need be defined. If a "split"        */
/* key (i.e. more than one segment) is to be used than the datpar has         */
/* to contain the corresponding number of "RTR__DATPAR_ELEM" elements         */
/* followed by a Longword of zero.                                            */
/*                                                                            */
/* In high level languages this is best achieved by declaring an array        */
/* of elements of type "RTR__DATPAR_ELEM" with one more element than          */
/* there are key segments. Initialize the first long Word of of the           */
/* last element to zero and the remaining elements to  contain                */
/* the required key/boundary specification.                                   */
/*                                                                            */
/* The structure of an "RTR__DATPAR_ELEM" element is described below.         */
/* Use of the symbolic offsets is however recommended.                        */
/*                                                                            */
/* .---------------------------------------------------------------.          */
/* |                     rtr_l_datpar_key_dtyp                     | 0        */
/* |---------------------------------------------------------------|          */
/* |                     rtr_l_datpar_key_len                      | 4        */
/* |---------------------------------------------------------------|          */
/* |                     rtr_l_datpar_key_off                      | 8        */
/* |---------------------------------------------------------------|        */
/* |                      rtr$a_datpar_lo_bnd                      | 12     */
/* |---------------------------------------------------------------|        */
/* |                      rtr$a_datpar_hi_bnd                      | 16     */
/* |---------------------------------------------------------------|          */
/*                                                                            */
/* rtr_l_datpar_key_dtyp                                                      */
/*                                                                            */
/*   Data type of key segment can take one of the following values:           */
/*                                                                            */
/*      DSC_K_DTYPE_BU (=2)    Unsigned byte                                  */
/*      DSC_K_DTYPE_WU (=3)    Unsigned Word                                  */
/*      DSC_K_DTYPE_LU (=4)    Unsigned long                                  */
/*      DSC_K_DTYPE_B  (=6)    Signed byte                                    */
/*      DSC_K_DTYPE_W  (=7)    Signed Word                                    */
/*      DSC_K_DTYPE_L  (=8)    Signed long                                    */
/*      DSC_K_DTYPE_Q  (=9)    Signed quad                                    */
/*      DSC_K_DTYPE_T (=14)    String                                         */
/*      DSC_K_DTYPE_P (=21)    Packed decimal                                 */
/*                                                                            */
/*                                                                            */
/* rtr_l_datpar_key_len                                                       */
/*                                                                            */
/*   Length of key segment in $enq_tx buffer. In bytes for all key types      */
/*   except DSC_K_DTYPE_P which uses nibbles (half bytes).                    */
/*                                                                            */
/* rtr_l_datpar_key_off                                                       */
/*                                                                            */
/*   Offset of key segment within $enq_tx buffer in bytes                     */
/*                                                                            */

struct RTR__DATPAR_ELEM
        {
          rtr_uns_32_t RTR_L_DATPAR_KEY_DTYP;
          /* Data type of key segment = DSC_K_DTYPE_xxx. */
          rtr_uns_32_t RTR_L_DATPAR_KEY_LEN;
          /* Length of key segment in $ENQ_TX buffer.    */
          rtr_uns_32_t RTR_L_DATPAR_KEY_OFF;
          /* Offset of key segment wihin $ENQ_TX buffer. */
	  char *RTR_A_DATPAR_LO_BND;
	  /* Address of key range low bound   */
	  char *RTR_A_DATPAR_HI_BND;
	  /* Address of key range high bound  */
        };

typedef struct RTR__DATPAR_ELEM	    RTR__DATPAR_ELEM;

struct RTR__EVT
        {
          rtr_uns_32_t RTR_L_EVT_ARGNO;
          /* No of arg in argument array.               */
          rtr_uns_32_t RTR_L_EVT_STATUS;
          /* Event status field.                        */
          rtr_uns_32_t RTR_L_EVT_EVTNO;
          /* The event no.                              */
          rtr_uns_16_t     RTR_W_EVT_CH;
          /* The channel on which the event occured.    */
          rtr_uns_16_t     RTR_W_EVT_SPAREW;
          rtr_uns_32_t RTR_L_EVT_FACID;
          /* Facility id for fac. where event occured.  */
          rtr_uns_32_t RTR_L_EVT_BUFLEN;
          /* Long arg-list only, message buffer length. */
          rtr_uns_8_t _far *RTR_L_EVT_BUFADR;
          /* Address of the buffer.                     */
        };

typedef struct RTR__EVT	    RTR__EVT;


struct RTR__EVTMSK_FLAGS_TYPE1 {
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_BRDCST : 1;   /* brdcst bit.                       */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF1 : 1;  /* user defined event no 1           */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF2 : 1;  /* user defined event no 2           */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF3 : 1;  /* user defined event no 3           */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF4 : 1;  /* user defined event no 4           */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF5 : 1;  /* user defined event no 5           */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF6 : 1;  /* user defined event no 6           */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF7 : 1;  /* user defined event no 7           */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF8 : 1;  /* user defined event no 8           */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF9 : 1;  /* user defined event no 9           */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF10 : 1; /* user defined event no 10          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF11 : 1; /* user defined event no 11          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF12 : 1; /* user defined event no 12          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF13 : 1; /* user defined event no 13          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF14 : 1; /* user defined event no 14          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF15 : 1; /* user defined event no 15          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF16 : 1; /* user defined event no 16          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF17 : 1; /* user defined event no 17          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF18 : 1; /* user defined event no 18          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF19 : 1; /* user defined event no 19          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF20 : 1; /* user defined event no 20          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF21 : 1; /* user defined event no 21          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF22 : 1; /* user defined event no 22          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF23 : 1; /* user defined event no 23          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF24 : 1; /* user defined event no 24          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF25 : 1; /* user defined event no 25          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF26 : 1; /* user defined event no 26          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF27 : 1; /* user defined event no 27          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF28 : 1; /* user defined event no 28          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF29 : 1; /* user defined event no 29          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF30 : 1; /* user defined event no 30          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF31 : 1; /* user defined event no 31          */
    };

struct RTR__EVTMSK_FLAGS_TYPE2 {
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF32 : 1; /* user defined event no 32          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF33 : 1; /* user defined event no 33          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF34 : 1; /* user defined event no 34          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF35 : 1; /* user defined event no 35          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF36 : 1; /* user defined event no 36          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF37 : 1; /* user defined event no 37          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF38 : 1; /* user defined event no 38          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF39 : 1; /* user defined event no 39          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF40 : 1; /* user defined event no 40          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF41 : 1; /* user defined event no 41          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF42 : 1; /* user defined event no 42          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF43 : 1; /* user defined event no 43          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF44 : 1; /* user defined event no 44          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF45 : 1; /* user defined event no 45          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF46 : 1; /* user defined event no 46          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF47 : 1; /* user defined event no 47          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF48 : 1; /* user defined event no 48          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF49 : 1; /* user defined event no 49          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF50 : 1; /* user defined event no 50          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF51 : 1; /* user defined event no 51          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF52 : 1; /* user defined event no 52          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF53 : 1; /* user defined event no 53          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF54 : 1; /* user defined event no 54          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF55 : 1; /* user defined event no 55          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF56 : 1; /* user defined event no 56          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF57 : 1; /* user defined event no 57          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF58 : 1; /* user defined event no 58          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF59 : 1; /* user defined event no 59          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF60 : 1; /* user defined event no 60          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF61 : 1; /* user defined event no 61          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF62 : 1; /* user defined event no 62          */
    RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_USRDEF63 : 1; /* user defined event no 63          */
    };

struct RTR__EVTMSK_TYPE2_MASK {
    struct RTR__EVTMSK_FLAGS_TYPE1 RTR_L_EVTMSK_TYPE1_FLAGS;
    struct RTR__EVTMSK_FLAGS_TYPE2 RTR_L_EVTMSK_TYPE2_FLAGS;
    struct  {
        rtr_sgn_32_t RTR_V_FIRST_RTR_DEFINED ;
        } RTR_R_FIRST_RTR_DEFINED_BITS;
    struct  {
        RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_FACREADY : 1;
        /* The facility has become operational */
        RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_FACDEAD : 1;
        /* The facility has broken down  */
        RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_FERTRGAIN : 1;
        /* FE link to current router established */
        RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_FERTRLOSS : 1;
        /* FE link to current router lost */
        RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_RTRBEGAIN : 1;
        /* Current router established link to a BE */
        RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_RTRBELOSS : 1;
        /* Current router lost link to a BE */
        RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_KEYRANGEGAIN : 1;
        /* Server(s) for new key range available */
        RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_KEYRANGELOSS : 1;
        /* No more servers left for a particular key range */
        RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_BERTRGAIN : 1;
        /* BE established link to a router */
        RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_BERTRLOSS : 1;
        /* BE lost link to a router    */
        RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_RTRFEGAIN : 1;
        /* Router established link to an FE */
        RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_RTRFELOSS : 1;
        /* Router lost link to an FE   */
        RTR_SGN_BITFIELD_TYPE RTR_V_SREVENTS : 7;
        RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_RCRCHGAIN : 1;
        /* Remote Client established link to RCH */
        RTR_SGN_BITFIELD_TYPE RTR_V_EVTMSK_RCRCHLOSS : 1;
        /* Remote Client lost link to RCH */
        RTR_SGN_BITFIELD_TYPE RTR_V_MORE_RTR_DEFINED : 12;
        } RTR_R_MORE_RTR_DEFINED_BITS;
    };

union RTR__EVTMSK
    {
    struct  { /* evtmsk type 1,quad word, mask in 2'nd longword */
        rtr_uns_32_t RTR_L_EVTMSK_MBZ;
        /* NOTE: first long must be zero to indicate mask type 1 */
        struct RTR__EVTMSK_FLAGS_TYPE1 RTR_L_EVTMSK_MASK;
        /* mask type 1 bits */
        } RTR_R_EVTMSK_TYPE1;
    struct  { /*evtmsk type 2, descriptor type    */
        rtr_uns_16_t RTR_W_EVTMSK_LEN;
        /* len of bitmask in bytes, max rtr_evt_k_maxmsklen  */
        rtr_uns_16_t RTR_W_RESERV;
        struct RTR__EVTMSK_TYPE2_MASK _far *RTR_A_EVTMSK_EVTADR;
        /* bitmask  address - max 8*rtr_evt_k_maxmsklen bits */
        } RTR_R_EVTMSK_TYPE2;
    };

typedef union RTR__EVTMSK	RTR__EVTMSK ;



/******************************************************************************/
/* Copyright Digital Equipment Corporation 1993. All rights reserved.         */
/*                                                                            */
/* Restricted Rights: Use, duplication, or disclosure by the U.S. Government  */
/* is subject to restrictions as set forth in subparagraph (c) (1) (ii) of    */
/* DFARS 252.227-7013, or in FAR 52.227-19, or in FAR 52.227=14 Alt. III, as  */
/* applicable.                                                                */
/*                                                                            */
/* This software is proprietary to and embodies the confidential technology   */
/* of Digital Equipment Corporation. Possession, use, or copying of this      */
/* software and media is authorized only pursuant to a valid written license  */
/* from Digital or an authorized sublicensor.                                 */
/******************************************************************************/

#ifndef RTR_SUPPORT
#define RTR_SUPPORT 1

/*
 * File name:           Full file name:
 *  RTRSUPP.H        	 RTR - Support for VAX RTR.
 *
 * Creation date:
 *  25-SEP-1990
 *
 * Purpose summary:
 *  Some definitions to do migration easier from VAX/RTR to ULTRIX/RTR
 *  requester.
 *
 * Revision date:       Revised by:     Revision summary:
 *  xx-SEP-1990
 *
 */

/* Some constant definitions. */

#define SS__NORMAL      1
#define RTR__SUCCESS	(rtr_uns_32_t)0
#define DSC_K_DTYPE_BU  2
#define DSC_K_DTYPE_WU  3
#define DSC_K_DTYPE_LU  4
#define DSC_K_DTYPE_QU  5
#define DSC_K_DTYPE_B   6
#define DSC_K_DTYPE_W   7
#define DSC_K_DTYPE_L   8
#define DSC_K_DTYPE_Q   9
#define DSC_K_DTYPE_T  14
#define DSC_K_DTYPE_P  21

#endif /* #ifndef RTR_SUPPORT */
/******************************************************************************/
/* Copyright Digital Equipment Corporation 1993. All rights reserved.         */
/*                                                                            */
/* Restricted Rights: Use, duplication, or disclosure by the U.S. Government  */
/* is subject to restrictions as set forth in subparagraph (c) (1) (ii) of    */
/* DFARS 252.227-7013, or in FAR 52.227-19, or in FAR 52.227=14 Alt. III, as  */
/* applicable.                                                                */
/*                                                                            */
/* This software is proprietary to and embodies the confidential technology   */
/* of Digital Equipment Corporation. Possession, use, or copying of this      */
/* software and media is authorized only pursuant to a valid written license  */
/* from Digital or an authorized sublicensor.                                 */
/******************************************************************************/

#ifndef RTR_ERROR
#define RTR_ERROR 1

/*
 * File name:            Full file name:
 *  RTRERROR.H            RTR - Errors
 *
 * Creation date:        Created by:
 *  28-FEB-1991
 *
 * Purpose summary:
 *  Defines RTR function modifiers, condition values & mask. Part of the RTR/VAX
 *  RTR.H file.
 *
 * Required includes:
 *
 * Compilation & link:
 *
 * Revision date:       Revised by:     Revision summary:
 *  xx-xxx-xxxx
 *
 */

/********************************************************************************************************************************/
/* Created 28-SEP-1990 02:50:28 by VAX SDL V3.2-12     Source: 28-SEP-1990 01:09:00 RTR$BUILD_ROOT:[LIB.BLDRTRTMP]RTRMSGTMP.SDL;3 */
/********************************************************************************************************************************/

/*** MODULE $RTRMSGDEF ***/
/*                                                                          */
/* This SDL File Generated by VAX-11 Message V04-00 on 28-SEP-1990 01:08:38.16 */
/*                                                                          */
/* COPYRIGHT (C) 1988 BY                                                    */
/* DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.                   */
/* ALL RIGHTS RESERVED.                                                     */
/*                                                                          */
/* THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED    */
/* ONLY  IN  ACCORDANCE  OF  THE  TERMS  OF  SUCH  LICENSE  AND WITH THE    */
/* INCLUSION OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY  OTHER    */
/* COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY    */
/* OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY    */
/* TRANSFERRED.                                                             */
/*                                                                          */
/* THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE    */
/* AND  SHOULD  NOT  BE  CONSTRUED  AS A COMMITMENT BY DIGITAL EQUIPMENT    */
/* CORPORATION.                                                             */
/*                                                                          */
/* DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS    */
/* SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.                  */
/*                                                                          */
/*                                                                          */
/* FACILITY : RTR SYSTEM SERVICES MESSAGES.                                 */
/*                                                                          */
/* ABSTRACT : MESSAGE DEFINITIONS FOR RTR SYSTEM SERVICES.                  */
/*                                                                          */
/* AUTHOR   : MICHAEL HOHWY.                                                */
/*                                                                          */
/* CREATED  : 8-DEC-1988                                                    */
/*                                                                          */
/*                                                                          */
/* FILE RT$RTRDEF.MSG CONTAINS RTR MESSAGES EXPORTED                        */
/* (AND USED) BY THE RTR SYSTEM SERVICE CODE -                              */
/* INTO THE FINAL RTRMSG FILE. THE FILE IS A PART                           */
/* OF THE ENTIRE RTR MSG SYSTEM, INCLUDING MSG'S                            */
/* EXPORTED BY OTHER RTR SUB-SYSTEMS.                                       */
/* THE .END (ETC) DIRECTIVE IS CONTAINED IN ANOTHER FILE.                   */
#define RTR__FACILITY 11
/*                                                                          */
/* %SYSTEM_SERVICE, OBSOLETE                                                */
/*                                                                          */
#define RTR__NOSERVCHAN 753674
/*                                                                          */
/* %SYSTEM_SERVICE, OBSOLETE                                                */
/*                                                                          */
#define RTR__NOREQCHAN 753682
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/* THE CHANNEL SUPPLIED FOR TRANSACTION OPERATIONS                          */
/* HAS NOT BEEN DECLARED. USE THE SYSTEM SERVICE                            */
/* $DCL_TX_PRC TO DECLARE CHANNEL BEFORE ATTEMPTING                         */
/* TRANSACTION OPERATIONS. ALTERNATIVELY, CHECK TO                          */
/* SEE IF CHANNEL HAS BEEN SHUTDOWN BY USING THE                            */
/* SHUTDOWN OPTION FOR $DCL_TX_PRC.                                         */
/*                                                                          */
#define RTR__CHNOTALLOC 753690
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* THE OPERATION REQUESTED REQUIRES THAT A TRANSACTION                      */
/* IS PRESENTLY ACTIVE ON SPECIFIED CHANNEL. A TRANSACTION                  */
/* BECOMES ACTIVE ON A CHANNEL WHEN (IN THE CASE OF A                       */
/* REQUESTER) A $START_TX IS ISSUED ON THE CHANNEL,                         */
/* TERMINATING SUCCESSFULLY.                                                */
/* FOR A SERVER CHANNEL THE TRANSITION TO ACTIVE HAPPENS                    */
/* WHEN A $DEQ_TX TERMINATES WITH AN RTR$_STARTTX                           */
/* STATUS. A TRANSACTION STOPS BEING ACTIVE WHEN IT IS                      */
/* EITHER ABORTED, COMMITTED (IN THE CASE OF A REQUESTER)                   */
/* OR THE $VOTE_TX (IN THE CASE OF A SERVER) SYSTEM                         */
/* SERVICE TERMINATES.                                                      */
/*                                                                          */
#define RTR__CHNOTACTIVE 753698
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* OPERATION SPECIFIED NOT VALID ON CHANNEL WITH ACTIVE                     */
/* TRANSACTION RUNNING.A TRANSACTION                                        */
/* BECOMES ACTIVE ON A CHANNEL WHEN (IN THE CASE OF A                       */
/* REQUESTER) A $START_TX IS ISSUED ON THE CHANNEL,                         */
/* TERMINATING SUCCESSFULLY.                                                */
/* FOR A SERVER CHANNEL THE TRANSITION TO ACTIVE HAPPENS                    */
/* WHEN A $DEQ_TX TERMINATES WITH AN RTR$_STARTTX                           */
/* STATUS. A TRANSACTION STOPS BEING ACTIVE WHEN IT IS                      */
/* EITHER ABORTED, COMMITTED (IN THE CASE OF A REQUESTER)                   */
/* OR THE $VOTE_TX (IN THE CASE OF A SERVER) SYSTEM                         */
/* SERVICE TERMINATES.                                                      */
/*                                                                          */
#define RTR__CHACTIVE 753706
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* A $DCL_TX_PRC SYSTEM SERVICE MUST BE CALLED PRIOR                        */
/* TO AND TERMINATE SUCCESSFULLY BEFORE ANY OTHER                           */
/* RTR OPERATION CAN BE EXECUTED.                                           */
/*                                                                          */
#define RTR__RTRNOTDECL 753714
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* OPERATION SPECIFIED ONLY VALID IN THE CONTEXT OF AN ACTIVE               */
/* TRANSACTION. A TRANSACTION BECOMES ACTIVE ON A CHANNEL                   */
/* WHEN (IN THE CASE OF A REQUESTER) A $START_TX IS ISSUED                  */
/* ON THE CHANNEL, TERMINATING SUCCESSFULLY.                                */
/* FOR A SERVER CHANNEL THE TRANSITION TO ACTIVE HAPPENS                    */
/* WHEN A $DEQ_TX TERMINATES WITH AN RTR$_STARTTX                           */
/* STATUS. A TRANSACTION STOPS BEING ACTIVE WHEN IT IS                      */
/* EITHER ABORTED, COMMITTED (IN THE CASE OF A REQUESTER)                   */
/* OR THE $VOTE_TX (IN THE CASE OF A SERVER) SYSTEM                         */
/* SERVICE TERMINATES.                                                      */
#define RTR__TXNOTACTIVE 753722
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* A $ABORT_TX SYSTEM SERVICE IS STILL IN PROGRESS                          */
/* FOR THE CHANNEL SPECIFIED. FURTHER OPERATIONS ON CHANNEL                 */
/* MUST AWAIT TERMINATION OF $ABORT_TX SYSTEM                               */
/* SERVICE.                                                                 */
/*                                                                          */
#define RTR__ABORTINPROG 753730
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* A $COMMIT_TX SYSTEM SERVICE IS STILL IN PROGRESS                         */
/* FOR THE CHANNEL SPECIFIED. FURTHER OPERATIONS ON CHANNEL                 */
/* MUST AWAIT TERMINATION OF $COMMIT_TX SYSTEM                              */
/* SERVICE.                                                                 */
/*                                                                          */
#define RTR__COMMITINPROG 753738
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* A $VOTE_TX SYSTEM SERVICE IS STILL IN PROGRESS                           */
/* FOR THE CHANNEL SPECIFIED. FURTHER OPERATIONS ON CHANNEL                 */
/* MUST AWAIT TERMINATION OF $VOTE_TX SYSTEM                                */
/* SERVICE.                                                                 */
/*                                                                          */
#define RTR__2PCINPROG 753746
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* A $VOTE_TX SYSTEM SERVICE CANNOT BE ISSUED                               */
/* FOR THE CHANNEL SPECIFIED. THE $VOTE_TX SYSTEM SERVICE                   */
/* CAN ONLY BE ISSUED FOR A TRANSACTION WHICH HAS ENTERED                   */
/* PHASE 1 OF THE TWO PHASE COMMIT. THIS TRANSITION TAKES PLACE             */
/* WHEN A $DEQ_TX IS TERMINATED WITH AN RTR$_VOTETX STATUS.                 */
#define RTR__2PCNOTINPROG 753754
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* A $VOTE_TX SYSTEM SERVICE CANNOT BE ISSUED                               */
/* FOR THE CHANNEL SPECIFIED. THE $VOTE_TX SYSTEM SERVICE                   */
/* CAN ONLY BE ISSUED FOR A TRANSACTION WHICH IS IN                         */
/* PHASE 1 OF THE TWO PHASE COMMIT (2PC). THIS PHASE STARTS                 */
/* WHEN A $DEQ_TX IS TERMINATED WITH AN RTR$_VOTETX STATUS.                 */
/* PHASE 1 OF THE 2PC ENDS WHEN A $VOTE_TX IS ISSUED. THIS                  */
/* STARTS THE PHASE 2 OF THE 2PC - THE SO-CALLED UNCERTAINTY                */
/* PERIOD. UNTIL THE $VOTE_TX TERMINATES NO OTHER SYSTEM                    */
/* SERVICE CAN BE ISSUED FOR THIS TRANSACTION.                              */
#define RTR__2PCUNCERTAIN 753762
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* AT THE TIME OF THE OPERATION ATTEMPTED A MESSAGE WAS                     */
/* FOUND OUTSTANDING INTENDED FOR DELIVERY TO THE                           */
/* APPLICATION PROGRAM. THIS MESSAGE MUST BE READ BY THE                    */
/* APPLICATION BY ISSUING A $DEQ_TX SYSTEM SERVICE.                         */
/*                                                                          */
#define RTR__MSGPEND 753770
/*                                                                          */
/* %SYSTEM_SERVICE, TXSB_STATUS                                             */
/*                                                                          */
/* BUFFER SUPPLIED BY THE USER WAS TOO SMALL TO HOLD                        */
/* MESSAGE RECEIVED. THE MESSAGE WAS TRUNCATED TO FIT                       */
/* INTO BUFFER. CHECK IF APPLICATION OBSERVES PROTOCOL                      */
/* AGREED TO BETWEEN REQUESTER/SERVER.                                      */
/*                                                                          */
#define RTR__TRUNCATE 753778
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* AN INVALID NUMBER OF PARAMETERS HAVE BEEN SPECIFIED                      */
/* IN CALL TO SYSTEM SERVICE.                                               */
/*                                                                          */
#define RTR__INVPARNO 753786
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* AN INVALID CHANNEL NUMBER HAS BEEN SUPPLIED. CHECK                       */
/* RTR APPLICATION WRITERS MANUAL FOR VALID RANGE OF                        */
/* CHANNEL NUMBERS SUPPORTED BY PRESENT RTR RELEASE.                        */
/*                                                                          */
#define RTR__INVALCH 753794
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* ACCESS PARAMETER PROVIDED IS ILLEGAL. CHECK FOR EITHER                   */
/* NULL ACCESS POINTER, OR NULL LENGTH SPECIFIED IN                         */
/* DESCRIPTOR POINTING TO ACCESS PROPER.                                    */
/*                                                                          */
#define RTR__INVACCESS 753802
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* FACNAM PARAMETER PROVIDED IS ILLEGAL. CHECK FOR EITHER                   */
/* NULL FACNAM POINTER, OR NULL LENGTH SPECIFIED IN                         */
/* DESCRIPTOR POINTING TO FACNAM PROPER.                                    */
/*                                                                          */
#define RTR__INVFACNAM 753810
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* INVALID DATPAR ARGUMENT SUPPLIED. CHECK FOR NULL DATPAR                  */
/* POINTER.                                                                 */
/*                                                                          */
#define RTR__INVDATPAR 753818
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* NULL BUFADR OR BUFLEN ARGUMENT SUPPLIED.                                 */
/*                                                                          */
#define RTR__INVBUF 753826
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* BUFLEN PARAMETER TO LARGE. CHECK RTR APPLICATION WRITER'S                */
/* MANUAL FOR LARGEST BUFFERLENGTH SUPPORTED BY CURRENT VERSION             */
/* OF RTR.                                                                  */
#define RTR__INVBUFLEN 753834
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* INVALID EVTMSK ARGUMENT SUPPLIED. SUPPLIED LENGTH                        */
/* EXCEEDS MAXIMUM LENGTH SUPPORTED BY PRESENT VERSION                      */
/* OF RTR.                                                                  */
/*                                                                          */
#define RTR__INVEVTMSK 753842
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* ADDRESS OF EVTAST SPECIFIED CANNOT BE USED AS ENTRY ADDRESS              */
/* OF ROUTINE.                                                              */
#define RTR__INVEVTAST 753850
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* AN UNDEFINED FLAG WAS SET, OR AN ILLEGAL FLAG                            */
/* COMBINATION WAS SPECIFIED IN THE FLAGS ARGUMENT. CHECK                   */
/* RTR APPLICATIONS WRITERS MANUAL FOR VALID FLAG BITS AND                  */
/* LEGAL FLAG COMBINATIONS FOR SERVICE IN QUESTION.                         */
/*                                                                          */
#define RTR__BADFLAG 753858
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* THE PRESENT RELEASE OF THE RTR DOES NOT SUPPORT THE FLAG                 */
/* SPECIFIED.                                                               */
/*                                                                          */
#define RTR__FLGNOTSUP 753866
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* FOR PRESENT VERSION OF RTR THERE ARE RESTRICTIONS TO                     */
/* WHICH TYPES OF ACCESS CAN BE USED. AT PRESENT ONLY                       */
/* TYPE SUPPORTED IS PASSWORD.                                              */
/*                                                                          */
#define RTR__ACCNOTSUP 753874
/*                                                                          */
/* %SYSTEM_SERVICE, TXSB_STATUS                                             */
/*                                                                          */
/* THE ONGOING TRANSACTION HAS BEEN ABORTED DUE TO                          */
/* EXHAUSTION OF RTR MEMORY CACHE. THIS ERROR CODE                          */
/* INDICATES A CONGESTION STATE OF RTR DUE TO                               */
/* OPERATIONAL OVERLOAD. CHECK IF FAULTY APPLICATIONS                       */
/* ATTEMPT ISSUING ABNORMALLY LARGE TRANSACTIONS                            */
/* OR ISSUES TRANSACTIONS AT AN ABNORMALLY HIGH RATE.                       */
/*                                                                          */
#define RTR__CHCQUOEXD 753882
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* THE NUMBER OF CHANNELS DECLARED EXCEEDS MAX. NUMBER                      */
/* OF CHANNELS (PER APPLICATION PROGRAM) SUPPORTED BY                       */
/* PRESENT RTR RELEASE.                                                     */
/*                                                                          */
#define RTR__CCBEXHAUST 753890
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* THE OPERATION ATTEMPTED IS NOT VALID ON A CHANNEL OF                     */
/* THIS TYPE. CHECK YOUR CHANNEL TYPE FOR REQUESTER OR                      */
/* SERVER, COMPARE THIS TO OPERATION ATTEMPTED.                             */
/*                                                                          */
#define RTR__OPERNOTVALID 753898
/*                                                                          */
/* %SYSTEM_SERVICE, TXSB_STATUS                                             */
/*                                                                          */
/* UPON TERMINATION OF A COMMIT_TX A NON-TERMINATED                         */
/* DEQ_TX SYSTEM SERVICE WAS FOUND. BOTH OUTSTANDING                        */
/* SYSTEM SERVICES WILL BE TERMINATED WITH                                  */
/* RTR__NONTRMDEQCOM STATUS CODE. CHECK IF APPLICATION                      */
/* PROGRAM OBSERVES PROTOCOL AGREED BETWEEN SERVER AND                      */
/* REQUESTER PROGRAMS.                                                      */
/*                                                                          */
#define RTR__NONTRMDEQCOM 753906
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
#define RTR__NONTRMTXSDWN 753914
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* UPON SHUTDOWN AN OUTSTANDING - I.E. NOT YET DELIVERED - EVENT            */
/* WAS ENCOUNTERED. WAIT FOR EVENT TO BE DELIVERED AND REPEAT               */
/* SHUTDOWN OPERATION.                                                      */
#define RTR__OUTSTEVTSDWN 753922
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* RTR MEMORY CACHE EXHAUSTION.                                             */
/*                                                                          */
#define RTR__CACHEXHAU 753930
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* THE PROCESS AST LIMIT HAS BEEN EXCEEDED.                                 */
#define RTR__EXASTLIM 753938
/*                                                                          */
/* %SYSTEM_SERVICE, R0, TXSB_STATUS                                         */
/*                                                                          */
/* UPON RETURN FROM A USER SPECIFIED EVTAST THE STACK WAS                   */
/* FOUND TO BE CORRUPTED. CHECK EVTAST'S STACK USE.                         */
#define RTR__INVALSTCK 753946
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* THE RTRACP PROCESS HAS DIED. NO FURTHER RTR SYSTEM                       */
/* SERVICE ACTIVITY WILL BE ALLOWED. RESTART RTRACP                         */
/* AND APPLICATION PROGRAM.                                                 */
/*                                                                          */
#define RTR__NOACP 753954
/*                                                                          */
/* %SYSTEM_SERVICE, TXSB_STATUS                                             */
/*                                                                          */
/* TRANSACTION ABORTED, CHECK TXSB FIELD RTR$L_TXSB_RSNSTS                  */
/* FOR ADDITIONAL STATUS CODE.                                              */
#define RTR__ABORT 753960
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* THE CHANNEL SPECIFIED FOR THE OPERATION HAS GOT                          */
/* NON-TERMINATED DCL_TX_PRC OUTSTANDING ON IT.                             */
/* DCL_TX_PRC MUST TERMINATE PRIOR TO ANY OTHER                             */
/* RTR OPERATIONS ON SPECIFIED CHANNEL.                                     */
/*                                                                          */
#define RTR__DCLNOTTERM 753968
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* RTR SYSTEM SERVICE NOT SUPPORTED BY PRESENT VERSION                      */
/* OF RTR.                                                                  */
/*                                                                          */
#define RTR__SERVNOTSUP 753976
/*                                                                          */
/* %SYSTEM_SERVICE, TXSB_STATUS, TXSB_RSNSTS                                */
/*                                                                          */
/* A $DEQ_TX SYSTEM SERVICE WAS FOUND OUTSTANDING AT CHANNEL                */
/* SHUTDOWN, SERVICE TERMINATED.                                            */
/* ALSO RETURNED IN TXSB FIELD RTR$L_TXSB_RSNSTS TO INDICATE                */
/* THAT AN OUTSTANDING TRANSACTION WAS ABORTED DURING CHANNEL               */
/* SHUTDOWN.                                                                */
#define RTR__SHUTDOWN 753984
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* AN ABORT_TX SYSTEM SERVICE HAS BEEN TERMINATED                           */
/* SYNCHRONOUSLY. THIS HAPPENS WHEN NO OTHER PARTS OF                       */
/* THE RTR SYSTEM HAD TO BECOME INVOLVED IN THE ABORT                       */
/* PROCESSING. THIS HAPPENS IF THE TRANSACTION HAS BEEN                     */
/* STARTED WITH A START_TX (NO TIMEOUT SPECIFIED) AND                       */
/* THE ABORT_TX WAS ISSUED BEFORE ANY OTHER                                 */
/* TRANSACTION OPERATIONS ON THAT PARTICULAR CHANNEL.                       */
/*                                                                          */
#define RTR__SYNCHABORT 753995
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* A COMMIT_TX SYSTEM SERVICE HAS BEEN TERMINATED                           */
/* SYNCHRONOUSLY. THIS HAPPENS WHEN NO OTHER PARTS OF                       */
/* THE RTR SYSTEM HAD TO BECOME INVOLVED IN THE COMMIT                      */
/* PROCESSING. THIS HAPPENS IF THE TRANSACTION HAS BEEN                     */
/* STARTED WITH A START_TX (NO TIMEOUT SPECIFIED) AND                       */
/* THE COMMIT_TX WAS ISSUED BEFORE ANY OTHER                                */
/* TRANSACTION OPERATIONS ON THAT PARTICULAR CHANNEL.                       */
/*                                                                          */
#define RTR__SYNCHCOMM 754003
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* THE ONGOING TRANSACTION WAS ABORTED DUE TO A PENDING                     */
/* ABORT OPERATION. CHECK TXSB STATUS/RSNSTS FIELDS FOR                     */
/* MORE INFORMATION ON CAUSE OF ABORT.                                      */
/*                                                                          */
#define RTR__ABORTPEND 754011
/*                                                                          */
/* %SYSTEM_SERVICE, UNDOCUMENTED                                            */
/*                                                                          */
/* UPON TERMINATION OF A $COMMIT_TX, A NON-TERMINATED SERVICE WAS FOUND. THE */
/* TRANSACTION WILL BE COMITTED AND THE SYSTEM SERVICE WILL BE TERMINATED. CHECK */
/* IF APPLICATION PROGRAM OBSERVES PROTOCOL AGREED BETWEEN SERVER AND REQUESTER */
/* PROGRAMS.                                                                */
/*                                                                          */
#define RTR__NONTRMSRVCOM 754019
/*                                                                          */
/* %SYSTEM_SERVICE, TXSB_STATUS                                             */
/*                                                                          */
/* UPON TERMINATION OF A COMMIT_TX AN UNDELIVERED MESSAGE WAS FOUND. THE    */
/* TRANACTION WILL BE COMITTED BUT THE MESSAGE IS DISCARDED.  CHECK IF      */
/* APPLICATION PROGRAM OBSERVES PROTOCOL AGREED BETWEEN SERVER AND REQUESTER */
/* PROGRAMS, SINCE THIS ERROR INDICATES THAT THE REQUESTER DID NOT ISSUE ENOUGH  */
/* $DEQ_TX CALLS BEFORE COMMITTING THE TRANSACTION.                         */
/*                                                                          */
#define RTR__NONDEQMSGCOM 754027
/*                                                                          */
/* %SYSTEM_SERVICE, TXSB_STATUS                                             */
/*                                                                          */
/* TERMINATION STATUS OF A VOTE_TX SYSTEM SERVICE                           */
/* INDICATING THAT THE TRANSACTION IS TO BE COMMITTED.                      */
/* THE APPLICATION IS NOW RESPONSIBLE FOR COMMITTING                        */
/* CHANGES INCURRED TO THE DATABASE.                                        */
/*                                                                          */
#define RTR__COMMIT 754033
/*                                                                          */
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* INVALID NO OF ARGUMENTS SUPPLIED TO SYSTEM SERVICE,                      */
/* SETTING THE RTR$M_EVENT FLAG REQUIRES THAT ALL                           */
/* ARGUMENTS BE SUPPLIED !                                                  */
/*                                                                          */
#define RTR__INVALARGNO 754042
/*                                                                          */
/* A SYSTEM SERVICE IS WAITING FOR A RESOURCE. UNTIL THIS WAIT TERMINATES   */
/* NO OTHER SYSTEM SERVICE CALL IS ALLOWED ON THE PARTICULAR CHANNEL. THIS  */
/* TO ENSURE CORRECT SEQUENCE OF MESSAGES AND CALLS TO RTR.                 */
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/*                                                                          */
#define RTR__SRVINWAIT 754050
/*                                                                          */
/*	A SYSTEM SERVICE CALL HAS NOT FOUND THE RESOURCES AVAILABLE         */
/*	FOR EXECUTION. THE USER HAS SPECIFIED NO WAIT IN THIS SITUATION.    */
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
#define RTR__NORSRCAVAI 754056
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* INVALID EVTNAM ARGUMENT SPECIFIED. CHECK EVTNAM PARAMETER FOR MAX LENGTH, */
/* READABILITY.                                                             */
/*                                                                          */
#define RTR__INVEVTNAM 754066
/*                                                                          */
/* %SYSTEM_SERVICE, R0                                                      */
/*                                                                          */
/* THE RTR SYSTEM SERVICE CALL HAS BEEN ACCEPTED FOR PROCESSING.            */
/* HOWEVER DUE TO LACK OF RESOURCES THE SERVICE CALL WILL NOT               */
/* BE TERMINATED IMMEDIATELY. RATHER THE TERMINATION WILL BE                */
/* DELAYED UNTIL SUCH TIME WHEN RESOURCES ARE AVAILABLE. IF AN              */
/* RTR SYSTEM SERVICE CALL (OTHER THAN $DEQ_TX AND $ABORT_TX)               */
/* IS ISSUED ON THE SAME CHANNEL BEFORE TERMINATION OF PREVIOUS             */
/* CALL THE SECOND CALL WILL BE PUT INTO A WAIT-STATE.                      */
/*                                                                          */
#define RTR__DELAYTERM 754075
/* COPYRIGHT (C) 1988 BY                                                    */
/* DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.                   */
/* ALL RIGHTS RESERVED.                                                     */
/*                                                                          */
/* THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED    */
/* ONLY  IN  ACCORDANCE  OF  THE  TERMS  OF  SUCH  LICENSE  AND WITH THE    */
/* INCLUSION OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY  OTHER    */
/* COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY    */
/* OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY    */
/* TRANSFERRED.                                                             */
/*                                                                          */
/* THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE    */
/* AND  SHOULD  NOT  BE  CONSTRUED  AS A COMMITMENT BY DIGITAL EQUIPMENT    */
/* CORPORATION.                                                             */
/*                                                                          */
/* DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS    */
/* SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.                  */
/*                                                                          */
/*                                                                          */
/* FACILITY : RTR SUBSYSTEM TM                                              */
/*                                                                          */
/* ABSTRACT : MESSAGE DEFINITIONS FOR RTR SUBSYSTEM TM                      */
/*                                                                          */
/* AUTHOR   : TONY CROSBY                                                   */
/*                                                                          */
/* CREATED  : 8-DEC-1988                                                    */
/*                                                                          */
/*                                                                          */
/* FILE RT$RTRTMDEF.MSG CONTAINS RTR MESSAGES EXPORTED                      */
/* (AND USED) BY THE RTR SUBSYSTEM TM                                       */
/* INTO THE FINAL RTRMSG FILE. THE FILE IS A PART                           */
/* OF THE ENTIRE RTR MSG SYSTEM, INCLUDING MSG'S                            */
/* EXPORTED BY OTHER RTR SUB-SYSTEMS.                                       */
/*                                                                          */
/* %SYSTEM_SERVICE, TXSB_STATUS                                             */
/*                                                                          */
/* RETURNED BY $DEQ_TX TO A SERVER WHEN THE FIRST MESSAGE OF                */
/* A NEW TRANSACTION IS DEQED.                                              */
/*                                                                          */
#define RTR__STARTTX 755265
/*                                                                          */
/* %SYSTEM_SERVICE, TXSB_STATUS                                             */
/*                                                                          */
/* RETURNED BY $DEQ_TX TO A SERVER AFTER THE REQUESTER ISSUES $COMMIT_TX,   */
/* AND THE LAST MESSAGE OF THE TRANSACTION HAS BEEN DEQED.                  */
/*                                                                          */
#define RTR__VOTETX 755273
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* DISPLAYS THE PROCESS NAME OF THE REQUESTER [A] AND ITS DECNET NODE ADDRESS */
/* [B] IN MESSAGES RELATING TO TRANSACTIONS.                                */
/*                                                                          */
#define RTR__RQEQUALS 755283
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* DISPLAYS THE TRANSACTION ID ([A] = FIRST LONGWORD, [B] = SECOND LONGWORD) IN */
/* MESSAGES RELATING TO TRANSACTIONS.                                       */
/*                                                                          */
#define RTR__TXIDEQUALS 755291
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* DISPLAYS THE TRANSACTION START TIME [A] IN MESSAGES                      */
/* RELATING TO TRANSACTIONS.                                                */
/*                                                                          */
#define RTR__TIMEEQUALS 755299
/*                                                                          */
/* %SYSTEM_SERVICE, TXSB_STATUS                                             */
/*                                                                          */
/* STATUS CODE RETURNED ON SERVER $DEQ_TX OR $VOTE_TX IN THE CASE WHERE     */
/* THE TRANSACTION CURRENTLY BEING PROCESSED HAS BEEN ABORTED BY THE        */
/* REQUESTER.                                                               */
/*                                                                          */
#define RTR__REQABOTX 755306
/*                                                                          */
/* %SYSTEM_SERVICE, TXSB_STATUS                                             */
/*                                                                          */
/* STATUS CODE RETURNED ON SERVER $DEQ_TX OR $VOTE_TX, OR ON REQUESTER      */
/* $ENQ_TX OR $COMMIT_TX IN THE CASE WHERE THE TRANSACTION CURRENTLY BEING  */
/* PROCESSED HAS BEEN ABORTED BY A SERVER FOR THE TX.                       */
/*                                                                          */
#define RTR__SRVABOTX 755314
/*                                                                          */
/* %SYSTEM_SERVICE, OBSOLETE                                                */
/*                                                                          */
/* THIS CODE IS NEVER RETURNED UNDER ANY CIRCUMSTANCES                      */
/*                                                                          */
#define RTR__NOSUISRV 755322
/*                                                                          */
/* %SYSTEM_SERVICE, TXSB_STATUS                                             */
/*                                                                          */
/* STATUS CODE RETURNED ON SERVER $DEQ_TX OR $VOTE_TX, OR ON REQUESTER      */
/* $ENQ_TX OR $COMMIT_TX IN THE CASE WHERE THE TRANSACTION CURRENTLY BEING  */
/* PROCESSED HAS BEEN ABORTED BECAUSE A SERVER IMAGE EXITED.                */
/*                                                                          */
#define RTR__SRVDIED 755330
/*                                                                          */
/* %SYSTEM_SERVICE, TXSB_STATUS                                             */
/*                                                                          */
/*                                                                          */
#define RTR__BELINLOS 755338
/*                                                                          */
/* %SYSTEM_SERVICE, TXSB_STATUS                                             */
/*                                                                          */
/*                                                                          */
#define RTR__FELINLOS 755346
/*                                                                          */
/* %SYSTEM_SERVICE, TXSB_STATUS                                             */
/*                                                                          */
/*                                                                          */
#define RTR__RTLINLOS 755354
/*                                                                          */
/* %SYSTEM_SERVICE, TXSB_STATUS                                             */
/*                                                                          */
/* STATUS CODE RETURNED ON REQUESTER $ENQ_TX OR $COMMIT_TX IN THE CASE      */
/* WHERE THE TRANSACTION CURRENTLY BEING PROCESSED HAS BEEN ABORTED         */
/* BECAUSE NO ROUTER IS AVAILABLE.                                          */
/* RETURNED IN TXSB STATUS FIELD.                                           */
/*                                                                          */
#define RTR__NOCURROU 755362
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* INDICATES THAT A REQUESTER EXITED BEFORE COMPLETING A TRANSACTION.       */
/*                                                                          */
#define RTR__REQDIED 755370
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* INDICATES THAT A REQUESTER DIED AFTER COMMITTING, BUT BEFORE COMPLETION OF A */
/* TRANSACTION.                                                             */
/*                                                                          */
#define RTR__REQDIEDVOT 755378
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* INDICATES THAT A SERVER EXITED BEFORE COMPLETING A TRANSACTION.          */
/*                                                                          */
#define RTR__SRVDIEDVOT 755386
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* INDICATES THAT A SERVER EXITED AFTER BEING TOLD TO COMMIT A TRANSACTION. */
/*                                                                          */
#define RTR__SRVDIEDCOM 755394
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* INDICATES THAT A TRANSACTION HAS BEEN ABORTED THAT WAS STARTED BY A      */
/* REQUESTER THAT HAS SINCE EXITED.                                         */
/*                                                                          */
#define RTR__ABODEAREQ 755402
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* INDICATES THAT A TRANSACTION HAS BEEN COMMITTED THAT WAS STARTED         */
/* BY A REQUESTER THAT HAS SINCE EXITED.                                    */
/*                                                                          */
#define RTR__COMDEAREQ 755410
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* INDICATES THAT A TRANSACTION HAS BEEN ABORTED THAT WAS SENT TO A SERVER  */
/* THAT HAS SINCE EXITED.                                                   */
/*                                                                          */
#define RTR__ABODEASRV 755418
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/*                                                                          */
/* INDICATES THAT A TRANSACTION HAS BEEN COMMITTED THAT WAS SENT TO A SERVER */
/* THAT HAS SINCE EXITED.                                                   */
/*                                                                          */
#define RTR__COMDEASRV 755426
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/*                                                                          */
/* INDICATES THAT A A REPLY $ENQ_TX MESSAGE WAS RECEIVED FOR A REQUESTER    */
/* THAS HAS SINCE EXITED.                                                   */
/*                                                                          */
#define RTR__ENQDEAREQ 755434
/*                                                                          */
/* %SYSTEM_SERVICE, TXSB_STATUS                                             */
/*                                                                          */
/* STATUS CODE RETURNED ON SERVER $DEQ_TX OR                                */
/* $VOTE_TX, OR ON REQUESTER $ENQ_TX OR $COMMIT_TX IN THE CASE WHERE THE    */
/* TRANSACTION CURRENTLY BEING PROCESSED HAS BEEN ABORTED BECAUSE THE USER- */
/* SPECIFIED TRANSACTION TIMEOUT HAS BEEN EXCEEDED.                         */
/*                                                                          */
#define RTR__TIMOUT 755442
/*                                                                          */
/* %SYSTEM_SERVICE, TXSB_STATUS                                             */
/*                                                                          */
/* RETURNED BY $DEQ_TX TO A SERVER TO INDICATE THE FIRST MESSAGE            */
/* OF A TRANSACTION REPLAYED DURING RECOVERY. THE SERVER SHOULD             */
/* ENSURE THAT THIS TRANSACTION HAS NOT ALREADY BEEN PROCESSED.             */
/*                                                                          */
#define RTR__STATXREC 755449
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* INDICATES THAT A SERVER EXITED WHILST PERFORMING RECOVERY OF TRANSACTIONS LOST */
/* ON AN EARLIER FAILURE.                                                   */
/*                                                                          */
#define RTR__SRVDIEDREC 755458
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* INDICATES THAT A SERVER ABORTED A TRANSACTION BEING RECOVERED AFTER AN EARLIER */
/* FAILURE.                                                                 */
/*                                                                          */
#define RTR__SRVABOREC 755466
/*                                                                          */
/* %SYSTEM_SERVICE, TXSB_STATUS                                             */
/*                                                                          */
/* STATUS CODE RETURNED ON REQUESTER $COMMIT_TX IN THE CASE WHERE THE       */
/* FATE OF THE TRANSACTION CURRENTLY BEING COMMITTED IS UNOBTAINABLE        */
/* BECAUSE OF AN UNRECOVERABLE HARDWARE ERROR.                              */
/*                                                                          */
/* RETURNED IN TXSB STATUS FIELD.                                           */
/*                                                                          */
#define RTR__COMSTAUNO 755474
/*                                                                          */
/* %SYSTEM_SERVICE, TXSB_STATUS                                             */
/*                                                                          */
/* STATUS CODE RETURNED ON SERVER $DEQ_TX OR $VOTE_TX IN THE CASE WHERE     */
/* THE TRANSACTION CURRENTLY BEING PROCESSED HAS BEEN ABORTED BECAUSE       */
/* OF A DEADLOCK WITH OTHER TRANSACTIONS USING THE SAME SERVERS. RTR        */
/* WILL REPLAY THE TRANSACTION AFTER THE DEADLOCK HAS BEEN CLEARED.         */
/*                                                                          */
/* RETURNED IN TXSB STATUS FIELD.                                           */
/*                                                                          */
#define RTR__DLKTXRES 755482
/* COPYRIGHT (C) 1988 BY                                                    */
/* DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.                   */
/* ALL RIGHTS RESERVED.                                                     */
/*                                                                          */
/* THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED    */
/* ONLY  IN  ACCORDANCE  OF  THE  TERMS  OF  SUCH  LICENSE  AND WITH THE    */
/* INCLUSION OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY  OTHER    */
/* COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY    */
/* OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY    */
/* TRANSFERRED.                                                             */
/*                                                                          */
/* THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE    */
/* AND  SHOULD  NOT  BE  CONSTRUED  AS A COMMITMENT BY DIGITAL EQUIPMENT    */
/* CORPORATION.                                                             */
/*                                                                          */
/* DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS    */
/* SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.                  */
/*                                                                          */
/*                                                                          */
/* FACILITY : RTR SUBSYSTEM CIF                                             */
/*                                                                          */
/* ABSTRACT : MESSAGE DEFINITIONS FOR RTR SUBSYSTEM CIF                     */
/*                                                                          */
/* AUTHOR   : ANDREW C. SCHOFIELD                                           */
/*                                                                          */
/* CREATED  : 31ST JUNE 1988                                                */
/*                                                                          */
/*                                                                          */
/* FILE RT$RTRCIFDEF.MSG CONTAINS RTR MESSAGES EXPORTED                     */
/* BY SUB-SYSTEM CIF. THESE MESSAGES ARE INCORPORATED                       */
/* INTO THE FINAL RTRMSG FILE. NOTE THIS FILE SHOULD                        */
/* NOT CONTAIN ANY OTHER DIRECTIVES BUT .BASE AND                           */
/* .SEVERITY. THE .FACILITY AND .END (ETC) DIRECTIVES                       */
/* ARE CONTAINED IN OTHER FILES.                                            */
/*                                                                          */
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* INDICATES THAT RTR HAS BEEN SUCCESSFULLY STARTED AFTER ISSUING A         */
/* "START RTR" COMMAND.                                                     */
/*                                                                          */
#define RTR__RTRSTART 756865
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* INDICATES THAT RTR HAS BEEN SUCCESSFULLY STOPPED AFTER ISSUING A         */
/* "STOP RTR" COMMAND.                                                      */
/*                                                                          */
#define RTR__RTRSTOP 756873
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* DISPLAYS THE NAME [A] OF THE FACILITY THAT WAS SUCCESSFULLY ADDED AFTER  */
/* ISSUING AN "ADD FACILITY" COMMAND.                                       */
/*                                                                          */
#define RTR__FACADDED 756881
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* DISPLAYS THE NAME OF THE FACILITY [A] THAT HAS BEEN                      */
/* SUCCESSFULLY DELETED AFTER ISSUING A "DELETE FACILITY" COMMAND.          */
/*                                                                          */
#define RTR__FACDELETE 756889
/*                                                                          */
/* %UTILITY,UNSUPPORTED                                                     */
/*                                                                          */
/* TRACE SUCCESSFULLY STOPPED AFTER ISSUING A "SET TRACE" COMMAND.          */
/*                                                                          */
#define RTR__TRACESTOP 756897
/*                                                                          */
/* %UTILITY,UNSUPPORTED                                                     */
/*                                                                          */
/* TRACE SUCCESSFULLY STOPPED AFTER ISSUING A "SET TRACE" COMMAND.          */
/*                                                                          */
#define RTR__TRACESTAR 756905
/*                                                                          */
/* %UTILITY,UNSUPPORTED                                                     */
/*                                                                          */
/* TRACE SUCCESSFULLY SUSPENDED AFTER ISSUING A "SUSPEND TRACE" COMMAND.    */
/*                                                                          */
#define RTR__TRASUSPEN 756913
/*                                                                          */
/* %UTILITY,UNSUPPORTED                                                     */
/*                                                                          */
/* TRACE SUCCESSFULLY RESUMED AFTER ISSUING A "RESUME TRACE" COMMAND.       */
/*                                                                          */
#define RTR__TRARESUME 756921
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* DISPLAYS WHICH LOG FILES [A] WILL BE USED AFTER ISSUING A "SET LOG" COMMAND */
/* WITH THE "/FILE" AND/OR "/OPERATOR" QUALIFIER                            */
/*                                                                          */
#define RTR__LOGFILSET 756929
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* DISPLAYS THE DEFAULT NODES [A] FOR COMMAND EXECUTION AFTER ISSUING A     */
/* "SET ENVIRONMENT" OR "SHOW ENVIRONMENT" COMMAND                          */
/*                                                                          */
#define RTR__COMARESEN 756937
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* INDICATES THAT LOGGING WAS SUCCESSFULLY SUPPRESSED AFTER                 */
/* ISSUING A "SET LOG command"                                              */
/* WITHOUT A "/FILE" OR "/OPERATOR" QUALIFIER.                              */
/*                                                                          */
#define RTR__LOGFILSUP 756945
/*                                                                          */
/* %INTERNAL                                                                */
/*                                                                          */
/*  ERROR CODE SUPPLIED TO $FORCEX WHEN STOPPING THE ACP.                   */
/*                                                                          */
#define RTR__ACPSTOP 756953
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* INDICATES HOW MANY DISPLAY ITEMS [A] WERE SUCCESSFULLY CLEARED           */
/* AFTER ISSUING A CLEAR DISPLAY COMMAND.                                   */
/*                                                                          */
#define RTR__DISITMCLR 756961
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* DISPLAYS THE CONTENTS [A] OF THE RSNSTS FIELD OF THE TXSB AFTER          */
/* CALLING AN RTR SYSTEM SERVICE VIA THE DCL INTERFACE                      */
/*                                                                          */
#define RTR__REASONSTS 756969
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* CONFIRMS THAT THE RTR JOURNAL HAS BEEN SUCCESSFULLY INITIALIZED          */
/* ON DEVICE [A] AFTER ISSUING THE "INITIALIZE JOURNAL" COMMAND.            */
/*                                                                          */
#define RTR__JOURNALINI 756977
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* INDICATES THAT A COMMAND SERVER IS BEING STARTED ON THE SPECIFIED        */
/* NODE [A].                                                                */
/*                                                                          */
#define RTR__STACOMSRV 756987
/*                                                                          */
/* %UTILITY,UNSUPPORTED                                                     */
/*                                                                          */
/* INDICATES THAT THE RTR UTILITY WILL WAIT UNTIL CONTROL-A KEY IS PRESSED. */
/* THIS MESSAGE APPEARS WHEN EITHER THE "WAIT" COMMAND OR "DEBUG ACP" COMMAND */
/* IS ISSUED.                                                               */
/*                                                                          */
#define RTR__WAITING 756995
/*                                                                          */
/* %UTILITY,UNSUPPORTED                                                     */
/*                                                                          */
/* CONFIRMS THAT CONTROL-A WAS PRESSED. THE RTR UTILITY WILL NOW RESUME     */
/* EXECUTION.                                                               */
/*                                                                          */
#define RTR__RESCTRLA 757003
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* DISPLAYS THE EVENT NUMBER [A], CHANNEL [B] AND DATA [C] IN THE RTR LOG WHEN */
/* AN EVENT OCCURS AND EVENTS WERE REQUESTED BY SUPPLYING                   */
/* THE "/EVENT" QUALIFIER ON THE "$DCL_TX_PRC" COMMAND.                     */
/*                                                                          */
#define RTR__EVENTAST 757011
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* DISPLAYS THE DEQUEUED DATA [B] AND ITS LENGTH IN BYTES [A]               */
/* WHEN A "SYS$DEQ_TX" COMMAND COMPLETES.                                   */
/*                                                                          */
#define RTR__DEQDATA 757019
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* DISPLAYS THE LOW BOUND OF THE SERVER KEY RANGE AS                        */
/* HEXADECIMAL NUMBER [A] AFTER ISSUING A                                   */
/* "SYS$DCL_TX_PRC" COMMAND.                                                */
/*                                                                          */
#define RTR__LOWBNDHEX 757027
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* DISPLAYS THE HIGH BOUND OF THE SERVER KEY RANGE AS                       */
/* HEXADECIMAL NUMBER [A] AFTER ISSUING A                                   */
/* "SYS$DCL_TX_PRC" COMMAND.                                                */
/*                                                                          */
#define RTR__HIGBNDHEX 757035
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* DISPLAYS THE NAME [A] OF THE OPERATION THAT COMPLETED ON                 */
/* A CHANNEL AFTER ISSUING A "SYS$SYNCH" COMMAND.                           */
/*                                                                          */
#define RTR__SYSSRVCOM 757043
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* DISPLAYS THE NAME [A] OF THE OPERATION THAT WAS                          */
/* ISSUED WITH THE "/NOWAIT" QUALIFIER ON CHANNEL [B].                      */
/*                                                                          */
#define RTR__SYSSRVNOW 757051
/*                                                                          */
/* %UTILITY,UNSUPPORTED                                                     */
/*                                                                          */
/* THE RTR ACP PROCESS IS NO LONGER RUNNING, BUT WAS NOT                    */
/* STOPPED WITH THE "STOP RTR" COMMAND. PLEASE SUBMIT A SPR.                */
/*                                                                          */
#define RTR__ACPDIED 757059
/*                                                                          */
/* %UTILITY,UNSUPPORTED                                                     */
/*                                                                          */
/* DISPLAYS THE NAME [A] OF THE NODE TO WHICH THE LINK HAS BEEN DISCONNECTED */
/* AFTER ISSUING A "DISCONNECT SERVER" COMMAND.                             */
/*                                                                          */
#define RTR__SRVDISCON 757067
/*                                                                          */
/* %UTILITY,UNSUPPORTED                                                     */
/*                                                                          */
/* DISPLAYS THE NAME [A] OF THE NODE TO WHICH THERE WAS NO LINK             */
/* AFTER ISSUING A "DISCONNECT SERVER" COMMAND.                             */
/*                                                                          */
#define RTR__SRVNOTRUN 757075
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* DISPLAYS THE NAME [A] OF THE MODE THAT WAS ENABLED AFTER ISSUING         */
/* A "SET MODE" COMMAND.                                                    */
/*                                                                          */
#define RTR__ENABMOD 757083
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* DISPLAYS THE NAME [A] OF THE MODE THAT WAS DISABLED AFTER ISSUING        */
/* A "SET MODE" COMMAND.                                                    */
/*                                                                          */
#define RTR__DISABMOD 757091
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* DISPLAYS THE NAME [A] AND PID [B] OF THE PROCESSES THAT WERE FORCED TO EXIT */
/* DUE TO THE EXECUTION OF A "STOP RTR" COMMAND.                            */
/*                                                                          */
#define RTR__FORCEDEXI 757099
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* DISPLAYS THE NAME [A] AND PID [B] OF THE PROCESSES THAT ARE STILL ATTACHED */
/* TO RTR.                                                                  */
/*                                                                          */
#define RTR__LIVEAPPL 757107
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* DISPLAYS THE NAME [A] OF A FILE THAT THE RTR UTILITY WAS UNABLE TO       */
/* OPEN. IT IS FOLLOWED BY AN RMS ERROR MESSAGE WHICH GIVES MORE            */
/* DETAILS.                                                                 */
/*                                                                          */
#define RTR__ERROPEFIL 757114
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* DISPLAYS THE NAME [A] OF A FILE THAT THE RTR UTILITY WAS UNABLE TO       */
/* ACCESS. IT IS FOLLOWED BY AN RMS ERROR MESSAGE WHICH GIVES MORE          */
/* DETAILS.                                                                 */
/*                                                                          */
#define RTR__ERRACCFIL 757122
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* INDICATES THAT THE COMMAND [A] REQUESTED WITH "RECALL" WAS               */
/* NOT IN THE RECALL BUFFER.                                                */
/*                                                                          */
#define RTR__COMNOTFOU 757130
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* INDICATES THAT THE COMMAND NUMBER REQUESTED WITH "RECALL" WAS            */
/* NOT IN THE ALLOWED RANGE (1 TO [A]).                                     */
/*                                                                          */
#define RTR__COMNUMMUS 757138
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE NODE NAME LIST SPECIFIED WITH THE                                    */
/* "/FRONTEND", "/ROUTER" OR "/BACKEND" QUALIFIERS ON AN                    */
/* "ADD FACILITY" COMMAND CONTAINED THE NODE NAME [A] MORE                  */
/* THAN ONCE.                                                               */
/*                                                                          */
#define RTR__DUPNODNAM 757146
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* AN EMPTY STRING WAS SPECIFIED WHERE A FACILITY NAME WAS EXPECTED.        */
/*                                                                          */
#define RTR__FACNAMBLA 757154
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* FACILITY NAME [A] IS TOO LONG.                                           */
/*                                                                          */
#define RTR__FACNAMLON 757162
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* FACILITY NAME [A] DOES NOT START WITH A LETTER ("A" TO "Z").             */
/*                                                                          */
#define RTR__FACNAMSTA 757170
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* FACILITY NAME [A] CONTAINS THE ILLEGAL CHARACTER [B].                    */
/* LEGAL CHARACTERS ARE LETTERS ("A" TO "Z"), NUMBERS ("0" TO "9"),         */
/* DOLLAR ("$") AND UNDERSCORE ("_").                                       */
/*                                                                          */
#define RTR__FACNAMILL 757178
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* WILDCARDS ("%" AND "*") ARE NOT ALLOWED.                                 */
/*                                                                          */
#define RTR__WILNOTALL 757186
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* NO ROUTERS WERE SPECIFIED ON AN "ADD FACILITY" COMMAND                   */
/* AND THE NODE WHERE THE COMMAND WAS EXECUTED WAS SPECIFIED                */
/* AS BEING A FRONTEND AND/OR BACKEND.                                      */
/*                                                                          */
#define RTR__NOROUTERS 757194
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* NO BACKEND WERE SPECIFIED ON AN "ADD FACILITY" COMMAND                   */
/* AND THE NODE WHERE THE COMMAND WAS EXECUTED WAS SPECIFIED                */
/* AS BEING A ROUTER.                                                       */
/*                                                                          */
#define RTR__NOBACKEND 757202
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* NO FRONTENDS WERE SPECIFIED ON AN "ADD FACILITY" COMMAND                 */
/* AND THE NODE WHERE THE COMMAND WAS EXECUTED WAS SPECIFIED                */
/* AS BEING A ROUTER.                                                       */
/*                                                                          */
#define RTR__NOFRONTEN 757210
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE NODE WHERE AN "ADD FACILITY" COMMAND WAS EXECUTED                    */
/* WAS NOT SPECIFIED AS BEING A FRONTEND, ROUTER OR BACKEND.                */
/*                                                                          */
#define RTR__OWNNODMIS 757218
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE FACILITY [A] SPECIFIED WITH THE "ADD FACILITY" COMMAND               */
/* ALREADY EXISTS.                                                          */
/*                                                                          */
#define RTR__FACALREXI 757226
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* INDICATES THAT THE CONFIGURATION TABLES COULD NOT BE ACCESSED.           */
/* THE SUBSEQUENT MESSAGE GIVES MORE DETAILS.                               */
/*                                                                          */
#define RTR__ERRACCTAB 757234
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* INDICATES THAT THE CONFIGURATION TABLES COULD NOT BE INITIALIZED.        */
/* THE SUBSEQUENT MESSAGE GIVES MORE DETAILS.                               */
/*                                                                          */
#define RTR__ERRINIACS 757242
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* RTR HAD NOT BEEN STARTED WHEN THE COMMAND WHEN                           */
/* A COMMAND WAS ISSUED WHICH REQUIRES RTR TO BE RUNNING.                   */
/*                                                                          */
#define RTR__RTRNOTSTA 757250
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* RTR WAS ALREADY RUNNING WHEN THE "START RTR" COMMAND                     */
/* WAS EXECUTED.                                                            */
/*                                                                          */
#define RTR__RTRALRSTA 757258
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* RTR HAD BEEN STOPPED WHEN THE COMMAND WHEN                               */
/* A COMMAND WAS ISSUED WHICH REQUIRES RTR TO BE RUNNING.                   */
/*                                                                          */
#define RTR__RTRWASSTO 757266
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE REQUESTED FACILITY [A] DOES NOT EXIST.                               */
/*                                                                          */
#define RTR__NOSUCHFAC 757274
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* NO FACILITIES HAVE YET BEEN DEFINED WITH THE                             */
/* "ADD FACILITY" COMMAND.                                                  */
/*                                                                          */
#define RTR__NOFACILIT 757282
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* AN ERROR OCCURRED WHILST CREATING A MAILBOX.                             */
/* THE SUBSEQUENT MESSAGE GIVES MORE DETAILS.                               */
/*                                                                          */
#define RTR__ERRCREMBX 757290
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* AN ERROR OCCURRED WHILST ACCESSING A MAILBOX.                            */
/* THE SUBSEQUENT MESSAGE GIVES MORE DETAILS.                               */
/*                                                                          */
#define RTR__ERRACCMBX 757298
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* AN ERROR OCCURRED WHILST DELETING A MAILBOX.                             */
/* THE SUBSEQUENT MESSAGE GIVES MORE DETAILS.                               */
/*                                                                          */
#define RTR__ERRDELMBX 757306
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE SPECIFIED FILENAME [A] IS INVALID. THE SUBSEQUENT RMS MESSAGE        */
/* GIVES MORE DETAILS.                                                      */
/*                                                                          */
#define RTR__INVFILNAM 757314
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* %UTILITY,UNSUPPORTED                                                     */
/*                                                                          */
/* THE SUBSYSTEM NAME [A] SPECIFIED WITH THE "/SUBSYSTEM" QUALIFIER         */
/* ON THE "SET TRACE" COMMAND IS TOO LONG.                                  */
/*                                                                          */
#define RTR__SUBTOOLON 757322
/*                                                                          */
/* %UTILITY,UNSUPPORTED                                                     */
/*                                                                          */
/* TOO MANY SUBSYSTEM NAMES WERE SPECIFIED WITH THE "/SUBSYSTEM" QUALIFIER  */
/* ON THE "SET TRACE" COMMAND.                                              */
/*                                                                          */
#define RTR__TOOMANSUB 757330
/*                                                                          */
/* %UTILITY,UNSUPPORTED                                                     */
/*                                                                          */
/* TRACE WAS NOT ENABLED WHEN A "SUSPEND TRACE" COMMAND                     */
/* WAS ISSUED.                                                              */
/*                                                                          */
#define RTR__TRANOTACT 757338
/*                                                                          */
/* %UTILITY,UNSUPPORTED                                                     */
/*                                                                          */
/* TRACE WAS ALREADY SUSPENDED WHEN A "SUSPEND TRACE" COMMAND               */
/* WAS ISSUED.                                                              */
/*                                                                          */
#define RTR__TRAALRSUS 757346
/*                                                                          */
/* %UTILITY,UNSUPPORTED                                                     */
/*                                                                          */
/* TRACE WAS NOT SUSPENDED WHEN A "RESUME TRACE" COMMAND                    */
/* WAS ISSUED.                                                              */
/*                                                                          */
#define RTR__TRANOTSUS 757354
/*                                                                          */
/* %UTILITY,UNSUPPORTED                                                     */
/*                                                                          */
/* TOO MANY FILE NAMES WERE SPECIFIED WITH THE "/FILE" QUALIFIER            */
/* ON THE "SET LOG" COMMAND.                                                */
/*                                                                          */
#define RTR__TOOMANLOG 757362
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* INDICATES THAT LOGGING WAS NOT ACTIVE WHEN A "SHOW LOG" COMMAND WAS ISSUED. */
/*                                                                          */
#define RTR__LOGNOTACT 757370
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE PROCESS WITH ID = [A] DOES NOT EXIST OR IS NOT USING                 */
/* RTR.                                                                     */
/*                                                                          */
#define RTR__NOSUCHPRC 757378
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* NO PROCESSES ARE CURRENTLY USING RTR.                                    */
/*                                                                          */
#define RTR__NORTRPROC 757386
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE SPECIFIED PROCESS ID [A] HAS AN INVALID FORMAT.                      */
/* PROCESS ID'S ARE HEXADECIMAL NUMBERS WITH UP TO EIGHT DIGITS.            */
/*                                                                          */
#define RTR__PROCIDILL 757394
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE RTR ACP PROCESS COULD NOT BE STARTED WHEN A "START RTR"              */
/* COMMAND WAS ISSUED. THE SUBSEQUENT MESSAGE GIVES MORE                    */
/* DETAILS.                                                                 */
/*                                                                          */
#define RTR__ERRSTAACP 757402
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE REQUESTED COUNTER [A] DOES NOT EXIST.                                */
/*                                                                          */
#define RTR__NOSUCHCOU 757410
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* INDICATES THAT INVALID COORDINATES WERE SPECIFIED                        */
/* ON A "CLEAR DISPLAY" OR "SHOW DISPLAY" COMMAND. NO ITEM                  */
/* IS DISPLAYED AT POINT [A], [B].                                          */
/*                                                                          */
#define RTR__NOSUCHITM 757418
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* INDICATES THAT INVALID COORDINATES WERE SPECIFIED                        */
/* ON A "DISPLAY" COMMAND WITHIN A DISPLAY FILE. THERE ALREADY IS           */
/* AN ITEM AT POINT [A], [B].                                               */
/*                                                                          */
/*                                                                          */
#define RTR__ITMALREXI 757426
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* INDICATES THAT NO ITEMS HAD BEEN DEFINED WITH THE DISPLAY                */
/* COMMAND WHEN A "MONITOR" OR "SCROLL" COMMAND WAS ISSUED.                 */
/*                                                                          */
#define RTR__NOTHTODIS 757434
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* AN ERROR OCCURRED WHILST ACCESSING NODE [A].                             */
/* THE SUBSEQUENT ERROR MESSAGE GIVES MORE DETAILS.                         */
/*                                                                          */
#define RTR__ERRACCNOD 757442
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* AN ATTEMPT WAS MADE TO MONITOR TOO MANY PROCESSES.                       */
/* PLEASE SUBMIT AN SPR.                                                    */
/*                                                                          */
#define RTR__TOOMUCDAT 757450
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* A SCROLL OR PRINT COMMAND WAS ISSUED BEFORE ANY MONITOR PICTURE          */
/* HAD BEEN DISPLAYED.                                                      */
/*                                                                          */
#define RTR__MONNOTACT 757458
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE VALUE OF QUALIFIER [A] MUST BE GREATER OR EQUAL TO [B].              */
/*                                                                          */
#define RTR__TOOSMALL 757466
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE VALUE OF QUALIFIER [A] MUST BE LESS OR EQUAL TO [B].                 */
/*                                                                          */
#define RTR__TOOBIG 757474
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE SPECIFIED DISPLAY FILE CONTAINED A COMMAND [A] OTHER THAN "DISPLAY". */
/* THIS IS SOMETIMES CAUSED BY FORGETTING THE CONTINUATION CHARACTER ("-")  */
/* ON THE END OF A LINE THAT IS TO BE CONTINUED.                            */
/* USE MONITOR/VERIFY TO FIND THE INCORRECT COMMAND.                        */
/*                                                                          */
#define RTR__ONLYDISP 757482
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE FILE-NAME [A] COULD REFER TO MORE THAN ONE                           */
/* MONITOR FILE. PLEASE SUPPLY MORE CHARACTERS.                             */
/*                                                                          */
#define RTR__AMBIGDISP 757490
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE REQUESTED MONITOR FILE [A] DOES NOT EXIST.                           */
/*                                                                          */
#define RTR__NOSUCHDIS 757498
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE REQUESTED NODE [A] DOES NOT EXIST.                                   */
/*                                                                          */
#define RTR__NOSUCHNOD 757506
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* IF A PROCESS ID IS SUPPLIED ON "MONITOR" COMMAND THEN                    */
/* ONLY ONE NODE MAY BE MONITORED.                                          */
/*                                                                          */
#define RTR__ONLONENOD 757514
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE STRING SUPPLIED WITH THE "/ACCESS" QUALIFIER ON THE                  */
/* "SYS$DCL_TX_PRC" COMMAND WAS TOO LONG.                                   */
/*                                                                          */
#define RTR__ACCTOOBIG 757522
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE STRING [A] COULD NOT BE CONVERTED TO DATA TYPE                       */
/* [B]. THE SUBSEQUENT MESSAGE GIVES THE REASON.                            */
/*                                                                          */
#define RTR__MSGDATILL 757530
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE "/EVENT" QUALIFIER ON THE "SYS$DCL_TX_PRC" COMMAND                   */
/* SPECIFIED AN UNKNOWN EVENT NAME.                                         */
/*                                                                          */
#define RTR__EVTNAMILL 757538
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* DISPLAYED WHEN A "SYS$DCL_TX_PRC" COMMAND IS ISSUED                      */
/* AND THE CHANNEL TABLE IS FULL.                                           */
/*                                                                          */
#define RTR__TOOMANCHN 757546
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE REQUESTED CHANNEL [A] HAS NOT BEEN DECLARED.                         */
/*                                                                          */
#define RTR__NOSUCHCHN 757554           /*                                  */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE CHANNEL SPECIFIED WITH THE "/CHANNEL" QUALIFIER ON                   */
/* A "SYS$DCL_TX_PRC" COMMAND HAS ALREADY BEEN DECLARED.                    */
/*                                                                          */
#define RTR__CHNALRDEC 757562
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE EXPRESSION [A] IS TOO COMPLEX TO EVALUATE.                           */
/* PLEASE SUBMIT AN SPR.                                                    */
/*                                                                          */
#define RTR__EXPTOOCOM 757570
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE NUMERIC CONSTANT [A] IS INVALID.                                     */
/*                                                                          */
#define RTR__NUMCONILL 757578
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* COUNTER [A] IS NOT THE SAME TYPE AS THE OTHER COUNTERS IN THE EXPRESSION. */
/* ALL COUNTERS IN AN EXPRESSION MUST BE EITHER 'PROCESS COUNTERS',         */
/* 'FACILITY COUNTERS', 'LINK COUNTERS' OR 'NODE COUNTERS'.                 */
/*                                                                          */
#define RTR__NOTSAMTYP 757586
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE EXPRESSION IS INVALID BECAUSE IT TERMINATED WHERE                    */
/* WHEN TOKEN [A] WAS EXPECTED.                                             */
/*                                                                          */
#define RTR__UNEXPEND 757594
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE EXPRESSION IS INVALID BECAUSE TOKEN [A]                              */
/* WAS EXPECTED BUT [B] WAS FOUND.                                          */
/*                                                                          */
#define RTR__EXPSYNILL 757602
/*                                                                          */
/* %UTILITY                                                                 */
/* THE EXPRESSION IS INVALID BECAUSE THE CHARACTERS [A]                     */
/* AT THE END OF THE EXPRESSION COULD NOT BE INTERPRETED.                   */
/*                                                                          */
#define RTR__SUPCHAEND 757610
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* DECNET WAS SHUTDOWN ON LOCAL NODE WHEN THE RTR UTILITY WAS BEING USED    */
/*                                                                          */
#define RTR__NODECNET 757618
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE NODE [A] IS UNKNOWN TO DECNET.                                       */
/*                                                                          */
#define RTR__NODNOTKNO 757626
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/*                                                                          */
/* AN ERROR OCCURRED WHILST TRYING TO LOOK UP NODE [A]                      */
/* IN THE DECNET DATABASE. THE SUBSEQUENT MESSAGE GIVES MORE                */
/* DETAILS.                                                                 */
/*                                                                          */
#define RTR__ERRGETNOD 757634
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THIS MESSAGE IS DISPLAYED WHEN AN "ADD FACILITY" COMMAND IS ISSUED.  IT  */
/* INDICATES THAT THE TOTAL NUMBER OF DIFFERENT NODES SPECIFIED WITH THIS AND */
/* ALL PREVIOUS "ADD FACILITY" COMMANDS WOULD EXCEED THE LIMIT SPECIFIED WITH */
/* THE "/LINKS" QUALIFIER WHEN RTR WAS STARTED.                             */
/*                                                                          */
#define RTR__NDBTABFUL 757642
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/*                                                                          */
/* THIS MESSAGE IS DISPLAYED WHEN AN "ADD FACILITY" COMMAND IS ISSUED.  IT  */
/* INDICATES THAT THE MAXIMUM NUMBER OF FACILITIES HAS ALREADY BEEN REACHED. */
/* THIS MAXIMUM IS SPECIFIED WITH THE "/FACILITIES" QUALIFIER               */
/* WHEN RTR IS STARTED.                                                     */
/*                                                                          */
#define RTR__FDBTABFUL 757650
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THIS MESSAGE IS DISPLAYED WHEN AN "ADD FACILITY" COMMAND IS ISSUED.  IT  */
/* INDICATES THAT THE MAXIMUM NUMBER OF FACILITY TO LINK RELATIONS          */
/* HAS BEEN REACHED.                                                        */
/* THIS MAXIMUM IS SPECIFIED WITH THE "/RELATIONS" QUALIFIER                */
/* WHEN RTR IS STARTED.                                                     */
/*                                                                          */
#define RTR__FACTABFUL 757658
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* A "SYS$SYNCH" COMMAND WAS ISSUED BUT THERE WERE NO OUTSTANDING           */
/* OPERATIONS ON CHANNEL [A]                                                */
/*                                                                          */
#define RTR__NOOUTSTND 757666
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* AN UNSUPPORTED COMMAND WAS ISSUED.                                       */
/*                                                                          */
#define RTR__CMDRESDEV 757674
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* A "SET MODE/GROUP" COMMAND WAS ISSUED WHILE RUNNING UNDER                */
/* SYSTEM UIC (GROUP ONE). SYSTEM UIC'S CANNOT BE USED IN                   */
/* GROUP MODE.                                                              */
/*                                                                          */
#define RTR__UICNOTGRP 757682
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* RTR IS NOT CORRECTLY INSTALLED.                                          */
/* REFER TO THE RTR INSTALLATION GUIDE FOR                                  */
/* DETAILS OF HOW TO INSTALL RTR.                                           */
/*                                                                          */
#define RTR__BADRTRINS 757690
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* "OPER" PRIVILEGE OR THE "RTR$OPERATOR" IDENTIFIER IS REQUIRED TO         */
/* RUN THE RTR UTILITY.                                                     */
/*                                                                          */
#define RTR__INSUFPRIV 757698
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* "SETPRV" PRIVILEGE IS REQUIRED TO EXECUTE A REMOTE COMMAND               */
/*                                                                          */
#define RTR__NFW 757706
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE RTR JOURNAL CANNOT BE INITIALIZED IF RTR IS RUNNING.                 */
/* FIRST STOP RTR AND THEN RE-ISSUE THE "INITIALIZE JOURNAL"                */
/* COMMAND.                                                                 */
/*                                                                          */
#define RTR__ININOTRUN 757714
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* RTR CAN ONLY PLACE IS NOT ABLE TO PLACE ITS JOURNAL FILES ON             */
/* REMOTE SYSTEMS. RE-ISSUE THE "INITIALIZE JOURNAL" COMMAND                */
/* WITHOUT THE NODE NAME AND COLONS ("::").                                 */
/*                                                                          */
#define RTR__ILLREMDEV 757722
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* RTR CAN ONLY PLACE ITS JOURNAL FILES ON DIRECTORY STRUCTURED             */
/* DEVICES. RE-ISSUE THE "INITIALIZE JOURNAL" COMMAND SPECIFYING            */
/* A DISK.                                                                  */
/*                                                                          */
#define RTR__ILLDEVTYP 757730
/*                                                                          */
/* %INTERNAL                                                                */
/*                                                                          */
/*  EXIT STATUS FROM RTRCOMSERV WHEN INACTIVITY TIMEOUT EXPIRES             */
/*                                                                          */
#define RTR__INATIMOUT 757738
/*                                                                          */
/* %INTERNAL                                                                */
/*                                                                          */
/*  EXIT STATUS FROM RTRCOMSERV WHEN CONNECT TIMEOUT EXPIRES                */
/*                                                                          */
#define RTR__CONTIMOUT 757746
/*                                                                          */
/* %INTERNAL                                                                */
/*                                                                          */
/*  EXIT STATUS FROM RTRCOMSERV WHEN SYTEM/GROUP MODE CHANGED               */
/*                                                                          */
#define RTR__MODECHANGE 757754
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/*  COMMAND WAS LONGER THAN 256 CHARACTERS.                                 */
/*                                                                          */
#define RTR__CMDTOOLON 757762
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/*  INDICATES THAT RTR CANNOT BE STOPPED UNDER PRESENT CIRCUMSTANCES        */
/*                                                                          */
#define RTR__CANTSTOP 757770
/* COPYRIGHT (C) 1988 BY                                                    */
/* DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.                   */
/* ALL RIGHTS RESERVED.                                                     */
/*                                                                          */
/* THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED    */
/* ONLY  IN  ACCORDANCE  OF  THE  TERMS  OF  SUCH  LICENSE  AND WITH THE    */
/* INCLUSION OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY  OTHER    */
/* COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY    */
/* OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY    */
/* TRANSFERRED.                                                             */
/*                                                                          */
/* THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE    */
/* AND  SHOULD  NOT  BE  CONSTRUED  AS A COMMITMENT BY DIGITAL EQUIPMENT    */
/* CORPORATION.                                                             */
/*                                                                          */
/* DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS    */
/* SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.                  */
/*                                                                          */
/* FACILITY : RTR SUBSYSTEM ERR                                             */
/*                                                                          */
/* ABSTRACT : MESSAGE DEFINITIONS FOR RTR SUBSYSTEM XXX INTERNAL MESSAGES   */
/*                                                                          */
/* AUTHOR   : ANDREW C. SCHOFIELD                                           */
/*                                                                          */
/* CREATED  : 31ST JUNE 1988                                                */
/*                                                                          */
/*                                                                          */
/* FILE RT$RTRERRDEF.MSG	CONTAINS RTR MESSAGES EXPORTED              */
/* BY SUB-SYSTEM ERR. THESE MESSAGES ARE INCORPORATED                       */
/* INTO THE FINAL RTRMSG FILE. NOTE THIS FILE SHOULD                        */
/* NOT CONTAIN ANY OTHER DIRECTIVES BUT .BASE AND                           */
/* .SEVERITY. THE .FACILITY AND .END (ETC) DIRECTIVES                       */
/* ARE CONTAINED IN OTHER FILES.                                            */
/*                                                                          */
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* DISPLAYS THE TIME/DATE [A], NODE NAME [B] AND USER NAME [C]              */
/* ASSOCIATED WITH THE SUBSEQUENT ERROR MESSAGE.                            */
/*                                                                          */
#define RTR__LOGFILENT 758467
/*                                                                          */
/* %CRASH                                                                   */
/*                                                                          */
/* SIGNALED BY A PROCESS WHEN AN RTR INTERNAL ERROR OCCURS.                 */
/* PLEASE SUBMIT AN SPR.                                                    */
/*                                                                          */
#define RTR__BUGCHECK 758476
/*                                                                          */
/* %CRASH                                                                   */
/*                                                                          */
/* SIGNALED BY A PROCESS WHEN AN RTR INTERNAL ERROR OCCURS.                 */
/* PLEASE SUBMIT AN SPR.                                                    */
/*                                                                          */
#define RTR__BUGCHECKPC 758484
/* COPYRIGHT (C) 1988 BY                                                    */
/* DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.                   */
/* ALL RIGHTS RESERVED.                                                     */
/*                                                                          */
/* THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED    */
/* ONLY  IN  ACCORDANCE  OF  THE  TERMS  OF  SUCH  LICENSE  AND WITH THE    */
/* INCLUSION OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY  OTHER    */
/* COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY    */
/* OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY    */
/* TRANSFERRED.                                                             */
/*                                                                          */
/* THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE    */
/* AND  SHOULD  NOT  BE  CONSTRUED  AS A COMMITMENT BY DIGITAL EQUIPMENT    */
/* CORPORATION.                                                             */
/*                                                                          */
/* DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS    */
/* SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.                  */
/*                                                                          */
/* FACILITY : RTR SUBSYSTEM ACS                                             */
/*                                                                          */
/* ABSTRACT : MESSAGE DEFINITIONS FOR RTR SUBSYSTEM ACS                     */
/*                                                                          */
/* AUTHOR   : ANDREW SCHOFIELD                                              */
/*                                                                          */
/* CREATED  : THURSDAY, THE 1ST OF SEPTEMBER 1988                           */
/*                                                                          */
/*                                                                          */
/* FILE RT$RTRACSDEF.MSG	CONTAINS RTR MESSAGES EXPORTED              */
/* BY SUB-SYSTEM ACS. THESE MESSAGES ARE INCORPORATED                       */
/* INTO THE FINAL RTRMSG FILE. NOTE THIS FILE SHOULD                        */
/* NOT CONTAIN ANY OTHER DIRECTIVES BUT .BASE AND                           */
/* .SEVERITY. THE .FACILITY AND .END (ETC) DIRECTIVES                       */
/* ARE CONTAINED IN OTHER FILES.                                            */
/*                                                                          */
/*                                                                          */
/* %UTILITY,SYSTEM_SERVICE,R0                                               */
/*                                                                          */
/* INDICATES THAT UTILITIES AND/OR SHARABLE IMAGES BEING                    */
/* USED ARE INTENDED FOR A DIFFERENT VERSION OF RTR TO THAT                 */
/* WHICH IS CURRENTLY RUNNING ON THE SYSTEM.                                */
/*                                                                          */
/* THIS MESSAGE CAN HOWEVER BE IGNORED WHEN IT IS DISPLAYED AFTER           */
/* ISSUING THE FIRST "STOP RTR" COMMAND AFTER HAVING JUST INSTALLED A NEW   */
/* RTR RELEASE.                                                             */
/*                                                                          */
#define RTR__VERMISMAT 759266
/*                                                                          */
/* %SYSTEM_SERVICE,R0                                                       */
/*                                                                          */
/* INDICATES THAT AN ATTEMPT WAS MADE TO START MORE RTR PROCESSES           */
/* THAN WERE SPECIFIED WITH THE "/PROCESS" QUALIFIER ON THE                 */
/* "START RTR" COMMAND.                                                     */
/*                                                                          */
#define RTR__TOOMANPRO 759274
/*                                                                          */
/* %SYSTEM_SERVICE,R0                                                       */
/*                                                                          */
/* INDICATES THAT THE RTR ACP HAS UNEXPECTEDLY DIED.                        */
/* PLEASE SUBMIT AN SPR.                                                    */
/*                                                                          */
#define RTR__ACPNOTVIA 759282
/* COPYRIGHT (C) 1988 BY                                                    */
/* DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.                   */
/* ALL RIGHTS RESERVED.                                                     */
/*                                                                          */
/* THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED    */
/* ONLY  IN  ACCORDANCE  OF  THE  TERMS  OF  SUCH  LICENSE  AND WITH THE    */
/* INCLUSION OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY  OTHER    */
/* COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY    */
/* OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY    */
/* TRANSFERRED.                                                             */
/*                                                                          */
/* THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE    */
/* AND  SHOULD  NOT  BE  CONSTRUED  AS A COMMITMENT BY DIGITAL EQUIPMENT    */
/* CORPORATION.                                                             */
/*                                                                          */
/* DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS    */
/* SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.                  */
/*                                                                          */
/* FACILITY : RTR SUBSYSTEM ASM                                             */
/*                                                                          */
/* ABSTRACT : MESSAGE DEFINITIONS FOR RTR SUBSYSTEM ASM                     */
/*                                                                          */
/* AUTHOR   : TONY CROSBY                                                   */
/*                                                                          */
/* CREATED  : 30-NOV-1989                                                   */
/*                                                                          */
/*                                                                          */
/* FILE RT$RTRASMDEF.MSG	CONTAINS RTR MESSAGES EXPORTED              */
/* BY SUB-SYSTEM ASM. THESE MESSAGES ARE INCORPORATED                       */
/* INTO THE FINAL RTRMSG FILE. NOTE THIS FILE SHOULD                        */
/* NOT CONTAIN ANY OTHER DIRECTIVES BUT .BASE AND                           */
/* .SEVERITY. THE .FACILITY AND .END (ETC) DIRECTIVES                       */
/* ARE CONTAINED IN OTHER FILES.                                            */
/*                                                                          */
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* RTR INTERNODE COMMUNICATION HAS BECOME TEMPORARILY BLOCKED. ONE OR MORE  */
/* BROADCAST MESSAGES MAY HAVE BEEN LOST.                                   */
/*                                                                          */
#define RTR__NETCOMBLO 765668
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* RTR INTERNODE COMMUNICATION HAS BECOME CONGESTED. NEW MESSAGES ARE WAITING */
/* FOR THE CONGESTION TO CLEAR.                                             */
/*                                                                          */
#define RTR__MESFLOCON 765676
/*                                                                          */
/* COPYRIGHT (C) 1988 BY                                                    */
/* DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.                   */
/* ALL RIGHTS RESERVED.                                                     */
/*                                                                          */
/* THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED    */
/* ONLY  IN  ACCORDANCE  OF  THE  TERMS  OF  SUCH  LICENSE  AND WITH THE    */
/* INCLUSION OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY  OTHER    */
/* COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY    */
/* OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY    */
/* TRANSFERRED.                                                             */
/*                                                                          */
/* THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE    */
/* AND  SHOULD  NOT  BE  CONSTRUED  AS A COMMITMENT BY DIGITAL EQUIPMENT    */
/* CORPORATION.                                                             */
/*                                                                          */
/* DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS    */
/* SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.                  */
/*                                                                          */
/* FACILITY : RTR SUBSYSTEM WAL                                             */
/*                                                                          */
/* ABSTRACT : MESSAGE DEFINITIONS FOR RTR SUBSYSTEM WAL                     */
/*                                                                          */
/* AUTHOR   : TONY CROSBY                                                   */
/*                                                                          */
/* CREATED  : 30-NOV-1989                                                   */
/*                                                                          */
/*                                                                          */
/* FILE RT$RTRWALDEF.MSG	CONTAINS RTR MESSAGES EXPORTED              */
/* BY SUB-SYSTEM WAL. THESE MESSAGES ARE INCORPORATED                       */
/* INTO THE FINAL RTRMSG FILE. NOTE THIS FILE SHOULD                        */
/* NOT CONTAIN ANY OTHER DIRECTIVES BUT .BASE AND                           */
/* .SEVERITY. THE .FACILITY AND .END (ETC) DIRECTIVES                       */
/* ARE CONTAINED IN OTHER FILES.                                            */
/*                                                                          */
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* ONE OR MORE BROADCAST MESSAGES HAD TO BE DISCARDED BECAUSE OF LOCAL      */
/* MEMORY CACHE CONGESTION. REDUCE THE RATE AT WHICH BROADCASTS ARE         */
/* SENT, OR INCREASE THE EFFICIENCY OF BROADCAST PROCESSING BY THE          */
/* RECIPIENT APPLICATIONS.                                                  */
/*                                                                          */
#define RTR__BRODISCAC 767268
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* ONE OR MORE BROADCAST MESSAGES HAD TO BE DISCARDED BECAUSE OF AN INTERNODE */
/* COMMUNICATIONS BLOCKAGE. REDUCE BROADCAST RATE OR INCREASE COMMUNICATIONS */
/* LINK CAPACITY.                                                           */
/*                                                                          */
#define RTR__BRODISBLO 767276
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* ONE OR MORE BROADCAST MESSAGES HAD TO BE DISCARDED BECAUSE NO NETWORK    */
/* LINK TO THE DESTINATION NODE WAS AVAILABLE                               */
/*                                                                          */
#define RTR__BRODISLIN 767284
/*                                                                          */
/*                                                                          */
/* COPYRIGHT (C) 1988 BY                                                    */
/* DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.                   */
/* ALL RIGHTS RESERVED.                                                     */
/*                                                                          */
/* THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED    */
/* ONLY  IN  ACCORDANCE  OF  THE  TERMS  OF  SUCH  LICENSE  AND WITH THE    */
/* INCLUSION OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY  OTHER    */
/* COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY    */
/* OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY    */
/* TRANSFERRED.                                                             */
/*                                                                          */
/* THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE    */
/* AND  SHOULD  NOT  BE  CONSTRUED  AS A COMMITMENT BY DIGITAL EQUIPMENT    */
/* CORPORATION.                                                             */
/*                                                                          */
/* DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS    */
/* SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.                  */
/*                                                                          */
/*                                                                          */
/* FACILITY : RTR SUBSYSTEM RTL                                             */
/*                                                                          */
/* ABSTRACT : MESSAGE DEFINITIONS FOR RTR SUBSYSTEM RTL                     */
/*                                                                          */
/* AUTHOR   : ANDREW C. SCHOFIELD                                           */
/*                                                                          */
/* CREATED  : SUNDAY, THE 30TH OF OCTOBER 1988                              */
/*                                                                          */
/*                                                                          */
/* FILE RT$RTRRTLDEF.MSG	CONTAINS RTR MESSAGES EXPORTED              */
/* BY SUB-SYSTEM RTL. THESE MESSAGES ARE INCORPORATED                       */
/* INTO THE FINAL RTRMSG FILE. NOTE THIS FILE SHOULD                        */
/* NOT CONTAIN ANY OTHER DIRECTIVES BUT .BASE AND                           */
/* .SEVERITY. THE .FACILITY AND .END (ETC) DIRECTIVES                       */
/* ARE CONTAINED IN OTHER FILES.                                            */
/*                                                                          */
#define RTR__REQALRDEC 760066
#define RTR__FACNAMABS 760074
#define RTR__FACNAMDES 760082
#define RTR__SENBUFABS 760090
#define RTR__SENBUFDES 760098
#define RTR__KEYPARABS 760106
#define RTR__TOOMANKEY 760114
#define RTR__KEYPAROMI 760122
#define RTR__KEYPARDES 760130
#define RTR__STAVARDES 760138
#define RTR__SECVARDES 760146
#define RTR__REQNOTDEC 760154
#define RTR__TRAALRSTA 760162
#define RTR__TRANOTSTA 760170
#define RTR__REPBUFDES 760178
#define RTR__REASONDES 760186
#define RTR__LOWALRSPC 760194
#define RTR__EXPSRVDEC 760202
#define RTR__SRVALRDEC 760210
#define RTR__SRVNOTDEC 760218
#define RTR__ERRACCLOW 760226
#define RTR__LOWBNDABS 760234
#define RTR__UPPALRSPC 760242
#define RTR__UPPBNDABS 760250
#define RTR__ERRACCUPP 760258
#define RTR__BNDNOTSPC 760266
#define RTR__RECBUFABS 760274
#define RTR__RECBUFDES 760282
#define RTR__EXPREPREJ 760290
#define RTR__ACTIONABS 760298
#define RTR__EXPRECEIV 760306
#define RTR__INVKEYTYP 760314
#define RTR__ERRRETRSN 760322
#define RTR__ERRRETMSG 760330
#define RTR__ERRRETACT 760338
#define RTR__ERRACCRSN 760346
#define RTR__ERRACCTIM 760354

/*	TITLE RT$RTRRSCDEF.MSG     RSC PUBLIC ERROR MESSAGE DEFINITIONS     */
/*       IDENT VERSION X-0.0                                                */
/*                                                                          */
/* COPYRIGHT (C) 1988 BY                                                    */
/* DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.                   */
/* ALL RIGHTS RESERVED.                                                     */
/*                                                                          */
/* THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED    */
/* ONLY  IN  ACCORDANCE  OF  THE  TERMS  OF  SUCH  LICENSE  AND WITH THE    */
/* INCLUSION OF THE ABOVE COPYRIGHT NOTICE. THIS SOFTWARE OR  ANY  OTHER    */
/* COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY    */
/* OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY    */
/* TRANSFERRED.                                                             */
/*                                                                          */
/* THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE    */
/* AND  SHOULD  NOT  BE  CONSTRUED  AS A COMMITMENT BY DIGITAL EQUIPMENT    */
/* CORPORATION.                                                             */
/*                                                                          */
/* DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS    */
/* SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.                  */
/*++                                                                        */
/* FACILITY:                                                                */
/*                                                                          */
/*   RTR REQUESTER SERVER CONFIGURATOR                                      */
/*                                                                          */
/* ABSTRACT:                                                                */
/*                                                                          */
/*   THIS FILE CONTAINS THE DEFINITION OF ALL RSC'S PUBLIC ERROR            */
/*   MESSAGES. THESE "public" ERROR MESSAGES ARE RETURNED TO THE            */
/*   USER.                                                                  */
/*                                                                          */
/* AUTHORS:                                                                 */
/*                                                                          */
/*   ANDREW SCHOFIELD                                                       */
/*                                                                          */
/* CREATION DATE: 1-DEC-1988                                                */
/*                                                                          */
/* MODIFICATION HISTORY:                                                    */
/*--                                                                        */
/*                                                                          */
/* %SYSTEM_SERVICE,R0                                                       */
/*                                                                          */
/* SERVER DECLARE SUCCESSFUL, BUT IN STANDBY MODE.                          */
/* SUBSEQUENT $DEQ_TX'S TO THIS CHANNEL WILL WAIT                           */
/* UNTIL THE PRIMARY NODE FAILS.                                            */
/*                                                                          */
#define RTR__SRVDCLSBY 763265
/*                                                                          */
/* %SYSTEM_SERVICE,R0                                                       */
/*                                                                          */
/* FUNCTION IS NOT SUPPORTED BY THIS RELEASE OF RTR                         */
/*                                                                          */
#define RTR__FUNCNOTSUP 763274
/*                                                                          */
/* %SYSTEM_SERVICE,R0                                                       */
/*                                                                          */
/* THE SPECIFIED FACILITY HAS NOT YET BEEN ADDED WITH                       */
/* THE "RTR ADD FACILITY" COMMAND.                                          */
/*                                                                          */
#define RTR__UNKNOFAC 763282
/*                                                                          */
/* %SYSTEM_SERVICE,TXSB_RSNSTS                                              */
/*                                                                          */
/* NO SERVER HAD DECLARED ITSELF TO HANDLE THE KEY VALUE                    */
/* SPECIFIED IN A MESSAGE SENT WITH A $ENQ_TX CALL                          */
/*                                                                          */
#define RTR__NODSTFND 763290            /*                                  */
/* %SYSTEM_SERVICE,TXSB_STATUS                                              */
/*                                                                          */
/* THE 'ACCESS' STRING SPECIFIED DOES NOT MATCH THAT OF                     */
/* EXISTING SERVER(S). CAN BE RETURNED WHEN DECLARING                       */
/* SERVERS OR REQUESTERS.                                                   */
/*                                                                          */
#define RTR__NOACCESS 763298
/*                                                                          */
/* %SYSTEM_SERVICE,TXSB_STATUS                                              */
/*                                                                          */
/* THE NUMBER OF KEY SEGMENTS IN THE 'DATPAR' ARGUMENT DOES                 */
/* NOT MATCH THAT OF EXISTING SERVER(S). CAN BE RETURNED                    */
/* WHEN DECLARING SERVERS OR REQUESTERS.                                    */
/*                                                                          */
#define RTR__NRSEGSDIF 763306
/*                                                                          */
/* %SYSTEM_SERVICE,TXSB_STATUS                                              */
/*                                                                          */
/* THE KEY DATA TYPE IN THE 'DATPAR' ARGUMENT DOES NOT MATCH                */
/* THAT OF EXISTING SERVER(S). CAN BE RETURNED WHEN                         */
/* DECLARING SERVERS OR REQUESTERS.                                         */
/*                                                                          */
#define RTR__DATTYPDIF 763314           /*                                  */
/* %SYSTEM_SERVICE,TXSB_STATUS                                              */
/*                                                                          */
/* THE KEY OFFSET IN THE 'DATPAR' ARGUMENT DOES NOT MATCH                   */
/* THAT OF EXISTING SERVER(S). CAN BE RETURNED WHEN                         */
/* DECLARING SERVERS OR REQUESTERS.                                         */
/*                                                                          */
#define RTR__KEYOFFDIF 763322           /*                                  */
/* %SYSTEM_SERVICE,TXSB_STATUS                                              */
/*                                                                          */
/* THE KEY LENGTH IN THE 'DATPAR' ARGUMENT DOES NOT MATCH                   */
/* THAT OF EXISTING SERVER(S). CAN BE RETURNED WHEN                         */
/* DECLARING SERVERS OR REQUESTERS.                                         */
/*                                                                          */
#define RTR__KEYLENDIF 763330           /*                                  */
/* %SYSTEM_SERVICE,TXSB_STATUS                                              */
/*                                                                          */
/* THE KEY RANGE SPECIFIED IN THE 'DATPAR' ARGUMENT OVERLAPS                */
/* THAT OF EXISTING SERVER(S). RETURNED WHEN                                */
/* DECLARING SERVERS.                                                       */
/*                                                                          */
#define RTR__KEYRANOVE 763338
/*                                                                          */
/* %SYSTEM_SERVICE,TXSB_STATUS                                              */
/*                                                                          */
/* THE HIGH BOUND IN THE 'DATPAR' ARGUMENT IS LESS THEN THE                 */
/* LOWER BOUND.RETURNED WHEN DECLARING SERVERS.                             */
/*                                                                          */
#define RTR__UPPLESLOW 763346
/*                                                                          */
/* %SYSTEM_SERVICE,TXSB_STATUS                                              */
/*                                                                          */
/* THE LENGTH OF THE ROUTING KEY IS LONGER THAN                             */
/* THE LENGTH OF A MESSAGE SENT WITH A $ENQ_TX CALL                         */
/*                                                                          */
#define RTR__INVTXBUFLEN 763354
/*                                                                          */
/* %SYSTEM_SERVICE,R0                                                       */
/*                                                                          */
/* AN ATTEMPT WAS MADE TO DECLARE A REQUESTER ON A NODE                     */
/* THAT WAS NOT DEFINED AS BEING A FRONTEND WHEN THE                        */
/* "ADD FACILITY" COMMAND WAS ISSUED.                                       */
/*                                                                          */
#define RTR__NODNOTFRO 763362
/*                                                                          */
/* %SYSTEM_SERVICE,R0                                                       */
/*                                                                          */
/* AN ATTEMPT WAS MADE TO DECLARE A SERVER ON A NODE                        */
/* THAT WAS NOT DEFINED AS BEING A BACKEND WHEN THE                         */
/* "ADD FACILITY" COMMAND WAS ISSUED.                                       */
/*                                                                          */
#define RTR__NODNOTBAC 763370
/*                                                                          */
/* %SYSTEM_SERVICE,TXSB_STATUS                                              */
/*                                                                          */
/* SHADOW SERVERS HAVE ALREADY BEEN DECLARED FOR THIS KEY RANGE ON          */
/* TWO OTHER NODES.                                                         */
/*                                                                          */
#define RTR__ALRSHADOW 763378
/*                                                                          */
/* %SYSTEM_SERVICE,TXSB_STATUS                                              */
/*                                                                          */
/* A SERVER HAS ALREADY BEEN DECLARED FOR THIS KEY RANGE ON THIS NODE       */
/* WHICH DID NOT SET 'CONCURRENT' FLAG ON ITS DECLARE.                      */
/*                                                                          */
#define RTR__EXINOTCON 763386
/*                                                                          */
/* %SYSTEM_SERVICE,TXSB_STATUS                                              */
/*                                                                          */
/* A SERVER HAS ALREADY BEEN DECLARED FOR THIS KEY RANGE ON THIS NODE       */
/* AND THIS DECLARE DID NOT SET THE 'CONCURRENT' FLAG.                      */
/*                                                                          */
#define RTR__CONNOTSET 763394
/*                                                                          */
/* %SYSTEM_SERVICE,TXSB_STATUS                                              */
/*                                                                          */
/* EITHER:                                                                  */
/*                                                                          */
/* (A) AN ATTEMPT WAS MADE TO START A STANDBY SERVER WHEN EXISTING SERVERS  */
/* HAD ALREADY BEEN DECLARED FOR THIS KEY RANGE WHICH HAD NOT SET THE       */
/* "STANDBY" FLAG, OR:                                                      */
/*                                                                          */
/* (B) AN ATTEMPT WAS MADE TO DECLARE A SERVER WITHOUT SETTING THE          */
/* "STANDBY" FLAG BUT STANDBY SERVERS WERE ALREADY RUNNING FOR THIS KEY RANGE. */
/*                                                                          */
#define RTR__ALLSRVSTA 763402
/*                                                                          */
/* %SYSTEM_SERVICE,TXSB_STATUS                                              */
/*                                                                          */
/* THIS KEY RANGE IS ALREADY BEING HANDLED BY SERVER(S) ON ANOTHER          */
/* NODE AND NEITHER THE "SHADOW" NOR "STANDBY" FLAGS WERE SET.              */
/*                                                                          */
#define RTR__NOTSAMNOD 763410
/*                                                                          */
/* %SYSTEM_SERVICE,TXSB_STATUS                                              */
/*                                                                          */
/* AN ATTEMPT WAS MADE TO CREATE A STANDBY SET WITH MORE                    */
/* THAN TWO PARTICIPATING NODES OR TO CREATE A SHADOW SET WITH MORE         */
/* THAN TWO PARTICIPATING NODES.                                            */
/*                                                                          */
#define RTR__TWONODALR 763418
/*                                                                          */
/* %SYSTEM_SERVICE,TXSB_STATUS                                              */
/*                                                                          */
/* ALL STANDBY SERVERS FOR A GIVEN KEY RANGE MUST BE ON NODES               */
/* WHICH BELONG TO THE SAME VAX-CLUSTER.                                    */
/*                                                                          */
#define RTR__NOTSAMCLU 763426
/*                                                                          */
/* %SYSTEM_SERVICE,R0,OBSOLETE                                              */
/*                                                                          */
#define RTR__INVDPARLEN 763434
/*                                                                          */
/* %SYSTEM_SERVICE,R0,OBSOLETE                                              */
/*                                                                          */
#define RTR__INVKEYLEN 763442
/*                                                                          */
/* %SYSTEM_SERVICE,R0,OBSOLETE                                              */
/*                                                                          */
#define RTR__INVKEYFLG 763450
/*                                                                          */
/* %SYSTEM_SERVICE,R0,OBSOLETE                                              */
/*                                                                          */
#define RTR__INVBNDLEN 763458
/*                                                                          */
/* %SYSTEM_SERVICE,R0                                                       */
/*                                                                          */
/* THE STRUCTURE PASSED TO $DCL_TX_PRC VIA THE 'DATPAR' ARGUMENT            */
/* COULD NOT BE READ.                                                       */
/*                                                                          */
#define RTR__NORDATPAR 763466
/*                                                                          */
/* %SYSTEM_SERVICE,R0                                                       */
/*                                                                          */
/* THE KEY RANGE LOW BOUND SPECIFIED IN THE RTR$A_DATPAR_LO_BND FIELD OF THE  */
/* DATPAR ARGUMENT COULD NOT BE READ.                                       */
/*                                                                          */
#define RTR__NORLOWBND 763474           /*                                  */
/* %SYSTEM_SERVICE,R0                                                       */
/*                                                                          */
/* THE KEY RANGE HIGH BOUND SPECIFIED IN THE RTR$A_DATPAR_HI_BND FIELD OF THE  */
/* DATPAR ARGUMENT COULD NOT BE READ.                                       */
/*                                                                          */
#define RTR__NORUPPBND 763482           /*                                  */
/* %SYSTEM_SERVICE                                                          */
/*                                                                          */
/* A PACKED DECIMAL STRING HAD AN INVALID LENGTH.                           */
/*                                                                          */
#define RTR__INVPCKLEN 763490
/*                                                                          */
/* %SYSTEM_SERVICE                                                          */
/*                                                                          */
/* A PACKED DECIMAL STRING CONTAINED AN INVALID CHARACTER.                  */
/*                                                                          */
#define RTR__INVPCKCHAR 763498
/*                                                                          */
/* %SYSTEM_SERVICE                                                          */
/*                                                                          */
/* A PACKED DECIMAL STRING CONTAINED MINUS ZERO.                            */
/*                                                                          */
#define RTR__NEGZEROPCK 763506
/*                                                                          */
/* %SYSTEM_SERVICE,R0                                                       */
/*                                                                          */
/* A "CALL_OUT" FLAG WAS SET WHEN DECLARING A SERVER BUT THE                */
/* FACILITY WAS NOT CONFIGURED FOR CALL-OUT SERVERS.                        */
/* USE THE "/CALL_OUT" QUALIFIER ON THE "ADD FACILITY" COMMAND              */
/* IF CALL-OUT SERVERS ARE TO BE DECLARED.                                  */
/*                                                                          */
#define RTR__NOCALLOUT 763514
/*                                                                          */
/* %SYSTEM_SERVICE,TXSB_RSNSTS                                              */
/*                                                                          */
/* THE "ADD FACILITY" COMMAND SPECIFIED THAT A NODE MUST                    */
/* HAVE "call-out" SERVERS BUT NONE WERE FOUND.                             */
/*                                                                          */
#define RTR__REQCALLUN 763522
/*                                                                          */
/* %SYSTEM_SERVICE,R0                                                       */
/*                                                                          */
/* THE "DATPAR" ARGUMENT OF $DCL_TX_PRC POINTED TO A LONGWORD               */
/* CONTAINING ZERO.                                                         */
/*                                                                          */
#define RTR__ZEROELEM 763530
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* THE PROCESS WITH ID = [A] USED AN OBSOLETE FORM OF                       */
/* THE 'DATPAR' ARGUMENT WHEN IT DECLARED A CHANNEL.                        */
/* THE CHANNEL DECLARATION MAY SUCCEED BUT THE OBSOLETE                     */
/* 'DATPAR' FORMAT MAY NOT BE SUPPORTED IN FUTURE VERSIONS                  */
/* OF RTR.                                                                  */
/*                                                                          */
#define RTR__OLDDATPAR 763536
/*                                                                          */
/* %SYSTEM_SERVICE,TXSB_STATUS                                              */
/*                                                                          */
/* EITHER:                                                                  */
/*                                                                          */
/* (A) AN ATTEMPT WAS MADE TO START A SHADOW SERVER WHEN EXISTING SERVERS   */
/* HAD ALREADY BEEN DECLARED FOR THIS KEY RANGE WHICH HAD NOT SET THE       */
/* "SHADOW" FLAG, OR:                                                       */
/*                                                                          */
/* (B) AN ATTEMPT WAS MADE TO DECLARE A SERVER WITHOUT SETTING THE          */
/* "SHADOW" FLAG BUT SHADOW SERVERS WERE ALREADY RUNNING FOR THIS KEY RANGE. */
/*                                                                          */
#define RTR__ALLSRVSHA 763546
/*                                                                          */
/* %SYSTEM_SERVICE,TXSB_STATUS                                              */
/*                                                                          */
/* AN ATTEMPT WAS MADE TO DECLARE A THIRD SHADOW SITE.                      */
/*                                                                          */
#define RTR__TOOMANSHA 763554
/* COPYRIGHT (C) 1988 BY                                                    */
/* DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.                   */
/* ALL RIGHTS RESERVED.                                                     */
/*                                                                          */
/* THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED    */
/* ONLY  IN  ACCORDANCE  OF  THE  TERMS  OF  SUCH  LICENSE  AND WITH THE    */
/* INCLUSION OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY  OTHER    */
/* COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY    */
/* OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY    */
/* TRANSFERRED.                                                             */
/*                                                                          */
/* THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE    */
/* AND  SHOULD  NOT  BE  CONSTRUED  AS A COMMITMENT BY DIGITAL EQUIPMENT    */
/* CORPORATION.                                                             */
/*                                                                          */
/* DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS    */
/* SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.                  */
/*                                                                          */
/* FACILITY : RTR SUBSYSTEM NCF                                             */
/*                                                                          */
/* ABSTRACT : MESSAGE DEFINITIONS FOR RTR SUBSYSTEM NCF                     */
/*                                                                          */
/* AUTHOR   : DIPANKAR DESHMUKH                                             */
/*                                                                          */
/* CREATED  : 5-DEC-1988                                                    */
/*                                                                          */
/*                                                                          */
/* FILE RT$RTRNCFDEF.MSG	CONTAINS RTR MESSAGES EXPORTED              */
/* BY SUB-SYSTEM NCF. THESE MESSAGES ARE INCORPORATED                       */
/* INTO THE FINAL RTRMSG FILE. NOTE THIS FILE SHOULD                        */
/* NOT CONTAIN ANY OTHER DIRECTIVES BUT .BASE AND                           */
/* .SEVERITY. THE .FACILITY AND .END (ETC) DIRECTIVES                       */
/* ARE CONTAINED IN OTHER FILES.                                            */
/*                                                                          */
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* THIS STATUS RESULTS WHEN SOMEONE STOPS DECNET ON A NODE RUNNING RTR      */
/* IF THE APPLICATION DOES NOT NEED DECNET, THEN RTR SHOULD                 */
/* BE STARTED UP BEFORE DECNET                                              */
/*                                                                          */
#define RTR__NETSHUT 764868
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* INTERNAL ERROR. SEND SPR                                                 */
/*                                                                          */
#define RTR__INTERFERENCE 764876
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* ATTEMPT TO START UP AN INCOMPATIBLE VERSION OF RTR ON THE SAME NETWORK   */
/* WITH SHARED FACILITIES.                                                  */
/*                                                                          */
#define RTR__INCOMPAT 764884
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* THIS IS A GENERAL STATUS USED TO INDICATE AN INADEQUACY IN THE STATIC    */
/* RESERVATIONS FOR THE TABLES. SEND SPR, WITH RTRACP DUMP.                 */
/*                                                                          */
#define RTR__OVERFLOW 764890
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* A CONNECTION FAILED BECAUSE RTR HAD NOT BEEN STARTED OR HAD DIED         */
/* ON THE REMOTE NODE [A].                                                  */
/*                                                                          */
#define RTR__OBJUNKNOWN 764898
/*                                                                          */
/* %LOG                                                                     */
/* THIS COULD BE A REASON FOR REJECTING A CONNECT REQUEST FROM A REMOTE ACP */
/*                                                                          */
#define RTR__NOTRECOGNISED 764906
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* THIS MEANS THAT NONE OF THE FACILITIES DEFINED ON THE LOCAL NODE [A] DEFINED */
/* A VALID ROLE FOR THE REMOTE NODE TO PERMIT A CONNECTION.                 */
/*                                                                          */
#define RTR__NOTCONFIGURED 764914
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* THIS CAN BE A REASON FOR REJECTING A CONNECT REQUEST.                    */
/* SUBMIT AN SPR.                                                           */
/*                                                                          */
#define RTR__ALRDCNCTD 764922
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* THIS CAN HAPPEN IF BOTH ACPS SIMULTANEOUSLY TRY TO CONNECT TO EACH OTHER */
/* SUBMIT AN SPR.                                                           */
/*                                                                          */
#define RTR__ALRINPRGS 764930
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* INTERNAL ERROR IN MESSAGES BETWEEN RTRACPS.                              */
/* SUBMIT AN SPR.                                                           */
/*                                                                          */
#define RTR__PROTOCOL 764938
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* NONE OF THE ROUTERS SPECIFIED FOR FACILITY [A] ARE CURRENTLY CONNECTABLE. */
/* THE SEARCH WILL CONTINUE AFTER A SHORT INTERVAL.                         */
/*                                                                          */
#define RTR__NOCURRTR 764946
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* THE ROUTER HANDLING FACILITY [A] FOR THIS FRONTEND NODE HAS DIED, OR     */
/* [A] HAS BEEN DELETED ON THE ROUTER. NO USER INTERVENTION IS              */
/* EXPECTED, AN ATTEMPT IS BEING MADE TO RECONNECT TO AN ALTERNATE ROUTER,  */
/* IF ONE IS AVAILABLE.                                                     */
/*                                                                          */
#define RTR__CURRTRLOSS 764954
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* A CONNECTION COULD FAIL BETWEEN A ROUTER AND A FRONTEND OR A BACKEND     */
/* IF THE FACILITY IS NOT YET DEFINED ON THE REMOTE NODE, TO NEGOTIATE      */
/* THE STATUS OF THE FACILITY.                                              */
/*                                                                          */
#define RTR__FACNOTDEC 764962
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* A NEGOTIATION WITH REMOTE NODE [A] ABOUT FACILITY [B] HAS FAILED FOR     */
/* THE REASON REPORTED IN THE FOLLOWING LINE. THIS MAY BE A REASON          */
/* FOR SYSTEM MANAGER INTERVENTION.                                         */
/*                                                                          */
#define RTR__RSPFAC 764968
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* A NEGOTIATION WITH REMOTE NODE [A] ABOUT FACILITY [B] HAS FAILED FOR     */
/* THE REASON REPORTED IN THE FOLLOWING LINE. THIS MAY BE A REASON          */
/* FOR SYSTEM MANAGER INTERVENTION.                                         */
/*                                                                          */
#define RTR__RSPNODE 764976
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* RTRACP ON NODE [A] MADE A CONNECT REQUEST, WHICH HAD TO BE REJECTED      */
/*                                                                          */
#define RTR__CNCTREJFR 764984
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* RTRACP ON NODE [A] REJECTED A CONNECT REQUEST FROM THIS NODE.            */
/*                                                                          */
#define RTR__CNCTREJBY 764992
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* NO FACILITY DEFINED ON THE NODE DESCRIBES THE CONNECTION REQUESTING NODE */
/*                                                                          */
#define RTR__NODENOTCNFG 765000
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* THE FACILITY EXISTS, BUT THE DEFINITION OF THE ROLE FOR THE REMOTE NODE  */
/* IS NOT THE SAME AS THE ONE IN THE LOCAL NODE. THE SYSTEM MANAGER HAS     */
/* PROBABLY INCORRECTLY DEFINED THE FACILITIES ON THE TWO NODES CONCERNED.  */
/*                                                                          */
#define RTR__ROLESMISMATCH 765008
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* THE NODE HAS LOST QUORUM FOR FACILITY [A]                                */
/*                                                                          */
#define RTR__OUTQUORUM 765016
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* THE REMOTE NODE [A] HAS LOST QUORUM FOR FACILITY [B]                     */
/*                                                                          */
#define RTR__OUTLNKQUO 765024
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* THE ROUTER HAS NO CREDIT LEFT TO ACCEPT ANY MORE FRONTENDS RIGHT NOW.    */
/* OTHER ROUTERS CAN BE TRIED.                                              */
/*                                                                          */
#define RTR__NOFECREDIT 765032
/* %LOG                                                                     */
/*                                                                          */
/* NODE [A] CANNOT BE REACHED PRESENTLY. THIS GENERALLY IMPLIES TRYING      */
/* TO REESTABLISH A CONNECTION.                                             */
/*                                                                          */
/*                                                                          */
#define RTR__PATHLOST 765043
/* %LOG                                                                     */
/*                                                                          */
/* DECNET CONNECTION WITH NODE [A] LOST                                     */
/*                                                                          */
#define RTR__CNCTLOST 765051
/*                                                                          */
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* FACILITY [A] INITIALIZED ON NODE [B]                                     */
/*                                                                          */
#define RTR__FACSTART 765059
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* THIS NODE IS NOW A CURRENT ROUTER FOR FRONTEND [B], FACILITY [A]         */
/*                                                                          */
#define RTR__FACSTARTFE 765067
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* A CONNECTION HAS BEEN ESTABLISHED WITH BACKEND NODE [B] ON FACILITY [A]  */
/*                                                                          */
#define RTR__FACSTARTBE 765075
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* A CONNECTION HAS BEEN ESTABLISHED WITH ROUTER NODE [B] ON FACILITY [A]   */
/*                                                                          */
#define RTR__FACSTARTTR 765083
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* THIS NODE IS NO LONGER A CURRENT ROUTER ON FACILITY [A],                 */
/* FOR FRONTEND NODE [B]                                                    */
/*                                                                          */
#define RTR__FACLOSTFE 765091
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* A CONNECTION HAS BEEN LOST WITH BACKEND NODE [B] ON FACILITY [A]         */
/*                                                                          */
#define RTR__FACLOSTBE 765099
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* A CONNECTION HAS BEEN LOST WITH ROUTER NODE [B] ON FACILITY [A]          */
/*                                                                          */
#define RTR__FACLOSTTR 765107
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
#define RTR__FACSTOP 765115
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
#define RTR__FACSTOPPED 765123
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* THE NODE IS NOW A MEMBER OF THE QUORUM SET OF FACILITY [A]               */
/*                                                                          */
#define RTR__INQUORUM 765131
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* THE REMOTE NODE [A] IS MEMBER OF QUORUM SET FOR FACILITY [B]             */
/*                                                                          */
#define RTR__INLNKQUO 765139
/*                                                                          */
/*% LOG                                                                     */
/*                                                                          */
/* A NEW CURRENT ROUTER [A] HAS BEEN FOUND FOR FACILITY [B]                 */
/*                                                                          */
#define RTR__CURRTR 765145
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* A CONNECTION REQUEST FROM RTRACP RUNNING ON NODE [A] HAS BEEN ACCEPTED   */
/*                                                                          */
#define RTR__CNCTACCFR 765153
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* A CONNECTION REQUEST HAS BEEN CONFIRMED BY RTRACP RUNNING ON NODE [A]    */
/*                                                                          */
#define RTR__CNCTCFRM 765161
/* COPYRIGHT (C) 1988 BY                                                    */
/* DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.                   */
/* ALL RIGHTS RESERVED.                                                     */
/*                                                                          */
/* THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED    */
/* ONLY  IN  ACCORDANCE  OF  THE  TERMS  OF  SUCH  LICENSE  AND WITH THE    */
/* INCLUSION OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY  OTHER    */
/* COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY    */
/* OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY    */
/* TRANSFERRED.                                                             */
/*                                                                          */
/* THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE    */
/* AND  SHOULD  NOT  BE  CONSTRUED  AS A COMMITMENT BY DIGITAL EQUIPMENT    */
/* CORPORATION.                                                             */
/*                                                                          */
/* DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS    */
/* SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.                  */
/*                                                                          */
/* FACILITY : RTR SUBSYSTEM WAL                                             */
/*                                                                          */
/* ABSTRACT : MESSAGE DEFINITIONS FOR RTR SUBSYSTEM WAL                     */
/*                                                                          */
/* AUTHOR   : TONY CROSBY                                                   */
/*                                                                          */
/* CREATED  : 30-NOV-1989                                                   */
/*                                                                          */
/*                                                                          */
/* FILE RT$RTRWALDEF.MSG	CONTAINS RTR MESSAGES EXPORTED              */
/* BY SUB-SYSTEM WAL. THESE MESSAGES ARE INCORPORATED                       */
/* INTO THE FINAL RTRMSG FILE. NOTE THIS FILE SHOULD                        */
/* NOT CONTAIN ANY OTHER DIRECTIVES BUT .BASE AND                           */
/* .SEVERITY. THE .FACILITY AND .END (ETC) DIRECTIVES                       */
/* ARE CONTAINED IN OTHER FILES.                                            */
/*                                                                          */
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* ONE OF PREVIOUSLY INITIALIZED RTR JOURNAL FILES FOR A BACKEND            */
/* COULD NOT BE FOUND. THIS STATUS MAY BE RETURNED BY THE ADD FACILITY      */
/* AND SHOW JOURNAL COMMANDS.                                               */
/*                                                                          */
/* PROBABLE CAUSES ARE:                                                     */
/*                                                                          */
/* (1) ONE OF THE DISKS BEING USED FOR JOURNALLING IS UNAVAILABLE, OR       */
/*                                                                          */
/* (2) A USER HAS INADVERTENTLY DELETED AN RTR JOURNAL FILE.                */
/*                                                                          */
/* CORRECTIVE ACTION, EITHER:                                               */
/*                                                                          */
/* (A) BRING THE MISSING DISK BACK ON LINE, OR                              */
/*                                                                          */
/* (B) RE-ISSUE THE RTR INITIALIZE JOURNAL COMMAND TO CREATE A NEW JOURNAL  */
/*     (IN THIS CASE ANY RECOVERY INFORMATION IN THE OLD JOURNAL IS LOST).  */
/*                                                                          */
/*                                                                          */
#define RTR__JOUFILMIS 766468
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* A DUPLICATE RTR JOURNAL FILE HAS BEEN FOUND. THIS STATUS MAY BE RETURNED */
/* BY THE ADD FACILITY AND SHOW JOURNAL COMMANDS.                           */
/*                                                                          */
/* PROBABLE CAUSE:                                                          */
/*                                                                          */
/* SYSTEM MANAGEMENT ERROR. A USER HAS INADVERTENTLY CREATED                */
/* TWO COPIES OF A JOURNAL FILE (PROBABLY WITH DCL BACKUP OR COPY).         */
/*                                                                          */
/* CORRECTIVE ACTION, EITHER:                                               */
/*                                                                          */
/* (A) DELETE THE SPURIOUS JOURNAL FILE, OR                                 */
/*                                                                          */
/* (B) RE-ISSUE THE INITIALIZE JOURNAL COMMAND                              */
/*     (IN THIS CASE ANY RECOVERY INFORMATION IN THE OLD JOURNAL IS LOST).  */
/*                                                                          */
#define RTR__DUPJOUFIL 766476
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* A SPURIOUS RTR JOURNAL FILE HAS BEEN FOUND WHICH DOES NOT CORRESPOND     */
/* TO THE OTHER JOURNAL FILES ON THE SYSTEM. THIS STATUS MAY BE RETURNED    */
/* BY THE ADD FACILITY AND SHOW JOURNAL COMMANDS.                           */
/*                                                                          */
/* PROBABLE CAUSE:                                                          */
/*                                                                          */
/* SYSTEM MANAGEMENT ERROR. A USER HAS INADVERTENTLY CREATED                */
/* A SPURIOUS JOURNAL FILE (PROBABLY WITH DCL BACKUP OR COPY)               */
/*                                                                          */
/* CORRECTIVE ACTION, EITHER:                                               */
/*                                                                          */
/* (A) DELETE THE SPURIOUS JOURNAL FILE, OR                                 */
/*                                                                          */
/* (B) RE-ISSUE THE INITIALIZE JOURNAL COMMAND                              */
/*     (IN THIS CASE ANY RECOVERY INFORMATION IN THE OLD JOURNAL IS LOST).  */
/*                                                                          */
#define RTR__SPUJOUFIL 766484
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* AN RTR JOURNAL FILE HAS BEEN FOUND WHICH HAS AN INCORRECT NAME FORMAT.   */
/* THIS IS PROBABLY AN RTR BUG, SUBMIT AN SPR. THIS STATUS MAY BE RETURNED  */
/* BY THE ADD FACILITY AND SHOW JOURNAL COMMANDS.                           */
/*                                                                          */
/* RE-ISSUE THE RTR INITIALIZE JOURNAL COMMAND BEFORE RESTARTING RTR.       */
/*                                                                          */
#define RTR__ERRJOUNAM 766492
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* NO RTR JOURNAL FILES CAN BE FOUND.                                       */
/*                                                                          */
/* THIS STATUS MAY BE RETURNED BY THE ADD FACILITY AND SHOW JOURNAL COMMANDS. */
/*                                                                          */
/* EITHER:                                                                  */
/*                                                                          */
/* 1) YOU HAVE NOT ISSUED AN RTR INITIALIZE JOURNAL COMMAND                 */
/*                                                                          */
/* 2) ALL JOURNAL DISKS ARE OFF-LINE                                        */
/*                                                                          */
/* 3) THE JOURNAL FILES HAVE BEEN INADVERTANTLY DELETED.                    */
/*                                                                          */
/* CORRECTIVE ACTION, EITHER:                                               */
/*                                                                          */
/* A) BRING THE JOURNAL DISK ON LINE                                        */
/*                                                                          */
/* B) ISSUE AN RTR INITIALIZE JOURNAL COMMAND.                              */
/*                                                                          */
#define RTR__JOUNOTINI 766500
/*                                                                          */
/* %UTILITY                                                                 */
/*                                                                          */
/* THE JOURNAL FILE(S) FOUND HAVE AN OUT-OF-DATE FORMAT. THIS STATUS MAY BE */
/* RETURNED BY THE ADD FACILITY AND SHOW JOURNAL COMMANDS AFTER A NEW VERSION OF */
/* RTR HAS BEEN INSTALLED ON A SYSTEM.                                      */
/*                                                                          */
/* CORRECTIVE ACTION: ISSUE AN RTR INITIALIZE JOURNAL COMMAND.              */
/*                                                                          */
#define RTR__JOUFORCHA 766508
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* AN INCONSISTENCY HAS BEEN FOUND IN A RECORD HEADER WITHIN THE RTR JOURNAL. */
/*                                                                          */
/* CORRECTIVE ACTION:                                                       */
/*                                                                          */
/* 1) RE-ISSUE THE RTR INITIALIZE JOURNAL COMMAND.                          */
/*                                                                          */
/* 2) RESTART RTR.                                                          */
/*                                                                          */
/* 3) SUBMIT AN SPR.                                                        */
/*                                                                          */
#define RTR__JOUHDRERR 766516
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* AN INCONSISTENCY HAS BEEN FOUND IN THE RECORD SEQUENCE WITHIN THE RTR JOURNAL. */
/*                                                                          */
/* CORRECTIVE ACTION:                                                       */
/*                                                                          */
/* 1) RE-ISSUE THE RTR INITIALIZE JOURNAL COMMAND.                          */
/*                                                                          */
/* 2) RESTART RTR.                                                          */
/*                                                                          */
/* 3) SUBMIT AN SPR.                                                        */
/*                                                                          */
#define RTR__JOUSEQERR 766524
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* THE JOURNAL FILE IS SO FULL THAT SOME TRANSACTION RECOVERY INFORMATION   */
/* HAS HAD TO BE DISCARDED. ONE OR MORE OF THE CURRENTLY ACTIVE TRANSACTIONS */
/* MAY BE INCORRECTLY RECOVERED IF A SYSTEM FAILURE OCCURS IN THE NEAR FUTURE. */
/*                                                                          */
#define RTR__JOUOVERFL 766532
/*                                                                          */
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* THE RTR JOURNAL FILE IS BECOMING FULL. EITHER REDUCE THE NUMBER AND SIZE OF */
/* CONCURRENTLY ACTIVE TRANSACTIONS, OR INCREASE THE SIZE OF THE JOURNAL FILE. */
/*                                                                          */
#define RTR__JOUFILFUL 766536
/*                                                                          */
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* JOURNAL SEARCH IS STARTING. THIS MESSAGE APPEARS WHEN RTR IS STARTED.    */
/*                                                                          */
#define RTR__COMJOUSEA 766547
/*                                                                          */
/* %LOG                                                                     */
/*                                                                          */
/* JOURNAL SEARCH HAS COMPLETED. THIS MESSAGE APPEARS WHEN RTR IS STARTED   */
/* THE THE NUMBER OF TRANSACTIONS NEEDING RECOVERY IS INDICATED BY [A].     */
/*                                                                          */
/*                                                                          */
#define RTR__JOUSEACOM 766555
/*                                                                          */
/*                                                                          */
/*	FILE RT$RTRENDDEF.MSG CONTAINS .END DIRECTIVE FOR                   */
/*	USE IN APPENDING RTR MESSAGE FILES TOGETHER FOR                     */
/*	THE FINAL RTR MESSAGE UTILITY.                                      */
/********************************************************************************************************************************/
/* Created 28-SEP-1990 02:50:50 by VAX SDL V3.2-12     Source: 19-MAY-1990 16:22:26 RTR$BUILD_ROOT:[LIB.BLDRTRTMP]RT$RTRSERVICE.S */
/********************************************************************************************************************************/

#define RTR_K_ACCESS_TYPE_PASSWORD 1

/*                                                                          */
/*  DCL_TX_PRC SYSTEM SERVICE FLAG DEFINITION                               */
/*                                                                          */
#define RTR_M_SHUTDOWN 0x1
#define RTR_M_REQUESTER 0x2
#define RTR_M_SERVER 0x4
#define RTR_M_RESERVED_1 0x8
#define RTR_M_RESERVED_2 0x10
#define RTR_M_CONCURRENT 0x20
#define RTR_M_SHADOW 0x40
#define RTR_M_STANDBY 0x80
#define RTR_M_FE_CALL_OUT 0x100
#define RTR_M_TR_CALL_OUT 0x200
#define RTR_M_BE_CALL_OUT 0x400
#define RTR_M_INHNOSRVWT 0x800
#define RTR_M_DDTM 0x1000
#define RTR_M_NONDEFTID 0x2000

/*                                                                          */
/*  START_TX SYSTEM SERVICE FLAG DEFINITION                                 */
/*                                                                          */

/*                                                                          */
/*  ENQ_TX SYSTEM SERVICE FLAG DEFINITION                                   */
/*                                                                          */
#define RTR_M_BROADCAST 1
#define RTR_M_EVENT 1
#define RTR_M_NOTUSED 0x100
#define RTR_M_ENQBUFCHK 0x200
#define RTR_M_NORSWAIT 0x400
#define RTR_M_NODSTFNDIGN 0x800
#define RTR_M_NODSTFNDEVT 0x1000
#define RTR_M_READONLY 0x2000

/*                                                                          */
/*  DEQ_TX SYSTEM SERVICE FLAG DEFINITION                                   */
/*                                                                          */
#define RTR_M_DEQBUFCHK 1

/*                                                                          */
/*  COMMIT_TX SYSTEM SERVICE FLAG DEFINITION                                */
/*                                                                          */

/*                                                                          */
/*  VOTE_TX SYSTEM SERVICE FLAG DEFINITION                                  */
/*                                                                          */
#define RTR_M_ABORT 1
#define RTR_M_COMMIT 2
#define RTR_M_FORGET 4

/*                                                                          */
/*  Definition of EVTMSK and EVTNO bit numbers                              */
/*  for event signalling. Also defines a number of                          */
/*  constants relating to EVTMSK and max EVTNO.                             */
/*                                                                          */
#define RTR_M_EVTMSK_BRDCST 1
#define RTR_M_EVTMSK_USRDEF1 2
#define RTR_M_EVTMSK_USRDEF2 4
#define RTR_M_EVTMSK_USRDEF3 8
#define RTR_M_EVTMSK_USRDEF4 16
#define RTR_M_EVTMSK_USRDEF5 32
#define RTR_M_EVTMSK_USRDEF6 64
#define RTR_M_EVTMSK_USRDEF7 128
#define RTR_M_EVTMSK_USRDEF8 256
#define RTR_M_EVTMSK_USRDEF9 512
#define RTR_M_EVTMSK_USRDEF10 1024
#define RTR_M_EVTMSK_USRDEF11 2048
#define RTR_M_EVTMSK_USRDEF12 4096
#define RTR_M_EVTMSK_USRDEF13 8192
#define RTR_M_EVTMSK_USRDEF14 16384
#define RTR_M_EVTMSK_USRDEF15 32768
#define RTR_M_EVTMSK_USRDEF16 65536
#define RTR_M_EVTMSK_USRDEF17 131072
#define RTR_M_EVTMSK_USRDEF18 262144
#define RTR_M_EVTMSK_USRDEF19 524288
#define RTR_M_EVTMSK_USRDEF20 1048576
#define RTR_M_EVTMSK_USRDEF21 2097152
#define RTR_M_EVTMSK_USRDEF22 4194304
#define RTR_M_EVTMSK_USRDEF23 8388608
#define RTR_M_EVTMSK_USRDEF24 16777216
#define RTR_M_EVTMSK_USRDEF25 33554432
#define RTR_M_EVTMSK_USRDEF26 67108864
#define RTR_M_EVTMSK_USRDEF27 134217728
#define RTR_M_EVTMSK_USRDEF28 268435456
#define RTR_M_EVTMSK_USRDEF29 536870912
#define RTR_M_EVTMSK_USRDEF30 1073741824
#define RTR_M_EVTMSK_USRDEF31 -2147483648

#define RTR_M_EVTMSK_USRDEF32 1
#define RTR_M_EVTMSK_USRDEF33 2
#define RTR_M_EVTMSK_USRDEF34 4
#define RTR_M_EVTMSK_USRDEF35 8
#define RTR_M_EVTMSK_USRDEF36 16
#define RTR_M_EVTMSK_USRDEF37 32
#define RTR_M_EVTMSK_USRDEF38 64
#define RTR_M_EVTMSK_USRDEF39 128
#define RTR_M_EVTMSK_USRDEF40 256
#define RTR_M_EVTMSK_USRDEF41 512
#define RTR_M_EVTMSK_USRDEF42 1024
#define RTR_M_EVTMSK_USRDEF43 2048
#define RTR_M_EVTMSK_USRDEF44 4096
#define RTR_M_EVTMSK_USRDEF45 8192
#define RTR_M_EVTMSK_USRDEF46 16384
#define RTR_M_EVTMSK_USRDEF47 32768
#define RTR_M_EVTMSK_USRDEF48 65536
#define RTR_M_EVTMSK_USRDEF49 131072
#define RTR_M_EVTMSK_USRDEF50 262144
#define RTR_M_EVTMSK_USRDEF51 524288
#define RTR_M_EVTMSK_USRDEF52 1048576
#define RTR_M_EVTMSK_USRDEF53 2097152
#define RTR_M_EVTMSK_USRDEF54 4194304
#define RTR_M_EVTMSK_USRDEF55 8388608
#define RTR_M_EVTMSK_USRDEF56 16777216
#define RTR_M_EVTMSK_USRDEF57 33554432
#define RTR_M_EVTMSK_USRDEF58 67108864
#define RTR_M_EVTMSK_USRDEF59 134217728
#define RTR_M_EVTMSK_USRDEF60 268435456
#define RTR_M_EVTMSK_USRDEF61 536870912
#define RTR_M_EVTMSK_USRDEF62 1073741824
#define RTR_M_EVTMSK_USRDEF63 -2147483648

#define RTR_M_EVTMSK_FACREADY 1
#define RTR_M_EVTMSK_FACDEAD 2
#define RTR_M_EVTMSK_FERTRGAIN 4
#define RTR_M_EVTMSK_FERTRLOSS 8
#define RTR_M_EVTMSK_RTRBEGAIN 16
#define RTR_M_EVTMSK_RTRBELOSS 32
#define RTR_M_EVTMSK_KEYRANGEGAIN 64
#define RTR_M_EVTMSK_KEYRANGELOSS 128
#define RTR_M_EVTMSK_BERTRGAIN 256
#define RTR_M_EVTMSK_BERTRLOSS 512
#define RTR_M_EVTMSK_RTRFEGAIN 1024
#define RTR_M_EVTMSK_RTRFELOSS 2048
#define RTR_M_EVTMSK_RCRCHGAIN 524288
#define RTR_M_EVTMSK_RCRCHLOSS 1048576

/*rtr$k_evtmsk_maxmsklen max len of EVTMSK type 2 in bytes.                 */
#define RTR_K_EVTMSK_MAXMSKLEN 16
/*rtr$k_max_evtnamlen : max byte length of evtnam parameter for $dcl_tx_prc and  */
/* $enq_tx.                                                                 */

#define RTR_K_MAX_EVTNAMLEN 32
#define RTR_V_EVTNO_BRDCST 0            /*brdcst bit.                       */
#define RTR_V_EVTNO_USRDEF0 0           /*brdcst bit.                       */
#define RTR_V_EVTNO_USRDEF1 1           /*user defined event no 1           */
#define RTR_V_EVTNO_USRDEF2 2           /*user defined event no 2           */
#define RTR_V_EVTNO_USRDEF3 3           /*user defined event no 3           */
#define RTR_V_EVTNO_USRDEF4 4           /*user defined event no 4           */
#define RTR_V_EVTNO_USRDEF5 5           /*user defined event no 5           */
#define RTR_V_EVTNO_USRDEF6 6           /*user defined event no 6           */
#define RTR_V_EVTNO_USRDEF7 7           /*user defined event no 7           */
#define RTR_V_EVTNO_USRDEF8 8           /*user defined event no 8           */
#define RTR_V_EVTNO_USRDEF9 9           /*user defined event no 9           */
#define RTR_V_EVTNO_USRDEF10 10         /*user defined event no 10          */
#define RTR_V_EVTNO_USRDEF11 11         /*user defined event no 11          */
#define RTR_V_EVTNO_USRDEF12 12         /*user defined event no 12          */
#define RTR_V_EVTNO_USRDEF13 13         /*user defined event no 13          */
#define RTR_V_EVTNO_USRDEF14 14         /*user defined event no 14          */
#define RTR_V_EVTNO_USRDEF15 15         /*user defined event no 15          */
#define RTR_V_EVTNO_USRDEF16 16         /*user defined event no 16          */
#define RTR_V_EVTNO_USRDEF17 17         /*user defined event no 17          */
#define RTR_V_EVTNO_USRDEF18 18         /*user defined event no 18          */
#define RTR_V_EVTNO_USRDEF19 19         /*user defined event no 19          */
#define RTR_V_EVTNO_USRDEF20 20         /*user defined event no 20          */
#define RTR_V_EVTNO_USRDEF21 21         /*user defined event no 21          */
#define RTR_V_EVTNO_USRDEF22 22         /*user defined event no 22          */
#define RTR_V_EVTNO_USRDEF23 23         /*user defined event no 23          */
#define RTR_V_EVTNO_USRDEF24 24         /*user defined event no 24          */
#define RTR_V_EVTNO_USRDEF25 25         /*user defined event no 25          */
#define RTR_V_EVTNO_USRDEF26 26         /*user defined event no 26          */
#define RTR_V_EVTNO_USRDEF27 27         /*user defined event no 27          */
#define RTR_V_EVTNO_USRDEF28 28         /*user defined event no 28          */
#define RTR_V_EVTNO_USRDEF29 29         /*user defined event no 29          */
#define RTR_V_EVTNO_USRDEF30 30         /*user defined event no 30          */
#define RTR_V_EVTNO_USRDEF31 31         /*user defined event no 31          */
#define RTR_V_EVTNO_USRDEF32 32         /*user defined event no 32          */
#define RTR_V_EVTNO_USRDEF33 33         /*user defined event no 33          */
#define RTR_V_EVTNO_USRDEF34 34         /*user defined event no 34          */
#define RTR_V_EVTNO_USRDEF35 35         /*user defined event no 35          */
#define RTR_V_EVTNO_USRDEF36 36         /*user defined event no 36          */
#define RTR_V_EVTNO_USRDEF37 37         /*user defined event no 37          */
#define RTR_V_EVTNO_USRDEF38 38         /*user defined event no 38          */
#define RTR_V_EVTNO_USRDEF39 39         /*user defined event no 39          */
#define RTR_V_EVTNO_USRDEF40 40         /*user defined event no 40          */
#define RTR_V_EVTNO_USRDEF41 41         /*user defined event no 41          */
#define RTR_V_EVTNO_USRDEF42 42         /*user defined event no 42          */
#define RTR_V_EVTNO_USRDEF43 43         /*user defined event no 43          */
#define RTR_V_EVTNO_USRDEF44 44         /*user defined event no 44          */
#define RTR_V_EVTNO_USRDEF45 45         /*user defined event no 45          */
#define RTR_V_EVTNO_USRDEF46 46         /*user defined event no 46          */
#define RTR_V_EVTNO_USRDEF47 47         /*user defined event no 47          */
#define RTR_V_EVTNO_USRDEF48 48         /*user defined event no 48          */
#define RTR_V_EVTNO_USRDEF49 49         /*user defined event no 49          */
#define RTR_V_EVTNO_USRDEF50 50         /*user defined event no 50          */
#define RTR_V_EVTNO_USRDEF51 51         /*user defined event no 51          */
#define RTR_V_EVTNO_USRDEF52 52         /*user defined event no 52          */
#define RTR_V_EVTNO_USRDEF53 53         /*user defined event no 53          */
#define RTR_V_EVTNO_USRDEF54 54         /*user defined event no 54          */
#define RTR_V_EVTNO_USRDEF55 55         /*user defined event no 55          */
#define RTR_V_EVTNO_USRDEF56 56         /*user defined event no 56          */
#define RTR_V_EVTNO_USRDEF57 57         /*user defined event no 57          */
#define RTR_V_EVTNO_USRDEF58 58         /*user defined event no 58          */
#define RTR_V_EVTNO_USRDEF59 59         /*user defined event no 59          */
#define RTR_V_EVTNO_USRDEF60 60         /*user defined event no 60          */
#define RTR_V_EVTNO_USRDEF61 61         /*user defined event no 61          */
#define RTR_V_EVTNO_USRDEF62 62         /*user defined event no 62          */
#define RTR_V_EVTNO_USRDEF63 63         /*user defined event no 63          */
#define RTR_K_EVTMSK_MAXUSREVTNO 63
/*RTR_K_evtmsk_maxusrevtno max event no possible to signal for user         */
#define RTR_V_EVTNO_FACREADY 96         /* The facility has become operational */
#define RTR_V_EVTNO_FACDEAD 97          /* The facility has broken down     */
#define RTR_V_EVTNO_FERTRGAIN 98        /* FE link to current router established */
#define RTR_V_EVTNO_FERTRLOSS 99        /* FE link to current router lost   */
#define RTR_V_EVTNO_RTRBEGAIN 100       /* Current router established link to a BE */
#define RTR_V_EVTNO_RTRBELOSS 101       /* Current router lost link to a BE */
#define RTR_V_EVTNO_KEYRANGEGAIN 102    /* Server(s) for new key range available */
#define RTR_V_EVTNO_KEYRANGELOSS 103    /* No more servers left for a particular key range */
#define RTR_V_EVTNO_BERTRGAIN 104       /* BE established link to a router  */
#define RTR_V_EVTNO_BERTRLOSS 105       /* BE lost link to a router         */
#define RTR_V_EVTNO_RTRFEGAIN 106       /* Router established link to an FE */
#define RTR_V_EVTNO_RTRFELOSS 107       /* Router lost link to an FE        */
#define RTR_V_EVTNO_RCRCHGAIN 115       /* Remote client established link to a RCH */
#define RTR_V_EVTNO_RCRCHLOSS 116       /* Remote client lost link to a RCH */
#define RTR_K_MAXBUFLEN 64000           /*max no of bytes sent by one ENQ_TX */
#define RTR_K_EVTAST_ARGNO 6            /*no of arg's in EVTAST arg-list    */

/*                                                                          */
/* Definitions of CHMK codes for the system services.                       */
/*                                                                          */
#define RTR_K_CHMK_CODE_BASE -300       /*CHMK code base for RTR services   */
#define RTR_K_ENQ_TX_CHMK_CODE -300
#define RTR_K_DEQ_TX_CHMK_CODE -299
#define RTR_K_START_TX_CHMK_CODE -298
#define RTR_K_COMMIT_TX_CHMK_CODE -297
#define RTR_K_VOTE_TX_CHMK_CODE -296
#define RTR_K_GETTXI_CHMK_CODE -295
#define RTR_K_SETTXI_CHMK_CODE -294
#define RTR_K_ABORT_TX_CHMK_CODE -293
#define RTR_K_DCL_TX_PRC_CHMK_CODE -292
#define RTR_K_CHMK_CODE_COUNT -292      /*No. of CHMK codes handled by RTR  */
/*system service dispatcher.                                                */

#endif /* #ifndef RTR_ERROR */
/******************************************************************************/
/* Copyright Digital Equipment Corporation 1993. All rights reserved.         */
/*                                                                            */
/* Restricted Rights: Use, duplication, or disclosure by the U.S. Government  */
/* is subject to restrictions as set forth in subparagraph (c) (1) (ii) of    */
/* DFARS 252.227-7013, or in FAR 52.227-19, or in FAR 52.227=14 Alt. III, as  */
/* applicable.                                                                */
/*                                                                            */
/* This software is proprietary to and embodies the confidential technology   */
/* of Digital Equipment Corporation. Possession, use, or copying of this      */
/* software and media is authorized only pursuant to a valid written license  */
/* from Digital or an authorized sublicensor.                                 */
/******************************************************************************/

#ifndef RTR_PROTO
#define RTR_PROTO 1

/*
 * File name:            Full file name:
 *  RTRPROTO.H            RTR - Function prototypes.
 *
 * Creation date:
 *  28-FEB-1991
 *
 * Purpose summary:
 *  Function prototypes used in application programs using the RTR library
 *  C interface.
 *
 * Revision date:       Revised by:     Revision summary:
 *  09-10-1992		Ronald Tschalaer  added MS-DOS defs and waited forms
 *					  of calls
 *
 */


/* Defines some default values for the parameters. */

#define RTR_NO_EFN        (rtr_uns_8_t _far *) NULL
#define RTR_NO_FLAGS      0
#define RTR_NO_TXSB       (RTR__TXSB _far *) NULL
#define RTR_NO_ASTADR     (void (_far *)(rtr_uns_32_t)) NULL
#define RTR_NO_CALLBACK   (void (_far *)(rtr_uns_32_t)) NULL
#define RTR_NO_BUFFER     (char _far *) NULL
#define RTR_NO_BUFLEN     0
#define RTR_NO_ASTPRM     0
#define RTR_NO_FACNAM     (char _far *) NULL
#define RTR_NOACCESS     (RTR__ACCESS _far *) NULL
#define RTR_NO_DATPAR     (RTR__DATPAR_ELEM _far *) NULL
#define RTR_NO_ASTEVT     (void (_far *)(RTR__EVT _far *)) NULL
#define RTR_NO_EVTAST     (void (_far *)(RTR__EVT _far *)) NULL
#define RTR_NO_EVTMSK     (RTR__EVTMSK _far *) NULL
#define RTR_NO_RESADR     (void (_far *)(void)) NULL
#define RTR_NO_EVTNAM     (char _far *) NULL
#define RTR_NO_EVTSTS     0
#define RTR_NO_TIMEOUT    (char _far *) NULL
#define RTR_NO_RSNSTS     0


/* [..] Indicates parameters where default values defined above can be used. */


#if defined(__cplusplus)
extern "C" {
#endif

typedef void (*rtr_completion_ast_t)(rtr_uns_32_t);

extern rtr_uns_32_t RTRAPI rtr_dcl_tx_prc (rtr_uns_8_t     _far  *,          /* [efn]      */
                       rtr_uns_16_t     _far  *,          /* ch     */
                       rtr_uns_32_t,                  /* flags      */
                       RTR__TXSB    _far  *,      /* [txsb]     */
                       void (_far *)(rtr_uns_32_t),   /* [astadr]     */
                       rtr_uns_32_t,                  /* [astprm]     */
                       char     _far  *,          /* [facnam]     */
                       RTR__ACCESS    _far  *,    /* [access]     */
                       RTR__DATPAR_ELEM _far  *,  /* [datpar]     */
                       void (_far *)(RTR__EVT _far *),  /* [evtast]     */
                       RTR__EVTMSK    _far  *,    /* [evtmsk]     */
                       void (_far *)(void),       /* [resadr]     */
                       char     _far  *);         /* [evtnam]     */

extern rtr_uns_32_t RTRAPI rtr_dcl_tx_prcw(rtr_uns_8_t     _far  *,          /* [efn]      */
                       rtr_uns_16_t     _far  *,          /* ch     */
                       rtr_uns_32_t,                  /* flags      */
                       RTR__TXSB    _far  *,      /* [txsb]     */
                       void (_far *)(rtr_uns_32_t),     /* [astadr]     */
                       rtr_uns_32_t,                  /* [astprm]     */
                       char     _far  *,          /* [facnam]     */
                       RTR__ACCESS    _far  *,    /* [access]     */
                       RTR__DATPAR_ELEM _far  *,  /* [datpar]     */
                       void (_far *)(RTR__EVT _far *),  /* [evtast]     */
                       RTR__EVTMSK    _far  *,    /* [evtmsk]     */
                       void (_far *)(void),       /* [resadr]     */
                       char     _far  *);         /* [evtnam]     */


extern rtr_uns_32_t RTRAPI rtr_commit_tx (rtr_uns_8_t     _far  *,     /* [efn]    */
                      rtr_uns_16_t,                 /* ch       */
                      rtr_uns_32_t,             /* [flags]  */
                      RTR__TXSB  _far  *,   /* [txsb]   */
                      void (_far *)(rtr_uns_32_t),  /* [astadr] */
                      rtr_uns_32_t);            /* [astprm] */

extern rtr_uns_32_t RTRAPI rtr_commit_txw(rtr_uns_8_t     _far  *,     /* [efn]    */
                      rtr_uns_16_t,                 /* ch       */
                      rtr_uns_32_t,             /* [flags]  */
                      RTR__TXSB  _far  *,   /* [txsb]   */
                      void (_far *)(rtr_uns_32_t),  /* [astadr] */
                      rtr_uns_32_t);            /* [astprm] */

extern rtr_uns_32_t RTRAPI rtr_abort_tx (rtr_uns_8_t   _far  *,        /* [efn]    */
                     rtr_uns_16_t,                  /* ch       */
                     rtr_uns_32_t,              /* [flags]  */
                     RTR__TXSB  _far  *,    /* [txsb]   */
                     void (_far *)(rtr_uns_32_t),   /* [astadr] */
                     rtr_uns_32_t,              /* [astprm] */
                     rtr_uns_32_t           );  /* [rsnsts] */

extern rtr_uns_32_t RTRAPI rtr_abort_txw(rtr_uns_8_t   _far  *,        /* [efn]    */
                     rtr_uns_16_t,                  /* ch       */
                     rtr_uns_32_t,              /* [flags]  */
                     RTR__TXSB  _far  *,    /* [txsb]   */
                     void (_far *)(rtr_uns_32_t),   /* [astadr] */
                     rtr_uns_32_t,              /* [astprm] */
                     rtr_uns_32_t           );  /* [rsnsts] */

extern rtr_uns_32_t RTRAPI rtr_enq_tx (rtr_uns_8_t   _far *,           /* [efn]    */
                   rtr_uns_16_t,                    /* ch       */
                   rtr_uns_32_t,                /* [flags]  */
                   RTR__TXSB    _far *,     /* [txsb]   */
                   void (_far *)(rtr_uns_32_t), /* [astadr] */
                   rtr_uns_32_t,                /* [astprm] */
                   rtr_uns_8_t   _far *,           /* bufadr   */
                   rtr_uns_16_t,                    /* buflen   */
                   RTR__EVTMSK  _far *,   /* [evtmsk] */
                   rtr_uns_32_t,              /* [evtsts] */
                   char   _far *);        /* [evtnam] */

extern rtr_uns_32_t RTRAPI rtr_enq_txw(rtr_uns_8_t   _far *,         /* [efn]    */
                   rtr_uns_16_t,                  /* ch       */
                   rtr_uns_32_t,              /* [flags]  */
                   RTR__TXSB    _far *,   /* [txsb]   */
                   void (_far *)(rtr_uns_32_t),   /* [astadr] */
                   rtr_uns_32_t,              /* [astprm] */
                   rtr_uns_8_t   _far *,         /* bufadr   */
                   rtr_uns_16_t,                  /* buflen   */
                   RTR__EVTMSK  _far *,   /* [evtmsk] */
                   rtr_uns_32_t,              /* [evtsts] */
                   char   _far *);        /* [evtnam] */

extern rtr_uns_32_t RTRAPI rtr_deq_tx (rtr_uns_8_t       _far *,     /* [efn]    */
                   rtr_uns_16_t,                  /* ch       */
                   rtr_uns_32_t,              /* [flags]  */
                   RTR__TXSB        _far *,   /* [txsb]   */
                   void (_far *)(rtr_uns_32_t),   /* [astadr] */
                   rtr_uns_32_t,                  /* [astprm] */
                   rtr_uns_8_t       _far *,     /* bufadr   */
                   rtr_uns_16_t       );          /* buflen   */

extern rtr_uns_32_t RTRAPI rtr_deq_txw(rtr_uns_8_t       _far *,     /* [efn]    */
                   rtr_uns_16_t,                  /* ch       */
                   rtr_uns_32_t,              /* [flags]  */
                   RTR__TXSB        _far *,   /* [txsb]   */
                   void (_far *)(rtr_uns_32_t),   /* [astadr] */
                   rtr_uns_32_t,                  /* [astprm] */
                   rtr_uns_8_t       _far *,     /* bufadr   */
                   rtr_uns_16_t       );          /* buflen   */

extern rtr_uns_32_t RTRAPI rtr_set_txi(void);

extern rtr_uns_32_t RTRAPI rtr_get_txi(void);

/*
**extern rtr_uns_32_t RTRAPI rtr_start_tx(
**    rtr_uns_16_t	ch,
**    rtr_uns_32_t	flags,
**    RTR__TXSB _far     *txsb,
**    rtr_sgn_8_t _far   *ptimeout
**    );
**
**
**extern rtr_uns_32_t RTRAPI rtr_error_text(
**    rtr_uns_32_t	status,
**    rtr_uns_8_t _far   *buffer,
**    rtr_uns_16_t _far  *buflen
**    );
**
*/



#if defined(__cplusplus)
}
#endif

#endif /* #ifndef RTR_PROTO */
/******************************************************************************/
/* Copyright Digital Equipment Corporation 1993. All rights reserved.         */
/*                                                                            */
/* Restricted Rights: Use, duplication, or disclosure by the U.S. Government  */
/* is subject to restrictions as set forth in subparagraph (c) (1) (ii) of    */
/* DFARS 252.227-7013, or in FAR 52.227-19, or in FAR 52.227=14 Alt. III, as  */
/* applicable.                                                                */
/*                                                                            */
/* This software is proprietary to and embodies the confidential technology   */
/* of Digital Equipment Corporation. Possession, use, or copying of this      */
/* software and media is authorized only pursuant to a valid written license  */
/* from Digital or an authorized sublicensor.                                 */
/******************************************************************************/

#ifndef RTR_LOC_ERR
#define RTR_LOC_ERR 1

/*
 * File name:           Full file name:
 *  RTRLOCER.H           RTR - Local condition values definition.
 *
 * Creation date:       Created by:
 *  25-SEP-1990
 *
 * Purpose summary:
 *  Defines local RTR condition values & error messages.
 *
 * Compilation & link:
 *  No compilation, no link.
 *
 * Revision date:       Revised by:     Revision summary:
 *  23-Jan-1993         Ronald Tschalaer  1st attempt to unify the MSDOS
 *                                        and Ultrix error codes...
 *  24-Aug-1993         Juergen Stieger   added RCH-Version mismatch
 *                                        added DLL-Error-Stuff
 *                                        extended to 777906
 */


/* Messages range. */

#define RTR__ERROR_LOW		777666
#define RTR__ERROR_HIGH		777906


/* Warning messages. */

/* The message text returned from the RCH was truncated */
#define RTR__TRUNCATED          777666


/* Error messages. */

/* Internal fatal error, non recoverable errror, should not happen. */
#define RTR__FATAL              777674

/* The function called is not implemented in the current version. */
#define RTR__NOT_IMPLEMENTED    777682

/* The function callled is unknown. */
#define RTR__UNKNOWN            777690

/* Not enough memory to process the current call. */
#define RTR__NO_MEM             777698

/* Unable to connect to the remote client handler. */
#define RTR__CONNECT_ERROR      777706

/* The host is unknown. */
#define RTR__HOST_UNKNOWN       777714

/* Error closing the network connection. */
#define RTR__CLOSE_ERROR        777722

/* Error sending a message on the network. */
#define RTR__SEND_ERROR         777730

/* Error reading a message on the network. */
#define RTR__RECEIVE_ERROR      777738

/* The link to the rch is down. */
#define RTR__LINK_ERROR         777746

/* Error in the protocol. */
#define RTR__PROTOCOL_ERROR     777754

/* Error with socket operations. */
#define RTR__SOCKET_ERROR       777762

/* Error when asking for a network operation. */
#define RTR__EMPTY_ERROR        777770

/* The exit handler was not installed. */
#define RTR__NO_EXIT            777778


#if defined(MSDOS) && !defined(_WIN32)


    /* The connection to the rch failed, the network is not installed. */
#define RTR__NET_NOT_INSTALLED    777786
    /* The RTR TSR is not loaded. */
#define RTR__TSR_NOT_LOADED       777794
    /* Version mismatch between the Interface and the TSR */
#define RTR__LIOCB_VERSMISM       777802


    /* Errors generated by the DLL */


      /* Bad CallFarRealModeProc on Inform_RTR_of_LIOCB */
#define RTR__BADCALFAR 777810
      /* Bad CallFarRealModeProc on INIT_RECEIVE */
#define RTR__BADINIRCV 777818
      /* Bad AllocRealModeCallbackAddr */
#define RTR__BADALLRCB 777826
      /* Bad RealMemorySelector */
#define RTR__BADMEMSEL 777834
      /* Error Registering Messages */
#define RTR__ERRREGMSG 777842
      /* Wrong Windows Version */
#define RTR__WRGWINVER 777850
      /* Bad Task Handle */
#define RTR__BADTSKHND 777858

#else /* MSDOS */

    /* The packet is too long for the protocol, protocol error. */
#define RTR__PACKET_ERROR       777786
    /* The signal handler was not installed. */
#define RTR__NO_SIGNAL          777794
    /* Error with event flag operations. */
#define RTR__EVTFLG_ERROR       777802
    /* Error opening the 'rtrhosts' file. */
#define RTR__NO_HOSTSFILE       777810


#endif /* #ifdef MSDOS */


/* Version mismatch between RCH and remote-client */
#define RTR__RCH_VERMISM          777866


/* Reserved error messages. */
#define RTR__RESERVED_1   777874
#define RTR__RESERVED_2   777882
#define RTR__RESERVED_3   777890
#define RTR__RESERVED_4   777898
#define RTR__RESERVED_5   777906

#ifdef need_error_texts

    static char *rtr_errlist[] = {
    "%RTR-E-LOCAL - The message text returned from the RCH was truncated.",
    "%RTR-E-LOCAL - Fatal internal error.",
    "%RTR-E-LOCAL - Function is not implemented.",
    "%RTR-E-LOCAL - The function called is unknown.",
    "%RTR-E-LOCAL - Not enough memory.",
    "%RTR-E-LOCAL - Connection to the Remote Client Handler failed.",
    "%RTR-E-LOCAL - Host name is undefined.",
    "%RTR-E-LOCAL - Error closing network connection.",
    "%RTR-E-LOCAL - Error sending a message on the network.",
    "%RTR-E-LOCAL - Error reading a message on the network.",
    "%RTR-E-LOCAL - The link to the remote client handler is down.",
    "%RTR-E-LOCAL - Protocol error.",
    "%RTR-E-LOCAL - Socket operation error.",
    "%RTR-E-LOCAL - Network information query error.",
    "%RTR-E-LOCAL - Exit handler installation error.",

#if defined(MSDOS) && !defined(_WIN32)

	"%RTR-E-LOCAL - The network is not installed.",
	"%RTR-E-LOCAL - The RTR TSR is not loaded.",
	"%RTR-E-LOCAL - Version mismatch between rtrintfc.c and the TSR.",
	"%RTR-E-LOCAL - Bad CallFarRealModeProc on Inform_RTR_of_LIOCB.",
	"%RTR-E-LOCAL - Bad CallFarRealModeProc on INIT_RECEIVE.",
	"%RTR-E-LOCAL - Bad AllocRealModeCallbackAddr.",
	"%RTR-E-LOCAL - Bad RealMemorySelector.",
	"%RTR-E-LOCAL - Error Registering Messages.",
	"%RTR-E-LOCAL - Wrong Windows Version.",
	"%RTR-E-LOCAL - Bad Task Handle.",

#else

	"%RTR-E-LOCAL - Packet too long for the protocol.",
	"%RTR-E-LOCAL - Signal handler installation error.",
	"%RTR-E-LOCAL - Semaphore operation error.",
	"%RTR-E-LOCAL - Error opening file 'rtrhosts'.",

#endif /* #ifdef MSDOS */

    "%RTR-E-LOCAL - Version mismatch between RCH and remote-client.",

    "%RTR-E-LOCAL - 777874 Undefined.",
    "%RTR-E-LOCAL - 777882 Undefined.",
    "%RTR-E-LOCAL - 777890 Undefined.",
    "%RTR-E-LOCAL - 777898 Undefined.",
    "%RTR-E-LOCAL - 777906 Undefined."
    };

#endif  /* need_error_texts */

#endif /* #ifndef RTR_LOC_ERR */

#pragma pack()
#ifdef __VMS
#pragma member_alignment restore
#endif

#endif /* RTR_RTR_H */
