/***************************************************************************
  Windows Sockets Client Application Support Module

  Written by:
      John A. Junod             Internet: <junodj@gordon-emh2.army.mil>
      267 Hillwood Street                 <zj8549@trotter.usma.edu>
      Martinez, GA 30907      Compuserve: 72321,366 

  This program executable and all source code is released into the public
  domain.  It would be nice (but is not required) to give me a little 
  credit for any use of this code.

  THE INFORMATION AND CODE PROVIDED IS PROVIDED AS IS WITHOUT WARRANTY 
  OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
  THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
  PURPOSE. IN NO EVENT SHALL JOHN A. JUNOD BE LIABLE FOR ANY DAMAGES 
  WHATSOEVER INCLUDING DIRECT, INDIRECT, INCIDENTAL, CONSEQUENTIAL, LOSS 
  OF BUSINESS PROFITS OR SPECIAL DAMAGES, EVEN IF JOHN A. JUNOD HAS BEEN 
  ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

*****************************************************************************/
/*
  MODULE: WS_PAINT.C  (main window (debug) display routines)
*/

#include "ws_glob.h"
#include "ws_ftp.h"
#include "version.h"

#include <stdarg.h>

extern struct win_info DBUGWINDOW;

void ReleaseDisplayMem()       { ReleaseWindowMem(&DBUGWINDOW); }

void DoAddLine(LPSTR szString) { DoAddWindowLine(&DBUGWINDOW,szString); }

void DoPrintf(char *szFormat,...)
{
   va_list vaArgs;
   static char szBuf[256];

   va_start(vaArgs,szFormat);
   if(vsprintf(szBuf,szFormat,vaArgs)!=EOF)
     DoAddWindowLine(&DBUGWINDOW,szBuf);
   va_end(vaArgs);
}

int GetLocalInfo()
{
  int nRc;
  struct hostent *hostptr;
 // char *ptr;
  struct in_addr *iptr;

//DoWindowPrintf(&DBUGWINDOW,"System Status: %s", (LPSTR)WSAData.szSystemStatus);
  if((nRc=gethostname((LPSTR)szString,
             MAXHOSTNAMELEN))==SOCKET_ERROR)
    ReturnWSError(WSAGetLastError(),&szMsgBuf2[strlen(szMsgBuf2)]);
  else
    DoWindowPrintf(&DBUGWINDOW,"Local Hostname: %s",szString);

  if(!nRc)
  {
    if((hostptr=gethostbyname(szString))==NULL) {
      ReportWindowWSError(&DBUGWINDOW,"gethostbyname",WSAGetLastError());
    } else {
      while ( (iptr = (struct in_addr *) *(hostptr->h_addr_list)) != NULL) {
        DoWindowPrintf(&DBUGWINDOW,"Local Address: %s",inet_ntoa(*iptr));
        hostptr->h_addr_list++;
      }
    }
  }
  DoWindowPrintf(&DBUGWINDOW,"WINSOCK.DLL: %s",(LPSTR)WSAData.szDescription);
  DoWindowPrintf(&DBUGWINDOW,"WS_FTP version %s written by John A. Junod/L. Kahn",VERSION);
  return(TRUE);
}

void ReleaseWindowMem(struct win_info *Window)
{
  int nIndex;
  for(nIndex=0;nIndex<Window->nMemPtr;nIndex++)
    GlobalFree(Window->hGMem[nIndex]);
  Window->nMemPtr=0;
}

void DoAddWindowLine(struct win_info *Window,LPSTR szString)
{
  GLOBALHANDLE hGlobalMemory;
  LPSTR lpGlobalMemory;
  int nIndex;
  RECT rect;

  if(!(bVerbose) && szString[0]=='[')
    return;

 // lgk only don't print if we are not in debug mode zzz

  if ((szString[0]!='[') || DEBUGGING_ON)
    SetStatus((LPSTR)szString);
// SendMessage(hTxtStatus,WM_SETTEXT,0,(LONG)szString);
  // added in some error checking to try to eliminate GPFs
  if(szString) {
    nIndex=strlen(szString);
    if(nIndex>0 && (hGlobalMemory=GlobalAlloc(GMEM_MOVEABLE,nIndex))!=NULL) {
      if((lpGlobalMemory=GlobalLock(hGlobalMemory))!=NULL) {
        lstrcpy(lpGlobalMemory,szString);
        GlobalUnlock(hGlobalMemory);
        if(Window->nMemPtr<90) {
          Window->hGMem[Window->nMemPtr++]=hGlobalMemory;
        } else {
          if(GlobalFree(Window->hGMem[0])==NULL) {
            for(nIndex=0;nIndex<90;nIndex++)
              Window->hGMem[nIndex]=Window->hGMem[nIndex+1];
            Window->hGMem[Window->nMemPtr-1]=hGlobalMemory;
          }
        }
      }
    }
  }
  GetClientRect(Window->hWnd,&rect);
  rect.top=min(0,(Window->nMemPtr-Window->nVpos-1))*Window->nLineHeight;

  if(Window->nMemPtr > (Window->nVpos+Window->nScreenRows))
    PostMessage(Window->hWnd,WM_VSCROLL,SB_LINEDOWN,0L);
  else
    InvalidateRect(Window->hWnd,&rect,TRUE);

  UpdateWindow(Window->hWnd);
}

void DoWindowPrintf(struct win_info *Window,char *szFormat,...)
{
   va_list vaArgs;
   static char szBuf[256];

   va_start(vaArgs,szFormat);
   if(vsprintf(szBuf,szFormat,vaArgs)!=EOF)
     DoAddWindowLine(Window,szBuf);
   va_end(vaArgs);
}

void DoWindowPaint(struct win_info *Window)
{
  HDC         hDC;   // handle for the display device
  PAINTSTRUCT ps;    // holds PAINT information
//  int         nRc;
  int         nIndex;
  LPSTR       lpMem;

  RECT rRect;
  TEXTMETRIC tm;

  memset(&ps, 0x00, sizeof(PAINTSTRUCT));
  hDC = BeginPaint(Window->hWnd, &ps);
  // Included as the background is not a pure color
  SetBkMode(hDC, TRANSPARENT);
  GetTextMetrics(hDC,&tm);
  Window->nLineHeight=tm.tmHeight+tm.tmExternalLeading;
  GetClientRect(Window->hWnd,&rRect);
  Window->nScreenRows=rRect.bottom/Window->nLineHeight;

  if(Window->nScreenRows >= Window->nMemPtr)
      ShowScrollBar(Window->hWnd,SB_VERT,FALSE);
  else
      ShowScrollBar(Window->hWnd,SB_VERT,TRUE);

  for(nIndex=0;(nIndex+Window->nVpos)<Window->nMemPtr;nIndex++) {
    lpMem=GlobalLock(Window->hGMem[nIndex+Window->nVpos]);
    if(lpMem!=NULL) {
      TextOut(hDC,20,nIndex*Window->nLineHeight,lpMem,lstrlen(lpMem));
      GlobalUnlock(Window->hGMem[nIndex+Window->nVpos]);
    }
  }
  // Inform Windows painting is complete
  EndPaint(Window->hWnd, &ps);
}

