/* Macro error structure and error code definitions */
#define wMACRO_ERROR    128     /* Maximum error msg length */

typedef struct {
	WORD  fwFlags;        /* indicates how error will be handled */
	WORD  wError;         /* Macro error code */
	
	/* Error message (if wError == wMERR_MESSAGE) */
	char  rgchError[wMACRO_ERROR];
} ME, NEAR *PME,  FAR *QME;

/* Macro error codes */
#define wMERR_NONE      0       /* No error */
#define wMERR_MEMORY    1       /* Out of memory (local) */
#define wMERR_PARAM     2       /* Invalid parameter passed */
#define wMERR_FILE      3       /* Invalid file parameter */
#define wMERR_ERROR     4       /* General macro error */
#define wMERR_MESSAGE   5       /* Macro error with message */

/* Flags constants indicating how error may be handled */
#define fwMERR_ABORT    0x0001  /* Allow the "abort" option */
#define fwMERR_CONTINUE 0x0002  /* Allow the "continue" option */
#define fwMERR_RETRY    0x0004  /* Allow the "retry" option */

/* Classes of messages that may be sent to DLLs */
#define DC_NOMSG     0x00
#define DC_MINMAX    0x01
#define DC_INITTERM  0x02
#define DC_JUMP      0x04
#define DC_ACTIVATE  0x08
#define DC_CALLBACKS 0x10

/* Messages sent to DLLs */
#define DW_NOTUSED   0
#define DW_WHATMSG   1
#define DW_MINMAX    2
#define DW_SIZE      3
#define DW_INIT      4
#define DW_TERM      5
#define DW_STARTJUMP 6
#define DW_ENDJUMP   7
#define DW_CHGFILE   8
#define DW_ACTIVATE  9
#define DW_CALLBACKS 10

/* Embedded Window messages */
#define EWM_RENDER          0x706A
#define EWM_QUERYSIZE       0x706B
#define EWM_ASKPALETTE      0x706C
#define EWM_FINDNEWPALETTE  0x706D

/* Embedded Window structure */
typedef struct tagCreateInfo {
	short   idMajVersion;
	short   idMinVersion;
	LPSTR   szFileName;   /* Current Help file */
	LPSTR   szAuthorData; /* Text passed by the author */
	HANDLE  hfs;          /* Handle to the current file system */
	DWORD   coFore;       /* Foreground color for this topic */
	DWORD   coBack;       /* Background color for this topic */
} EWDATA, FAR *QCI;

/* Embedded window rendering info */
typedef struct tagRenderInfo {
	RECT  rc;
	HDC   hdc;
} RENDERINFO, FAR * QRI;

/* file mode flags */
#define fFSReadOnly       (BYTE)0x01
#define fFSOpenReadOnly   (BYTE)0x02
#define fFSReadWrite      (BYTE)0x00
#define fFSOpenReadWrite  (BYTE)0x00

/* seek origins */
#define wFSSeekSet      0
#define wFSSeekCur      1
#define wFSSeekEnd      2

/* low level info options */
#define wLLSameFid    0
#define wLLDupFid     1
#define wLLNewFid     2

/* Return codes (help file system) */
#define rcSuccess       0
#define rcFailure       1
#define rcExists        2
#define rcNoExists      3
#define rcInvalid       4
#define rcBadHandle     5
#define rcBadArg        6
#define rcUnimplemented 7
#define rcOutOfMemory   8
#define rcNoPermission  9
#define rcBadVersion    10
#define rcDiskFull      11
#define rcInternal      12
#define rcNoFileHandles 13
#define rcFileChange    14
#define rcTooBig        15

/* following not from core engine: */
#define rcReadError     101   /* Errors for Error() */
#define wERRS_OOM               2   /* Out of memory */
#define wERRS_NOHELPPS          3   /* No help in print setup */
#define wERRS_NOHELPPR          4   /* No help while printing */
#define wERRS_FNF            1001   /* Cannot find file */
#define wERRS_NOTOPIC        1002   /* Topic does not exist */
#define wERRS_NOPRINTER      1003   /* Cannot print */
#define wERRS_PRINT          1004   /* Print error */
#define wERRS_EXPORT         1005   /* Can't copy to clipboard */
#define wERRS_BADFILE        1006   /* Not a Windows Help file */
#define wERRS_OLDFILE        1007   /* Cannot read help file */
#define wERRS_VIRUS          1011   /* Bad .EXE */
#define wERRS_BADDRIVE       1012   /* Invalid drive */
#define wERRS_WINCLASS       1014   /* Bad window class */
#define wERRS_BADKEYWORD     3012   /* Invalid keyword */
#define wERRS_BADPATHSPEC    3015   /* Invalid path */
#define wERRS_PATHNOTFOUND   3017   /* Path not found */
#define wERRS_DIALOGBOXOOM   3018   /* No memory for dialog */
#define wERRS_DISKFULL       5001   /* Disk is full */
#define wERRS_FSREADWRITE    5002   /* File I/O error */

/* Actions for LGetInfo() */
#define GI_NOTHING   0  /* Not used */
#define GI_INSTANCE  1  /* Application instance handle */
#define GI_MAINHWND  2  /* Main window handle */
#define GI_CURRHWND  3  /* Current window handle */
#define GI_HFS       4  /* Handle to file system in use */
#define GI_FGCOLOR   5  /* Foreground color used by app */
#define GI_BKCOLOR   6  /* Background color used by app */
#define GI_TOPICNO   7  /* Topic number */
#define GI_HPATH     8  /* Handle containing path */

/* Callback Function Table offsets: */
#define HE_NotUsed           0
#define HE_HfsOpenSz         1
#define HE_RcCloseHfs        2
#define HE_HfOpenHfs         3
#define HE_RcCloseHf         4
#define HE_LcbReadHf         5
#define HE_LTellHf           6
#define HE_LSeekHf           7
#define HE_FEofHf            8
#define HE_LcbSizeHf         9
#define HE_FAccessHfs       10
#define HE_RcLLInfoFromHf   11
#define HE_RcLLInfoFromHfs  12
#define HE_ErrorW           13
#define HE_ErrorSz          14
#define HE_GetInfo          15
#define HE_API              16
