//////////////////////////////////////////////////////////////////////////////////
// Project Name:   [ CDX Class Library - CDX.lib ]
// Source File:    [ CDXMMMap Implementation ]
// Author:         [ Bil Simser - bsimser@home.com ]
// Contributions:  [ Lennart Steinke ]
// Revision:       [ 1.99a ]
//////////////////////////////////////////////////////////////////////////////////
#include "CDX.h"

//////////////////////////////////////////////////////////////////////////////////
// CDXMMMap Default Constructor
//////////////////////////////////////////////////////////////////////////////////
CDXMMMap::CDXMMMap()
{
}

//////////////////////////////////////////////////////////////////////////////////
// CDXMMMap Constructor
//////////////////////////////////////////////////////////////////////////////////
CDXMMMap::CDXMMMap(CDXTile *pTiles, CDXScreen *pScreen)
{
	m_bInit   = FALSE;
	m_dwWidth = 0;
	m_dwHeight= 0;

	DATA = NULL;
	Tiles = pTiles;

	m_TileWidth = Tiles->m_BlockWidth;
	m_TileHeight = Tiles->m_BlockHeight;

	m_PosX = 0;
	m_PosY = 0;

	SCREEN_W = pScreen->m_dwPixelWidth;
	SCREEN_H = pScreen->m_dwPixelHeight;

	SCREEN_TW = SCREEN_W / m_TileWidth;
	SCREEN_TH = SCREEN_H / m_TileHeight;
}

//////////////////////////////////////////////////////////////////////////////////
// CDXMMMap Destructor
//////////////////////////////////////////////////////////////////////////////////
CDXMMMap::~CDXMMMap()
{
	if (m_bInit)
	{
		m_bInit= FALSE;
		if (m_pMap)
		{
			free (m_pMap);
			m_pMap = NULL;
		}
	}

	delete [] DATA;
}

//////////////////////////////////////////////////////////////////////////////////
// CDXMMMap Create
//////////////////////////////////////////////////////////////////////////////////
void CDXMMMap::Create(int Width, int Height, int Fill)
{
	m_Width = Width;
	m_Height = Height;

	m_PixelWidth = m_Width * m_TileWidth;
	m_PixelHeight = m_Height * m_TileHeight;

	SIZE = m_Width * m_Height;
	DATA = new int[SIZE];

	for(int i=0; i<SIZE; i++)
		DATA[i] = Fill;
}

//////////////////////////////////////////////////////////////////////////////////
// CDXMMMap GetTile
//////////////////////////////////////////////////////////////////////////////////
int CDXMMMap::GetTile(int MapX, int MapY)
{
	return DATA[MapX + (MapY * m_Width)];
}
/*
BOOL CDXMMMap::Create(const char *szFilename)
{
	// Load a MapMaker map from file.
	FILE *f;

	f= fopen(szFilename, "rb");

	// Read size and Magic bytes to check if this is a 
	// valid file
	DWORD size=0;
	
	fread(&size, sizeof(DWORD), 1, f);
	if (size != 0x0134)
	{
		fclose(f);
		return FALSE;
	}

	DWORD magic;
	fread(&magic, sizeof(DWORD), 1, f);
	if (magic !=  0x0050414d) // magic != (4d,41,50,00 = "MAP\0") (Intel byte ordering!)
	{
		fclose(f);
		return FALSE;
	}

	// Check version, only 1.1 supported
	WORD version;
	fread(&version, sizeof(WORD), 1,f);
	if (version != 0x0101)
	{
		fclose(f);
		return FALSE;
	}

	// skip the next two bytes
	fseek(f, 2, SEEK_CUR);

	// Read width and height
	DWORD width, height;
	fread(&width , sizeof(DWORD), 1, f);
	fread(&height, sizeof(DWORD), 1, f);

	// Skip the rest of the header, and go to the data 
	fseek(f, 0x0134, SEEK_SET);

	// Now, let's create an array large enough to hold all the data...
	CDXMapMakerCell* map;
	map = (CDXMapMakerCell*) malloc( width * height * sizeof(CDXMapMakerCell));
	if (!map)
	{
		// No memory
		fclose(f);
		return NULL;
	}
	LONG cur =0;
	WORD tmp;

	for (DWORD y=0; y< height; y++)
	{
		for (DWORD x=0; x<width; x++)
		{
			for (int act_layer=0; act_layer <4; act_layer++)
			{
				
				fread(&tmp, sizeof(WORD), 1, f);
				map[cur].layer[act_layer] = tmp;
			}

			fread(&(map[cur].walkability), 1, 1, f);
			fread(&(map[cur].walkspecial), 1, 1, f);
			fread(&(map[cur].flags      ), 4, 1, f);
			fread(&tmp                   , 2, 1, f);
			fread(&(map[cur].special    ), 4, 1, f);
			cur++;
		}
	}
	fclose(f);

	m_dwWidth  = width;
	m_dwHeight = height;
	m_pMap     = map;

	m_bInit = TRUE;

	return TRUE;
}

inline CDXMapMakerCell *CDXMMMap::GetAt(DWORD x, DWORD y)
{
	return &(m_pMap[x + y*m_dwWidth]);
}

inline WORD CDXMMMap::GetTileAt(DWORD x, DWORD y, DWORD layer)
{
	return (m_pMap[x + y*m_dwWidth]).layer[layer];
}

inline DWORD CDXMMMap::GetWidth(void)
{
	return m_dwWidth;
}

inline DWORD CDXMMMap::GetHeight(void)
{
	return m_dwHeight;
}

void CDXMMMap::FillCDXMap(CDXMap *map, int layer)
{
	DWORD width  = map->m_Width;
	DWORD height = map->m_Height;
	int cur=0;

	if (width > GetWidth())
	{
		width = GetWidth();
	}
	if (height > GetHeight())
	{
		height = GetHeight();
	}

	DWORD x,y;
	for (y=0; y < height; y++)
	{
		for (x=0; x < width; x++)
		{
			map->SetTile(x,y, GetTileAt(x,y,layer));
		}
	}
}

*/