//////////////////////////////////////////////////////////////////////////////////
// Project Name:   [ CDX Class Library - CDX.lib ]
// Source File:    [ CDXSprite Implementation ]
// Author:         [ Bil Simser - bsimser@home.com ]
// Contributions:  [ Dan Farley, Harold L. Blankenship ]
// Revision:       [ 1.99a ]
//////////////////////////////////////////////////////////////////////////////////
#include "CDX.h"

//////////////////////////////////////////////////////////////////////////////////
// CDXSprite Constructor
//////////////////////////////////////////////////////////////////////////////////
CDXSprite::CDXSprite(CDXTile* pTile)
{
	Create(pTile);
}

//////////////////////////////////////////////////////////////////////////////////
// CDXSprite Constructor
//////////////////////////////////////////////////////////////////////////////////
CDXSprite::CDXSprite(CDXScreen *pScreen, const char* Filename, int w, int h, int num, BOOL memoryType)
{
	Create(pScreen, Filename, w, h, num, memoryType);
}

//////////////////////////////////////////////////////////////////////////////////
// CDXSprite Destructor
//////////////////////////////////////////////////////////////////////////////////
CDXSprite::~CDXSprite(void)
{
//<JJH>
	if(m_TileCreated)
		delete m_Tile;
	else
		RELEASE(m_Tile->m_lpDDS);
//<JJH>

	m_Tile = NULL;
	m_Next = NULL;
	m_Prev = NULL;
}

//////////////////////////////////////////////////////////////////////////////////
// CDXSprite Create - creates a sprite object
//////////////////////////////////////////////////////////////////////////////////
BOOL CDXSprite::Create(CDXTile* pTile)
{
	if(pTile == NULL) 
		return FALSE;

//<JJH>
	m_PosX			= m_PosY = m_PosZ = 0;
	m_VelX			= m_VelY = 0;
	m_Frame			= 0;
	m_Delay			= 0;
	m_State			= 0;
	m_Type			= 0;
	m_Angle			= 0;
	m_Next			= NULL;
	m_Prev			= NULL;
	m_Tile			= pTile;
	m_ShadowValue	= 0;
	m_AlphaValue	= 0;
	m_TileCreated	= FALSE;

	m_Tile->m_lpDDS->AddRef();
//<JJH>

	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////////
// CDXSprite Create - creates a sprite object
//////////////////////////////////////////////////////////////////////////////////
BOOL CDXSprite::Create(CDXScreen *pScreen, const char* Filename, int w, int h, int num, BOOL memoryType)
{
	if(Filename == NULL) return FALSE;

	m_PosX = m_PosY = 0;
	m_VelX = m_VelY = 0;
	m_Frame = 0;
	m_Delay = 0;
	m_State = 0;
	m_Type = 0;

	m_Next = NULL;
	m_Prev = NULL;

	m_Tile = new CDXTile(pScreen, Filename, w, h, num, memoryType);

	return TRUE;
}

//<JJH>
//////////////////////////////////////////////////////////////////////////////////
// CDXSprite Draw - Staging area for all blits
//////////////////////////////////////////////////////////////////////////////////
void CDXSprite::Draw(CDXSurface* lpCDXS, DWORD ScrnWorldX, DWORD ScrnWorldY, WORD BltType)
{

	// lpCDXS		Destination CDXSurface pointer
	// ScrnWorldX	X postion of the left edge of the screen in world space
	// ScrnWorldY	Y postion of the top edge of the screen in world space
	// BltType		Type of BLT operation to perform

	RECT SpriteDestRect;	// Sprite RECT is defined in world space
	RECT SpriteSrcRect;		// RECT defining the source area for the BLT
	WORD TilesInWidth;		// Number of tiles in width of sprite tile surface
	DWORD SpriteSrcX;
	DWORD SpriteSrcY;
	HRESULT rval;

	// Validate the screen world space coordinates.
	if ( (ScrnWorldX == NULL) || (ScrnWorldX < 0) ) 
		ScrnWorldX = 0;
	if ( (ScrnWorldY == NULL) || (ScrnWorldY < 0) ) 
		ScrnWorldY = 0;

	// RECT defining the sprite in world space.
	SpriteDestRect.top    = m_PosY;
	SpriteDestRect.left   = m_PosX;
	SpriteDestRect.bottom = m_PosY + m_Tile->m_BlockHeight;
	SpriteDestRect.right  = m_PosX + m_Tile->m_BlockWidth;

	// Adjust the sprite RECT to screen space. Destination RECT for the BLT.
	SpriteDestRect.top    -= ScrnWorldY;
	SpriteDestRect.bottom -= ScrnWorldY;
	SpriteDestRect.left   -= ScrnWorldX;
	SpriteDestRect.right  -= ScrnWorldX;

	// Get the number of tiles in the sprite tile surface width
	TilesInWidth = m_Tile->m_PixelWidth / m_Tile->m_BlockWidth;

	// Calc the upper left corner of the current frame of animation
    SpriteSrcX = m_Frame % TilesInWidth * m_Tile->m_BlockWidth;
	SpriteSrcY  = m_Frame / TilesInWidth * m_Tile->m_BlockHeight;
	
	// Define the source RECT for the BLT.
	SpriteSrcRect.top = SpriteSrcY;
	SpriteSrcRect.left = SpriteSrcX;
	SpriteSrcRect.bottom = SpriteSrcY + m_Tile->m_BlockHeight;
	SpriteSrcRect.right = SpriteSrcX + m_Tile->m_BlockWidth;


	switch(BltType)
	{
	case CDXBLT_BLK:
		rval = BlkBlt(lpCDXS, SpriteSrcRect, SpriteDestRect);
		break;
	case CDXBLT_BLKALPHA:
		rval = BlkAlpha(lpCDXS, SpriteSrcRect, SpriteDestRect);
		break;
	case CDXBLT_BLKALPHAFAST:
		rval = BlkAlphaFast(lpCDXS, SpriteSrcRect, SpriteDestRect);
		break;
	case CDXBLT_BLKSCALED:
		//rval = BlkScaled(lpCDXS, SpriteSrcRect, SpriteDestRect);
		break;
	case CDXBLT_BLKSHADOW:
		rval = BlkShadow(lpCDXS, SpriteSrcRect, SpriteDestRect);
		break;
	case CDXBLT_BLKSHADOWFAST:
		rval = BlkShadowFast(lpCDXS, SpriteSrcRect, SpriteDestRect);
		break;
	case CDXBLT_BLKROTATED:
		//rval = BlkRotated(lpCDXS, SpriteSrcRect, SpriteDestRect);
		break;
	case CDXBLT_BLKROTOZOOM:
		//rval = BlkRotoZoom(lpCDXS, SpriteSrcRect, SpriteDestRect);
		break;
	case CDXBLT_BLKHFLIP:
		rval = BlkHFlip(lpCDXS, SpriteSrcRect, SpriteDestRect);
		break;
	case CDXBLT_BLKVFLIP:
		rval = BlkVFlip(lpCDXS, SpriteSrcRect, SpriteDestRect);
		break;
	
	case CDXBLT_TRANS:
		rval = TransBlt(lpCDXS, SpriteSrcRect, SpriteDestRect);
		break;
	case CDXBLT_TRANSALPHA:  
		rval = TransAlpha(lpCDXS, SpriteSrcRect, SpriteDestRect);
		break;
	case CDXBLT_TRANSALPHAFAST:
		rval = TransAlphaFast(lpCDXS, SpriteSrcRect, SpriteDestRect);
		break;
	case CDXBLT_TRANSSCALED:
		//rval = TransScaled(lpCDXS, SpriteSrcRect, SpriteDestRect);
		break;
	case CDXBLT_TRANSSHADOW:
		rval = TransShadow(lpCDXS, SpriteSrcRect, SpriteDestRect);
		break;
	case CDXBLT_TRANSSHADOWFAST:
		rval = TransShadowFast(lpCDXS, SpriteSrcRect, SpriteDestRect);
		break;
	case CDXBLT_TRANSROTATED:
		//rval = TransRotated(lpCDXS, SpriteSrcRect, SpriteDestRect);
		break;
	case CDXBLT_TRANSROTOZOOM:
		//rval = TransRotoZoom(lpCDXS, SpriteSrcRect, SpriteDestRect);
		break;
	case CDXBLT_TRANSHFLIP:
		rval = TransHFlip(lpCDXS, SpriteSrcRect, SpriteDestRect);
		break;
	case CDXBLT_TRANSVFLIP:
		rval = TransVFlip(lpCDXS, SpriteSrcRect, SpriteDestRect);
		break;
	default:
		break;
	}
}

//////////////////////////////////////////////////////////////////////////////////
// CDXSprite SetShadowOffset - 
//////////////////////////////////////////////////////////////////////////////////
void CDXSprite::SetShadowOffset(LONG dx, LONG dy)
{
	m_ShadowOffsetX = dx;
	m_ShadowOffsetY = dy;
}
//////////////////////////////////////////////////////////////////////////////////
// CDXSprite TransBlt - draws a transparent sprite
//////////////////////////////////////////////////////////////////////////////////
HRESULT CDXSprite::TransBlt(CDXSurface* lpCDXSDest, RECT SrcRect, RECT DestRect)
{
	HRESULT rval;

	rval = m_Tile->CDXBLT_Trans(lpCDXSDest, DestRect.left, DestRect.top, SrcRect);

	return rval;
}

//////////////////////////////////////////////////////////////////////////////////
// CDXSprite BlkBlt - draws a Block sprite, no transparency
//////////////////////////////////////////////////////////////////////////////////
HRESULT CDXSprite::BlkBlt(CDXSurface* lpCDXSDest, RECT SrcRect, RECT DestRect)
{
	HRESULT rval;

	rval = m_Tile->CDXBLT_Blk(lpCDXSDest, DestRect.left, DestRect.top, SrcRect);

	return rval;
}

//////////////////////////////////////////////////////////////////////////////////
// CDXSprite TransHFlip
//////////////////////////////////////////////////////////////////////////////////
HRESULT CDXSprite::TransHFlip(CDXSurface* lpCDXSDest, RECT SrcRect, RECT DestRect)
{
	HRESULT rval;

	rval = m_Tile->CDXBLT_TransHFlip(lpCDXSDest, DestRect.left, DestRect.top, SrcRect);

	return rval;
}

//////////////////////////////////////////////////////////////////////////////////
// CDXSprite BlkHFlip
//////////////////////////////////////////////////////////////////////////////////
HRESULT CDXSprite::BlkHFlip(CDXSurface* lpCDXSDest, RECT SrcRect, RECT DestRect)
{
	HRESULT rval;

	rval = m_Tile->CDXBLT_BlkHFlip(lpCDXSDest, DestRect.left, DestRect.top, SrcRect);

	return rval;
}

//////////////////////////////////////////////////////////////////////////////////
// CDXSprite TransVFlip
//////////////////////////////////////////////////////////////////////////////////
HRESULT CDXSprite::TransVFlip(CDXSurface* lpCDXSDest, RECT SrcRect, RECT DestRect)
{
	HRESULT rval;

	rval = m_Tile->CDXBLT_TransVFlip(lpCDXSDest, DestRect.left, DestRect.top, SrcRect);

	return rval;
}

//////////////////////////////////////////////////////////////////////////////////
// CDXSprite BlkVFlip
//////////////////////////////////////////////////////////////////////////////////
HRESULT CDXSprite::BlkVFlip(CDXSurface* lpCDXSDest, RECT SrcRect, RECT DestRect)
{
	HRESULT rval;

	rval = m_Tile->CDXBLT_BlkVFlip(lpCDXSDest, DestRect.left, DestRect.top, SrcRect);

	return rval;
}

////////////////////////////////////////////////////////////////////////
// CDXSprite BlkAlphaFast 
////////////////////////////////////////////////////////////////////////
HRESULT CDXSprite::BlkAlphaFast(CDXSurface* lpCDXSDest, RECT SrcRect, RECT DestRect)
{
	HRESULT rval;

	rval = m_Tile->CDXBLT_BlkAlphaFast(lpCDXSDest, DestRect.left, DestRect.top, SrcRect);

	return rval;
}


////////////////////////////////////////////////////////////////////////
// CDXSprite TransAlphaFast
////////////////////////////////////////////////////////////////////////
HRESULT CDXSprite::TransAlphaFast(CDXSurface* lpCDXSDest, RECT SrcRect, RECT DestRect)
{
	HRESULT rval;

	rval = m_Tile->CDXBLT_TransAlphaFast(lpCDXSDest, DestRect.left, DestRect.top, SrcRect);

	return rval;
}


//////////////////////////////////////////////////////////////////////////////////
// CDXSprite TransAlpha
//////////////////////////////////////////////////////////////////////////////////
HRESULT CDXSprite::TransAlpha(CDXSurface* lpCDXSDest, RECT SrcRect, RECT DestRect)
{
	HRESULT rval;

	rval = m_Tile->CDXBLT_TransAlpha(lpCDXSDest, DestRect.left, DestRect.top, SrcRect, m_AlphaValue);

	return rval;
}

//////////////////////////////////////////////////////////////////////////////////
// CDXSprite BlkAlpha
//////////////////////////////////////////////////////////////////////////////////
HRESULT CDXSprite::BlkAlpha(CDXSurface* lpCDXSDest, RECT SrcRect, RECT DestRect)
{
	HRESULT rval;

	rval = m_Tile->CDXBLT_BlkAlpha(lpCDXSDest, DestRect.left, DestRect.top, SrcRect, m_AlphaValue);

	return rval;
}

//////////////////////////////////////////////////////////////////////////////////
// CDXSprite BlkShadow 
//////////////////////////////////////////////////////////////////////////////////
HRESULT CDXSprite::BlkShadow(CDXSurface* lpCDXSDest, RECT SrcRect, RECT DestRect)
{
	HRESULT rval;

	rval = m_Tile->CDXBLT_BlkShadow(lpCDXSDest, DestRect.left - m_ShadowOffsetX, DestRect.top - m_ShadowOffsetY, SrcRect, m_ShadowValue);

	return rval;
}

//////////////////////////////////////////////////////////////////////////////////
// CDXSprite TransShadow
//////////////////////////////////////////////////////////////////////////////////
HRESULT CDXSprite::TransShadow(CDXSurface* lpCDXSDest, RECT SrcRect, RECT DestRect)
{
	HRESULT rval;

	rval = m_Tile->CDXBLT_TransShadow(lpCDXSDest, DestRect.left - m_ShadowOffsetX, DestRect.top - m_ShadowOffsetY, SrcRect, m_ShadowValue);

	return rval;
}

////////////////////////////////////////////////////////////////////////
// CDXSprite BlkShadowFast
////////////////////////////////////////////////////////////////////////
HRESULT CDXSprite::BlkShadowFast(CDXSurface* lpCDXSDest, RECT SrcRect, RECT DestRect)
{
	HRESULT rval;

	rval = m_Tile->CDXBLT_BlkShadowFast(lpCDXSDest, DestRect.left - m_ShadowOffsetX, DestRect.top - m_ShadowOffsetY, SrcRect);

	return rval;
}


////////////////////////////////////////////////////////////////////////
// CDXSprite TransShadowFast
////////////////////////////////////////////////////////////////////////
HRESULT CDXSprite::TransShadowFast(CDXSurface* lpCDXSDest, RECT SrcRect, RECT DestRect)
{
	HRESULT rval;

	rval = m_Tile->CDXBLT_TransShadowFast(lpCDXSDest, DestRect.left - m_ShadowOffsetX, DestRect.top - m_ShadowOffsetY, SrcRect);

	return rval;
}
//<JJH>

//////////////////////////////////////////////////////////////////////////////////
// CDXSprite SpriteHit - checks for sprite collisions
//////////////////////////////////////////////////////////////////////////////////
BOOL CDXSprite::SpriteHit(CDXSprite* pSprite)
{
	if(pSprite == this) return FALSE;

	RECT Rect1 = { m_PosX, m_PosY,
								 m_PosX + m_Tile->m_BlockWidth,
								 m_PosY + m_Tile->m_BlockHeight };
	RECT Rect2 = { pSprite->m_PosX, pSprite->m_PosY,
								 pSprite->m_PosX + pSprite->m_Tile->m_BlockWidth,
								 pSprite->m_PosY + pSprite->m_Tile->m_BlockHeight };

	if(Rect1.top > Rect2.bottom) return FALSE;
	else if(Rect1.bottom < Rect2.top) return FALSE;
	else if(Rect1.right < Rect2.left) return FALSE;
	else if(Rect1.left > Rect2.right) return FALSE;

	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////////
// CDXSprite TileHit - checks for tile collisions
//////////////////////////////////////////////////////////////////////////////////
BOOL CDXSprite::TileHit(CDXMap* pMap, int Tile)
{
	int MapX, MapY, TileType;

	// Check top left
  MapX = (pMap->m_PosX + m_PosX) / pMap->m_TileWidth;
  MapY = (pMap->m_PosY + m_PosY) / pMap->m_TileHeight;
  TileType = pMap->GetTile(MapX, MapY);
  if(TileType == Tile) return TRUE;

	// Check top right
  MapX = (pMap->m_PosX + m_PosX + m_Tile->m_BlockWidth) / pMap->m_TileWidth;
  MapY = (pMap->m_PosY + m_PosY) / pMap->m_TileHeight;
  TileType = pMap->GetTile(MapX, MapY);
  if(TileType == Tile) return TRUE;

	// Check bottom left
  MapX = (pMap->m_PosX + m_PosX) / pMap->m_TileWidth;
  MapY = (pMap->m_PosY + m_PosY + m_Tile->m_BlockHeight) / pMap->m_TileHeight;
  TileType = pMap->GetTile(MapX, MapY);
  if(TileType == Tile) return TRUE;

	// Check bottom right
  MapX = (pMap->m_PosX + m_PosX + m_Tile->m_BlockWidth) / pMap->m_TileWidth;
  MapY = (pMap->m_PosY + m_PosY + m_Tile->m_BlockHeight) / pMap->m_TileHeight;
  TileType = pMap->GetTile(MapX, MapY);
  if(TileType == Tile) return TRUE;

	return FALSE;
}
