//////////////////////////////////////////////////////////////////////////////////
// Project Name:   [ CDX Class Library - CDX.lib ]
// Source File:    [ CDXSpriteList Implementation ]
// Author:         [ Bil Simser - bsimser@home.com ]
// Contributions:  [ Dan Farley ]
// Revision:       [ 1.99a ]
//////////////////////////////////////////////////////////////////////////////////
#include "CDX.h"

//////////////////////////////////////////////////////////////////////////////////
// CDXSpriteList Constructor
//////////////////////////////////////////////////////////////////////////////////
CDXSpriteList::CDXSpriteList(void)
{
	m_List.m_Next = m_List.m_Prev = &m_List;
	m_List.SetPos(0,0);
	m_List.SetVel(0,0);

	m_nSprites = 0;
}

//////////////////////////////////////////////////////////////////////////////////
// CDXSpriteList Destructor
//////////////////////////////////////////////////////////////////////////////////
CDXSpriteList::~CDXSpriteList(void)
{
}

//////////////////////////////////////////////////////////////////////////////////
// CDXSpriteList AddSprite
//////////////////////////////////////////////////////////////////////////////////
CDXSprite *CDXSpriteList::AddSprite(CDXTile* pTile, int Type, int PosX, int PosY, 
							  int VelX, int VelY, int State, int Frame, int Delay)
{
	CDXSprite* Node;

	// Create a new sprite
	Node = new CDXSprite(pTile);
	if(Node == NULL) 
		return Node;

	// Setup sprite
	Node->SetType(Type);
	Node->SetPos(PosX, PosY);
	Node->SetVel(VelX, VelY);
	Node->SetState(State);
	Node->SetFrame(Frame);
	Node->SetDelay(Delay);

	// Add sprite too list
	Node->m_Next = m_List.m_Next;
	Node->m_Prev = &m_List;
	m_List.m_Next->m_Prev = Node;
	m_List.m_Next = Node;

	m_nSprites++;

	return Node;
}

//////////////////////////////////////////////////////////////////////////////////
// CDXSpriteList DelSprite
//////////////////////////////////////////////////////////////////////////////////
void CDXSpriteList::DelSprite(CDXSprite* pNode)
{
	if(m_List.m_Next == &m_List) 
		return;

	m_nSprites--;

	pNode->m_Next->m_Prev = pNode->m_Prev;
	pNode->m_Prev->m_Next = pNode->m_Next;

	delete pNode;
}

//////////////////////////////////////////////////////////////////////////////////
// CDXSpriteList Draw
//////////////////////////////////////////////////////////////////////////////////
void CDXSpriteList::Draw(CDXSurface* lpCDXS, DWORD ScrnWorldX, DWORD ScrnWorldY, WORD BltType)
{
	CDXSprite* Node;

	// Loop the list and draw the objects
	for(Node = m_List.m_Next; Node != &m_List; Node = Node->m_Next)
	{
		Node->Draw(lpCDXS, ScrnWorldX, ScrnWorldY, BltType);
	}
}
