# Make DOS-related files, typically while under Unix.

#	$Id: makefile.mk,v 1.9 1992/07/28 16:12:44 eggert Exp $

EDIT = \
		sed <../Makefile \
			-e '/start of configuration section/r $@h' \
			-e '/start of configuration section/r ms.mkh' \
			-e '/^.(Unix/,/^.)/d' \
			-e 's|$$\([a-z]\)|$$(\1)|g' \
			-e 's|::|:|' \
			-e '/^rcsclean =/s|\\$$|dirent$$(o) \\|'

format = ((echo .na; echo .nh; sed 's|\\(co *||g') | nroff -man) <

default :: bor.mk nmake.mk nt.mk rcstest rlog.1

rlog.rsp :
	rm -f *.rsp
	cd .. && $(MAKE) conf_h= o= x=.rsp LINK=echo LDLIBS='| sed "s/ -o.*//" >$$@'
	mv ../*.rsp .

linksource = \$$(LINK) \$$(\(.*\)) -o \$$@ \$$(LDLIBS)
linktarget = $$(LINK) @ms\\$$*.rsp,$$*,,$$(LDLIBS);

bor.mk : ../Makefile ms.mkh bor.mkh
	$(EDIT) >$@ -e \
		's/$(linksource)/$(linktarget)/'

nmake.mk : ../Makefile ms.mkh nmake.mkh rlog.rsp
	$(EDIT) >$@ -e \
		'/$(linksource)/{s|.*|!IF "$$(OS)" == "os2"|; p; s|.*|	$$(LINK) $$($$@) $$(LDLIBS)|; p; s|.*|	$$(BIND) $$@ $$(BINDN)|; p; s|.*|!ELSE|; p; s|.*|	$(linktarget)|; p; s|.*|!ENDIF|; }'

nt.mk : ../Makefile ms.mkh nt.mkh
	$(EDIT) >$@ -e \
		's/$(linksource)/$$(LINK) $$(\1) $$(LDLIBS)/'

rcstest : ../rcstest
	sed \
		-e 's|/dev/null|nul|g' \
		-e 's|pwd|case $$OS in os2) cmd /c cd;; *) command /c cd;; esac|' \
		-e 's|^SLASH=.*|SLASH=\\\\\\\\|' \
	<../rcstest >$@

rlog.1 :
	for i in ../../man/*.[0-9]; do \
		$(format) $$i >`expr "$$i" : '.*/\(.*\)'`; \
	done

clean ::
	rm -f ../*.rsp *.rsp *.[0-9] bor.mk nmake.mk nt.mk rcstest
