#
#
# Copyright (C) 1995 Christopher M Sedore
#
# This code may be modified and reused for any purpose.
#
# Setowner.tcl sample program 
#
#

load ntsys.dll ntsys


#
# The order of these lists must correspond
#
set ACCOUNT_TYPE_LIST {Faculty Staff Student}
#
# name of the accounts we should copy settings on for each account type 
#
set ACCOUNT_TEMPLATE_LIST { template template template }
#
# base paths (the paths on the server) for the directories for each account type
#
set HOME_DIR_BASE_LIST {g:\\faculty g:\\staff e:\\students}
#
# shares for HOME_DIR_BASE_LIST 
#
set UNC_DIR_BASE_LIST {\\\\commons\\faculty \\\\commons\\staff \\\\commons\\students}
#
# login scripts for each account type
#
set LOGIN_SCRIPT_LIST {faculty.bat staff.bat student.bat}

#
# Who I ask for group lists:
#
set LOCALGROUP_HOST {\\manager}
set GLOBALGROUP_HOST {\\manager}
#
# 
#
# Account parameters
set HOME_SERVER commons
set HOME_DRIVE H:
set PROFILE_PATH \\\\commons\\profiles\\

#
# Our domain
#
set DOMAIN maxwell-school
#
# domain controller (this can be [NT_GetDCName {}])
#
set DOMAIN_CONTR [NT_GetDCName $DOMAIN] 


wm title . "Maxwell Add User"

frame .top -relief sunken -bd 3
frame .top.fui
frame .top.fui.un
label .top.fui.un.label -text "Username:" -justify left
entry .top.fui.un.entry -textvariable username -justify left
pack .top.fui.un.label -side left -anchor w 
pack .top.fui.un.entry -side right -anchor e 

frame .top.fui.fn
label .top.fui.fn.label -text "Full name:" -justify left
entry .top.fui.fn.entry -textvariable fullname -justify left
pack .top.fui.fn.label -side left -anchor w
pack .top.fui.fn.entry -side right -anchor e


frame .top.fui.cm
label .top.fui.cm.label -text "Comment:" -justify left
entry .top.fui.cm.entry -textvariable comment -justify left
pack .top.fui.cm.label -side left -anchor w
pack .top.fui.cm.entry -side right -anchor e

pack .top.fui.un .top.fui.fn .top.fui.cm
pack .top.fui -side left -anchor nw

frame .top.class

label .top.class.label -text "Choose the account type:" -justify left
listbox .top.class.lb  -height [llength $ACCOUNT_TYPE_LIST] -exportselection false
foreach a $ACCOUNT_TYPE_LIST { .top.class.lb insert end $a }
pack .top.class.label -side left -anchor n
pack .top.class.lb -side right
pack .top.class -side right

pack .top -expand true -fill x -anchor n

set grouplist [NT_GroupEnum $GLOBALGROUP_HOST]

set localgrouplist [NT_LocalGroupEnum $LOCALGROUP_HOST]

frame .bottom -relief sunken -bd 3
frame .bottom.fg
label .bottom.label -text "Global groups:" -justify left
listbox .bottom.fg.lbg -width 32 -yscrollcommand ".bottom.fg.sb set" -selectmode extended -exportselection false
scrollbar .bottom.fg.sb -command ".bottom.fg.lbg yview"

foreach a $grouplist { .bottom.fg.lbg insert end $a }

frame .bottom.flg
label .bottom.labellg -text "Local groups:" -justify left
listbox .bottom.flg.lbg -width 32 -yscrollcommand ".bottom.flg.sb set" -selectmode extended -exportselection false
scrollbar .bottom.flg.sb -command ".bottom.flg.lbg yview"

foreach a $localgrouplist { .bottom.flg.lbg insert end $a }

pack .bottom.label -side left -anchor nw
pack .bottom.fg.sb -expand true -fill y -side right
pack .bottom.fg.lbg  -side left -expand true -fill y
pack .bottom.fg -side left -expand true -fill y

pack .bottom.labellg -side left -anchor nw
pack .bottom.flg.sb -expand true -fill y -side right
pack .bottom.flg.lbg -expand true -fill y -side left 
pack .bottom.flg -after .bottom.labellg -expand true -fill y
pack .bottom -expand true -fill y -anchor n

frame .buttons -relief sunken -bd 3

button .buttons.doit -text "Create account..." -command "createUser"
button .buttons.quit -text "Quit..." -command "exit"
pack .buttons.doit -side left -anchor w
pack .buttons.quit -side right -anchor e
pack .buttons -expand true -fill x

set dcount 0

proc createUser {} {
  global ACCOUNT_TYPE_LIST ACCOUNT_TEMPLATE_LIST username fullname comment
  global PROFILE_PATH HOME_DRIVE DOMAIN_CONTR HOME_SERVER dcount 
  global GLOBALGROUP_HOST LOCALGROUP_HOST HOME_DIR_BASE_LIST DOMAIN UNC_DIR_BASE_LIST
  global LOGIN_SCRIPT_LIST

  set class [lindex $ACCOUNT_TYPE_LIST [.top.class.lb curselection]]
  set shareBasePath [lindex $HOME_DIR_BASE_LIST [.top.class.lb curselection]]
  set uncBasePath [lindex $UNC_DIR_BASE_LIST [.top.class.lb curselection]]
  set template [lindex $ACCOUNT_TEMPLATE_LIST [.top.class.lb curselection]]
  set loginScript [lindex $LOGIN_SCRIPT_LIST [.top.class.lb curselection]]
  
  set glbg {}
  set locg {}

  foreach a [.bottom.fg.lbg curselection] { append glbg " " [list [.bottom.fg.lbg get $a]] }
  foreach a [.bottom.flg.lbg curselection] { append locg " " [list [.bottom.flg.lbg get $a]] }

  set win [toplevel .t[incr dcount]]
  text $win.t 
  button $win.b -text "OK" -command "destroy $win" 
  wm title $win "Status for $username"
  pack $win.t $win.b
  
  if {[catch {NT_UserAdd $DOMAIN_CONTR $template $username "$username" \\\\$HOME_SERVER\\$username\$ $comment $loginScript $fullname $PROFILE_PATH$username.usr $HOME_DRIVE} ] } {
    $win.t insert end "Account creation for $username failed.\n"
  } else { $win.t insert end "Account $username created successfullly\n" }
 
 if {[catch {
       NT_CreateDirectory $uncBasePath\\$username
       NT_CreateDirectory $uncBasePath\\$username\\mail 
    } ] } {
    $win.t insert end "Home & mail directory creation for $username failed.\n"
  } else { $win.t insert end "Home & mail directories for $username created successfullly\n" }

 if {[catch {
      set f [open $uncBasePath\\$username\\mail\\eudora.ini w]
      puts $f {[Settings]}
      puts $f "POPAccount=$username@pop.maxwell.syr.edu"
      puts $f "RealName=$fullname"
      puts $f "ReturnAddress=$username@maxwell.syr.edu"
      puts $f "SMTPServer=maxwell.syr.edu"
      close $f
    } ] } {
    $win.t insert end "eudora.ini creation for $username failed.\n"
  } else { $win.t insert end "eudora.ini creation for $username succeeded\n" }

 if {[catch {NT_ShareAdd \\\\$HOME_SERVER $username\$ {} {} 10 $shareBasePath\\$username {} } ] } {
    $win.t insert end "Share creation for $username's home directory failed ($shareBasePath\\$username).\n"
  } else { $win.t insert end "Share for $username's home directory created successfullly\n" }

 if {[catch { set hacl [NT_CreateACL [list ACCESS_ALLOWED OBJECT_INHERIT|CONTAINER_INHERIT GENERIC_ALL $DOMAIN\\$username] ] }  msg] } {
    $win.t insert end "acl creation for $username failed ($DOMAIN\\$username): $msg.\n"
 } else {
     if {[catch { set hsd [NT_CreateSecurityDescriptor {} {} $hacl {} ]} ] } {
      $win.t insert end "Security descriptor creation for $username failed ($DOMAIN\\$username).\n"
     } else {
       if {[catch {
           NT_SetFileSecurity $hsd DACL_SECURITY_INFORMATION $uncBasePath\\$username\\mail\\eudora.ini
           NT_SetFileSecurity $hsd DACL_SECURITY_INFORMATION $uncBasePath\\$username\\mail
           NT_SetFileSecurity $hsd DACL_SECURITY_INFORMATION $uncBasePath\\$username
         } msg ]} {
         $win.t insert end "Setting $username's home directory security failed: $msg\n"
       } else { 
         $win.t insert end "Setting $username's home directory security succeeded\n" 
         NT_CloseHandle $hsd 
       }
       NT_CloseHandle $hacl 
     } 
 }
   
 


  foreach a $glbg { 
    if {[catch {NT_GroupAddUser $GLOBALGROUP_HOST $a $username}]} {
      $win.t insert end "Could not add $username to global group $a\n"
    } else { $win.t insert end "$username added to global group $a\n" }
  }

  foreach a $locg { 
  if {[catch {NT_LocalGroupAddUser $LOCALGROUP_HOST $a $username}]} {
      $win.t insert end "Could not add $username to local group $a\n"
    } else { $win.t insert end "$username added to local group $a\n" }
  }
  
  
}  
  
  