#ifndef __DATA_P_H__
#define __DATA_P_H__

extern Lisp_Object wrong_type_argument _P_((register Lisp_Object predicate,
                                            register Lisp_Object value));
extern _VOID_ pure_write_error _P_((void));
extern _VOID_ args_out_of_range _P_((Lisp_Object a1, Lisp_Object a2));
extern _VOID_ args_out_of_range_3 _P_((Lisp_Object a1, Lisp_Object a2,
                                       Lisp_Object a3));
extern Lisp_Object make_number _P_((int num));
extern int sign_extend_lisp_int _P_((int num));
extern Lisp_Object do_symval_forwarding _P_((register
                                             Lisp_Object valcontents));
extern _VOID_ store_symval_forwarding _P_((Lisp_Object sym, register
                                           Lisp_Object valcontents,
                                           register Lisp_Object newval));
extern Lisp_Object find_symbol_value _P_((Lisp_Object sym));
extern Lisp_Object default_value _P_((Lisp_Object sym));
extern Lisp_Object indirect_function _P_((Lisp_Object object));
extern Lisp_Object Farray_length _P_((Lisp_Object array));
extern Lisp_Object long_to_cons _P_((unsigned long i));
extern unsigned long cons_to_long _P_((Lisp_Object c));
extern _VOID_ syms_of_data _P_((void));
extern SIGTYPE arith_error _P_((int signo));
extern _VOID_ init_data _P_((void));

DEFUN_P(Feq, (Lisp_Object obj1, Lisp_Object obj2));
DEFUN_P(Fnull, (Lisp_Object obj));
DEFUN_P(Fconsp, (Lisp_Object obj));
DEFUN_P(Fatom, (Lisp_Object obj));
DEFUN_P(Flistp, (Lisp_Object obj));
DEFUN_P(Fnlistp, (Lisp_Object obj));
DEFUN_P(Fsymbolp, (Lisp_Object obj));
DEFUN_P(Fvectorp, (Lisp_Object obj));
DEFUN_P(Fstringp, (Lisp_Object obj));
DEFUN_P(Farrayp, (Lisp_Object obj));
DEFUN_P(Fsequencep, (register Lisp_Object obj));
DEFUN_P(Fbufferp, (Lisp_Object obj));
DEFUN_P(Fmarkerp, (Lisp_Object obj));
DEFUN_P(Fsubrp, (Lisp_Object obj));
DEFUN_P(Fbyte_code_function_p, (Lisp_Object obj));
DEFUN_P(Fchar_or_string_p, (register Lisp_Object obj));
DEFUN_P(Fintegerp, (Lisp_Object obj));
DEFUN_P(Finteger_or_marker_p, (register Lisp_Object obj));
DEFUN_P(Fnatnump, (Lisp_Object obj));
DEFUN_P(Fnumberp, (Lisp_Object obj));
DEFUN_P(Fnumber_or_marker_p, (Lisp_Object obj));
DEFUN_P(Ffloatp, (Lisp_Object obj));
DEFUN_P(Fcar, (register Lisp_Object list));
DEFUN_P(Fcar_safe, (Lisp_Object object));
DEFUN_P(Fcdr, (register Lisp_Object list));
DEFUN_P(Fcdr_safe, (Lisp_Object object));
DEFUN_P(Fsetcar, (register Lisp_Object cell, register Lisp_Object newcar));
DEFUN_P(Fsetcdr, (register Lisp_Object cell, register Lisp_Object newcdr));
DEFUN_P(Fboundp, (register Lisp_Object sym));
DEFUN_P(Ffboundp, (register Lisp_Object sym));
DEFUN_P(Fmakunbound, (register Lisp_Object sym));
DEFUN_P(Ffmakunbound, (register Lisp_Object sym));
DEFUN_P(Fsymbol_function, (register Lisp_Object symbol));
DEFUN_P(Fsymbol_plist, (register Lisp_Object sym));
DEFUN_P(Fsymbol_name, (register Lisp_Object sym));
DEFUN_P(Ffset, (register Lisp_Object sym, register Lisp_Object newdef));
DEFUN_P(Fdefalias, (register Lisp_Object sym, register Lisp_Object newdef));
DEFUN_P(Fdefine_function, (register Lisp_Object sym,
                           register Lisp_Object newdef));
DEFUN_P(Fsetplist, (register Lisp_Object sym, register Lisp_Object newplist));
DEFUN_P(Fsymbol_value, (Lisp_Object sym));
DEFUN_P(Fset, (register Lisp_Object sym, register Lisp_Object newval));
DEFUN_P(Fdefault_boundp, (Lisp_Object sym));
DEFUN_P(Fdefault_value, (Lisp_Object sym));
DEFUN_P(Fset_default, (Lisp_Object sym, Lisp_Object value));
DEFUN_P(Fsetq_default, (Lisp_Object args));
DEFUN_P(Fmake_variable_buffer_local, (register Lisp_Object sym));
DEFUN_P(Fmake_local_variable, (register Lisp_Object sym));
DEFUN_P(Fkill_local_variable, (register Lisp_Object sym));
DEFUN_P(Findirect_function, (register Lisp_Object object));
DEFUN_P(Faref, (register Lisp_Object array, Lisp_Object idx));
DEFUN_P(Faset, (register Lisp_Object array, Lisp_Object idx,
                Lisp_Object newelt));
DEFUN_P(Feqlsign, (register Lisp_Object num1, register Lisp_Object num2));
DEFUN_P(Flss, (register Lisp_Object num1, register Lisp_Object num2));
DEFUN_P(Fgtr, (register Lisp_Object num1, register Lisp_Object num2));
DEFUN_P(Fleq, (register Lisp_Object num1, register Lisp_Object num2));
DEFUN_P(Fgeq, (register Lisp_Object num1, register Lisp_Object num2));
DEFUN_P(Fneq, (register Lisp_Object num1, register Lisp_Object num2));
DEFUN_P(Fzerop, (register Lisp_Object num));
DEFUN_P(Fnumber_to_string, (register Lisp_Object num));
DEFUN_P(Fstring_to_number, (register Lisp_Object str));
DEFUN_P(Fplus, (int nargs, Lisp_Object *args));
DEFUN_P(Fminus, (int nargs, Lisp_Object *args));
DEFUN_P(Ftimes, (int nargs, Lisp_Object *args));
DEFUN_P(Fquo, (int nargs, Lisp_Object *args));
DEFUN_P(Frem, (register Lisp_Object num1, register Lisp_Object num2));
DEFUN_P(Fmax, (int nargs, Lisp_Object *args));
DEFUN_P(Fmin, (int nargs, Lisp_Object *args));
DEFUN_P(Flogand, (int nargs, Lisp_Object *args));
DEFUN_P(Flogior, (int nargs, Lisp_Object *args));
DEFUN_P(Flogxor, (int nargs, Lisp_Object *args));
DEFUN_P(Fquo, (int nargs, Lisp_Object *args));
DEFUN_P(Fash, (register Lisp_Object num1, register Lisp_Object num2));
DEFUN_P(Flsh, (register Lisp_Object num1, register Lisp_Object num2));
DEFUN_P(Fadd1, (register Lisp_Object num));
DEFUN_P(Fsub1, (register Lisp_Object num));
DEFUN_P(Flognot, (register Lisp_Object num));
    
#endif
