#ifndef __PROCESS_P_H__
#define __PROCESS_P_H__

extern _VOID_ update_status _P_((struct Lisp_Process *p));
extern _VOID_ decode_status _P_((Lisp_Object l, Lisp_Object *symbol, int *code,
                                 int *coredump));
extern Lisp_Object status_message _P_((Lisp_Object status));
extern int allocate_pty _P_((void));
extern Lisp_Object make_process _P_((Lisp_Object name));
extern _VOID_ remove_process _P_((register Lisp_Object proc));
extern Lisp_Object get_process _P_((register Lisp_Object name));
extern Lisp_Object list_processes_1 _P_((Lisp_Object dummy));
extern SIGTYPE create_process_1 _P_((int signo));
extern SIGTYPE create_process_sigchld _P_((void));
extern _VOID_ create_process _P_((Lisp_Object process, char **new_argv,
                                  Lisp_Object current_dir));
extern _VOID_ deactivate_process _P_((Lisp_Object proc));
extern _VOID_ close_process_descs _P_((void));
extern int wait_reading_process_input _P_((int time_limit, int microsecs,
                                           Lisp_Object read_kbd,
                                           int do_display));
extern int read_process_output _P_((Lisp_Object proc, register int channel));
extern SIGTYPE send_process_trap _P_((void));
extern _VOID_ send_process _P_((Lisp_Object proc, char *buf, int len));
extern _VOID_ kill_buffer_processes _P_((Lisp_Object buffer));
extern _VOID_ status_notify _P_((void));
extern _VOID_ init_process _P_((void));
extern _VOID_ syms_of_process _P_((void));
extern int wait_reading_process_input _P_((int time_limit, int microsecs,
                                           Lisp_Object read_kbd,
                                           int do_display));
extern SIGTYPE _CALLBACK_ sigchld_handler _P_((int signo));

DEFUN_P(Fprocessp, (Lisp_Object obj));
DEFUN_P(Fget_process, (register Lisp_Object name));
DEFUN_P(Fget_buffer_process, (register Lisp_Object name));
DEFUN_P(Fdelete_process, (register Lisp_Object proc));
DEFUN_P(Fprocess_status, (register Lisp_Object proc));
DEFUN_P(Fprocess_exit_status, (register Lisp_Object proc));
DEFUN_P(Fprocess_id, (register Lisp_Object proc));
DEFUN_P(Fprocess_name, (register Lisp_Object proc));
DEFUN_P(Fprocess_command, (register Lisp_Object proc));
DEFUN_P(Fset_process_buffer, (register Lisp_Object proc,
                              register Lisp_Object buffer));
DEFUN_P(Fprocess_buffer, (register Lisp_Object proc));
DEFUN_P(Fprocess_mark, (register Lisp_Object proc));
DEFUN_P(Fset_process_filter, (register Lisp_Object proc,
                              register Lisp_Object filter));
DEFUN_P(Fprocess_filter, (register Lisp_Object proc));
DEFUN_P(Fset_process_sentinel, (register Lisp_Object proc,
                                register Lisp_Object sentinel));
DEFUN_P(Fprocess_sentinel, (register Lisp_Object proc));
DEFUN_P(Fprocess_kill_without_query, (register Lisp_Object proc,
                                      register Lisp_Object value));
DEFUN_P(Flist_processes, (void));
DEFUN_P(Fprocess_list, (void));
DEFUN_P(Fstart_process, (int nargs, Lisp_Object *args));
DEFUN_P(Fopen_network_stream, (Lisp_Object name, Lisp_Object buffer,
                               Lisp_Object host, Lisp_Object service));
DEFUN_P(Faccept_process_output, (register Lisp_Object proc,
                                 register Lisp_Object timeout,
                                 register Lisp_Object timeout_msecs));
DEFUN_P(Fwaiting_for_user_input_p, (void));
DEFUN_P(Fprocess_send_region, (Lisp_Object process, Lisp_Object start,
                               Lisp_Object end));
DEFUN_P(Fprocess_send_string, (Lisp_Object process, Lisp_Object string));
DEFUN_P(Finterrupt_process, (Lisp_Object process, Lisp_Object current_group));
DEFUN_P(Fkill_process, (Lisp_Object process, Lisp_Object current_group));
DEFUN_P(Fquit_process, (Lisp_Object process, Lisp_Object current_group));
DEFUN_P(Fstop_process, (Lisp_Object process, Lisp_Object current_group));
DEFUN_P(Fcontinue_process, (Lisp_Object process, Lisp_Object current_group));
DEFUN_P(Fsignal_process, (Lisp_Object pid, Lisp_Object sig));
DEFUN_P(Fprocess_send_eof, (Lisp_Object process));
DEFUN_P(Fprocess_connection, (Lisp_Object process));
DEFUN_P(Fget_buffer_process, (register Lisp_Object name));

#endif
