#ifndef __SEARCH_P_H__
#define __SEARCH_P_H__

extern Lisp_Object signal_failure _P_((Lisp_Object arg));
extern int fast_string_match _P_((Lisp_Object regexp, Lisp_Object string));
extern int scan_buffer _P_((register int target, int start, register int count,
                            int *shortage));
extern int find_next_newline _P_((register int from, register int cnt));
extern Lisp_Object skip_chars _P_((int forwardp, int syntaxp,
                                   Lisp_Object string, Lisp_Object lim));
extern int search_buffer _P_((Lisp_Object string, int pos, int lim, int n,
                              int RE, register unsigned char *trt,
                              register unsigned char *inverse_trt));
extern _VOID_ syms_of_search _P_((void));

DEFUN_P(Flooking_at, (Lisp_Object string));
DEFUN_P(Fstring_match, (Lisp_Object regexp, Lisp_Object string,
                        Lisp_Object start));
DEFUN_P(Fskip_chars_forward, (Lisp_Object string, Lisp_Object lim));
DEFUN_P(Fskip_chars_backward, (Lisp_Object string, Lisp_Object lim));
DEFUN_P(Fskip_syntax_forward, (Lisp_Object syntax, Lisp_Object lim));
DEFUN_P(Fskip_syntax_backward, (Lisp_Object syntax, Lisp_Object lim));
DEFUN_P(Fsearch_backward, (Lisp_Object string, Lisp_Object bound,
                           Lisp_Object noerror, Lisp_Object count));
DEFUN_P(Fsearch_forward, (Lisp_Object string, Lisp_Object bound,
                          Lisp_Object noerror, Lisp_Object count));
DEFUN_P(Fword_search_backward, (Lisp_Object string, Lisp_Object bound,
                                Lisp_Object noerror, Lisp_Object count));
DEFUN_P(Fword_search_forward, (Lisp_Object string, Lisp_Object bound,
                               Lisp_Object noerror, Lisp_Object count));
DEFUN_P(Fre_search_backward, (Lisp_Object string, Lisp_Object bound,
                              Lisp_Object noerror, Lisp_Object count));
DEFUN_P(Fre_search_forward, (Lisp_Object string, Lisp_Object bound,
                             Lisp_Object noerror, Lisp_Object count));
DEFUN_P(Freplace_match, (Lisp_Object string, Lisp_Object fixedcase,
                             Lisp_Object literal));
DEFUN_P(Fmatch_beginning, (Lisp_Object num));
DEFUN_P(Fmatch_end, (Lisp_Object num));
DEFUN_P(Fmatch_data, (void));
DEFUN_P(Fstore_match_data, (Lisp_Object list));
DEFUN_P(Fregexp_quote, (Lisp_Object str));
    
#endif
