/**********************************************************************
 *                                                                    *
 * NOLOCKWS.C, version 0.9                                            *
 *                                                                    *
 * A program to modify msgina.dll in order to inactivate the          *
 * 'Lock Workstation' button in the 'Windows NT Security'             *
 * dialog (at Ctrl-Alt-Del).                                          *
 *                                                                    *
 * Copyright (C) 1997 by Alexander Frink                              *
 *                       Hermann Schauss Str. 8                       *
 *                       65232 Taunusstein                            *
 *                       Germany                                      *
 *                       Alexander.Frink@Uni-Mainz.DE                 *
 *                                                                    *
 * This program is free software; you can redistribute it and/or      *
 * modify it under the terms of the GNU General Public License        * 
 * as published by the Free Software Foundation; either version 2     *
 * of the License, or (at your option) any later version.             *
 *                                                                    *
 * This program is distributed in the hope that it will be useful,    *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the       *
 * GNU General Public License (file name: LICENSE) for more details.  *
 *                                                                    *
 * You should have received a copy of the GNU General Public License  * 
 * along with this program; if not, write to the Free Software        *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.          *
 *                                                                    *
 **********************************************************************/

#include <windows.h>
#include <stdio.h>
#include <conio.h>

#define MAXPATHLEN            1024
#define MAXSEQLEN             1024
#define GINA_FILENAME         "msgina.dll"
#define GINA_BACKUP_FILENAME  "msgina.bak"
#define GINA_TEMP_FILENAME    "msgina.tmp"
#define DEFAULT_BUTTONTEXT    "Lock &Workstation"
#define DEFAULT_LOCATION      "%systemroot%\\system32\\"
/* #define DEFAULT_LOCATION      "%temp%" */ /* for testing */
#define MODE_ALLOW            'a'
#define MODE_DISALLOW         'd'
#define DEFAULT_MODE          MODE_DISALLOW
#define RETVAL_SUCCESS        0
#define RETVAL_ERROR          1


BOOL QueryIfUserIsAdmin(void)
{
/*  
    check if the current user is a member of the Administrator group

    IN  ---
    OUT ---

    returns TRUE  if user is an admin
            FALSE if user is not an admin

    This code is taken from Microsoft knowledge base article Q118626.
*/

    HANDLE hAccessToken;
    UCHAR InfoBuffer[1024];
    PTOKEN_GROUPS ptgGroups = (PTOKEN_GROUPS)InfoBuffer;
    DWORD dwInfoBufferSize;
    PSID psidAdministrators;
    SID_IDENTIFIER_AUTHORITY siaNtAuthority = SECURITY_NT_AUTHORITY;
    UINT x;
    BOOL bSuccess;

    if (!OpenProcessToken(GetCurrentProcess(),TOKEN_READ,&hAccessToken)) {
        return(FALSE);
    }

    bSuccess = GetTokenInformation(hAccessToken,TokenGroups,InfoBuffer,
                                   1024, &dwInfoBufferSize);

    CloseHandle(hAccessToken);

    if(!bSuccess) {
        return FALSE;
    }

    if (!AllocateAndInitializeSid(&siaNtAuthority, 2,
                                  SECURITY_BUILTIN_DOMAIN_RID,
                                  DOMAIN_ALIAS_RID_ADMINS,
                                  0, 0, 0, 0, 0, 0,
                                  &psidAdministrators)) {
        return FALSE;
    }

    /* assume that we don't find the admin SID. */
    bSuccess = FALSE;

    for (x=0;x<ptgGroups->GroupCount;x++) {
        if (EqualSid(psidAdministrators, ptgGroups->Groups[x].Sid)) {
            bSuccess = TRUE;
            break;
        }
    }
    FreeSid(psidAdministrators);

    return bSuccess;
}

BOOL EnterParameters(char *GinaFileName, char *GinaBackupFileName,
                     char *GinaTempFileName, unsigned char *Sequence,
                     int *SeqLen, int *Mode)
{
/*
    Let the user enter all relevant parameters (location of msgina.dll,
    text on the 'Lock Workstation' button and whether to enable or 
    disable workstation locking.

    IN  ---
    OUT GinaFileName:        full path and name of msgina.dll
        GinaBackupFileName: path/name of backup file (will be created later)
        GinaTempFileName:   path/name of a working copy of msgina.dll
        Sequence:             byte sequence to search for (unicoded button text)
        SeqLen:               number of bytes to search (2*length of button text)
        Mode:                 'a' (allow) or 'd' (disallow) locking

    returns FALSE if user interrupted then input of parameters
            TRUE  otherwise
*/
    
    char Location[MAXPATHLEN];
    char DefaultExpLocation[MAXPATHLEN];
    char ButtonText[MAXSEQLEN/2];
    int i;

    printf("ENABLE/DISABLE THE 'LOCK WORKSTATION' BUTTON IN THE NT SECURITY DIALOG\n"
           "----------------------------------------------------------------------\n\n"
           "Copyright (C) 1997 by Alexander Frink (Alexander.Frink@Uni-Mainz.DE).\n"
           "This is free software, and you are welcome to redistribute it under\n"
           "certain conditions; see the README file and LICENSE for more details.\n\n"
           "WARNING: This program directly modifies msgina.dll in your SYSTEM32\n"
           "directory. It should work with any NT version and language. If you\n"
           "have the U.S. version, simply press Enter three times. However, any\n"
           "unexpected failure may prevent your system from booting. Make sure you\n"
           "have a backup of your system before continuing.\n"
           "This is a BETA version, it was tested on a limited number of systems.\n"
           "Please take a look at the README file first!\n\n"
           "DISCLAIMER: This program is provided \"AS IS\" and comes WITHOUT ANY\n"
           "            WARRANTY; without even the implied warranty of\n"
           "            MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n"
           "            See sections 11 and 12 of the LICENSE file for the full\n"
           "            disclaimer text.\n\n"
           "You can stop execution with CTRL-C or CTRL-BREAK.\n"
           "You must reboot in order to activate the changes.\n");

    ExpandEnvironmentStrings(DEFAULT_LOCATION,DefaultExpLocation,sizeof(DefaultExpLocation));

    printf("\nWhere is msgina.dll located? [%s]:",DefaultExpLocation);
    gets(Location);

    if (strlen(Location)==0) {
        strcpy(Location,DefaultExpLocation);
    }
    /* add a trailing backslash if necessary */
    if (Location[strlen(Location)-1]!='\\') {
        Location[strlen(Location)]='\\';
        Location[strlen(Location)+1]=0;
    }
#ifdef _DEBUG
    printf("msgina.dll will be modified in directory %s.\n",Location);
#endif

    strcpy(GinaFileName,Location);
    strcat(GinaFileName,GINA_FILENAME);
    strcpy(GinaBackupFileName,Location);
    strcat(GinaBackupFileName,GINA_BACKUP_FILENAME);
    strcpy(GinaTempFileName,Location);
    strcat(GinaTempFileName,GINA_TEMP_FILENAME);
#ifdef _DEBUG
    printf("filenames: %s %s %s\n",GinaFileName,GinaBackupFileName,GinaTempFileName);
#endif

    printf("\n"
           "Type in exactly the text on your 'Lock Workstation' button (this text depends\n"
           "on your language). You must pay attention to upper/lower case letters. In front\n"
           "of the accelerator key (the letter that is underlined), type an &-character.\n"
           "[%s]: ",DEFAULT_BUTTONTEXT);
    gets(ButtonText);

    *SeqLen=2*strlen(ButtonText);
    if (*SeqLen==0) {
        strcpy(ButtonText,DEFAULT_BUTTONTEXT);
        *SeqLen=2*strlen(ButtonText);
    }
    MultiByteToWideChar(CP_OEMCP,
                        0,
                        ButtonText,
                        strlen(ButtonText)+1,
                        (WCHAR *)Sequence,
                        MAXSEQLEN/sizeof(WCHAR));
#ifdef _DEBUG
    printf("Searching for Sequence:\n");
    for (i=0; i< *SeqLen; i++) {
        printf("%i\t",Sequence[i]);
    }
    printf("\n");
#endif

    printf("\nDo you want to (a)llow or (d)isallow workstation locking? [%c]: ",DEFAULT_MODE);
    do {
        *Mode=tolower(_getch());
        if (*Mode=='\r') *Mode=DEFAULT_MODE;
    } while ((*Mode!=MODE_ALLOW)&&(*Mode!=MODE_DISALLOW)&&(*Mode!=3));
    printf("\n");
    if (*Mode==3) {
        printf("Terminating.\n");
        return FALSE;
    }
#ifdef _DEBUG
    if (*Mode==MODE_ALLOW) {
        printf("Allowing locking.\n");
    } else {
        printf("Disallowing locking.\n");
    }
#endif

    return TRUE;
}

BOOL LoadGinaInMemory(char *FileName, DWORD *Size, unsigned char **FileBuffer)
{
/*
    Allocate a buffer and read msgina.dll into memory 

    IN  FileName:   full path and name of msgina.dll
    OUT Size:       file length
    OUT FileBuffer: pointer to the allocated (and filled) memory block

    returns FALSE on error
            TRUE  otherwise
*/

    HANDLE hFile;
    DWORD dwBytesRead;

    hFile=CreateFile(FileName,                // pointer to name of the file 
                     GENERIC_READ,            // access (read-write) mode 
                     0,                       // share mode 
                     NULL,                    // pointer to security descriptor 
                     OPEN_EXISTING,           // how to create 
                     FILE_ATTRIBUTE_READONLY, // file attributes 
                     NULL                     // handle to file with attributes to copy  
    );
    if (hFile==INVALID_HANDLE_VALUE) return FALSE;

    *Size=GetFileSize(hFile,NULL);
    if (*Size == 0xFFFFFFFF) {
        printf("Error, cannot determine file size.\n");
        return FALSE;
    }

    *FileBuffer=HeapAlloc(GetProcessHeap(),0,*Size);
    if (*FileBuffer==NULL) {
        printf("Error, insufficient memory.\n");
        return FALSE;
    }

    if (!ReadFile(hFile,
                  *FileBuffer,
                  *Size,
                  &dwBytesRead,
                  NULL)) {
        printf("Error, cannot read file into memory.\n");
        CloseHandle(hFile);
        return FALSE;
    }
    if (dwBytesRead != *Size) {
        printf("Error, read wrong number of bytes.\n");
        CloseHandle(hFile);
        return FALSE;
    }
    CloseHandle(hFile);
    return TRUE;
}

BOOL SearchAndApplyPatch(unsigned char *FileBuffer, DWORD Size, unsigned char Sequence[], DWORD SeqLen, int Mode, BOOL *ChangesMade)
{
/*
    Search through the file buffer for the sequence with the button text.
    If found, the window style attributes for this button should be
    22 bytes ahead, 0x01 (or 0x00) 0x00 0x01 0x50 is the default for an
    enabled button, 0x01 (or 0x00) 0x00 0x01 0x58 means a disabled button.
    

    IN  FileBuffer:  pointer to the allocated (and filled) memory block
    IN  Size:        file length
    IN  Sequence:    character sequence with button text to search
    IN  SeqLen:      length of character sequence
    IN  Mode:        'a'==allow locking, 'd'==disallow
    OUT ChangesMade: flag if changes were made (so writing back is necessary)

    returns FALSE on error
            TRUE  otherwise
*/

    DWORD i,j;
    int Found=0;

    *ChangesMade=FALSE;

#ifdef _DEBUG
    printf("Searching...\n",SeqLen);
#endif

    for (i=0; i<Size-SeqLen+1; i++) {
        for (j=0; j<SeqLen; j++) {
            if (FileBuffer[i+j]!=Sequence[j]) break;
        }
        if ((j==SeqLen)&&(i>=22)) {
#ifdef _DEBUG
            printf("Text found at position %i.\n",i);
#endif
            if ((FileBuffer[i-22]|0x01==0x01)&&(FileBuffer[i-21]==0x00)&&
                (FileBuffer[i-20]==0x01)&&((FileBuffer[i-19]|0x08)==0x58)) {
                Found++;
                if (FileBuffer[i-19]==(Mode==MODE_DISALLOW ? 0x58 : 0x50)) {
                    printf("No modification necessary.\n");
                } else {
                    FileBuffer[i-19]=(Mode==MODE_DISALLOW ? 0x58 : 0x50);
                    *ChangesMade=TRUE;
                    printf("Modification made.\n");
                }
/*
                if (Mode==MODE_DISALLOW) {
                    if (FileBuffer[i-19]==0x58) {
                        printf("No modification necessary.\n");
                    } else {
                        FileBuffer[i-19]=0x58;
                        *ChangesMade=TRUE;
                        printf("Modification made.\n");
                    }
                } else {
                    if (FileBuffer[i-19]==0x50) {
                        printf("No modification necessary.\n");
                    } else {
                        FileBuffer[i-19]=0x50;
                        *ChangesMade=TRUE;
                        printf("Modification made.\n");
                    }
                }
*/
            } else {
                printf("Unexpected window styles, making no modifications.\n");
                printf("Found: %x %x %x %x, expected 01 (or 00) 00 01 50/58.\n",
                       FileBuffer[i-22],FileBuffer[i-21],FileBuffer[i-20],FileBuffer[i-19]);
                return FALSE;
            }
        }
    }

    if (Found==0) {
        printf("Error, button text not found. Check spelling!\n");
        return FALSE;
    } else if (Found>1) {
        printf("Error, button text found more than once. No changes made.\n");
        return FALSE;
    }
    return TRUE;
}

BOOL WriteGinaBackToDisk(char *FileName, unsigned char *FileBuffer, DWORD Size)
{
/*
    Write the modified file back to the disk (under a temporary file name)    

    IN  FileName:    temporary file name
    IN  FileBuffer:  pointer to the allocated (and filled) memory block
    IN  Size:        file length

    returns FALSE on error
            TRUE  otherwise
*/

    HANDLE hFile;
    DWORD dwBytesWritten;

    hFile=CreateFile(FileName,                // pointer to name of the file 
                     GENERIC_WRITE,           // access (read-write) mode 
                     0,                       // share mode 
                     NULL,                    // pointer to security descriptor 
                     CREATE_ALWAYS,           // how to create 
                     FILE_ATTRIBUTE_NORMAL,   // file attributes 
                     NULL                     // handle to file with attributes to copy  
    );
    if (hFile==INVALID_HANDLE_VALUE) {
        printf("Error opening temporary copy of msgina.dll, %s.\n",FileName);
        return FALSE;
    }
    if (!WriteFile(hFile,
                   FileBuffer,
                   Size,
                   &dwBytesWritten,
                   NULL)) {
        printf("Error creating temporary copy of msgina.dll, %s.\n",FileName);
        DeleteFile(FileName);
        return FALSE;
    }
    CloseHandle(hFile);
    return TRUE;
}

BOOL FinishModification(char *GinaFileName,char *GinaBackupFileName,char *GinaTempFileName)
{
/*
    Make final changes:
      - rename the original file to a backup file name,
        handle the case of an already existing backup
      - rename the temporary file to the original file name

    IN  GinaFileName:        original file name
    IN  GinaBackupFileName:  backup file name
    IN  GinaTempFileName:    temporary file name

    returns FALSE on error
            TRUE  otherwise
*/

    int answer;

    while (!MoveFile(GinaFileName,GinaBackupFileName)) {
        printf("\nBackup copy of msgina.dll (%s) already exists.\n"
               "(D)elete old version, (t)erminate or (r)etry?",GinaBackupFileName);
        do {
            answer=tolower(_getch());
        } while ((answer!='r')&&(answer!='d')&&(answer!='t')&&(answer!=3));

        switch (answer) {
        case 'r':
            break;
        case 'd':
#ifdef _DEBUG
            printf("\nDeleting old version.\n");
#endif
            if (!DeleteFile(GinaBackupFileName)) {
                printf("Error, can't delete %s.\n",GinaBackupFileName);
                DeleteFile(GinaTempFileName);
                return FALSE;
            }
            break;
        default: /* 't' or CTRL-C */ 
#ifdef _DEBUG
            printf("\nTerminating.\n");
#endif
            DeleteFile(GinaTempFileName);
            return FALSE;
        }
    } 

    if (!MoveFile(GinaTempFileName,GinaFileName)) {
        printf("Error renaming temporary file (%s) to msgina.dll,\n"
               "trying to restore backup.\n",GinaTempFileName);
        if (!MoveFile(GinaBackupFileName,GinaFileName)) {
            printf("FATAL ERROR: Restoring backup copy (%s) to %s\n"
                   "failed as well. Try to restore msgina.dll manually before rebooting!\n",
                   GinaBackupFileName,GinaFileName);
        } else {
            printf("Restore of backup was successful.\n");
        }
        return FALSE;
    }
    return TRUE;
}

BOOL SetPrivilege(HANDLE hToken, LPCTSTR Privilege, BOOL bEnablePrivilege)
{
/*  
    Enable or disable a privilege

    IN  hToken:           token of the process to modify (NULL=current process)
    IN  Privilege:        privilege to enable or disable (SE_XYZ_NAME)
    IN  bEnablePrivilege: TRUE to enable.  FALSE to disable
    OUT ---

    returns TRUE  if privilege was enabled/disabled successfully
            FALSE if not

    This code is taken from Microsoft knowledge base article Q131065
    with slight modifications.
*/

    TOKEN_PRIVILEGES tp;
    LUID luid;
    TOKEN_PRIVILEGES tpPrevious;
    DWORD cbPrevious=sizeof(TOKEN_PRIVILEGES);

    //
    // Retrieve a handle of the access token
    //
    if (hToken==NULL) {
		if (!OpenProcessToken(GetCurrentProcess(),
				TOKEN_ADJUST_PRIVILEGES | TOKEN_QUERY,
				&hToken)) {
			return FALSE;
		}
	}

    if (!LookupPrivilegeValue( NULL, Privilege, &luid )) {
		return FALSE;
	}

    //
    // first pass.  get current privilege setting
    //
    tp.PrivilegeCount           = 1;
    tp.Privileges[0].Luid       = luid;
    tp.Privileges[0].Attributes = 0;

    AdjustTokenPrivileges(
            hToken,
            FALSE,
            &tp,
            sizeof(TOKEN_PRIVILEGES),
            &tpPrevious,
            &cbPrevious
            );

    if (GetLastError() != ERROR_SUCCESS) {
		return FALSE;
	}

    //
    // second pass.  set privilege based on previous setting
    //
    tpPrevious.PrivilegeCount       = 1;
    tpPrevious.Privileges[0].Luid   = luid;

    if(bEnablePrivilege) {
        tpPrevious.Privileges[0].Attributes |= (SE_PRIVILEGE_ENABLED);
    }
    else {
        tpPrevious.Privileges[0].Attributes ^= (SE_PRIVILEGE_ENABLED &
            tpPrevious.Privileges[0].Attributes);
    }

    AdjustTokenPrivileges(
            hToken,
            FALSE,
            &tpPrevious,
            cbPrevious,
            NULL,
            NULL
            );

    if (GetLastError() != ERROR_SUCCESS) {
		return FALSE;
	}

    return TRUE;
}

void AskForReboot(void)
{
/*
    Ask the user if he wants to reboot.
    Reboot if he wants to.
    Rebooting is necessary to activate the changes.

    IN  ---
    OUT ---

    returns nothing
*/

    int answer;

    printf("\nReboot Windows NT now (Y/N)? [N]:");
    do {
        answer=tolower(_getch());
        if (answer=='\r') answer='n';
    } while ((answer!='y')&&(answer!='n'));
    if (answer=='y') {
        if (!SetPrivilege(NULL,SE_SHUTDOWN_NAME,TRUE)) {
            printf("Seems like you don't have the right to restart this computer.\n");
        }
        // try anyway
        ExitWindowsEx(EWX_REBOOT,0);
    } else {
        printf("\nYou must reboot before running this program again!\n");
    }
}

int main(void)
{
    char GinaFileName[MAXPATHLEN];
    char GinaBackupFileName[MAXPATHLEN];
    char GinaTempFileName[MAXPATHLEN];
    unsigned char Sequence[MAXSEQLEN];
    unsigned char *FileBuffer;
    DWORD Size;
    DWORD SeqLen;
    int Mode;
    BOOL ChangesMade;

    if (!QueryIfUserIsAdmin()) {
        printf("You must be a member of the Administrators group to run this program.\n");
        return RETVAL_ERROR;
    }
    
    if (!EnterParameters(GinaFileName,GinaBackupFileName,
                         GinaTempFileName,Sequence,&SeqLen,&Mode)) return RETVAL_ERROR;

    if (!LoadGinaInMemory(GinaFileName,&Size,&FileBuffer)) return RETVAL_ERROR;
    
    if (!SearchAndApplyPatch(FileBuffer,Size,Sequence,SeqLen,Mode, &ChangesMade)) return RETVAL_ERROR;

    if (ChangesMade) {
        if (!WriteGinaBackToDisk(GinaTempFileName,FileBuffer,Size)) return RETVAL_ERROR;

        if (!FinishModification(GinaFileName,GinaBackupFileName,GinaTempFileName)) return RETVAL_ERROR;

        printf("\nmsgina.dll changed successfully. Please reboot now!\n");

        AskForReboot();
    } else {
        printf("\nmsgina.dll already changed.\n");
    }

    HeapFree(GetProcessHeap(),0,FileBuffer);

    return RETVAL_SUCCESS;
}
