 #ifdef VAXC   #module CHKLIC "BOL-V1.0/OCT-95" #else ' #pragma module CHKLOC "BOL-V1.0/OCT-95"  #endif  7 /* This routine checks for required licenses to perform     interactive logins.  ;    (P) 1995 by Ing. Ferry Bolhr (bol@adv.magwien.gv.at) */   - #include descrip	/* Descriptor definitions */ 9 #include lib$routines	/* LIB$ RTL function definitions */ G #ifdef __DECC		/* The following two modules don't exists in VAXC TLB */ < #include licensedef	/* LICENSE$_xxxx license status codes */7 #include lmfdef		/* LMF$_ license facility constants */  #endif1 #include ssdef		/* SS$_xxx system status codes */ : #include starlet	/* SYS$_xxx system service definitions */4 #include string		/* strxxx() function definitions */5 #include syidef		/* SYI$_xxx item code definitions */ 5 #include uaidef		/* UAI$M_xxx item codes and flahs */   ? #include "chklgidef.h"	/* CHKLGI$_xxx login source constants */ @ #include "lgibufdef.h"  /* LGIBUF structure field definitions */9 #include "lgimsgdef.h"  /* LGI$_xxx login status codes */ 2 #include "compdepnd.h"	/* Compiler dependencies */  $ typedef struct dsc$descriptor_s dsc;  6 /* Define platform-depending license names and values.  D    We define all licenses separately, even if some of them currentlyA    have the same name on VAX and Alpha. This will make changes in     the future easier. */   #ifdef __ALPHA #define VMSLIC1 "OPENVMS-ALPHA" $ #define VMSLIC2 "OPENVMS-ALPHA-USER" #define CLULIC1 "VMSCLUSTER"# #define CLULIC2 "VMSCLUSTER-CLIENT"  #else  #define VMSLIC1 "VAX-VMS" ! #define VMSLIC2 "BASE-VMS-250136"  #define CLULIC1 "VAXCLUSTER"# #define CLULIC2 "VMSCLUSTER-CLIENT"  #endif   /*  */    /*** CHKLIC() ***/ /*** ======== ***/   /* Input arguments:   E    lgi:  Login buffer containing additional information. By reference       Return codes:  -         SS$_NORMAL:    	license validation ok   8 	LGI$_LOGOPRCON:	no VMS or VMSCLUSTER license found, but  			logins are allowed from OPA0:  ; 	LGI$_LICNOTREQ: no license check required for this process  			(DECwindows logins only)   9 	LGI$_EXLICENSE:	licensed number of system users exceeded   5 	LGI$_NOVAXCLUSTER: no (valid) VMSCLUSTER(VAXCLUSTER)  			license found  " 	Any other error code returned by:  : 	o - System services SYS$GRANT_LICENSE, SYS$LOOKUP_LICENSE 	o _ RTL routine: LIB$GETSYI  7 	Note that the following LMF_xxx codes are converted in 
 	this way:  ! 	Status Code		License		Conversion : 	---------------------------------------------------------# 	LMF$_EXCEEDED		VMS		LGI$_EXLICENSE 2 	All LMF error codes 	VMSCLUSTER	LGI$_NOVAXCLUSTER    7 	NOTE: THE LICENSE-RELATED SYSTEM SERVICES USED IN THIS 9 	      MODULE ARE NOT SUPPORTED AND DOCUMENTED OFFICIALY.  	      USE IT ON YOUR OWN RISK.   */  2 int chklic(struct LGIBUF *lgi)		/* Login buffer */ {   int"  tmp,					/* Temp return status */  status,				/* Return Status */ +  contxt[4];				/* License context buffer */   @  $DESCRIPTOR (vms_lic1,VMSLIC1);	/* Name of first VMS license */A  $DESCRIPTOR (vms_lic2,VMSLIC2);	/* Name of second VMS license */ D  $DESCRIPTOR (clu_lic1,CLULIC1);	/* Name of first cluster license */E  $DESCRIPTOR (clu_lic2,CLULIC2);	/* Name of second cluster license */   >  $DESCRIPTOR (vms_dal,"VMS-DAAL");	/* VMS DAAL license name */2  $DESCRIPTOR (prc_nam,"DEC");		/* Producer name */  B  struct itmlst itm[3] = 		/* item list for license system serv. */  {0   4,LMF$_PROD_VERSION,&VMS$GL_LICENSE_VERSION,0,*   8,LMF$_PROD_DATE,&VMS$GQ_LICENSE_DATE,0,   0,0};   =  /* Check for either primary or secondary VMS license. We use A     SYS$GRANT_LICENSE here since we don't want to include license      groups in the check. */   ;  status = sys$grant_license(&vms_lic1,&prc_nam,contxt,itm);   .  /* If status is O.K., release the license. */  =  if (status == SS$_NORMAL) tmp = sys$release_license(contxt);   *  /* Otherwise, check secondary license. */    else   {<   status = sys$grant_license(&vms_lic2,&prc_nam,contxt,itm);  >   if (status == SS$_NORMAL) tmp = sys$release_license(contxt);  }A  /* Finally, if this is a captive account and there is a VMS-DAAL ?     license loaded, allow the login as well. Since this license =     may be part of a group, we use now SYS$LOOKUP_LICENSE. */     if (status != SS$_NORMAL)  {#   if (lgi->L_FLAGS & UAI$M_CAPTIVE)   4   status = sys$lookup_license(&vms_dal,itm,&prc_nam,% 			      &LMF$M_RETURN_FAILURES,0,0);   }  if (status != SS$_NORMAL)  {>   /* If there is no valid VMS license, but the user's terminal@      is the console, we allow logins as well, but we will return      a different status. */   B   if (!(strcmp(lgi->T_PHYDEVNAM,"_OPA0:"))) return LGI$_LOGOPRCON;  =   /* If this is a DECwindows login, return LGI$_LICNOTREQ. */   A   if (lgi->L_LGISRC == CHKLGI$_DECWINDOWS) return LGI$_LICNOTREQ;   N   /* No license is available - return status now. We convert LICENSE$_EXCEEDEDL      ("attempted usage exceeds active license limits") to the login-specificI      code LGI$_EXLICENSE ("licensed number of system users exceeded"). */   ?   return status == LICENSE$_EXCEEDED ? LGI$_EXLICENSE : status;   }H  /* If this system is part of a VMScluster, we need a cluster license as2     well. Otherwise, we can return immediately. */  D  if ((status = lib$getsyi(&SYI$_CLUSTER_MEMBER,&tmp)) != SS$_NORMAL)  return status;     if (!tmp) return SS$_NORMAL;   G  /* Well, its a cluster, so there must be a cluster license as well. */   P  status = sys$lookup_license(&clu_lic1,itm,&prc_nam,&LMF$M_RETURN_FAILURES,0,0);    if (status != SS$_NORMAL)P  status = sys$lookup_license(&clu_lic2,itm,&prc_nam,&LMF$M_RETURN_FAILURES,0,0);    /* If O.K., we can return. */  )  if (status == SS$_NORMAL) return status;   D  /* If the login attempt occurs on the console, grant it, but return     a different status. */  A  if (!(strcmp(lgi->T_PHYDEVNAM,"_OPA0:"))) return LGI$_LOGOPRCON;   <  /* If this is a DECwindows login, return LGI$_LICNOTREQ. */  @  if (lgi->L_LGISRC == CHKLGI$_DECWINDOWS) return LGI$_LICNOTREQ;  G  /* Otherwise, no login may occur. Convert all LMF-specific error codes J     to the single login code LGI$_NOVAXCLUSTER ("DEC VMSCLUSTER license is     not active"). */    return LGI$_NOVAXCLUSTER; } 