 #ifdef VAXC   #module GETUSR "BOL-V1.0/OCT-95" #else ' #pragma module GETUSR "BOL-V1.0/OCT-95"  #endif  G /* This routine returns an UAF record according some input criteria and &    databases (SYSALF and NET[$]PROXY).  ;    (P) 1995 by Ing. Ferry Bolhr (bol@adv.magwien.gv.at) */   4 #include dcdef		/* DC$_xxx device class constants */2 #include descrip	/* Definitions for descriptors */* #include dvidef		/* DVI$_xxx item codes */9 #include lib$routines	/* LIB$ RTL function definitions */ < #include psldef		/* PSL$C_xxxx process status definitions */? #include rms		/* RMS (FAB, RAB) definitions and status codes */ 1 #include ssdef		/* SS$_xxx system status codes */ ; #include starlet	/* SYS$xxx() system service definitions */ 4 #include string		/* strxxx() function definitions */* #include syidef		/* SYI$_xxx item codes */( #include ttdef		/* TT$M_xxx bit names */* #include uaidef		/* UAI$_xxx item codes */  ? #include "chklgidef.h"	/* CHKLGI$_xxx login source constants */ ? #include "lgibufdef.h"	/* LGIBUF structure field definitions */ 8 #include "lgimsgdef.h"	/* LGI$_xxx login status codes */; #include "compdepnd.h"	/* Compiler-dependend definitions */    /* ALF record definitions */  ? #define ALF$C_LENGTH 128	/* Length of record in ALF database */ F #define ALF$T_DEVNAME 0		/* Relative position of terminal/port name */H #define ALF$T_USERNAME 63	/* Relative position of associated username */  - /* Auxilliary routines called by getusr(): */   G static int gettrm(char*,int,char*,char*); /* Get terminal attributes */ C static int getalf(char*,char*);		  /* Get user from ALF database */ K static int getprx(char*,char*,char*);	  /* Get user via proxy processing */ H static int getuai(char*,struct LGIBUF*);  /* Get information from UAF */   /* External routines: */  A int conlgi(struct LGIBUF*,char*);	  /* Check for console login */    /*  */    /*** GETUSR() ***/ /*** ======== ***/   /* Input arguments:   >  usrnam: a 1-12 character, zero-terminated string containing a# 	 valid VMS username. By reference.    E  lgidev: a 1-64 character, zero-terminated string containing the name = 	 of a valid, existing terminal or a logical name pointing to  	 this terminal. By reference   D  reminf: a 1-256 character, zero-terminated string containing remote< 	 information, in the format "REMNOD::REMUSR". By reference.  G  lgi:    the login buffer (buffer to receive information about the user = 	 whose account was determined by this routine). By reference       Return codes:  < 	SS$_NORMAL:   information about the given or obtainend user" 		      was successfully returned.  : 	SS$_BADPARAM: The login source is invalid or the 'reminf'5 		      string is not in the "REMINF::REMUSR" format.   7 	SS$_CONFQUAL: an invalid argument combination (missing , 		      or conflicting arguments) was given.  = 	LGI$_FILEACC: error accessing the system authorization file.   = 	LGI$_NOSUCHUSER: the given username wasn't found in the UAF.   0 	LGI$_NOTMODEM: remote modem not wired correctly  6 	LGI$_NOTVALID:	either there was no correspondig proxy. 			(remote/network logins) or no corresponding- 			record in the ALF database (local logins).   > 	LGI$_INVINPUT: the name given in the 'lgidev' argument is not2 		       a (known) terminal or workstation device.  " 	Any other error code returned by:  > 	o - System Services: SYS$GETDVI, SYS$GETUAI, SYS$VERIFY_PROXY< 	o - RMS Services: SYS$OPEN, SYS$CONNECT, SYS$GET, SYS$CLOSE     */   ( int getusr(char* usrnam, 	/* Username *// 	   char* lgidev,	/* Login Device (terminal) */ ) 	   char* reminf,	/* Remote Node::User */ + 	   struct LGIBUF* lgi)  /* Login Buffer */  {   char :  retusr[14],			/* VMS username returned by ALF or proxy */!  *ptr;				/* auxiliary pointer */     int  status,			/* Return status */7  trmstat = SS$_NORMAL;		/* Return status of gettrm() */     /*  */  L  /* Copy the remote information into the 'reminf' field. This information is*     used later for auditing processing. */  2  if (reminf != NULL) strcpy(lgi->T_REMINF,reminf);  H  /* Copy a username default string into the 'usrnam' field. This defaultE     is used later for auditing if no valid user could be found. We'll G     assume interactive login here. The default is changed as needed. It E     is updated with a valid username, as sonn as one can be found. */   !  strcpy(lgi->T_USRNAM,"<login>");   K  /* If a terminal was given in the 'lgidev' arg, translate it into physical ;     name, and if available, obtain the access port name. */        if (lgidev != NULL)  {>   if ((trmstat = gettrm(lgidev,lgi->L_LGISRC,lgi->T_PHYDEVNAM,$ 			lgi->T_ACCPORNAM)) != SS$_NORMAL)   { ?    /* If an error other than LGI$_INVINPUT is returned, pass it        immediately. */   0    if (trmstat != LGI$_INVINPUT) return trmstat;   }   }I  /* See whether the given username was "DEFAULT". This string is reserved G     for the AUTHORIZE utility's default account. If it was given, abort      immediately. */     if (usrnam != NULL)  {:   if (!(strcmp(usrnam,"DEFAULT"))) return LGI$_NOSUCHUSER;  }F  /* Ensure that the 'reminf' string contains a REMNOD::REMUSR pair. */    if (reminf != NULL)  {   ptr = strstr(reminf,"::");  '   if (ptr == NULL) return SS$_BADPARAM;   }/  /* Now process the different login sources. */     switch(lgi->L_LGISRC)  {	   /*  */      case CHKLGI$_BATCH:    { F    /* For this login source, a valid username must be supplied and all)       other arguments must be omitted. */   O    if (usrnam == NULL || lgidev != NULL || reminf != NULL) return SS$_CONFQUAL;   D    /* Change the default username string to indicate batch login. */  #    strcpy(lgi->T_USRNAM,"<batch>");   )    /* Get information about this user. */       return getuai(usrnam,lgi);    } 	   /*  */      case CHKLGI$_DETACHED:   { I    /* Change the default username string to indicate a detached login. */   !    strcpy(lgi->T_USRNAM,"<det>");   4    /* The rest is common with CHKLGI$_DECWINDOWS. */   }    case CHKLGI$_DECWINDOWS:   { K    /* This is the same as CHKLGI$_BATCH, except that a 'lgidev' argument is        allowed. */   =    if (usrnam == NULL || reminf != NULL) return SS$_CONFQUAL;   )    /* Get information about this user. */       status = getuai(usrnam,lgi);   (    /* If an error occured, return it. */  +    if (status != SS$_NORMAL) return status;   E    /* In case of DECwindows logins, if a login device was specified,  &       check for valid device class. */  G    if (lgi->L_LGISRC == CHKLGI$_DECWINDOWS && trmstat == LGI$_INVINPUT)     return trmstat;      /* Fine, everything O.K. */      return SS$_NORMAL;    } 	   /*  */      case CHKLGI$_DIALUP:   case CHKLGI$_LOCAL:    { E    /* We accept a 'usrnam' and/or 'lgidev' argument here. If 'usrnam' H       is specified, 'lgidev' is not further processed (used for auditingE       only). Otherwise, 'lgidev' must be specified and is used by ALF        to obtain a username. */  Q    if ((usrnam == NULL && lgidev == NULL) || reminf != NULL) return SS$_CONFQUAL;   5    /* If a username was given as input, return it. */   3    if (usrnam != NULL) status = getuai(usrnam,lgi);       else     {C     /* No username was given, so ALF processing must be done. If an B        access port name exists, we use it as key (this is requiredA        for logins via LAT). Otherwise, we use the physical device 4        name for logins over serial line or modem. */       if (lgi->T_ACCPORNAM[0])     { Q      if ((status = getalf(lgi->T_ACCPORNAM,retusr)) != SS$_NORMAL) return status;      }      else     { Q      if ((status = getalf(lgi->T_PHYDEVNAM,retusr)) != SS$_NORMAL) return status;      } @     /* Mark that this login is an auto-login (required for later        checks). */  )     lgi->L_IFLAGS |= CHKLGI$M_AUTO_LOGIN;   6     /* Get information about the user given by ALF. */        status = getuai(retusr,lgi);    }(    /* If an error occured, return it. */  +    if (status != SS$_NORMAL) return status;   D    /* Otherwise, if gettrm's status was LGI$_INVINPUT, return it. */  5    else if (trmstat == LGI$_INVINPUT) return trmstat;       return status;    } 	   /*  */      case CHKLGI$_REMOTE:   { A    /* For this login source, we accept all arguments. If 'lgidev' ?       is specified, we use it for ALF processing. Otherwise, we <       use 'reminf'. At least one of the three args _must_ be       supplied, however. */   O    if (usrnam == NULL && lgidev == NULL && reminf == NULL) return SS$_CONFQUAL;   2    /* If a 'usrnam' argument was given, use it. */  3    if (usrnam != NULL) status = getuai(usrnam,lgi);       else     {(     /* Mark this login as auto-login. */  )     lgi->L_IFLAGS |= CHKLGI$M_AUTO_LOGIN;   D     /* Use ALF to obtain a username. If a 'lgidev' arg was supplied,G        use the obtained access port or physical terminal string (access G        port info is used if available, otherwise, the physical terminal         name is used). */       if (lgidev != NULL)      {       if (lgi->T_ACCPORNAM[0])       {R       if ((status = getalf(lgi->T_ACCPORNAM,retusr)) != SS$_NORMAL) return status;      }	      else       {R       if ((status = getalf(lgi->T_PHYDEVNAM,retusr)) != SS$_NORMAL) return status;      }     }      else     { >      /* Otherwise, pass the given 'reminf' argument to ALF. */  G      if ((status = getalf(reminf,retusr)) != SS$_NORMAL) return status;      } *     /* Get information about this user. */        status = getuai(retusr,lgi);    }(    /* If an error occured, return it. */  +    if (status != SS$_NORMAL) return status;   D    /* Otherwise, if gettrm's status was LGI$_INVINPUT, return it. */  5    else if (trmstat == LGI$_INVINPUT) return trmstat;       return status;    } 	   /*  */      case CHKLGI$_NETWORK:    { E    /* We accept a 'usrnam' and/or 'reminf' argument here. If 'usrnam' F       is specified without 'reminf', it is used. Otherwise, a proxy isD       searched with the arguments given in 'reminf' and 'usrnam'. */  Q    if ((usrnam == NULL && reminf == NULL) || lgidev != NULL) return SS$_CONFQUAL;   F    /* Change the default username string to indicate network login. */  !    strcpy(lgi->T_USRNAM,"<net>");   L    /* If a 'usrnam' argument was given without 'reminf', use it directly. */  C    if (usrnam != NULL && reminf == NULL) return getuai(usrnam,lgi);   C    /* Otherwise, check the proxy database for an existing proxy. */   =    if ((status = getprx(reminf,usrnam,retusr)) == SS$_NORMAL)       return getuai(retusr,lgi);       else return status;   } G   /* All possible login sources are processed at this point. If we come =      here, the user specified an invalid source. Tell him. */      default: return SS$_BADPARAM;   } }   	 /******/    /*** gettrm() ***/ /*** -------- ***/  D /* This routine is used to obtain information about a given terminal0    and to ensure that it is a valid terminal. */  M static int gettrm(char* lgidev, int lgisrc, char* phydevnam, char* accpornam)  { H  /* Parameters:	trmnam...the name of the device which information should 		be obtained for    		lgisrc...the login source   . 		phydevnam...the physical or full device name  + 		accpornam...the access port name (if any)     0    Return status: SS$_NORMAL...validation was OK  ; 		  LGI$_INVINPUT...the given input device isn't a terminal   4 		  LGI$_NOTMODEM...remote modem not wired correctly  , 		  Any other return status from SYS$GETDVI.   ******/     char %  fulnam[64],			/* Full device name */ )  phynam[64];			/* Physical device name */       short+  fullen,			/* Length of full device name */ /  phylen,			/* Length of physical device name */ +  acclen,			/* Length of access port name */ 1  iosb[4];			/* I/O status block for SYS$GETDVI */       int  devcls,			/* device class */ )  devtt,				/* terminal characteristics */   status;			/* return status */  C  $DESCRIPTOR(trmdsc,lgidev);	/* VMS descriptor for terminal name */   7  struct itmlst itm[6] =		/* item list for SYS$GETDVI */   {!   4, DVI$_DEVCLASS,    &devcls,0, !   4, DVI$_DEVDEPEND,   &devtt,0,  (  63, DVI$_FULLDEVNAM,   fulnam, &fullen,(  63, DVI$_TT_PHYDEVNAM, phynam, &phylen,*  63, DVI$_TT_ACCPORNAM,accpornam, &acclen,   0, 0  };   /* Setup the descriptor. */  &  trmdsc.dsc$w_length = strlen(lgidev);  G  /* Call SYS$GETDVIW to obtain this information: device class, physical 3     terminal name and access port name (if any). */   F  if ((status = sys$getdviw(0,0,&trmdsc,itm,iosb,0,0,0)) != SS$_NORMAL)     return status;  "  /* Check the I/O status block. */  +  if (iosb[0] != SS$_NORMAL) return iosb[0];   7  /* Mark the end of the various device name strings. */     accpornam[acclen] = '\0';    fulnam[fullen] = '\0';     phynam[phylen] = '\0';   B  /* If we got a physical device name, return it. Otherwise, return     the full device name. */  &  if (phylen) strcpy(phydevnam,phynam);    else strcpy(phydevnam,fulnam);   D  /* Check the device class. It must be either DC$_TERM (terminal) or6     DC$_WORKSTATION (DECwindows workstation device. */  K  if (devcls != DC$_TERM && devcls != DC$_WORKSTATION) return LGI$_INVINPUT;   >  /* If this is a terminal and was set to /MODEM, the TT_REMOTEJ     characteristic must be set as well, otherwise return LGI$_NOTMODEM. */    if (devcls == DC$_TERM)  {   if (devtt & TT$M_MODEM)    { 4    if (!(devtt & TT$M_REMOTE)) return LGI$_NOTMODEM;   }   }L  /* OK, thats all. Physical device name and access port name were already   >     placed in their approbiate buffers. Return to getusr(). */    return SS$_NORMAL;  }   	 /******/    /*** getalf() ***/ /*** -------- ***/  F /* This routine is used to emulate ALF processing. If the ALF databaseF    exists, it uses the given input string as key into the database. */  - static int getalf(char* keystr, char* retusr)  { 9  /* Parameters:	keystr...the key which we should look for   3 		retusr...the username which machtes the given key   5    Return status: SS$_NORMAL: we've found a username.   - 		  LGI$_NOTVALID: user authorization failure   7 		  Any other return status from SYS$OPEN, SYS$CONNECT, 6 		  SYS$GET and SYS$CLOSE. Note that the return states6 		  RMS$_FNF (file not found) and RMS$_RNF (record not* 		  found) are converted to LGI$_NOTVALID.   ******/     char C  filnam[] = "SYSALF",		/* File name (or logical pointing to file */ 6  defnam[] = "SYS$SYSTEM:.DAT",	/* Default file name */5  record[ALF$C_LENGTH];		/* Buffer receiving record */   *  int status;			/* Primary return status */  7  struct FAB alf_fab;		/* RMS FAB (file access block) */ 9  struct RAB alf_rab;		/* RMS RAB (record access block) */   O  /* First ensure that ALF is not processed from the system's console device. */   6  if (!(strcmp(keystr,"_OPA0:"))) return LGI$_NOTVALID;    /* Now, initialize FAB. */     alf_fab = cc$rms_fab;M  alf_fab.fab$b_acmodes = PSL$C_EXEC;	/* SYSALF trans in exec/krnl mode only*/ 0  alf_fab.fab$l_dna = defnam;		/* Default name */<  alf_fab.fab$b_dns = strlen(defnam);	/* Default name size */;  alf_fab.fab$b_fac = FAB$M_GET;		/* We want to read only */ -  alf_fab.fab$l_fna = filnam;		/* File name */ 9  alf_fab.fab$b_fns = strlen(filnam);	/* File name size */ 3  alf_fab.fab$b_org = FAB$C_IDX;		/* Indexed file */ P  alf_fab.fab$b_shr = FAB$M_GET|FAB$M_UPI|FAB$M_PUT|FAB$M_UPD; /* Sharing opts */    /* Open the ALF database. */   !  status = sys$open(&alf_fab,0,0);   I  /* If an error occured, lets check for RMS$_FNF (file not found). If so, I     there is no ALF database and we will return LGI$_NOTVALID instead. */     if (status != RMS$_NORMAL)   {1   if (status == RMS$_FNF) status = LGI$_NOTVALID;      return status;  }?  /* There is an ALF database to process. Initialize the RAB. */     alf_rab = cc$rms_rab;?  alf_rab.rab$l_fab = &alf_fab;		/* Addr of corresponding FAB */ 3  alf_rab.rab$b_rac = RAB$C_KEY;		/* Keyed access */ =  alf_rab.rab$b_ksz = strlen(keystr);	/* Size of key string */ 9  alf_rab.rab$l_kbf = keystr;		/* Address of key string */ 3  alf_rab.rab$b_krf = 0;			/* Reference by key #0 */ >  alf_rab.rab$w_usz = ALF$C_LENGTH;	/* Length of user buffer */:  alf_rab.rab$l_ubf = record;		/* Address of user buffer */  !  /* Connect the RAB to the FAB */   $  status = sys$connect(&alf_rab,0,0);  )  /* If error, close the FAB and return */     if (status != RMS$_NORMAL)d  {   sys$close(&alf_fab);     return status;    }<  /* Get the record and immediately close the ALF database */     status = sys$get(&alf_rab,0,0);    sys$close(&alf_fab);   A  /* If the return code is RMS$_RNF (record not found), convert ito     to LGI$_NOTVALID; */    if (status != RMS$_NORMAL)$  {1   if (status == RMS$_RNF) status = LGI$_NOTVALID;i     return status;  }G  /* A valid record was found. Return it to the user. Since the usernameLG     is returned as blank-filled string, truncate the string first to 13sH     chars (the maximum username length + 1) and then skip the characters%     starting with the first blank. */x  -  strncpy (retusr,&record[ALF$T_USERNAME],14);$  $  retusr[strcspn(retusr," ")] = '\0';    /* All fine, return now. */    return SS$_NORMAL;c }e  	 /******/Y   /*** getprx() ***/ /*** -------- ***/  H /* This routine is used to perform proxy processing. This is done simply3    by using the SYS$VERIFY_PROXY system service. */*  9 static int getprx(char* reminf,char* usrnam,char* retusr)o {*E  /* Parameters:	reminf...remote information in the format NODE::USER."  D 	        usrnam...if a proxy contains more targets, use this target. 			 This argument is optionalG   		retusr...the obtained target  5    Return status: SS$_NORMAL: we've found a username.o  = 		  LGI$_NOTVALID: no matching proxy was found or no username , 				 was given and the matching proxy has no 			         DEFAULT entry.  ; 		  LGI$_NOSUCHUSER: a matching proxy was found but withoutt! 				 the entry given in 'usrnam'.g  < 		  Any other return status from SYS$VERIFY_PROXY. Note that< 		  the return states SECSRV$_NOSUCHPROXY (no matching proxy> 		  found) and SECSRV$_NOSUCHUSER (no valid user for requested3 		  proxy found) are converted to LGI$_NOTVALID and " 		  LGI$_NOSUCHUSER, respectively.   ******/n    charn;  retusrbuf[40],		/* Buffer receiving the target username */    *ptr;			/* Auxiliary pointer */    short5  retlen;		/* Word receiving the target user length */     int  status;		/* return status */a  "  $DESCRIPTOR(remnoddsc,retusrbuf);"  $DESCRIPTOR(remusrdsc,retusrbuf);  $DESCRIPTOR(usrnamdsc,usrnam);n"  $DESCRIPTOR(retusrdsc,retusrbuf);  H  /* Ensure that VMS V6 (V6.1 VAX or V6.2 Alpha) is available. Otherwise,E     there is no documented way to perform proxy processing, so simply      return LGI$_NOTVALID. */  
 #ifndef V6_OKi  return LGI$_NOTVALID; #elseh  A  /* Now, create two descriptors. Split the 'reminf' string at therD     current position, advance the pointer (which currently points toD     the first ':') to the start of the USER part of 'reminf' and set     up the descriptors. */    ptr = strstr(reminf,"::");e  
  *ptr = '\0';   
  ptr += 2;  )  remnoddsc.dsc$w_length = strlen(reminf);("  remnoddsc.dsc$a_pointer = reminf;  &  remusrdsc.dsc$w_length = strlen(ptr);  remusrdsc.dsc$a_pointer = ptr;o  6  /* Omit the 'usrnam' argument, if it wasn't given. */    if (usrnam != NULL)  {*   usrnamdsc.dsc$w_length = strlen(usrnam);  H   status = sys$verify_proxy(&remnoddsc,&remusrdsc,&usrnamdsc,&retusrdsc, 	   &retlen,0);e  }N  else status = sys$verify_proxy(&remnoddsc,&remusrdsc,0,&retusrdsc,&retlen,0);  4  /* In case of success, return the obtained name. */    if (status == SS$_NORMAL)  {   retusrbuf[retlen] = '\0';u     strcpy(retusr,retusrbuf);s     return SS$_NORMAL;  };  /* Otherwise, convert specific errors to LGI$_NOTVALID. */$    switch(status)  {   case SECSRV$_NOSUCHPROXY:	5   case SECSRV$_SERVERNOTACTIVE: return LGI$_NOTVALID;i  2   case SECSRV$_NOSUCHUSER: return LGI$_NOSUCHUSER;     default: return status;o  } #endif	/* V6_OK */ }   	 /******/	   /*** getuai() ***/ /*** -------- ***/  I /* This routine obtains all information from the UAF database for further/K    processing. If the given user doesn't exist, it returns LGI$_NOSUCHUSER.   J    If SYS$GETUAI returns RMS$_FNF and the system parameter UAFALTERNATE isH    set to 1 and the login occurs on the console with username SYSTEM, we:    will allow the login and substitute standard values. */  5 static int getuai(char* usrnam,struct LGIBUF* recbuf)  {iI  /* Parameters:	usrnam...user name which we should obtain information forh  = 		recbuf...a pointer to a LGIBUF buffer. This buffer receives 4 			 all information and is used for all checks later  5    Return status: SS$_NORMAL: we've found a username.   2 		  LGI$_NOSUCHUSER: user didn't exist in the UAF.  & 		  LGI$_FILEACC: error accessing UAF.  9 		  Any other return codes from SYS$GETUAI. Note that thet4 		  code RMS$_RNF (record not found) is converted to4 		  LGI$_NOSUCHUSER and RMS$_FNF (file not found) is! 		  converted to LGI$_FILEACC. */i   /******/    char -  cli[32],				/* Buffer to receive CLI name */$1  clitab[32];				/* Buffer to receive CLITABLES */e    int*  status,				/* SYS$GETUAI return status */"  temp;					/* Temporary storage */  >  $DESCRIPTOR(usrnamdsc,usrnam);		/* Descriptor for username */  8  struct itmlst itm[30] =		/* item list for SYS$GETUAI */  {%   32,UAI$_ACCOUNT,recbuf->T_ACCNAM,0,u    4,UAI$_UIC,&recbuf->L_UIC,0,i  2    3,UAI$_NETWORK_ACCESS_P,&recbuf->L_ACCESS[0],0,2    3,UAI$_NETWORK_ACCESS_S,&recbuf->L_ACCESS[1],0,0    3,UAI$_BATCH_ACCESS_P,&recbuf->L_ACCESS[2],0,0    3,UAI$_BATCH_ACCESS_S,&recbuf->L_ACCESS[3],0,0    3,UAI$_LOCAL_ACCESS_P,&recbuf->L_ACCESS[4],0,0    3,UAI$_LOCAL_ACCESS_S,&recbuf->L_ACCESS[5],0,1    3,UAI$_DIALUP_ACCESS_P,&recbuf->L_ACCESS[6],0,t1    3,UAI$_DIALUP_ACCESS_S,&recbuf->L_ACCESS[7],0, 1    3,UAI$_REMOTE_ACCESS_P,&recbuf->L_ACCESS[8],0, 1    3,UAI$_REMOTE_ACCESS_S,&recbuf->L_ACCESS[9],0,e*    4,UAI$_PRIMEDAYS,&recbuf->L_PRIMDAYS,0,  )    1,UAI$_ENCRYPT,&recbuf->B_PWDENC[0],0,h*    1,UAI$_ENCRYPT2,&recbuf->B_PWDENC[1],0,!    8,UAI$_PWD,recbuf->Q_PWD[0],0,G"    8,UAI$_PWD2,recbuf->Q_PWD[1],0,)    8,UAI$_PWD_DATE,recbuf->Q_PWDDAT[0],0,c*    8,UAI$_PWD2_DATE,recbuf->Q_PWDDAT[1],0,$    2,UAI$_SALT,&recbuf->W_PWDSALT,0,*    8,UAI$_PWD_LIFETIME,recbuf->Q_PWDTIM,0,(    8,UAI$_EXPIRATION,recbuf->Q_EXPTIM,0,  #    4,UAI$_FLAGS,&recbuf->L_FLAGS,0,g'    8,UAI$_DEF_PRIV,recbuf->Q_DEFPRIV,0,      32,UAI$_DEFCLI,cli,0,m   32,UAI$_CLITABLES,clitab,0,L  .    2,UAI$_MAXACCTJOBS,&recbuf->W_MAXACCJOBS,0,'    2,UAI$_MAXJOBS,&recbuf->W_MAXJOBS,0,/)    2,UAI$_LOGFAILS,&recbuf->W_LOGFAILS,0,i      0,0};    /* Setup descriptor. */  *  usrnamdsc.dsc$w_length = strlen(usrnam);   !  /* Let's call SYS$GETUAI now. */h  /  status = sys$getuai(0,0,&usrnamdsc,itm,0,0,0);S    if (status == SS$_NORMAL)  {B   /* Overwrite the default name string with the valid username. */  "   strcpy(recbuf->T_USRNAM,usrnam);  @   /* Copy account name. It is returned as a fixed-length, blank-      filled string. */  9   recbuf->T_ACCNAM[strcspn(recbuf->T_ACCNAM," ")] = '\0';e  B   /* Copy CLI and CLITABLES. This information is returned as ASCIC3      string (first byte contains string length). */d  (   strncpy(recbuf->T_CLI,&cli[1],cli[0]);     recbuf->T_CLI[cli[0]] = '\0';   1   strncpy(recbuf->T_CLITAB,&clitab[1],clitab[0]);/  %   recbuf->T_CLITAB[clitab[0]] = '\0';n  K  /* All information is now in the LGIBUF data structure, so we can exit. */      return SS$_NORMAL;  }E  /* If status is RMS$_FNF (file not found), we must check for a loginx     attempt with alternate UAF:e  '     o - Login must occur on the consoles'     o - Given username must be "SYSTEM"m7     o - System parameter UAFALTERNATE must be set to 1.-  N     In this case, substitute default values and let the user login. Otherwise,@     return LGI$_FILEACC (error accessing authorization file). */    if (status == RMS$_FNF) M  {O   if (!conlgi(recbuf,usrnam)) return LGI$_FILEACC; /* No console login? Exit.*/u  /   /* Check whether UAFALTERNATE is set to 1. */   D   if ((status = lib$getsyi(&SYI$_UAFALTERNATE,&temp)) != SS$_NORMAL)   return status;  A   if (!temp) return LGI$_FILEACC;		/* UAFALTERNATE = 0? Abort. */o  D   /* A login occured on the console when UAFALTERNATE was 1. This is@      used on emergency when the system manager has forgotten its;      password. Grant this login and substitute defaults. */t  8   strcpy(recbuf->T_USRNAM,"SYSTEM");		/* Set username */  C   strcpy(recbuf->T_ACCNAM,recbuf->T_USRNAM);	/* and account name */f  3   strcpy(recbuf->T_CLI,"DCL");			/* and CLI name */s  B   strcpy(recbuf->T_CLITAB,"DCLTABLES");		/* and CLI tables name */  1   recbuf->L_UIC = 0x00010004;			/* UIC = [1,4] */u  K   recbuf->Q_DEFPRIV[0] = recbuf->Q_DEFPRIV[1] = -1; /* All privs are set *//  '   /* Mark this login as "alternate"; */   )   recbuf->L_IFLAGS |= CHKLGI$M_ALTERNATE;u  F   /* No need to set other fields since they were initialized with 0 in-      the main routine which is sufficient. */      return SS$_NORMAL;  };  /* Store the non-existent username in its own field (we'lli'     require this later for auditing. */n  !  strcpy(recbuf->T_BADNAM,usrnam);i  8  /* If status is RMS$_RNF (record not found), convert it4     to LGI$_NOSUCHUSER, else return it unchanged. */  6  return status == RMS$_RNF ? LGI$_NOSUCHUSER : status; }  l