 #ifdef VAXC   #module INTRUS "BOL-V1.0/OCT-95" #else ' #pragma module INTRUS "BOL-V1.0/OCT-95"  #endif  6 /* This routine performs intrusion-related operations.  ;    (P) 1995 by Ing. Ferry Bolhr (bol@adv.magwien.gv.at) */   B #ifdef __DECC		/* For VAXC, the following module doesn't exist: */* #include ciadef		/* CIA$M_xxx flag bits */ #endif2 #include descrip	/* Definitions for descriptors */. #include stdio		/* Standard I/O definitions */4 #include string		/* strxxx() function definitions */; #include starlet	/* SYS$xxx() system service definitions */ 1 #include ssdef		/* SS$_xxx system status codes */   @ #include "chklgidef.h"  /* CHKLGI$_xxx login source constants */@ #include "lgibufdef.h"  /* LGIBUF structure field definitions */9 #include "lgimsgdef.h"  /* LGI$_xxx login status codes */ L #include "compdepnd.h"	/* Compiler dependencies (CIA$xxx symbols for VAXC */   /***  ***/    /*** INTRUS() ***/ /*** ======== ***/   /* Input arguments:   -  lgistat:   Status of login attempt, by value   H  lgi:       Login buffer containing additional information. By reference      Return codes:  ( 	LGI$_EVADE:	Breakin evasion in progress   	The given login status   . 	Any error code returned by SYS$SCAN_INTRUSION    */  P typedef struct dsc$descriptor_s dsc;    /* Abbreviation for descriptor struct.*/  * int intrus(int lgistat,struct LGIBUF* lgi) { E  /* Intrusion database scanning is done by the new SYS$SCAN_INTRUSION ?     system service. This service exists on OpenVMS VAX V6.1 and B     OpenVMS Alpha V6.2 and higher only. If we are running an older/     version, simply return the given status. */   
 #ifndef V6_OK   return lgistat; #else   -  /* Otherwise, use the new system service. */     char "  *ptr;					/* Auxiliary pointer */    int&  tmp = 0, 				/* Auxiliary variable */&  flags,					/* System service flags */  status;				/* Return status */     $DESCRIPTOR (usr, ptr);  $DESCRIPTOR (trm, ptr);  $DESCRIPTOR (srcnod, ptr);   $DESCRIPTOR (srcusr, ptr);   F  /* Intrusion processing only occurs for the following login failures:  ,     LGI$_NOTVALID	User authorization failure      LGI$_NOSUCHUSER	No such user!     LGI$_INVPWD		Invalid password $     LGI$_DISUSER	Account is disabled  F     In all other cases, the login is rejected, but no intrusion record     is created. */    switch (lgistat)   {   case LGI$_NOTVALID:    case LGI$_NOSUCHUSER: D   case LGI$_DISUSER:		/* For these failures, intrusion processing */.   case LGI$_INVPWD: break;	/* must be done. */  :   default: return lgistat;	/* Otherwise, simply return. */  }M  /* Set control flags initially. Don't audit, we perform our own auditing. */     flags = CIA$M_NOAUDIT;   -  /* Build the descriptor for the username. */   *  usr.dsc$w_length = strlen(lgi->T_USRNAM);#  usr.dsc$a_pointer = lgi->T_USRNAM;   F  /* Pass different information to the system service, depending on theD     given arguments. Note: passwords are not supplied here; they areE     used by SYS$SCAN_INTRUSION for auditing only. Since we do our own -     auditing later, we can omit them here. */   
  while (1)  {C   /* If a remote info was specified, pass it. In this, we create an +      intrusion record of type "NETWORK". */      if (lgi->T_REMINF[0])    { $    ptr = strstr(lgi->T_REMINF,"::");  =    srcnod.dsc$w_length = strlen(lgi->T_REMINF) - strlen(ptr);   (    srcnod.dsc$a_pointer = lgi->T_REMINF;  )    srcusr.dsc$w_length = strlen(ptr) - 2;   "    srcusr.dsc$a_pointer = ptr + 2;  ;    status = sys$scan_intrusion (lgistat,	/* Login status */  				&usr,		/* Username */ # 				lgi->L_LGISRC,	/* Login type */   				0,		/* No source terminal */ 				&srcnod,	/* Source node */ 				&srcusr, 	/* Source user */  				0,		/* No source address */ ( 				0,0,0,		/* No pwd and parent info */  				flags);		/* And our flags */	    break;    } @   /* If an access port name exists in the REMNOD::REMUSR format,=      we must create a NETWORK record as well. This occurs for :      RTAn: devices used with remote interactive logins. */     if (lgi->T_ACCPORNAM[0])   { 5    if ((ptr = strstr(lgi->T_ACCPORNAM,"::")) != NULL)     {A     srcnod.dsc$w_length = strlen(lgi->T_ACCPORNAM) - strlen(ptr);   ,     srcnod.dsc$a_pointer = lgi->T_ACCPORNAM;  *     srcusr.dsc$w_length = strlen(ptr) - 2;  #     srcusr.dsc$a_pointer = ptr + 2;   ;     status = sys$scan_intrusion(lgistat,	/* Login status */  				&usr,		/* Username */ # 				lgi->L_LGISRC,	/* Login type */   				0,		/* No source terminal */ 				&srcnod,	/* Source node */ 				&srcusr, 	/* Source user */  				0,		/* No source address */ ( 				0,0,0,		/* No pwd and parent info */  				flags);		/* And our flags */
     break;    }   } A   /* Pass the terminal name to SYS$SCAN_INTRUSION, it will obtain @      the access port name, if one is available. Depending on the<      username, either build a TERM_USER record (username was>      valid) or TERMINAL record (username wasn't valid). Bypass@      this for detached logins with a mailbox as login device. */  ?   if (lgi->T_PHYDEVNAM[0] && lgi->L_LGISRC != CHKLGI$_DETACHED)    { /    trm.dsc$w_length = strlen(lgi->T_PHYDEVNAM);   (    trm.dsc$a_pointer = lgi->T_PHYDEVNAM;  ;    /* If the user exists (the username string doesn't start ;       with '<'), mark it as real user to create a TERM_USER        record. */  =    if (lgi->T_USRNAM[0] != '<') flags |= CIA$M_REAL_USERNAME;   ;    status = sys$scan_intrusion(lgistat,		/* Login status */ " 		  	       &usr, 		/* Username */) 			       lgi->L_LGISRC,	/* Login type */ 5 		               &trm,		/* Source terminal, if any */ " 			       0,		/* No source node */# 			       0, 		/* No source user */ % 			       0,		/* No source address */ . 			       0,0,0,		/* No pwd and parent info */& 			       flags);		/* And our flags */	    break;    } L   /* Otherwise, we have no more info, so we can supply the username only. */     flags |= CIA$M_REAL_USERNAME;   :   status = sys$scan_intrusion(lgistat,		/* Login status */ 			      &usr,		/* Username */( 			      lgi->L_LGISRC,	/* Login type */% 			      0,		/* No source terminal */ ! 			      0,		/* No source node */ " 			      0, 		/* No source user */$ 			      0,		/* No source address */- 			      0,0,0,		/* No pwd and parent info */ % 			      flags);		/* And our flags */    break;  }E  /* Convert the return status to a login-specific code. If the status I     is informational, return the status given as input. If it is SECSRV$_ F     INTRUDER (intrusion was found), convert it to LGI$_EVADE (breakin-E     evasion is in effect); if it is SECSRV$_SERVERNOTACTIVE (security H     server not running), convert it to LGI$_NOTVALID (user authorization,     failure). Otherwise, return it as is. */    switch (status)  {   case SS$_NORMAL:   case SECSRV$_SUSPECT: 1   case SECSRV$_NOSCANNEDINTRUDER: return lgistat;   5   case SECSRV$_SERVERNOTACTIVE: return LGI$_NOTVALID;   +   case SECSRV$_INTRUDER: return LGI$_EVADE;      default: return status;   }  /* That's all here. */    #endif	/* V6_OK */ } 