dnl Parameterized macros that do not check for something specific.
dnl This file is part of Autoconf.
dnl Copyright (C) 1992, 1993, 1994 Free Software Foundation, Inc.
dnl
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2, or (at your option)
dnl any later version.
dnl
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software
dnl Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
dnl
dnl Written by David MacKenzie, with help from
dnl Franc,ois Pinard, Karl Berry, Richard Pixley, Ian Lance Taylor,
dnl Roland McGrath, Noah Friedman, and david d zuhn.
dnl
changequote([,])dnl
undefine([include])dnl
undefine([shift])dnl
undefine([format])dnl
dnl traceon[]dnl
ifdef([__gnu__], , [errprint(Autoconf requires GNU m4
)m4exit(2)])dnl
dnl
dnl
dnl Utility functions for stamping the configure script.
dnl
dnl
define(AC_ACVERSION, 1.11)dnl
dnl This is defined by the --version option of the autoconf script.
ifdef([AC_PRINT_VERSION], [errprint(Autoconf version AC_ACVERSION
)])dnl
dnl
dnl These are currently not used, for the sake of people who diff
dnl configure scripts and don't want spurious differences.
dnl But they are too clever to just delete.
dnl
define(AC_USER, [esyscmd(
$!# Extract the user name from the first pair of parentheses.
$ WRITE SYS$OUTPUT F$GETJPI("","USERNAME"))])dnl
dnl
define(AC_HOST, [esyscmd($ WRITE SYS$OUTPUT F$GETSYI("NODENAME"))])dnl
dnl
define(AC_DATE, [esyscmd($ SHOW TIME)])dnl
dnl
dnl
dnl Controlling Autoconf operation
dnl
dnl
dnl This is used in VMS command files, to make unique lables.
dnl
define([VMS],)dnl
dnl
define(AC_DEFINE_VMS_LABLE,[dnl takes $1 for a lable symbol and $2 as a lable counter prefix
ifdef([$2_LABLE_COUNTER],dnl
[define([$2_LABLE_COUNTER],eval($2_LABLE_COUNTER + 1))dnl
],[define([$2_LABLE_COUNTER],0)])dnl
define([$1_VMS_LABLE],[$2_VMS_LABLE]$2_LABLE_COUNTER)])dnl
dnl
define(AC_USE_VMS_LABLE,[dnl takes $1 for a lable symbol
ifdef([$1_VMS_LABLE],$1_VMS_LABLE)])dnl
define(AC_REJECT_VMS_LABLE,[dnl takes $1 for a lable symbol
ifdef([$1_LABLE_COUNTER],dnl
[define([$1_LABLE_COUNTER],eval($1_LABLE_COUNTER - 1))])])dnl
dnl traceon([AC_DEFINE_VMS_LABLE])dnl
dnl traceon([AC_USE_VMS_LABLE])dnl
dnl
dnl This is only useable on VMS
dnl it takes one argument, which is the code to execute.
dnl That code HAS to end with a newline.
define(AC_MAYBE_SILENT,[AC_DEFINE_VMS_LABLE(__save_mesg,__save_mesg)dnl
$ __debug = f$trnlnm("DEBUG_CONFIGURE")
$ if .not. __debug then AC_USE_VMS_LABLE(__save_mesg) = f$environment("MESSAGE")
$ if .not. __debug then set message/nofacility/noident/noseverity/notext
$ if .not. __debug then def/user sys$output nl:
$ if .not. __debug then def/user sys$error nl:
$1
$ if .not. __debug then set message 'AC_USE_VMS_LABLE(__save_mesg)'
AC_REJECT_VMS_LABLE(__save_mesg)dnl
$]) dnl
dnl
define(AC_MAYBE_NOERROR,[AC_DEFINE_VMS_LABLE(__save_mesg,__save_mesg)dnl
$ __debug = f$trnlnm("DEBUG_CONFIGURE")
$ if .not. __debug then AC_USE_VMS_LABLE(__save_mesg) = f$environment("MESSAGE")
$ if .not. __debug then set message/nofacility/noident/noseverity/notext
$ if .not. __debug then def/user sys$error nl:
$1
$ if .not. __debug then set message 'AC_USE_VMS_LABLE(__save_mesg)'
AC_REJECT_VMS_LABLE(__save_mesg)dnl
$]) dnl
dnl This is separate from AC_INIT to prevent GNU m4 1.0 from coredumping
dnl when AC_CONFIG_HEADER is used.
define(AC_NOTICE,
[$!# Guess values for system-dependent variables and create Makefiles.
dnl [$!] Generated automatically using autoconf.
$!# Generated automatically using autoconf version] AC_ACVERSION [
dnl [$!] by AC_USER@AC_HOST on AC_DATE
$!# Copyright (C) 1991, 1992, 1993, 1994 Free Software Foundation, Inc.
$
$!# This configure script is free software; you can redistribute it and/or
$!# modify it under the terms of the GNU General Public License as published
$!# by the Free Software Foundation; either version 2, or (at your option)
$!# any later version.
$
$!# This script is distributed in the hope that it will be useful, but
$!# WITHOUT ANY WARRANTY; without even the implied warranty of
$!# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
$!# Public License for more details.
$
$!# You should have received a copy of the GNU General Public License
$!# along with this program; if not, write to the Free Software
$!# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
$
$ set symbol/verb/scope=(noglobal,nolocal)
$])dnl
dnl
dnl This is only use on VMS so far. It defines more substitutions of
dnl shell variable values which are not marked with @'s.
dnl divertion 7 is used.
define(AC_INSTALL_EXTRA_prsub,
[AC_OBSOLETE([$0], [.  Instead use AC_INSTALL_EXTRA_ac_prsub($1)])dnl
AC_INSTALL_EXTRA_ac_prsub([$1])])dnl
define(AC_INSTALL_EXTRA_ac_prsub,[divert(7)dnl
ifdef([AC_PRSUB_COUNTER],,[define(AC_PRSUB_COUNTER,)$ ac_prsub_counter = 0
])dnl
$ if "''$1'" .nes. ""
$  then
$   ac_prsub_counter = ac_prsub_counter + 1
$   ac_prsub'ac_prsub_counter'="position(beginning_of (main_buffer));"
$   ac_prsub_counter = ac_prsub_counter + 1
$   ac_prsub'ac_prsub_counter'= "r := search_quietly(LINE_BEGIN+(""""$1""""+ ((p_0_or_more_spc +""""="""")@r1))@r0+LINE_END,FORWARD);"
$   ac_prsub_counter = ac_prsub_counter + 1
$   ac_prsub'ac_prsub_counter'="if (r = 0)"
$   ac_prsub_counter = ac_prsub_counter + 1
$   ac_prsub'ac_prsub_counter'="then"
$   ac_prsub_counter = ac_prsub_counter + 1
$   ac_prsub'ac_prsub_counter'="position(beginning_of (main_buffer));"
$   ac_prsub_counter = ac_prsub_counter + 1
$   ac_prsub'ac_prsub_counter'= "r := search_quietly(LINE_BEGIN+(""""$1""""+ ((p_0_or_more_spc +""""="""")@r1)+scan(""""""""))@r0+LINE_END,FORWARD);"
$   ac_prsub_counter = ac_prsub_counter + 1
$   ac_prsub'ac_prsub_counter'="endif;"
$   ac_prsub_counter = ac_prsub_counter + 1
$   ac_prsub'ac_prsub_counter'="if (r <> 0)"
$   ac_prsub_counter = ac_prsub_counter + 1
$   ac_prsub'ac_prsub_counter'="then"
$   ac_prsub_counter = ac_prsub_counter + 1
$! This is a piece of deep DCL magic.
$   ac_prsub_support'ac_prsub_counter'="__ac_prsub_tmp:='$1'"
$   ac_prsub'ac_prsub_counter'="res := """"$1"""" + """"=""""+""""'"+"'__ac_prsub_tmp'"""";"
$   ac_prsub_counter = ac_prsub_counter + 1
$   ac_prsub'ac_prsub_counter'="erase(r0);"
$   ac_prsub_counter = ac_prsub_counter + 1
$   ac_prsub'ac_prsub_counter'="position(r0);"
$   ac_prsub_counter = ac_prsub_counter + 1
$   ac_prsub'ac_prsub_counter'="copy_text(res);"
$   ac_prsub_counter = ac_prsub_counter + 1
$   ac_prsub'ac_prsub_counter'="endif;"
$  endif
$!#
$
divert(0)])dnl
dnl
dnl This is only use on VMS so far. It defines more substitutions of
dnl shell variable values which are not marked with @'s.
dnl divertion 7 is used.
define(AC_INSTALL_EXTRA_vpsub,
[AC_OBSOLETE([$0], [.  Instead use AC_INSTALL_EXTRA_ac_vpsub($1)])dnl
AC_INSTALL_EXTRA_ac_vpsub([$1])])dnl
define(AC_INSTALL_EXTRA_ac_vpsub,[divert(7)dnl
ifdef([AC_VPSUB_COUNTER],,[define(AC_VPSUB_COUNTER,)$ ac_vpsub_counter = 0
])dnl
$ if "''$1'" .nes. ""
$  then
$   ac_vpsub_counter = ac_vpsub_counter + 1
$   ac_vpsub'ac_vpsub_counter'="position(beginning_of (main_buffer));"
$   ac_vpsub_counter = ac_vpsub_counter + 1
$   ac_vpsub'ac_vpsub_counter'= "r := search_quietly(LINE_BEGIN+(""""$1""""+ ((p_0_or_more_spc +""""="""")@r1))@r0+LINE_END,FORWARD);"
$   ac_prsub_counter = ac_prsub_counter + 1
$   ac_prsub'ac_prsub_counter'="if (r = 0)"
$   ac_prsub_counter = ac_prsub_counter + 1
$   ac_prsub'ac_prsub_counter'="then"
$   ac_prsub_counter = ac_prsub_counter + 1
$   ac_prsub'ac_prsub_counter'="position(beginning_of (main_buffer));"
$   ac_vpsub_counter = ac_vpsub_counter + 1
$   ac_vpsub'ac_vpsub_counter'= "r := search_quietly(LINE_BEGIN+(""""$1""""+ ((p_0_or_more_spc +""""="""")@r1)+scan(""""""""))@r0+LINE_END,FORWARD);"
$   ac_vpsub_counter = ac_vpsub_counter + 1
$   ac_vpsub'ac_vpsub_counter'="endif;"
$   ac_vpsub_counter = ac_vpsub_counter + 1
$   ac_vpsub'ac_vpsub_counter'="if (r <> 0)"
$   ac_vpsub_counter = ac_vpsub_counter + 1
$   ac_vpsub'ac_vpsub_counter'="then"
$   ac_vpsub_counter = ac_vpsub_counter + 1
$! This is a piece of deep DCL magic.
$   ac_vpsub_support'ac_vpsub_counter'="__ac_vpsub_tmp:='$1'"
$   ac_vpsub'ac_vpsub_counter'="res := """"$1"""" + """"=""""+""""'"+"'__ac_vpsub_tmp'"""";"
$   ac_vpsub_counter = ac_vpsub_counter + 1
$   ac_vpsub'ac_vpsub_counter'="erase(r0);"
$   ac_vpsub_counter = ac_vpsub_counter + 1
$   ac_vpsub'ac_vpsub_counter'="position(r0);"
$   ac_vpsub_counter = ac_vpsub_counter + 1
$   ac_vpsub'ac_vpsub_counter'="copy_text(res);"
$   ac_vpsub_counter = ac_vpsub_counter + 1
$   ac_vpsub'ac_vpsub_counter'="endif;"
$  endif
$!#
$
divert(0)])dnl
dnl
dnl This is only use on VMS so far. It defines more substitutions of
dnl any kind.  This corresponds to the extrasub definition on UNIX.
dnl Two arguments are accepted. $1 is the thing to look for, and $1 is
dnl the thing to put there instead.
dnl divertion 7 is used.
define(AC_INSTALL_extrasub,[divert(7)dnl
ifdef([AC_EXTRASUB_COUNTER],,[define(AC_EXTRASUB_COUNTER,)$ extrasub_counter = 0
])dnl
$ if "''$1'" .nes. ""
$  then
$   extrasub_counter = extrasub_counter + 1
$   extrasub'extrasub_counter'="position(beginning_of (main_buffer));"
$   extrasub_counter = extrasub_counter + 1
$   extrasub'extrasub_counter'= "r := search_quietly(LINE_BEGIN+(""""""""$1""""""""+ ((p_0_or_more_spc +""""""""="""""""")@r1)+(p_0_or_more_spc@r2)+scan(""""""""""""""""))@r0+LINE_END,FORWARD);"
$   extrasub_counter = extrasub_counter + 1
$   extrasub'extrasub_counter'="if (r <> 0)"
$   extrasub_counter = extrasub_counter + 1
$   extrasub'extrasub_counter'="then"
$   extrasub_counter = extrasub_counter + 1
$   extrasub'extrasub_counter'="res := """"""""$1"""""""" + """"""""=""""""""+""""""""''$1'"""""""";"
$   extrasub_counter = extrasub_counter + 1
$   extrasub'extrasub_counter'="erase(r0);"
$   extrasub_counter = extrasub_counter + 1
$   extrasub'extrasub_counter'="position(r0);"
$   extrasub_counter = extrasub_counter + 1
$   extrasub'extrasub_counter'="copy_text(res);"
$   extrasub_counter = extrasub_counter + 1
$   extrasub'extrasub_counter'="endif;"
$  endif
$!#
$
divert(0)])dnl
dnl
dnl This is only on the VMS version so far, and helps in defining extra
dnl switches to be parsed. The following arguments are expected:
dnl  $1 - the presentation in the NOTICE above.
dnl  $2 - the DCL symbol which gets the value.
dnl  $3 - the string describing this switch.
dnl  $4 - the lable name to be used (it will in reality be prepended by A_ and AA_)
dnl  $5 - a description for the usage output.
dnl  $6 - if it is a switch with assignment, a default value, otherwise not defined.
dnl
dnl divertion 4 and 5 are used by this routine.
dnl
define(AC_INSTALL_EXTRA_ARG,[dnl
AC_SUBST($2)dnl
ifdef([AC_EXTRA_ARGS],dnl
[define([AC_EXTRA_ARGS],changequote(,)AC_EXTRA_ARGS [[$1]]changequote([,]))],dnl
[define([AC_EXTRA_ARGS],changequote(,)[[$1]]changequote([,]))])dnl
divert(4)dnl
$ possible_args_'n_possible_args' = "|$3:A_$4:$5"
$ n_possible_args = n_possible_args + 1
ifelse($#,6,[$ $2 = "[$6]"
],[$ $2 := NO
])dnl
divert(5)dnl
ifelse($#,6,[dnl
$[A_]$4:
$ if ac_optarg .eqs. "=" then [ac_prev] := $2
$ if ac_optarg .nes. "=" then $2 = ac_optarg
$ goto ac_arg_loop
],[$[A_]$4:
$ $2 := YES
$ goto ac_arg_loop
])divert(0)dnl
])dnl
dnl
define(AC_PARSEARGS_SUBS,
[$!#
$ goto passed_subroutines
$
$!# This set of subroutines helps with parsing arguments GNU style
$!# 3 Symbols are needed to make these possible:
$!#
$!#   POSSIBLE_ARGS_n := switch_descriptors
$!#	switch_descriptors := switch_descriptor
$!#				| switch_descriptor "|" switch_descriptors
$!#	switch_descriptor := switches ":" lable [ ":" description ]
$!#	switches := switch
$!#			| switch "/" switches
$!#	switch := "-" letter
$!#		| "--" letters [ "*" letters ] [ "=" | "&" ]
$!#	lable := letters
$!#	letters := letter
$!#		| letter letters
$!#	letter := "A".."Z" | "_" | "-"
$!#     description := any chars | "\n"
$!#
$!#   N_POSSIBLE_ARGS := number of POSSIBLE_ARGS_n variables we have.
$!#
$!#   DEFAULT_LABLE	containing the lable to jump to when the next
$!#			argument is not a switch
$!#
$!#   ERROR_LABLE	containing the lable to jump to on error
$!#
$!# examples:
$!#    $ possible_args_0 = "-H/--H*ELP:A_HELP:--help	Gives this help"
$!#    $ possible_args_1 = "-M/--M*ACRODIR=:A_MACRODIR" +-
$!#    "|-V/--V*ERSION:A_VERSION|--:LOOPEND|-:A_KBDINP|-W-&/--WITH-&:A_WITH"
$!#    $ n_possible_args = 2
$!#    $ default_lable := A_NOMORE
$!#    $ error_lable := A_BADSWITCH
$count_args:
$ ac_count = 8
$count_args1:
$ if ac_count .eq. 0 then return
$ if p'ac_count' .nes. "" then return
$ ac_count = ac_count - 1
$ goto count_args1
$
$
$process_arg:
$ ac_label = default_lable
$ ac_optarg = "="
$ _n1 = -1
$process_arg0:
$ _n1 = _n1 + 1
$ if _n1 .ge. n_possible_args then return
$ _i1 = 0
$process_arg1:
$ _e1 = f$element(_i1,"|",possible_args_'_n1')
$ _i1 = _i1 + 1
$ if "''_e1'" .eqs. "|" then goto process_arg0
$ _s = f$element(0,":",_e1)
$ _l = f$element(1,":",_e1)
$ _i2 = 0
$process_arg2:
$ _e2 = f$element(_i2,"/","''_s'")
$ _i2 = _i2 + 1
$ if "''_e2'" .eqs. "/" then goto process_arg1
$ _s1 = f$element(0,"*",_e2)
$ _s2 = f$element(1,"*",_e2)
$ if "''_s2'" .eqs. "*" then _s2 = ""
$ _s3 = f$element(0,"&",_s1 + _s2)
$ _s4 = f$element(1,"&","''_s1'" + "''_s2'")
$ check_amp := true
$ if _s4 .eqs. "&" then check_amp := false
$ if _s4 .eqs. "&" then _s3 = f$element(0,"=",_s1 + _s2)
$ if _s4 .eqs. "&" then _s4 = f$element(1,"=",_s1 + _s2)
$ _p1 = f$element(0,"=",ac_option)
$ _p2 = f$element(1,"=",ac_option)
$ if (.not. check_amp) -
	.and. "''_p1'" .nes. f$extract(0,f$length(_p1),"''_s3'") -
	then goto process_arg2
$ if (check_amp) -
	.and. "''_s3'" .nes. f$extract(0,f$length(_s3),_p1) -
	then goto process_arg2
$ if f$length(_p1) .lt. f$length(_s1) then goto process_arg_err
$ if (_s4 .eqs. "=" .and. _p2 .nes. "=") then goto process_arg_err
$!# if (.not. check_amp) .and. (_p2 .eqs. "=") then gosub shift
$ ac_optarg = _p2
$ if check_amp then ac_package = f$extract(f$length(_s3), 999, _p1)
$ ac_label = _l
$ return
$process_arg_err:
$ ac_label = error_lable
$ return
$
$
$shift:
$ p1 = p2
$ p2 = p3
$ p3 = p4
$ p4 = p5
$ p5 = p6
$ p6 = p7
$ p7 = p8
$ p8 = ""
$ ac_count = ac_count - 1
$ return
$
$ac_usage:
$!# Only options tha might do something get documented
$ ac_w := write 'ac_usage_output'
$ ac_w "Usage: configure [options] [host]"
$ ac_w "Options: [defaults in brackets after descriptions]"
$ac_usage_arg:
$ _n1 = -1
$ac_usage_arg0:
$ _n1 = _n1 + 1
$ if _n1 .ge. n_possible_args then return
$ _i1 = 0
$ac_usage_arg1:
$ _e1 = f$element(_i1,"|",possible_args_'_n1')
$ _i1 = _i1 + 1
$ if "''_e1'" .eqs. "|" then goto ac_usage_arg0
$ _s = f$element(0,":",_e1)
$ _l = f$element(1,":",_e1)
$ _d = f$extract(f$length(_s)+f$length(_l)+2,f$length(_e1),_e1)
$ if _d .nes. ":" .and. _d .nes. "" then ac_w _d
$ goto ac_usage_arg1
$ return
$
$passed_subroutines:
$])dnl
define(AC_PARSEARGS,
[AC_PARSEARGS_SUBS
$
$!# Save the original args to write them into config.status later.
$ configure_args = p1+" "+p2+" "+p3+" "+p4+" "+p5+" "+p6+" "+p7+" "+p8+" "
$
$!# A few defaults
changequote(,)dnl
$ prefix := SYS$SYSDEVICE:[GNU]
$ STARTUPDIR := SYS$COMMON:[SYS$STARTUP]
changequote([,])dnl
$
$!# Initialize some variables set by options.
$!# The variables have the same names as the options, with
$!# dashes changed to underlines.
$ build:=NONE
$ host:=NONE
$ no_create:=NO
$ nonopt:=NONE
$ norecursion:=NO
$! prefix:=
$ exec_prefix:=
$ program_prefix:=
$ program_suffix:=
$ program_transform_name:=
$ silent:=NO
$ srcdir:=
$ target:=NONE
$ verbose:=NO
$ x_includes:=
$ x_libraries:=
$
$ possible_args_0 = "-BUILD=/--B*UILD=:A_BUILD:"+-
"--build=BUILD		configure for building on BUILD [BUILD=HOST]"
$ possible_args_1 = "-DISABLE-&/--DISABLE-&:A_DISABLE:"+-
"--disable-FEATURE	do not include FEATURE (same as --enable-FEATURE=no)"
$ possible_args_2 = "-ENABLE-&=/--ENABLE-&=:A_ENABLE:"+-
"--enable-FEATURE[=ARG]	include FEATURE [ARG=yes]"
$ possible_args_3 = "-EXEC-PREFIX=/-EXEC_PREFIX=/--E*XEC-PREFIX=:A_EXEC_PREFIX:"+-
"--exec-prefix=PREFIX	install host dependent files in PREFIX [/usr/local]"
$ possible_args_4 = "-GAS=/--G*AS:A_GAS"
$ possible_args_5 = "-HELP=/--HE*LP:A_HELP:"+-
"--help			print this message"
$ possible_args_6 = "-HOST=/--HO*ST=:A_HOST:"+-
"--host=HOST		configure for HOST [guessed]"
$ possible_args_7 = "-NFP=/--NF*P:A_NFP"
$ possible_args_8 = "-NO-CREATE=/--NO-C*REATE:A_NO_CREATE"
$ possible_args_9 = "-NORECURSION=/--NOR*ECURSION:A_NORECURSION"
$ possible_args_10 = "-PREFIX/--P*REFIX=:A_PREFIX:"+-
"--prefix=PREFIX		install host independent files in PREFIX [/usr/local]"
$ possible_args_11 = "-PROGRAM-PREFIX/--PROGRAM-P*REFIX=:A_PROGRAM_PREFIX"
$ possible_args_12 = "-PROGRAM-SUFFIX/--PROGRAM-S*UFFIX=:A_PROGRAM_SUFFIX"
$ possible_args_13 = "-PROGRAM-TRANSFORM-NAME/--PROGRAM-T*RANSFORM-NAME=:A_PROGRAM_TRANSFORM_NAME"
$ possible_args_14 = "-Q/-QUIET/-SILENT/--Q*UIET/--SIL*ENT:A_SILENT:"+-
"--quiet, --silent	do not print `checking for...' messages"
$ possible_args_15 = "-SRCDIR=/--S*RCDIR=:A_SRCDIR:"+-
"--srcdir=DIR		find the sources in DIR [configure dir or ..]"
$ possible_args_16 = "-TARGET=/--T*ARGET=:A_HOST:"+-
"--target=TARGET		configure for TARGET [TARGET=HOST]"
$ possible_args_17 = "-V/-VERBOSE/--VERB*OSE:A_VERBOSE:"+-
"--verbose		print results of checks"
$ possible_args_18 = "-VERSION/--VERS*ION:A_VERSION:"+-
"--version		print the version of autoconf that created configure"
$ possible_args_19 = "-WITH-&=/--WITH-&=:A_WITH:"+-
"--with-PACKAGE[=ARG]	use PACKAGE [ARG=yes]"
$ possible_args_20 = "-WITHOUT-&/--WITHOUT-&:A_WITHOUT:"+-
"--without-PACKAGE	do not use PACKAGE (same as --with-PACKAGE=no)"
$ possible_args_21 = "--X:A_X"
$ possible_args_22 = "-X-INCLUDES=/--X-I*NCLUDES=:A_X_INCLUDES:"+-
"--x-includes=DIR	X include files are in DIR"
$ possible_args_23 = "-X-LIBRARIES=/--X-L*IBRARIES=:A_X_LIBRARIES:"+-
"--x-libraries=DIR	X library files are in DIR"
$ n_possible_args = 24
undivert(4)dnl
$ default_lable := A_SKIP
$ error_lable := A_ERROR
$ gosub count_args ! generates AC_COUNT
$ i = 0
$ ac_prev :=
$ goto ac_arg_file_init
$ac_arg_file_err:
$ ac_tmp = f$message($status)
AC_WARN([could not open file 'ac_arg_file_name'])
AC_WARN_CONTINUATION(['ac_tmp'])
$ got ac_arg_file_init
$ac_arg_file_end:
$ close ac_arg_file
$ac_arg_file_init:
$ ac_args_from_file := NO
$ ac_arg_line :=
$ac_arg_loop:
$ if i .ge. ac_count .and. .not. ac_args_from_file then goto ac_arg_loopend
$ if ac_args_from_file then goto ac_arg_file_loop
$ i = i + 1
$ ac_option = p'i'
$ ac_label = ""
$ goto ac_arg_prev
$ac_arg_file_loop:
$ if ac_arg_line .nes. "" then goto ac_arg_file_loop1
$  read/error=ac_arg_file_end/end=ac_arg_file_end ac_arg_file ac_arg_line
$  goto ac_arg_file_loop
$ac_arg_file_loop1:
$ ac_option :=
$ ac_arg_line = f$edit(ac_arg_line,"TRIM")
$ac_arg_file_loop2:
$ if ac_arg_line .eqs. "" then goto ac_arg_file_loop5
$  ac_i1 = f$locate(" ",ac_arg_line)
$ ac_arg_file_loop3:
$  ac_i2 = f$locate("""",ac_arg_line)
$  if ac_i2 .ge. ac_i1 then goto ac_arg_file_loop4
$   ac_option = ac_option + f$extract(0,ac_i2,ac_arg_line)
$   ac_arg_line = f$extract(ac_i2,f$length(ac_arg_line)-ac_i2,ac_arg_line)
$   ac_i1 = ac_i1 - ac_i2
$   ac_i2 = f$locate("""",ac_arg_line)
$   ac_option = ac_option + f$extract(0,ac_i2,ac_arg_line)
$   ac_arg_line = f$extract(ac_i2,f$length(ac_arg_line)-ac_i2,ac_arg_line)
$   ac_i1 = ac_i1 - ac_i2
$   if ac_i1 .lt. ac_i1 then goto ac_arg_file_loop2: ! The space was between quotes
$   goto ac_arg_file_loop3
$ ac_arg_file_loop4:
$  ac_option = ac_option + f$extract(0,ac_i1,ac_arg_line)
$  ac_arg_line = f$extract(ac_i1,f$length(ac_arg_line)-ac_i1,ac_arg_line)
$ac_arg_file_loop5:
$ ! This should make sure the argument is treated the same way as a command
$ ! line argument.
$ ac_option := 'ac_option'
$
$ac_arg_prev:
$!# If the previous option needs an argument, assign it
$ if ac_prev .eqs. "" then goto ac_arg_no_prev
$  'ac_prev' = ac_option
$  ac_prev = ""
$  goto ac_arg_loop
$
$ac_arg_no_prev:
$ if f$extract(0,1,ac_option) .nes. "+" then goto ac_arg_loop1
$ ac_arg_file_name = f$extract(1,999,ac_option)
$ open/read/error=ac_arg_file_err ac_arg_file 'ac_arg_file_name'
$ ac_args_from_file := YES
$ goto ac_arg_loop
$
$ac_arg_loop1:
$ gosub process_arg ! generates AC_LABEL and AC_OPTION
$ goto 'ac_label'
undivert(5)dnl
$A_BUILD:
$A_EXEC_PREFIX:
$A_HOST:
$A_PREFIX:
$A_PROGRAM_PREFIX:
$A_PROGRAM_SUFFIX:
$A_PROGRAM_TRANSFORM_NAME:
$A_SRCDIR:
$A_TARGET:
$A_X_INCLUDES:
$A_X_LIBRARIES:
$ ac_varname = ac_label - "A_"
$ if ac_optarg .eqs. "=" then ac_prev := 'ac_varname'
$ if ac_optarg .nes. "=" then 'ac_varname' = ac_optarg
$ goto ac_arg_loop
$A_NO_CREATE:
$A_NORECURSION:
$A_SILENT:
$A_VERBOSE:
$ ac_varname = ac_label - "A_"
$ 'ac_varname' := YES
$ goto ac_arg_loop
$A_GAS:
$A_X:
$ ac_varname = ac_label - "A_"
$ with_'ac_varname' := YES
$ goto ac_arg_loop
$A_NFP:
$ with_fp := NO
$ goto ac_arg_loop
$A_ENABLE:
$A_DISABLE:
$ ac_name = ac_package
$ gosub A_check_name
$ if ac_check then goto ac_process_feature
AC_ERROR('ac_package': invalid feature name)
$ goto ac_arg_loop
$ac_process_feature:
$ if ac_optarg .eqs. "=" then ac_optarg := YES
$ if ac_label .eqs. "A_DISABLE" then ac_optarg := NO
$ enable_'ac_name' = ac_optarg
$ goto ac_arg_loop
$A_WITH:
$A_WITHOUT:
$ ac_name = ac_package
$ gosub A_check_name
$ if ac_check then goto ac_process_package
AC_ERROR('ac_package': invalid package name)
$ goto ac_arg_loop
$ac_process_package:
$ if ac_optarg .eqs. "=" then ac_optarg := YES
$ if ac_label .eqs. "A_WITHOUT" then ac_optarg := NO
$ with_'ac_name' = ac_optarg
$ goto ac_arg_loop
$A_HELP:
$ ac_usage_output := sys$output
$ gosub ac_usage
$ exit
$A_VERSION:
$ write sys$output "configure generated by autoconf version AC_ACVERSION"
$ exit
$A_SKIP:
$ if f$extract(0,1,ac_option) .eqs. "-" then goto A_ERROR
$ ac_name = f$edit(ac_option,"LOWERCASE")
$ gosub A_check_name_no_convert
$ if ac_check then goto A_SKIP1
AC_WARN('ac_option': invalid host type)
$A_SKIP1:
$ if nonopt .eqs. "NONE" then goto A_SKIP2
AC_ERROR(can only configure for one host and one target at a time)
$A_SKIP2:
$ nonopt = ac_option
$ goto ac_arg_loop
$A_ERROR:
AC_ERROR(['ac_option': invalid option; use --help to show usage])
$ goto ac_arg_loop
$
$A_check_name:
$ ac_convert := yes
$ goto A_check_name1
$A_check_name_no_convert:
$ ac_convert := no
$A_check_name1:
$ ac_p = f$length(ac_name)
$ ac_check := YES
$ac_loop_name:
$ ac_p = ac_p - 1
$ if ac_p .eq. -1 then goto ac_loop_name_end
$ ac_e = f$extract(ac_p,1,ac_name)
$ if ac_e .eqs. "-" .and. ac_convert then -
	ac_name[ac_p*8,8] = 95 ! an underscore
$ if ac_e .eqs. "-" .or. ac_e .eqs. "_" -
     .or. (ac_e .ges. "a" .and. ac_e .les. "z") -
     .or. (ac_e .ges. "A" .and. ac_e .les. "A") -
     .or. (ac_e .ges. "0" .and. ac_e .les. "9") then goto ac_loop_name
$ ac_check := NO
$ac_loop_name_end:
$ return
$ac_arg_loopend:
$ if ac_prev .eqs. "" then goto ac_arg_end
$
$ ac_p = f$length(ac_prev)
$ac_arg_loopend1:
$ ac_p = ac_p - 1
$ if ac_p .eq. -1 then goto ac_arg_loopend2
$ ac_e = f$extract(ac_p,1,ac_prev)
$ if ac_e .eqs. "_" then ac_prev[ac_p*8,8] = 45 ! a dash
$ goto ac_arg_loopend1
$ac_arg_loopend2:
AC_ERROR(missing argument to --'ac_prev')
$ac_arg_end:
$])dnl
dnl
define(AC_INIT,
[AC_NOTICE
AC_PARSEARGS
AC_PREPARE($1)])dnl
dnl
define(AC_PREPARE,
[$ ac_DCL_message = f$environment("MESSAGE")
$ ac_DCL_verify = f$verify(0)
$ ! 'f$verify(ac_DCL_verify)
$ ac_DCL_original_directory = f$trnlnm("SYS$DISK")+f$directory()
$ on warning then continue
$ on error then goto ac_bail_out
$ on severe_error then goto ac_bail_out
$ on control_y then goto ac_bail_out
$ goto ac_passed_error_routines
$ac_bail_out:
$ set default 'ac_DCL_original_directory'
$ set message 'ac_DCL_message'
VMS_DELTREE([conftest*.*])
VMS_DELTREE([confdefs*.*])
$ exit 1 + 0 * f$verify(ac_DCL_verify)
$ac_passed_error_routines:
$
$!# Save the original args if we used an alternate arg parser.
$ if f$type(configure_args) .nes. "" then ac_configure_args = configure_args
$ if f$type(configure_args) .eqs. "" then -
	ac_configure_args = p1+" "+p2+" "+p3+" "+p4+" "+p5+" "+p6+" "+p7+" "+p8
$!# Strip out --no-create and --norecursion so they don't pile up.
$ configure_args = configure_args-" --NO-CREATE"-"--NO-CREATE "-"--NO-CREATE"
$ configure_args = configure_args-" --NORECURSION"-"--NORECURSION "-"--NORECURSION"
$
$ goto ac_prepare_after_subs
$ac_prepare_compile_params:
$ __cflags = ""
$ if f$type(CFLAGS) .nes. "" then __cflags = CFLAGS
$ __defs = ""
$ if f$type(DEFS) .nes. "" then __defs = "/defin=("+DEFS+")"
$ if f$type(ac_flags) .nes. "" then __cflags = __cflags + ac_flags
$ __incs = ""
$ if f$type(INCS) .nes. "" then __incs = "/include=("+INCS+")"
$ __compiler := cc
$ if f$type(ac_cc) .nes. "" then __compiler := 'ac_cc'
$ if f$type(CC) .nes. "" then __compiler := 'CC'
$ __preprocessor := cc '__cflags'/preprocess=
$ if f$type(ac_cpp) .nes. "" then __preprocessor := 'ac_cpp'
$ if f$type(CPP) .nes. "" then __preprocessor := 'CPP'
$ __extension := c
$ if f$type(ac_ext) .nes. "" then __extension = ac_ext
$ return
$ac_prepare_preprocess:
$ gosub ac_prepare_compile_params
$! '__preprocessor' CONFTEST.OUT '__defs' '__incs' conftest.'__extension'
$ '__preprocessor' CONFTEST.OUT conftest.'__extension'
$ ac_severity = $severity
$ return
$ac_prepare_compile:
$ gosub ac_prepare_compile_params
$ '__compiler' '__cflags' /object=conftest.obj '__defs' '__incs' conftest.'__extension'
$ ac_severity = $severity
$ return
$ac_prepare_link:
$ open/write link_opt conftest.opt
$ libi = 0
$ if f$type(LIBS) .eqs. "" then libs = ""
$ac_prepare_link_loop:
$ lib1 = f$element(libi," ",libs)
$ libi = libi + 1
$ if lib1 .nes. " "
$  then
$   if lib1 .nes. "" then write link_opt lib1
$   goto ac_prepare_link_loop
$  endif
$ close link_opt
$ libc = ","
$ if "''OPTS'" .eqs. "" then libc = ""
$ link 'ldflags' conftest.obj,conftest.opt/opt 'libc' 'OPTS'
$ ac_severity = $severity
$ return
$ac_prepare_after_subs:
$
$ ldflags := /nouserlibrary
AC_SUBST(LDFLAGS)dnl
$ ac_preprocess := gosub ac_prepare_preprocess
$ ac_compile := gosub ac_prepare_compile
$ ac_link := gosub ac_prepare_link
$
VMS_DELTREE([conftest*.*])
$ if f$search("CONFDEFS.H.*") .nes. "" then delete/nolog confdefs.h.*
$
$ open/write foo confdefs.h
$ close foo
$
changequote({,})dnl
$!# A filename unique to this package, relative to the directory that
$!# configure is in, which we can look for to find out if srcdir is correct.
$ ac_unique_file:=$1
$
$!# Find the source files, if location was not specified.
$ if "''srcdir'" .nes. "" then goto ac_prepare_srcdir_try
$  ac_srcdirdefaulted := yes
$!# Try the directory containing this script, then `..'.
$  ac_prog=f$environment("PROCEDURE")
$  _dummy = "''prog'" ! This is prog, for debugging
$  ac_confdir=f$parse(ac_prog,,,"NODE") + f$parse(ac_prog,,,"DEVICE") + f$parse(ac_prog,,,"DIRECTORY")
$  _dummy = "''ac_confdir'" ! This is confdir, for debugging
$  if ac_confdir .eqs. f$environment("DEFAULT") then ac_confdir := []
$  srcdir=ac_confdir
$  if f$search(srcdir+ac_unique_file) .eqs. "" then srcdir := [-]
$ac_prepare_srcdir_try:
$ if f$search(srcdir+ac_unique_file) .nes. "" then goto ac_prepare_srcdir2
changequote([,])dnl
$ if "''ac_srcdirdefaulted'" then -
  AC_ERROR(can not find sources in `'ac_confdir'' or `[[-]]'.)
$ if .not. "''ac_srcdirdefaulted'" then -
  AC_ERROR(can not find sources in `'srcdir''.)
$ exit 0
$ac_prepare_srcdir2:
$!# The following are quite usefull
changequote(,)dnl
$ if srcdir .eqs. "[-]" .or. srcdir .eqs. "[]"
$  then
$   srcdir_dev:=
$   srcdir_dir = srcdir - "[" - "]"
$  else
$   srcdir_dir = f$parse(srcdir,,,"DIRECTORY") - "[" - "]" - "<" - ">"
$   srcdir_dev = f$parse(srcdir,,,"DEVICE")
$  endif
changequote([,])dnl
AC_LANG_C
$])dnl
dnl
define(AC_ENABLE,
[[$!#] check whether --enable-$1 was given
$ enableval="''[enable_]patsubst($1,-,_)'"
$ if enableval .nes. ""
$  then
$   ifelse([$2], ,!, [$2])
ifelse([$3], , , [$  else
$   $3
$])dnl
$  endif
$])dnl
dnl
dnl Giving --with an argument is deprecated.
define(AC_WITH,
[[$!#] check whether --with-$1 or --without-$1 was given
$ withval="''[with_]patsubst($1,-,_)'"
$ if withval .nes. ""
$  then
$   ifelse([$2], ,!, [$2])
ifelse([$3], , , [$  else
$   $3
$])dnl
$  endif
$])dnl
dnl
dnl Guess the value for the `prefix' variable by looking for
dnl the argument program along PATH and taking its parent.
dnl Example: if the argument is `gcc' and we find /usr/local/gnu/bin/gcc,
dnl set `prefix' to /usr/local/gnu.
dnl Unfortunatelly, on VMS, this is not possible.
define(AC_PREFIX,
[$ if "''prefix'" .nes. "" then goto ac_prefix_after
AC_ERROR(On VMS, the configuration needs a prefix directory)
$ exit 0
$ac_prefix_after:
$!# Set default prefixes.
$ if "''prefix'" .nes. "" .and. "''exec_prefix'" .eqs. "" then exec_prefix=prefix
changequote(,)dnl
$ if "''prefix'" .nes. ""
$  then
$   prefix_dir = f$parse(prefix,,,"DIRECTORY") - "[" - "]" - "<" - ">"
$   prefix_dev = f$parse(prefix,,,"DEVICE")
$  endif
$ if "''exec_prefix'" .nes. ""
$  then
$   exec_prefix := 'exec_prefix'
$   exec_prefix_dir = f$parse(exec_prefix,,,"DIRECTORY") - "[" - "]" - "<" - ">"
$   exec_prefix_dev = f$parse(exec_prefix,,,"DEVICE")
$  endif
changequote([,])dnl
$])dnl
dnl
define(AC_CONFIG_HEADER, [$ define(AC_CONFIG_NAMES, [[$1]])])dnl
dnl
define(AC_DOREV, [$! From [CONFIGURE.COM_IN] $1
$])dnl
define(AC_REVISION, [AC_DOREV(translit($1,$"))])dnl
dnl
dnl Subroutines of AC_PREREQ.
dnl
dnl Change the dots in version number $1 into commas.
define(AC_PREREQ_SPLIT, [translit($1,.,[,])])dnl
dnl
dnl Default the ternary version number to 0 (e.g., 1,7 -> 1,7,0).
define(AC_PREREQ_CANON, [$1,$2,ifelse([$3],,0,[$3])])dnl
dnl
dnl Complain and exit if the version number in $1 through $3 is less than
dnl the version number in $4 through $6.
dnl $7 is the printable version of the second version number.
define(AC_PREREQ_COMPARE,
[ifelse(builtin([eval],
[$3 + $2 * 100 + $1 * 10000 < $6 + $5 * 100 + $4 * 10000]),1,
[errprint(Autoconf version $7 or higher is required
)m4exit(3)])])dnl
dnl
dnl Complain and exit if the Autoconf version is less than $1.
define(AC_PREREQ,
[AC_PREREQ_COMPARE(AC_PREREQ_CANON(AC_PREREQ_SPLIT(AC_ACVERSION)),
AC_PREREQ_CANON(AC_PREREQ_SPLIT([$1])),[$1])])dnl
dnl
dnl
dnl Setting variables
dnl
dnl
dnl Several simple subroutines to do various flavors of quoting.
dnl
dnl Quote $1 against DCL "s.
define([AC_QUOTE_DQUOTE], [dnl We use \1 instead of \& to avoid an m4 1.0.3 bug.
patsubst([[$1]], ", "")])dnl
define([AC_QUOTE_DQUOTE2], [dnl We use \1 instead of \& to avoid an m4 1.0.3 bug.
patsubst([[$1]], '', '"+"')])dnl
dnl
dnl Quote $1 against DCL 's.
define(AC_QUOTE_SQUOTE, [dnl
patsubst([[$1]], changequote(,)\([^']\)\('[$_A-Za-z0-9]+\)changequote([,]), \1'\2)])dnl
dnl
dnl Quote $1 against shell here documents (<<EOF).
define(AC_QUOTE_HERE, [changequote({,})dnl
dnl We use \1 instead of \& to avoid an m4 1.0.3 bug.
patsubst(patsubst([$1], \(\\[$`\\]\), \\\1), \([$`]\), \\\1){}dnl
changequote([,])])dnl
dnl
dnl Quote $1 against the right hand side of a sed substitution.
define(AC_QUOTE_SED, [changequote({,})dnl
dnl We use \1 instead of \& to avoid an m4 1.0.3 bug.
dnl % and @ and ! are commonly used as the sed s separator character.
patsubst([$1], \([&\\%@!]\), \\\1){}dnl
changequote([,])])dnl
dnl
dnl Quote $1 against tokenization.
define(AC_QUOTE_TOKEN, [changequote({,})dnl
patsubst([$1], \([	 ]\), \\\1){}dnl
changequote([,])])dnl
dnl
dnl Subroutine of AC_DEFINE.  Does more quoting magic than any sane person
dnl should be able to understand.  The point of it all is that what goes into
dnl Makefile et al should be verbatim what was written in configure.com_in.
define(AC_DEFINE_QUOTE, [dnl
AC_QUOTE_SQUOTE(AC_QUOTE_DQUOTE([$1]))])dnl
dnl
define(AC_DEFINE_SEDQUOTE, [dnl
AC_QUOTE_DQUOTE(AC_QUOTE_HERE(AC_QUOTE_HERE(AC_QUOTE_SED([$1]))))])dnl
dnl
define(AC_DEFINE_TPUQUOTE, [AC_QUOTE_DQUOTE([$1])])dnl
dnl
dnl Don't compare $2 to a blank, so we can support "-Dfoo=".
dnl If creating a configuration header file, we add
dnl commands to ac_sed_defs to define the variable.  ac_[due][ABCD]
dnl get defined in config.status.  Here we just insert the
dnl variable parts of the string: the variable name to define
dnl and the value to give it.
dnl The newlines around the curly braces prevent sh syntax errors.
define(AC_DEFINED_P,[f$type(_ac_is_defined_$1).nes.""])dnl
define(AC_DEFINE,[$!#
dnl Uniformly use AC_DEFINE_[SED]QUOTE, so callers of AC_DEFINE_UNQUOTED
dnl can use AC_QUOTE_* manually if they want to.
$ _ac_is_defined_$1 = 1
$ if f$type(DEFS_COUNTER) .eqs. "" then DEFS_COUNTER = 0
$ if f$type(DEFS) .nes. "" then DEFS = DEFS + ","
$ if f$type(DEFS) .eqs. "" then DEFS:=
$ DEFS_COUNTER = DEFS_COUNTER + 1
$ if "''verbose'" then write sys$output -
ifelse($#, 2, 
[define([AC_VAL], [[$2]])dnl
"	defining AC_DEFINE_QUOTE([$1]) to be ifelse(AC_VAL,, dnl
empty, [AC_DEFINE_QUOTE(AC_VAL)])"],
[define([AC_VAL], 1)dnl
"	defining AC_DEFINE_QUOTE([$1])"])
$ open/append ac_define_file confdefs.h
$ write ac_define_file "[#][define] AC_DEFINE_QUOTE([$1]) AC_DEFINE_QUOTE(AC_VAL)"
$ close ac_define_file
dnl Defines DEFS even if AC_CONFIG_NAMES for use in user case statements.
$ DEFS'DEFS_COUNTER' = """AC_DEFINE_QUOTE([$1])""=""AC_DEFINE_QUOTE(AC_VAL)"""
$! actually, no --ttn
$! DEFS = DEFS + DEFS'DEFS_COUNTER'
ifdef([AC_CONFIG_NAMES],
[$ if "''ac_sed_defs_COUNTER'" .eqs. "" then ac_sed_defs_COUNTER = 0
$ ac_sed_defs_COUNTER = ac_sed_defs_COUNTER + 1
$ ac_sed_defs'ac_sed_defs_COUNTER' = -
	"ac_d(""AC_DEFINE_QUOTE([$1])"",""AC_DEFINE_QUOTE(AC_DEFINE_QUOTE(AC_VAL))"");"
$ ac_sed_defs_COUNTER = ac_sed_defs_COUNTER + 1
$ ac_sed_defs'ac_sed_defs_COUNTER' = -
	"ac_u(""AC_DEFINE_QUOTE([$1])"",""AC_DEFINE_QUOTE(AC_DEFINE_QUOTE(AC_VAL))"");"
$ ac_sed_defs_COUNTER = ac_sed_defs_COUNTER + 1
$ ac_sed_defs'ac_sed_defs_COUNTER' = -
	"ac_e(""AC_DEFINE_QUOTE([$1])"",""AC_DEFINE_QUOTE(AC_DEFINE_QUOTE(AC_VAL))"");"
])$])dnl
dnl
dnl Unsafe version of AC_DEFINE.
dnl Users are responsible for the quoting nightmare.
dnl Well, not all of it.  We need to pull the identify function out to
dnl the top level, because m4 doesn't really support nested functions;
dnl it doesn't distinguish between the arguments to the outer
dnl function, which should be expanded, and the arguments to the inner
dnl function, which shouldn't yet.
define(AC_IDENTITY,[[$1]])dnl
define(AC_DEFINE_UNQUOTED,[dnl
pushdef([AC_QUOTE_SQUOTE],defn([AC_IDENTITY]))dnl
pushdef([AC_DEFINE_SEDQUOTE],defn([AC_IDENTITY]))dnl
AC_DEFINE($1,[$2])dnl
popdef([AC_DEFINE_SEDQUOTE])dnl
popdef([AC_QUOTE_SQUOTE])dnl
])dnl
dnl
dnl Protects the argument from being diverted twice
dnl if this macro is called twice for it.
dnl Diversion 0 is the normal output.
dnl Diversion 1 is sed substitutions for output files. TPU subst on VMS
dnl Diversion 2 is variable assignments for config.status.
define(AC_SUBST,
[ifdef([AC_SUBST_$1], ,
[define([AC_SUBST_$1], )dnl
divert(1)dnl
dnl UNIX s%@$1@%[$]$1%g
dnl This is a piece of very deep DCL magic.  Look in CONFIG.STATUS if
dnl you want to see it in action.  This is really a way to do recursive
dnl values of symbols!  It can be done to as many levels of indirection
dnl as you wish.
$ write config_status_file "$ __config_status_tmp := '$1'"
$ write config_status_file "$ write config_status_tpu ""TPU_substitute(""""@""""+""""$1""""+""""@"""","""""",__config_status_tmp,"""""");""" ! Experimental
divert(2)dnl
dnl UNIX $1='[$]$1'
$ write config_status_file "$ $1=""''$1'""" ! Experimental
divert(3)dnl
dnl We need to instansiate the variables, otherwise, changes made to another
dnl variable might change the meaning of this one...
$ write config_status_file "$ $1 := '$1'"
divert(0)dnl
])])dnl
dnl
dnl
dnl Printing messages
dnl
dnl
define(AC_CHECKING,
[__AC_CHECKING("AC_DEFINE_QUOTE([$1])")])dnl
dnl
define(__AC_CHECKING,
[$ if .not. silent then write sys$output "checking ",$1])dnl
dnl
define(AC_VERBOSE,
[__AC_VERBOSE("AC_DEFINE_QUOTE([$1])")])dnl
dnl
define(__AC_VERBOSE,
[$ if verbose then write sys$output "	",$1])dnl
dnl
define(AC_WARN,
[__AC_WARN("AC_DEFINE_QUOTE([$1])")])dnl
dnl
define(__AC_WARN,
[$ write sys$error "configure: warning: ",$1])dnl
dnl
define(AC_WARN_CONTINUATION,
[__AC_WARN_CONTINUATION("AC_DEFINE_QUOTE([$1])")])dnl
dnl
define(__AC_WARN_CONTINUATION,
[$ write sys$error "configure:          ",$1])dnl
dnl
define(AC_ERROR,
[__AC_ERROR("AC_DEFINE_QUOTE([$1])")])dnl
define(__AC_ERROR,
[$ write sys$error "configure: ",$1
$ exit 2])dnl
dnl
dnl
dnl Selecting which language to use for testing
dnl
dnl
define(AC_LANG_CLEANUP_CPP,
[$
$ _tmp = f$element(0," ",ac_cpp_cmd)
$ if _tmp .nes. "" then -
	ac_cpp_switch = f$extract(f$length(ac_cpp_cmd),999,ac_cpp_cmd) + " " + ac_cpp_switch
$ if _tmp .nes. "" then ac_cpp_cmd = _tmp
$ _tmp = f$element(0,"/",ac_cpp_cmd)
$ if _tmp .nes. "" then -
	ac_cpp_switch = f$extract(f$length(ac_cpp_cmd),999,ac_cpp_cmd) + " " + ac_cpp_switch
$ if _tmp .nes. "" then ac_cpp_cmd = _tmp
$])dnl
dnl
define(AC_LANG_C,
[define([AC_LANG],[C])AC_PROVIDE([$0])dnl
$ ac_cc := cc
$ if "''CC'" .nes. "" then ac_cc = CC
$ ac_ext:=c
dnl $ ac_cpp_cmd := cc
dnl $ ac_cpp_switch = CFLAGS+"/preprocess="
$ ac_cpp := 'ac_cc' 'CFLAGS' /preprocess=
dnl $ if "''CPP'" .nes. "" then ac_cpp_cmd = CPP
dnl $ if "''CPP'" .nes. "" then ac_cpp_switch :=
$ if "''CPP'" .nes. "" then ac_cpp = CPP
dnl AC_LANG_CLEANUP_CPP
$])dnl
dnl
define(AC_LANG_CPLUSPLUS,
[define([AC_LANG],[CPLUSPLUS])AC_PROVIDE([$0])dnl
$ ac_cc := cxx
$ if "''CXX'" .nes. "" then ac_cc = CXX
$ ac_ext:=cc
$!# CXXFLAGS is not in ac_cpp because -g, -O, etc. are not valid cpp options.
dnl $ ac_cpp_cmd := cxx
dnl $ ac_cpp_switch = "/preprocess="
$ ac_cpp := 'ac_cc' 'CFLAGS' /preprocess=
dnl $ if "''CXXCPP'" .nes. "" then ac_cpp_cmd = CXXCPP
dnl $ if "''CXXCPP'" .nes. "" then ac_cpp_switch :=
$ if "''CXXCPP'" .nes. "" then ac_cpp = CXXCPP
dnl AC_LANG_CLEANUP_CPP
$])dnl
dnl
dnl Push the current language on a stack.
define(AC_LANG_SAVE, [pushdef([AC_LANG_STACK], AC_LANG)])dnl
dnl
dnl Restore the current language from the stack.
define(AC_LANG_RESTORE,
[ifelse(AC_LANG_STACK,C,[ifelse(AC_LANG,C,,[AC_LANG_C])],[ifelse(AC_LANG,CPLUSPLUS,,[AC_LANG_CPLUSPLUS])])[]popdef([AC_LANG_STACK])])dnl
dnl
dnl
dnl Enforcing ordering constraints
dnl
dnl
define(AC_BEFORE,
[ifdef([AC_PROVIDE_$2], [errprint(__file__:__line__: [$2 was called before $1
])])])dnl
dnl
define(AC_REQUIRE,
[ifdef([AC_PROVIDE_$1],,[indir([$1])
])])dnl
dnl
define(AC_PROVIDE,
[define([AC_PROVIDE_$1],)])dnl
dnl
define(AC_OBSOLETE,
[errprint(__file__:__line__: warning: [$1] is obsolete[$2]
)])dnl
dnl
dnl
dnl Checking for kinds of features
dnl
dnl
define(AC_PROGRAM_CHECK,
[$ if "''$1'" .eqs. ""
$  then ! We are taking a risk here, because we are really trying to start
$	! the program. I hope we don't get caught by this.
$   set noon
AC_MAYBE_SILENT(dnl
[$   !# Gasp...
$   ac_dummy = "AC_DEFINE_QUOTE([$2])"
AC_CHECKING([for 'ac_dummy'])
$   ac_dummy
$   ac_status = $status])   
$   set on
$   if ac_status .ne. %X038090 ! This is the code for an unknown verb
$    then
$     $1 = "AC_DEFINE_QUOTE([$3])"
$    endif
$  endif
ifelse([$4],,, [$ if "''$1'" .eqs. "" then $1="AC_DEFINE_QUOTE([$4])"
])dnl
$ if "''$1'" .nes. "" then AC_VERBOSE(	setting $1 to '$1')
AC_SUBST($1)dnl
$])dnl
dnl
define(AC_PROGRAMS_CHECK,
[AC_DEFINE_VMS_LABLE(ac_pc1,ac_pc)dnl
$ ac_prgs = "$2"
$ ac_i = 0
[$]AC_USE_VMS_LABLE(ac_pc1):
$  ac_prog = f$element(ac_i," ",ac_prgs)
$  ac_i = ac_i + 1
$  if ac_prog .nes. " "
$   then
AC_PROGRAM_CHECK($1, 'ac_prog', 'ac_prog', )
$    if "''$1'" .eqs. "" then goto AC_USE_VMS_LABLE(ac_pc1)
$   endif
ifelse([$3],,, [$ if "''$1'" .eqs. "" then $1="$3"
])$])dnl
dnl
define(AC_PROGRAM_PATH,
[$ if "''$1'" .eqs. ""
$  then ! We are taking a risk here, because we are really trying to start
$	! the program. I hope we don't get caught by this.
$   set noon
AC_MAYBE_SILENT(dnl
[$   !# Gasp...
$   ac_dummy = "$2"
AC_CHECKING([for 'ac_dummy'])
$   ac_dummy
$   ac_status = $status])   
$   set on
$   if ac_status .ne. %X038090 ! This is the code for an unknown verb
$    then
$     $1 = "$2"
$    endif
$  endif
ifelse([$3],,, [$ if "''$1'" .eqs. "" then $1="$3"
])dnl
$ if "''$1'" .nes. "" then AC_VERBOSE(	setting $1 to '$1')
AC_SUBST($1)dnl
$])dnl
dnl
define(AC_PROGRAMS_PATH,
[AC_DEFINE_VMS_LABLE(ac_pp1,ac_pp)dnl
$ ac_prgs = "$2"
$ ac_i = 0
[$]AC_USE_VMS_LABLE(ac_pp1):
$  ac_prog = f$element(ac_i," ",ac_prgs)
$  ac_i = ac_i + 1
$  if ac_prog .nes. " "
$   then
AC_PROGRAM_PATH($1, 'ac_prog')
$    if "''$1'" .eqs. "" then goto AC_USE_VMS_LABLE(ac_pp1)
$   endif
ifelse([$3],,, [$ if "''$1'" .eqs. "" then $1="$3"
])$])dnl
dnl
define(AC_HEADER_EGREP,
[AC_REQUIRE_CPP()AC_PROVIDE([$0])dnl
$ open/write conftest_FILE conftest.'ac_ext'
$ write conftest_FILE "#include ""confdefs.h"""
$ write conftest_FILE "[#]include <AC_DEFINE_QUOTE([$2])>"
$ close conftest_FILE
$ set noon
$!# def/user sys$error nla0:
$!# def/user sys$output nla0:
$ ac_preprocess
AC_MAYBE_SILENT(dnl
[$ search/out=nla0: conftest.out "AC_QUOTE_DQUOTE([$1])"
$ ac_severity = $severity])
$ set on
$ if ac_severity .eq. 1
$  then
ifelse([$3],,[$!],[$ delete/nolog conftest*.*.*
$3])
ifelse([$4],,,[$  else
$ delete/nolog conftest*.*.*
$4
])dnl
$  endif
$ dummy = f$search("foo.bar.1") ! To prevent f$search bug.
$ if f$search("CONFTEST*.*.*") .nes. "" then delete/nolog conftest*.*.*
$])dnl
dnl
dnl Because this macro is used by AC_GCC_TRADITIONAL, which must come early,
dnl it is not included in AC_BEFORE checks.
define(AC_PROGRAM_EGREP,
[AC_REQUIRE_CPP()AC_PROVIDE([$0])dnl
$ open/write conftest_file conftest.'ac_ext'
$ write conftest_file "#include ""confdefs.h"""
VMS_SPLIT_LINES([$ write conftest_file "], AC_QUOTE_DQUOTE([$2]), ")
$ close conftest_file
$ set noon
$!# def/user sys$error nla0:
$!# def/user sys$output nla0:
AC_MAYBE_SILENT(dnl
[$ ac_preprocess
$ search/out=nla0: conftest.out "AC_QUOTE_DQUOTE([$1])"
$ ac_status = $status])
$ set on
$ if ac_status .eq. 1
$  then
ifelse([$3],,[$!],[$ delete/nolog conftest*.*.*
$3])
ifelse([$4],,,[$  else
$ delete/nolog conftest*.*.*
$4
])dnl
$  endif
$ dummy = f$search("foo.bar.1") ! To prevent f$search bug.
$ if f$search("CONFTEST*.*.*") .nes. "" then delete/nolog conftest*.*.*
$])dnl
dnl
define(AC_HEADER_CHECK,
[AC_CHECKING(for $1)
ifelse([$3], , [AC_TEST_CPP([#include <]AC_QUOTE_SQUOTE([$1])[>
], [$2])],
[AC_TEST_CPP([#include <]AC_QUOTE_SQUOTE([$1])[>
], [$2], [$3])])
$])dnl
dnl
define(AC_COMPILE_CHECK,
[AC_PROVIDE([$0])dnl
ifelse([$1], , , [AC_CHECKING([for $1])
])dnl
$ open/write conftest_file conftest.'ac_ext'
$ write conftest_file "#include ""confdefs.h"""
ifelse([$2], , , [VMS_SPLIT_LINES([$ write conftest_file "], AC_QUOTE_DQUOTE([$2]), ["])
])dnl
VMS_SPLIT_LINES([$ write conftest_file "], 
AC_DEFINE_QUOTE([int main() { return 1; }
int t() { $3; return 0; }]), ["])
$ close conftest_file
$ _ac_cc_flag = "NO"
$!# def/user sys$error nla0:
$!# def/user sys$output nla0:
$ set noon
AC_MAYBE_SILENT([$ ac_compile])
$ if f$search("conftest.obj") .nes. ""
$  then
AC_MAYBE_SILENT(dnl
[$   ac_link])
$   if ac_severity .eq. 1
$    then
$     _ac_cc_flag = "YES"
$    endif
$  endif
$ set on
$ if _ac_cc_flag
$  then
ifelse([$4], , [$!],[$ delete/nolog conftest*.*.*
$4])
ifelse([$5], , , [$  else
$ delete/nolog conftest*.*.*
$5
])dnl
$  endif
$ dummy = f$search("foo.bar.1") ! To prevent f$search bug.
$ if f$search("CONFTEST*.*.*") .nes. "" then delete/nolog conftest*.*.*
$])dnl
dnl
dnl AC_TEST_PROGRAM might test VMSified as well as UNIXified programs.
dnl The problem is that VMS programs return 1 for success, while
dnl UNIX programs return 0.  I still do not know the best solution
dnl for this problem, but I've tried.  The option I give here is
dnl to specify which mode should be used, with the 2 following
dnl macros.
dnl
dnl didn't work well..... It's easier to convert some code to return 2
dnl for failure...
dnl
dnl define(_AC_TEST_PROGRAM_SUCCESS_CODE,1)dnl We DO run this on VMS, usually
dnl define(AC_TEST_PROGRAM_VMS,[define([_AC_TEST_PROGRAM_SUCCESS_CODE],1)])dnl
dnl define(AC_TEST_PROGRAM_UNIX,[define([_AC_TEST_PROGRAM_SUCCESS_CODE],0)])dnl
define(AC_TEST_PROGRAM,
[AC_PROVIDE([$0])ifelse([$4], , , [AC_REQUIRE([AC_CROSS_CHECK])$ if "''cross_compiling'" .nes. ""
$  then
$4
$  else
])dnl
$   open/write conftest_file conftest.'ac_ext'
$   write conftest_file "#include ""confdefs.h"""
VMS_SPLIT_LINES([$   write conftest_file "], AC_QUOTE_DQUOTE([$1]), ["])
AC_DEFINE_VMS_LABLE(ac_tp_fail,ac_tp)dnl
$   close conftest_file
AC_TEST_FILED_PROGRAM(conftest.'ac_ext',[$2],[$3],[$4])
$])dnl
define(AC_TEST_FILED_PROGRAM,
[$   ac_file_name := $1
$   ac_default_name := conftest.'ac_ext'
$   if ac_file_name .nes. ac_default_name then copy 'ac_file_name 'ac_default_name
$   set noon
$   _tmp = -1 ! Because DCL can't jump into the middle of an IF stmt
AC_MAYBE_SILENT([$   ac_compile])
$   if f$search("conftest.obj") .eqs. "" then goto AC_USE_VMS_LABLE(ac_tp_fail)
AC_MAYBE_SILENT([$   ac_link])
$   if ac_severity .ne. 1 then goto AC_USE_VMS_LABLE(ac_tp_fail)
AC_MAYBE_SILENT([$   run conftest
$   ac_status = $status])
$   set on
$ AC_USE_VMS_LABLE(ac_tp_fail):
$   if ac_status .eq. 1 .or. ac_status .eq. 0 ! UNIXoid programs return 0 for success
$    then
ifelse([$2],,[$!],[$2])
$  else
ifelse([$3],,[$!],[$3])
$    endif
ifelse([$4],,, [$  endif
])dnl
$ if f$search("CONFTEST*.*.*") .nes. "" then delete/nolog conftest*.*.*
$])dnl
dnl
define(AC_TEST_CPP,
[AC_REQUIRE_CPP()dnl
$ open/write conftest_file conftest.'ac_ext'
$ write conftest_file "#include ""confdefs.h"""
VMS_SPLIT_LINES([$ write conftest_file "], AC_QUOTE_DQUOTE([$1]), ["])
$ close conftest_file
dnl Some shells (Coherent) do redirections in the wrong order, so need
dnl the parens.
$ set noon
$ def/user sys$output conftest.err
$ def/user sys$error conftest.err
$ 'ac_cpp' nla0: conftest.'ac_ext'
$ ac_severity = $severity
$ set on
$ ac_err := YES
$ if f$search("conftest.err") .nes. "" then -
	if f$file("conftest.err","EOF") .ne. 0 then -
	ac_err := NO
$! Alternate test for gcc
$ if ac_gcc .and. ac_severity .gt. 1 then ac_err := NO
$ if ac_err
$  then
ifelse([$2],,[$!],[$ delete/nolog conftest*.*.*
$2])
ifelse([$3],,,[$  else
$ delete/nolog conftest*.*.*
$3
])dnl
$  endif
$ dummy = f$search("foo.bar.1") ! To prevent f$search bug.
$ if f$search("CONFTEST*.*.*") .nes. "" then delete/nolog conftest*.*.*
$])dnl
dnl
define(AC_REPLACE_FUNCS,
[AC_DEFINE_VMS_LABLE(ac_rf_loop,ac_rf)dnl
$ ac_l = "$1"
$ ac_i = 0
[$]AC_USE_VMS_LABLE(ac_rf_loop):
$ ac_func = f$element(ac_i," ",ac_l)
$ ac_i = ac_i + 1
$ if ac_func .nes. " "
$  then
AC_COMPILE_CHECK(['ac_func'], [#include <ctype.h>
], [/* The GNU C library defines this for functions which it implements
    to always fail with ENOSYS.  Some functions are actually named
    something starting with __ and the normal name is an alias.  */
#if defined (__stub_''ac_func') || defined (__stub___''ac_func')
choke me
#else
/* Override any gcc2 internal prototype to avoid an error.  */
extern char ''ac_func'(); ''ac_func'();
#endif
], , [dnl
$ if f$type(LIBOBJS) .eqs. "" then LIBOBJS = ""
$ LIBOBJS=LIBOBJS + ",''ac_func'.obj"
AC_VERBOSE(using 'ac_func'.obj instead)])
$   goto AC_USE_VMS_LABLE(ac_rf_loop)
$  endif
AC_SUBST(LIBOBJS)dnl
$])dnl
dnl
define(AC_FUNC_CHECK,
[ifelse([$3], , [AC_COMPILE_CHECK([$1], [#include <ctype.h>
], [/* The GNU C library defines this for functions which it implements
    to always fail with ENOSYS.  Some functions are actually named
    something starting with __ and the normal name is an alias.  */
#if defined (__stub_$1) || defined (__stub___$1)
choke me
#else
/* Override any gcc2 internal prototype to avoid an error.  */
extern char $1(); $1();
#endif
],
[$2])], [AC_COMPILE_CHECK([$1], [#include <ctype.h>
], [/* The GNU C library defines this for functions which it implements
    to always fail with ENOSYS.  Some functions are actually named
    something starting with __ and the normal name is an alias.  */
#if defined (__stub_$1) || defined (__stub___$1)
choke me
#else
#ifndef $1 /* It might be implemented as a macro, as with DEC C for AXP */
/* Override any gcc2 internal prototype to avoid an error.  */
extern char $1();
#endif
$1();
#endif
],
[$2], [$3])])])dnl
dnl
define(AC_HAVE_FUNCS,
[AC_DEFINE_VMS_LABLE(ac_hf_loop1,ac_hf)dnl
$ ac_l = VMS_SPLIT_LINES(["],AC_DEFINE_QUOTE($1),[ "+-])
""
$ ac_i = 0
$AC_USE_VMS_LABLE([ac_hf_loop1]):
$ ac_func = f$element(ac_i," ",ac_l)
$ ac_i = ac_i + 1
$ if ac_func .nes. " "
$  then
$   if ac_func .nes. ""
$    then
$     !# Translates all lower case characters to upper case
$     ac_tr_func := HAVE_'ac_func'
AC_FUNC_CHECK('ac_func',
[AC_DEFINE('ac_tr_func')])
$    endif
$   goto AC_USE_VMS_LABLE([ac_hf_loop1])
$  endif 
$])dnl
dnl
define(AC_HAVE_HEADERS,
[AC_REQUIRE_CPP()dnl Make sure the cpp check happens outside the loop.
AC_DEFINE_VMS_LABLE(ac_hh_1,ac_hh)AC_DEFINE_VMS_LABLE(ac_hh_2,ac_hh)dnl
$ ac_hh_l = "AC_DEFINE_QUOTE($1)"
$ ac_hh_i = 0
[$]AC_USE_VMS_LABLE(ac_hh_1):
$ ac_hh_hdr_orig = f$element(ac_hh_i," ",ac_hh_l)
$ ac_hh_hdr = "HAVE_" + ac_hh_hdr_orig
$ ac_hh_i = ac_hh_i + 1
$ if ac_hh_hdr_orig .nes. " "
$  then
$   ac_hh_tr_hdr = ""
$   ac_hh_c1 = "."
$   ac_hh_c2 = "/"
$   ac_hh_c = 1
$   ac_hh_j = 0
[$]AC_USE_VMS_LABLE([ac_hh_2]):
$   ac_hh_e = f$element(ac_hh_j,ac_hh_c'ac_hh_c',ac_hh_hdr)
$   ac_hh_j = ac_hh_j + 1
$   if ac_hh_e .eqs. ac_hh_c'ac_hh_c'
$    then
$     if ac_hh_c .eq. 1
$      then
$       ac_hh_c = 2
$       ac_hh_hdr = ac_hh_tr_hdr
$       ac_hh_tr_hdr = ""
$       ac_hh_j = 0
$       goto AC_USE_VMS_LABLE([ac_hh_2])
$      endif
$    else
$     if ac_hh_tr_hdr .nes. "" then -
	ac_hh_tr_hdr = ac_hh_tr_hdr + "_"
$     ac_hh_tr_hdr = ac_hh_tr_hdr + f$edit(ac_hh_e,"UPCASE")
$     goto AC_USE_VMS_LABLE([ac_hh_2])
$    endif
AC_HEADER_CHECK('ac_hh_hdr_orig',
[AC_DEFINE('ac_hh_tr_hdr')])
$   goto AC_USE_VMS_LABLE([ac_hh_1])
$  endif
$])dnl
dnl
dnl errprint([AC_HAVE_LIBRARY still needs some work
dnl ])dnl
dnl
define(AC_HAVE_LIBRARY, [dnl
changequote({,})dnl
define({AC_LIB_NAME}, dnl
patsubst({$1}, {\([^:].*:\)?\([^\./]*\).*}, {\2}))dnl
changequote([,])dnl
$ if f$type(LIBS) .nes. ""
$  then
$   ac_save_LIBS=LIBS
$   ac_new_LIBS=LIBS+" $1"
$  else
$   ac_save_LIBS=""
$   ac_new_LIBS="$1"
$  endif
$ ac_have_lib="NO"
$ LIBS=ac_new_LIBS
AC_COMPILE_CHECK([$1], , [main();], [$ ac_have_lib="YES"])
$ LIBS=ac_save_LIBS
ifelse($#, 1, [dnl
$ if ac_have_lib
$  then
AC_DEFINE([HAVE_LIB]translit(AC_LIB_NAME, [a-z], [A-Z]))
$   LIBS=ac_new_LIBS
$  endif
undefine([AC_LIB_NAME])dnl
$], [dnl
$ if ac_have_lib
$  then
$2
$  else
$3
$  endif
$])])dnl
dnl
define(AC_SIZEOF_TYPE,
[AC_CHECKING(size of $1)
AC_TEST_PROGRAM([#include <stdio.h>
main()
{
  FILE *f=fopen("conftestval.out", "w");
  if (!f) exit(1);
  fprintf(f, "%d\n", sizeof($1));
  exit(0);
}], [dnl
$ open/read/err=ac_s_t_close ac_tmp_file conftestval.out
$ read/err=ac_s_t_close/end=ac_s_t_close ac_tmp_file ac_size
$ac_s_t_close:
$ close ac_tmp_file], AC_ERROR(can not determine size of $1))
AC_DEFINE(changequote(<<,>>)translit(sizeof_$1, [a-z *], [A-Z_P])<<>>changequote([,]), 'ac_size')])dnl
dnl
dnl define(_AC_POST_HOOK,)dnl
define(AC_DEFINE_POST_HOOK,[define([_AC_POST_HOOK],[VMS_SPLIT_LINES([$ write config_status_file "], AC_QUOTE_DQUOTE([$1]), ["])])
])dnl
dnl
dnl
dnl The big finish
dnl
dnl
define(AC_OUTPUT,
[$!# The preferred way to propogate these variables is regular @ substitutions.
$ if "''prefix'" .nes. ""
$  then
changequote(,)dnl
$   prefix_dir = f$parse(prefix,,,"DIRECTORY") - "[" - "]" - "<" - ">"
$   prefix_dev = f$parse(prefix,,,"DEVICE")
changequote([,])dnl
AC_INSTALL_EXTRA_ac_prsub(prefix_dev)dnl
AC_INSTALL_EXTRA_ac_prsub(prefix_dir)dnl
AC_INSTALL_EXTRA_ac_prsub(prefix)dnl
$  else
changequote(,)dnl
$   prefix_dev := sys$sysdevice:
$   prefix_dir := gnu
$   prefix := sys$sysdevice:[gnu]
changequote([,])dnl
$  endif
$ if "''exec_prefix'" .nes. ""
$  then
changequote(,)dnl
$   exec_prefix := 'exec_prefix'
$   exec_prefix_dir = f$parse(exec_prefix,,,"DIRECTORY")-"[" - "]" - "<" - ">"
$   exec_prefix_dev = f$parse(exec_prefix,,,"DEVICE")
changequote([,])dnl
AC_INSTALL_EXTRA_ac_prsub(exec_prefix_dev)dnl
AC_INSTALL_EXTRA_ac_prsub(exec_prefix_dir)dnl
AC_INSTALL_EXTRA_ac_prsub(exec_prefix)dnl
$  else
$   exec_prefix_dev = prefix_dev
$   exec_prefix_dir = prefix_dir
$   exec_prefix = prefix
$  endif
undivert(7)dnl
dnl Substitute for predefined variables.
AC_SUBST(LIBS)dnl
AC_SUBST(OPTS)dnl
AC_SUBST(srcdir_dev)dnl
AC_SUBST(srcdir_dir)dnl
AC_SUBST(srcdir)dnl
AC_SUBST(top_srcdir_dev)dnl
AC_SUBST(top_srcdir_dir)dnl
AC_SUBST(top_srcdir)dnl
AC_SUBST(prefix_dev)dnl
AC_SUBST(prefix_dir)dnl
AC_SUBST(prefix)dnl
AC_SUBST(exec_prefix_dev)dnl
AC_SUBST(exec_prefix_dir)dnl
AC_SUBST(exec_prefix)dnl
AC_SUBST(startupdir)dnl
dnl Substituting for DEFS would confuse sed if it contains multiple lines.
ifdef([AC_CONFIG_NAMES],
[divert(1)dnl
dnl UNIX s%@DEFS@%-DHAVE_CONFIG_H%,
$ write config_status_file "$ write config_status_tpu ""TPU_substitute(""""@DEFS@"""",""""""""""""HAVE_CONFIG_H"""""""""""");"""
],[divert(1)dnl
dnl UNIX s%@DEFS@%$DEFS%
AC_DEFINE_VMS_LABLE(DEFS_SUBST,DEFS_SUBST)dnl
AC_DEFINE_VMS_LABLE(DEFS_SUBST2,DEFS_SUBST)dnl
$ if f$type(DEFS_COUNTER) .eqs. "" then DEFS_COUNTER = 0
$ DEFSC = 0
$AC_USE_VMS_LABLE(DEFS_SUBST):
$ DEFSC = DEFSC + 1
$ if DEFSC .le. DEFS_COUNTER
$  then
$   DEFS = DEFS'DEFSC'
$
$   DEFS_ACC = f$element(0,"""",DEFS)
$   QUOTED_DEFS_ACC = DEFS_ACC
$   DEFSI = 1
$AC_USE_VMS_LABLE(DEFS_SUBST2):
$   DEFS_EL = f$element(DEFSI,"""",DEFS)
$   if DEFS_EL .nes. """"
$    then
$     DEFSI = DEFSI + 1
$     DEFS_ACC = DEFS_ACC + """""""""""""""""" + DEFS_EL
$     QUOTED_DEFS_ACC = QUOTED_DEFS_ACC + """""""""""""""""""""""""""""""""" + DEFS_EL
$     goto AC_USE_VMS_LABLE(DEFS_SUBST2)
$    endif
$   if DEFSC .lt. DEFS_COUNTER
$    then
$     write config_status_file "$ write config_status_tpu ""TPU_substitute(""""@DEFS@"""",""""''DEFS_ACC',@DEFS@"""");"""
$     write config_status_file "$ write config_status_tpu ""TPU_substitute(""""@QUOTED_DEFS@"""",""""""""""""''QUOTED_DEFS_ACC'"""""""",@QUOTED_DEFS@"""");"""
$    else
$     write config_status_file "$ write config_status_tpu ""TPU_substitute(""""@DEFS@"""",""""''DEFS_ACC'"""");"""
$     write config_status_file "$ write config_status_tpu ""TPU_substitute(""""@QUOTED_DEFS@"""",""""""""""""''QUOTED_DEFS_ACC'"""""""""""");"""
$    endif
$   goto AC_USE_VMS_LABLE(DEFS_SUBST)
$  endif
divert(2)dnl
dnl UNIX DEFS='$DEFS'
AC_DEFINE_VMS_LABLE(DEFS_SUBST,DEFS_SUBST)dnl
AC_DEFINE_VMS_LABLE(DEFS_SUBST1,DEFS_SUBST)dnl
AC_DEFINE_VMS_LABLE(DEFS_SUBST2,DEFS_SUBST)dnl
AC_DEFINE_VMS_LABLE(DEFS_SUBST3,DEFS_SUBST)dnl
$ if f$type(DEFS_COUNTER) .eqs. "" then DEFS_COUNTER = 0
$ DEFSC = 0
$ DEFS_prefix = "$ DEFS:="
$AC_USE_VMS_LABLE(DEFS_SUBST):
$ DEFSC = DEFSC + 1
$ if DEFSC .le. DEFS_COUNTER
$  then
$   DEFS = DEFS'DEFSC'
$
$   DEFS_ACC = f$element(0,"""",DEFS)
$   DEFSI = 1
$AC_USE_VMS_LABLE(DEFS_SUBST2):
$   DEFS_EL = f$element(DEFSI,"""",DEFS)
$   if DEFS_EL .nes. """"
$    then
$     DEFSI = DEFSI + 1
$     DEFS_ACC = DEFS_ACC + """""""""" + DEFS_EL
$     goto AC_USE_VMS_LABLE(DEFS_SUBST2)
$    endif
$   if DEFSC .lt. DEFS_COUNTER
$    then
$     write config_status_file "''DEFS_prefix'""''DEFS_ACC'"",-"
$    else
$     write config_status_file "''DEFS_prefix'""''DEFS_ACC'"""
$    endif
$   DEFS_prefix = ""
$   goto AC_USE_VMS_LABLE(DEFS_SUBST)
$  endif
$
$ DEFSC = 0
$ QUOTED_DEFS_prefix = "$ QUOTED_DEFS:="
$AC_USE_VMS_LABLE(DEFS_SUBST1):
$ DEFSC = DEFSC + 1
$ if DEFSC .le. DEFS_COUNTER
$  then
$   DEFS = DEFS'DEFSC'
$
$   QUOTED_DEFS_ACC = f$element(0,"""",DEFS)
$   DEFSI = 1
$AC_USE_VMS_LABLE(DEFS_SUBST3):
$   DEFS_EL = f$element(DEFSI,"""",DEFS)
$   if DEFS_EL .nes. """"
$    then
$     DEFSI = DEFSI + 1
$     QUOTED_DEFS_ACC = QUOTED_DEFS_ACC + """""""""""""""""" + DEFS_EL
$     goto AC_USE_VMS_LABLE(DEFS_SUBST3)
$    endif
$   if DEFSC .lt. DEFS_COUNTER
$    then
$     write config_status_file "''QUOTED_DEFS_prefix'""''QUOTED_DEFS_ACC'"",-"
$    else
$     write config_status_file "''QUOTED_DEFS_prefix'""''QUOTED_DEFS_ACC'"""
$    endif
$   QUOTED_DEFS_prefix = ""
$   goto AC_USE_VMS_LABLE(DEFS_SUBST1)
$  endif
])dnl
divert(2)dnl
$ ac_i = 0
$ac_prsub_loop:
$ ac_i = ac_i + 1
$ if f$type(ac_prsub'ac_i') .nes. ""
$  then"
$   if f$type(ac_prsub_support'ac_i') .nes. ""
$    then
$     ac_tmp = ac_prsub_support'ac_i'
$     write config_status_file "$   ",ac_tmp
$    endif
$   ac_tmp = ac_prsub'ac_i'
$   write config_status_file "$   ac_prsub''ac_i'=""",ac_tmp,""""
$   goto ac_prsub_loop
$  endif
$
$ ac_i = 0
$ac_vpsub_loop:
$ ac_i = ac_i + 1
$ if f$type(ac_vpsub'ac_i') .nes. ""
$  then"
$   if f$type(ac_vpsub_support'ac_i') .nes. ""
$    then
$     ac_tmp = ac_vpsub_support'ac_i'
$     write config_status_file "$   ",ac_tmp
$    endif
$   ac_tmp = ac_vpsub'ac_i'
$   write config_status_file "$   ac_vpsub''ac_i'=""",ac_tmp,""""
$   goto ac_vpsub_loop
$  endif
$
$ ac_i = 0
$ac_extrasub_loop:
$ ac_i = ac_i + 1
$ if f$type(ac_extrasub'ac_i') .nes. ""
$  then"
$   ac_tmp = ac_extrasub'ac_i'
$   write config_status_file "$   ac_extrasub''ac_i'=""''ac_tmp'"""
$   goto ac_extrasub_loop
$  endif
divert(0)dnl
$
$ set noon
$ if f$search("CONFIG.STATUS.*") .nes. "" then purge/nolog config.status
$ set on
$! trap 'rm -f config.status; exit 1' 1 2 15
$ write sys$output "creating config.status"
$ open/write config_status_file config.status
$ write config_status_file "$! Generated automatically by CONFIGURE.COM."
$ write config_status_file "$! Run this file to recreate the current configuration."
$ write config_status_file "$! This directory was configured as follows,"
dnl hostname on some systems (SVR3.2, Linux) returns a bogus exit status,
dnl so uname gets run too.
$ write config_status_file "$! on host "+f$getsyi("NODENAME")+":"
$ write config_status_file "$!"
$ __tmp_p = f$env("PROCEDURE")
$ __tmp_p = f$parse(__tmp_p,,,"DEVICE")+f$parse(__tmp_p,,,"DIRECTORY")+ -
	f$parse(__tmp_p,,,"NAME")+f$parse(__tmp_p,,,"TYPE")
$ write config_status_file "$! @"+__tmp_p+" "+configure_args
$ write config_status_file "$"
$ write config_status_file "$ set symbol/verb/scope=(noglobal,nolocal)"
$ write config_status_file "$"
changequote({,})dnl
$ write config_status_file "$ ac_cs_usage = ""Usage: config.status [--recheck] [--version] [--help]"
changequote([,])dnl
$ write config_status_file "$ ac_will_recheck := no"
$ write config_status_file "$ ac_recheck_extra_args = """""
$ write config_status_file "$ ac_count = 8"
$ write config_status_file "$config_status_loop1:"
$ write config_status_file "$ if ac_count .gt. 0
$ write config_status_file "$  then
$ write config_status_file "$   if p'ac_count' .eqs. """""
$ write config_status_file "$    then"
$ write config_status_file "$     ac_count = ac_count - 1"
$ write config_status_file "$     goto config_status_loop1"
$ write config_status_file "$    endif"
$ write config_status_file "$  endif"
$ write config_status_file "$ i = 0"
$ write config_status_file "$config_status_loop2:"
$ write config_status_file "$ i = i + 1"
$ write config_status_file "$ if i .le. ac_count"
$ write config_status_file "$  then"
$ write config_status_file "$   if p'i' .eqs. ""-RECHECK"" -"
$ write config_status_file "	.or. p'i' .eqs. f$extract(0,f$length(p'i'),""--RECHECK"")"
$ write config_status_file "$    then"
$ write config_status_file "$     ac_will_recheck := yes"
$ write config_status_file "$     goto config_status_loop2"
$ write config_status_file "$    endif"
$ write config_status_file "$   if f$extract(0,f$locate(""="",p'i'),p'i') .eqs. f$extract(0,f$locate(""="",p'i'),""--NEW-ARGS"")"
$ write config_status_file "$    then"
$ write config_status_file "$     tmp = f$extract(f$locate(""="",p'i'),999,p'i')"
$ write config_status_file "$     if tmp .nes. """" then ac_recheck_extra_args = ac_recheck_extra_args + "" "" + (tmp - ""="")"
$ write config_status_file "$     goto config_status_loop2"
$ write config_status_file "$    endif"
$ write config_status_file "$   if p'i' .eqs. ""-VERSION"" -"
$ write config_status_file "	.or. p'i' .eqs. f$extract(0,f$length(p'i'),""--VERSION"")"
$ write config_status_file "$    then"
$ write config_status_file "$     write sys$output ""config.status generated by autoconf version AC_ACVERSION"""
$ write config_status_file "$     exit 1"
$ write config_status_file "$    endif"
$ write config_status_file "$   if p'i' .eqs. ""-HELP"" -"
$ write config_status_file "	.or. p'i' .eqs. f$extract(0,f$length(p'i'),""--HELP"")"
$ write config_status_file "$    then"
$ write config_status_file "$     write sys$output ac_cs_usage"
$ write config_status_file "$     exit $status"
$ write config_status_file "$    endif"
$ write config_status_file "$   if p'i' .nes. """"
$ write config_status_file "$    then
$ write config_status_file "$     write sys$error ac_cs_usage"
$ write config_status_file "$     exit 0"
$ write config_status_file "$    endif"
$ write config_status_file "$   goto config_status_loop2"
$ write config_status_file "$  endif"
$ write config_status_file "$"
$ write config_status_file "$ if ac_will_recheck"
$ write config_status_file "$  then"
$ write config_status_file "$   write sys$output ""@"+__tmp_p+" "+configure_args+""",ac_recheck_extra_args"
$ write config_status_file "$   @"+__tmp_p+" "+f$edit(configure_args,"TRIM")+"'ac_recheck_extra_args'"
$ write config_status_file "$   exit $status"
$ write config_status_file "$  endif"
$ write config_status_file "$"
ifdef([AC_CONFIG_NAMES],
[$ write config_status_file "$ set noon"
$ write config_status_file "$! _tmp = f$parse(""AC_CONFIG_NAMES"","";*"",,,""SYNTAX_ONLY"")
$ write config_status_file "$! if f$search(_tmp) .nes. """" then delete/nolog '_tmp'"
$ write config_status_file "$ if f$search(""CONFTEST*.*.*"") .nes. """" then delete/nolog conftest*.*.*"
$ write config_status_file "$ if f$search(""CONFDEFS*.*.*"") .nes. """" then delete/nolog confdefs*.*.*"
$ write config_status_file "$ set on"
])dnl
dnl Insert the variable assignments.
undivert(2)dnl
undivert(3)dnl
$ write config_status_file "$"
$ write config_status_file "$ ac_given_srcdir=srcdir"
$ write config_status_file "$ ac_given_srcdir_dev=srcdir_dev"
$ write config_status_file "$ ac_given_srcdir_dir=srcdir_dir"
$ write config_status_file "$"
changequote({,})dnl
$ write config_status_file "$ if f$type(CONFIG_FILES) .eqs. """" then CONFIG_FILES = ""[-]"" +-"
changequote([,])dnl
VMS_SPLIT_LINES([$ write config_status_file "	"" ],[$1],["" +-"])
$ write config_status_file "	"""""
$ write config_status_file "$! CONFIG_FILE_i = -1"
$ write config_status_file "$ CONFIG_FILE_i = 0"
$ write config_status_file "$config_status_loop3:"
$ write config_status_file "$! if CONFIG_FILE_i .eq. -1"
$ write config_status_file "$!  then"
changequote({,})dnl
]changequote({,})dnl
{$ write config_status_file "$!   ac_file = ""[-]"""
$ write config_status_file "$!  else"
$ write config_status_file "$   ac_file = f$element(CONFIG_FILE_i,"" "",CONFIG_FILES)"
$ write config_status_file "$!  endif"
$ write config_status_file "$ dummy = ""'"+"'ac_file'""" ! debug
$ write config_status_file "$ CONFIG_FILE_i = CONFIG_FILE_i + 1"
$ write config_status_file "$ if ac_file .eqs. ""[-]"" then goto config_status_loop3"
$ write config_status_file "$ if ac_file .nes. "" """
$ write config_status_file "$  then"
$ write config_status_file "$   ac_dir:="
$ write config_status_file "$   ac_dir_tmp = ac_file"
$ write config_status_file "$  ac_loop_dir1:"
$ write config_status_file "$   ac_dir_e = f$element(0,""]"",ac_dir_tmp)"
$ write config_status_file "$   if ac_dir_e .eqs. ac_dir_tmp then goto ac_loop_dir2"
$ write config_status_file "$   ac_dir_e = ac_dir_e + ""]"""
$ write config_status_file "$   ac_dir = ac_dir + ac_dir_e"
$ write config_status_file "$   ac_dir_tmp = ac_dir_tmp - ac_dir_e"
$ write config_status_file "$   goto ac_loop_dir1
$ write config_status_file "$  ac_loop_dir2:"
$ write config_status_file "$   ac_dir_e = f$element(0,"">"",ac_dir_tmp)"
$ write config_status_file "$   if ac_dir_e .eqs. ac_dir_tmp then goto ac_end_dir"
$ write config_status_file "$   ac_dir_e = ac_dir_e + "">"""
$ write config_status_file "$   ac_dir = ac_dir + ac_dir_e"
$ write config_status_file "$   ac_dir_tmp = ac_dir_tmp - ac_dir_e"
$ write config_status_file "$   goto ac_loop_dir2"
$ write config_status_file "$  ac_end_dir:"
$ write config_status_file "$   if ac_dir .nes. ac_file .and. ac_dir .nes. """" -"
$ write config_status_file "	.and. ac_dir .nes. ""[]"""
$ write config_status_file "$    then"
$ write config_status_file "$     !# The file is in a subdirectory"
$ write config_status_file "$     set noon"
$ write config_status_file "$     if f$parse(ac_dir) .eqs. """" then create/dir 'ac_dir'"
$ write config_status_file "$     set on"
$ write config_status_file "$     ac_dir_tmp = ac_dir - ""[."" - ""<."" - ""["" - ""<"" - ""]"" - "">"""
changequote([,])dnl
}changequote([,])dnl
[$ write config_status_file "$     ac_dir_suffix:=.'ac_dir_tmp'"
$ write config_status_file "$    else"
$ write config_status_file "$     ac_dir_suffix:="
$ write config_status_file "$    endif"
$ write config_status_file "$"
$ write config_status_file "$   ac_dashes:="
$ write config_status_file "$   ac_dir_tmp=ac_dir_suffix"
$ write config_status_file "$  ac_loop_dashes:"
$ write config_status_file "$   ac_dir_e = f$element(1,""."",ac_dir_tmp)"
$ write config_status_file "$   if ac_dir_e .eqs. ""."" then goto ac_end_dashes"
$ write config_status_file "$   ac_dashes = ac_dashes + ""-"""
$ write config_status_file "$   ac_dir_e = "".""+ac_dir_e"
$ write config_status_file "$   ac_dir_tmp = ac_dir_tmp - ac_dir_e"
$ write config_status_file "$   goto ac_loop_dashes"
$ write config_status_file "$  ac_end_dashes:"
changequote({,})dnl
]changequote({,})dnl
{$ write config_status_file "$   if ac_given_srcdir .eqs. ""[]"""
$ write config_status_file "$    then"
$ write config_status_file "$     srcdir := []"
$ write config_status_file "$     srcdir_dev :="
$ write config_status_file "$     srcdir_dir :="
$ write config_status_file "$     if ac_dir_suffix .eqs. """"
$ write config_status_file "$      then"
$ write config_status_file "$       top_srcdir := []"
$ write config_status_file "$       top_srcdir_dev :="
$ write config_status_file "$       top_srcdir_dir :="
$ write config_status_file "$      else"
$ write config_status_file "$       top_srcdir := ['ac_dashes']"
$ write config_status_file "$       top_srcdir_dev :="
$ write config_status_file "$       top_srcdir_dir = ac_dashes"
$ write config_status_file "$      endif"
$ write config_status_file "$    else"
$ write config_status_file "$     if f$extract(0,2,ac_given_srcdir_dir) .eqs. ""[."""
$ write config_status_file "$      then !# Relative path."
$ write config_status_file "$       if ac_dashes .nes. """" then ac_dashes = ac_dashes + ""."""
$ write config_status_file "$       srcdir_dir := 'ac_dashes'"+"'ac_given_srcdir_dir'"+"'ac_dir_suffix'"
$ write config_status_file "$       srcdir_dev := 'ac_given_srcdir_dev'"
$ write config_status_file "$       srcdir := 'srcdir_dev'['srcdir_dir']"
$ write config_status_file "$       top_srcdir_dev := 'ac_given_srcdir_dev'"
$ write config_status_file "$       top_srcdir_dir := 'ac_dashes'"+"'ac_given_srcdir_dir'"
$ write config_status_file "$       top_srcdir := 'top_srcdir_dev'['top_srcdir_dir']"
$ write config_status_file "$      else"
$ write config_status_file "$       srcdir_dir := 'ac_given_srcdir_dir'"+"'ac_dir_suffix'"
$ write config_status_file "$       srcdir_dev := 'ac_given_srcdir_dev'"
$ write config_status_file "$       srcdir := 'srcdir_dev'['srcdir_dir']"
$ write config_status_file "$       top_srcdir_dev := 'ac_given_srcdir_dev'"
$ write config_status_file "$       top_srcdir_dir := 'ac_given_srcdir_dir'"
$ write config_status_file "$       top_srcdir := 'top_srcdir_dev'['top_srcdir_dir']"
$ write config_status_file "$      endif"
$ write config_status_file "$    endif"
changequote([,])dnl
}changequote([,])dnl
[$ write config_status_file "$"
$ write config_status_file "$   write sys$output ""creating '"+"'ac_file'"""
$ write config_status_file "$   set noon"
$ write config_status_file "$   ac_tmp = f$parse(ac_file,""*.*;*"")"
$ write config_status_file "$!   if f$search(ac_tmp) .nes. """" then delete/nolog 'ac_tmp'"
$ write config_status_file "$   ac_input_file_type = f$parse(ac_file,,,""TYPE"")"
$ write config_status_file "$   ac_input_file := 'f$element(0,"";"",ac_file)'"
$ write config_status_file "$   ac_input_file_len = f$length(ac_input_file)-f$length(ac_input_file_type)"
$ write config_status_file "$   !sh sym ac_input_file*"
$ write config_status_file "$   if f$extract(ac_input_file_len,f$length(ac_input_file_type),ac_input_file) .nes. ac_input_file_type then ac_input_file_len = f$length(ac_input_file)"
$ write config_status_file "$   ac_input_file = f$extract(0,ac_input_file_len,ac_input_file)"
$ write config_status_file "$   ac_input_file_dir = f$extract(0,ac_input_file_len-f$length(f$parse(ac_input_file,,,""NAME"")),ac_input_file)"
$ write config_status_file "$   ac_input_file = ac_input_file-ac_input_file_dir"
$ write config_status_file "$   !sh sym ac_input_file*"
$ write config_status_file "$   !set verify"
$ write config_status_file "$   comment_str=""Generated automatically from ""+ac_input_file+ac_input_file_type+"" by configure."""
$ write config_status_file "$   open/write config_status_dest 'ac_file'"
$ write config_status_file "$   if ac_input_file_type .eqs. "".C"" -"
$ write config_status_file "      .or. ac_input_file_type .eqs. "".H"" -"
$ write config_status_file "      .or. ac_input_file_type .eqs. "".CC"" -"
$ write config_status_file "      .or. ac_input_file_type .eqs. "".MAR"""
$ write config_status_file "$    then"
$ write config_status_file "$     write config_status_dest ""/* "",comment_str,"" */"""
$ write config_status_file "$    else"
$ write config_status_file "$     if ac_input_file_type .eqs. "".COM"""
$ write config_status_file "$      then"
$ write config_status_file "$       write config_status_dest ""$! "",comment_str"
$ write config_status_file "$      else
$ write config_status_file "$       write config_status_dest ""# "",comment_str"
$ write config_status_file "$      endif"
$ write config_status_file "$    endif"
$ write config_status_file "$
$ write config_status_file "$   open/write config_status_tpu conftest.tpu"
$ write config_status_file "$   type sys$input:/out=config_status_tpu"
$ write config_status_file "procedure TPU_substitute(pat,value)"
$ write config_status_file "	local r;"
$ write config_status_file "	position (beginning_of (main_buffer));"
$ write config_status_file "	loop"
$ write config_status_file "		r := search_quietly (pat, FORWARD);"
$ write config_status_file "		EXITIF r = 0;"
$ write config_status_file "		erase (r);"
$ write config_status_file "		position (r);"
$ write config_status_file "		copy_text (value);"
$ write config_status_file "		position (end_of (r));"
dnl $ write config_status_file "		position (line_begin);"
dnl $ write config_status_file "		move_vertical (1);"
$ write config_status_file "	endloop;"
$ write config_status_file "endprocedure;"
$ write config_status_file "! This is the main thing."
$ write config_status_file "input_file := GET_INFO (COMMAND_LINE, ""file_name"");"
$ write config_status_file "main_buffer := CREATE_BUFFER (""main"", input_file);"
$ write config_status_file "p_0_or_more_spc := (span("" ""+ASCII(9)) | """");"
$ write config_status_file "position (beginning_of (main_buffer));"
$ write config_status_file "! Here it is time to put the calls."
$ write config_status_file "$   !set noverify"
$ write config_status_file "$   ac_i = 0"
$ write config_status_file "$ac_prsub_write_loop:"
$ write config_status_file "$   ac_i = ac_i + 1"
$ write config_status_file "$   if f$type(ac_prsub'ac_i') .nes. ""
$ write config_status_file "$    then
$ write config_status_file "$     ac_tmp = ac_prsub'ac_i'"
$ write config_status_file "$     write config_status_tpu ac_tmp"
$ write config_status_file "$     goto ac_prsub_write_loop"
$ write config_status_file "$    endif"
$ write config_status_file "$   ac_i = 0"
$ write config_status_file "$ac_vpsub_write_loop:"
$ write config_status_file "$   ac_i = ac_i + 1"
$ write config_status_file "$   if f$type(ac_vpsub'ac_i') .nes. ""
$ write config_status_file "$    then
$ write config_status_file "$     ac_tmp = ac_vpsub'ac_i'"
$ write config_status_file "$     write config_status_tpu ac_tmp"
$ write config_status_file "$     goto ac_vpsub_write_loop"
$ write config_status_file "$    endif"
dnl Shell code in configure.in might set extrasub.
$ write config_status_file "$   ac_i = 0"
$ write config_status_file "$ac_extrasub_write_loop:"
$ write config_status_file "$   ac_i = ac_i + 1"
$ write config_status_file "$   if f$type(ac_extrasub'ac_i') .nes. ""
$ write config_status_file "$    then
$ write config_status_file "$     ac_tmp = ac_extrasub'ac_i'"
$ write config_status_file "$     write config_status_tpu ac_tmp"
$ write config_status_file "$     goto ac_extrasub_write_loop"
$ write config_status_file "$    endif"
dnl Insert the sed substitutions.
undivert(1)dnl
$ write config_status_file "$   !set verify"
$ write config_status_file "$   type sys$input:/out=config_status_tpu"
$ write config_status_file "! Now let's save it all"
$ write config_status_file "WRITE_FILE(main_buffer, GET_INFO(COMMAND_LINE, ""output_file""));"
$ write config_status_file "quit;"
$ write config_status_file "$   close config_status_tpu"
$ write config_status_file "$   if ac_input_file_type .eqs. ""."""
$ write config_status_file "$    then ac_input_file = ac_input_file + "".IN"""
$ write config_status_file "$    else ac_input_file = ac_input_file + ac_input_file_type + ""_IN"""
$ write config_status_file "$    endif"
$ write config_status_file "$   save_def = f$environment(""DEFAULT"")"
$ write config_status_file "$   if ac_given_srcdir .nes. """" then set default 'ac_given_srcdir'"
$ write config_status_file "$   if ac_input_file_dir .nes. """" then set default 'ac_input_file_dir'"
$ write config_status_file "$   ac_input_file_dir = f$environment(""DEFAULT"")"
$ write config_status_file "$   set default 'save_def'
VMS_SPLIT_LINES([$ write config_status_file "],dnl
AC_QUOTE_DQUOTE2(AC_QUOTE_DQUOTE(dnl
AC_MAYBE_SILENT([$   edit/tpu/nosection/command=conftest.tpu/nodisplay -
	'ac_input_file_dir''ac_input_file' /out=config_status_dest]))),["])
$ write config_status_file "$   close config_status_dest"
$ write config_status_file "$   set noon"
$ write config_status_file "$   if f$search(""conftest.tpu"") then delete/nolog conftest.tpu.*"
$ write config_status_file "$! Description files are often check for dependencies, so don't check
$ write config_status_file "$! if they have changed.  Scripts on the ofter hand...
$ write config_status_file "$!$   if f$parse(file,,,""TYPE"") .eqs. "".COM"" -"
$ write config_status_file "$!	.and. f$search(file) .nes. """" then -"
$ write config_status_file "$!	diff conftest.out 'file'/out=nla0:"
$ write config_status_file "$!$   if $status .eq. %X06c8009 ! code for no change"
$ write config_status_file "$!$    then"
$ write config_status_file "$!$     ! The file exists and we would not be changing it."
$ write config_status_file "$!$     write sys$output ""'"+"'file' is unchanged."""
$ write config_status_file "$!$    else"
$ write config_status_file "$!$     copy conftest.out 'file'"
$ write config_status_file "$!$     purge/nolog 'file'"
$ write config_status_file "$!$    endif"
$ write config_status_file "$!$   if f$search(""conftest.out.*"") .nes. """" then delete/nolog conftest.out.*"
$ write config_status_file "$   set on"
$ write config_status_file "$   goto config_status_loop3"
$ write config_status_file "$  endif"
AC_OUTPUT_HEADER[]
$ write config_status_file "$"
$ write config_status_file "$ srcdir=ac_given_srcdir"
$ write config_status_file "$ srcdir_dev=ac_given_srcdir_dev"
$ write config_status_file "$ srcdir_dir=ac_given_srcdir_dir"
$ write config_status_file "$"
VMS_SPLIT_LINES([$ write config_status_file "],AC_QUOTE_DQUOTE([$2]),["])
ifdef([_AC_POST_HOOK],[_AC_POST_HOOK
])dnl
$ write config_status_file "$ exit"
$ close config_status_file
$ set file/prot=(s:rwed,o:rwed,g:re,w:re) config.status
$ if .not. no_create then @config.status
$])dnl
dnl This is a subroutine of AC_OUTPUT, broken out primarily to avoid bugs
dnl with long definitions in GNU m4 1.0.  This is called inside a quoted
dnl here document whose contents are going into config.status.
dnl The here document is written to with the logical config_status_file.
define(AC_OUTPUT_HEADER,[dnl
ifdef([AC_CONFIG_NAMES],[dnl
$ write config_status_file "$ if f$search(""conftest.tpu"") .nes. """" then delete/nolog conftest.tpu.*"
$ write config_status_file "$ type sys$input: /out=conftest.tpu"
$ write config_status_file "! ac_d sets the value in ""#define NAME VALUE"" lines."
$ write config_status_file "! ac_u turns ""#undef NAME"" with trailing blanks into ""#define NAME VALUE""."
$ write config_status_file "! ac_e turns ""#undef NAME"" without trailing blanks into ""#define NAME VALUE""."
$ write config_status_file ""
$ write config_status_file "procedure ac_d(nam,value)"
$ write config_status_file "	local p0, r, r0, r1, r2, r3, res;"
$ write config_status_file "	position (beginning_of (main_buffer));"
$ write config_status_file "	p0 := line_begin + (((((p_empty_or_spaces @ r1) + ""#"" + (p_empty_or_spaces @ r2)) @ r10) + ""def"+"ine"" + (p_spaces @ r3) + nam + (p_spaces @ r4) + p_nospaces) @ r0) + line_end;"
$ write config_status_file "	loop"
$ write config_status_file "		r := search_quietly (p0, FORWARD);"
$ write config_status_file "		EXITIF r = 0;"
$ write config_status_file "		res := sub"+"str (r10, 1) + ""def"+"ine"" + sub"+"str (r3, 1) + nam + sub"+"str(r4, 1) + value;"
$ write config_status_file "		erase (r0);"
$ write config_status_file "		position (r0);"
$ write config_status_file "		copy_text (res);"
$ write config_status_file "		position (end_of (r0));"
dnl $ write config_status_file "		position (line_begin);"
dnl $ write config_status_file "		move_vertical (1);"
$ write config_status_file "	endloop;"
$ write config_status_file "endprocedure;"
$ write config_status_file ""
$ write config_status_file "procedure ac_u(nam,value)"
$ write config_status_file "	local p0, r, r0, r1, r2, r3, res;"
$ write config_status_file "	position (beginning_of (main_buffer));"
$ write config_status_file "	p0 := line_begin + (((((p_empty_or_spaces @ r1) + ""#"" + (p_empty_or_spaces @ r2)) @ r10) + ""undef"" + (p_spaces @ r3) + nam + (p_space @ r4)) @ r0);"
$ write config_status_file "	loop"
$ write config_status_file "		r := search_quietly (p0, FORWARD);"
$ write config_status_file "		EXITIF r = 0;"
$ write config_status_file "		res := sub"+"str (r10, 1) + ""def"+"ine"" + sub"+"str (r3, 1) + nam + "" "" + value + sub"+"str (r4, 1);"
$ write config_status_file "		erase (r0);"
$ write config_status_file "		position (r0);"
$ write config_status_file "		copy_text (res);"
$ write config_status_file "		position (end_of (r0));"
dnl $ write config_status_file "		position (line_begin);"
dnl $ write config_status_file "		move_vertical (1);"
$ write config_status_file "	endloop;"
$ write config_status_file "endprocedure;"
$ write config_status_file ""
$ write config_status_file "procedure ac_e(nam,value)"
$ write config_status_file "	local p0, r, r0, r1, r2, r3, res;"
$ write config_status_file "	position (beginning_of (main_buffer));"
$ write config_status_file "	p0 := line_begin + (((((p_empty_or_spaces @ r1) + ""#"" + (p_empty_or_spaces @ r2)) @ r10) + ""undef"" + (p_spaces @ r3) + nam) @ r0) + line_end;"
$ write config_status_file "	loop"
$ write config_status_file "		r := search_quietly (p0, FORWARD);"
$ write config_status_file "		EXITIF r = 0;"
$ write config_status_file "		res := sub"+"str (r10, 1) + ""def"+"ine"" + sub"+"str (r3, 1) + nam + "" "" + value;"
$ write config_status_file "		erase (r0);"
$ write config_status_file "		position (r0);"
$ write config_status_file "		copy_text (res);"
$ write config_status_file "		position (end_of (r0));"
dnl $ write config_status_file "		position (line_begin);"
dnl $ write config_status_file "		move_vertical (1);"
$ write config_status_file "	endloop;"
$ write config_status_file "endprocedure;"
$ write config_status_file ""
$ write config_status_file "procedure comment_undefs()"
$ write config_status_file "	local p0, r, r0, res;"
$ write config_status_file "	position (beginning_of (main_buffer));"
$ write config_status_file "	p0 := line_begin + ((p_empty_or_spaces + ""#"" + p_empty_or_spaces + ""undef"" + p_spaces + p_any_name) @ r0);"
$ write config_status_file "	loop"
$ write config_status_file "		r := search_quietly (p0, FORWARD);"
$ write config_status_file "		EXITIF r = 0;"
$ write config_status_file "		res := ""/* "" + sub"+"str (r0, 1) + "" */"";"
$ write config_status_file "		erase (r0);"
$ write config_status_file "		position (r0);"
$ write config_status_file "		copy_text (res);"
$ write config_status_file "		position (end_of (r0));"
dnl $ write config_status_file "		position (line_begin);"
dnl $ write config_status_file "		move_vertical (1);"
$ write config_status_file "	endloop;"
$ write config_status_file "endprocedure;"
$ write config_status_file ""
$ write config_status_file "p_empty_or_spaces := (span ("" "" + ascii (9)) | """");"
$ write config_status_file "p_before_keyword := (span ("" "" + ascii (9)) | """") + ""#"" + (span ("" "" + ascii (9)) | """");"
$ write config_status_file "p_space := ("" "" | ascii (9));"
$ write config_status_file "p_spaces := span ("" "" + ascii (9));"
$ write config_status_file "p_nospaces := scan ("" "" + ascii (9));"
$ write config_status_file "p_any_name := any(""abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_"") +"
$ write config_status_file "	span(""abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789"");"
$ write config_status_file ""
$ write config_status_file "! This is the main thing."
$ write config_status_file "ac_input_file := GET_INFO (COMMAND_LINE, ""file_name"");"
$ write config_status_file "main_buffer := CREATE_BUFFER (""main"", ac_input_file);"
$ write config_status_file "position (beginning_of (main_buffer));"
$ write config_status_file "! Here it is time to put the calls."
$ ac_i = 0
$ac_sed_defs_write_loop:
$ ac_i = ac_i + 1
$ if f$type(ac_sed_defs'ac_i') .nes. ""
$  then"
$   write config_status_file ac_sed_defs'ac_i'
$   goto ac_sed_defs_write_loop
$  endif
$ write config_status_file "!# This command replaces #undef's with comments.  This is necessary, for"
$ write config_status_file "!# example, in the case of _POSIX_SOURCE, which is predefined and required"
$ write config_status_file "!# on some systems where configure will not decide to define it in"
changequote({,})dnl
$ write config_status_file "!#"+-
" AC_CONFIG_NAMES."
changequote([,])dnl
$ write config_status_file "comment_undefs();"
$ write config_status_file "!# Now let's save it all"
$ write config_status_file "WRITE_FILE(main_buffer, GET_INFO(COMMAND_LINE, ""output_file""));"
$ write config_status_file "quit;"
$ write config_status_file "$!"
$ write config_status_file "$ if f$type(CONFIG_HEADERS) .eqs. """" then CONFIG_HEADERS=""AC_CONFIG_NAMES"""
$ write config_status_file "$ CONFIG_HEADER_i = 0"
$ write config_status_file "$config_status_loop4:"
$ write config_status_file "$ ac_file = f$element(CONFIG_HEADER_i,"" "",CONFIG_HEADERS)"
$ write config_status_file "$ CONFIG_HEADER_i = CONFIG_HEADER_i + 1"
$ write config_status_file "$ if ac_file .nes. "" """
$ write config_status_file "$  then"
$ write config_status_file "$   write sys$output ""creating "",ac_file"
$ write config_status_file "$   set noon"
$ write config_status_file "$   if f$search(""conftest.h.*"") .nes. """" then delete/nolog conftest.h.*"
$ write config_status_file "$   set on"
$ write config_status_file "$   open/write config_status_tmp conftest.h"
$ write config_status_file "$   write config_status_tmp ""/* '"+"'ac_file'.  Generated automatically by configure.  */"""
$ write config_status_file "$   _tmp = f$parse(ac_file,"".;*"")"
$ write config_status_file "$   ac_input_file = f$parse(ac_file,,,""NAME"")"
$ write config_status_file "$   if f$parse(ac_file,,,""TYPE"") .eqs. ""."""
$ write config_status_file "$    then ac_input_file = ac_input_file + "".IN"""
$ write config_status_file "$    else ac_input_file = ac_input_file + f$parse(ac_file,,,""TYPE"") + ""_IN"""
$ write config_status_file "$    endif"
$ write config_status_file "$   save_def = f$environment(""DEFAULT"")"
$ write config_status_file "$   set def 'ac_given_srcdir'"
$ write config_status_file "$!   set def 'f$parse(ac_file,,,""DEVICE"")'"+"'f$parse(ac_file,,,""DIRECTORY"")"
$ write config_status_file "$   set def 'f$parse(ac_file,,,""DIRECTORY"")'"
$ write config_status_file "$   ac_input_dir = f$environment(""DEFAULT"")"
$ write config_status_file "$   set def 'save_def'"
$ write config_status_file "$!   set noon"
VMS_SPLIT_LINES([$ write config_status_file "],dnl
AC_QUOTE_DQUOTE2(AC_QUOTE_DQUOTE(dnl
AC_MAYBE_SILENT([$   edit/tpu/nosection/nodisplay/command=conftest.tpu/out=config_status_tmp 'ac_input_dir''ac_input_file']))),["])
$ write config_status_file "$   close config_status_tmp"
$ write config_status_file "$   set noon"
$ write config_status_file "$   if f$search(""conftest.tpu.*"") .nes. """" then delete/nolog conftest.tpu.*"
$ write config_status_file "$   if f$search(ac_file) .nes. """" then -"
$ write config_status_file "	diff conftest.h 'ac_file'/out=nla0:"
$ write config_status_file "$   if $status .eq. %X06c8009 ! code for no change"
$ write config_status_file "$    then"
$ write config_status_file "$     ! The file exists and we would not be changing it."
$ write config_status_file "$     write sys$output ""'"+"'ac_file' is unchanged."""
$ write config_status_file "$    else"
$ write config_status_file "$     _tmp = f$parse(ac_file,""*.*;*"")"
$ write config_status_file "$     if f$search(_tmp) .nes. """" then delete/nolog '_tmp'"
$ write config_status_file "$     copy conftest.h 'ac_file'"
$ write config_status_file "$     purge/nolog 'ac_file'"
$ write config_status_file "$    endif"
$ write config_status_file "$   if f$search(""conftest.h.*"") .nes. """" then delete/nolog conftest.h.*"
$ write config_status_file "$   goto config_status_loop4
$ write config_status_file "$  endif
$ write config_status_file "$ set on"
$ write config_status_file "$"
$],[$])])dnl
define(VMS_DELTREE,[changequote({,})ifdef({VMS_DELR_defined},,{define(VMS_DELR_defined,yes)dnl
$!#
$ goto after_VMS_DELR
$VMS_DELR: subroutine
$ on control_y then goto VMS_DELR_STOP
$ on warning then goto VMS_DELR_exit
$ _VMS_DELR_def = f$trnlnm("SYS$DISK")+f$directory()
$ if f$parse(p1) .eqs. "" then exit
$ set default 'f$parse(p1,,,"DEVICE")''f$parse(p1,,,"DIRECTORY")'
$VMS_DELR_loop:
$ _fp = f$parse(".DIR",p1)
$ _f = f$search(_fp)
$ if _f .eqs. "" then goto VMS_DELR_loopend
$ call {VMS_DELR} [.'f$parse(_f,,,"NAME")']*.*
$ goto VMS_DELR_loop
$VMS_DELR_loopend:
$ _fp = f$parse(p1,".;*")
$ if f$search(_fp) .eqs. "" then goto VMS_DELR_exit
$ set noon
$ set file/prot=(S:RWED,O:RWED,G:RWED,W:RWED) '_fp'
$ set on
$ delete/nolog '_fp'
$VMS_DELR_exit:
$ set default '_VMS_DELR_def'
$ exit
$VMS_DELR_STOP:
$ set default '_VMS_DELR_def'
$ stop/id=""
$ exit
$ endsubroutine
$
$after_VMS_DELR:
$!
})dnl
$ call {VMS_DELR} "$1"
changequote([,])$])dnl
dnl
define(VMS_SPLIT_LINES, [patsubst([$2],[^\(.*\)$], [[$1\1$3]])])dnl
dnl
define(AC_ECHO, [$ write sys$output "$*"])dnl
