#include "BinTree.h"

#include <iostream>
#if defined(__DECCXX)
#include <time.h>
#else
#include <ctime>
#endif

#if !defined(_RWSTD_NO_NAMESPACE)
using namespace std;
#endif

int main()
{
  // seed the random number generator with the current time
  srand((unsigned)time(NULL));

  EZUniverse *pEZUniverse = new EZUniverse("EZSave.dat");
  OID OIDofRoot = pEZUniverse->GetRoot();
  EZPtr<BinTree> pRoot;

  if(OIDofRoot == 0)
    pRoot = EZNew(BinTree);
  else
    pRoot = _RWSTD_STATIC_CAST(BinTree *,OIDofRoot);

  // add three random entries to the new or restored tree
  pRoot->AddToTree(RandomName(), RandomAge());
  pRoot->AddToTree(RandomName(), RandomAge());
  pRoot->AddToTree(RandomName(), RandomAge());

  // print the current tree
  pRoot->PrintTree();

  delete pEZUniverse;

  return 0;
}
