 #include "EZSave.h"   $ #include <utility>  // for make_pair #include <fstream>  ! #if !defined(_RWSTD_NO_NAMESPACE)  using namespace std; using namespace EZSave;  #endif   // initialize static variables2 EZUniverse * EZUniverse::m_pCurrentEZUniverse = 0;4 EZToolsTableType * EZToolsBase::m_pEZToolsTable = 0;  * // constructor restores the saved universea EZUniverse::EZUniverse(const char *pFileName) : m_Root(0), m_bInProcessOfRestoringUniverse(true), a                       m_pFileName(0), m_pOID2NameTable(new OID2NameTableType), m_pOID2OIDTable(0)  { :   // make this EZUniverse object the current or active one   m_pCurrentEZUniverse = this;     // save file name 0   m_pFileName = new char[strlen(pFileName) + 1];!   strcpy(m_pFileName, pFileName);      // open file for reading #if defined(__DECCXX) T   ifstream file(m_pFileName, ios::in);  // file won't be created if it doesn't exist #else ]   ifstream file(m_pFileName, ios_base::binary);  // file won't be created if it doesn't exist  #endif  &   if(file)  // continue if file exists   {      // define useful variables     char ClassName[128];     char ch;     int i = 0;     size_t ObjectSize;C     char *p;  // general purpose pointer for "read" member function      OID OldOID, NewOID; I     OID2NameTableType::size_type RecordCount;  // number of saved objects   2     // create new OID2OIDTable for restore process+     m_pOID2OIDTable = new OID2OIDTableType;        // read record count5     p = _RWSTD_REINTERPRET_CAST(char *,&RecordCount); &     file.read(p, sizeof(RecordCount));     assert(RecordCount > 0);       while(RecordCount--)     {        // read class name       i = 0;       do       {          file.get(ch);          ClassName[i++] = ch;       }        while(ch != '\0');         // get size of object 6       ObjectSize = EZToolsBase::ObjectSize(ClassName);  "       // get raw memory for object*       NewOID = ::operator new(ObjectSize);         if(m_Root == 0)          m_Root = NewOID;         // read old OID 2       p = _RWSTD_REINTERPRET_CAST(char *,&OldOID);        file.read(p, sizeof(OID));         // update lists ,       AddToOID2NameTable(NewOID, ClassName);(       AddToOID2OIDTable(OldOID, NewOID);  )       // read object data into raw memory 1       p = _RWSTD_REINTERPRET_CAST(char *,NewOID);        file.read(p, ObjectSize);      }        file.close();   5     // run placement operator new on restored objects E     for(OID2NameTableType::iterator it = (*m_pOID2NameTable).begin(); F                                 it != (*m_pOID2NameTable).end(); it++):       EZToolsBase::FixPointers((*it).second, (*it).first);       // done with OID2OIDTable      delete m_pOID2OIDTable;    }   *   m_bInProcessOfRestoringUniverse = false; }   + // destructor saves the persistent universe  EZUniverse::~EZUniverse()  { H   OID2NameTableType::size_type RecordCount = (*m_pOID2NameTable).size();  A   // create an output file only if the OID2NameTable is not empty    if(RecordCount > 0)    { Q     const char *p;  // general purpose pointer to use for "write" member function      const char *pRootName;       // open new file for output    #if defined(__DECCXX) )     ofstream file(m_pFileName, ios::out);  #else ,     ofstream file(m_pFileName, ios::binary); #endif     assert(file);        // write record count ;     p = _RWSTD_REINTERPRET_CAST(const char *,&RecordCount); '     file.write(p, sizeof(RecordCount));   G     // define iterator for OID2NameTable, position the iterator at root J     OID2NameTableType::iterator itRoot = (*m_pOID2NameTable).find(m_Root);0     assert(itRoot != (*m_pOID2NameTable).end());  /     // write root class name + terminating null %     p = pRootName = (*itRoot).second;      while(*p != '\0')      {        file.put(*p); 
       ++p;     }      file.put('\0');        // write root OID A     p = _RWSTD_REINTERPRET_CAST(const char *,&((*itRoot).first));      file.write(p, sizeof(OID));        // write root data>     p = _RWSTD_REINTERPRET_CAST(const char *,(*itRoot).first);=     file.write(p, EZToolsBase::ObjectSize((*itRoot).second));   +      // write the rest of the OID2NameTable A     OID2NameTableType::iterator it = (*m_pOID2NameTable).begin(); *     while(it != (*m_pOID2NameTable).end())     { 8       // don't write root data since it was already done       if(it == itRoot)       { 
         ++it;          continue;        }   ,       // write class name + terminating null       p = (*it).second;        while(*p != '\0')        {          file.put(*p);          ++p;       }        file.put('\0');          // write OID?       p = _RWSTD_REINTERPRET_CAST(const char *,&((*it).first)); !       file.write(p, sizeof(OID));          // write data <       p = _RWSTD_REINTERPRET_CAST(const char *,(*it).first);;       file.write(p, EZToolsBase::ObjectSize((*it).second));          ++it;      }        file.close();   T     // destroy (delete) root object for proper cleanup - this MUST be done after the7     // OID2NameTable is read and before it is destroyed 2     EZToolsBase::DestroyObject(pRootName, m_Root);  P     // if the root object was properly designed, the OID2NameTable should now be-     // empty, we test for this with an assert ,     assert((*m_pOID2NameTable).size() == 0);   }  // if(RecordCount > 0) T   else  // OID2NameTable is empty, remove existing output file, don't create new one   { 
     /*****Y     I could not find any mention in the ANSI C++ standard of a library function that will ^     delete a file.  The following "remove" function is an ANSI C library function.  Curiously,]     it requires #include <stdio> which was NOT done in this or any EZSave file, nevertheless,      it appears to work. 
     *****/     remove(m_pFileName);   }   9   delete m_pOID2NameTable;  // delete empty OID2NameTable   "   // invalidate current EZUniverse   m_pCurrentEZUniverse = 0;   2   // delete dynamic memory allocated for file name   delete m_pFileName;  }   D void EZUniverse::AddToOID2NameTable(OID oid, const char *pClassName) { 
   // set root    if(m_Root == 0)      m_Root = oid;   -   char *p = new char[strlen(pClassName) + 1];    strcpy(p, pClassName); #if defined(__DECCXX) 6   const pair<OID const, const char*> thePair(oid, p) ;=   bool bSuccess = (*m_pOID2NameTable).insert(thePair).second;  #else G   bool bSuccess = (*m_pOID2NameTable).insert(make_pair(oid, p)).second;  #endif   assert(bSuccess);  }   : void EZUniverse::AddToOID2OIDTable(OID oldOID, OID newOID) {  #if defined(__DECCXX) 6   const pair<OID const, OID> thePair(oldOID, newOID) ;<   bool bSuccess = (*m_pOID2OIDTable).insert(thePair).second; #else N   bool bSuccess = (*m_pOID2OIDTable).insert(make_pair(oldOID, newOID)).second; #endif   assert(bSuccess);  }   1 void EZUniverse::DeleteFromOID2NameTable(OID oid)  { 
   /********** _   It is an error to delete the root object from the OID2NameTable while there are other objects ^   in the table.  Don't confuse this with doing an EZDelete(EZPtr_to_root_object) on a universe^   with more than one persistent object.  If the root object is properly designed, the order ofW   destructor calls will guarantee that the root object is the last one to be destroyed. 
   **********/ =   assert(!(oid == m_Root && (*m_pOID2NameTable).size() > 1));   A   OID2NameTableType::iterator it = (*m_pOID2NameTable).find(oid);   *   assert(it != (*m_pOID2NameTable).end());     /*****[   Note: a const char * pointer can be deleted without a cast.  Apparently there is a bug in 3   VC++ 6.0 because the cast appears to be required.    *****/3   delete [] _RWSTD_CONST_CAST(char *,(*it).second);       (*m_pOID2NameTable).erase(it);  ;   // if the OID2NameTable is empty, there is no root object %   if((*m_pOID2NameTable).size() == 0)      m_Root = 0;  }   ) OID EZUniverse::ReadOID2OIDTable(OID old)  { >   OID2OIDTableType::iterator i = (*m_pOID2OIDTable).find(old);(   assert(i != (*m_pOID2OIDTable).end());   return (*i).second;  }   : void * operator new(size_t amount, const char *pClassName) {    // get current EZUniverse ;   EZUniverse *pUniverse = EZUniverse::GetCurrentUniverse();    assert(pUniverse != 0);   $   void *p  = ::operator new(amount);     assert(p != 0);   /   pUniverse->AddToOID2NameTable(p, pClassName);      return p;  }   % ////////// EZTools Section //////////   0 EZToolsBase::EZToolsBase(const char *pClassName) {    if(m_pEZToolsTable == 0)+     m_pEZToolsTable = new EZToolsTableType;      /*\     Leading characters of pClassName may be "class " since it comes from typeid().name(). If6     this is the case, remove these leading characters.   */E   if(strncmp("class ", pClassName, 6) == 0)  // strlen("class ") == 6      pClassName += 6;  -   char *p = new char[strlen(pClassName) + 1];    strcpy(p, pClassName);   #if defined(__DECCXX) F   const pair<const char* const, const EZToolsBase*> thePair(p, this) ;<   bool bSuccess = (*m_pEZToolsTable).insert(thePair).second; #else G   bool bSuccess = (*m_pEZToolsTable).insert(make_pair(p, this)).second;  #endif   assert(bSuccess);  }    EZToolsBase::~EZToolsBase()  {    /*****[   Objects of type EZTools are global static objects and will be destroyed at the end of the M   program.  This destructor will work regardless of the order of destruction.    *****/     if(m_pEZToolsTable != 0)   { ?     EZToolsTableType::iterator it = (*m_pEZToolsTable).begin(); )     while(it != (*m_pEZToolsTable).end())      { 3       delete _RWSTD_CONST_CAST(char *,(*it).first);        ++it;      }         delete m_pEZToolsTable;      m_pEZToolsTable = 0;   }  }   T // The following are the 3 "important" public static member functions of EZToolsBase6 size_t EZToolsBase::ObjectSize(const char *pClassName) {    assert(m_pEZToolsTable != 0);   F   EZToolsTableType::iterator it = (*m_pEZToolsTable).find(pClassName);)   assert(it != (*m_pEZToolsTable).end()); '   return ((*it).second)->vObjectSize();  }   > void EZToolsBase::FixPointers(const char *pClassName, OID oid) {    assert(m_pEZToolsTable != 0);   F   EZToolsTableType::iterator it = (*m_pEZToolsTable).find(pClassName);)   assert(it != (*m_pEZToolsTable).end()); $   ((*it).second)->vFixPointers(oid); }   @ void EZToolsBase::DestroyObject(const char *pClassName, OID oid) {    assert(m_pEZToolsTable != 0);   F   EZToolsTableType::iterator it = (*m_pEZToolsTable).find(pClassName);)   assert(it != (*m_pEZToolsTable).end()); &   ((*it).second)->vDestroyObject(oid); } 