#include "List.h"

#if defined(__DECCXX)
#include <stdlib.h>
#include <time.h>
#else
#include <cstdlib>  // for rand() - random number function
#include <ctime>    // for time() - used to seed random number generator
#endif

#if !defined(_RWSTD_NO_NAMESPACE)
using namespace EZSave;  // optional, exists in "list.h" also
#endif

int main()
{
  // create a universe
  EZUniverse *pEZUniverse = new EZUniverse("EZSave.dat");

  // get the root
  OID OIDofRoot = pEZUniverse->GetRoot();

  // create a pointer to the root object - type of root object is IntList
  EZPtr<IntListBase> pIntListBase;  // pIntListBase will point to IntList

  if(OIDofRoot == 0)
    // create a root object (IntList), put address into base pointer
    pIntListBase = EZNew(IntList);
  else
    // list is restored - insertions/deletions will be applied to the restored list
    pIntListBase = _RWSTD_STATIC_CAST(IntListBase *,OIDofRoot);

  // insert 15, 10, 15, 20 in list, delete 15 from list
  pIntListBase->vInsertInIntList(15);
  pIntListBase->vInsertInIntList(10);
  pIntListBase->vInsertInIntList(15);
  pIntListBase->vInsertInIntList(20);
  pIntListBase->vDeleteFromIntList(15);

  // now insert a random integer x >= 25 in list
  srand( (unsigned int) time(0) );  // seed random number generator with current time
  int nRandom = rand();
  if(nRandom < 25) nRandom += 25;
  pIntListBase->vInsertInIntList(nRandom);

  // print entire int list
  pIntListBase->vPrintIntList();

  // save the universe - EZSave then deletes the root object
  delete pEZUniverse;

  return 0;
}
