. *   Extr_Inp.For -- input routines for ExtractJ *                                                       Pat Rankin, Oct'882 *  i*4  Get_Next_File ( nextfile, nxt_len, multi ) *   "   Reset_Next_File ( ) , *  i*4  Open_Input_File ( filename, rabadr )4 *  i*4  Rfa_Position ( rab, nxt_rec, start, finish )7 *  i*4  Direct_Position ( rab, nxt_rec, start, finish ) ; *  sub  Determine_EOF ( fhc, last_record, lrecl, non_span ) 2 *  sub  Block_Info ( fab, fhc, last_block, lrecl )1 *  i*4  Block_Pos ( rab, nxt_rec, start, finish ) ' *  i*4  ReRead_Stream ( rab, prev_rfa )  *       E       integer *4 function  Get_Next_File ( nextfile, nxt_len, multi )  	!G 	!   Retreive the next filename (wildcard lookup or from command line).  	! 	implicit none C     called by:& *       program         Extract (main) C     2nd entry below:4 	integer *4      Reset_Next_File         !(not used) C     constant: : 	include '($RMSdef)/nolist'              !RMS status codesB 	include '($NAMdef)/nolist'              !rms file name block defs C     global input: 1 	include 'Extract.F'                     !options 
 C     output:  	character *(*)  nextfile  	integer *2      nxt_len 	logical         multi C     local: 	character *128  filespec  	integer *2      fspc_len  	logical         check_multi 	integer         idx  	integer *4      name_opts,  sts 	    data    idx /0/$ 	    save    idx, filespec, fspc_len C     functions: 	integer *4      Rms_Find_File   C     init if necessary  	if ( idx .eq. 0 ) then  	    idx = 18 	    call Get_Inp_Element( inp_cnt, %VAL(inp_list), idx,4      &                           filespec, fspc_len) 	    check_multi = .TRUE.  	else  	    check_multi = .FALSE. 	end if  C     search for the next file3 	sts = Rms_Find_File( filespec(:fspc_len), '[].;0', 9      &                      nextfile, nxt_len, name_opts) O C     if none found, move to the next file specification (if any) and try again 5 	if ( sts .eq. RMS$_NMF .and. idx .lt. inp_cnt ) then  	    idx = idx + 18 	    call Get_Inp_Element( inp_cnt, %VAL(inp_list), idx,4      &                           filespec, fspc_len)7 	    sts = Rms_Find_File( filespec(:fspc_len), '[].;0', =      &                          nextfile, nxt_len, name_opts)  	end if ? C     figure out whether we're trying to process multiple files  	if ( check_multi ) (      &          multi = ( inp_cnt .gt. 1@      &               .or. (name_opts .and. NAM$M_WILDCARD).ne. 0E      &               .or. (name_opts .and. NAM$M_SEARCH_LIST).ne. 0 ) M C     'multi' really determines whether to identify file before processing it  	if ( identify .eq. 1 ) then 	    multi = .true. ! 	else if ( identify .eq. 2 ) then  	    multi = .false. 	end if    	Get_Next_File = sts 	return    **        entry  Reset_Next_File ( ) 	! 	!   Clean up. 	! 	call Rms_Find_File_End()  	idx = 0   	Reset_Next_File = 1 	return -       end !of Get_Next_File & Reset_Next_File         G       integer *4 function  Open_Input_File ( filename, rabadr, stream )  	! 	!   Open the next input file. 	! 	implicit none C     called by:& *       program         Extract (main) C     constant: L *-      include '($CLIMSGdef)/list'             !(borrow a cli status value)G 	parameter       CLI$_INVRFM = '000388D2'x       !invalid record format D 	include '($DEVdef)/list'                !device characteristic defs? 	include '($FABdef)/list'                !rms File Access Block = 	include '($NAMdef)/list'                !rms file NAMe block A 	include '($RABdef)/list'                !rms Record Access Block G 	include 'f_inc:Xabs.F'                  !rms extended attribute blocks = 	byte            rAB_PROTOTYPE(2)    / RAB$C_BID, RAB$C_BLN / G *-      byte            xABDAT_PROTOTYPE(2) / XAB$C_DAT, XAB$C_DATLEN / @ 	byte            xABFHC_PROTOTYPE(2) / XAB$C_FHC, XAB$C_FHCLEN / 	parameter       bLKSIZ = 512 
 C     global:  	include 'Extract.F'# 	common /findfile_rmsdata/ fab, nam  	  record /fabdef/ fab 	  record /namdef/ nam( 	common /openfile_rmsdata/ rab, fhc, dat 	  record /rabdef/ rab 	  record /xabs/   fhc,  dat C     input:4 	character *(*)  filename        !(no longer needed)
 C     output:  	integer *4      rabadr  	logical         stream  C     local: 	logical         is_disk 	integer *4      sts,  stv C     functions:3 	integer *4      SYS$OPEN,  SYS$CONNECT,  SYS$CLOSE    	sts = 1  4 	is_disk = ( (fab.fab$l_dev .and. DEV$M_RND).ne. 0 ); 	buffer_required = ( (start_val .lt. 0 .or. end_val .lt. 0) .      &                   .and. .not. is_disk )L C     update fab (set access options in addition to previous lookup options)2 	fab.fab$b_fac = FAB$M_GET               !readonly 	if ( block_mode )J      &          fab.fab$b_fac = fab.fab$b_fac .or. FAB$M_BIO    !block i/o C-old-- O C-      fab.fab$b_shr = FAB$M_SHRGET            !share w/ readers (not writers) J C+new++  read any file that allows us access; somebody could delete one orM C+           more records out from under us though.  Relatively small risk... / 	fab.fab$b_shr = FAB$M_SHRGET .or. FAB$M_SHRPUT 6      &             .or. FAB$M_SHRDEL .or. FAB$M_SHRUPD> 	fab.fab$l_fop = FAB$M_NAM               !open using NAM blockJ C!       phony usage of function argument to suppress VARUNUSED diagnostic; 	fab.fab$l_fna = %LOC(filename)          !(not really used) A 	if ( start_val .eq. 1 .and. end_val .gt. 0 .or. buffer_required) P      &          fab.fab$l_fop = fab.fab$l_fop .or. FAB$M_SQO    !sequential onlyG 	fab.fab$l_xab = 0                       !clear old value (avoid loop!)  	if ( is_disk ) thenK C         set up xabs:  date & time xab and file header characteristics xab F *-          call LIB$MOVC5( 2, xABDAT_PROTOTYPE, 0, XAB$C_DATLEN, dat)- *-          dat.xab.xab$l_nxt = fab.fab$l_xab % *-          fab.fab$l_xab = %LOC(dat) ? 	    call LIB$MOVC5( 2, xABFHC_PROTOTYPE, 0, XAB$C_FHCLEN, fhc) & 	    fhc.xab.xab$l_nxt = fab.fab$l_xab 	    fab.fab$l_xab = %LOC(fhc) 	end if  C     set up rabF 	call LIB$MOVC5( 2, rAB_PROTOTYPE, 0, RAB$C_BLN, rab)    !bid,bln,0...; 	rab.rab$b_rac = RAB$C_SEQ               !sequential access A 	rab.rab$l_rop = RAB$M_RAH .or. RAB$M_NLK    !read ahead, no lock C C         request locate mode unless we plan buffer manipulation(s) * 	if ( ( buffer_required .or. .not. detab )[      &    .and. .not. use_vfc ) !want to keep full buffer control when treating vfc as data P      &          rab.rab$l_rop = rab.rab$l_rop .or. RAB$M_LOC    !use locate mode; 	rab.rab$b_mbf = 2                       !multibuffer count : 	rab.rab$b_mbc = 20                      !multiblock count: 	rab.rab$b_krf = key_index_byte          !key of reference9 	rab.rab$l_fab = %LOC(fab)               !link rab to fab 9 	rabadr = %LOC(rab)                      !output argument    C     open the file 9 	if ( SYS$OPEN( fab) ) then              !access the file F 	    if ( fab.fab$b_rfm .eq. FAB$C_UDF   !record format == 'undefined'+      &        .and. .not. block_mode ) then @ 		sts = CLI$_INVRFM       !invalid record format for our purpose	 	    else ; 		sts = SYS$CONNECT( rab)         !establish record context  	    end if D 	    if ( .not. sts )  call SYS$CLOSE( fab)      !give up if problem 	    stv = rab.rab$l_stv 	else  	    sts = fab.fab$l_sts 	    stv = fab.fab$l_stv 	end if !$open   	if ( sts ) thenB C         file successfully opened; perform some additional set-up 	    if ( block_mode ) then = 		rab.rab$l_ctx = ZEXT(fab.fab$w_bls) !block size (for tapes) 5 		if ( rab.rab$l_ctx .eq. 0 )  rab.rab$l_ctx = bLKSIZ   0 		call Block_Info( fab, fhc, last_record, lrecl)	 	    else @ 		rab.rab$l_ctx = ZEXT(fab.fab$b_fsz) !fixed-header size for vfc   		direct_access =( is_diskM      &                     .and. fab.fab$b_org .eq. FAB$C_SEQ     !sequential O      &                     .and. fab.fab$b_rfm .eq. FAB$C_FIX     !fixed-length H      &                     .and. (start_val .ne. 1 .or. end_val .lt. 0)) 		if ( direct_access )H      &            call Determine_EOF( fhc, last_record, lrecl, non_span) 	    end if  	end if !sts* 	stream = ( fab.fab$b_rfm .eq. FAB$C_STMLF1      &        .or. fab.fab$b_rfm .eq. FAB$C_STMCR 1      &        .or. fab.fab$b_rfm .eq. FAB$C_STM )    	Open_Input_File = sts 	return        end !of Open_Input_File                integer *4 function A      &    Rfa_Position ( rab, nxt_rec, start, finish, is_stream )  	!, 	!   Read an entire file, caching its rfa's;D 	!   recalculate starting & ending records based on new information;& 	!   position file at starting record. 	! 	implicit none C     called by:$ *       function        Process_File C     constant: : 	include '($RMSdef)/list'                !rms status codesF 	include '($RABdef)/list'                !rms Record Access Block defs 	structure /rfa/ 	    integer *4      block 	    integer *2      offset  	end structure !rfa ! 	parameter       cACHE_SIZ = 2048  C     global input:  	include 'Extract.F' C     input:9 	record /rabdef/ rab             !rms record access block E 	logical         is_stream       !requires special handling for $FIND 
 C     output: G 	integer *4      nxt_rec,        !next read will retreive this record # L      &                  start,  finish  !initial & final records of interest C     local:1 	record /rfa/    rfa,  prev_rfa,  rec(cACHE_SIZ), 8      &                  big(cACHE_SIZ),  huge(cACHE_SIZ)) 	integer         recpos,  bigpos, hugepos 7 	logical         got_start,  chk_stream,  stream_kludge  	integer *4      rec_cnt,  sts C     functions:@ 	integer *4      SYS$FIND,  SYS$GET,  SYS$REWIND,  ReRead_Stream 	intrinsic       MAX,  MIN  7 C     kludge for SYS$FIND vs. unterminated final record  	chk_stream = is_stream  	if ( chk_stream ) then  	    prev_rfa.block  = 0 	    prev_rfa.offset = 0 	end if  	stream_kludge = .false.   	sts = 1- C     read the file, caching record addresses  	rec_cnt = 0 	recpos = 0  	bigpos = 0  	hugepos = 0 	got_start = .false. 	do while ( sts )  	    sts = SYS$FIND( rab)  	    if ( chk_stream ) then  		if ( sts .eq. RMS$_EOF ) then ) 		    sts = ReRead_Stream( rab, prev_rfa) - 		    stream_kludge = ( (sts .and. 1).ne. 0 )  		    chk_stream = .false. 		else& 		    prev_rfa.block  = rab.rab$l_rfa0& 		    prev_rfa.offset = rab.rab$w_rfa4 		end if 	    end if & 	    if ( sts )  rec_cnt = rec_cnt + 1   	    if ( got_start ) thenF C               do nothing [except continue counting 'til end of file]G 	    else if ( rec_cnt .eq. start_val ) then     !only if start_val > 04 		rfa.block  = rab.rab$l_rfa0c 		rfa.offset = rab.rab$w_rfa4e: 		got_start = .true.      !'rfa' will retain current value	 	    elsef 		rfa.block  = rab.rab$l_rfa0  		rfa.offset = rab.rab$w_rfa4  		recpos = recpos + 14# 		if ( recpos .gt. cACHE_SIZ ) then  		    bigpos = bigpos + 1n= 		    if ( bigpos .gt. cACHE_SIZ ) then   !extremely unlikelyt 			hugepos = hugepos + 1: 			if ( hugepos .le. cACHE_SIZ )   !(impossible to exceed)6      &                          huge(hugepos) = big(1)
 			bigpos = 1r 		    end if 		    big(bigpos) = rec(1) 		    recpos = 1 		end if  		rec(recpos).block  = rfa.block! 		rec(recpos).offset = rfa.offsets 	    end if$ 	end doo" 	if ( sts .eq. RMS$_EOF )  sts = 1  ? C     we can now determine proper values for for start & finish  	if ( start_val .le. 0 ) then / 	    start = MAX( (rec_cnt + 1) + start_val, 1)l 	elseg 	    start = start_val 	end if  	if ( end_val .le. 0 ) theni. 	    finish = MAX( (rec_cnt + 1) + end_val, 0) 	else $ 	    finish = MIN( end_val, rec_cnt) 	end ifs   C     re-position file( 	if ( sts .and. start .le. finish ) then 	    if ( got_start ) then2 		nxt_rec = start         !'rfa' has desired valueI 	    else if ( (rec_cnt - start + 1) .le. cACHE_SIZ ) then !within last nV! 		recpos = MOD( start, cACHE_SIZ) * 		if ( recpos .eq. 0 )  recpos = cACHE_SIZ 		rfa = rec(recpos) 9 		nxt_rec = start         !no. of record about to be readf$ 	    else if ( (rec_cnt - start + 1)P      &             .le. cACHE_SIZ * cACHE_SIZ + recpos ) then !with last n^2 + m' 		bigpos = ((start - 1)/ cACHE_SIZ) + 1t" 		bigpos = MOD( bigpos, cACHE_SIZ)* 		if ( bigpos .eq. 0 )  bigpos = cACHE_SIZ 		rfa = big(bigpos)t( 		nxt_rec = (bigpos - 1) * cACHE_SIZ + 1 	    else    !** NOT TESTED **!)6 		hugepos = ((start - 1)/ (cACHE_SIZ * cACHE_SIZ)) + 1$ 		hugepos = MIN( hugepos, cACHE_SIZ) 		rfa = huge(hugepos) 5 		nxt_rec = (hugepos - 1) * cACHE_SIZ * cACHE_SIZ + 1m 	    end ifd& C         setup position for next readG 	    if ( stream_kludge .and. start .eq. rec_cnt ) then      !"/tail=1"t= 		rfa = prev_rfa                  !back up to previous record.	 	    elseC< 		stream_kludge = .false.         !no additional fixup neeed 	    end ife5 	    if ( stream_kludge .and. rfa.block .eq. 0 ) thent7 		sts = SYS$REWIND( rab)          !start at top of fileh; 		stream_kludge = .false.         !don't get a record below 	 	    else=O C             set rfa and fetch record (into position for next sequential read)x 		rab.rab$l_rfa0 = rfa.block 		rab.rab$w_rfa4 = rfa.offset 1 		rab.rab$b_rac = RAB$C_RFA       !access via rfa 4 		sts = SYS$FIND( rab)            !locate the record< 		rab.rab$b_rac = RAB$C_SEQ       !restore sequential access 	    end if!( 	    if ( stream_kludge .and. sts ) thenB 		sts = SYS$GET( rab)     !read a record iff we have backed up oneB 		if ( sts .eq. RMS$_RTB )  sts = RMS$_NORMAL  !ignore rec too big 	    end ifa 	elseuG 	    nxt_rec = rec_cnt + 1       !beyond EOF (forces end of processing)a 	end ifu  4 	if ( sts .eq. RMS$_NORMAL )  sts = 1    !SS$_NORMAL 	Rfa_Position = stsA 	returnt       end !of Rfa_Position               integer *4 functioni;      &      Direct_Position ( rab, nxt_rec, start, finish )/ 	!B 	!   Calculate & set record position for fixed length record file. 	! 	implicit none C     called by:$ *       function        Process_File C     constant:CF 	include '($RABdef)/list'                !rms Record Access Block defs 	structure /rfa/ 	    integer *4      block 	    integer *2      offset$ 	end structure !rfar 	integer *4      bLKSIZ 9 	parameter     ( bLKSIZ = 512 )          !bytes per block/ C     global input:  	include 'Extract.F' C     input:9 	record /rabdef/ rab             !rms record access blocke
 C     output:rG 	integer *4      nxt_rec,        !next read will retreive this record # L      &                  start,  finish  !initial & final records of interest C     local: 	record /rfa/    rfa; 	integer *4      ltmp,  rcrds_per_block,  even,  xtra,  stsg C     functions: 	integer *4      SYS$FIND  	intrinsic       MAX,  MOD   	start = start_val 	if ( start .le. 0 )8      &          start = MAX( 1, last_record + 1 + start) 	finish = end_val  	if ( finish .le. 0 )i:      &          finish = MAX( 0, last_record + 1 + finish)   	sts = 1 	nxt_rec = 1 	if ( start .gt. 1 ) then  C         calculate rfa A 	    ltmp = lrecl + (lrecl .and. 1)      !round up to even numberF 	    if ( non_span ) thenl< 		rcrds_per_block = bLKSIZ / ltmp         !records per block/ 		rfa.block = (start - 1) / rcrds_per_block + 1t6 		rfa.offset = MOD( start - 1, rcrds_per_block) * ltmp< 	    else        !(beware of overflow near end of huge file)= *               rfa.block = ((start - 1) * ltmp) / bLKSIZ + 1 = *               rfa.offset = MOD( (start - 1) * ltmp, bLKSIZ)b 		even = (start - 1) / bLKSIZ & 		xtra = (start - 1) - (bLKSIZ * even)6 		rfa.block = even * ltmp + (xtra * ltmp) / bLKSIZ + 1( 		rfa.offset = MOD( xtra * ltmp, bLKSIZ) 	    end ifl! C         set rfa & position filen 	    rab.rab$l_rfa0 = rfa.blocku  	    rab.rab$w_rfa4 = rfa.offset8 	    rab.rab$b_rac = RAB$C_RFA           !access via rfa; 	    sts = SYS$FIND( rab)                !locate the recorddC 	    rab.rab$b_rac = RAB$C_SEQ           !restore sequential accessa 	    nxt_rec = start 	end ifc   	Direct_Position = sts 	return        end !of Direct_PositionA        E       subroutine  Determine_EOF ( fhc, last_record, lrecl, non_span )$ 	!D 	!   Using file header data, figure how many records are in the file< 	!   (only appropriate for files with fixed length records). 	! 	implicit none C     called by:' *       function        Open_Input_FileT C     constant:,I 	include '($XabFHCdef)/nolist'           !file header characteristics xablD 	include '($FABdef)/nolist'              !rms File Access Block defs 	integer *4      bLKSIZ 9 	parameter     ( bLKSIZ = 512 )          !bytes per block  C     input:2 	record /xabfhcdef/ fhc          !file header info
 C     output: F 	integer *4      last_record,    !calculated number of records in fileN      &                  lrecl           !longest record's length (limited use)C 	logical         non_span        !flag for non-block-span attribute  C     local:! 	integer *4      ltmp,  ebk,  ffby C     functions: 	intrinsic       ZEXT,  MODb    	last_record = 0         !(temp)I 	non_span = ( (fhc.xab$b_atr .and. FAB$M_BLK).ne. 0 )    !(fab.fab$b_rat) I 	lrecl = ZEXT(fhc.xab$w_mrz)     !maximum record size    !(fab.fab$w_mrs)eK 	if ( lrecl .eq. 0 .or. non_span .and. lrecl .gt. bLKSIZ ) return !(never!)'  3 	ebk = fhc.xab$l_ebk             !end-of-file block ; 	ffb = fhc.xab$w_ffb             !first free byte within it ? 	ltmp = lrecl + (lrecl .and. 1)  !round up to even no. of bytesx 	if ( non_span ) theni9 	    last_record = bLKSIZ / ltmp * (ebk - 1) + ffb / ltmpl* 	else    !(beware overflow for huge files)U *           last_record = (bLKSIZ * (ebk - 1) + ffb) / ltmp !(overflow iff ebk >= 4M) 0 	    last_record = ( (ebk - 1) / ltmp ) * bLKSIZD      &                  + ( MOD( ebk - 1, ltmp) * 512 + ffb ) / ltmp 	end if    	return        end !of Determine_EOFl        <       subroutine  Block_Info ( fab, fhc, last_block, lrecl ) 	!C 	!   Using file header data, figure how many blocks are in the filefB 	!   (and determine whether it's safe to retain record structure). 	!* 	!   Note:  tape handling is insufficient. 	! 	implicit none C     called by:' *       function        Open_Input_FileI C     constant:tI 	include '($XabFHCdef)/nolist'           !file header characteristics xab)D 	include '($FABdef)/nolist'              !rms File Access Block defs 	parameter       bLKSIZ = 512  C     input:D 	record /fabdef/ fab             !input file's rms file access block2 	record /xabfhcdef/ fhc          !file header info
 C     output:rK 	integer *4      last_block,     !size of file (blocks used, not allocated)IM      &                  lrecl           !record length iff safe to preserve -xO C     local:                            !+ record structure in extracted blocks' 	integer *4      ltmp,  blk  C     functions: 	intrinsic       ZEXT,  MOD    	blk = ZEXT(fab.fab$w_bls)  	if ( blk .eq. 0 )  blk = bLKSIZ  3 	last_block = fhc.xab$l_ebk      !end-of-file blocko/ 	if ( blk .ne. bLKSIZ .and. last_block .gt. 0 ) 6      &          last_block = last_block * blk / bLKSIZ  G C     zero-out record length if input is not fixed-length records whichb< C         evenly within blocks or non-block-spanned records.I 	lrecl = ZEXT(fhc.xab$w_mrz)     !maximum record size    !(fab.fab$w_mrs) 2 	if ( (fab.fab$b_rat .and. FAB$M_BLK).eq. 0 ) thenC 	    ltmp = lrecl + (lrecl .and. 1)  !round up to even no. of bytesi; 	    if ( lrecl .ne. 0 .and. ( fab.fab$b_rfm .ne. FAB$C_FIXr>      &                           .or. MOD( blk, ltmp) .ne. 0 )      &      )  lrecl = 01 	end if !file's records may span block boundaries:   	returnr       end !of Block_Info        D       integer *4 function  Block_Pos ( rab, nxt_rec, start, finish ) 	!? 	!   Calculate & set block position for direct access by block.c 	! 	implicit none C     called by:$ *       function        Process_File C     constant: F 	include '($RABdef)/list'                !rms Record Access Block defs C     global input:f1 	include 'Extract.F'                     !optionsr C     input/output: F 	record /rabdef/ rab             !input file's rms record access block
 C     output:rF 	integer *4      nxt_rec,        !next read will retreive this block #K      &                  start,  finish  !initial & final blocks of interest= C     functions: 	intrinsic       MAX   	start = start_val 	if ( start .le. 0 )8      &          start = MAX( 1, last_record + 1 + start) 	finish = end_vala 	if ( finish .le. 0 ) :      &          finish = MAX( 0, last_record + 1 + finish)  F 	if ( start .gt. 1 )  rab.rab$l_bkt = start      !read this block next 	nxt_rec = start   	Block_Pos = 1   !SS$_NORMAL 	return=       end !of Block_Pos         :       integer *4 function  ReRead_Stream ( rab, prev_rfa ) 	!C 	!   Stream format files may have an unterminated record at the endnA 	!   that SYS$FIND will miss.  ANALYZE/RMS reports this situation=3 	!   as an error, but SYS$GET handles it just fine.l 	! 	implicit none C     called by:$ *       function        Process_File C     constant:r; 	include '($RMSdef)/list'                !rms status valuestF 	include '($RABdef)/list'                !rms Record Access Block defs 	structure /rfa/ 	    integer *4      block 	    integer *2      offsetC 	end structure !rfal C     input: 	record /rabdef/ rab 	record /rfa/    prev_rfai C     local: 	integer *4      sts C     functions:0 	integer *4      SYS$GET,  SYS$FIND,  SYS$REWIND  G C     set rfa and fetch record (into position for next sequential read)d" 	if ( prev_rfa.block .ne. 0 ) then$ 	    rab.rab$l_rfa0 = prev_rfa.block% 	    rab.rab$w_rfa4 = prev_rfa.offset 8 	    rab.rab$b_rac = RAB$C_RFA           !access via rfa@ 	    call SYS$FIND( rab)                 !locate previous recordC 	    rab.rab$b_rac = RAB$C_SEQ           !restore sequential access > 	    call SYS$GET( rab)                  !read previous recordB 	else    !couldn't find first record, but it may actually be thereF 	    call SYS$REWIND( rab)               !there was no previous record 	end ifeD 	sts = SYS$GET( rab)                 !attempt to read another record, 	if ( sts .eq. RMS$_RTB )  sts = RMS$_NORMAL   	ReRead_Stream = sts 	return        end !of ReRead_Streame