$! GRAB_SPLIT.COM
$! --------------
$! Split file P1 into chunks of P2 records
$!
$! This procedure demonstrates the /CONTEXT, /LIMIT, and /SAVE features.
$!
$! The /LIMIT qualifier is used to limit the output to a specific number of
$! records. The /CONTEXT qualifier is used start subsequent search operations
$! at the next record. The /SAVE=STATUS qualifier is used to obtain status
$! information to determine when all records in the file have been processed.
$!
$! ---------------------------------------------------------------------------
$!
$	on warning then exit $status
$	on control_y then exit %x2
$  !
$	wo = "write sys$output"
$  !
$	if P2 .eqs. ""
$	  then	write sys$error "Usage: @GRAB_SPLIT file records_per_chunk"
$		exit
$	endif
$  !
$	input_fn = f$search(P1)
$	if input_fn .eqs. ""
$	  then	write sys$error "ERROR - no such file: ", P1
$		exit %x2
$	endif
$	n = f$integer(P2)
$	if n .lt. 1
$	  then	write sys$error "ERROR - invalid records_per_chunk: ", P2
$		exit %x2
$	endif
$  !
$	wo f$fao("GRAB_SPLIT!/ file = !AS!/ records per chunk = !SL" -
		, input_fn, n)
$  !
$  ! Prefix for the output file
$  !
$	out_prefix = input_fn - f$parse(input_fn,,,"VERSION") + "_CHUNK_"
$  !
$  ! We need to ensure we get a new context for the first search, we could:
$  !	1) $SET SYMBOL/SCOPE=NOLOCAL to isolate us from outer local symbols
$  !	2) Use /NEW_CONTEXT on first pass
$  !	3) Initialise the context symbol to ""
$  !
$	ctx = ""
$	c = 1
$ LOOP:
$	out_fn = f$fao("!AS!SL", out_prefix, c)
$	wo f$fao("!/Split #!SL ...", c)
$  !
$	grab/log/save=(status)/context=ctx/limit='n'/out='out_fn' 'P1' ""
$  !
$	wo f$fao(" status = !AS!/ chunk = !AS", grab_status, out_fn)
$	if grab_status .eqs. "%LIMITED"
$	  then	c = c + 1
$		goto LOOP
$	  else	if grab_status .nes. "%NORMAL"
$		  then	exit %x2
$		endif
$	endif
$  !
$	wo f$fao("!/File split into !SL chunk!%S", c)
$!
$	exit
