/*
 * Define routiens for traversing bodypart sections within a bookreader
 * file.
 */

int bks_create_section_cursor ( void *bkf_ctx, void **cursor );
int bks_delete_section_cursor ( void *cursor );
/*
 * Seek_section input args corresponde to fseek():
 *   direction = 0 -> offset is absolute.
 *   direction = 1 -> offset is relative to current position.
 *   direction = 2 -> offset is relative to end (unimplemented).
 * Seeking to a section prepares the section for subtext scans, seeking
 * to (cursor,0,1) resets context for the current cursor.
 */
int bks_seek_section ( void *cursor, int offset, int direction,
	int *type, int *length, long hdr[9] );
int bks_read_section ( void *cursor, 
	int *type, 		/* text_rec type: 0, 1, 2, 3 */
	short *h_v, 		/* horiz/vert */
	unsigned char attr[4], 	/* cont, x, y, spare */
	int *length, 		/* Legnth of data */
	char **data, 		/* Pointer to data inside record buffer,
				 * becomes invalid on next seek */
	int *is_last );         /* 0 more, 1 - end of sect, 2 -end of part */

int bks_seek_part ( void *cursor, int part, int dir, int *sect_cnt );

int bks_get_cursor_info ( void *cursor, 
	int parts_info[4], 	/* 0-cur_part, 1-prev, 2-next, 3-reserved */
	int sect_info[4] );	/* 0-first_sect, 1-sect_count, 2-cur_sect */
