/*
 *  Define routines to access an indexed file by zero-terminated subfields
 * within the records.  Caller is responsible for padding fixed fields.
 */
#include "access_db.h"

struct subfield_item {		/* List element */
    int size;			/* If zero, variable key */
    char *name;
    char *value;
};
struct subfield_context {	/* context */
    int item_count;		/* Array size / array used */
    int rec_limit, rec_size;
    IFILE *db;				/* indexed file */
    char hdr_data[32];			/* optional data in header record */
    struct subfield_item *fld;
    char *fld_names;
    char *key;				/* Current key value, padded */
    char *rec;
    char *outrec;			/* only initialized if needed */
};
typedef struct subfield_context *subfield_ctx;

int subfield_open ( char *db_name,		/* file name */
		    char *mode,			/* "r" or "r+" */
		    int rec_limit,		/* max record size. */
		    subfield_ctx ctx );

int subfield_close ( subfield_ctx ctx );

/* 
 * specify a key_size of zero for sequential read
 */
int subfield_read ( subfield_ctx ctx, char *key, int key_num, int key_size );
/* 
 * Return string is null is name not matched in field list.
 */
char *subfield_value ( subfield_ctx ctx, char *name );
/*
 * Record is built into contiguous area using field items.
 */
int subfield_set ( subfield_ctx ctx, char *name, char *value );
int subfield_write ( subfield_ctx ctx );
int subfield_update ( subfield_ctx ctx );
int subfield_delete_rec ( subfield_ctx ctx );
int subfield_update_header ( subfield_ctx ctx, int (*update_cb)(subfield_ctx) );
