$!
$! Convert HTTP server configuration file to non-preprocessed form to allow
$! easier non-script editting.  The standard pre-processor rules are expaned, 
$! additional rule declared with .IGNORE are preserved.  Folded lines (ending 
$! in \) are converted to single lines.
$!
$! Parameters:
$!   P1		Input file
$!   P2		Output file
$!   P3		Option selection, if set to the string "INCLUDE", will perform
$!		nested reads.
$!
$ if p1 .eqs. ""
$ then
$     write sys$error "P1 must specify name of input file.
$    exit
$ endif
$ nest_include = 0
$ if p3 .eqs. "INCLUDE" then nest_include = 1
$!
$ if f$trnlnm("WWW_SYSTEM") .eqs. "" then define www_system sys$disk:[]
$!
$ inp_level = 0
$ out_level = 0
$ on error then goto cleanup
$ on control_y then goto cleanup
$ include_file = f$search(P1)		! get version number
$ if include_file .eqs. ""
$ then
$    write "Configuration file ", P1," not found"
$    exit
$ endif
$ if p2 .eqs. "" then P2 = "sys$output"
$ create 'P2'		! make normal text file.
# This file was created by convert_config.com.
#
$ open/append out1 'p2'
$ out_level = 1
$ known_directives = ".DEFINE.EXPAND.ITERATE.NEXT."
$!
$ start_level:
$ write sys$output "## File ", include_file, "##"
$ next_level = inp_level+1
$ open/read inp'next_level' 'include_file'/error=open_error
$ inp_level = inp_level+1
$ inp_name'inp_level' = include_file
$ next_line:
$     read inp'inp_level' line/end=file_done
$     line_len = f$length(line)
$ append_extension:
$     if line_len .eq. 0 then goto scan_line
$     if f$extract(line_len-1,1,line) .nes. "\" then goto scan_line
$	line = f$extract(0,line_len-1,line) + " "
$	read  inp'inp_level' line_x
$	line = line + f$edit(line_x,"TRIM")
$	line_len = f$length(line)
$	goto append_extension
$ scan_line:
$	out_line = line
$	line = f$edit(line,"TRIM,COMPRESS")
$	if f$length(line) .eq. 0 then goto output_line
$	if f$extract(0,1,line) .eqs. "#" then goto output_line
$	comment = f$locate(" #",line)
$	line = f$extract(0,comment,line)	! trim comments
$	if f$extract(0,1,line) .nes. "." then goto output_line
$	   cmd = f$edit(f$element(0," ",line),"UPCASE")
$	   arg1 = f$element(1," ",line)
$	   arg2 = f$extract(f$length(cmd+arg1+"  "),1000,line)
$	   if cmd .eqs. ".DEFINE" then sym'inp_level'_'arg1' = arg2
$	   if cmd .eqs. ".DEFINE" then goto next_line
$	   if cmd .eqs. ".EXPAND" then gosub expand_line
$	   if cmd .eqs. ".ITERATE" then gosub iterate_setup
$	   if cmd .eqs. ".ITERATE" then goto next_line
$	   if cmd .eqs. ".NEXT" then gosub iterate_line
$!
$	   if f$locate(cmd+".",known_directives) .GE. -
		f$length(known_directives) then goto output_line
$	   line = out_line
$	   goto scan_line		! rescan line
$!
$ output_line:
$	if nest_include .and. -
	   f$edit(f$element(0," ",line),"UPCASE") .eqs. "INCLUDE" 
$	then
$	   include_file = f$element(1," ",line)
$	    goto start_level
$	endif
$	write out'out_level' out_line
$	goto next_line
$ file_done:
$     close inp'inp_level'
$    inp_level = inp_level - 1
$    write sys$Output "## {EOF} ##"
$    if inp_level .gt. 0 then goto next_line
$    write sys$output "Successfulling scanned file"
$    goto cleanup
$!
$ open_error:
$    write sys$output "Error opening ", include_file
$    if inp_level .gt. 0 then goto next_line
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$! Close open files.
$!
$ cleanup:
$   set noon
$   if inp_level .GT. 0
$   then
$      close inp'inp_level'
$      inp_level = inp_level - 1
$      goto cleanup
$   endif
$ clenaup_out:
$   if out_level .GT. 0
$   then
$      close out'out_level'
$      out_level = out_level - 1
$      goto cleanup
$   endif
$  exit
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$! Subroutines for handling pre-processor directives.
$! input symbols:
$!    cmd	pre-processor command
$!    arg1	First token following command
$!    arg1	Remainder of line
$!    inp_level	Scope nesting level
$!    line
$!    sym'inp_level'_name	symbol value for symbol 'name'
$! modified symbols:
$!    out_line	Re-written line.
$!    pat'inp_level'_name	iteration place-holders.
$!!!
$ expand_line:
$    out_line = ""
$    i = 1		! skip the .expand
$ expand_line_sym:
$    token = f$element(i," ",line)
$    if token .eqs. " " then return
$    if f$extract(0,1,token) .eqs. "$"
$    then
$	sym_name = "sym"+f$string(inp_level)+"_"+f$extract(1,30,token)
$       if f$type('sym_name') .eqs. "" then 'sym_name' = "*UNDEFINED*"
$	token = 'sym_name'
$	if token .eqs. " " then token = "#"		! restore comment
$	if token .eqs. "" then token = "#"		! restore comment
$    endif
$    if i .gt. 1 then out_line = out_line + " "
$    out_line = out_line + token
$    i = i + 1
$    goto expand_line_sym
$!!!!!!!!
$ iterate_setup:
$    pattern'inp_level' = line
$    return
$!!!!!!!!
$ iterate_line:
$    out_line = ""
$    pattern = pattern'inp_level'
$    i = 1		! Patttern position, skip the .iterate
$    j = 1		! parameter position, skip the .next
$ expand_i_line:
$    token = f$element(i," ",pattern)
$    if token .eqs. " " then return
$    if f$extract(0,1,token) .eqs. "$"
$    then
$!	replace token in pattern with next token in .next line
$!
$	token = f$element(j," ",line)
$	if token .eqs. " " then return	! missing argument, abort
$	j = j + 1
$    endif
$    if i .gt. 1 then out_line = out_line + " "
$    i = i + 1
$    out_line = out_line + token
$    goto expand_i_line
$   return
