$!								2-APR-1996
$!
$! This command procedure runs the http_server.exe image and must reside
$! in the same directory.  It takes the following parameters:
$!
$!	Param.	  Default		Description.
$!	P1	RUN		Mode option:
$!				   RUN		Run server image.
$!				   MBXNET	Run mbxnet_acp with this
$!						procedure as client proc.
$!
$!      P2  -	HTTP_SERVER_ERR.LOG Log file name.  File will default to same
$!				directory as this procedure.  May include
$!				log_level by appending /{level}
$!
$!      P3  -   HTTP_MAIN.CONF	Configuration file name.  This file is
$!				also known as the rules file.  File will 
$!				default to same directory as this procedure.
$!
$!	P4  -    80		TCP port number that server will listen on.
$!
$!	P5  -    		TCP port number that server will listen on
$!				with cache disabled.
$!
$! Note that if http_server.exe is to be installed with privilege, then you 
$! must also install sys$share:cma$lib_shr.exe, sys$share:cma$open_rtl.exe, 
$! and sys$share:cma$rtl.exe.
$!
$ proc = f$parse(f$environment("PROCEDURE"),,,,"NO_CONCEAL")
$! Define DCL symbols that HTTP_SERVER will read as environment variables.
$!
$ if f$type(HTTP_CLIENT_LIMIT) .eqs. "" then -
    HTTP_CLIENT_LIMIT = 100		! Max. number of concurent clients.
$ HTTP_LOG_LEVEL = 0			! Level of detail in log file.
$ HTTP_CRLF_NEWLINE = 1			! set to zero to use just LF
$ HTTP_PEEK_PFLAG = 0			! create temporary mailbox HTTP_PEEK
$!
$! Make default for default host name, this will work with both UCX and
$! multinet.
$!
$ if f$type(http_default_host) + f$trnlnm("HTTP_DEFAULT_HOST") .eqs. "" 
$ then
$	hname = f$trnlnm("UCX$INET_HOST")
$	if f$locate(".",hname) .ge. f$length(hname) then -
		hname = hname + "." + f$trnlnm("UCX$INET_DOMAIN")
$ 	if hname .nes. "." then -
		write sys$output "Using default host name of ",hname
$	HTTP_DEFAULT_HOST = hname
$ endif
$ if "''http_default_host'" .eqs. "."   ! OK no host name, try for CMU
$ then
$       hname = f$trnlnm("INTERNET_HOST_NAME")
$	if hname .eqs. ""		! try for TWG
$	then
$	    hname = f$trnlnm("ARPANET_HOST_NAME")
$	    if f$locate(".",hname) .ge. f$length(hname) then -
		hname = hname + "." + f$trnlnm("INET_DOMAIN_NAME")
$	    if hname .eqs. "." then hname = "?hostname?"
$	endif
$       write sys$output "Using default host name of ",hname
$       HTTP_DEFAULT_HOST = hname
$ endif
$! if f$getsyi("CPU") .ge. 128 then http_reentrant_c_rtl == 1
$!
$! Define www_root and www_system logicals if not defined.
$!
$ mode = f$mode()
$ if mode .eqs. "INTERACTIVE" .OR. f$trnlnm("www_root") .eqs. ""
$ then
$    if mode .eqs. "INTERACTIVE" then write sys$Output -
	"Making interactive definition of WWW_ROOT and WWW_SYSTEM"
$    root_dir = f$parse("1.;",proc,,,"NO_CONCEAL,SYNTAX_ONLY") - "][" - "]1.;"
$    l = f$length(root_dir)
$ trim_last:
$    l = l - 1
$    if f$extract(l,1,root_dir) .nes. "." .and. l .gt. 0 then goto trim_last
$    root_dir = f$extract(0,l,root_dir) + ".]"
$    table = ""
$    if p1 .eqs. "MBXNET" then table = "/job"
$    write sys$output "Defining www_root as ", root_dir
$    define/nolog 'table' www_root 'root_dir'/trans=(term,conceal)
$ endif
$ if mode .eqs. "INTERACTIVE" .or. f$trnlnm("www_system") .eqs. ""
$ then
$    sys_dir = f$parse("1.;",proc,,,"NO_CONCEAL,SYNTAX_ONLY") - "][" - "]1.;"
$    sys_dir = sys_dir + "]"
$    write sys$output "Defining www_system as ", sys_dir
$    table = ""
$    if p1 .eqs. "MBXNET" then table = "/job"
$    define/nolog 'table' www_system 'sys_dir'
$ endif
$ if mode .eqs. "INTERACTIVE" .or. f$trnlnm("http_base_mst") .eqs. "" then -
	define http_base_mst www_system:http_base_mst
$!
$! Give warning if no timzone.
$!
$ if f$trnlnm("SYS$TIMEZONE_DIFFERENTIAL") .eqs. ""
$ then
$    type sys$Input
Warning, sys$timezone_differential is undefined, so local time for file
dates will be reported as GMT time of file.  SYS$TIMEZONE_DIFFERENTIAL
should translate to number of seconds offset to add to local time to
get UTC time (.e.g EDT is -18000).
$ endif
$!
$ P1 = f$edit(P1,"UPCASE")
$ if P1 .eqs. "" THEN P1 = "RUN"
$ IF P1 .nes. "RUN" THEN GOTO ALT_MODE
$!
$! Setup command line arguments, Make this procedure name the related file
$! to default it to the same directory.
$!
$ log_level = f$element(1,"/",P2)
$ if log_level .nes. "/" .and. log_level .nes. "" then http_log_level = log_level
$ log_file = f$parse(f$element(0,"/",P2),"HTTP_SERVER_ERR.LOG",proc)
$ if log_file .eqs. "" then write sys$output "Error in log file parse: ", -
	f$element(0,"/",P2)
$ rules_file = f$parse(P3,"HTTP_MAIN.CONF",proc)
$ if rules_file .eqs. "" then write sys$output "Error in rule file parse: ",P3
$!
$! Run server as foreign command, specifying rules file determined above.
$! Server failures cause an automatic restart unless less than 10 minutes
$! have past since the previous restart.
$!
$ httpd = "$ www_system:http_server.exe"
$ server_restart:
$ on error then goto error_restart
$ restart_after = f$cvtime("+00:10:00")
$ httpd "''log_file'" "''rules_file'" "''P4'" "''P5'" 'P6'
$ exit $status
$ error_restart:
$ if f$cvtime(f$time()) .gts. restart_after then goto server_restart
$ exit $status
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$! Handle special functions for HTTP_SERVER:
$ ALT_MODE:
$ if P1 .eqs. "MBXNET"
$ then
$!
$!    Kluge for systems without decnet to allow scripts to run.  Enforce
$!    more restrictive client limit to account for resource usage by
$!    script processes.
$!
$     bytlm = f$getjpi("0","BYTCNT")
$     cand_limit = bytlm / 10000
$     if cand_limit .lt. 3 then cand_limit = 3
$     if cand_limit .lt. http_client_limit then http_client_limit = cand_limit
$!
$!    Script processes inherit RMS default but not the process logicals,
$!    therefore expand the current default mbxnet_system location to
$!    bare device/directory.
$!
$     defdir = f$environment("DEFAULT")
$     defdir_exposed = f$parse(defdir,,,,"NO_CONCEAL") - "][" - "><" - ".;"
$     server_proc = f$parse("www_system:mbxnet_server.com;",,,,"NO_CONCEAL")
$     server_proc = server_proc - "MBXNET_SERVER.COM;"
$     table_qual = "/job"
$     if "''mbxnet_server_detach'" then table_qual = "/group/log/exec"
$     define 'table_qual' mbxnet_system 'server_proc'
$!
$!    Create overlord process to manage script processes, http_server is
$!    run as a sub-process.
$!
$     mbxnet = "$www_system:mbxnet_acp"
$     set noon
$     set default 'defdir_exposed'
$     mbxnet 'proc' "RUN" "''P2'" "''P3'" "''P4'" "''P5'" "''P6'"
$     mstatus = $status
$     set default 'defdir'
$     exit mstatus
$ endif
$    write sys$output "Invalid P1 parameter, must be RUN.
$    exit 20
