 	PROGRAM EXECSYMB H CDEC$ IDENT 'V3.6.1--26Jun94' ! (modify other references below as well!) C ' C	EXECSYMB -- Executive Server Symbiont  C  C	Version V3.6.1 C . C	Version 1 written 21-Jan-1986 by John Osudar. C	Version 2 written 10-Feb-1986 by John OsudarE C	Version 3 converted from version 2.32 on 20-Jun-1989 by John Osudar  C  C	Modification history:  C F C	1.00 21-Jan-1986 Created initial version (CMDSYMB) from test programB C	2.00 10-Feb-1986 Created version 2 (EXECSYMB) from CMDSYMB V1.05G C	2.01 11-Feb-1986 Modified to specify spool directory, do ENTER/REMOVE 4 C	2.02 12-Feb-1986 Fixed ASCII stream item edit code; C	2.03 12-Feb-1986 Added subprocess termination recognition J C	2.04 14-Feb-1986 Modified for general item selection, better wakeup codeC C	2.05 14-Feb-1986 Added PARSEMSG to end of code, removed ITEM_CONV ) C	2.06 26-Feb-1986 Fixed PARSE_ITEMS code G C	2.07 28-Feb-1986 Added CHECKPOINT/NOCHECKPOINT, COPY=(FIRST,LAST,ALL) G C	2.08 04-Mar-1986 Added code to set queue JOB_RESET_MODULES to reflect 4 C			 non-default options that were actually selectedD C	2.09 05-Mar-1986 Fixed multi-stream status return code, abort code< C	2.10 05-Mar-1986 Fixed subprocess exit code to reset queueE C	2.11 07-Mar-1986 Worked on bug in task abort code that hangs stream I C	2.12 24-Mar-1986 Documented code better; changed channel number to word I C	2.13 25-Mar-1986 Added debugging code activated through status mailbox; 4 C			 made adjustments to messages logged to operatorJ C	2.14 01-Apr-1986 Worked on "48042" bug (which causes symbiont to attempt8 C			 to abort nonexistent job at queue reset/stop time);8 C			 fixed process name length restriction checking and $ C			 related logical name definitionG C	2.15 06-Nov-1986 Added USER=username for subprocess username setting; 8 C			 made queue processors detached processes instead of C			 subprocesses A C	2.16 07-Nov-1986 Completed conversion to detached processes by  ; C			 changing logical names of command and status mailboxes H C	2.17 07-Nov-1986 Added creation of QUEUE_NAME_xxxxxxxx logical to pass8 C			 queue name informatio to processor; changed Fortran' C			 I/O to $FAO and other system calls G C	2.18 13-Feb-1987 Added DYNAMIC=dddd hh:mm:ss.cc parameter for dynamic  C			 processor start/stop < C	2.19 18-Feb-1987 Modified operator logging to go to OPER12H C	2.20 10-Jun-1987 Fixed problem with hangup in WRITE_MBX code for ASCII C			 queue processors F C	2.21 11-Jun-1987 Made further adjustments to WRITE_MBX code to avoid. C			 hanging the symbiont if a processor hangsD C	2.22 15-Jun-1987 Fixed bug with process completion synchronizationH C	2.23 16-Jun-1987 Fixed race condition with dynamic process terminationH C	2.24 16-Jun-1987 Cleaned up 2.23 fix; converted LOGICAL*1 flags to bit C			 flags in FLAGS word: C	2.25 15-Jul-1987 Updated to allow 32 streams per process> C	2.26 19-Aug-1987 Worked on mysterious processor exit problemA C	2.27 02-Dec-1987 Added permanent processor code; moved logs to  , C		      	 SYS_EXECSYMB (if that is defined)A C	2.28 14-Jan-1988 Added queue parameter FLAG (to send EXEC_FLAGS % C			 item with -1 code for each task) < C	2.29 23-Feb-1988 Fixed minor problems with AST enable code: C	2.30 16-May-1989 Added optional task status information;0 C			 *** REMOVED *** permanent processor supportI C	2.31 22-May-1989 Fixed minor problems with 2.30 and AST synchronization E C	2.32 15-Jun-1989 Work on hangup in HIB state with processors active  C G C	3.0.0 20-Jun-1989 Began cleanup of code, including: event flag usage, 2 C			  wakeup/hibernation state, AST enable/disableH C	3.0.1 12-Jul-1989 Added validity checks on times; fixed null item codeG C	3.1.0 28-Feb-1990 Added determination of "DEVICE_NAME" in queue setup G C	3.1.1 02-Mar-1990 Fixed problem with stopping hung processors -- need   C			  to turn on WORLD privilegeF C	3.1.2 21-Jun-1990 Fixed minor problem with time string in parametersF C	3.2.0 07-Aug-1990 Added retry-disable feature to status value; added8 C			  logical name to indicate "stream started" to worldD C	3.2.1 08-Aug-1990 Fixed processor-startup bugs introduced in 3.2.0A C	3.2.2 15-Aug-1990 Added stream-stop code to $DEBUG EXIT command H C	3.2.3 15-Aug-1990 Changed exit action for $DEBUG EXIT to do it non-ASTJ C	3.2.4 20-Aug-1990 Adjustment to logical names to simplify error recoveryI C	3.2.5 28-Mar-1991 Minor new feature: queue-specific .OUT file locations H C	3.2.6 01-Apr-1991 Fixed bug in 3.2.5 when queue-specific name not usedG C	3.2.7 23-Oct-1991 Added INIT flag (start dynamic processor initially) 0 C	3.3.0 29-Mar-1992 Changes required by VMS V5.5F C	3.3.1 31-Mar-1992 Changes to make same image work with V5.4 and V5.5J C	3.3.2 06-Oct-1992 Source cleanup: declare all variables; also, rearrange< C			  exit-requested code to set flag before sending messageG C	3.3.3 09-Oct-1992 Move kernel-mode code to protected shareable image; : C			  add kernel mode rundown routine to be called at exitG C	3.4.0 13-Oct-1992 Add workaround for V5.5 new queue manager "feature" : C			  disallowing TASK_STATUS messages when no task activeG C	3.4.1 14-Oct-1992 Fixed bug in STOP_STREAM processing that would send < C			  back duplicate response to JOBCTL (which, in VMS V5.5,8 C			  triggers an EXECSYMB process dump if it happens on' C			  the last remaining active stream) G C	3.5.0 24-Nov-1993 Alpha compatibility and DEC Fortran compiler stuff, " C			  plus some minor code cleanupF C	3.5.1 20-Dec-1993 Add working set controls based on queue parameters" C			  (on VMS V5.5 and above only)H C	3.5.2 12-Jan-1994 Fix STOP/QUEUE/RESET related bugs, item mailbox size# C	3.6.0 03-May-1994 Added HOLD flag G C	3.6.1 26-Jun-1994 Fixed bug in VMSV55 definition -- prevented it from  C			  working with VMS V6.x  C ? C	This program is a VMS server symbiont that feeds queue entry  @ C	information to processes that are designed to execute specificB C	operations.  It is multi-threaded (it can handle up to 32 queuesF C	at the same time); it requires one process and one mailbox for each 1 C	queue, plus one mailbox for status information.  C O C==============================================================================  C 9 C	Make implicit declaration and specify all INCLUDE files  C  	IMPLICIT NONE 	INCLUDE '($PRVDEF)' 	INCLUDE '($SJCDEF)' 	INCLUDE '($DVIDEF)' 	INCLUDE '($SYIDEF)' 	INCLUDE '($LNMDEF)' 	INCLUDE 'EXECSYMB.INC'  	INCLUDE 'ITEMDEF.INC' C  C	Version number C  	CHARACTER*6 VERSION_NUMBER $ 	PARAMETER (VERSION_NUMBER='V3.6.1') C ! C	AST routine for message receipt  C  	EXTERNAL MSG_AST  C  C	Create-mailbox definitions C + 	INTEGER*4 SYS$CREMBX,LIB$GETDVI,SYS$CRELNM  C  C	QIO definitions  C  C @ C	System services and other general routines called as functions C A 	INTEGER*4 SYS$SETPRN,SYS$HIBER,SYS$SETPRV,SYS$SNDJBCW,SYS$SETPRI 7 	INTEGER*4 SMB$INITIALIZE,SMB$SEND_TO_JOBCTL,LIB$GETSYI  C ' C	Our own routines, called as functions  C  	INTEGER*4 DO_REMOVE C 0 C	Vectors used with system and symbiont services C ) 	INTEGER*4 PRIVILEGES(2),STATUS_VECTOR(2)  C % C	Item list for defining logical name  C  	RECORD /ITEM/ LNM_LIST(2) 	CHARACTER*9 LNMGROUP  	DATA LNMGROUP/'LNM$GROUP'/  C  C	Miscellaneous local variables  C  	INTEGER*2 ACTIVE_STREAMS  	INTEGER*4 IOSB(2) 	LOGICAL*1 STOPPING  	INTEGER*4 ITEM_CODE 	CHARACTER*256 EDITBUF 	CHARACTER*12 STRN 	INTEGER*2 L_STRN  	CHARACTER*8 VMSVERS( 	INTEGER*4 I,ISTAT,L,IP,IT,LE,IX,HWMODEL C E C	Reference to P1 cell used for rundown pointer; also rundown address  C * 	EXTERNAL CTL$A_COMMON,KERNEL_MODE_RUNDOWN C E C	Process name stuff (used for generating logfile and error messages)  C  	CHARACTER*32 STREAM_CHARS 	CHARACTER*15 PROCESS_NAME* 	COMMON /PRCNAM/ STREAM_CHARS,PROCESS_NAME6 	DATA STREAM_CHARS/'0123456789ABCDEFGHIJKLMNOPQRSTUV'/ C  C	Requeue stuff  C ' 	RECORD /ITEM/ ITEMLIST(6),RESETLIST(2)  	CHARACTER*32 SJC_QUEUE  	INTEGER*4 SJC_ENTRY_NUMBER  	INTEGER*4 SJC_AFTER_TIME(2) C  C	AST synchronization stuff  C  	INTEGER*4 AST_DISABLE_LEVEL$ 	COMMON /ASTSTUFF/ AST_DISABLE_LEVEL C  C	Item conversion information  C A C	Each item has an item name, the length of the name, and an item B C	conversion type, used for converting the item value to ASCII forB C	streams requiring ASCII-format item values.  The following table  C	lists the possible item types: C	      type	meaning C	      ----	-------6 C		1	No translation (already ASCII, or item not easily2 C			translated to ASCII, so left in original form)5 C		2	Binary longword, converted to hexadecimal in the  C			format "%Xnnnnnnnn" 8 C		3	Date and time, converted to dd-mmm-yyyy hh:mm:ss.cc1 C			format (with one space between date and time) 8 C		4	UIC, converted to [gggggg,mmmmmm] format with octal7 C			group and member numbers containing leading zeroes. 5 C		5	Bitstring, converted to a list of which bits are 7 C			set.  Up to 16 bytes of data can be included in the ; C			item (since the CHARACTERISTICS item is 16 bytes long.) 8 C			The list is a series of decimal numbers separated by, C			commas (e.g. hex 641 becomes "0,6,9,10") C / 	CHARACTER*21 SMBITEM(SMBMSG$K_MAX_ITEM_CODE-1) * 	BYTE SMBITEMLEN(SMBMSG$K_MAX_ITEM_CODE-1)+ 	BYTE SMBITEMTYPE(SMBMSG$K_MAX_ITEM_CODE-1) 4 	COMMON /SMBITEMINFO/ SMBITEM,SMBITEMLEN,SMBITEMTYPE C ; 	DATA SMBITEM(SMBMSG$K_ACCOUNTING_DATA) /'ACCOUNTING_DATA'/ / 	DATA SMBITEMLEN(SMBMSG$K_ACCOUNTING_DATA) /15/ / 	DATA SMBITEMTYPE(SMBMSG$K_ACCOUNTING_DATA) /1/ 5 	DATA SMBITEM(SMBMSG$K_ACCOUNT_NAME) /'ACCOUNT_NAME'/ , 	DATA SMBITEMLEN(SMBMSG$K_ACCOUNT_NAME) /12/, 	DATA SMBITEMTYPE(SMBMSG$K_ACCOUNT_NAME) /1/1 	DATA SMBITEM(SMBMSG$K_AFTER_TIME) /'AFTER_TIME'/ * 	DATA SMBITEMLEN(SMBMSG$K_AFTER_TIME) /10/* 	DATA SMBITEMTYPE(SMBMSG$K_AFTER_TIME) /3/; 	DATA SMBITEM(SMBMSG$K_ALIGNMENT_PAGES) /'ALIGNMENT_PAGES'/ / 	DATA SMBITEMLEN(SMBMSG$K_ALIGNMENT_PAGES) /15/ / 	DATA SMBITEMTYPE(SMBMSG$K_ALIGNMENT_PAGES) /2/ 7 	DATA SMBITEM(SMBMSG$K_BOTTOM_MARGIN) /'BOTTOM_MARGIN'/ - 	DATA SMBITEMLEN(SMBMSG$K_BOTTOM_MARGIN) /13/ - 	DATA SMBITEMTYPE(SMBMSG$K_BOTTOM_MARGIN) /2/ ; 	DATA SMBITEM(SMBMSG$K_CHARACTERISTICS) /'CHARACTERISTICS'/ / 	DATA SMBITEMLEN(SMBMSG$K_CHARACTERISTICS) /15/ / 	DATA SMBITEMTYPE(SMBMSG$K_CHARACTERISTICS) /5/ ; 	DATA SMBITEM(SMBMSG$K_CHECKPOINT_DATA) /'CHECKPOINT_DATA'/ / 	DATA SMBITEMLEN(SMBMSG$K_CHECKPOINT_DATA) /15/ / 	DATA SMBITEMTYPE(SMBMSG$K_CHECKPOINT_DATA) /1/ = 	DATA SMBITEM(SMBMSG$K_CONDITION_VECTOR) /'CONDITION_VECTOR'/ 0 	DATA SMBITEMLEN(SMBMSG$K_CONDITION_VECTOR) /16/0 	DATA SMBITEMTYPE(SMBMSG$K_CONDITION_VECTOR) /1/3 	DATA SMBITEM(SMBMSG$K_DEVICE_NAME) /'DEVICE_NAME'/ + 	DATA SMBITEMLEN(SMBMSG$K_DEVICE_NAME) /11/ + 	DATA SMBITEMTYPE(SMBMSG$K_DEVICE_NAME) /1/ 7 	DATA SMBITEM(SMBMSG$K_DEVICE_STATUS) /'DEVICE_STATUS'/ - 	DATA SMBITEMLEN(SMBMSG$K_DEVICE_STATUS) /13/ - 	DATA SMBITEMTYPE(SMBMSG$K_DEVICE_STATUS) /5/ 5 	DATA SMBITEM(SMBMSG$K_ENTRY_NUMBER) /'ENTRY_NUMBER'/ , 	DATA SMBITEMLEN(SMBMSG$K_ENTRY_NUMBER) /12/, 	DATA SMBITEMTYPE(SMBMSG$K_ENTRY_NUMBER) /2/9 	DATA SMBITEM(SMBMSG$K_EXECUTOR_QUEUE) /'EXECUTOR_QUEUE'/ . 	DATA SMBITEMLEN(SMBMSG$K_EXECUTOR_QUEUE) /14/. 	DATA SMBITEMTYPE(SMBMSG$K_EXECUTOR_QUEUE) /1/3 	DATA SMBITEM(SMBMSG$K_FILE_COPIES) /'FILE_COPIES'/ + 	DATA SMBITEMLEN(SMBMSG$K_FILE_COPIES) /11/ + 	DATA SMBITEMTYPE(SMBMSG$K_FILE_COPIES) /2/ 1 	DATA SMBITEM(SMBMSG$K_FILE_COUNT) /'FILE_COUNT'/ * 	DATA SMBITEMLEN(SMBMSG$K_FILE_COUNT) /10/* 	DATA SMBITEMTYPE(SMBMSG$K_FILE_COUNT) /2/A 	DATA SMBITEM(SMBMSG$K_FILE_SETUP_MODULES) /'FILE_SETUP_MODULES'/ 2 	DATA SMBITEMLEN(SMBMSG$K_FILE_SETUP_MODULES) /18/2 	DATA SMBITEMTYPE(SMBMSG$K_FILE_SETUP_MODULES) /1/1 	DATA SMBITEM(SMBMSG$K_FIRST_PAGE) /'FIRST_PAGE'/ * 	DATA SMBITEMLEN(SMBMSG$K_FIRST_PAGE) /10/* 	DATA SMBITEMTYPE(SMBMSG$K_FIRST_PAGE) /2/3 	DATA SMBITEM(SMBMSG$K_FORM_LENGTH) /'FORM_LENGTH'/ + 	DATA SMBITEMLEN(SMBMSG$K_FORM_LENGTH) /11/ + 	DATA SMBITEMTYPE(SMBMSG$K_FORM_LENGTH) /2/ / 	DATA SMBITEM(SMBMSG$K_FORM_NAME) /'FORM_NAME'/ ( 	DATA SMBITEMLEN(SMBMSG$K_FORM_NAME) /9/) 	DATA SMBITEMTYPE(SMBMSG$K_FORM_NAME) /1/ A 	DATA SMBITEM(SMBMSG$K_FORM_SETUP_MODULES) /'FORM_SETUP_MODULES'/ 2 	DATA SMBITEMLEN(SMBMSG$K_FORM_SETUP_MODULES) /18/2 	DATA SMBITEMTYPE(SMBMSG$K_FORM_SETUP_MODULES) /1/1 	DATA SMBITEM(SMBMSG$K_FORM_WIDTH) /'FORM_WIDTH'/ * 	DATA SMBITEMLEN(SMBMSG$K_FORM_WIDTH) /10/* 	DATA SMBITEMTYPE(SMBMSG$K_FORM_WIDTH) /2/C 	DATA SMBITEM(SMBMSG$K_FILE_IDENTIFICATION) /'FILE_IDENTIFICATION'/ 3 	DATA SMBITEMLEN(SMBMSG$K_FILE_IDENTIFICATION) /19/ 3 	DATA SMBITEMTYPE(SMBMSG$K_FILE_IDENTIFICATION) /1/ A 	DATA SMBITEM(SMBMSG$K_FILE_SPECIFICATION) /'FILE_SPECIFICATION'/ 2 	DATA SMBITEMLEN(SMBMSG$K_FILE_SPECIFICATION) /18/2 	DATA SMBITEMTYPE(SMBMSG$K_FILE_SPECIFICATION) /1/1 	DATA SMBITEM(SMBMSG$K_JOB_COPIES) /'JOB_COPIES'/ * 	DATA SMBITEMLEN(SMBMSG$K_JOB_COPIES) /10/* 	DATA SMBITEMTYPE(SMBMSG$K_JOB_COPIES) /2// 	DATA SMBITEM(SMBMSG$K_JOB_COUNT) /'JOB_COUNT'/ ( 	DATA SMBITEMLEN(SMBMSG$K_JOB_COUNT) /9/) 	DATA SMBITEMTYPE(SMBMSG$K_JOB_COUNT) /2/ - 	DATA SMBITEM(SMBMSG$K_JOB_NAME) /'JOB_NAME'/ ' 	DATA SMBITEMLEN(SMBMSG$K_JOB_NAME) /8/ ( 	DATA SMBITEMTYPE(SMBMSG$K_JOB_NAME) /1/? 	DATA SMBITEM(SMBMSG$K_JOB_RESET_MODULES) /'JOB_RESET_MODULES'/ 1 	DATA SMBITEMLEN(SMBMSG$K_JOB_RESET_MODULES) /17/ 1 	DATA SMBITEMTYPE(SMBMSG$K_JOB_RESET_MODULES) /1/ / 	DATA SMBITEM(SMBMSG$K_LAST_PAGE) /'LAST_PAGE'/ ( 	DATA SMBITEMLEN(SMBMSG$K_LAST_PAGE) /9/) 	DATA SMBITEMTYPE(SMBMSG$K_LAST_PAGE) /2/ 3 	DATA SMBITEM(SMBMSG$K_LEFT_MARGIN) /'LEFT_MARGIN'/ + 	DATA SMBITEMLEN(SMBMSG$K_LEFT_MARGIN) /11/ + 	DATA SMBITEMTYPE(SMBMSG$K_LEFT_MARGIN) /2/ G 	DATA SMBITEM(SMBMSG$K_LIBRARY_SPECIFICATION) /'LIBRARY_SPECIFICATION'/ 5 	DATA SMBITEMLEN(SMBMSG$K_LIBRARY_SPECIFICATION) /21/ 5 	DATA SMBITEMTYPE(SMBMSG$K_LIBRARY_SPECIFICATION) /1/ ; 	DATA SMBITEM(SMBMSG$K_MAXIMUM_STREAMS) /'MAXIMUM_STREAMS'/ / 	DATA SMBITEMLEN(SMBMSG$K_MAXIMUM_STREAMS) /15/ / 	DATA SMBITEMTYPE(SMBMSG$K_MAXIMUM_STREAMS) /2/ 9 	DATA SMBITEM(SMBMSG$K_MESSAGE_VECTOR) /'MESSAGE_VECTOR'/ . 	DATA SMBITEMLEN(SMBMSG$K_MESSAGE_VECTOR) /14/. 	DATA SMBITEMTYPE(SMBMSG$K_MESSAGE_VECTOR) /1/% 	DATA SMBITEM(SMBMSG$K_NOTE) /'NOTE'/ # 	DATA SMBITEMLEN(SMBMSG$K_NOTE) /4/ $ 	DATA SMBITEMTYPE(SMBMSG$K_NOTE) /1/A 	DATA SMBITEM(SMBMSG$K_PAGE_SETUP_MODULES) /'PAGE_SETUP_MODULES'/ 2 	DATA SMBITEMLEN(SMBMSG$K_PAGE_SETUP_MODULES) /18/2 	DATA SMBITEMTYPE(SMBMSG$K_PAGE_SETUP_MODULES) /1/3 	DATA SMBITEM(SMBMSG$K_PARAMETER_1) /'PARAMETER_1'/ + 	DATA SMBITEMLEN(SMBMSG$K_PARAMETER_1) /11/ + 	DATA SMBITEMTYPE(SMBMSG$K_PARAMETER_1) /1/ 3 	DATA SMBITEM(SMBMSG$K_PARAMETER_2) /'PARAMETER_2'/ + 	DATA SMBITEMLEN(SMBMSG$K_PARAMETER_2) /11/ + 	DATA SMBITEMTYPE(SMBMSG$K_PARAMETER_2) /1/ 3 	DATA SMBITEM(SMBMSG$K_PARAMETER_3) /'PARAMETER_3'/ + 	DATA SMBITEMLEN(SMBMSG$K_PARAMETER_3) /11/ + 	DATA SMBITEMTYPE(SMBMSG$K_PARAMETER_3) /1/ 3 	DATA SMBITEM(SMBMSG$K_PARAMETER_4) /'PARAMETER_4'/ + 	DATA SMBITEMLEN(SMBMSG$K_PARAMETER_4) /11/ + 	DATA SMBITEMTYPE(SMBMSG$K_PARAMETER_4) /1/ 3 	DATA SMBITEM(SMBMSG$K_PARAMETER_5) /'PARAMETER_5'/ + 	DATA SMBITEMLEN(SMBMSG$K_PARAMETER_5) /11/ + 	DATA SMBITEMTYPE(SMBMSG$K_PARAMETER_5) /1/ 3 	DATA SMBITEM(SMBMSG$K_PARAMETER_6) /'PARAMETER_6'/ + 	DATA SMBITEMLEN(SMBMSG$K_PARAMETER_6) /11/ + 	DATA SMBITEMTYPE(SMBMSG$K_PARAMETER_6) /1/ 3 	DATA SMBITEM(SMBMSG$K_PARAMETER_7) /'PARAMETER_7'/ + 	DATA SMBITEMLEN(SMBMSG$K_PARAMETER_7) /11/ + 	DATA SMBITEMTYPE(SMBMSG$K_PARAMETER_7) /1/ 3 	DATA SMBITEM(SMBMSG$K_PARAMETER_8) /'PARAMETER_8'/ + 	DATA SMBITEMLEN(SMBMSG$K_PARAMETER_8) /11/ + 	DATA SMBITEMTYPE(SMBMSG$K_PARAMETER_8) /1/ 7 	DATA SMBITEM(SMBMSG$K_PRINT_CONTROL) /'PRINT_CONTROL'/ - 	DATA SMBITEMLEN(SMBMSG$K_PRINT_CONTROL) /13/ - 	DATA SMBITEMTYPE(SMBMSG$K_PRINT_CONTROL) /5/ - 	DATA SMBITEM(SMBMSG$K_PRIORITY) /'PRIORITY'/ ' 	DATA SMBITEMLEN(SMBMSG$K_PRIORITY) /8/ ( 	DATA SMBITEMTYPE(SMBMSG$K_PRIORITY) /2/' 	DATA SMBITEM(SMBMSG$K_QUEUE) /'QUEUE'/ $ 	DATA SMBITEMLEN(SMBMSG$K_QUEUE) /5/% 	DATA SMBITEMTYPE(SMBMSG$K_QUEUE) /1/ 7 	DATA SMBITEM(SMBMSG$K_REFUSE_REASON) /'REFUSE_REASON'/ - 	DATA SMBITEMLEN(SMBMSG$K_REFUSE_REASON) /13/ - 	DATA SMBITEMTYPE(SMBMSG$K_REFUSE_REASON) /1/ 7 	DATA SMBITEM(SMBMSG$K_RELATIVE_PAGE) /'RELATIVE_PAGE'/ - 	DATA SMBITEMLEN(SMBMSG$K_RELATIVE_PAGE) /13/ - 	DATA SMBITEMTYPE(SMBMSG$K_RELATIVE_PAGE) /2/ ; 	DATA SMBITEM(SMBMSG$K_REQUEST_CONTROL) /'REQUEST_CONTROL'/ / 	DATA SMBITEMLEN(SMBMSG$K_REQUEST_CONTROL) /15/ / 	DATA SMBITEMTYPE(SMBMSG$K_REQUEST_CONTROL) /5/ = 	DATA SMBITEM(SMBMSG$K_REQUEST_RESPONSE) /'REQUEST_RESPONSE'/ 0 	DATA SMBITEMLEN(SMBMSG$K_REQUEST_RESPONSE) /16/0 	DATA SMBITEMTYPE(SMBMSG$K_REQUEST_RESPONSE) /2/5 	DATA SMBITEM(SMBMSG$K_RIGHT_MARGIN) /'RIGHT_MARGIN'/ , 	DATA SMBITEMLEN(SMBMSG$K_RIGHT_MARGIN) /12/, 	DATA SMBITEMTYPE(SMBMSG$K_RIGHT_MARGIN) /2/7 	DATA SMBITEM(SMBMSG$K_SEARCH_STRING) /'SEARCH_STRING'/ - 	DATA SMBITEMLEN(SMBMSG$K_SEARCH_STRING) /13/ - 	DATA SMBITEMTYPE(SMBMSG$K_SEARCH_STRING) /1/ A 	DATA SMBITEM(SMBMSG$K_SEPARATION_CONTROL) /'SEPARATION_CONTROL'/ 2 	DATA SMBITEMLEN(SMBMSG$K_SEPARATION_CONTROL) /18/2 	DATA SMBITEMTYPE(SMBMSG$K_SEPARATION_CONTROL) /5/9 	DATA SMBITEM(SMBMSG$K_STOP_CONDITION) /'STOP_CONDITION'/ . 	DATA SMBITEMLEN(SMBMSG$K_STOP_CONDITION) /14/. 	DATA SMBITEMTYPE(SMBMSG$K_STOP_CONDITION) /2/3 	DATA SMBITEM(SMBMSG$K_TIME_QUEUED) /'TIME_QUEUED'/ + 	DATA SMBITEMLEN(SMBMSG$K_TIME_QUEUED) /11/ + 	DATA SMBITEMTYPE(SMBMSG$K_TIME_QUEUED) /3/ 1 	DATA SMBITEM(SMBMSG$K_TOP_MARGIN) /'TOP_MARGIN'/ * 	DATA SMBITEMLEN(SMBMSG$K_TOP_MARGIN) /10/* 	DATA SMBITEMTYPE(SMBMSG$K_TOP_MARGIN) /2/# 	DATA SMBITEM(SMBMSG$K_UIC) /'UIC'/ " 	DATA SMBITEMLEN(SMBMSG$K_UIC) /3/# 	DATA SMBITEMTYPE(SMBMSG$K_UIC) /4/ / 	DATA SMBITEM(SMBMSG$K_USER_NAME) /'USER_NAME'/ ( 	DATA SMBITEMLEN(SMBMSG$K_USER_NAME) /9/) 	DATA SMBITEMTYPE(SMBMSG$K_USER_NAME) /1/ E C> Following items added VMS V5.5 -- types are tentative as of V3.3.0 E 	DATA SMBITEM(SMBMSG$K_CHECKPOINT_FREQUENCY) /'CHECKPOINT_FREQUENCY'/ 4 	DATA SMBITEMLEN(SMBMSG$K_CHECKPOINT_FREQUENCY) /20/4 	DATA SMBITEMTYPE(SMBMSG$K_CHECKPOINT_FREQUENCY) /1/; 	DATA SMBITEM(SMBMSG$K_QUEUING_CONTROL) /'QUEUING_CONTROL'/ / 	DATA SMBITEMLEN(SMBMSG$K_QUEUING_CONTROL) /15/ / 	DATA SMBITEMTYPE(SMBMSG$K_QUEUING_CONTROL) /1/ 1 	DATA SMBITEM(SMBMSG$K_RETRY_TIME) /'RETRY_TIME'/ * 	DATA SMBITEMLEN(SMBMSG$K_RETRY_TIME) /10/* 	DATA SMBITEMTYPE(SMBMSG$K_RETRY_TIME) /1/= 	DATA SMBITEM(SMBMSG$K_DEVICE_CONDITION) /'DEVICE_CONDITION'/ 0 	DATA SMBITEMLEN(SMBMSG$K_DEVICE_CONDITION) /16/0 	DATA SMBITEMTYPE(SMBMSG$K_DEVICE_CONDITION) /1/5 	DATA SMBITEM(SMBMSG$K_MESSAGE_FILE) /'MESSAGE_FILE'/ , 	DATA SMBITEMLEN(SMBMSG$K_MESSAGE_FILE) /12/, 	DATA SMBITEMTYPE(SMBMSG$K_MESSAGE_FILE) /1/7 	DATA SMBITEM(SMBMSG$K_AGENT_PROFILE) /'AGENT_PROFILE'/ - 	DATA SMBITEMLEN(SMBMSG$K_AGENT_PROFILE) /13/ - 	DATA SMBITEMTYPE(SMBMSG$K_AGENT_PROFILE) /1/ / 	DATA SMBITEM(SMBMSG$K_CPU_LIMIT) /'CPU_LIMIT'/ ( 	DATA SMBITEMLEN(SMBMSG$K_CPU_LIMIT) /9/) 	DATA SMBITEMTYPE(SMBMSG$K_CPU_LIMIT) /1/ ; 	DATA SMBITEM(SMBMSG$K_FILE_SEPARATION) /'FILE_SEPARATION'/ / 	DATA SMBITEMLEN(SMBMSG$K_FILE_SEPARATION) /15/ / 	DATA SMBITEMTYPE(SMBMSG$K_FILE_SEPARATION) /1/ / 	DATA SMBITEM(SMBMSG$K_LOG_QUEUE) /'LOG_QUEUE'/ ( 	DATA SMBITEMLEN(SMBMSG$K_LOG_QUEUE) /9/) 	DATA SMBITEMTYPE(SMBMSG$K_LOG_QUEUE) /1/ ? 	DATA SMBITEM(SMBMSG$K_LOG_SPECIFICATION) /'LOG_SPECIFICATION'/ 1 	DATA SMBITEMLEN(SMBMSG$K_LOG_SPECIFICATION) /17/ 1 	DATA SMBITEMTYPE(SMBMSG$K_LOG_SPECIFICATION) /1/ / 	DATA SMBITEM(SMBMSG$K_LOG_SPOOL) /'LOG_SPOOL'/ ( 	DATA SMBITEMLEN(SMBMSG$K_LOG_SPOOL) /9/) 	DATA SMBITEMTYPE(SMBMSG$K_LOG_SPOOL) /1/ = 	DATA SMBITEM(SMBMSG$K_OPERATOR_REQUEST) /'OPERATOR_REQUEST'/ 0 	DATA SMBITEMLEN(SMBMSG$K_OPERATOR_REQUEST) /16/0 	DATA SMBITEMTYPE(SMBMSG$K_OPERATOR_REQUEST) /1// 	DATA SMBITEM(SMBMSG$K_WSDEFAULT) /'WSDEFAULT'/ ( 	DATA SMBITEMLEN(SMBMSG$K_WSDEFAULT) /9/) 	DATA SMBITEMTYPE(SMBMSG$K_WSDEFAULT) /1/ - 	DATA SMBITEM(SMBMSG$K_WSEXTENT) /'WSEXTENT'/ ' 	DATA SMBITEMLEN(SMBMSG$K_WSEXTENT) /8/ ( 	DATA SMBITEMTYPE(SMBMSG$K_WSEXTENT) /1/+ 	DATA SMBITEM(SMBMSG$K_WSQUOTA) /'WSQUOTA'/ & 	DATA SMBITEMLEN(SMBMSG$K_WSQUOTA) /7/' 	DATA SMBITEMTYPE(SMBMSG$K_WSQUOTA) /1/ ; 	DATA SMBITEM(SMBMSG$K_FILE_ATTRIBUTES) /'FILE_ATTRIBUTES'/ / 	DATA SMBITEMLEN(SMBMSG$K_FILE_ATTRIBUTES) /15/ / 	DATA SMBITEMTYPE(SMBMSG$K_FILE_ATTRIBUTES) /1/ E 	DATA SMBITEM(SMBMSG$K_FILE_ATTRIBUTES_SIZE) /'FILE_ATTRIBUTES_SIZE'/ 4 	DATA SMBITEMLEN(SMBMSG$K_FILE_ATTRIBUTES_SIZE) /20/4 	DATA SMBITEMTYPE(SMBMSG$K_FILE_ATTRIBUTES_SIZE) /1/9 	DATA SMBITEM(SMBMSG$K_JOB_ATTRIBUTES) /'JOB_ATTRIBUTES'/ . 	DATA SMBITEMLEN(SMBMSG$K_JOB_ATTRIBUTES) /14/. 	DATA SMBITEMTYPE(SMBMSG$K_JOB_ATTRIBUTES) /1/C 	DATA SMBITEM(SMBMSG$K_JOB_ATTRIBUTES_SIZE) /'JOB_ATTRIBUTES_SIZE'/ 3 	DATA SMBITEMLEN(SMBMSG$K_JOB_ATTRIBUTES_SIZE) /19/ 3 	DATA SMBITEMTYPE(SMBMSG$K_JOB_ATTRIBUTES_SIZE) /1/ = 	DATA SMBITEM(SMBMSG$K_QUEUE_ATTRIBUTES) /'QUEUE_ATTRIBUTES'/ 0 	DATA SMBITEMLEN(SMBMSG$K_QUEUE_ATTRIBUTES) /16/0 	DATA SMBITEMTYPE(SMBMSG$K_QUEUE_ATTRIBUTES) /1/G 	DATA SMBITEM(SMBMSG$K_QUEUE_ATTRIBUTES_SIZE) /'QUEUE_ATTRIBUTES_SIZE'/ 5 	DATA SMBITEMLEN(SMBMSG$K_QUEUE_ATTRIBUTES_SIZE) /21/ 5 	DATA SMBITEMTYPE(SMBMSG$K_QUEUE_ATTRIBUTES_SIZE) /1/ 9 	DATA SMBITEM(SMBMSG$K_SUBMITTER_EPID) /'SUBMITTER_EPID'/ . 	DATA SMBITEMLEN(SMBMSG$K_SUBMITTER_EPID) /14/. 	DATA SMBITEMTYPE(SMBMSG$K_SUBMITTER_EPID) /1/ C  C	Miscellaneous data statements  C ( 	DATA PRIVILEGES/0,0/,STATUS_VECTOR/1,0/% 	DATA PROCESS_NAME/'ExecSymb3.6.1_0'/ O C==============================================================================  C  C	Start of code  C B C	Set our process name to "ExecSymbv.v.v_n", n=1,...,9,A,...,Z -- ' C	whichever is the next one not in use.  C & 500	IF(PROCESS_NAME(15:15).EQ.'9')THEN 	   I=ICHAR('A') 	ELSE " 	   I=ICHAR(PROCESS_NAME(15:15))+1 	ENDIF 	PROCESS_NAME(15:15)=CHAR(I)' 	ISTAT=SYS$SETPRN(%DESCR(PROCESS_NAME))  	IF(.NOT.ISTAT)GOTO500 C 9 C	Indicate that no AST disable calls have been made (yet)  C  	AST_DISABLE_LEVEL=0 C ? C	Inform operator that process is starting, and set up log file  C C 	CALL TELL_OPER('ExecSymb '//VERSION_NUMBER//' process starting',3)  	LOGDIR(1:12)='SYS_EXECSYMB' 	L_LD=12B 	OPEN(UNIT=1,NAME=LOGDIR(1:L_LD)//':EXECSYMB'//PROCESS_NAME(15:15)6 	1 //'.LOG',TYPE='NEW',CARRIAGECONTROL='LIST',ERR=501) 	GOTO502 501	LOGDIR(1:11)='SYS$MANAGER' 	L_LD=11B 	OPEN(UNIT=1,NAME=LOGDIR(1:L_LD)//':EXECSYMB'//PROCESS_NAME(15:15)5 	1 //'.LOG',TYPE='NEW',CARRIAGECONTROL='LIST',ERR=99)  502	CLOSE(UNIT=1)  C ) C	Set needed privileges and base priority  C  C	We used to be able to write: C  C	IF(PRV$V_FOOBAR.LE.31)THEN0 C	   PRIVILEGES(1)=PRIVILEGES(1).OR.PRV$M_FOOBAR C	ELSE0 C	   PRIVILEGES(2)=PRIVILEGES(2).OR.PRV$M_FOOBAR C	ENDIF  C G C	and have the VAX Fortran compiler's optimizer automatically generate  I C	the correct assignment (since PRV$V_FOOBAR is a constant).  But the new I C	DEC Fortran compilers complain that the unused part of the statement is H C	unreachable.  Therefore, these statements must now know which longwordG C	the privilege belongs in.  If Digital ever changes the privilege bits D C	(unlikely as that may be), this code must be modified accordingly. C , 	PRIVILEGES(1)=PRIVILEGES(1).OR.PRV$M_TMPMBX, 	PRIVILEGES(1)=PRIVILEGES(1).OR.PRV$M_CMKRNL, 	PRIVILEGES(1)=PRIVILEGES(1).OR.PRV$M_DETACH, 	PRIVILEGES(1)=PRIVILEGES(1).OR.PRV$M_SYSPRV, 	PRIVILEGES(1)=PRIVILEGES(1).OR.PRV$M_ALTPRI+ 	PRIVILEGES(1)=PRIVILEGES(1).OR.PRV$M_WORLD 4 	ISTAT=SYS$SETPRV(%VAL(1),%REF(PRIVILEGES),%VAL(1),)# 	CALL LOGGIT('$SETPRV stat=',ISTAT)  C A C	Raise our priority above default but to level below JOB_CONTROL , C	(JOB_CONTROL runs at 8, so we'll run at 7) C  	ISTAT=SYS$SETPRI(,,%VAL(7),) # 	CALL LOGGIT('$SETPRI stat=',ISTAT)  C B C	Get local VMS version number, and determine if it's at least V5.F C	(VERSION is an eight-character blank-padded string, e.g. "V5.1-1  ")? C	Similarly, get default base priority for processes in system.  C . 	ISTAT=LIB$GETSYI(%REF(SYI$_HW_MODEL),HWMODEL)$ 	CALL LOGGIT('$GETSYI0 stat=',ISTAT) 	IF(HWMODEL.LT.1024)THEN1 	   ISTAT=LIB$GETSYI(%REF(SYI$_VERSION),,VMSVERS) ' 	   CALL LOGGIT('$GETSYI1 stat=',ISTAT)  	   VMSV5=(VMSVERS(2:2).GE.'5') < 	   VMSV55=(VMSVERS(2:2).EQ.'5'.AND.VMSVERS(4:4).GE.'5').OR. 	1   VMSVERS(2:2).GT.'5' 	ELSE = 	   VMSV55=.TRUE.	! all AXP assume V5.5 or greater equivalent , 	   VMSV5=.TRUE.		! it's also V5 or greater! 	ENDIF. 	ISTAT=LIB$GETSYI(%REF(SYI$_DEFPRI),BASE_PRIO)$ 	CALL LOGGIT('$GETSYI2 stat=',ISTAT) C  C	Do the equivalent of:  C D C	DEFINE/TABLE=LNM$PROCESS_DIRECTORY LNM$TEMPORARY_MAILBOX LNM$GROUP C D C	telling the system to put the logical names of temporary mailboxesD C	into the group logical name table (which will be LNM$GROUP_000001) C  	LNM_LIST(1).BUFLEN=9 ! 	LNM_LIST(1).ITEMCODE=LNM$_STRING " 	LNM_LIST(1).BUFADR=%LOC(LNMGROUP) 	LNM_LIST(1).RETLENADR=0 	LNM_LIST(2).TERMINATOR=0 C 	ISTAT=SYS$CRELNM(,'LNM$PROCESS_DIRECTORY','LNM$TEMPORARY_MAILBOX', 
 	1 ,LNM_LIST) # 	CALL LOGGIT('$CRELNM stat=',ISTAT)  C @ C	Create mailboxes for status return and process exit detection,7 C	and do initial reads to them (with AST on completion) ? C	Effective with V2.16, the status mailbox name is STAT_W_MBX_x G C	where "x" is the last character of our process name, ExecSymbvv.vv_x. C C	This is necessary now that these logicals are in the group table, 9 C	since more than one copy of the symbiont may be active.  C F C	Similarly, the subprocess exit mailbox is called SUBPROC_EXIT_MBX_x. C D C	Effective with version 2.30, the mailbox message size is increasedA C	from 12 to 268, to allow room for accounting/checkpoint/status  : C	extensions.  (Provide for 33*268 bytes of buffer space.) C > 	ISTAT=SYS$CREMBX(,%REF(STAT_W_MBX_CHAN),%VAL(268),%VAL(8844),< 	1 %VAL('FF00'X),,%DESCR('STAT_W_MBX'//PROCESS_NAME(14:15)))$ 	CALL LOGGIT('$CREMBX1 stat=',ISTAT) 	CALL READ_STAT_MBX A 	ISTAT=SYS$CREMBX(,%REF(EXIT_MBX_CHAN),%VAL(132),,%VAL('FF00'X),, 3 	1 %DESCR('SUBPROC_EXIT_MBX'//PROCESS_NAME(14:15))) $ 	CALL LOGGIT('$CREMBX2 stat=',ISTAT) 	CALL READ_EXIT_MBX 7 	ISTAT=LIB$GETDVI(%REF(DVI$_UNIT),%REF(EXIT_MBX_CHAN),,  	1 %REF(EXIT_MBX_UNIT)) # 	CALL LOGGIT('$GETDVI stat=',ISTAT)  C 3 C	Initialize SCB's to indicate all streams inactive  C  	DO I=0,MAX_STREAMS-1  	   STREAM(I).PID=0  	   STREAM(I).MBX_CHAN=-1 * 	   STREAM(I).REQUEST=SMBMSG$K_STOP_STREAM 	ENDDO 	MAXUSED=-1  C 7 C	Set up itemlist for modifying aborted job for requeue  C  	IF(VMSV5)THEN< 	   ITEMLIST(1).ITEMCODE=SJC$_RESTART	! a no-op in this case 	   ITEMLIST(1).BUFLEN=0 	   ITEMLIST(1).BUFADR=0 	   ITEMLIST(1).RETLENADR=0  	ELSE # 	   ITEMLIST(1).ITEMCODE=SJC$_QUEUE & 	   ITEMLIST(1).BUFADR=%LOC(SJC_QUEUE) 	   ITEMLIST(1).RETLENADR=0  	ENDIF' 	ITEMLIST(2).ITEMCODE=SJC$_ENTRY_NUMBER  	ITEMLIST(2).BUFLEN=4 * 	ITEMLIST(2).BUFADR=%LOC(SJC_ENTRY_NUMBER) 	ITEMLIST(2).RETLENADR=0" 	ITEMLIST(3).ITEMCODE=SJC$_NO_HOLD 	ITEMLIST(3).BUFLEN=0  	ITEMLIST(3).BUFADR=0  	ITEMLIST(3).RETLENADR=0% 	ITEMLIST(4).ITEMCODE=SJC$_AFTER_TIME  	ITEMLIST(4).BUFLEN=8 + 	ITEMLIST(4).BUFADR=%LOC(SJC_AFTER_TIME(1))  	ITEMLIST(4).RETLENADR=0- 	ITEMLIST(5).ITEMCODE=SJC$_NO_CHECKPOINT_DATA  	ITEMLIST(5).BUFLEN=0  	ITEMLIST(5).BUFADR=0  	ITEMLIST(5).RETLENADR=0 	ITEMLIST(6).TERMINATOR=0  C A C	Now, tell the job controller that we are really a symbiont, and I C	let it know how many streams we can handle.  Also, first time through,  F C	force active stream count nonzero (in case the first message didn't  C	arrive yet.) C 7 C	Effective V3.3.3: also set address of rundown routine  C  	ACTIVE_STREAMS=1 5 	ISTAT=SMB$INITIALIZE(%REF(SMBMSG$K_STRUCTURE_LEVEL), # 	1 %REF(MSG_AST),%REF(MAX_STREAMS))   	CALL LOGGIT('INIT stat=',ISTAT)8 	CALL MOVL(%REF(%LOC(KERNEL_MODE_RUNDOWN)),CTL$A_COMMON)	 	GOTO1001 O C==============================================================================  C  C	Main processing loop C H C	For each pass, set hibernation flag and initialize active stream count C  1000	ACTIVE_STREAMS=0  1001	DO_HIBER=.TRUE. C  C	Repeat loop for each stream  C  	DO I=0,MAXUSED  C G C	STOP_STREAM indicates that stream is inactive (or becoming inactive,  ? C	if process hasn't yet exited) -- count stream as "active" if  > C	process is alive, or else we might exit before process does! C 5 	   IF(STREAM(I).REQUEST.EQ.SMBMSG$K_STOP_STREAM)THEN < 	      IF(STREAM(I).PID.NE.0)ACTIVE_STREAMS=ACTIVE_STREAMS+1 C 8 C	START_STREAM indicates that stream is started but idle C ; 	   ELSE IF(STREAM(I).REQUEST.EQ.SMBMSG$K_START_STREAM)THEN & 	      ACTIVE_STREAMS=ACTIVE_STREAMS+1 C 3 C	START_TASK indicates that task is being processed B C	RESET_STREAM is present only if task was active when stream was > C	reset; handle task abort, then change request to STOP_STREAM C 8 	   ELSE IF(STREAM(I).REQUEST.EQ.SMBMSG$K_START_TASK.OR.; 	1          STREAM(I).REQUEST.EQ.SMBMSG$K_RESET_STREAM)THEN & 	      ACTIVE_STREAMS=ACTIVE_STREAMS+1 C ; C	Active task can be in one of five states, given by INDEX:  C  C		1	Task being started 5 C	      	2	Task processing (sending items to process) + C		3	Task waiting for status to be returned  C		4	Task completing C		5	Task being aborted  C 5 	      GOTO(1010,1020,1030,1040,1050),STREAM(I).INDEX E 	      CALL SYS$FAO(' !2UB=!8XL',,STRN,%VAL(I),%VAL(STREAM(I).INDEX)) . 	      CALL LOGGIT('Bad index: stream'//STRN,) 	      GOTO1040  C H C	Task being started -- verify that old processor is not exiting; if so,/ C				initialize item index and go on; otherwise 0 C				retain this item index and skip this stream5 C				(allowing hibernation) until old processor exits  C : 1010	      IF(BTEST(STREAM(I).FLAGS,FLG_V_EXITING))GOTO189 	      STREAM(I).ITEMNO=0 ( 	      STREAM(I).INDEX=STREAM(I).INDEX+1 	      GOTO1021  C D C	Task processing -- if last item was read, send next item and go on C , 1020	      IF(STREAM(I).IOSB(1).EQ.0)GOTO189 C 4 C	New code in V3.5.1: if I/O failed, kill the stream C % 	      IF(.NOT.STREAM(I).IOSB(1))THEN E 	         CALL LOGGIT('IOSB shows failure; resetting stream ',I*16+6) ; 	         CALL LOGGIT('Stream I/O stat=',STREAM(I).IOSB(1)) 3 	         RESETLIST(1).BUFLEN=STREAM(I).OURNAME_LEN * 	         RESETLIST(1).ITEMCODE=SJC$_QUEUE5 	         RESETLIST(1).BUFADR=%LOC(STREAM(I).OURNAME) " 	         RESETLIST(1).RETLENADR=0# 	         RESETLIST(2).TERMINATOR=0 H 	         ISTAT=SYS$SNDJBCW(,%VAL(SJC$_RESET_QUEUE),,%REF(RESETLIST),,,)9 	         CALL LOGGIT('$SNDJBCW RESET_QUEUE stat=',ISTAT)  	         STREAM(I).IOSB(1)=0  	         GOTO189  	      ENDIF C . 1021	      STREAM(I).ITEMNO=STREAM(I).ITEMNO+12 	      ITEM_CODE=STREAM(I).ORDER(STREAM(I).ITEMNO) C D C	Zero item code indicates end of items, and requires command "item"/ C	to be sent; otherwise, send item as requested  C ! 	      IF(ITEM_CODE.EQ.0)GOTO1025 " 	      L=STREAM(I).SIZE(ITEM_CODE) C 8 C	If item is null and stream specified NONULL, skip item C H 	      IF((L.EQ.0).AND.(.NOT.BTEST(STREAM(I).FLAGS,FLG_V_NULL)))GOTO1021" 	      IP=STREAM(I).POS(ITEM_CODE) 	      IF(IP.LE.0)THEN 	         IF(L.EQ.0)THEN 	            IP=1  	         ELSE7 	            CALL LOGGIT('Bad non-null item position',)  	            GOTO1021  	         ENDIF  	      ENDIF C A C	Send item in binary form or ASCII form, as specified for stream  C 2 	      IF(BTEST(STREAM(I).FLAGS,FLG_V_BINARY))THENE 	         CALL WRITE_MBX_BINARY(I,ITEM_CODE,STREAM(I).MSG(IP:IP+L-1))  	      ELSE # 	         IT=SMBITEMTYPE(ITEM_CODE) # 	         IF(IT.EQ.1.OR.L.EQ.0)THEN 9 	            CALL WRITE_MBX_ASCII(I,SMBITEM(ITEM_CODE)(1: > 	1            SMBITEMLEN(ITEM_CODE)),STREAM(I).MSG(IP:IP+L-1)) 	         ELSEA 	            CALL ITEMEDIT(EDITBUF,STREAM(I).MSG(IP:IP+L-1),LE,L, % 	1            SMBITEMTYPE(ITEM_CODE)) 9 	            CALL WRITE_MBX_ASCII(I,SMBITEM(ITEM_CODE)(1: 3 	1            SMBITEMLEN(ITEM_CODE)),EDITBUF(1:LE))  	         ENDIF      	      ENDIF 	      GOTO1020  C D C	After all items sent, initialize status to zero (indicating statusG C	not yet received) and write the "EXECUTE" command pseudo-item to the  , C	process; then, enter wait-for-status state C 8 1025	      IF(BTEST(STREAM(I).FLAGS,FLG_V_FLAGSENT))THEN 	         STREAM(I).STATUS=05 	         IF(BTEST(STREAM(I).FLAGS,FLG_V_BINARY))THEN 7 	            CALL WRITE_MBX_BINARY(I,%REF(0),'EXECUTE')  	         ELSE: 	            CALL WRITE_MBX_ASCII(I,'EXEC_STEP','EXECUTE') 	         ENDIF A 	         STREAM(I).FLAGS=STREAM(I).FLAGS.AND..NOT.FLG_M_FLAGSENT  	         GOTO188 5 	      ELSE IF(BTEST(STREAM(I).FLAGS,FLG_V_FLAG))THEN 6 	         IF(BTEST(STREAM(I).FLAGS,FLG_V_ENTERED))THEN  	            STRN(1:7)='/SPOOL/' 	            L_STRN=7  	         ELSE 	            STRN(1:2)='//'  	            L_STRN=2  	         ENDIF 5 	         IF(BTEST(STREAM(I).FLAGS,FLG_V_BINARY))THEN = 	            CALL WRITE_MBX_BINARY(I,%REF(-1),STRN(1:L_STRN))  	         ELSE@ 	            CALL WRITE_MBX_ASCII(I,'EXEC_FLAGS',STRN(1:L_STRN)) 	         ENDIF ; 	         STREAM(I).FLAGS=STREAM(I).FLAGS.OR.FLG_M_FLAGSENT - 	         STREAM(I).ITEMNO=STREAM(I).ITEMNO-1  	         GOTO189  	      ELSE ; 	         STREAM(I).FLAGS=STREAM(I).FLAGS.OR.FLG_M_FLAGSENT  	         GOTO1025 	      ENDIF C 5 C	Waiting for status -- once status is nonzero, go on  C + 1030	      IF(STREAM(I).STATUS.EQ.0)GOTO189 ( 	      STREAM(I).INDEX=STREAM(I).INDEX+1 C @ C	Task completion state -- if reached normally, clear abort flag C  1040	      STOPPING=.FALSE.  C F C	Merge point from abort code; get status and do completion processing C , 1041	      STATUS_VECTOR(2)=STREAM(I).STATUS C E C	If file was a spool file entered by the AST routine, we must remove E C	its directory entry (since the job controller will delete the file,  C	but won't remove the entry)  C 3 	      IF(BTEST(STREAM(I).FLAGS,FLG_V_ENTERED))THEN  	         CALL SETAST(%REF(0))@ 	         STREAM(I).FLAGS=STREAM(I).FLAGS.AND..NOT.FLG_M_ENTEREDD 	         IX=INDEX(STREAM(I).FILESPEC(1:STREAM(I).FILESPEC_LEN),']') 	         ISTAT=DO_REMOVE(D 	1         STREAM(I).DEVICE_NAME(1:STREAM(I).DEVICE_NAME_LEN)//':'//F 	2         STREAM(I).SPOOLDIR(1:STREAM(I).SPOOLDIR_LEN),STREAM(I).FID,; 	3         STREAM(I).FILESPEC(IX+1:STREAM(I).FILESPEC_LEN))  	         CALL SETAST(%REF(1)). 	         CALL LOGGIT('DO_REMOVE stat=',ISTAT) 	      ENDIF C D C	Reset stream state to idle and set dynamic exit timer (if dynamic) C . 	      STREAM(I).REQUEST=SMBMSG$K_START_STREAM 	      CALL SET_TIMER(I) C J C	If task was aborted, determine whether we did it and proceed accordingly C  	      IF(STOPPING)THEN  C F C	If we aborted the task for requeuing, requeue it (and set checkpoint/ C	indicator according to stream specifications)  C 4 	         IF(BTEST(STREAM(I).FLAGS,FLG_V_ABORT))THEN 	            IF(.NOT.VMSV5)THEN H 	               SJC_QUEUE=STREAM(I).QUEUENAME(1:STREAM(I).QUEUENAME_LEN): 	               ITEMLIST(1).BUFLEN=STREAM(I).QUEUENAME_LEN 	            ENDIF- 	            SJC_ENTRY_NUMBER=STREAM(I).ENTRY 8 	            SJC_AFTER_TIME(1)=STREAM(I).REQUEUE_TIME(1)8 	            SJC_AFTER_TIME(2)=STREAM(I).REQUEUE_TIME(2)< 	            IF(BTEST(STREAM(I).FLAGS,FLG_V_CHECKPOINT))THEN) 	                ITEMLIST(5).TERMINATOR=0  	            ELSE = 	               	ITEMLIST(5).ITEMCODE=SJC$_NO_CHECKPOINT_DATA ) 	                ITEMLIST(6).TERMINATOR=0  	            ENDIF C A C	V3.6.0: if HOLD flag set, insert HOLD code, else insert NO_HOLD  C 6 	            IF(BTEST(STREAM(I).FLAGS,FLG_V_HOLD))THEN. 	               ITEMLIST(3).ITEMCODE=SJC$_HOLD 	            ELSE 1 	               ITEMLIST(3).ITEMCODE=SJC$_NO_HOLD  	            ENDIF 	         ENDIF  C F C	Since we can't requeue an active task, and this task got a STOP_TASKA C	request, complete the request by returning a status to the job  G C	controller.  This will put the job back into the queue, where we can   C	manipulate it. C + 	         ISTAT=SMB$SEND_TO_JOBCTL(%REF(I), 8 	1         %REF(SMBMSG$K_STOP_TASK),STREAM(I).ACCDATSTR,! 	2         ,,%REF(STATUS_VECTOR)) 8 	         CALL LOGGIT('SEND_TO_JOBCTL STOP stat=',ISTAT) C D C	If we are requeuing the job, modify it to specify the AFTER-time, E C	and release the HOLD on it.  (NOTE:  Prior to VMS V4.2, this didn't D C	work correctly in one step, i.e. you couldn't both RELEASE the job@ C	and set its AFTER attribute in one operation.  The roundabout D C	solution, used by Jan and Don Provan in their MFENET code, was to F C	alter the held job to have characteristic 127, release the job, and G C	finally modify the released job to both clear characteristic 127 and  F C	set the AFTER-time, which worked.  I am assuming that this will run ; C	under VMS V4.2 or later, so that method isn't necessary.)  C 4 	         IF(BTEST(STREAM(I).FLAGS,FLG_V_ABORT))THENE 	            ISTAT=SYS$SNDJBCW(,%VAL(SJC$_ALTER_JOB),,%REF(ITEMLIST),  	1            IOSB,,) 6 	            CALL LOGGIT('$SNDJBCW ALTER stat=',ISTAT)8 	            CALL LOGGIT('$SNDJBCW ALTER IOSB=',IOSB(1)) 	         ENDIF  	      ELSE  C D C	If we are not killing the job, send a TASK_COMPLETE status to the E C	job controller, completing the task and making the stream ready for  C	another job. C + 	         ISTAT=SMB$SEND_TO_JOBCTL(%REF(I), < 	1         %REF(SMBMSG$K_TASK_COMPLETE),STREAM(I).ACCDATSTR,! 	2         ,,%REF(STATUS_VECTOR)) < 	         CALL LOGGIT('SEND_TO_JOBCTL COMPLETE stat=',ISTAT) 	      ENDIF 	      GOTO189 C E C	Aborting the task -- set the STOPPING flag, and determine which of  ! C	several scenarios is occurring.  C  1050	      STOPPING=.TRUE. C > C	If stream is being reset, we need to kill the job, tell the ; C	process to exit, and set the stream status to STOP_STREAM  C 9 	      IF(STREAM(I).REQUEST.EQ.SMBMSG$K_RESET_STREAM)THEN  	         CALL SETAST(%REF(0))6 	         IF(BTEST(STREAM(I).FLAGS,FLG_V_DYNAMIC).AND.9 	1         BTEST(STREAM(I).FLAGS,FLG_V_NO_PROCESSOR))THEN ( 	            CALL FAKE_DYNAMIC_EXIT(I,1) 	         ELSE" 	            CALL SEND_EXIT_MSG(I) 	         ENDIF 0 	         STREAM(I).REQUEST=SMBMSG$K_STOP_STREAM< 	         STREAM(I).FLAGS=STREAM(I).FLAGS.OR.FLG_M_RESETTING) 	         ACTIVE_STREAMS=ACTIVE_STREAMS-1  	         CALL SETAST(%REF(1)) 	         GOTO189  	      ELSE  C B C	If the stream wasn't being reset (stopped), tell the process to / C	reset itself to its initial state, and go on.  C 5 	         IF(BTEST(STREAM(I).FLAGS,FLG_V_BINARY))THEN . 	            CALL WRITE_MBX_BIN_X(I,0,'RESET') 	         ELSE8 	            CALL WRITE_MBX_ASC_X(I,'EXEC_STEP','RESET') 	         ENDIF  	      ENDIF 	      GOTO1041  C D C	After completing as much as can be done in the present task state,B C	come here.  If the task state completed its work, advance to theF C	next state and clear the hibernation flag.  If the state is waiting @ C	for something (e.g. a status, or completion of a QIO), let theC C	hibernate flag remain as-is, and keep the same task state number.  C C 188	      IF(STREAM(I).INDEX.LT.4)STREAM(I).INDEX=STREAM(I).INDEX+1  	      DO_HIBER=.FALSE.  189	      CONTINUE C C C	PAUSE_TASK indicates that task is paused -- stream is active, but $ C	there's no reason not to hibernate C 9 	   ELSE IF(STREAM(I).REQUEST.EQ.SMBMSG$K_PAUSE_TASK)THEN & 	      ACTIVE_STREAMS=ACTIVE_STREAMS+1 	   ELSE C E C	Should never reach here -- REQUEST (stream status) value is illegal  C G 	      CALL SYS$FAO(' !2UB=!8XL',,STRN,%VAL(I),%VAL(STREAM(I).REQUEST)) 0 	      CALL LOGGIT('Bad request: stream'//STRN,)	 	   ENDIF  C 7 C	End of main processing loop, executed once per stream  C  	ENDDO C C C	Assume we have to do a wakeup to get ourselves moving again; this C C	prevents race condition between hibernation code in non-AST state  C	and wakeup code in AST state.  C  	DO_WAKE=.TRUE.  C F C	If no stream had a reason to keep us from hibernating, we hibernate.D C	If there were no active streams, though, we have no reason to keepF C	running, so we must exit.  (Job controller will NOT recognize us as @ C	a symbiont if we stay active, so we have to exit when no more  C	streams are active.) C  	IF(DO_HIBER)THEN  	   IF(ACTIVE_STREAMS.EQ.0)THEN 9 	      CALL TELL_OPER('All streams inactive, exiting.',3)  	      PROCESS_NAME(14:14)='-', 	      CALL SYS$SETPRN(%DESCR(PROCESS_NAME)) 	      DO I=1,MAXUSED+1 3 	         CALL SYS$DELLNM('LNM$GROUP','EXECSYMB_'// 3 	1         PROCESS_NAME(15:15)//STREAM_CHARS(I:I),)  	      ENDDOD 	      CALL TELL_OPER('EXECSYMB '//VERSION_NUMBER//' terminated.',3) 	      CALL EXIT_PROCESS(1) 	 	   ENDIF  C F C	Hibernate.  If an AST routine spotted the fact that the DO_WAKE flagA C	was set, and posted a SYS$WAKE already, this SYS$HIBER will do  . C	nothing more than cancel the pending wakeup. C  	   ISTAT=SYS$HIBER()  C C C	(Note that the following message, if it appears, will be printed   C	*after* wakeup!) C % 	   CALL LOGGIT('$HIBER stat=',ISTAT)  	ENDIF C C C	Once we are past the hibernate code, clear the wakeup flag (thus, E C	we cannot enter the state where the non-AST code hibernates but the 8 C	AST-level code thinks it doesn't need to do a wakeup.) C  	DO_WAKE=.FALSE. C E C	Done with one pass through all the streams, so go back through the   C	main loop  C 	 	GOTO1000  C : C	If we can't create the log file, exit with ABORT status. C @ 99	CALL TELL_OPER('Exiting due to create failure on log file',4) 	CALL EXIT_PROCESS('2C'X)  	END C @ C	READ_EXIT_MBX -- Post a read QIO with AST on the process-exit  C	mailbox channel  C  	SUBROUTINE READ_EXIT_MBX  	IMPLICIT NONE 	INCLUDE 'EXECSYMB.INC'  	INCLUDE '($IODEF)'  	EXTERNAL EXIT_AST 	INTEGER*4 SYS$QIO 	INTEGER*4 ISTAT$ 	ISTAT=SYS$QIO(,%VAL(EXIT_MBX_CHAN),' 	1 %VAL(IO$_READVBLK),,%REF(EXIT_AST),,  	2 %REF(EXITBUF),%VAL(12),,,,). 	CALL LOGGIT('READ_EXIT_MBX $QIO stat=',ISTAT) 	RETURN  	END C F C	READ_STAT_MBX -- post a read QIO with AST on the task status-return  C	mailbox channel  C  	SUBROUTINE READ_STAT_MBX  	IMPLICIT NONE 	INCLUDE 'EXECSYMB.INC'  	INCLUDE '($IODEF)'  	EXTERNAL IO_DONE_AST  	INTEGER*4 SYS$QIO 	INTEGER*4 ISTAT& 	ISTAT=SYS$QIO(,%VAL(STAT_W_MBX_CHAN),8 	1 %VAL(IO$_READVBLK),%REF(STATIOSB),%REF(IO_DONE_AST),, 	2 %REF(STATBUF),%VAL(268),,,,) . 	CALL LOGGIT('READ_STAT_MBX $QIO stat=',ISTAT) 	RETURN  	END C E C	MSG_AST -- routine called by the shareable symbiont code when a new E C	request message is received from the job controller.  This routine  = C	does all of the initialization in setting up a new request.  C  	SUBROUTINE MSG_AST  C < C	First, make implicit declaration and specify INCLUDE files C  	IMPLICIT NONE 	INCLUDE 'EXECSYMB.INC'  	INCLUDE '($SJCDEF)' 	INCLUDE '($PRCDEF)' 	INCLUDE '($LNMDEF)' 	INCLUDE '($SSDEF)'  	INCLUDE 'ITEMDEF.INC' C % C	System services called as functions  C B 	INTEGER*4 SYS$CANTIM,SYS$BINTIM,SYS$ASCTIM,SYS$SNDJBCW,SYS$CRELNM C ' C	Process creation flags for processors  C  	INTEGER*4 PRC_FLAGS; 	PARAMETER (PRC_FLAGS=PRC$M_NOUAF+PRC$M_DETACH+PRC$M_HIBER)  C > C	Item list for setting JOB_RESET_MODULES, stream logical name C  	RECORD /ITEM/ SJCLIST(3)  	RECORD /ITEM/ LNMLIST(2)  C $ C	Other routines called as functions C 7 	INTEGER*4 SMB$READ_MESSAGE,DO_ENTER,SMB$SEND_TO_JOBCTL  C C C	Local storage for holding current message, and item position/size : C	arrays for messages that aren't inserted into stream SCB C ! 	CHARACTER*(MAX_MSG_SIZE) MESSAGE G 	INTEGER*2 POS(SMBMSG$K_MAX_ITEM_CODE-1),SIZE(SMBMSG$K_MAX_ITEM_CODE-1)  C  C	Miscellaneous local storage  C ! 	INTEGER*4 ISTAT,STATUS_VECTOR(2)  	INTEGER*4 NSTREAM,NEWREQUEST $ 	CHARACTER*256 NEW_JOB_RESET_MODULES 	INTEGER*2 LEN_NJRM  	INTEGER*2 DID(3) 
 	BYTE BYTE 	INTEGER*2 WORD  	INTEGER*4 LONG  	LOGICAL*1 REALLY_START_TASK3 	INTEGER*4 L,IX,IP,IY,IL,JC1,JC2,ITEMP,ISTAT_CREPRC  C ) C	Process name (need last character only)  C  	CHARACTER*32 STREAM_CHARS 	CHARACTER*14 FILLER 	CHARACTER*1 SYMB_INDEX / 	COMMON /PRCNAM/ STREAM_CHARS,FILLER,SYMB_INDEX  C ' C	Data declarations for local variables  C  	DATA STATUS_VECTOR/1,1/ C  C	Start of MSG_AST code  C F C	Call process wakeup routine first -- getting a new message is reason C	to wake up non-AST code  C  	CALL WAKEUP C F C	Read the message from the job controller via shareable symbiont code C G 	ISTAT=SMB$READ_MESSAGE(%REF(NSTREAM),%DESCR(MESSAGE),%REF(NEWREQUEST)) ( 	CALL LOGGIT('READ_MESSAGE stat=',ISTAT)& 	IF(NSTREAM.GT.MAXUSED)MAXUSED=NSTREAM C E C	If this is a dynamic processor and the processor exists, cancel its  C	timer request. C 8 	IF(BTEST(STREAM(NSTREAM).FLAGS,FLG_V_DYNAMIC).AND..NOT.7 	1 BTEST(STREAM(NSTREAM).FLAGS,FLG_V_NO_PROCESSOR))THEN & 	   ISTAT=SYS$CANTIM(%VAL(NSTREAM+1),)& 	   CALL LOGGIT('$CANTIM stat=',ISTAT) 	ENDIF C D C	If START_TASK request, parse message items into stream SCB's item C C	position and size arrays, and initialize directory fileid, device H C	name length, and task abort and retry inhibit flags.  Also initialize  C	accounting data. C * 	IF(NEWREQUEST.EQ.SMBMSG$K_START_TASK)THENE 	   CALL PARSEMSG(MESSAGE,STREAM(NSTREAM).POS,STREAM(NSTREAM).SIZE,L)  	   DID(1)=0 	   DID(2)=0 	   DID(3)=0% 	   STREAM(NSTREAM).DEVICE_NAME_LEN=0 4 	   STREAM(NSTREAM).FLAGS=STREAM(NSTREAM).FLAGS.AND.. 	1   .NOT.(FLG_M_ABORT.OR.FLG_M_RETRY_INHIBIT) 	   STREAM(NSTREAM).ACCDAT(1)=0  	   STREAM(NSTREAM).ACCDAT(2)=0  	   STREAM(NSTREAM).ACCDAT(3)=0  	   STREAM(NSTREAM).ACCDAT(4)=0  	ELSE  C C C	For all other requests, parse items into local position and size   C	arrays C % 	   CALL PARSEMSG(MESSAGE,POS,SIZE,L)  	ENDIF C B C	If request was RESET_STREAM, determine current stream state and  C	handle accordingly C , 	IF(NEWREQUEST.EQ.SMBMSG$K_RESET_STREAM)THEN C : C	If stream being reset is idle (START_STREAM) or stopped ; C	(STOP_STREAM) then change request to a simple STOP_STREAM  C ; 	   IF(STREAM(NSTREAM).REQUEST.EQ.SMBMSG$K_START_STREAM.OR. 9 	1   STREAM(NSTREAM).REQUEST.EQ.SMBMSG$K_STOP_STREAM)THEN & 	      NEWREQUEST=SMBMSG$K_STOP_STREAME 	      STREAM(NSTREAM).FLAGS=STREAM(NSTREAM).FLAGS.OR.FLG_M_RESETTING  	   ELSE C ? C	Otherwise (task active, stream in START_TASK or PAUSE_TASK or A C	STOP_TASK state), set stream task state index to 5 (abort task)  C  	      STREAM(NSTREAM).INDEX=5	 	   ENDIF  	ENDIF C G C	If request is START_STREAM, process stream initialization information  C	specified in various items C , 	IF(NEWREQUEST.EQ.SMBMSG$K_START_STREAM)THEN C F C	Get EXECUTOR_QUEUE item and use it to determine OURNAME (which gives C	process its name)  C  	   IX=SMBMSG$K_EXECUTOR_QUEUE 	   L=SIZE(IX)= 	   STREAM(NSTREAM).OURNAME(1:L)=MESSAGE(POS(IX):POS(IX)+L-1) ! 	   STREAM(NSTREAM).OURNAME_LEN=L  C E C	V3.5.1 (20Dec93): get explicit queue working set parameters, if any  C " 	   CALL GET_QUEUE_PARAMS(NSTREAM) C 8 C	Get DEVICE_NAME item and use it to determine OURDEVICE C  	   IX=SMBMSG$K_DEVICE_NAME  	   L=SIZE(IX)? 	   STREAM(NSTREAM).OURDEVICE(1:L)=MESSAGE(POS(IX):POS(IX)+L-1) # 	   STREAM(NSTREAM).OURDEVICE_LEN=L  C D C	Get LIBRARY_SPECIFICATION item, strip off "SYS$LIBRARY:" that was C C	put on its front, and ".TLB" that was put on its end, and use the F C	resulting string as the name of the stream's command procedure file. C % 	   IX=SMBMSG$K_LIBRARY_SPECIFICATION  	   L=SIZE(IX)-16 " 	   STREAM(NSTREAM).COM_FILE_LEN=LB 	   STREAM(NSTREAM).COM_FILE(1:L)=MESSAGE(POS(IX)+12:POS(IX)+L+11) C F C	Get JOB_RESET_MODULES item.  (This is a character string that is notB C	interpreted by the job controller.)  Use the item as a means for C	passing stream parameters. C 9 C	Values recognized in this string (separated by commas): & C		TIME="d hh:mm:ss.cc"	(requeue time)6 C		ITEMS="itemlist"	(list of NN or MM:NN item numbers)8 C		SPOOL=[spooldir]	(directory for entering spool files)+ C		ASCII or BINary		(how values are passed) $ C		PRINTer or SERVER	(type of queue)2 C		NONULl or NULL		(whether null items are passed) C		CHECKpoint or NOCHECKpoint + C					(whether jobs restart from beginning)  C		COPY={ALL, First, or Last} ) C					(which copy of job/file to process) 7 C		USER=username		(username under which to run process) 7 C		DYN="d hh:mm:ss.cc"	(timeout for dynamic start/stop) ) C		FLAG			(send EXEC_FLAGS for each task) ; C		INIT or NOINIT		(with DYN=x; start queue proc initially)  C 5 C	Defaults:	no requeue, no ITEMS, no SPOOL directory, / C			ASCII, SERVER, NULL, CHECKpoint, COPY=ALL,    C			USER=SYSTEM, no FLAG, NOINIT C & 	   IP=POS(SMBMSG$K_JOB_RESET_MODULES)& 	   L=SIZE(SMBMSG$K_JOB_RESET_MODULES) C * C	First, initialize all values to defaults C  	   LEN_NJRM=0C 	   STREAM(NSTREAM).FLAGS=FLG_M_NULL+FLG_M_CHECKPOINT+FLG_M_COPYALL + 	   STREAM(NSTREAM).SPOOLDIR_LEN=0          % 	   STREAM(NSTREAM).USERNAME='SYSTEM'  C " C	Parse for requeue time parameter C ( 	   IX=INDEX(MESSAGE(IP:IP+L-1),'TIME=') C = C	From there to next comma (or end of string) is requeue time  C  	   IF(IX.NE.0)THEN - 	      IY=INDEX(MESSAGE(IP+IX:IP+L-1),',')+IX  	      IF(IY.EQ.IX)IY=L+1 1 	      ISTAT=SYS$BINTIM(MESSAGE(IP+IX+4:IP+IY-2), ( 	1      STREAM(NSTREAM).REQUEUE_TIME(1))* 	      CALL LOGGIT('$BINTIM1 stat=',ISTAT)3 	      IF(STREAM(NSTREAM).REQUEUE_TIME(2).GE.0)THEN  	         ISTAT='2A'X 0 	         CALL LOGGIT('$BINTIM1 absolute time',) 	      ENDIF C E C	If $BINTIM converts requeue time successfully, indicate that stream  C	is to requeue aborted jobs C & 	      IF(ISTAT)STREAM(NSTREAM).FLAGS=1 	1      STREAM(NSTREAM).FLAGS.OR.FLG_M_DO_REQUEUE  C A C	Blank out part of string that contained requeue time parameter, : C	and add edited requeue time to actual parameters string. C # 	      MESSAGE(IP+IX-1:IP+IY-2)=' ' ; 	      NEW_JOB_RESET_MODULES(LEN_NJRM+1:LEN_NJRM+6)='TIME='  	      LEN_NJRM=LEN_NJRM+6G 	      ISTAT=SYS$ASCTIM(IY,NEW_JOB_RESET_MODULES(LEN_NJRM:LEN_NJRM+15), ) 	1      STREAM(NSTREAM).REQUEUE_TIME(1),) * 	      CALL LOGGIT('$ASCTIM1 stat=',ISTAT) C A C	Adjust converted requeue time to eliminate extra spaces, zeroes  C C 	      CALL FIXTIME(NEW_JOB_RESET_MODULES(LEN_NJRM:LEN_NJRM+15),IY)  	      LEN_NJRM=LEN_NJRM+IY-1 	 	   ENDIF  C % C	Parse for dynamic timeout parameter  C ' 	   IX=INDEX(MESSAGE(IP:IP+L-1),'DYN=')  C E C	From there to next comma (or end of string) is dynamic timeout time - C                                              	   IF(IX.NE.0)THEN - 	      IY=INDEX(MESSAGE(IP+IX:IP+L-1),',')+IX  	      IF(IY.EQ.IX)IY=L+1 1 	      ISTAT=SYS$BINTIM(MESSAGE(IP+IX+3:IP+IY-2), ( 	1      STREAM(NSTREAM).DYNAMIC_TIME(1))* 	      CALL LOGGIT('$BINTIM2 stat=',ISTAT)3 	      IF(STREAM(NSTREAM).DYNAMIC_TIME(2).GE.0)THEN  	         ISTAT='2A'X 0 	         CALL LOGGIT('$BINTIM2 absolute time',) 	      ENDIF C H C	If $BINTIM converts time successfully, indicate that stream processor A C	is to be started and stopped dynamically, independent of queue.  C & 	      IF(ISTAT)STREAM(NSTREAM).FLAGS=. 	1      STREAM(NSTREAM).FLAGS.OR.FLG_M_DYNAMIC C 9 C	Blank out part of string that contained time parameter, 2 C	and add edited time to actual parameters string. C # 	      MESSAGE(IP+IX-1:IP+IY-2)=' '  	      IF(LEN_NJRM.NE.0)THEN 	         LEN_NJRM=LEN_NJRM+1 6 	         NEW_JOB_RESET_MODULES(LEN_NJRM:LEN_NJRM)=',' 	      ENDIF: 	      NEW_JOB_RESET_MODULES(LEN_NJRM+1:LEN_NJRM+5)='DYN=' 	      LEN_NJRM=LEN_NJRM+5G 	      ISTAT=SYS$ASCTIM(IY,NEW_JOB_RESET_MODULES(LEN_NJRM:LEN_NJRM+15), ) 	1      STREAM(NSTREAM).DYNAMIC_TIME(1),) * 	      CALL LOGGIT('$ASCTIM2 stat=',ISTAT) C 9 C	Adjust converted time to eliminate extra spaces, zeroes  C C 	      CALL FIXTIME(NEW_JOB_RESET_MODULES(LEN_NJRM:LEN_NJRM+15),IY)  	      LEN_NJRM=LEN_NJRM+IY-1 	 	   ENDIF  C A C	Look for list of item codes to be passed to subroutine, and use D C	PARSE_ITEMS routine to set up the ORDER array with specified codes C ) 	   IX=INDEX(MESSAGE(IP:IP+L-1),'ITEMS=') C 	   CALL PARSE_ITEMS(MESSAGE(IP+IX+5:IP+L-1),STREAM(NSTREAM).ORDER)  C G C	Then, edit ORDER array into new JOB_RESET_MODULES (stream parameters)  C	string C H 	   CALL EDIT_NJRM(STREAM(NSTREAM).ORDER,NEW_JOB_RESET_MODULES,LEN_NJRM) C  C	Look for spool directory name  C * 	   IX=INDEX(MESSAGE(IP:IP+L-1),'SPOOL=[') C I C	Find terminator for name, and add entry to new stream parameters string  C  	   IF(IX.NE.0)THEN - 	      IY=INDEX(MESSAGE(IP+IX:IP+L-1),']')+IX  	      IF(IY.EQ.IX)GOTO1118  	      IL=IY-IX-5  	      IF(LEN_NJRM.NE.0)THEN 	         LEN_NJRM=LEN_NJRM+1 6 	         NEW_JOB_RESET_MODULES(LEN_NJRM:LEN_NJRM)=',' 	      ENDIF7 	      NEW_JOB_RESET_MODULES(LEN_NJRM+1:LEN_NJRM+IL+6)=   	1      MESSAGE(IP+IX-1:IP+IY-1) 	      LEN_NJRM=LEN_NJRM+IL+6  C B C	Turn spool directory name into name of file that represents that& C	directory, so we can get its fileid. C & 	      STREAM(NSTREAM).SPOOLDIR_LEN=IL8 	      STREAM(NSTREAM).SPOOLDIR=MESSAGE(IP+IX+5:IP+IY-1)# 	      MESSAGE(IP+IX-1:IP+IY-1)=' ' 3 	      IX=INDEX(STREAM(NSTREAM).SPOOLDIR(1:IL),'.')  C D C	If name contains no subdirectory, change it to a file in [000000]./ C	e.g., change [SPOOL] into [000000]SPOOL.DIR;0  C  	      IF(IX.EQ.0)THEN7 	         STREAM(NSTREAM).SPOOLDIR(2:IL+12)='000000]'// 5 	1         STREAM(NSTREAM).SPOOLDIR(2:IL-1)//'.DIR;0' , 	         STREAM(NSTREAM).SPOOLDIR_LEN=IL+12 	      ELSE  C B C	If name contains a subdirectory, change it to a file in the next C	higher directory. 8 C	e.g., change [SPOOL.FOO.BAR] into [SPOOL.FOO]BAR.DIR;0 C  	         DO IY=IL-2,IX+1,-1? 	            IF(STREAM(NSTREAM).SPOOLDIR(IY:IY).EQ.'.')GOTO1117  	         ENDDO  	         IY=IX 1 1117	         STREAM(NSTREAM).SPOOLDIR(IY:IY)=']' 4 	         STREAM(NSTREAM).SPOOLDIR(IL:IL+5)='.DIR;0'+ 	         STREAM(NSTREAM).SPOOLDIR_LEN=IL+5  	      ENDIF	 	   ENDIF  C  C	Check for USER=username  C , 1118	   IX=INDEX(MESSAGE(IP:IP+L-1),'USER=') C I C	Find terminator for name, and add entry to new stream parameters string  C  	   IF(IX.NE.0)THEN / 	      IY=INDEX(MESSAGE(IP+IX:IP+L-1),',')+IX-1  	      IF(IY.EQ.IX-1)IY=L 8 	      STREAM(NSTREAM).USERNAME=MESSAGE(IP+IX+4:IP+IY-1)3 	      IF(STREAM(NSTREAM).USERNAME.NE.'SYSTEM')THEN  	         IF(LEN_NJRM.GT.0)THEN   	            LEN_NJRM=LEN_NJRM+19 	            NEW_JOB_RESET_MODULES(LEN_NJRM:LEN_NJRM)=','  	         ENDIF > 	         NEW_JOB_RESET_MODULES(LEN_NJRM+1:LEN_NJRM+5)='USER='= 	         NEW_JOB_RESET_MODULES(LEN_NJRM+6:LEN_NJRM+IY-IX+1)= # 	1         MESSAGE(IP+IX+4:IP+IY-1) # 	         LEN_NJRM=LEN_NJRM+IY-IX+1  	      ENDIF# 	      MESSAGE(IP+IX-1:IP+IY-1)=' ' 	 	   ENDIF  C = C	V3.6.0: Check for HOLD flag (if not present, assume NOHOLD)  C ' 	   IX=INDEX(MESSAGE(IP:IP+L-1),'HOLD')  	   IF(IX.NE.0)THEN D 	      STREAM(NSTREAM).FLAGS=STREAM(NSTREAM).FLAGS.OR.FLG_M_HOLD.OR. 	1      FLG_M_DO_REQUEUE( 	      STREAM(NSTREAM).REQUEUE_TIME(1)=0( 	      STREAM(NSTREAM).REQUEUE_TIME(2)=0 	      IF(LEN_NJRM.NE.0)THEN 	         LEN_NJRM=LEN_NJRM+1 6 	         NEW_JOB_RESET_MODULES(LEN_NJRM:LEN_NJRM)=',' 	      ENDIF: 	      NEW_JOB_RESET_MODULES(LEN_NJRM+1:LEN_NJRM+4)='HOLD' 	      LEN_NJRM=LEN_NJRM+4	 	   ENDIF  C 6 C	Check for BINARY flag (if not present, assume ASCII) C & 	   IX=INDEX(MESSAGE(IP:IP+L-1),'BIN') 	   IF(IX.NE.0)THEN B 	      STREAM(NSTREAM).FLAGS=STREAM(NSTREAM).FLAGS.OR.FLG_M_BINARY 	      IF(LEN_NJRM.NE.0)THEN 	         LEN_NJRM=LEN_NJRM+1 6 	         NEW_JOB_RESET_MODULES(LEN_NJRM:LEN_NJRM)=',' 	      ENDIF9 	      NEW_JOB_RESET_MODULES(LEN_NJRM+1:LEN_NJRM+3)='BIN'  	      LEN_NJRM=LEN_NJRM+3	 	   ENDIF  C 8 C	Check for PRINTER flag (if not present, assume SERVER) C ( 	   IX=INDEX(MESSAGE(IP:IP+L-1),'PRINT') 	   IF(IX.NE.0)THEN F 	      STREAM(NSTREAM).FLAGS=STREAM(NSTREAM).FLAGS.OR.FLG_M_PRINTQUEUE 	      IF(LEN_NJRM.NE.0)THEN 	         LEN_NJRM=LEN_NJRM+1 6 	         NEW_JOB_RESET_MODULES(LEN_NJRM:LEN_NJRM)=',' 	      ENDIF; 	      NEW_JOB_RESET_MODULES(LEN_NJRM+1:LEN_NJRM+5)='PRINT'  	      LEN_NJRM=LEN_NJRM+5	 	   ENDIF  C 5 C	Check for NONULL flag (if not present, assume NULL)  C ( 	   IX=INDEX(MESSAGE(IP:IP+L-1),'NONUL') 	   IF(IX.NE.0)THEN F 	      STREAM(NSTREAM).FLAGS=STREAM(NSTREAM).FLAGS.AND..NOT.FLG_M_NULL 	      IF(LEN_NJRM.NE.0)THEN 	         LEN_NJRM=LEN_NJRM+1 6 	         NEW_JOB_RESET_MODULES(LEN_NJRM:LEN_NJRM)=',' 	      ENDIF; 	      NEW_JOB_RESET_MODULES(LEN_NJRM+1:LEN_NJRM+5)='NONUL'  	      LEN_NJRM=LEN_NJRM+5	 	   ENDIF  C A C	Check for NOCHECKpoint flag (if not present, assume CHECKpoint)  C * 	   IX=INDEX(MESSAGE(IP:IP+L-1),'NOCHECK') 	   IF(IX.NE.0)THEN 7 	      STREAM(NSTREAM).FLAGS=STREAM(NSTREAM).FLAGS.AND.  	1      .NOT.FLG_M_CHECKPOINT  	      IF(LEN_NJRM.NE.0)THEN 	         LEN_NJRM=LEN_NJRM+1 6 	         NEW_JOB_RESET_MODULES(LEN_NJRM:LEN_NJRM)=',' 	      ENDIF= 	      NEW_JOB_RESET_MODULES(LEN_NJRM+1:LEN_NJRM+7)='NOCHECK'  	      LEN_NJRM=LEN_NJRM+7	 	   ENDIF  C 5 C	Check for FLAG flag (if not present, assume NOFLAG)  C ' 	   IX=INDEX(MESSAGE(IP:IP+L-1),'FLAG')  	   IF(IX.NE.0)THEN @ 	      STREAM(NSTREAM).FLAGS=STREAM(NSTREAM).FLAGS.OR.FLG_M_FLAG 	      IF(LEN_NJRM.NE.0)THEN 	         LEN_NJRM=LEN_NJRM+1 6 	         NEW_JOB_RESET_MODULES(LEN_NJRM:LEN_NJRM)=',' 	      ENDIF: 	      NEW_JOB_RESET_MODULES(LEN_NJRM+1:LEN_NJRM+4)='FLAG' 	      LEN_NJRM=LEN_NJRM+4	 	   ENDIF  C 5 C	Check for INIT flag (if not present, assume NOINIT)  C ' 	   IX=INDEX(MESSAGE(IP:IP+L-1),'INIT')  	   IF(IX.NE.0)THEN C 	      STREAM(NSTREAM).FLAGS=STREAM(NSTREAM).FLAGS.OR.FLG_M_INITREQ  	      IF(LEN_NJRM.NE.0)THEN 	         LEN_NJRM=LEN_NJRM+1 6 	         NEW_JOB_RESET_MODULES(LEN_NJRM:LEN_NJRM)=',' 	      ENDIF: 	      NEW_JOB_RESET_MODULES(LEN_NJRM+1:LEN_NJRM+4)='INIT' 	      LEN_NJRM=LEN_NJRM+4	 	   ENDIF  C  C	Check COPY parameter C ) 	   IX=INDEX(MESSAGE(IP:IP+L-1),'COPY=F')  C C C	If COPY=FIRST, indicate stream doesn't want all copies, and wants   C	first copy of each job or file C  	   IF(IX.NE.0)THEN 7 	      STREAM(NSTREAM).FLAGS=STREAM(NSTREAM).FLAGS.AND.  	1      .NOT.FLG_M_COPYALLE 	      STREAM(NSTREAM).FLAGS=STREAM(NSTREAM).FLAGS.OR.FLG_M_COPYFIRST  	      IF(LEN_NJRM.NE.0)THEN 	         LEN_NJRM=LEN_NJRM+1 6 	         NEW_JOB_RESET_MODULES(LEN_NJRM:LEN_NJRM)=',' 	      ENDIF< 	      NEW_JOB_RESET_MODULES(LEN_NJRM+1:LEN_NJRM+6)='COPY=F' 	      LEN_NJRM=LEN_NJRM+6	 	   ENDIF ) 	   IX=INDEX(MESSAGE(IP:IP+L-1),'COPY=L')  C F C	If COPY=LAST specified, indicate stream doesn't want all copies, and@ C	doesn't want first copy.  (If neither COPY=FIRST or COPY=LAST " C	specified, COPY=ALL is assumed.) C  	   IF(IX.NE.0)THEN 7 	      STREAM(NSTREAM).FLAGS=STREAM(NSTREAM).FLAGS.AND.  	1      .NOT.FLG_M_COPYALL 	      IF(LEN_NJRM.NE.0)THEN 	         LEN_NJRM=LEN_NJRM+1 6 	         NEW_JOB_RESET_MODULES(LEN_NJRM:LEN_NJRM)=',' 	      ENDIF< 	      NEW_JOB_RESET_MODULES(LEN_NJRM+1:LEN_NJRM+6)='COPY=L' 	      LEN_NJRM=LEN_NJRM+6	 	   ENDIF  C D C	Set up itemlist for modifying queue's JOB_RESET_MODULES to reflect/ C	non-default parameters that were actually set  C 1 	   SJCLIST(1).BUFLEN=STREAM(NSTREAM).OURNAME_LEN " 	   SJCLIST(1).ITEMCODE=SJC$_QUEUE3 	   SJCLIST(1).BUFADR=%LOC(STREAM(NSTREAM).OURNAME)  	   SJCLIST(1).RETLENADR=0 	   SJCLIST(2).BUFLEN=LEN_NJRM. 	   SJCLIST(2).ITEMCODE=SJC$_JOB_RESET_MODULES1 	   SJCLIST(2).BUFADR=%LOC(NEW_JOB_RESET_MODULES)  	   SJCLIST(2).RETLENADR=0 	   SJCLIST(3).TERMINATOR=0 : 	   ISTAT=SYS$SNDJBCW(,%VAL(SJC$_ALTER_QUEUE),,SJCLIST,,,)/ 	   CALL LOGGIT('MSG_AST $SNDJBCW stat=',ISTAT)  C F C	If request was START_TASK, determine whether we really want to startA C	a task (based upon which copy of the file and job we are being  F C	given, and which copy -- FIRST, LAST, or ALL -- the stream requires) C / 	ELSE IF(NEWREQUEST.EQ.SMBMSG$K_START_TASK)THEN  	   REALLY_START_TASK=.TRUE. C C C	If all copies are passed to stream, we must really start the task  C 6 	   IF(BTEST(STREAM(NSTREAM).FLAGS,FLG_V_COPYALL))THEN 	      CONTINUE  C D C	If the first copy is passed to the stream, check the job count andE C	file count parameters; both must be one in order to start this task  C = 	   ELSE IF(BTEST(STREAM(NSTREAM).FLAGS,FLG_V_COPYFIRST))THEN 1 	      IP=STREAM(NSTREAM).POS(SMBMSG$K_JOB_COUNT) ! 	      JC1=LONG(MESSAGE(IP:IP+3))  	      IF(JC1.NE.1)THEN # 	         REALLY_START_TASK=.FALSE.  	      ELSE 5 	         IP=STREAM(NSTREAM).POS(SMBMSG$K_FILE_COUNT) $ 	         JC2=LONG(MESSAGE(IP:IP+3))8 	         IF(JC2.NE.1)REALLY_START_TASK=.FALSE.          	      ENDIF C C C	If the last copy is passed to the stream, get the JOB_COPIES and  A C	JOB_COUNT items.  They must be equal, or the task is not really 
 C	started. C  	   ELSE2 	      IP=STREAM(NSTREAM).POS(SMBMSG$K_JOB_COPIES)! 	      JC1=LONG(MESSAGE(IP:IP+3)) 1 	      IP=STREAM(NSTREAM).POS(SMBMSG$K_JOB_COUNT) ! 	      JC2=LONG(MESSAGE(IP:IP+3))  	      IF(JC1.NE.JC2)THEN # 	         REALLY_START_TASK=.FALSE.  C @ C	If last copy of the job, check FILE_COPIES against FILE_COUNT.< C	They must also be equal in order to really start the task. C  	      ELSE 6 	         IP=STREAM(NSTREAM).POS(SMBMSG$K_FILE_COPIES)$ 	         JC1=LONG(MESSAGE(IP:IP+3))5 	         IP=STREAM(NSTREAM).POS(SMBMSG$K_FILE_COUNT) $ 	         JC2=LONG(MESSAGE(IP:IP+3))1 	         IF(JC1.NE.JC2)REALLY_START_TASK=.FALSE.  	      ENDIF	 	   ENDIF  C ? C	If we are really starting the task, copy the symbiont message < C	to the stream's SCB, and perform task initialization code. C  	   IF(REALLY_START_TASK)THEN 0 	      STREAM(NSTREAM).MESSAGE(1:L)=MESSAGE(1:L) C E C	Determine which queue (our own or a generic queue) originated this  A C	job, and save the name in case we need to manipulate the entry.  C - 	      L=STREAM(NSTREAM).SIZE(SMBMSG$K_QUEUE) - 	      IP=STREAM(NSTREAM).POS(SMBMSG$K_QUEUE) & 	      STREAM(NSTREAM).QUEUENAME_LEN=L8 	      STREAM(NSTREAM).QUEUENAME(1:L)=MESSAGE(IP:IP+L-1) C 0 C	Determine the entry number in case we need it. C 4 	      IP=STREAM(NSTREAM).POS(SMBMSG$K_ENTRY_NUMBER) C H C	Look at the identification of the file being processed.  Strip off the: C	device name, and get the fileid and directory id values. C 3 	      STREAM(NSTREAM).ENTRY=LONG(MESSAGE(IP:IP+3)) ; 	      IP=STREAM(NSTREAM).POS(SMBMSG$K_FILE_IDENTIFICATION) ; 	      STREAM(NSTREAM).DEVICE_NAME_LEN=BYTE(MESSAGE(IP:IP)) 6 	      STREAM(NSTREAM).DEVICE_NAME=MESSAGE(IP+1:IP+15)8 	      STREAM(NSTREAM).FID(1)=WORD(MESSAGE(IP+16:IP+17))8 	      STREAM(NSTREAM).FID(2)=WORD(MESSAGE(IP+18:IP+19))8 	      STREAM(NSTREAM).FID(3)=WORD(MESSAGE(IP+20:IP+21))( 	      DID(1)=WORD(MESSAGE(IP+22:IP+23))( 	      DID(2)=WORD(MESSAGE(IP+24:IP+25))( 	      DID(3)=WORD(MESSAGE(IP+26:IP+27)) C 2 C	Get the filespec (at least in its original form) C : 	      IP=STREAM(NSTREAM).POS(SMBMSG$K_FILE_SPECIFICATION): 	      L=STREAM(NSTREAM).SIZE(SMBMSG$K_FILE_SPECIFICATION)% 	      STREAM(NSTREAM).FILESPEC_LEN=L 7 	      STREAM(NSTREAM).FILESPEC(1:L)=MESSAGE(IP:IP+L-1) 	 	   ENDIF  C D C	If request was STOP_TASK, pick up the stop condition as the stream& C	status (or use %X0000002C = "abort") C . 	ELSE IF(NEWREQUEST.EQ.SMBMSG$K_STOP_TASK)THEN3 	   IP=STREAM(NSTREAM).POS(SMBMSG$K_STOP_CONDITION)  	   IF(IP.EQ.0)THEN # 	      STREAM(NSTREAM).STATUS='2C'X  	   ELSE4 	      STREAM(NSTREAM).STATUS=LONG(MESSAGE(IP:IP+3))B 	      IF(STREAM(NSTREAM).STATUS.EQ.0)STREAM(NSTREAM).STATUS='2C'X	 	   ENDIF  	ENDIF C B C	Save the current stream status ("request" value) and tentatively C	set up the new request.  C  	ITEMP=STREAM(NSTREAM).REQUEST# 	STREAM(NSTREAM).REQUEST=NEWREQUEST  C C C	If it's START_STREAM, create the command mailbox for the process, @ C	then create the process.  The command mailbox has a 1024-byte E C	limit on record size (4-byte item code + 1020-byte item, for BINARY = C	streams) and has the logical name CMD_MBX_pid to enable the  C	process to find it.  C E C	Effective with V2.16, the process name is no longer based entirely  I C	upon the queue name, but rather is constructed from the symbiont name's B C	last character and the stream number, as well as the queue name.G C	Also, the logical names for the mailboxes are now based upon the PID  H C	of the queue-processor process, since the queue name may not be uniqueA C	in fifteen characters.  To implement the latter, the process is C C	created in hibernate state, and is awakened after the mailbox has  C	been set up. C , 	IF(NEWREQUEST.EQ.SMBMSG$K_START_STREAM)THEN1 	   LNMLIST(1).BUFLEN=STREAM(NSTREAM).OURNAME_LEN # 	   LNMLIST(1).ITEMCODE=LNM$_STRING 3 	   LNMLIST(1).BUFADR=%LOC(STREAM(NSTREAM).OURNAME)  	   LNMLIST(1).RETLENADR=0 	   LNMLIST(2).TERMINATOR=0 ; 	   ISTAT=SYS$CRELNM(,'LNM$GROUP','EXECSYMB_'//SYMB_INDEX// 0 	1   STREAM_CHARS(NSTREAM+1:NSTREAM+1),,LNMLIST)G 	   IF(ISTAT.NE.SS$_SUPERSEDE)CALL LOGGIT('Stream $CRELNM stat=',ISTAT) 6 	   IF(BTEST(STREAM(NSTREAM).FLAGS,FLG_V_DYNAMIC))THEN6 	      STREAM(NSTREAM).FLAGS=STREAM(NSTREAM).FLAGS.OR. 	1      FLG_M_NO_PROCESSOR9 	      IF(BTEST(STREAM(NSTREAM).FLAGS,FLG_V_INITREQ))THEN F 	         STREAM(NSTREAM).FLAGS=STREAM(NSTREAM).FLAGS.OR.FLG_M_INITING4 	         CALL START_PROCESSOR(NSTREAM,ISTAT_CREPRC)! 	         CALL SET_TIMER(NSTREAM)  	      ELSE # 	         CALL TELL_OPER('Queue '// C 	1         STREAM(NSTREAM).OURNAME(1:STREAM(NSTREAM).OURNAME_LEN)// < 	2         ' starting; processor will start dynamically.',3) 	         ISTAT_CREPRC=1 	      ENDIF 	   ELSE1 	      CALL START_PROCESSOR(NSTREAM,ISTAT_CREPRC) 	 	   ENDIF  C C C	If it's START_TASK, determine whether we are really starting the  H C	task (i.e. if it's the copy of the job and file that the stream wants 
 C	to process)  C / 	ELSE IF(NEWREQUEST.EQ.SMBMSG$K_START_TASK)THEN  	   IF(REALLY_START_TASK)THEN  C @ C	If it's the right copy, set up the stream to process the task: C B C	First, determine whether the file is a spool file.  Spool files F C	(files created by the job controller from data copied directly to a E C	spooled device) have no directory entry.  Most applications of this F C	symbiont require a valid filespec for each file to be processed; VMSE C	expects spool files to be opened by fileid and not by name.  We get B C	around this problem, if necessary, by entering the file into theF C	"spool directory" specified for this stream.  A "spool directory" ofF C	the same name must exist on each disk used as an intermediate device/ C	for spooled devices processed by this stream.  C 7 	      STREAM(NSTREAM).FLAGS=STREAM(NSTREAM).FLAGS.AND.  	1      .NOT.FLG_M_ENTERED C C C	If the file is a spool file, its directory's fileid will be zero. B C	If the device name is also zero, it's an even more special case:B C	it is a nonexistent file that resulted from failing to create a E C	batch log file.  The latter case is determined from the device name E C	length, and if it is that special case, the filespec is modified to A C	include the null device (NLA0:); the process should be able to  G C	open or copy the "file" by name, getting an empty file as the result.  C : 	      IF(DID(1).EQ.0.AND.DID(2).EQ.0.AND.DID(3).EQ.0)THEN6 	         IF(STREAM(NSTREAM).DEVICE_NAME_LEN.EQ.0)THEN, 	            IL=STREAM(NSTREAM).FILESPEC_LEN9 	            IX=INDEX(STREAM(NSTREAM).FILESPEC(1:IL),':')  	            IY=IL+5-IX 5 	            STREAM(NSTREAM).FILESPEC(1:IY)='NLA0:'// / 	1            STREAM(NSTREAM).FILESPEC(IX+1:IL) , 	            STREAM(NSTREAM).FILESPEC_LEN=IY C D C	If the filespec is modified, it is changed in the SCB field calledD C	FILE_SPECIFICATION, and not in the message itself.  This SCB fieldC C	follows the field containing the message; by setting the position G C	to one greater than the size of the message buffer, normal processing ! C	will pick up the modified name.  C B 	            STREAM(NSTREAM).POS(SMBMSG$K_FILE_SPECIFICATION)=1025A 	            STREAM(NSTREAM).SIZE(SMBMSG$K_FILE_SPECIFICATION)=IY  	            GOTO215 	         ENDIF  C F C	If there is no directory, but there is a device, the file is a spoolH C	file.  Enter it in the spool directory, but give it the next availableF C	version number, in case a file with the same name and version number( C	already exists in the spool directory. C F 	         STREAM(NSTREAM).FLAGS=STREAM(NSTREAM).FLAGS.OR.FLG_M_ENTERED> 	         IX=INDEX(STREAM(NSTREAM).FILESPEC(1:STREAM(NSTREAM). 	1         FILESPEC_LEN),']') > 	         IY=INDEX(STREAM(NSTREAM).FILESPEC(1:STREAM(NSTREAM). 	1         FILESPEC_LEN),';')  	         ISTAT=DO_ENTER( 9 	1         STREAM(NSTREAM).DEVICE_NAME(1:STREAM(NSTREAM). = 	2         DEVICE_NAME_LEN)//':'//STREAM(NSTREAM).SPOOLDIR(1: = 	3         STREAM(NSTREAM).SPOOLDIR_LEN),STREAM(NSTREAM).FID, 5 	4         STREAM(NSTREAM).FILESPEC(IX+1:IY-1)//';0') - 	         CALL LOGGIT('DO_ENTER stat=',ISTAT)  C G C	Convert the fileid to a filespec.  This routine (LIB$FID_TO_NAME) was F C	stolen from some other software for VMS V4, but is in the RTL in V5.I C	The V4 version (at least) does have one peculiarity, though; it returns C C	a blank-padded filespec, which we have to trim to get the length.  C  	         CALL LIB$FID_TO_NAME( 9 	1         STREAM(NSTREAM).DEVICE_NAME(1:STREAM(NSTREAM). @ 	2         DEVICE_NAME_LEN),STREAM(NSTREAM).FID,STREAM(NSTREAM). 	3         FILESPEC,,,) A 	         CALL STR$TRIM(STREAM(NSTREAM).FILESPEC,STREAM(NSTREAM). 1 	1         FILESPEC,STREAM(NSTREAM).FILESPEC_LEN)  C F C	Again, we point the FILE_SPECIFICATION item to the revised filespec. C ; 	         STREAM(NSTREAM).POS(SMBMSG$K_FILE_SPECIFICATION)=  	1         MAX_MSG_SIZE+1 < 	         STREAM(NSTREAM).SIZE(SMBMSG$K_FILE_SPECIFICATION)=' 	1         STREAM(NSTREAM).FILESPEC_LEN  215	         CONTINUE  	      ENDIF C E C	Finally, to start the task up right, we initialize the item number  ; C	index and set the task status index to the initial state.  C  	      STREAM(NSTREAM).ITEMNO=0  	      STREAM(NSTREAM).INDEX=1 C C C	If we didn't really want to start the task (i.e. it was the wrong / C	copy of the job or file), we do nothing here.  C 	 	   ENDIF  C D C	PAUSE_TASK requires no processing, as it simply changes the streamC C	state to prevent the task from doing any further processing (once 9 C	the main loop gets back to checking the stream's state)  C / 	ELSE IF(NEWREQUEST.EQ.SMBMSG$K_PAUSE_TASK)THEN  	   CONTINUE C F C	Similarly, RESUME_TASK requires no processing, other than to restoreG C	the state of the stream to START_TASK, which means "task in progress"  C 0 	ELSE IF(NEWREQUEST.EQ.SMBMSG$K_RESUME_TASK)THEN/ 	   STREAM(NSTREAM).REQUEST=SMBMSG$K_START_TASK  C H C	STOP_TASK requires that the task be processable, so the stream's stateG C	must be set to START_TASK (clearing any previous PAUSE_TASK request), : C	and the task state index is set to the abort-task value. C . 	ELSE IF(NEWREQUEST.EQ.SMBMSG$K_STOP_TASK)THEN/ 	   STREAM(NSTREAM).REQUEST=SMBMSG$K_START_TASK  	   STREAM(NSTREAM).INDEX=5  C E C	A RESET_STREAM request is not processed here.  (If it got this far, A C	it means that an active task on the stream needs to be aborted. B C	The main loop at non-AST level will take care of converting this. C	request to a STOP_STREAM once that is done.) C 1 	ELSE IF(NEWREQUEST.EQ.SMBMSG$K_RESET_STREAM)THEN  	   CONTINUE C > C	STOP_STREAM requires that the process be asked to exit.  The@ C	stream is not considered completely stopped until the process F C	exits (so that if it's the last active stream, we won't accidentally6 C	abort the process prematurely by exiting ourselves.) C 0 	ELSE IF(NEWREQUEST.EQ.SMBMSG$K_STOP_STREAM)THEN6 	   IF(BTEST(STREAM(NSTREAM).FLAGS,FLG_V_DYNAMIC).AND.9 	1   BTEST(STREAM(NSTREAM).FLAGS,FLG_V_NO_PROCESSOR))THEN ( 	      CALL FAKE_DYNAMIC_EXIT(NSTREAM,1) 	   ELSE" 	      CALL SEND_EXIT_MSG(NSTREAM)	 	   ENDIF  C = C	Should never get here -- an invalid request code was found.  C  	ELSE 5 	   CALL LOGGIT('Bad request in MSG_AST=',NEWREQUEST) ! 	   STREAM(NSTREAM).REQUEST=ITEMP  	ENDIF C B C	One more time:  if it's a START_STREAM request, reply to the job6 C	controller with the proper attribute, SERVER or not. C H C	V3.4.0: do not reply here if INIT specified -- rely on queue processor$ C	to send a message triggering this. C , 	IF(NEWREQUEST.EQ.SMBMSG$K_START_STREAM)THEN; 	   IF(.NOT.BTEST(STREAM(NSTREAM).FLAGS,FLG_V_INITING))THEN < 	      IF(BTEST(STREAM(NSTREAM).FLAGS,FLG_V_PRINTQUEUE))THENB 	         ISTAT=SMB$SEND_TO_JOBCTL(%REF(NSTREAM),%REF(NEWREQUEST)) 	      ELSE D 	         ISTAT=SMB$SEND_TO_JOBCTL(%REF(NSTREAM),%REF(NEWREQUEST),,,! 	1         %REF(SMBMSG$M_SERVER))  	      ENDIF= 	      CALL LOGGIT('SEND_TO_JOBCTL START_STREAM stat=',ISTAT) 	 	   ENDIF  C ? C	Then, if the $CREPRC for the stream processor failed, pretend : C	that the process actually exited abnormally, to clean up
 C	the SCB. C  	   IF(.NOT.ISTAT_CREPRC)THEN / 	      CALL CREPRC_FAILED(NSTREAM,ISTAT_CREPRC) 3 	      STREAM(NSTREAM).REQUEST=SMBMSG$K_STOP_STREAM 	 	   ENDIF  C B C	If it's not a STOP_TASK, and it's not a STOP_STREAM for a stream? C	whose process still exists, and it's not a RESET_STREAM, then E C	we reply to the job controller that the request has been completed. F C	(Note that replying to a START_TASK with the START_TASK status meansF C	that the task has been started, and not that the task is completed!)A C	We do not want to reply to STOP_TASK, STOP_STREAM with existing = C	process, or RESET_STREAM because these requests need to be  C C	completed at non-AST level; completing them here would allow the  6 C	next task for the queue to wipe out the current one. C . 	ELSE IF(NEWREQUEST.NE.SMBMSG$K_STOP_TASK.AND.C 	1 (NEWREQUEST.NE.SMBMSG$K_STOP_STREAM.OR.STREAM(NSTREAM).PID.EQ.0) 0 	1 .AND.NEWREQUEST.NE.SMBMSG$K_RESET_STREAM)THEN< 	   ISTAT=SMB$SEND_TO_JOBCTL(%REF(NSTREAM),%REF(NEWREQUEST)); 	   CALL LOGGIT('SEND_TO_JOBCTL non-STOP_TASK stat=',ISTAT)  	ENDIF C F C	Another special case:  if it was a START_TASK request, and we didn'tD C	really start the task (because it was the wrong copy of the job orD C	file), we simply respond with TASK_COMPLETE.  This gets us quickly5 C	through all unwanted copies of the job and file(s).  C E 	IF((NEWREQUEST.EQ.SMBMSG$K_START_TASK).AND.(.NOT.REALLY_START_TASK))  	1 THEN + 	   ISTAT=SMB$SEND_TO_JOBCTL(%REF(NSTREAM), 9 	1   %REF(SMBMSG$K_TASK_COMPLETE),,,,%REF(STATUS_VECTOR)) C 	   CALL LOGGIT('SEND_TO_JOBCTL MSG_AST TASK_COMPLETE stat=',ISTAT)  C < C	Make sure the stream state is idle after task "completion" C 1 	   STREAM(NSTREAM).REQUEST=SMBMSG$K_START_STREAM  	ENDIF C , C	Done.  Let non-AST code take it from here. C  	RETURN  	END C @ C	EXIT_AST -- AST routine for completion of read QIO on process  C	exit mailbox C                              	SUBROUTINE EXIT_AST C 5 C	Make implicit declaration and specify INCLUDE files  C  	IMPLICIT NONE 	INCLUDE 'EXECSYMB.INC'  	INCLUDE '($SJCDEF)' 	INCLUDE 'ITEMDEF.INC' C 8 C	Declare itemlist for sending request to job controller C  	RECORD /ITEM/ SJCLIST(2)  C 3 C	System and SMBSRVSHR routines called as functions  C ? 	INTEGER*4 SMB$SEND_TO_JOBCTL,SYS$DASSGN,SYS$SNDJBCW,SYS$DELLNM  C  C	Process name stuff C  	CHARACTER*32 STREAM_CHARS 	CHARACTER*14 FILLER 	CHARACTER*1 SYMB_INDEX / 	COMMON /PRCNAM/ STREAM_CHARS,FILLER,SYMB_INDEX  C  C	Miscellaneous local storage  C $ 	INTEGER*4 ISTAT,INSTREAM,IPIDSTATUS 	INTEGER*4 EXITPID,PIDSTATUS 	CHARACTER*8 PROCPID 	INTEGER*4 NSTREAM 	CHARACTER*17 EXITSTAT 	LOGICAL*1 ALT_ENTRY C > C	Start of code:  process exit is an event that should awaken  C	mainline non-AST level code  C  	CALL WAKEUP C = C	Indicate entry at EXIT_AST and not at CREPRC_FAILED (below)  C  	ALT_ENTRY=.FALSE. C 2 C	Read process status and PID from mailbox message C ( 	CALL MOVL(%REF(EXITBUF(5:8)),PIDSTATUS)' 	CALL MOVL(%REF(EXITBUF(9:12)),EXITPID)  C ) C	Scan stream SCB's for one with this PID  C  4	DO NSTREAM=0,MAXUSED* 	   IF(STREAM(NSTREAM).PID.EQ.EXITPID)THEN? 	      CALL TELL_OPER('Processor for '//STREAM(NSTREAM).OURNAME : 	1      (1:STREAM(NSTREAM).OURNAME_LEN)//' has exited.',3)2 	      CALL SYS$FAO('!8XL',,PROCPID,%VAL(EXITPID))< 	      ISTAT=SYS$DELLNM('LNM$GROUP','QUEUE_NAME_'//PROCPID,)4 	      CALL LOGGIT('$DELLNM QUEUE_NAME stat=',ISTAT)= 	      ISTAT=SYS$DELLNM('LNM$GROUP','DEVICE_NAME_'//PROCPID,) 5 	      CALL LOGGIT('$DELLNM DEVICE_NAME stat=',ISTAT) < 	      ISTAT=SYS$DELLNM('LNM$GROUP','STAT_W_MBX_'//PROCPID,)4 	      CALL LOGGIT('$DELLNM STAT_W_MBX stat=',ISTAT)A 	      ISTAT=SYS$DELLNM('LNM$GROUP','EXECSYMB_PID_'//SYMB_INDEX// + 	1      STREAM_CHARS(NSTREAM+1:NSTREAM+1),) / 	      CALL LOGGIT('$DELLNM _PID_ stat=',ISTAT)  	      GOTO7	 	   ENDIF  	ENDDO C F C	If we couldn't find the PID anywhere, it's probably a processor thatB C	didn't exit in time, and was replaced by a new one.  Log it, and& C	attempt to delete the logical names. C B 	CALL SYS$FAO('!8XL=!8XL',,EXITSTAT,%VAL(EXITPID),%VAL(PIDSTATUS))8 	CALL LOGGIT('Exitstat ignored for bad PID '//EXITSTAT,)< 	ISTAT=SYS$DELLNM('LNM$GROUP','QUEUE_NAME_'//EXITSTAT(1:8),)2 	CALL LOGGIT('$DELLNM odd QUEUE_NAME stat=',ISTAT)= 	ISTAT=SYS$DELLNM('LNM$GROUP','DEVICE_NAME_'//EXITSTAT(1:8),) 3 	CALL LOGGIT('$DELLNM odd DEVICE_NAME stat=',ISTAT) < 	ISTAT=SYS$DELLNM('LNM$GROUP','STAT_W_MBX_'//EXITSTAT(1:8),)2 	CALL LOGGIT('$DELLNM odd STAT_W_MBX stat=',ISTAT) 	GOTO99  C F C	FAKE_DYNAMIC_EXIT is used with streams that have dynamic processors.F C	When one of these streams is supposed to be stopped, this entry getsD C	called to fake the processor exit if there is no active processor.B C	It works like CREPRC_FAILED but doesn't print the error message. C - 	ENTRY FAKE_DYNAMIC_EXIT(INSTREAM,IPIDSTATUS) < 	CALL LOGGIT('Faking dynamic processor exit ',INSTREAM*16+7) 	GOTO69  C D C	CREPRC_FAILED enters with NSTREAM and PIDSTATUS already specified,( C	and just handles the rest of the work. C ) 	ENTRY CREPRC_FAILED(INSTREAM,IPIDSTATUS) G 	CALL LOGGIT('Handling $CREPRC failure as process exit ',INSTREAM*16+7)  69	NSTREAM=INSTREAM  	PIDSTATUS=IPIDSTATUS  	ALT_ENTRY=.TRUE.  C ) C	Format a string for subsequent messages  C 9 7	CALL SYS$FAO('!2UB = %X!8XL  ',,EXITSTAT,%VAL(NSTREAM),  	1 %VAL(PIDSTATUS))  C B C	If the stream was already "stopped", this is an expected processB C	exit, so send the STOP_STREAM status back to the job controller. C 9 8	IF(STREAM(NSTREAM).REQUEST.EQ.SMBMSG$K_STOP_STREAM)THEN 8 	   IF(BTEST(STREAM(NSTREAM).FLAGS,FLG_V_RESETTING))THEN. 	      ISTAT=SMB$SEND_TO_JOBCTL(%REF(NSTREAM),$ 	1      %REF(SMBMSG$K_RESET_STREAM))F 	      CALL LOGGIT('EXIT_AST SEND_TO_JOBCTL RESET_STREAM stat=',ISTAT) 	   ELSE. 	      ISTAT=SMB$SEND_TO_JOBCTL(%REF(NSTREAM),# 	1      %REF(SMBMSG$K_STOP_STREAM)) E 	      CALL LOGGIT('EXIT_AST SEND_TO_JOBCTL STOP_STREAM stat=',ISTAT) 	 	   ENDIF  C F C	If the stream state was other than STOP_STREAM, check to see if thisG C	is a dynamic processor that timed out.  (Cannot check the EXITING bit D C	here since EXIT_TIMER_AST may have cleared it, so use DYNAMIC and ; C	NO_PROCESSOR.  Make sure EXITING is cleared in any case.)  C 8 	ELSE IF(BTEST(STREAM(NSTREAM).FLAGS,FLG_V_DYNAMIC).AND.7 	1 BTEST(STREAM(NSTREAM).FLAGS,FLG_V_NO_PROCESSOR))THEN F 	   STREAM(NSTREAM).FLAGS=STREAM(NSTREAM).FLAGS.AND..NOT.FLG_M_EXITING C B C	Otherwise, it's an unexpected process exit.  We need to do some F C	cleanup in that case, so that the job controller, our code, and the I C	stream SCB all reflect the fact that the stream has stopped on its own.  C  	ELSE / 	   CALL LOGGIT('Exitstat: stream '//EXITSTAT,)  C F C	Set up and submit a RESET_QUEUE request for the stream.  This forces> C	the job controller to put the stream in the "stopped" state. C 1 	   SJCLIST(1).BUFLEN=STREAM(NSTREAM).OURNAME_LEN " 	   SJCLIST(1).ITEMCODE=SJC$_QUEUE3 	   SJCLIST(1).BUFADR=%LOC(STREAM(NSTREAM).OURNAME)  	   SJCLIST(1).RETLENADR=0 	   SJCLIST(2).TERMINATOR=0 @ 	   ISTAT=SYS$SNDJBCW(,%VAL(SJC$_RESET_QUEUE),,%REF(SJCLIST),,,)< 	   CALL LOGGIT('EXIT_AST $SNDJBCW RESET_QUEUE stat=',ISTAT) 	ENDIF C ? C	Since the process exited, clear the stream's PID, and if the  C C	mailbox for the stream still has a channel assigned, deassign it.  C  	STREAM(NSTREAM).PID=0' 	IF(STREAM(NSTREAM).MBX_CHAN.NE.-1)THEN 4 	   ISTAT=SYS$DASSGN(%VAL(STREAM(NSTREAM).MBX_CHAN))& 	   CALL LOGGIT('$DASSGN stat=',ISTAT) 	   STREAM(NSTREAM).MBX_CHAN=-1  	ENDIF C B C	Finally, post another read to the process exit mailbox, so we'llB C	get called again when another process exits (but only if we came C	in at EXIT_AST!) C ' 99	IF(.NOT.ALT_ENTRY)CALL READ_EXIT_MBX  	RETURN          	END C E C	IO_DONE_AST -- AST routine for completion of read QIO on the status B C	return mailbox (used by processes to report completion status of	 C	a task)  C                       D C	NOTE: Effective with V3.4.0, this routine may need to send a replyF C	to a START_STREAM request when an "intermediate status" is received. C  	SUBROUTINE IO_DONE_AST  C > C	Make implicit declaration and specify required INCLUDE files C  	IMPLICIT NONE 	INCLUDE '($SJCDEF)' 	INCLUDE 'EXECSYMB.INC'  	INCLUDE 'ITEMDEF.INC' C - C	Declare system routines called as functions  C ) 	INTEGER*4 SYS$SNDJBCW,SMB$SEND_TO_JOBCTL  C A C	Declare itemlist for requesting requeue and hold on current job  C  	RECORD /ITEM/ ITEMLIST(4) C  C	Miscellaneous local storage  C  	CHARACTER*32 SJC_OUR_QUEUE  	LOGICAL*1 FIRST_TIME 7 	INTEGER*4 IOSB(2),IX,IY,DEVSTAT,READ_STAT_NUMBER,ISTAT % 	INTEGER*4 I,NSTREAM,SEVERITY,REQCODE  	CHARACTER*8 HEXVAL  C A C	FIRST_TIME is used to avoid reinitializing variables that can't  C	be set up via DATA statements  C  	DATA FIRST_TIME/.TRUE./ C @ C	Start of code -- if first time in this routine, initialize the C	itemlist constant fields C  	IF(FIRST_TIME)THEN  	   FIRST_TIME=.FALSE.# 	   ITEMLIST(1).ITEMCODE=SJC$_QUEUE * 	   ITEMLIST(1).BUFADR=%LOC(SJC_OUR_QUEUE) 	   ITEMLIST(1).RETLENADR=0 % 	   ITEMLIST(2).ITEMCODE=SJC$_REQUEUE  	   ITEMLIST(2).BUFLEN=0 	   ITEMLIST(2).BUFADR=0 	   ITEMLIST(2).RETLENADR=0 " 	   ITEMLIST(3).ITEMCODE=SJC$_HOLD 	   ITEMLIST(3).BUFLEN=0 	   ITEMLIST(3).BUFADR=0 	   ITEMLIST(3).RETLENADR=0  	   ITEMLIST(4).TERMINATOR=0 	ENDIF C B C	Receiving any type of status message requires us to wake up the G C	mainline non-AST level code (since it may be hibernating waiting for   C	something to happen) C  	CALL WAKEUP C C C	If the IOSB shows other than success, skip processing and re-post 	 C	the I/O  C  	IF(.NOT.STATIOSB(1))GOTO90  C E C	Use the second longword of the IOSB on the mailbox read (which, for D C	the mailbox device, contains the PID of the process that wrote to @ C	the mailbox) to determine which stream's process returned the @ C	status value.  This also eliminates spurious mailbox messages. C  	DO I=0,MAXUSED ) 	   IF(STREAM(I).PID.EQ.STATIOSB(2))GOTO1  	ENDDO C 4 C	If it wasn't from one of our processes, ignore it.F C	(Actually, first check for a debug command.  If it isn't a command, C C	then ignore it.  If it is, process it and reset to "NOOP" in case , C	we drop through to here on a mailbox EOF.) C ! 	IF(STATBUF(1:6).EQ.'$DEBUG')THEN 4 	   CALL DEBUG_MODE_COMMAND(STATBUF(7:STATIOSBW(2))) 	   STATBUF(7:11)='NOOP '  	ELSE 2 	   CALL SYS$FAO('!8XL',,HEXVAL,%VAL(STATIOSB(2)))0 	   CALL LOGGIT('Status from bad PID '//HEXVAL,) 	ENDIF 	GOTO90  C E C	Prior to V02.30, the status message was expected to be exactly ten  < C	characters long, in ASCII, with the last eight characters G C	containing the status value in hex.  This was done so that a process  F C	command procedure could copy $STATUS directly to the mailbox -- the J C	$STATUS symbol ordinarily has a string value in the format "%Xnnnnnnnn". C I C	Effective with V02.30, the status string can have the following general 0 C	forms (optional parts are enclosed in braces): C ( C	,{<device status>}{,<checkpoint data>}) C	<completion status>{,<accounting data>}  C E C	Each "status" value is a numeric longword value, represented in one E C	of two forms: as a signed decimal number, or as "%X" followed by a   C	hexadecimal number.  C B C	<accounting data> consists of four numbers in the same format as  C	"status", separated by commas. C 5 C	<checkpoint data> is an arbitrary character string.  C F C	First, get length of status buffer, and check for the initial comma 8 C	character (signalling an intermediate status message.) C  1	L_SB=STATIOSBW(2) 
 	NSTREAM=I 	IF(STATBUF(1:1).NE.',')GOTO5  C ? C	It's an intermediate status message; find next comma, if any. @ C	If none, rest of message is numeric device status.  Otherwise,? C	everything before comma is device status, everything after is < C	checkpoint data.  Handle cases where one or both are null:? C	Null device status is not reported; null checkpoint string is . C	reported only if device status is also null. C F C	V3.4.0: if the stream is "INITING", pass a START_STREAM request codeJ C	instead of a TASK_STATUS.  This works around the new V5.5 QMAN "feature"= C	that disallows TASK_STATUS messages when no task is active.  C 
 	DEVSTAT=0 	IX=INDEX(STATBUF(2:L_SB),',') 	IF(IX.EQ.0)IX=L_SB 3 	IF(IX.GT.1)DEVSTAT=READ_STAT_NUMBER(STATBUF(2:IX))  C 5 C	Determine if we need a START_STREAM or TASK_STATUS. F C	If the former, we also flag ourselves as a "server" queue unless the@ C	PRINTQUEUE attribute was explicitly specified for this stream.F C	Also note that checkpoint data is not allowed on a START_STREAM (andG C	thus is not accepted on the initializing intermediate status message)  C 3 	IF(BTEST(STREAM(NSTREAM).FLAGS,FLG_V_INITING))THEN ! 	   REQCODE=SMBMSG$K_START_STREAM : 	   IF(.NOT.BTEST(STREAM(NSTREAM).FLAGS,FLG_V_PRINTQUEUE))' 	1   DEVSTAT=DEVSTAT.OR.SMBMSG$M_SERVER  C C C	No checkpoint data will be sent, even if specified, since it's a  D C	START_STREAM request code; so make sure IX is .NE. 1 and .GE. L_SB C  	   IX=MAX(2,L_SB)F 	   STREAM(NSTREAM).FLAGS=STREAM(NSTREAM).FLAGS.AND..NOT.FLG_M_INITING 	ELSE   	   REQCODE=SMBMSG$K_TASK_STATUS 	ENDIF 	IF(IX.EQ.1)THEN9 	   ISTAT=SMB$SEND_TO_JOBCTL(%REF(NSTREAM),%REF(REQCODE),  	1   ,STATBUF(3:L_SB)): 	   CALL LOGGIT('IO_DONE_AST SEND_TO_JOBCTL1 stat=',ISTAT) 	ELSE IF(IX.LT.L_SB)THEN9 	   ISTAT=SMB$SEND_TO_JOBCTL(%REF(NSTREAM),%REF(REQCODE), ! 	1   ,STATBUF(IX+2:L_SB),DEVSTAT) : 	   CALL LOGGIT('IO_DONE_AST SEND_TO_JOBCTL2 stat=',ISTAT) 	ELSE C 	   ISTAT=SMB$SEND_TO_JOBCTL(%REF(NSTREAM),%REF(REQCODE),,,DEVSTAT) : 	   CALL LOGGIT('IO_DONE_AST SEND_TO_JOBCTL3 stat=',ISTAT) 	ENDIF 	GOTO90  C 9 C	Must be a completion status message; find comma if any. D C	Everything before comma (or everything, if no comma) is completionD C	status.  Following comma are up to four accounting data longwords.= C	A null completion status is treated as "abort" (i.e. %X2C).  C  5	STREAM(NSTREAM).STATUS=0 	STREAM(NSTREAM).ACCDAT(1)=0 	STREAM(NSTREAM).ACCDAT(2)=0 	STREAM(NSTREAM).ACCDAT(3)=0 	STREAM(NSTREAM).ACCDAT(4)=0 	IX=INDEX(STATBUF(1:L_SB),',') 	IF(IX.EQ.0)IX=L_SB+1 D 	IF(IX.GT.1)STREAM(NSTREAM).STATUS=READ_STAT_NUMBER(STATBUF(1:IX-1))$ 	IF(STREAM(NSTREAM).STATUS.EQ.0)THEN  	   STREAM(NSTREAM).STATUS='2C'X) 	ELSE IF(STREAM(NSTREAM).STATUS.LT.0)THEN F 	   STREAM(NSTREAM).FLAGS=STREAM(NSTREAM).FLAGS.OR.FLG_M_RETRY_INHIBIT2 	   STREAM(NSTREAM).STATUS=-STREAM(NSTREAM).STATUS 	ENDIF 	I=0 6	I=I+1  	IF(IX.GT.L_SB)GOTO9 	IF(I.GT.4)GOTO9 	IY=IX$ 	IX=INDEX(STATBUF(IY+1:L_SB),',')+IY 	IF(IX.EQ.IY)IX=L_SB+1? 	STREAM(NSTREAM).ACCDAT(I)=READ_STAT_NUMBER(STATBUF(IY+1:IX-1))  	GOTO6 C ? C	Determine the severity of the status.  If it isn't 2 (error)  A C	or 4 (fatal error), we accept it.  Also, if no requeue time was G C	specified for the queue, we accept the status regardless of severity.  C ) 9	SEVERITY=(STREAM(NSTREAM).STATUS).AND.7 * 	IF(SEVERITY.NE.2.AND.SEVERITY.NE.4)GOTO90= 	IF(.NOT.BTEST(STREAM(NSTREAM).FLAGS,FLG_V_DO_REQUEUE))GOTO90  C E C	If the task had an error or fatal error completion status, and the  C C	stream has a requeue time specified, we will attempt to abort the E C	job and requeue it for retry.  (The job controller doesn't know, at C C	this point, that the task failed -- since we didn't tell it yet!) C C	Set up the dynamic portions of the itemlist with information from E C	the stream's SCB, and send the job controller an ABORT_JOB request, C C	asking for a HOLD status and a requeue on the job.  Note that the D C	ABORT_JOB request cannot possibly complete while we're here, since? C	this code runs at AST level.  The job controller will send a  E C	STOP_TASK request to us, which MSG_AST will pass on to the mainline E C	non-AST level code that is designed to handle aborting the task and " C	requeuing it with an AFTER-time. C @ C	V3.2 adds a retry-inhibit mechanism: if the status reported isE C	negative, retry is inhibited and the correct status is the negative  C	of what was reported.  C ; 	IF(BTEST(STREAM(NSTREAM).FLAGS,FLG_V_RETRY_INHIBIT))GOTO90 E 	SJC_OUR_QUEUE=STREAM(NSTREAM).OURNAME(1:STREAM(NSTREAM).OURNAME_LEN) / 	ITEMLIST(1).BUFLEN=STREAM(NSTREAM).OURNAME_LEN @ 	ISTAT=SYS$SNDJBCW(,%VAL(SJC$_ABORT_JOB),,%REF(ITEMLIST),IOSB,,)* 	CALL LOGGIT('$SNDJBCW ABORT stat=',ISTAT), 	CALL LOGGIT('$SNDJBCW ABORT IOSB=',IOSB(1)) C F C	Before we leave, we clear the status so that the mainline code won'tA C	do anything to this task until the ABORT_TASK request comes in. G C	Also, we set the stream's ABORT flag, indicating that we are the ones F C	who requested the task abort.  (This lets us distinguish our aborts,G C	which should be requeued, from those done by someone else for reasons F C	that we know nothing about.  We let the person doing the abort worry' C	about the consequences in that case.)  C  	STREAM(NSTREAM).STATUS=0 ; 	STREAM(NSTREAM).FLAGS=STREAM(NSTREAM).FLAGS.OR.FLG_M_ABORT  C C C	All paths merge here, to post another read to the status mailbox, 
 C	and return.  C  90	CALL READ_STAT_MBX  	RETURN  	END C F C	WRITE_MBX -- routine to write a message to a process command mailbox C 2 	SUBROUTINE WRITE_MBX(ISTREAM,MESS,NOWFLG,WAITING) 	IMPLICIT NONE 	INCLUDE 'EXECSYMB.INC'  	INCLUDE '($IODEF)'  	EXTERNAL WAKEUP 	INTEGER*4 ISTREAM 	CHARACTER*(*) MESS  	LOGICAL*1 NOWFLG,WAITING # 	INTEGER*4 L,ISTAT,SYS$QIOW,SYS$QIO  C C C	Check to make sure the stream still has a channel assigned to its 0 C	mailbox.  If it doesn't, don't do a whole lot. C ' 	IF(STREAM(ISTREAM).MBX_CHAN.NE.-1)THEN  	   L=LEN(MESS)  C A C	If the write will demand an immediate return, don't bother with B C	the IOSB; otherwise, initialize the IOSB to zero.  Then post theF C	QIO; if immediate return, do a QIOW, else do a plain QIO and specifyG C	WAKEUP as the AST routine, so that we can hibernate until the request  C	completes. C  	   IF(NOWFLG)THEN6 	      ISTAT=SYS$QIOW(,%VAL(STREAM(ISTREAM).MBX_CHAN),3 	1      %VAL(IO$_WRITEVBLK+IO$M_NOW),,,,%REF(MESS),  	2      %VAL(L),,,,)1 	      CALL LOGGIT('WRITE_MBX $QIOW stat=',ISTAT)  C F C	If "WAITING" flag is set, then this is a QIO that uses the IOSB and & C	requires a WAKEUP when it completes. C  	   ELSE IF(WAITING)THEN5 	      ISTAT=SYS$QIO(,%VAL(STREAM(ISTREAM).MBX_CHAN), 9 	1      %VAL(IO$_WRITEVBLK),STREAM(ISTREAM).IOSB,WAKEUP,,  	2      %REF(MESS),%VAL(L),,,,) 1 	      CALL LOGGIT('WRITE_MBX $QIO1 stat=',ISTAT)  	   ELSE5 	      ISTAT=SYS$QIO(,%VAL(STREAM(ISTREAM).MBX_CHAN), 6 	1      %VAL(IO$_WRITEVBLK),,,,%REF(MESS),%VAL(L),,,,)1 	      CALL LOGGIT('WRITE_MBX $QIO2 stat=',ISTAT) 4 	   ENDIF                                            	ENDIF C F C	Return after posting the QIO (or after doing nothing, if no mailbox) C  	RETURN  	END C G C	WAKEUP -- make sure mainline code wakes up (call from/as AST routine)  C  	SUBROUTINE WAKEUP 	IMPLICIT NONE 	INCLUDE 'EXECSYMB.INC'  	INTEGER*4 SYS$WAKE  	INTEGER*4 ISTAT C D C	If the flag indicating a wakeup is necessary is set, call SYS$WAKEF C	to do it.  (Mainline code sets DO_WAKE when it's about to hibernate.B C	This lets us avoid excessive SYS$WAKE calls, possible if we just. C	base our decision on the value of DO_HIBER.) C  	IF(DO_WAKE)THEN 	   ISTAT=SYS$WAKE(,) $ 	   CALL LOGGIT('$WAKE stat=',ISTAT) C C C	If the wakeup flag is not set, simply clear the DO_HIBER flag, so B C	that the mainline code will know not to hibernate at the end of   C	this pass through the streams. C  	ELSE  	   DO_HIBER=.FALSE. 	ENDIF C  C	That done, we return.  C  	RETURN  	END C F C	WRITE_MBX_ASCII -- routine to write the command mailbox for a stream2 C	that uses the ASCII format for item transmission C B C	The ASCII format for item transmission is intended for use with C C	streams serviced by command procedures.  Each item is sent as two E C	mailbox messages:  the first contains the name of the item, and the D C	second contains the value of the item, edited (in most cases) fromE C	its binary format into a suitable ASCII format, if necessary.  This 8 C	enables DCL code like the following to read all items: C		$ INPUT_LOOP:9 C		$    read/end=eof cmd_mbx itemname	! read name of item ; C		$    read/end=eof cmd_mbx 'itemname	! read value of item : C		$    if itemname .nes. "EXEC_STEP" then goto INPUT_LOOPC C	Some items are not edited into ASCII, but are passed as-is, even  F C	though they contain some binary information.  See the main program's3 C	table of item conversion information for details.  C 2 	SUBROUTINE WRITE_MBX_ASCII(ISTREAM,ITEMNAME,MESS) 	IMPLICIT NONE 	INCLUDE 'EXECSYMB.INC'  	CHARACTER*(*) ITEMNAME,MESS( 	INTEGER*4 ISTAT,SYS$CANCEL,TEMP,ISTREAM 	LOGICAL*1 X_ENTRY,ASTSET  	X_ENTRY=.FALSE. 	ASTSET=.FALSE.  	GOTO1 C G C	Alternate entry for non-itemlist writes (e.g. EXIT or RESET commands)  C - 	ENTRY WRITE_MBX_ASC_X(ISTREAM,ITEMNAME,MESS)  	X_ENTRY=.TRUE.  	ASTSET=.FALSE. ' 	IF(STREAM(ISTREAM).MBX_CHAN.NE.-1)THEN 4 	   ISTAT=SYS$CANCEL(%VAL(STREAM(ISTREAM).MBX_CHAN))* 	   CALL LOGGIT('ASC $CANCEL stat=',ISTAT) 	   CALL SETAST(%REF(0)) 	   ASTSET=.TRUE.  	ENDIF C ? C	First of all, if the processor is dynamic and it's not there,  C	start it.  C 4 1	IF(BTEST(STREAM(ISTREAM).FLAGS,FLG_V_DYNAMIC).AND.7 	1 BTEST(STREAM(ISTREAM).FLAGS,FLG_V_NO_PROCESSOR))THEN , 	   CALL START_PROCESSOR(ISTREAM,%REF(TEMP)) 	   IF(.NOT.TEMP)THEN ' 	      CALL CREPRC_FAILED(ISTREAM,TEMP) 3 	      STREAM(ISTREAM).REQUEST=SMBMSG$K_STOP_STREAM  C D C	Prevent additional calls in mainline code by pretending I/O failed C # 	      STREAM(ISTREAM).IOSB(1)=TEMP 	 	   ENDIF  	ENDIF C 6 C	Make sure there's a mailbox channel for this stream. C ' 	IF(STREAM(ISTREAM).MBX_CHAN.NE.-1)THEN  C . C	Write the item name using the common routine C 4 	   CALL WRITE_MBX(ISTREAM,ITEMNAME,X_ENTRY,.FALSE.) C > C	Write the item value, posting the QIO but not waiting for it C / 	   CALL WRITE_MBX(ISTREAM,MESS,X_ENTRY,.TRUE.)  	ENDIF C . C	Re-enable AST's once we are done, and return C  	IF(ASTSET)CALL SETAST(%REF(1))  	RETURN  	END C B C	WRITE_MBX_BINARY -- write the item code and value to the process@ C	command mailbox, without formatting or editing the item value.E C	This routine is for use with streams that specify the BINARY format C C	of item value transmission.  In the BINARY format, one message is E C	written for each item.  The first four bytes of the message contain F C	the longword item code in binary, while the remainder of the messageE C	contains the item value, as received from the job controller.  This B C	is designed primarily for queues serviced by programs written in. C	"real" (i.e. non-DCL) programming languages. C 3 	SUBROUTINE WRITE_MBX_BINARY(ISTREAM,ITEMCODE,MESS)  	IMPLICIT NONE 	INCLUDE 'EXECSYMB.INC'  	CHARACTER*(*) MESS  	CHARACTER*4 TEMP  	INTEGER*4 ITEMP 	INTEGER*4 ITEMCODE # 	INTEGER*4 ISTAT,SYS$CANCEL,ISTREAM  	LOGICAL*1 X_ENTRY,ASTSET  	X_ENTRY=.FALSE. 	ASTSET=.FALSE.  	GOTO1 C G C	Alternate entry for non-itemlist writes (e.g. EXIT or RESET commands)  C - 	ENTRY WRITE_MBX_BIN_X(ISTREAM,ITEMCODE,MESS)  	X_ENTRY=.TRUE.  	ASTSET=.FALSE. ' 	IF(STREAM(ISTREAM).MBX_CHAN.NE.-1)THEN 4 	   ISTAT=SYS$CANCEL(%VAL(STREAM(ISTREAM).MBX_CHAN))* 	   CALL LOGGIT('BIN $CANCEL stat=',ISTAT) 	   CALL SETAST(%REF(0)) 	   ASTSET=.TRUE.  	ENDIF C ? C	First of all, if the processor is dynamic and it's not there,  C	start it.  C 4 1	IF(BTEST(STREAM(ISTREAM).FLAGS,FLG_V_DYNAMIC).AND.7 	1 BTEST(STREAM(ISTREAM).FLAGS,FLG_V_NO_PROCESSOR))THEN - 	   CALL START_PROCESSOR(ISTREAM,%REF(ITEMP))  	   IF(.NOT.ITEMP)THEN( 	      CALL CREPRC_FAILED(ISTREAM,ITEMP)3 	      STREAM(ISTREAM).REQUEST=SMBMSG$K_STOP_STREAM  C E C	Prevent additional calls in mainline code by pretending I/O is busy  C $ 	      STREAM(ISTREAM).IOSB(1)=ITEMP	 	   ENDIF  	ENDIF C & C	Make sure the mailbox channel exists C ' 	IF(STREAM(ISTREAM).MBX_CHAN.NE.-1)THEN  C 7 C	Write the item code into a character string in binary  C . 	   CALL LIB$SCOPY_R_DX(%REF(4),ITEMCODE,TEMP) C ' C	Post the new write QIO to the mailbox  C 5 	   CALL WRITE_MBX(ISTREAM,TEMP//MESS,X_ENTRY,.TRUE.)  	ENDIF C  C	Finally, re-enable AST's C  	IF(ASTSET)CALL SETAST(%REF(1))  C  C	Return when done C  	RETURN  	END C D C	LOGGIT -- Routine for logging messages to the log file (and to the C	operator's console)  C   	SUBROUTINE LOGGIT(STRING,THING) 	IMPLICIT NONE 	INCLUDE 'EXECSYMB.INC'  	CHARACTER*(*) STRING  	INTEGER*4 THING 	CHARACTER*9 CDATE 	CHARACTER*8 CTIME 	CHARACTER*8 HEXVAL  	LOGICAL*1 DO_OPER 	CHARACTER*46 FILLER 	CHARACTER*1 SYMB_INDEX " 	COMMON /PRCNAM/ FILLER,SYMB_INDEX 	INTEGER*4 LTHING,SEVERITY,L C ' C	Disable AST's to prevent interference  C  	CALL SETAST(%REF(0))  C 6 C	Determine if this call specified the status argument C  	LTHING=%LOC(THING)  C * C	Assume the operator will not be notified C  	DO_OPER=.FALSE. C < C	If the status field was specified, and the status wasn't a; C	success code (i.e. low bit was zero), notify the operator  C  	IF(LTHING.NE.0)THEN C : C	If it was a success status, don't log anything anywhere.H C	(NOTE:  for debugging purposes, to get all messages into the log file ? C	and to the operator, comment out the next line.  To just get  @ C	everything into the log file, comment out the next two lines.) C : 	   IF(.NOT.DO_DEBUG.AND.((THING.AND.'FFFF'X).EQ.1))GOTO90 	   DO_OPER=.NOT.DO_DEBUG  	   SEVERITY=(THING.AND.7) 	ELSE  	   SEVERITY=1 	ENDIF C  C	Get the current date and time  C  	CALL DATE(CDATE)  	CALL TIME(CTIME)M CED C	Make sure the message will fit, by truncating it at 228 charactersB C	(This allows 28 characters for the date and time, and the statusB C	value in hexadecimal, for a total maximum of 256 characters per 	 C	record)t C  	L=LEN(STRING) 	IF(L.GT.228)L=228 	HEXVAL='        ' 	IF(LTHING.NE.0)THEN 	   IF(SEVERITY.LE.4)THEN	/ 	      CALL SYS$FAO('!8XL',,HEXVAL,%VAL(THING))e 	   ELSE1 	      CALL SYS$FAO('!UL',,HEXVAL,%VAL(THING/16))e 	      SEVERITY=8-SEVERITY	 	   ENDIFm 	ENDIF C.D C	If notifying the operator, send the message with the status value.3 C	(OPCOM does its own time stamping and formatting)i Co8 	IF(DO_OPER)CALL TELL_OPER(STRING(1:L)//HEXVAL,SEVERITY) CoA C	Open the log file for append.  If it fails to open, go create aw@ C	new version, and return to the next line to write the message. C ; 	OPEN(UNIT=1,NAME=LOGDIR(1:L_LD)//':EXECSYMB'//SYMB_INDEX//7, 	1 '.LOG',TYPE='OLD',ACCESS='APPEND',ERR=99) C(@ C	If the message is too long for one line, write it in two lines CT 1	IF(L.GT.104)THEN< 	   WRITE(1,2)CDATE,CTIME,STRING(1:104),STRING(105:L),HEXVAL 2	   FORMAT(3(1X,A)/1X,A,A)a Ct/ C	If it fits in one line, write it in one line.F Cd 	ELSEc( 	   WRITE(1,2)CDATE,CTIME,STRING//HEXVAL 	ENDIF Ce0 C	Close the logfile, allowing it to be examined. C2 	CLOSE(UNIT=1) Cn! C	Re-enable AST's now, and returnm C  90	CALL SETAST(%REF(1))9 	RETURNd CgD C	If we couldn't open the log file for append, create a new version,1 C	and go back to the code that writes the messager C = 99	OPEN(UNIT=1,NAME=LOGDIR(1:L_LD)//':EXECSYMB'//SYMB_INDEX// 3 	1 '.LOG',TYPE='NEW',CARRIAGECONTROL='LIST',ERR=90)d 	GOTO1 	END Cg9 C	TELL_OPER -- routine to send message to OPER12 operatori Ci$ 	SUBROUTINE TELL_OPER(MESS,SEVERITY) 	IMPLICIT NONE 	INCLUDE '($OPCDEF)' 	CHARACTER*(*) MESSc 	INTEGER*4 SEVERITYs 	CHARACTER*280 REALMESSr 	CHARACTER*32 FILLER 	CHARACTER*15 PROCESS_NAME$ 	COMMON /PRCNAM/ FILLER,PROCESS_NAME 	BYTE MSGTYPE(0:7). 	DATA MSGTYPE/'W','S','E','I','F','?','?','?'/ 	INTEGER*4 L 	L=LEN(MESS) C_= C	Format the message with a sort-of-standard VMS-like header.oE C	Include the process index, in case multiple copies of this symbiont- C	are running at the same time.: Cc! 	REALMESS(1:1)=CHAR(OPC$_RQ_RQST)e3 	CALL LIB$SCOPY_R_DX(%REF(3),%REF(OPC$M_NM_OPER12),r 	1 %DESCR(REALMESS(2:4)))	; 	CALL LIB$SCOPY_R_DX(%REF(4),%REF(0),%DESCR(REALMESS(5:8)))fC 	REALMESS(9:L+27)='%'//PROCESS_NAME//'-'//CHAR(MSGTYPE(SEVERITY))//u 	1 '-'//MESS(1:L)X 	L=L+27a Cd C	Send it to OPCOM, and return Co  	CALL SYS$SNDOPR(REALMESS(1:L),) 	RETURNw 	END Cs3 C	ITEMEDIT -- routine to edit item value into ASCIId Cc, 	SUBROUTINE ITEMEDIT(EDITBUF,ITEM,LE,L,TYPE) 	IMPLICIT NONE 	CHARACTER*(*) ITEMx 	CHARACTER*256 EDITBUF 	INTEGER*2 L
 	BYTE TYPE 	INTEGER*4 LONG5 	INTEGER*4 TEMP(2) 	INTEGER*4 LE,I,Js Cr, C	(See main program for table of item types) C ) C	Note that type 1 is NOT handled here!!!A Cd 	GOTO(10,20,30,40,50),TYPE	 10	RETURNo> 20	CALL SYS$FAO('%X!8XL',,EDITBUF(1:10),%VAL(LONG(ITEM(1:4)))) 23	LE=10 	GOTO10r 30	TEMP(1)=LONG(ITEM(1:4)) 	TEMP(2)=LONG(ITEM(5:8))4 	CALL SYS$ASCTIM(,%DESCR(EDITBUF(1:23)),%REF(TEMP),) 	LE=23 	GOTO10a= 40	CALL SYS$FAO('!15%U',,EDITBUF(1:15),%VAL(LONG(ITEM(1:4))))t 43	LE=15 	GOTO10V 50	LE=1r 	DO I=1,L/4s! 	   TEMP(1)=LONG(ITEM(I*4-3:I*4))d
 	   DO J=0,31 < 	      IF(BTEST(TEMP(1),J))CALL OUTDEC(EDITBUF,LE,I*32+J-32) 	      IF(LE.GE.253)GOTO59	 	   ENDDOt 	ENDDO
 59	LE=LE-1 	GOTO10  	END CaE C	OUTDEC -- output value in 0:127 range as one, two, or three digits,a C	followed by a comma.H C	The output is placed in a string at a given position, and the position3 C	is advanced by the length of the string inserted.M Ci% 	SUBROUTINE OUTDEC(STRING,IPOS,VALUE)e 	IMPLICIT NONE 	INTEGER*4 IPOS,VALUE  	CHARACTER*(*) STRING  	INTEGER*4 IDIGe C	* C	Determine how many digits it should have C  	IF(VALUE.LT.10)THEN
 	   IDIG=1 	ELSE IF(VALUE.LT.100)THEN
 	   IDIG=2 	ELSEa
 	   IDIG=3 	ENDIF CaC C	Format the value with the required number of digits, and a comma.eA C	(If this results in an error, don't change the position or the d C	contents of the string.) CEE 	CALL SYS$FAO('!#UL,',,STRING(IPOS:IPOS+IDIG),%VAL(IDIG),%VAL(VALUE))o C $ C	Advance the position in the string Ct 	IPOS=IPOS+IDIG+1o Cm C	Return when done C	 9	RETURN 	END CiC C	PARSE_ITEMS -- routine to parse the "ITEMS=list" parameter for a 1A C	stream and fill an ORDER array with the specified item numbers.3C C	The list of item numbers can contain either single decimal values.C C	or ranges.  Numbers are separated by commas.  A range consists ofeD C	two decimal numbers separated by a colon, and implies inclusion ofF C	all of the numbers between the two numbers, including the endpoints,D C	and in the order given.  For example, the list "4,19:21,5,33:30,7"7 C	is the same as the list "4,19,20,21,5,33,32,31,30,7".eB C	This routine may also accept some slightly erroneous item lists,@ C	and try to make sense of them.  In any case, since the resultsE C	will be fed back into the queue parameters, the user will see whiche C	items were actually selected.h Cw% 	SUBROUTINE PARSE_ITEMS(STRING,ORDER)s 	IMPLICIT NONE 	INCLUDE 'SMBDEF.INC'  	CHARACTER*(*) STRINGo# 	BYTE ORDER(SMBMSG$K_MAX_ITEM_CODE)  	INTEGER*4 IPTR,L,I  	INTEGER*2 FROM,THRU,CH,N,IX,K 	LOGICAL*1 EOS CnA C	Initialize:  not at the end of the string, the input pointer is C C	at the start of the string, and the item number counter is at thes: C	first position in ORDER.  Also, get the string's length. CT 	EOS=.FALSE. 	IPTR=1b 	K=1 	L=LEN(STRING) C	F C	State 1:  looking for the first number in a pair, or a single numberH C	Initialize range values both to zero (which isn't a valid item number) Cs 1	FROM=0 	THRU=0e CrE C	If at the end of the string, set the flag, consider the last number - C	as a single number, and go add it to ORDER.  Cm 10	IF(IPTR.GT.L)THEN 	   EOS=.TRUE.
 	   THRU=FROMe
 	   GOTO30 	ENDIF Cs; C	Otherwise, get the next character and advance the pointerl C  	CH=ICHAR(STRING(IPTR:IPTR)) 	IPTR=IPTR+1 C=? C	If it's a digit, add it into the beginning-of-range value and + C	loop for another character in this state.  CL. 	IF(CH.GE.ICHAR('0').AND.CH.LE.ICHAR('9'))THEN 	   FROM=FROM*10+(CH-48)
 	   GOTO10 CVC C	If it's a comma, this was a single number, so go add it to ORDER.B CC 	ELSE IF(CH.EQ.ICHAR(','))THEN
 	   THRU=FROMr
 	   GOTO30 CRF C	If it's a colon, this is a range, so drop through to state 2 to get F C	the end-of-range number.  Otherwise, we've hit an invalid character,C C	which probably means that the last comma followed the last numberIE C	in the list.  If we picked up a number after the last comma, add itlE C	to ORDER, but in any case assume we've reached the end of the list.D CW 	ELSE IF(CH.NE.ICHAR(':'))THEN 	   IF(FROM.EQ.0)GOTO90L 	   EOS=.TRUE.
 	   THRU=FROMt
 	   GOTO30 	ENDIF Cn/ C	State 2:  looking for the end-of-range value.wE C	First, check to make sure we haven't reached the end of the string.EE C	If we have, go add the final range to the list.  If no end-of-range/F C	value was given, recover from the error by adding the start-of-range C	as a single number.a Cb 20	IF(IPTR.GT.L)THEN 	   EOS=.TRUE. 	   IF(THRU.EQ.0)THRU=FROM
 	   GOTO30 	ENDIF C4@ C	Otherwise, pick up the next character and advance the pointer. CS 	CH=ICHAR(STRING(IPTR:IPTR)) 	IPTR=IPTR+1 CLA C	If it's a digit, add it into the end-of-range value and repeat.o Ce. 	IF(CH.GE.ICHAR('0').AND.CH.LE.ICHAR('9'))THEN 	   THRU=THRU*10+(CH-48)
 	   GOTO20 Ca: C	If it's a comma, fall through to add the range to ORDER.A C	Otherwise, decide we're at the end of the string, and then fall  C	through anyway.R CR 	ELSE IF(CH.NE.ICHAR(','))THEN 	   EOS=.TRUE. 	ENDIF CR9 C	Come here to add a number or range of numbers to ORDER.)> C	First, make the numbers valid by range-checking them against C	the valid item codes.T CT 30	IF(FROM.LT.1)FROM=1@ 	IF(FROM.GE.SMBMSG$K_MAX_ITEM_CODE)FROM=SMBMSG$K_MAX_ITEM_CODE-1 	IF(THRU.LT.1)THRU=1@ 	IF(THRU.GE.SMBMSG$K_MAX_ITEM_CODE)THRU=SMBMSG$K_MAX_ITEM_CODE-1 Ce7 C	Next, determine which way the range goes, up or down., Ce 	IF(FROM.GT.THRU)THENe	 	   IX=-1A 	   N=FROM-THRU+1  	ELSEn 	   IX=1 	   N=THRU-FROM+1T 	ENDIF Cg< C	If too many items were specified, truncate the extra ones. C	& 	IF(K+N.GT.SMBMSG$K_MAX_ITEM_CODE)THEN/ 	   THRU=THRU-(IX*(K+N-SMBMSG$K_MAX_ITEM_CODE))d 	ENDIF Cs C	Fill in the range of values. Cr 	DO I=FROM,THRU,IX 	   ORDER(K)=I	 	   K=K+1	 	ENDDO CXA C	If more room is left in the ORDER array, and we haven't reachedc( C	the end of the list, go back for more. C 6 	IF((K.LT.SMBMSG$K_MAX_ITEM_CODE).AND.(.NOT.EOS))GOTO1 CoA C	When we're finally done, fill the remaining slots in ORDER with5@ C	zeroes.  (The first zero serves as the list terminator, and weB C	never allow the last slot in ORDER to be filled with a real item C	code.) Ct  90	DO I=K,SMBMSG$K_MAX_ITEM_CODE 	   ORDER(I)=0 	ENDDO Cu C	Return when done C	 	RETURN. 	END C1F C	EDIT_NJRM -- routine to format item list into new JOB_RESET_MODULES  C	value  CI# 	SUBROUTINE EDIT_NJRM(ORDER,LINE,L)T 	IMPLICIT NONE 	INCLUDE 'SMBDEF.INC' # 	BYTE ORDER(SMBMSG$K_MAX_ITEM_CODE)E 	CHARACTER*(*) LINE  	INTEGER*2 L 	INTEGER*4 IP,I,K,J,IX,KK' COB C	If there are no items in ORDER, don't put anything into the list C  	IF(ORDER(1).EQ.0)RETURN CNE C	Set up a pointer into the output string, and insert a leading commaDC C	if this isn't the first thing in the string (as it may not be, ifK- C	the "TIME=..." field was already inserted.)R CM 	IP=L+1R 	IF(IP.GT.1)THEN 	   LINE(IP:IP)=','E 	   IP=IP+1  	ENDIF CE$ C	Insert the leading "ITEMS=" string CI 	LINE(IP:IP+5)='ITEMS='G 	IP=IP+6 	I=0 CEH C	Loop:  keep going until we process all of ORDER or we find a zero code CM 1	I=I+1N' 2	IF(I.GT.SMBMSG$K_MAX_ITEM_CODE)GOTO10B 	K=ORDER(I)  	IF(K.EQ.0)GOTO10  CTF C	Put the decimal value of the item number in the string (followed by 
 C	a comma) C2 	CALL OUTDEC(LINE,IP,K)K CAF C	Inner loop:  check subsequent item codes to see if they form a rangeC C	with the present one.  A range consists of two or more item codes F C	where all codes are either +1 apart or -1 apart.  Do the same checks> C	here as well (looking for end-of-array or a zero terminator) CO 	J=I+1 	IX=0 & 	IF(J.GT.SMBMSG$K_MAX_ITEM_CODE)GOTO10 	KK=ORDER(J) 	IF(KK.EQ.0)GOTO10 	IX=KK-K C$D C	If the next value is not +1 or -1 from the present one, there's no! C	range; go back to the main loop_ CE 	IF(ABS(IX).NE.1)GOTO1 CMF C	Got a range started, now find the end.  Same checks for end-of-array' C	and zero terminator are here as well._ CT 3	J=J+1I% 	IF(J.GT.SMBMSG$K_MAX_ITEM_CODE)GOTO4_	 	KK=KK+IXU 	IF(KK.NE.ORDER(J))GOTO4 	IF(KK.NE.0)GOTO3T CSI C	If we found a complete range, insert a colon and the terminating value.E CN 4	LINE(IP-1:IP-1)=':'  	CALL OUTDEC(LINE,IP,KK-IX)G 	I=J CN$ C	Loop back when done with the range CO 	GOTO2 CEF C	When done with everything, back up the pointer to eliminate the last C	comma that was inserted. CU	 10	L=IP-2D 	RETURNE 	END CK: C	PARSEMSG -- routine to parse symbiont message into items CCB C	This routine takes the message received from the job controller,D C	and finds the position and length of each item within the message.B C	This information is stored in the POS and SIZE arrays, which areA C	subsequently used to retrieve item values.  This eliminates the D C	need to call SMB$READ_MESSAGE_ITEM, which copies each item's valueE C	from the message buffer to another buffer.  It allows direct accessP( C	to item values at much lower overhead. C ) 	SUBROUTINE PARSEMSG(MSG,POS,SIZE,MSGLEN)) 	IMPLICIT NONE 	INCLUDE 'EXECSYMB.INC'  	CHARACTER*(*) MSG( 	INTEGER*2 POS(SMBMSG$K_MAX_ITEM_CODE-1)) 	INTEGER*2 SIZE(SMBMSG$K_MAX_ITEM_CODE-1)2 	INTEGER*4 MSGLEN,I,J,L,IPTR 	INTEGER*2 WORDM 	CHARACTER*16 DBGTEMPS 	INTEGER*4 ISIZE,ICODE 	CHARACTER*46 FILLER 	CHARACTER*1 SYMB_INDEXT" 	COMMON /PRCNAM/ FILLER,SYMB_INDEX C/? C	Initialize the position and size values for all items to zeroL C   	DO I=1,SMBMSG$K_MAX_ITEM_CODE-1 	   POS(I)=0
 	   SIZE(I)=0  	ENDDO CM+ C	Point to the byte past the request headerE CN@ C	For VMS V5.4/V5.5 compatibility, next line replaced in V3.3.1: C/! C>	IPTR=SMBMSG$S_REQUEST_HEADER+1I 	IF(VMSV55)THENIC 	   IPTR=13	! Starting with VMS V5.5, SMBMSG$S_REQUEST_HEADER is 12  	ELSE = 	   IPTR=5	! Prior to VMS V5.5, SMBMSG$S_REQUEST_HEADER was 4M 	ENDIF0 C>	Previous lines replaced preceding single line CID C	Loop:  get the size and item code for the next item in the message C_D 1	ISIZE=WORD(MSG(IPTR+SMBMSG$W_ITEM_SIZE:IPTR+SMBMSG$W_ITEM_SIZE+1))C 	ICODE=WORD(MSG(IPTR+SMBMSG$W_ITEM_CODE:IPTR+SMBMSG$W_ITEM_CODE+1))G CJE C	If the item code is zero, it's the message terminator, so calculate B C	the actual length of the message (for use in copying the messageD C	to a stream's SCB, to avoid copying blank-padding at the end), and	 C	return.S C_ 	IF(ICODE.EQ.0)THEN  	   MSGLEN=IPTR-1K 	   IF(DO_DEBUG)THEN2 	      CALL LOGGIT('Message from job controller',)A 	      OPEN(UNIT=1,NAME=LOGDIR(1:L_LD)//':EXECSYMB'//SYMB_INDEX//M4 	1      '.LOG',TYPE='OLD',ACCESS='APPEND',ERR=10099) 	      WRITE(1,10001)MSGLENT! 10001	      FORMAT('Length: ',I4)_' 	      DO I=0,MSGLEN.AND.'FFFFFFF0'X,16K 	         L=MIN(16,MSGLEN-I)A 	         CALL SYS$FAO('!AF',,DBGTEMP,%VAL(L),%REF(MSG(I+1:I+1)))_E 	         WRITE(1,10002)(ICHAR(MSG(I+J:I+J)),J=L,1,-1),I,DBGTEMP(1:L) : 10002	         FORMAT(T<49-L*3>,<L>(Z2.2,1X),1X,Z4.4,2X,A) 	      ENDDO 	      WRITE(1,10003)R& 10003	      FORMAT('Item #,pos,size:')( 	      DO I=0,SMBMSG$K_MAX_ITEM_CODE-1,5- 	         L=MIN(5,SMBMSG$K_MAX_ITEM_CODE-I-1)U4 	         WRITE(1,10004)(J,POS(J),SIZE(J),J=I+1,I+L)- 10004	         FORMAT(5(2X,I3,',',I4,',',I4))R 	      ENDDO 	      CLOSE(UNIT=1)	 	   ENDIFO 10099	   RETURNO 	ENDIF C 4 C	Advance the pointer by the size of the item header CP 	IPTR=IPTR+SMBMSG$S_ITEM_HEADERD C I C	Store the pointer in the item's POS slot, and the size in the SIZE slotT; C	(If somehow the item code is out of range, store nothing)_ CU7 	IF(ICODE.GT.0.AND.ICODE.LT.SMBMSG$K_MAX_ITEM_CODE)THENS 	   POS(ICODE)=IPTRS 	   SIZE(ICODE)=ISIZEP 	ENDIF CP1 C	Advance the pointer by the item size, and loop.M CR 	IPTR=IPTR+ISIZE 	GOTO1 	END CLJ C	LONG -- function to return the longword equivalent of a four-byte string CD  	INTEGER*4 FUNCTION LONG(STRING) 	IMPLICIT NONE 	CHARACTER*(*) STRINGS 	CHARACTER*4 CTEMP 	BYTE BTEMP(4) 	INTEGER*4 LTEMP( 	EQUIVALENCE (CTEMP,BTEMP),(BTEMP,LTEMP) 	CTEMP=STRING(1:4) 	LONG=LTEMP  	RETURNN 	END C_E C	WORD -- function to return the word equivalent of a two-byte string  CI  	INTEGER*2 FUNCTION WORD(STRING) 	IMPLICIT NONE 	CHARACTER*(*) STRINGA 	CHARACTER*2 CTEMP 	BYTE BTEMP(2) 	INTEGER*2 ITEMP( 	EQUIVALENCE (CTEMP,BTEMP),(BTEMP,ITEMP) 	CTEMP=STRING(1:2) 	WORD=ITEMPL 	RETURN$ 	END CEE C	BYTE -- function to return the byte equivalent of a one-byte string(F C	(Yes, I know that ICHAR does something similar, but this one returns! C	a BYTE result, not a longword.)M CK 	BYTE FUNCTION BYTE(STRING)I 	IMPLICIT NONE 	CHARACTER*(*) STRING' 	BYTE=ICHAR(STRING(1:1)) 	RETURNE 	END C1D C	DEBUG_MODE_COMMAND -- routine to process debugging commands passed) C	through the status mailbox (STAT_W_MBX)I CL' 	SUBROUTINE DEBUG_MODE_COMMAND(CMDLINE)I 	IMPLICIT NONE 	INCLUDE 'EXECSYMB.INC'  	CHARACTER*(*) CMDLINE 	CHARACTER*4 CMD 	CHARACTER*1280 LINE 	INTEGER*2 WORDN
 	BYTE BYTE 	CHARACTER*46 FILLER 	CHARACTER*1 SYMB_INDEX " 	COMMON /PRCNAM/ FILLER,SYMB_INDEX  	INTEGER*4 I,L,J,K,MINSTR,MAXSTR CB C	Symbiont item definitionsM CE/ 	CHARACTER*21 SMBITEM(SMBMSG$K_MAX_ITEM_CODE-1)G* 	BYTE SMBITEMLEN(SMBMSG$K_MAX_ITEM_CODE-1)+ 	BYTE SMBITEMTYPE(SMBMSG$K_MAX_ITEM_CODE-1)E4 	COMMON /SMBITEMINFO/ SMBITEM,SMBITEMLEN,SMBITEMTYPE CR C	Start of codeM CE, C	At present, these commands are recognized: CT. C		DUMP -- dump all stream statuses to logfile, C		EXIT -- exit (after stopping all streams) C		QUIT -- exit immediatelyI C		DBG0 -- turn off debug mode C		DBG1 -- turn on debug mode   C		NOOP -- do absolutely nothing CL 	CMD=CMDLINE(1:4)' 	IF(CMD.EQ.'EXIT')THEN C$( C	Try to tell all streams to exit first! CM 	   DO I=0,MAXUSED3 	      IF(BTEST(STREAM(I).FLAGS,FLG_V_DYNAMIC).AND.R6 	1      BTEST(STREAM(I).FLAGS,FLG_V_NO_PROCESSOR))THEN% 	         CALL FAKE_DYNAMIC_EXIT(I,1)K 	      ELSEO 	         CALL SEND_EXIT_MSG(I)R 	      ENDIF- 	      STREAM(I).REQUEST=SMBMSG$K_STOP_STREAMH	 	   ENDDO1 	ELSE IF(CMD.EQ.'QUIT')THENK 	   CALL EXIT_PROCESS('29'X) 	ELSE IF(CMD.EQ.'DBG0')THEN' 	   DO_DEBUG=.FALSE. 	ELSE IF(CMD.EQ.'DBG1')THENS 	   DO_DEBUG=.TRUE.M 	ELSE IF(CMD.EQ.'NOOP')THENI7 	   IF(LEN(CMDLINE).GT.4)CALL LOGGIT('NOOP message: '//P 	1   CMDLINE(5:LEN(CMDLINE)),)0 	ELSE IF(CMD.EQ.'DUMP'.OR.CMD(1:3).EQ.'DMP')THEN 	   IF(CMD.EQ.'DUMP')THEN_ 	      MINSTR=0T 	      MAXSTR=MAXUSED_ 	   ELSE  	      MINSTR=ICHAR(CMD(4:4))-55& 	      IF(MINSTR.LT.10)MINSTR=MINSTR+7 	      MAXSTR=MINSTR	 	   ENDIFT' 	   CALL LOGGIT('Status dump follows',)U> 	   OPEN(UNIT=1,NAME=LOGDIR(1:L_LD)//':EXECSYMB'//SYMB_INDEX//. 	1   '.LOG',TYPE='OLD',ACCESS='APPEND',ERR=10)
 	   GOTO11@ 10	   OPEN(UNIT=1,NAME=LOGDIR(1:L_LD)//':EXECSYMB'//SYMB_INDEX//5 	1   '.LOG',TYPE='NEW',CARRIAGECONTROL='LIST',ERR=90)I( 11	   WRITE(1,1200)MAXUSED,MINSTR,MAXSTRG 1200	   FORMAT('Max stream number used:',I11,'; dumping ',I2,' to ',I2)4 	   DO I=MINSTR,MAXSTR 	      WRITE(1,12,ERR=1201)I& 12	      FORMAT(/'Stream number ',I2/)1 1201	      CALL REQ_ASC(STREAM(I).REQUEST,LINE,L)lE 	      WRITE(1,1301,ERR=1202)STREAM(I).PID,LINE(1:L),STREAM(I).INDEX,  	1      STREAM(I).ITEMNOA 1301	      FORMAT('pid = ',Z8.8,'  request = ',A,'  index = ',I6,H 	1      '  itemno = ',I6)DC 1202	      WRITE(1,1302,ERR=1203)STREAM(I).MBX_CHAN,STREAM(I).IOSB,M 	1      STREAM(I).STATUS? 1302	      FORMAT('mbx_chan = ',Z4.4,'  iosb = ',Z8.8,'/',Z8.8,  	1      '  status = ',Z8.8)Q: 1203	      CALL SYS$ASCTIM(L,LINE,STREAM(I).REQUEUE_TIME,)7 	      WRITE(1,1303,ERR=12032)STREAM(I).ENTRY,LINE(1:L) 7 1303	      FORMAT('entry = ',I12,'  requeue_time = ',A)(; 12032	      CALL SYS$ASCTIM(L,LINE,STREAM(I).DYNAMIC_TIME,)E> 	      WRITE(1,13032,ERR=1204)LINE(1:L),BTEST(STREAM(I).FLAGS,A 	1      FLG_V_DYNAMIC),BTEST(STREAM(I).FLAGS,FLG_V_NO_PROCESSOR),A, 	2      BTEST(STREAM(I).FLAGS,FLG_V_EXITING)9 13032	      FORMAT('dynamic_time = ',A,'  dynamic = ',L1,D1 	1      '  no_processor = ',L1,'  exiting = ',L1)'; 1204	      WRITE(1,1304,ERR=1205)STREAM(I).DEVICE_NAME_LEN,I4 	1      STREAM(I).COM_FILE_LEN,STREAM(I).OURNAME_LENG 1304	      FORMAT('string lengths:  device_name = ',I6,'  com_file = ',/ 	1      I6,'  ourname = ',I6)U8 1205	      WRITE(1,1305,ERR=1206)STREAM(I).SPOOLDIR_LEN,6 	1      STREAM(I).FILESPEC_LEN,STREAM(I).QUEUENAME_LENG 1305	      FORMAT('spooldir = ',I6,'  filespec = ',I6,'  queuename = ',E 	1      I6)G. 1206	      WRITE(1,1306,ERR=1207)STREAM(I).FIDH 1306	      FORMAT('fileid = (',I6,',',I6,',',I6,')'/'pos, size, order:')- 1207	      DO J=0,SMBMSG$K_MAX_ITEM_CODE-1,14O, 	         L=MIN(14,SMBMSG$K_MAX_ITEM_CODE-J)6 	         WRITE(1,1307,ERR=1208)'n',(J+K,K=1,L),'pos',B 	1         (STREAM(I).POS(J+K),K=1,L),'size',(STREAM(I).SIZE(J+K),6 	2         K=1,L),'order',(STREAM(I).ORDER(J+K),K=1,L) 1307	         FORMAT(A5,<L>I5)$ 1208	         WRITE(1,1308,ERR=1209) 1308	         FORMAT(A)E 1209	         CONTINUE 	      ENDDO4 	      WRITE(1,1308,ERR=1210)'valid non-null items:'* 1210	      DO J=1,SMBMSG$K_MAX_ITEM_CODE-1B 	         IF(STREAM(I).POS(J).GT.0.AND.STREAM(I).SIZE(J).GT.0)THEN( 	            IF(SMBITEMTYPE(J).EQ.1)THEN# 	               L=STREAM(I).SIZE(J)E! 	               IF(L.GT.1024)THEN $ 	                  WRITE(1,12101)J,LH 12101	                  FORMAT('Item number ',I2,' has bad length ',I11) 	                  L=7& 	                  LINE(1:7)='<error>' 	               ELSE@ 	                  LINE(1:L)=STREAM(I).MESSAGE(STREAM(I).POS(J):) 	1                  STREAM(I).POS(J)+L-1)_ 	               ENDIF  	            ELSELF 	               CALL ITEMEDIT(LINE,STREAM(I).MESSAGE(STREAM(I).POS(J):9 	1               STREAM(I).POS(J)+STREAM(I).SIZE(J)-1),L,_2 	2               STREAM(I).SIZE(J),SMBITEMTYPE(J)) 	            ENDIFD 	            LINE(1:L+SMBITEMLEN(J)+3)=SMBITEM(J)(1:SMBITEMLEN(J))// 	1            ' = '//LINE(1:L)  	            L=L+SMBITEMLEN(J)+3 	            K=0$ 12105	            IF(L-K.LE.132)THEN1 	               WRITE(1,1308,ERR=1211)LINE(K+1:L)T 	            ELSET5 	               WRITE(1,1308,ERR=1211)LINE(K+1:K+132)U 	               K=K+132  	               GOTO12105_ 	            ENDIF 1211	            CONTINUEG 	         ENDIFE 	      ENDDO2 	      WRITE(1,1308,ERR=1212)'other stream flags:'E 1212	      WRITE(1,1309,ERR=1213)BTEST(STREAM(I).FLAGS,FLG_V_BINARY), F 	1      BTEST(STREAM(I).FLAGS,FLG_V_DO_REQUEUE),BTEST(STREAM(I).FLAGS,? 	2      FLG_V_ENTERED),BTEST(STREAM(I).FLAGS,FLG_V_PRINTQUEUE),S@ 	3      BTEST(STREAM(I).FLAGS,FLG_V_NULL),BTEST(STREAM(I).FLAGS, 	4      FLG_V_ABORT)H 1309	      FORMAT('binary = ',L1,'  do_requeue = ',L1,'  entered = ',L1,< 	1      '  printqueue = ',L1,'  null = ',L1,'  abort = ',L1)H 1213	      WRITE(1,1310,ERR=1214)BTEST(STREAM(I).FLAGS,FLG_V_CHECKPOINT)D 	1      ,BTEST(STREAM(I).FLAGS,FLG_V_COPYALL),BTEST(STREAM(I).FLAGS,@ 	2      FLG_V_COPYFIRST),BTEST(STREAM(I).FLAGS,FLG_V_NEVERUSED),) 	3      BTEST(STREAM(I).FLAGS,FLG_V_FLAG) H 1310	      FORMAT('checkpoint = ',L1,'  copyall = ',L1,'  copyfirst = ',. 	1      L1,'  neverused = ',L1,'  flag = ',L1)H 1214	      WRITE(1,13101,ERR=1215)BTEST(STREAM(I).FLAGS,FLG_V_FLAGSENT),3 	1      BTEST(STREAM(I).FLAGS,FLG_V_RETRY_INHIBIT),mC 	2      BTEST(STREAM(I).FLAGS,FLG_V_INITING),BTEST(STREAM(I).FLAGS,E 	3      FLG_V_INITREQ)< 13101	      FORMAT('flagsent = ',L1,'  retry_inhibit = ',L1,, 	1      '  initing = ',L1,'  initreq = ',L1)C 1215	      CALL WRITE_DEBUG('device_name = ',STREAM(I).DEVICE_NAME,C" 	1      STREAM(I).DEVICE_NAME_LEN)9 	      CALL WRITE_DEBUG('filespec = ',STREAM(I).FILESPEC,O 	1      STREAM(I).FILESPEC_LEN)S9 	      CALL WRITE_DEBUG('com_file = ',STREAM(I).COM_FILE,, 	1      STREAM(I).COM_FILE_LEN) 7 	      CALL WRITE_DEBUG('ourname = ',STREAM(I).OURNAME,  	1      STREAM(I).OURNAME_LEN)9 	      CALL WRITE_DEBUG('spooldir = ',STREAM(I).SPOOLDIR,. 	1      STREAM(I).SPOOLDIR_LEN)E; 	      CALL WRITE_DEBUG('queuename = ',STREAM(I).QUEUENAME,e  	1      STREAM(I).QUEUENAME_LEN); 	      WRITE(1,1311,ERR=1221)BYTE(STREAM(I).FILEINFO(1:1)), ! 	1      STREAM(I).FILEINFO(2:16),h3 	1      (WORD(STREAM(I).FILEINFO(J:J+1)),J=17,27,2)s3 1311	      FORMAT('fileinfo = ',I2,' "',A,'" ',6I7)r= 	      WRITE(1,1312,ERR=1221)(STREAM(I).QUOTALIST(J).PQLTYPE,g+ 	1      STREAM(I).QUOTALIST(J).VALUE,J=1,4)iB 1312	      FORMAT('quota list =',4(/'pqltype ',z2.2,' value ',i6)) 1221	      CONTINUEP	 	   ENDDO)H 	   WRITE(1,13131,ERR=13139)EXIT_MBX_UNIT,EXIT_MBX_CHAN,STAT_W_MBX_CHAN,E 	1   STATIOSBW,STATIOSB(2),DO_HIBER,DO_DEBUG,VMSV5,DO_WAKE,BASE_PRIO,EC 	2   EXITBUF,STATBUF(1:90),STATBUF(91:180),STATBUF(181:268),LOGDIR,  	3   L_LD,L_SB,MAXUSEDC 13131	   FORMAT(/'General status information:'/'exit mbx unit=',i5/(; 	1   'exit mbx channel=',z4/'status-write mbx channel=',z4/rF 	2   'status iosb=',z4,1x,i6,1x,z8/'flags: do_hiber=',l1,' do_debug=',A 	3   l1,' vmsv5=',l1,' do_wake=',l1/'base prio=',i2/'exitbuf=',a/L3 	4   'statbuf(1:90)=   ',a,/'statbuf(911:180)= ',a/ > 	5   'statbuf(181:268)=',a/'logdir=',a/'length of logdir=',i3/7 	6   'length of statbuf=',i3/'maximum used stream=',i2)) 13139	   CLOSE(UNIT=1)( 	   CALL LOGGIT('Status dump complete',) 	ENDIF	 90	RETURNT 	END CS% 	SUBROUTINE WRITE_DEBUG(STR1,STR2,L2)G 	IMPLICIT NONE 	CHARACTER*(*) STR1,STR2 	INTEGER*2 L1,L2 	INTEGER*4 L
 	L1=LEN(STR1)V 	L=L1+L2 	IF(L.GT.132)THENE. 	   WRITE(1,1,ERR=9)STR1(1:L1)//STR2(1:132-L1) 1	   FORMAT(A) 	   IF(L.GT.264)THEN* 	      WRITE(1,1,ERR=9)STR2(133-L1:264-L1)& 	      WRITE(1,1,ERR=9)STR2(265-L1:L2) 	   ELSE& 	      WRITE(1,1,ERR=9)STR2(133-L1:L2)	 	   ENDIF. 	ELSEs* 	   WRITE(1,1,ERR=9)STR1(1:L1)//STR2(1:L2) 	ENDIF 9	RETURN 	END CP 	SUBROUTINE REQ_ASC(REQ,BUF,L) 	IMPLICIT NONE 	INTEGER*4 REQ,L 	CHARACTER*(*) BUF 	CHARACTER*14 REQS(1:11) 	INTEGER*2 LENS(1:11)XD 	DATA REQS/'PAUSE_TASK','RESET_STREAM','RESUME_TASK','START_STREAM',: 	1 'START_TASK','STOP_STREAM','STOP_TASK','TASK_COMPLETE',0 	2 'TASK_STATUS','START_SYMBIONT','JOB_REQUEST'/+ 	DATA LENS/10,12,11,12,10,11,9,13,11,14,11/L 	IF(REQ.LT.1.OR.REQ.GT.11)THEN 	   BUF(1:10)='??????????'/ 	   CALL SYS$FAO('%X!8XL',,BUF(1:10),%VAL(REQ))R	 2	   L=10T 	ELSEN 	   BUF(1:9)='SMBMSG$K_' 	   L=LENS(REQ)+9 $ 	   BUF(10:L)=REQS(REQ)(1:LENS(REQ)) 	ENDIF 	RETURNf 	END C  	SUBROUTINE FIXTIME(TIMSTR,L)o 	IMPLICIT NONE 	CHARACTER*(*) TIMSTRh 	INTEGER*4 L,IP,LL 	LL=LEN(TIMSTR)h 	L=0 	DO IP=1,LLm! 	   IF(TIMSTR(IP:IP).NE.' ')GOTO1r 	ENDDO 	GOTO9 1	L=L+1e 	TIMSTR(L:L)=TIMSTR(IP:IP)	 2	IP=IP+1  	IF(IP.GT.LL)GOTO3 	IF(IP.LE.LL-2)THENc$ 	   IF(TIMSTR(IP:IP+2).EQ.':00')THEN 	      L=L+1 	      TIMSTR(L:L)=':' 	      IP=IP+2 	      GOTO2E 	   ELSE IF(TIMSTR(IP:IP+1).EQ.' 0'.AND.TIMSTR(IP+2:IP+2).NE.'0')THENt 	      L=L+1 	      TIMSTR(L:L)=' ' 	      IP=IP+1 	      GOTO2	 	   ENDIF  	ENDIF 	IF(IP.LE.LL-1)THENc# 	   IF(TIMSTR(IP:IP+1).EQ.'00')THENr 	      IP=IP+1 	      GOTO2( 	   ELSE IF(TIMSTR(IP:IP+1).EQ.':0')THEN 	      L=L+1 	      TIMSTR(L:L)=':' 	      IP=IP+1 	      GOTO2( 	   ELSE IF(TIMSTR(IP:IP+1).EQ.'  ')THEN 	      GOTO2	 	   ENDIF) 	ENDIF 	L=L+1 	TIMSTR(L:L)=TIMSTR(IP:IP) 	GOTO2 3	IF(TIMSTR(L:L).EQ.'0')L=L-10 	IF(TIMSTR(L:L).EQ.'.')L=L-1 4	IF(TIMSTR(L:L).EQ.':')THEN	 	   L=L-1G	 	   GOTO42 	ENDIF 9	RETURN 	END CE/ 	SUBROUTINE DEFINE_GROUP_LNM(LOGNAME,EQUIVNAME)E 	IMPLICIT NONE  	CHARACTER*(*) LOGNAME,EQUIVNAME 	INCLUDE '($LNMDEF)' 	INCLUDE 'ITEMDEF.INC' 	INTEGER*4 SYS$CRELNM,ISTATa 	RECORD /ITEM/ LNM_LIST(2)" 	LNM_LIST(1).BUFLEN=LEN(EQUIVNAME)! 	LNM_LIST(1).ITEMCODE=LNM$_STRINGE# 	LNM_LIST(1).BUFADR=%LOC(EQUIVNAME)E 	LNM_LIST(1).RETLENADR=0 	LNM_LIST(2).TERMINATOR=0n1 	ISTAT=SYS$CRELNM(,'LNM$GROUP',LOGNAME,,LNM_LIST) 4 	CALL LOGGIT('DEFINE_GROUP_LNM $CRELNM stat=',ISTAT) 	RETURNT 	END C. C	Subroutine to start processor0 C   C	(code taken from MSG_AST code) C 1 	SUBROUTINE START_PROCESSOR(NSTREAM,ISTAT_CREPRC). CA< C	First, make implicit declaration and specify INCLUDE files CS 	IMPLICIT NONE 	INCLUDE 'EXECSYMB.INC'S 	INCLUDE '($PRCDEF)' 	INCLUDE '($SSDEF)'C CT C	Declare arguments( CR 	INTEGER*4 NSTREAM,ISTAT_CREPRC= C$% C	System services called as functionsL C() 	INTEGER*4 SYS$CREPRC,SYS$CREMBX,SYS$WAKEE CS' C	Process creation flags for processors( CB 	INTEGER*4 PRC_FLAGS; 	PARAMETER (PRC_FLAGS=PRC$M_NOUAF+PRC$M_DETACH+PRC$M_HIBER)I CL) C	Process name (need last character only)I CL 	CHARACTER*32 STREAM_CHARS 	CHARACTER*14 FILLER 	CHARACTER*1 SYMB_INDEXS/ 	COMMON /PRCNAM/ STREAM_CHARS,FILLER,SYMB_INDEXo 	CHARACTER*15 PROCESSOR_NAME 	INTEGER*2 LPN 	CHARACTER*20 LNM_SUFFIX 	INTEGER*2 L_LNM_SUF 	INTEGER*4 GET_SYSTEM_LNMo 	CHARACTER*256 OUTDIR  	INTEGER*2 LOD Ce C	Functionse Cd 	INTEGER*4 LIB_SET_USERNAMEf Ct C	Local variablest C          u 	INTEGER*4 ISTAT CA 	CALL SETAST(%REF(0))T 	STREAM(NSTREAM).IOSB(1)=1* 	LPN=MIN(15,STREAM(NSTREAM).OURNAME_LEN+3)9 	PROCESSOR_NAME=SYMB_INDEX//' ='//STREAM(NSTREAM).OURNAMEL6 	PROCESSOR_NAME(2:2)=STREAM_CHARS(NSTREAM+1:NSTREAM+1)- 	IF(STREAM(NSTREAM).USERNAME.NE.'SYSTEM')THEN=4 	   ISTAT=LIB_SET_USERNAME(STREAM(NSTREAM).USERNAME)+ 	   CALL LOGGIT('SET_USERNAME stat=',ISTAT)i 	ENDIF) 	CALL GET_SYSTEM_LNM('EXECSYMB_OUTDIR_'//0E 	1 STREAM(NSTREAM).OURNAME(1:STREAM(NSTREAM).OURNAME_LEN),OUTDIR,LOD)r 	IF(LOD.EQ.0)THENA 	   LOD=L_LD+1% 	   OUTDIR(1:LOD)=LOGDIR(1:L_LD)//':'t 	ENDIF. 1	ISTAT_CREPRC=SYS$CREPRC(STREAM(NSTREAM).PID, 	1 'SYS$SYSTEM:LOGINOUT.EXE',e< 	1 STREAM(NSTREAM).COM_FILE(1:STREAM(NSTREAM).COM_FILE_LEN), 	1 OUTDIR(1:LOD)//B 	1 STREAM(NSTREAM).OURNAME(1:STREAM(NSTREAM).OURNAME_LEN)//'.OUT', 	1 OUTDIR(1:LOD)//C 	1 STREAM(NSTREAM).OURNAME(1:STREAM(NSTREAM).OURNAME_LEN)//'.ERR',,t3 	1 STREAM(NSTREAM).QUOTALIST,PROCESSOR_NAME(1:LPN),SC 	1 %VAL(STREAM(NSTREAM).PRIO),,%VAL(EXIT_MBX_UNIT),%VAL(PRC_FLAGS)) * 	CALL LOGGIT('$CREPRC stat=',ISTAT_CREPRC)D 	CALL SYS$FAO('!8XL',L_LNM_SUF,LNM_SUFFIX,%VAL(STREAM(NSTREAM).PID)) 2	IF(ISTAT_CREPRC)THENA 	   CALL DEFINE_GROUP_LNM('STAT_W_MBX_'//LNM_SUFFIX(1:L_LNM_SUF),T% 	1         'STAT_W_MBX_'//SYMB_INDEX)OA 	   CALL DEFINE_GROUP_LNM('QUEUE_NAME_'//LNM_SUFFIX(1:L_LNM_SUF), < 	1   STREAM(NSTREAM).OURNAME(1:STREAM(NSTREAM).OURNAME_LEN))B 	   CALL DEFINE_GROUP_LNM('DEVICE_NAME_'//LNM_SUFFIX(1:L_LNM_SUF),@ 	1   STREAM(NSTREAM).OURDEVICE(1:STREAM(NSTREAM).OURDEVICE_LEN))7 	   CALL DEFINE_GROUP_LNM('EXECSYMB_PID_'//SYMB_INDEX//i? 	1   STREAM_CHARS(NSTREAM+1:NSTREAM+1),LNM_SUFFIX(1:L_LNM_SUF)),@ 	   ISTAT=SYS$CREMBX(,%REF(STREAM(NSTREAM).MBX_CHAN),%VAL(1024), 	1   %VAL(2048),%VAL('FF00'X),, 1 	2   %DESCR('CMD_MBX_'//LNM_SUFFIX(1:L_LNM_SUF)))G. 	   CALL LOGGIT('CMD_MBX $CREMBX stat=',ISTAT). 	   ISTAT=SYS$WAKE(%REF(STREAM(NSTREAM).PID),). 	   CALL LOGGIT('$WAKE processor stat=',ISTAT)9 	   CALL TELL_OPER('Start proc '//PROCESSOR_NAME(1:LPN)//h 	1   ' for queue '//> 	2   STREAM(NSTREAM).OURNAME(1:STREAM(NSTREAM).OURNAME_LEN),3)) 	ELSE IF(ISTAT_CREPRC.EQ.SS$_DUPLNAM)THEN & 	   IF(PROCESSOR_NAME(3:3).EQ.'=')THEN 	      PROCESSOR_NAME(3:3)='a' 	      GOTO1+ 	   ELSE IF(PROCESSOR_NAME(3:3).EQ.'z')THEN A 	      CALL LOGGIT('Duplicate procname '//PROCESSOR_NAME(1:LPN),)e 	   ELSE= 	      PROCESSOR_NAME(3:3)=CHAR(ICHAR(PROCESSOR_NAME(3:3))+1)I 	      GOTO1	 	   ENDIFA 	ENDIF- 	IF(STREAM(NSTREAM).USERNAME.NE.'SYSTEM')THEN6* 	   ISTAT=LIB_SET_USERNAME('SYSTEM      ')2 	   CALL LOGGIT('SET_USERNAME SYSTEM stat=',ISTAT) 	ENDIF' 	IF(ISTAT_CREPRC)STREAM(NSTREAM).FLAGS=E4 	1 STREAM(NSTREAM).FLAGS.AND..NOT.FLG_M_NO_PROCESSOR 	CALL SETAST(%REF(1))  	RETURNE 	END CRE C	Subroutine to set timer request for stream, if processor is dynamicN CC 	SUBROUTINE SET_TIMER(NSTREAM) CE< C	First, make implicit declaration and specify INCLUDE files CT 	IMPLICIT NONE 	INCLUDE 'EXECSYMB.INC'  C  C	Declare argumentsD C  	INTEGER*4 NSTREAM C)& C	Declare routines called as functions CE 	INTEGER*4 SYS$SETIMR( CI C	Timer AST routinee Co 	EXTERNAL DYN_TIMER_AST, Cd C	Local variablesi C" 	INTEGER*4 ISTAT Cw 	CALL SETAST(%REF(0))s3 	IF(BTEST(STREAM(NSTREAM).FLAGS,FLG_V_DYNAMIC))THENLA 	   ISTAT=SYS$SETIMR(,STREAM(NSTREAM).DYNAMIC_TIME,DYN_TIMER_AST,i 	1   %VAL(NSTREAM+1)) & 	   CALL LOGGIT('$SETIMR stat=',ISTAT) 	ENDIF 	CALL SETAST(%REF(1))0 	RETURN  	END CM% C	Dynamic processor timer AST routineH C  	SUBROUTINE DYN_TIMER_AST(ARG) C < C	First, make implicit declaration and specify INCLUDE files Ci 	IMPLICIT NONE 	INCLUDE 'EXECSYMB.INC'  C  C	Declare argumentsE CF	 	BYTE ARGd 	INTEGER*4 NSTREAM C  	NSTREAM=%LOC(ARG)-1/ 	IF(NSTREAM.LT.0.OR.NSTREAM.GE.MAX_STREAMS)THENG1 	   CALL LOGGIT('Bad stream # in DYN_TIMER_AST',)R= 	ELSE IF(.NOT.BTEST(STREAM(NSTREAM).FLAGS,FLG_V_DYNAMIC))THEN ? 	   CALL LOGGIT('DYN_TIMER_AST on static stream ',NSTREAM*16+6) > 	ELSE IF(STREAM(NSTREAM).REQUEST.EQ.SMBMSG$K_START_STREAM)THEN8 	   CALL LOGGIT('Idle timeout for stream ',NSTREAM*16+7) 	   CALL SEND_EXIT_MSG(NSTREAM)CE 	   STREAM(NSTREAM).FLAGS=STREAM(NSTREAM).FLAGS.OR.FLG_M_NO_PROCESSORI 	ELSE(< 	   CALL LOGGIT('Timeout for non-idle stream ',NSTREAM*16+7) 	ENDIF 	RETURN  	END CM( C	Subroutine to track AST enable/disable C  	SUBROUTINE SETAST(ASTVAL) 	IMPLICIT NONE! 	LOGICAL*1 ASTVAL,LIB$AST_IN_PROGa 	INTEGER*4 AST_DISABLE_LEVEL$ 	COMMON /ASTSTUFF/ AST_DISABLE_LEVEL 	IF(LIB$AST_IN_PROG())RETURN 	IF(AST_DISABLE_LEVEL.LT.0)THENe+ 	   CALL LOGGIT('Bad AST level in SETAST',)( 	   AST_DISABLE_LEVEL=0_ 	ENDIF 	IF(ASTVAL)THEN " 	   IF(AST_DISABLE_LEVEL.EQ.0)THEN+ 	      CALL LOGGIT('Redundant AST enable',)  	   ELSE, 	      AST_DISABLE_LEVEL=AST_DISABLE_LEVEL-19 	      IF(AST_DISABLE_LEVEL.EQ.0)CALL SYS$SETAST(%VAL(1))P! 	   ENDIF                          	ELSET6 	   IF(AST_DISABLE_LEVEL.EQ.0)CALL SYS$SETAST(%VAL(0))) 	   AST_DISABLE_LEVEL=AST_DISABLE_LEVEL+1R 	ENDIF 	RETURNV 	END CE& C	Subroutine to tell processor to exit CV" 	SUBROUTINE SEND_EXIT_MSG(NSTREAM) 	IMPLICIT NONE 	INCLUDE 'EXECSYMB.INC'  	INTEGER*2 NSTREAM  	INTEGER*4 SYS$SETIMR,SYS$DASSGN 	EXTERNAL EXIT_TIMER_AST 	INTEGER*4 ISTAT 	INTEGER*4 EXIT_TIMEOUT(2) 	LOGICAL*1 INITED  	CALL SETAST(%REF(0))I 	IF(.NOT.INITED)THEN 	   INITED=.TRUE.  CL) C	Here's definition of exit timeout valueE CL1 	   CALL SYS$BINTIM('0 00:01:00.00',EXIT_TIMEOUT)T 	ENDIF CG0 C	If it's a dynamic stream, set the EXITING flag CM/ 	IF(BTEST(STREAM(NSTREAM).FLAGS,FLG_V_DYNAMIC)) ? 	1 STREAM(NSTREAM).FLAGS=STREAM(NSTREAM).FLAGS.OR.FLG_M_EXITINGM2 	IF(BTEST(STREAM(NSTREAM).FLAGS,FLG_V_BINARY))THEN* 	   CALL WRITE_MBX_BIN_X(NSTREAM,0,'EXIT') 	ELSE 4 	   CALL WRITE_MBX_ASC_X(NSTREAM,'EXEC_STEP','EXIT') 	ENDIF8 	CALL LOGGIT('Exit request for processor ',NSTREAM*16+7) C-@ C	Since "EXIT" message has been sent, no further messages can be8 C	sent on this mailbox channel, so deassign the channel. Cc' 	IF(STREAM(NSTREAM).MBX_CHAN.NE.-1)THENU4 	   ISTAT=SYS$DASSGN(%VAL(STREAM(NSTREAM).MBX_CHAN))< 	   CALL LOGGIT('$DASSGN exiting processor MBX stat=',ISTAT) 	   STREAM(NSTREAM).MBX_CHAN=-1l 	ENDIF Cl. C	If it's a dynamic stream, set the exit timer C 3 	IF(BTEST(STREAM(NSTREAM).FLAGS,FLG_V_DYNAMIC))THEN C 	   ISTAT=SYS$SETIMR(,EXIT_TIMEOUT,EXIT_TIMER_AST,%VAL(NSTREAM+65))L1 	   CALL LOGGIT('$SETIMR EXIT TIMER stat=',ISTAT)A 	ENDIF 	CALL SETAST(%REF(1))P 	RETURN] 	END C                    ( C	Exit timeout AST routine CA 	SUBROUTINE EXIT_TIMER_AST(ARG)' C/< C	First, make implicit declaration and specify INCLUDE files CI 	IMPLICIT NONE 	INCLUDE 'EXECSYMB.INC'1 CR C	Declare arguments  C 	 	BYTE ARGL 	INTEGER*4 NSTREAM C  C	Local variables_ CO 	INTEGER*4 ISTAT 	CHARACTER*8 PROCPID  	INTEGER*4 SYS$DELPRC,SYS$DELLNM Cm 	NSTREAM=%LOC(ARG)-65i/ 	IF(NSTREAM.LT.0.OR.NSTREAM.GE.MAX_STREAMS)THENT2 	   CALL LOGGIT('Bad stream # in EXIT_TIMER_AST',)8 	ELSE IF(BTEST(STREAM(NSTREAM).FLAGS,FLG_V_EXITING))THEN$ 	   IF(STREAM(NSTREAM).PID.NE.0)THEN> 	      CALL SYS$FAO('!8XL',,PROCPID,%VAL(STREAM(NSTREAM).PID))< 	      CALL LOGGIT('Processor never exited; stopping PID '//- 	1      PROCPID//' for stream ',NSTREAM*16+7)H- 	      ISTAT=SYS$DELPRC(STREAM(NSTREAM).PID,) ) 	      CALL LOGGIT('$DELPRC stat=',ISTAT)M< 	      ISTAT=SYS$DELLNM('LNM$GROUP','QUEUE_NAME_'//PROCPID,)4 	      CALL LOGGIT('$DELLNM QUEUE_NAME stat=',ISTAT)= 	      ISTAT=SYS$DELLNM('LNM$GROUP','DEVICE_NAME_'//PROCPID,)S5 	      CALL LOGGIT('$DELLNM DEVICE_NAME stat=',ISTAT))< 	      ISTAT=SYS$DELLNM('LNM$GROUP','STAT_W_MBX_'//PROCPID,)4 	      CALL LOGGIT('$DELLNM STAT_W_MBX stat=',ISTAT)	 	   ENDIFO C C C	Clear EXITING flag here, in case $DELPRC fails to really kill theHB C	process (e.g. if process is in MWAIT); then, $CREPRC will noticeF C	duplicate process name, and will increment the name for the new one. COF 	   STREAM(NSTREAM).FLAGS=STREAM(NSTREAM).FLAGS.AND..NOT.FLG_M_EXITING 	   CALL WAKEUPI 	ENDIF 	RETURNC 	END C C C	Read a "status" numeric value, i.e. signed decimal or %X followed " C	by hexadecimal, into a longword. C , 	INTEGER*4 FUNCTION READ_STAT_NUMBER(STRING) 	IMPLICIT NONE 	CHARACTER*(*) STRINGc 	INTEGER*4 LENSTR,VALUEt 	LENSTR=LEN(STRING)e 	VALUE=0 	IF(LENSTR.EQ.0)GOTO9p 	IF(LENSTR.GT.2)THEN8 	   IF(STRING(1:3).EQ.'-%X'.OR.STRING(1:3).EQ.'-%x')THEND 	      CALL LIB$CVT_HTB(%VAL(LENSTR-3),%REF(STRING(4:LENSTR)),VALUE) 	      VALUE=-VALUE, 	      GOTO9; 	   ELSE IF(STRING(1:2).EQ.'%X'.OR.STRING(1:2).EQ.'%x')THEN D 	      CALL LIB$CVT_HTB(%VAL(LENSTR-2),%REF(STRING(3:LENSTR)),VALUE) 	      GOTO9	 	   ENDIF	 	ENDIF2 	CALL LIB$CVT_DTB(%VAL(LENSTR),%REF(STRING),VALUE) 9	READ_STAT_NUMBER=VALUE 	RETURNt 	END Cy0 	INTEGER*4 FUNCTION GET_SYSTEM_LNM(LNM,VAL,LVAL) 	IMPLICIT NONE 	INCLUDE '($LNMDEF)' 	INCLUDE 'ITEMDEF.INC' 	CHARACTER*(*) LNM,VAL 	INTEGER*2 LVALT          RECORD /ITEM/ LNMLIST(2)!         INTEGER*4 STAT,SYS$TRNLNMa 	VOLATILE VAL,LVAL 	LNMLIST(1).BUFLEN=LEN(VAL)o  	LNMLIST(1).ITEMCODE=LNM$_STRING 	LNMLIST(1).BUFADR=%LOC(VAL)  	LNMLIST(1).RETLENADR=%LOC(LVAL) 	LNMLIST(2).TERMINATOR=03         STAT=SYS$TRNLNM(,'LNM$SYSTEM',LNM,,LNMLIST)  	IF(STAT)GOTO9 	LVAL=0A 9	GET_SYSTEM_LNM=STAT) 	RETURN  	END CI C	Simple copy-longword routine CO 	SUBROUTINE MOVL(FROM,TO)  	IMPLICIT NONE 	INTEGER*4 FROM,TO 	TO=FROM 	RETURNT 	END C,- C	Cancel rundown routine and exit with statusR CS 	SUBROUTINE EXIT_PROCESS(STAT) 	IMPLICIT NONE 	INTEGER*4 STAT  	EXTERNAL CTL$A_COMMON  	CALL MOVL(%REF(0),CTL$A_COMMON) 	CALL SYS$EXIT(%VAL(STAT)) 	END C : C	*** WARNING *** Kernel-mode code follows *** WARNING *** CAG C	The following routine is called in kernel mode, IPL 0, during processTI C	rundown.  It *must not* use RMS, RTL routines, Fortran I/O, etc. but itI C	can use most system services., CA' 	INTEGER*4 FUNCTION KERNEL_MODE_RUNDOWNb 	IMPLICIT NONE 	INCLUDE 'EXECSYMB.INC'  	INCLUDE '($IODEF)'f 	INCLUDE '($PSLDEF)' 	CHARACTER*1 STREAM_CHARS(0:31)S 	CHARACTER*15 PROCESS_NAME* 	COMMON /PRCNAM/ STREAM_CHARS,PROCESS_NAME 	INTEGER*4 I 	CHARACTER*8 PROCPID 	INTEGER*4 BINEXIT(2)  	DATA BINEXIT/0,'EXIT'/I CTB C	Free the exit-mailbox channel so we don't get notified of queue 5 C	processor exits (this is a "last gasp", after all!)N CC% 	CALL SYS$DASSGN(%VAL(EXIT_MBX_CHAN))S CG/ C	Request that all active queue processors exitN CCI C	(Check that stream's queue processor is active and that mailbox channelN C	is valid)  CT 	DO I=0,MAXUSEDM5 	   IF((.NOT.BTEST(STREAM(I).FLAGS,FLG_V_DYNAMIC).OR..9 	1   .NOT.BTEST(STREAM(I).FLAGS,FLG_V_NO_PROCESSOR)).AND.T" 	2   STREAM(I).MBX_CHAN.NE.-1)THEN2 	      IF(BTEST(STREAM(I).FLAGS,FLG_V_BINARY))THENG 	         CALL SYS$QIO(,%VAL(STREAM(I).MBX_CHAN),%VAL(IO$_WRITEVBLK.OR.f2 	1         IO$M_NOW),,,,%REF(BINEXIT),%VAL(8),,,,) 	      ELSE(G 	         CALL SYS$QIO(,%VAL(STREAM(I).MBX_CHAN),%VAL(IO$_WRITEVBLK.OR.T6 	1         IO$M_NOW),,,,%REF('EXEC_STEP'),%VAL(9),,,,)G 	         CALL SYS$QIO(,%VAL(STREAM(I).MBX_CHAN),%VAL(IO$_WRITEVBLK.OR. 1 	1         IO$M_NOW),,,,%REF('EXIT'),%VAL(4),,,,)p 	      ENDIF8 	      CALL SYS$FAO('!8XL',,PROCPID,%VAL(STREAM(I).PID)): 	      CALL SYS$DELLNM('LNM$GROUP','QUEUE_NAME_'//PROCPID, 	1      %REF(PSL$C_USER)) ; 	      CALL SYS$DELLNM('LNM$GROUP','DEVICE_NAME_'//PROCPID,t 	1      %REF(PSL$C_USER)) : 	      CALL SYS$DELLNM('LNM$GROUP','STAT_W_MBX_'//PROCPID, 	1      %REF(PSL$C_USER))E7 	      CALL SYS$DELLNM('LNM$GROUP','CMD_MBX_'//PROCPID,  	1      %REF(PSL$C_USER))A4 	      CALL SYS$DELLNM('LNM$GROUP','EXECSYMB_PID_'//> 	1      PROCESS_NAME(15:15)//STREAM_CHARS(I),%REF(PSL$C_USER))	 	   ENDIF.B 	   CALL SYS$DELLNM('LNM$GROUP','EXECSYMB_'//PROCESS_NAME(15:15)//& 	1   STREAM_CHARS(I),%REF(PSL$C_USER)) 	ENDDO@ 	CALL SYS$DELLNM('LNM$GROUP','STAT_W_MBX_'//PROCESS_NAME(15:15), 	1 %REF(PSL$C_USER)) 	KERNEL_MODE_RUNDOWN=1 	RETURN) 	END C % 	SUBROUTINE GET_QUEUE_PARAMS(NSTREAM)N 	IMPLICIT NONE 	INCLUDE 'EXECSYMB.INC'i 	INCLUDE 'ITEMDEF.INC' 	INCLUDE '($QUIDEF)' 	INCLUDE '($PQLDEF)' 	INTEGER*4 NSTREAM 	RECORD /ITEM/ QUILIST(6)t$ 	INTEGER*4 WSDEF,WSQUO,WSEXT,QUEPRIO# 	VOLATILE WSDEF,WSQUO,WSEXT,QUEPRIO  	INTEGER*4 STAT,SYS$GETQUIWe 	INTEGER*4 IOSB(2)
 	INTEGER*4 NQn 	LOGICAL*1 INITEDo 	DATA INITED/.FALSE./n 	STREAM(NSTREAM).PRIO=BASE_PRIOw 	NQ=0a 	IF(.NOT.VMSV5)GOTO9 	IF(.NOT.INITED)THEN( 	   QUILIST(1).ITEMCODE=QUI$_SEARCH_NAME 	   QUILIST(1).RETLENADR=0 	   QUILIST(2).BUFLEN=4e& 	   QUILIST(2).ITEMCODE=QUI$_WSDEFAULT! 	   QUILIST(2).BUFADR=%LOC(WSDEF)  	   QUILIST(2).RETLENADR=0 	   QUILIST(3).BUFLEN=4 $ 	   QUILIST(3).ITEMCODE=QUI$_WSQUOTA! 	   QUILIST(3).BUFADR=%LOC(WSQUO)S 	   QUILIST(3).RETLENADR=0 	   QUILIST(4).BUFLEN=4S% 	   QUILIST(4).ITEMCODE=QUI$_WSEXTENT ! 	   QUILIST(4).BUFADR=%LOC(WSEXT)E 	   QUILIST(4).RETLENADR=0 	   QUILIST(5).BUFLEN=4C* 	   QUILIST(5).ITEMCODE=QUI$_BASE_PRIORITY# 	   QUILIST(5).BUFADR=%LOC(QUEPRIO)t 	   QUILIST(5).RETLENADR=0 	   QUILIST(6).TERMINATOR=0  	   INITED=.TRUE.f 	ENDIF. 	QUILIST(1).BUFLEN=STREAM(NSTREAM).OURNAME_LEN0 	QUILIST(1).BUFADR=%LOC(STREAM(NSTREAM).OURNAME)< 	STAT=SYS$GETQUIW(,%VAL(QUI$_DISPLAY_QUEUE),,QUILIST,IOSB,,)# 	IF(.NOT.STAT.OR..NOT.IOSB(1))GOTO9	 	IF(WSDEF.NE.0)THENi 	   NQ=NQ+1f8 	   STREAM(NSTREAM).QUOTALIST(NQ).PQLTYPE=PQL$_WSDEFAULT- 	   STREAM(NSTREAM).QUOTALIST(NQ).VALUE=WSDEF  	ENDIF 	IF(WSQUO.NE.0)THENr 	   NQ=NQ+1e6 	   STREAM(NSTREAM).QUOTALIST(NQ).PQLTYPE=PQL$_WSQUOTA- 	   STREAM(NSTREAM).QUOTALIST(NQ).VALUE=WSQUOS 	ENDIF 	IF(WSEXT.NE.0)THENt 	   NQ=NQ+1 7 	   STREAM(NSTREAM).QUOTALIST(NQ).PQLTYPE=PQL$_WSEXTENTt- 	   STREAM(NSTREAM).QUOTALIST(NQ).VALUE=WSEXT  	ENDIF 	STREAM(NSTREAM).PRIO=QUEPRIOf	 9	NQ=NQ+1r3 	STREAM(NSTREAM).QUOTALIST(NQ).PQLTYPE=PQL$_LISTENDL 	RETURNE 	END