  , #pragma module sys_get_tape_devices "X1-006"   /* int sys_get_tape_devices ()   */  /*  *+   * Version:	X1-006  *%  * Facility:	General system routines.   *C  * Abstract:	Defines a number of logicals in a consistent format to 6  *		enable easy processing of all tapes on the system.  *  * Environment:	User mode.  *  * History:   *#  *	19-Oct-1990, DBS; Version X1-001 ;  * X1-001	Original version.  (Taken from get_tape_devices.) #  *	10-Dec-1990, DBS; Version X1-002 @  * X1-002	Modified to use lib$set_logical to define the logicalsB  *		without the need for privileges.  Also use lib$delete_logical.&  *		Other stuff commented out for now.#  *	05-Apr-1991, DBS; Version X1-003 A  * X1-003	Made into a callable routine and the 002 stuff deleted. #  *	19-Jan-1996, DBS; Version X1-004   * X1-004	Added code for alpha. #  *	20-Apr-2004, DBS; Version X1-005 <  * X1-005	Rewrite in C.  (Taken from SYS_GET_DISK_DEVICES.C)#  *	28-May-2004, DBS; Version X1-006 /  * X1-006	Added code to handle iledef.h on VAX.   *-   */    /*  *++  * Functional Description:E  * 	This routine uses the device scan system service to find all tape E  *	class devices on the system and then create logical names that can H  *	be used to reference them.  An attempt is made to delete any existing<  *	logical names that match the format used by this routine.  *  * Calling Sequence:  *	call sys_get_tape_devices ()   *		-or-#  *	calls	#0, g^sys_get_tape_devices   *  * Formal Argument(s):  *	None   *  * Implicit Inputs:   *	None   *  * Implicit Outputs:D  *	Logical names are in the format TAPE_DEVICE_n where n is a numberD  *	from 1 to the number of tape devices found.  These are defined in"  *	the process logical name table.  *  * Routine Value:   *	None   *  * Side Effects:  *	None   *--  */    #define __NEW_STARLET 1    #include	<lib$routines>  #include	<libdef>    #include	<dcdef> #include	<dvsdef>    #ifdef __VAX #include	"vax_iledef.h"  #else  #include	<iledef>  #endif   #include	<ssdef> #include	<stsdef>    #include	<descrip> #include	<starlet>     int sys_get_tape_devices ()  {    /*B  *	Descriptors of the form mumble_dsc are only to be used as input@  *	to library routines and system services.  The descriptor nameE  *	WITHOUT the _dsc can be used as the address for the return length. ?  *	That descriptor can then be used as input to other routines.   */    	long int	device_count; # 	long int	dvs_context [2] = {0, 0}; & 	long int	dvs_device_class = DC$_TAPE;  	char		dvs_device_name_t [64+1];2 	$DESCRIPTOR	(dvs_device_name, dvs_device_name_t);6 	$DESCRIPTOR	(dvs_device_name_dsc, dvs_device_name_t); 	ILE3		dvs_item_list [2]; $ 	$DESCRIPTOR	(dvs_search_name, "*");1 	$DESCRIPTOR	(logical_format, "TAPE_DEVICE_!UL");  	char		logical_name_t [32+1]; , 	$DESCRIPTOR	(logical_name, logical_name_t);0 	$DESCRIPTOR	(logical_name_dsc, logical_name_t);2 	$DESCRIPTOR	(logical_table, "LNM$PROCESS_TABLE"); 	long int	sstatus;    % 	dvs_item_list[0].ile3$w_length		= 4; / 	dvs_item_list[0].ile3$w_code		= DVS$_DEVCLASS; 6 	dvs_item_list[0].ile3$ps_bufaddr	= &dvs_device_class;* 	dvs_item_list[0].ile3$ps_retlen_addr	= 0;% 	dvs_item_list[1].ile3$w_length		= 0; # 	dvs_item_list[1].ile3$w_code		= 0;    	device_count = 0;
 	sstatus = 1;  	do {  	    device_count++; 	    sys$fao (&logical_format, 			&logical_name,  			&logical_name_dsc,  			device_count); 1 	    sstatus = lib$delete_logical (&logical_name,  						&logical_table); 	} while (sstatus & 1);    	device_count = 0;
 	sstatus = 1;  	do {   	    sstatus = sys$device_scan ( 				&dvs_device_name_dsc,  				&dvs_device_name,  				&dvs_search_name,  				&dvs_item_list,  				&dvs_context); 	    if (sstatus & 1) {  		device_count++;  		sys$fao (&logical_format,  				&logical_name, 				&logical_name_dsc, 				device_count);+ 		sstatus = lib$set_logical (&logical_name,  					&dvs_device_name, 					&logical_table);  	    } 	} while (sstatus & 1);   $ 	return (sstatus | STS$M_INHIB_MSG); } 