* #pragma module find_volume_label "V01.000"L // *************************************************************************L // *                                                                       *L // * Copyright 2005 Hewlett-Packard Development Company, L.P.              *L // *                                                                       *L // * Confidential computer software.  Valid license from HP and/or         *L // * its subsidiaries required for possession, use, or copying.            *L // *                                                                       *L // * Consistent with FAR 12.211 and 12.212, Commercial Computer Software,  *L // * Computer Software Documentation, and Technical Data for Commercial    *L // * Items are licensed to the U.S. Government under vendor's standard     *L // * commercial license.                                                   *L // *                                                                       *L // * Neither HP nor any of its subsidiaries shall be liable for technical  *L // * or editorial errors or omissions contained herein.  The information   *L // * in this document is provided "as is" without warranty of any kind and *L // * is subject to change without notice.  The warranties for HP products  *L // * are set forth in the express limited warranty statements accompanying *L // * such products.  Nothing herein should be construed as constituting an *L // * additional warranty.                                                  *L // *                                                                       *L // *************************************************************************   // // // Abstract: //H //      This module contains the routines necessary to locate an ODS-2/5G //      home block, and to then return the volume label for the device.  //H //      The basic search is documented in ODS.MEM document, and in Kirby0 //      McCoy's VMS File Systems Internals book. // // // Privileges Needed:  //8 //      These routines needs volpro priv and log_io priv //      to get this data.  // // Noted Side Effect:  //4 //      If the device described by the input channel5 //      was not marked valid, it will be marked valid  //      and left that way. // // Compilation Command:  //- //     $ CC FIND_VOLUME_LABEL + SYS$LIB_C/LIB  // // Creation Date:  // //      14-Jul-2005 E //      [Hoff has expurgated the OpenVMS Engineering Author's name as F //      part of inclusion on the Freeware, per request of the author.] // // Modification History  // // //     #include <string.h>  #include <stdlib.h>  #include <stddef.h>      //: // The following includes are from SYS$SHARE:SYS$LIB_C.TLB" // and SYS$SHARE:SYS$STARLET_C.TLB //   #include <dcdef.h> #include <dvidef.h>  #include <efndef.h>  #include <fiddef.h>  #include <hm2def.h>  #include <iledef.h>  #include <iodef.h> #include <iosbdef.h> #include <ssdef.h> #include <ucbdef.h>  #include <starlet.h> #include <lib$routines.h>    // // // typedef unsigned int   Uint ;  typedef unsigned short Ushort ;  typedef unsigned char  Uchar ;   typedef struct _ile3 ITMLIST ; typedef struct _iosb IOSBDEF ;  ! #pragma __member_alignment __save  #pragma __nomember_alignment struct _geom {         Uchar sectors ;          Uchar tracks ;         Ushort cylinders ;         } ; $ #pragma __member_alignment __restore   //& // Forward Externally visable routines //  9 int find_volume_label( int channel, char **volume_name) ; 4 int find_homeblock( int channel, HM2 **homeblock ) ;     // // Forward helper routines //  8 static int valid_home_block( HM2 *homeblock, Uint LBN );: static Ushort checksum( void *buffer, int chksum_offset) ;J static int read_block (int channel, Uint LBN, void *buffer, int bufsize) ;? static int get_delta( int delta_type, struct _geom geometry ) ; M static int get_device_info( int channel, Uint *maxblock, struct _geom *gm ) ;       8 int find_volume_label( int channel, char **volume_name)  // //5 // This routine finds the label of the device via the 6 // homeblocks on the disk.  It presumes the privileges+ // to do the read  logical block operation  7 // (and packack if necessary) to find this information.  //	 // Input:  //% //    channel - channel to the device  //	 // Output  //, //      volume_name pointer to a pointer of 8 //                      characters with the volume name. //; //                      caller is responsible for 'free'ing $ //                      this string. // Calling Sequence: // //      int channel ;  //      char *volume_name ;  //      char volname[20] ; //= //      status = find_volume_label( channel, &volume_name ) ;  //      if (status&1) { @ //              strncpy(volname, volume_name, sizeof(volname)) ;# //              free(volume_name) ; 	 //      }  // //
 // returns // {      char *vln ; 
     int i;     int status = SS$_NORMAL ;      HM2 *homeblock ;       //1     // First find a valid home block.  If that is 1     // found, then get the volume data from that.      //3     status = find_homeblock( channel, &homeblock) ;      if (status & 1) { 
         //7         // Allocate the users string data.  Return that 6         // lable with the trailing spaces set to NULL.
         //:         vln = malloc(sizeof(homeblock->hm2$t_volname)+1) ;1         if (vln == NULL) return SS$_EXPGFLQUOTA ; .         memcpy(vln, homeblock->hm2$t_volname, ;                         sizeof(homeblock->hm2$t_volname)) ;   '         // Set trailing spaces to NULL. 
         //>         for(i=sizeof(homeblock->hm2$t_volname)-1; i>=0; i--) {.             if (vln[i] == ' ') vln[i] = '\0' ;             else break ;	         }      } '     // Free the homeblock we asked for.      free(homeblock) ;      *volume_name = vln ;     return status ;  }   3 int find_homeblock( int channel, HM2 **homeblock )   // //5 // This routine finds the label of the device via the 6 // homeblocks on the disk.  It presumes the privileges* // to do the read  logical block operation7 // (and packack if necessary) to find this information.  //	 // Input:  //% //    channel - channel to the device  //	 // Output  //7 //      homeblock pointer to a pointer of a home block.  //                       //; //                      caller is responsible for 'free'ing  //                      this . // // Calling Sequence: // //      int channel ; ! //      HM2 *homeblock, h_block ;  //8 //      status = find_homeblock( channel, &homeblock ) ; //      if (status&1) { : //              memcpy(&h_block, homeblock, sizeof(HM2)) ;! //              free(homeblock) ; 	 //      }  //
 // returns //   {        int status = SS$_IVCHAN ;  //2 // Define the search types.  Chose the most likely! // order of finding a home block.  //     int geometry_types[3] = { .                 HM2$C_REQ_DELTA_GEOM_INDEPEND,-                 HM2$C_REQ_DELTA_FIXED_CONTIG, /                 HM2$C_REQ_DELTA_GEOM_DEPEND } ;        HM2 hmblk, *hm2 ;      int delta ;      int i, search_sequence ;     Uint current_lbn ;     Uint maxblock ;      struct _geom gm ;        //3     // Get the device information to use as limits.      //9     status = get_device_info (channel, &maxblock, &gm ) ;      if (!(status & 1)) {'         lib$signal(status); return 0 ;       }        //7     // Try each of the search types for the home block.      //     for(i=0;i<3;i++) {3         delta = get_delta(geometry_types[i] , gm) ;          if (delta > 0) {Q             for(search_sequence=0; search_sequence < HM2$C_LIMITED_SEARCH_LENGTH; &                 search_sequence ++ ) {                 //)                 // Get the LBN to search.                  //;                 current_lbn = 1 + (search_sequence*delta) ;                    //H                 // Make sure it is within the addressable address range.                 //4                 if (current_lbn >= maxblock) break ;  R                 status = read_block(channel, current_lbn, &hmblk, sizeof(hmblk)) ;                 if (status&1) { @                     if (valid_home_block(&hmblk, current_lbn)) {                         //D                         // We have a valid home block.  Allocate the;                         // users copy and init that result.                          //C                         if ( (hm2 = malloc(sizeof(HM2))) == NULL) { 9                             lib$signal(SS$_EXPGFLQUOTA) ; &                             return 0 ;                         }   )                         // copy the data.   :                         memcpy(hm2, &hmblk, sizeof(HM2)) ;*                         *homeblock = hm2 ;"                         return 1 ;'                     } // if (valid_home +                 } // if (status                          } // for (search_se          } // if (delta > 0     } // for (i=       return 0 ; }   8 static Ushort checksum( void *buffer, int chksum_offset) //? // This routine calculates a additive checksum of 16 bits words ; // from the zero offset to the byte offset passed into the   // routine.  //
 // Inputs:0 //      buffer - address of a buffer to checksumC //      chksum_offset - byte offset within buffer of where to stop.  // // Outputs:  //      None // // Returns:  //      the check sum value. // {      Ushort chksum = 0 ; (     Ushort *chkbuf = (Ushort *) buffer ;     int i ;     1     for(i=0; i<chksum_offset/sizeof(Ushort); i++)          chksum += chkbuf[i] ;        return chksum ;    }       > static int get_delta( int delta_type, struct _geom geometry )  //2 // This routine will return the value of the delta+ // as part of a search vector for a volume.  //	 // Input:  //= //      delta_type - a value to determine the search pattern. 9 //      geometry   - the value of geometry of the device.  // //
 // Output: // //      None // // Returns:  //# //      -1 if delta_type is invalid  //      the delta  // // {      int delta = -1 ;       switch( delta_type ) {  )         case HM2$C_REQ_DELTA_GEOM_DEPEND:              if (*                 (geometry.sectors != 1) &&*                 (geometry.tracks  != 1) &&)                 (geometry.cylinders != 1)                 )F                 delta = (geometry.tracks + 1) * geometry.sectors + 1 ;  +             else if (geometry.sectors != 1) .                 delta = geometry.sectors + 1 ;  +             else if (geometry.sectors == 1) A                 delta = geometry.tracks + 1 ;                                    else                 delta = 1 ;                break ;   +         case HM2$C_REQ_DELTA_GEOM_INDEPEND: /             delta = HM2$C_GEOM_INDEPEND_DELTA ;              break ;   *         case HM2$C_REQ_DELTA_FIXED_CONTIG:.             delta = HM2$C_FIXED_CONTIG_DELTA ;             break ;              default: return delta ;      }        return delta ;   }       G static int read_block (int channel, Uint LBN, void *buffer, int bufsiz)  //7 // Read a 512 byte block from disk into callers buffer.  // //	 // Input:  //& //    channel - channel to the device.$ //    LBN     - block number to read1 //    buffer  - address of a buffer to read into. $ //    bufsiz  - size of that buffer. // // Outputs:  //
 //    None // // Returns:  // //    $qio status. // {      int status ;     IOSBDEF iosb ;  "     status = sys$qiow( EFN$C_ENF ,%                       channel&0xffff, #                       IO$_READLBLK,                        &iosb,                       0, 0,                        buffer,                        bufsiz,                        LBN,                        0, 0, 0) ;1     if (status & 1) status = iosb.iosb$w_status ;        return status ;    }     L static int get_device_info( int channel, Uint *maxblock, struct _geom *gm )  //. // This routine get the device information for // use as limits on the search.  //	 // Input:  //& //    Channel - channel to the device. // // Outputs:  //. //    maxblock - largest addressable block + 1B //    gm       - struct containg sectors tracks and cylinder info. // // // Implicit Outputs: //G //   If the UCB$V_VALID bit was not set, it will be set by IO$_PACKACK.  // // Returns:  // // {      int status ;     IOSBDEF iosb ;       int sectors = 0;     int tracks = 0;      int cylinders = 0 ;      Uint maxblk = 0 ;      int sts = 0, class = 0 ;       ITMLIST itmlist[] = { 7         { sizeof(sectors), DVI$_SECTORS, &sectors, 0 }, 5         { sizeof(sectors), DVI$_TRACKS, &tracks, 0 }, ;         { sizeof(sectors), DVI$_CYLINDERS, &cylinders, 0 }, 7         { sizeof(maxblk),  DVI$_MAXBLOCK, &maxblk, 0 }, 0         { sizeof(sts),     DVI$_STS, &sts, 0 } ,6         { sizeof(class),   DVI$_DEVCLASS, &class, 0 },         { 0 }          } ;     $     status = sys$getdviw(EFN$C_ENF, '                         channel&0xffff,                          0,                          itmlist,                         &iosb,  "                         0, 0, 0) ;  1     if (status & 1) status = iosb.iosb$w_status ;          if (status & 1) { 4         if (class != DC$_DISK) return SS$_IVDEVNAM ;#         if (!(sts & UCB$M_VALID)) {              //G             // The device needs to be PACKACKed to get the proper data.              //*             status = sys$qiow( EFN$C_ENF ,%                       channel&0xffff, "                       IO$_PACKACK,                       &iosb,                       0, 0,                        0, 0, 0,                        0, 0, 0) ;9             if (status & 1) status = iosb.iosb$w_status ;              if (status & 1) {   0                 status = sys$getdviw(EFN$C_ENF, '                         channel&0xffff,                          0,                          itmlist,                         &iosb,  "                         0, 0, 0) ;=                 if (status & 1) status = iosb.iosb$w_status ; 
             } 	         }      }        *maxblock     = maxblk ;     gm->sectors   = sectors ;      gm->tracks    = tracks ;     gm->cylinders = cylinders ;        return status ;  }     7 static int valid_home_block( HM2 *homeblock, Uint LBN )  //8 // This routine verifies that the given block is a valid // ODS-2/5 home block. //
 // Inputs:1 //      homeblock - Address of a buffer to check. 9 //      LBN       - Value of the LBN the block was found.  // // Outputs:  //      None // // Returns:  //      0 if not a home block ( //      1 if block is a valid home block // // { 	      if ( 0         ((Uint) homeblock->hm2$l_homelbn == LBN)*         && (homeblock->hm2$l_homelbn != 0),         && (homeblock->hm2$l_alhomelbn != 0),         && (homeblock->hm2$l_altidxlbn != 0)
         &&L            (((homeblock->hm2$w_struclev&0xff00) == (HM2$C_LEVEL2&0xff00)) ||J             ((homeblock->hm2$w_struclev&0xff00) == (HM2$C_LEVEL5&0xff00)))*         && (homeblock->hm2$w_cluster != 0)*         && (homeblock->hm2$w_homevbn != 0),         && (homeblock->hm2$l_ibmaplbn != 0) ,         && (homeblock->hm2$w_ibmapsize != 0)5         && (homeblock->hm2$w_resfiles > FID$C_CORIMG)   >         && (!strncmp(homeblock->hm2$t_format, "DECFILE11B  ", 1                 sizeof(homeblock->hm2$t_format))) 2         && ((Ushort) homeblock->hm2$w_checksum1 ==D                 checksum(homeblock, offsetof(HM2, hm2$w_checksum1)))  3         && ((Ushort) homeblock->hm2$w_checksum2 ==  E                 checksum(homeblock, offsetof(HM2, hm2$w_checksum2)))      	         )              return 1 ;               return 0 ;  }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   